/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private int clause = 0;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;
    private LocalField receiverField;

    public boolean isPrimitiveType() {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return false;
        }
        return jSQLType.getCategory() == 2;
    }

    public String getJavaTypeName() {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        switch (jSQLType.getCategory()) {
            case 1: {
                return jSQLType.getJavaClassName();
            }
            case 2: {
                return JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
            }
        }
        return "";
    }

    public void setJavaTypeName(String string) {
        this.jsqlType = new JSQLType(string);
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        switch (jSQLType.getCategory()) {
            case 2: {
                return JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
            }
        }
        return "";
    }

    public void castToPrimitive(boolean bl) {
        this.mustCastToPrimitive = bl;
    }

    public boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    public JSQLType getJSQLType() {
        return this.jsqlType;
    }

    public TypeId mapToTypeID(JSQLType jSQLType) {
        DataTypeDescriptor dataTypeDescriptor = jSQLType.getSQLType();
        if (dataTypeDescriptor == null) {
            return null;
        }
        return dataTypeDescriptor.getTypeId();
    }

    public void setClause(int n) {
    }

    public void markForCallStatement() {
        this.forCallStatement = true;
    }

    public abstract JavaValueNode remapColumnReferencesToExpressions() throws StandardException;

    public abstract boolean categorize(JBitSet var1, boolean var2) throws StandardException;

    abstract JavaValueNode bindExpression(FromList var1, SubqueryList var2, Vector var3) throws StandardException;

    public abstract void preprocess(int var1, FromList var2, SubqueryList var3, PredicateList var4) throws StandardException;

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    protected final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(activationClassBuilder, methodBuilder);
    }

    protected boolean generateReceiver(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    protected abstract void generateExpression(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    protected final boolean generateReceiver(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, JavaValueNode javaValueNode) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if (!this.valueReturnedToSQLDomain()) {
            if (ClassInspector.primitiveType(this.getJavaTypeName())) {
                return false;
            }
        }
        String string = javaValueNode.getJavaTypeName();
        this.receiverField = expressionClassBuilder.newFieldDeclaration(2, string);
        javaValueNode.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.putField(this.receiverField);
        return true;
    }

    protected final void getReceiverExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, JavaValueNode javaValueNode) throws StandardException {
        if (this.receiverField != null) {
            methodBuilder.getField(this.receiverField);
        } else {
            javaValueNode.generateExpression(expressionClassBuilder, methodBuilder);
        }
    }

    protected void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    protected boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    protected void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    protected boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }

    public void checkReliability(ValueNode valueNode) throws StandardException {
        valueNode.checkReliability(4, "42Z00.U");
    }
}

