/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xssf.binary.XSSFBCommentsTable;
import org.apache.poi.xssf.binary.XSSFBSharedStringsTable;
import org.apache.poi.xssf.binary.XSSFBSheetHandler;
import org.apache.poi.xssf.binary.XSSFBStylesTable;
import org.apache.poi.xssf.eventusermodel.XSSFBReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShapeNonVisual;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XSSFBExcelExtractorDecorator
extends XSSFExcelExtractorDecorator {
    public XSSFBExcelExtractorDecorator(ParseContext context, POIXMLTextExtractor extractor, Locale locale) {
        super(context, extractor, locale);
    }

    @Override
    protected void configureExtractor(POIXMLTextExtractor extractor, Locale locale) {
        ((XSSFBEventBasedExcelExtractor)extractor).setLocale(locale);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        this.metadata = metadata;
        this.parseContext = context;
        metadata.set("protected", "false");
        super.getXHTML(handler, metadata, context);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSSFBSharedStringsTable strings;
        XSSFBReader.SheetIterator iter;
        XSSFBStylesTable styles;
        OPCPackage container = this.extractor.getPackage();
        try {
            XSSFBReader xssfReader = new XSSFBReader(container);
            String originalPath = xssfReader.getAbsPathMetadata();
            if (originalPath != null) {
                this.metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, originalPath);
            }
            styles = xssfReader.getXSSFBStylesTable();
            iter = (XSSFBReader.SheetIterator)xssfReader.getSheetsData();
            strings = new XSSFBSharedStringsTable(container);
        }
        catch (InvalidFormatException e) {
            throw new XmlException(e);
        }
        catch (OpenXML4JException oe) {
            throw new XmlException(oe);
        }
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            PackagePart sheetPart = iter.getSheetPart();
            this.addDrawingHyperLinks(sheetPart);
            this.sheetParts.add(sheetPart);
            XSSFExcelExtractorDecorator.SheetTextAsHTML sheetExtractor = new XSSFExcelExtractorDecorator.SheetTextAsHTML(this.config.getIncludeHeadersAndFooters(), xhtml);
            XSSFBCommentsTable comments = iter.getXSSFBSheetComments();
            xhtml.startElement("div");
            xhtml.element("h1", iter.getSheetName());
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            this.processSheet((XSSFSheetXMLHandler.SheetContentsHandler)sheetExtractor, comments, styles, strings, stream);
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            for (String header : sheetExtractor.headers) {
                this.extractHeaderFooter(header, xhtml);
            }
            for (String footer : sheetExtractor.footers) {
                this.extractHeaderFooter(footer, xhtml);
            }
            List<XSSFShape> shapes = iter.getShapes();
            this.processShapes(shapes, xhtml);
            this.extractHyperLinks(sheetPart, xhtml);
            xhtml.endElement("div");
        }
    }

    @Override
    protected void extractHeaderFooter(String hf, XHTMLContentHandler xhtml) throws SAXException {
        if (hf.length() > 0) {
            xhtml.element("p", hf);
        }
    }

    private void extractHyperLinks(PackagePart sheetPart, XHTMLContentHandler xhtml) throws SAXException {
        try {
            for (PackageRelationship rel : sheetPart.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation())) {
                xhtml.startElement("a", "href", rel.getTargetURI().toString());
                xhtml.characters(rel.getTargetURI().toString());
                xhtml.endElement("a");
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    private void processShapes(List<XSSFShape> shapes, XHTMLContentHandler xhtml) throws SAXException {
        if (shapes == null) {
            return;
        }
        for (XSSFShape shape : shapes) {
            XSSFDrawing drawing;
            if (shape instanceof XSSFSimpleShape) {
                String sText = ((XSSFSimpleShape)shape).getText();
                if (sText != null && sText.length() > 0) {
                    xhtml.element("p", sText);
                }
                this.extractHyperLinksFromShape(((XSSFSimpleShape)shape).getCTShape(), xhtml);
            }
            if ((drawing = shape.getDrawing()) == null) continue;
            this.handleGeneralTextContainingPart("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", "diagram-data", drawing.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
            this.handleGeneralTextContainingPart(XSSFRelation.CHART.getRelation(), "chart", drawing.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
        }
    }

    private void extractHyperLinksFromShape(CTShape ctShape, XHTMLContentHandler xhtml) throws SAXException {
        CTHyperlink ctHoverHyperlink;
        if (ctShape == null) {
            return;
        }
        CTShapeNonVisual nvSpPR = ctShape.getNvSpPr();
        if (nvSpPR == null) {
            return;
        }
        CTNonVisualDrawingProps cNvPr = nvSpPR.getCNvPr();
        if (cNvPr == null) {
            return;
        }
        CTHyperlink ctHyperlink = cNvPr.getHlinkClick();
        if (ctHyperlink == null) {
            return;
        }
        String url = (String)this.drawingHyperlinks.get(ctHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
        if ((ctHoverHyperlink = cNvPr.getHlinkHover()) == null) {
            return;
        }
        url = (String)this.drawingHyperlinks.get(ctHoverHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
    }

    private void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, XSSFBCommentsTable comments, XSSFBStylesTable styles, XSSFBSharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        XSSFBSheetHandler xssfbSheetHandler = new XSSFBSheetHandler(sheetInputStream, styles, comments, strings, sheetContentsExtractor, this.formatter, false);
        xssfbSheetHandler.parse();
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        for (PackagePart part : this.sheetParts) {
            parts.add(part);
            try {
                PackagePartName relName;
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.VML_DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", e);
            }
        }
        for (PackagePart part : this.extractor.getPackage().getPartsByRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            parts.add(part);
        }
        return parts;
    }
}

