/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.unidata.util.StringUtil2;

class NcepLocalParams {
    private static final Logger log = LoggerFactory.getLogger(NcepLocalParams.class);
    private static final boolean debugOpen = false;
    private static final boolean debug = false;
    private Map<Integer, Table> tableMap = new HashMap<Integer, Table>(30);
    private final String resourcePath;
    private static final String match = "Table4.2.";

    NcepLocalParams(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Grib2Parameter getParameter(int discipline, int category, int number) {
        int key = (discipline << 8) + category;
        Table params = this.tableMap.get(key);
        if (params == null) {
            params = this.factory(discipline, category);
            if (params == null) {
                return null;
            }
            this.tableMap.put(key, params);
        }
        return params.getParameter(number);
    }

    public String getCategory(int discipline, int category) {
        int key = (discipline << 8) + category;
        Table params = this.tableMap.get(key);
        return params == null ? null : params.title;
    }

    Table factory(String path) {
        Table params = new Table();
        if (!params.readParameterTableXml(path)) {
            return null;
        }
        return params;
    }

    private Table factory(int discipline, int category) {
        Table params = new Table();
        if (!params.readParameterTableFromResource(this.getTablePath(discipline, category))) {
            return null;
        }
        return params;
    }

    String getTablePath(int discipline, int category) {
        return this.resourcePath + match + discipline + "." + category + ".xml";
    }

    static boolean isUnitless(String unit) {
        if (unit == null) {
            return true;
        }
        String munge = unit.toLowerCase().trim();
        return (munge = StringUtil2.remove(munge, 40)).length() == 0 || munge.startsWith("numeric") || munge.startsWith("non-dim") || munge.startsWith("see") || munge.startsWith("proportion") || munge.startsWith("code") || munge.startsWith("0=") || munge.equals("1");
    }

    static class Table {
        private String title;
        private String source;
        private String tableName;
        private int discipline;
        private int category;
        private Map<Integer, Grib2Parameter> paramMap;

        Table() {
        }

        public List<Grib2Parameter> getParameters() {
            ArrayList<Grib2Parameter> result = new ArrayList<Grib2Parameter>(this.paramMap.values());
            Collections.sort(result);
            return result;
        }

        public Grib2Parameter getParameter(int code) {
            if (this.paramMap == null) {
                return null;
            }
            return this.paramMap.get(code);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readParameterTableXml(String path) {
            try (InputStream is = GribResourceReader.getInputStream(path);){
                if (is == null) {
                    log.warn("Cant read file " + path);
                    boolean bl2 = false;
                    return bl2;
                }
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                Element root = doc.getRootElement();
                this.paramMap = this.parseXml(root);
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return false;
            }
            catch (JDOMException e) {
                e.printStackTrace();
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readParameterTableFromResource(String resource) {
            ClassLoader cl = this.getClass().getClassLoader();
            try (InputStream is = cl.getResourceAsStream(resource);){
                if (is == null) {
                    log.info("Cant read resource " + resource);
                    boolean bl2 = false;
                    return bl2;
                }
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                Element root = doc.getRootElement();
                this.paramMap = this.parseXml(root);
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return false;
            }
            catch (JDOMException e) {
                e.printStackTrace();
                return false;
            }
        }

        public HashMap<Integer, Grib2Parameter> parseXml(Element root) {
            this.tableName = root.getChildText("table");
            this.title = root.getChildText("title");
            this.source = root.getChildText("source");
            int pos = this.tableName.indexOf(NcepLocalParams.match);
            String dc = this.tableName.substring(pos + NcepLocalParams.match.length());
            String[] dcs = dc.split("\\.");
            this.discipline = Integer.parseInt(dcs[0]);
            this.category = Integer.parseInt(dcs[1]);
            HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>();
            List<Element> params = root.getChildren("parameter");
            for (Element elem : params) {
                String name;
                int code = Integer.parseInt(elem.getAttributeValue("code"));
                String abbrev = elem.getChildText("shortName");
                String desc = elem.getChildText("description");
                String units = elem.getChildText("units");
                if (units == null) {
                    units = "";
                }
                if (desc.length() > 80 && abbrev != null && !abbrev.equalsIgnoreCase("Validation")) {
                    name = abbrev;
                } else {
                    name = desc;
                    desc = null;
                }
                Grib2Parameter parameter = new Grib2Parameter(this.discipline, this.category, code, name, units, abbrev, desc);
                result.put(parameter.getNumber(), parameter);
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NcepTable");
            sb.append("{title='").append(this.title).append('\'');
            sb.append(", source='").append(this.source).append('\'');
            sb.append(", tableName='").append(this.tableName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

