# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193635;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"811852", "Oga\,\ Akita",
"818664", "Takahashi\,\ Okayama",
"818466", "Mima\,\ Tokushima",
"818879", "Muroto\,\ Kochi",
"811554", "Obihiro\,\ Hokkaido",
"817998", "Tsuna\,\ Hyogo",
"815767", "Gero\,\ Gifu",
"811357", "Iwanai\,\ Hokkaido",
"817965", "Toyooka\,\ Hyogo",
"818493", "Onomichi\,\ Hiroshima",
"818873", "Aki\,\ Kochi",
"818290", "Hiroshima\,\ Hiroshima",
"817725", "Miyazu\,\ Kyoto",
"818582", "Kurayoshi\,\ Tottori",
"819823", "Nobeoka\,\ Miyazaki",
"811943", "Iwaizumi\,\ Iwate",
"81932", "Kitakyushu\,\ Fukuoka",
"812655", "Iida\,\ Nagano",
"812674", "Komoro\,\ Nagano",
"811876", "Omagari\,\ Akita",
"812476", "Miharu\,\ Fukushima",
"818547", "Kakeya\,\ Shimane",
"817735", "Fukuchiyama\,\ Kyoto",
"818946", "Uwajima\,\ Ehime",
"81551", "Nirasaki\,\ Yamanashi",
"81933", "Kitakyushu\,\ Fukuoka",
"811463", "Urakawa\,\ Hokkaido",
"819233", "Maebaru\,\ Fukuoka",
"8153969", "Hamamatsu\,\ Shizuoka",
"817687", "Noto\,\ Ishikawa",
"812896", "Kanuma\,\ Tochigi",
"81236", "Yamagata\,\ Yamagata",
"81587", "Ichinomiya\,\ Aichi",
"815986", "Matsusaka\,\ Mie",
"81266", "Suwa\,\ Nagano",
"811394", "Matsumae\,\ Hokkaido",
"8182942", "Hiroshima\,\ Hiroshima",
"812389", "Yonezawa\,\ Yamagata",
"812612", "Omachi\,\ Nagano",
"815958", "Kameyama\,\ Mie",
"812788", "Maebashi\,\ Gunma",
"81963", "Kumamoto\,\ Kumamoto",
"81288", "Imabari\,\ Ehime",
"812577", "Muika\,\ Niigata",
"817945", "Kakogawa\,\ Hyogo",
"812374", "Murayama\,\ Yamagata",
"812383", "Yonezawa\,\ Yamagata",
"81549", "Shizuoka\,\ Shizuoka",
"819956", "Kajiki\,\ Kagoshima",
"81962", "Kumamoto\,\ Kumamoto",
"814287", "Ome\,\ Tokyo",
"819557", "Karatsu\,\ Saga",
"811733", "Goshogawara\,\ Aomori",
"81234", "Sakata\,\ Yamagata",
"812415", "Yanaizu\,\ Fukushima",
"812551", "Joetsu\,\ Niigata",
"818567", "Tsuwano\,\ Shimane",
"812243", "Shiroishi\,\ Miyagi",
"818364", "Ube\,\ Yamaguchi",
"817498", "Nagahama\,\ Shiga",
"817465", "Yoshino\,\ Nara",
"81544", "Fujinomiya\,\ Shizuoka",
"818463", "Takehara\,\ Hiroshima",
"81722", "Sakai\,\ Osaka",
"817995", "Sumoto\,\ Hyogo",
"817968", "Hamasaka\,\ Hyogo",
"8125481", "Murakami\,\ Niigata",
"818694", "Okayama\,\ Okayama",
"8125485", "Tsugawa\,\ Niigata",
"81433", "Chiba\,\ Chiba",
"81898", "Imabari\,\ Ehime",
"8169", "Osaka\,\ Osaka",
"8186993", "Bizen\,\ Okayama",
"811635", "Hamatonbetsu\,\ Hokkaido",
"811547", "Shiranuka\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"818680", "Okayama\,\ Okayama",
"811946", "Kuji\,\ Iwate",
"819826", "Hyuga\,\ Miyazaki",
"8124197", "Yanaizu\,\ Fukushima",
"811873", "Kakunodate\,\ Akita",
"812484", "Shirakawa\,\ Fukushima",
"812473", "Ishikawa\,\ Fukushima",
"8125480", "Murakami\,\ Niigata",
"81596", "Ise\,\ Mie",
"811582", "Monbetsu\,\ Hokkaido",
"81432", "Chiba\,\ Chiba",
"818943", "Yawatahama\,\ Ehime",
"817738", "Maizuru\,\ Kyoto",
"818204", "Yanai\,\ Yamaguchi",
"812658", "Ina\,\ Nagano",
"812232", "Iwanuma\,\ Miyagi",
"812899", "Kanuma\,\ Tochigi",
"811466", "Erimo\,\ Hokkaido",
"818949", "Uwajima\,\ Ehime",
"812832", "Sano\,\ Tochigi",
"819682", "Yamaga\,\ Kumamoto",
"818554", "Hamada\,\ Shimane",
"8153966", "Hamamatsu\,\ Shizuoka",
"81723", "Sakai\,\ Osaka",
"8144", "Kawasaki\,\ Kanagawa",
"812893", "Utsunomiya\,\ Tochigi",
"81572", "Tajimi\,\ Gifu",
"811932", "Kamaishi\,\ Iwate",
"81852", "Matsue\,\ Shimane",
"818657", "Kasaoka\,\ Okayama",
"8198295", "Hyuga\,\ Miyazaki",
"815983", "Matsusaka\,\ Mie",
"815974", "Owase\,\ Mie",
"812545", "Murakami\,\ Niigata",
"8198291", "Nobeoka\,\ Miyazaki",
"815754", "Sekigahara\,\ Gifu",
"811364", "Kutchan\,\ Hokkaido",
"818240", "Higashi\-ku\,\ Hiroshima",
"81546", "Shizuoka\,\ Shizuoka",
"819667", "Minamata\,\ Kumamoto",
"814776", "Funabashi\,\ Chiba",
"817948", "Miki\,\ Hyogo",
"81167", "Furano\,\ Hokkaido",
"812386", "Nagai\,\ Yamagata",
"81462", "Atsugi\,\ Kanagawa",
"812785", "Numata\,\ Gunma",
"819953", "Okuchi\,\ Kagoshima",
"811644", "Rumoi\,\ Hokkaido",
"81848", "Onomichi\,\ Hiroshima",
"8164", "Osaka\,\ Osaka",
"819784", "Bungotakada\,\ Oita",
"81463", "Hiratsuka\,\ Kanagawa",
"811736", "Goshogawara\,\ Aomori",
"8126172", "Omachi\,\ Nagano",
"8198290", "Nobeoka\,\ Miyazaki",
"817495", "Nagahama\,\ Shiga",
"819544", "Takeo\,\ Saga",
"817468", "Kamikitayama\,\ Nara",
"814752", "Mobara\,\ Chiba",
"81594", "Kuwana\,\ Mie",
"81853", "Izumo\,\ Shimane",
"81280", "Koga\,\ Ibaraki",
"814704", "Tateyama\,\ Chiba",
"812246", "Ogawara\,\ Miyagi",
"817722", "Miyazu\,\ Kyoto",
"812489", "Sukagawa\,\ Fukushima",
"818553", "Hamada\,\ Shimane",
"818585", "Kurayoshi\,\ Tottori",
"817487", "Minakuchi\,\ Shiga",
"812894", "Utsunomiya\,\ Tochigi",
"812483", "Shirakawa\,\ Fukushima",
"812474", "Ishikawa\,\ Fukushima",
"811874", "Kakunodate\,\ Akita",
"812676", "Saku\,\ Nagano",
"811855", "Noshiro\,\ Akita",
"814298", "Hanno\,\ Saitama",
"818559", "Kawamoto\,\ Shimane",
"818944", "Yawatahama\,\ Ehime",
"81272", "Maebashi\,\ Gunma",
"818203", "Yanai\,\ Yamaguchi",
"817962", "Toyooka\,\ Hyogo",
"819596", "Fukue\,\ Nagasaki",
"81138", "Hakodate\,\ Hokkaido",
"812797", "Shibukawa\,\ Gunma",
"81244", "Hobara\,\ Fukushima",
"81992", "Kagoshima\,\ Kagoshima",
"81184", "Yurihonjo\,\ Akita",
"8161", "Osaka\,\ Osaka",
"812838", "Sano\,\ Tochigi",
"819688", "Tamana\,\ Kumamoto",
"81875", "Kan\'onji\,\ Kagawa",
"81765", "Uozu\,\ Toyama",
"817950", "Sanda\,\ Hyogo",
"81273", "Takasaki\,\ Gunma",
"818464", "Takehara\,\ Hiroshima",
"812652", "Iida\,\ Nagano",
"818666", "Ibara\,\ Okayama",
"812238", "Sendai\,\ Miyagi",
"811957", "Iwate\,\ Iwate",
"817732", "Fukuchiyama\,\ Kyoto",
"811556", "Obihiro\,\ Hokkaido",
"811588", "Okoppe\,\ Hokkaido",
"81124", "Ashibetsu\,\ Hokkaido",
"818693", "Oku\,\ Okayama",
"812857", "Mooka\,\ Tochigi",
"819543", "Takeo\,\ Saga",
"814703", "Tateyama\,\ Chiba",
"819789", "Kitsuki\,\ Oita",
"817942", "Kakogawa\,\ Hyogo",
"818366", "Ube\,\ Yamaguchi",
"818798", "Tonosho\,\ Kagawa",
"819975", "Naze\,\ Kagoshima",
"819954", "Kajiki\,\ Kagoshima",
"81942", "Kurume\,\ Fukuoka",
"81294", "Hitachiota\,\ Ibaraki",
"812640", "Nagano\,\ Nagano",
"81555", "Fujiyoshida\,\ Yamanashi",
"814709", "Kamogawa\,\ Chiba",
"819783", "Bungotakada\,\ Oita",
"811938", "Miyako\,\ Iwate",
"812615", "Omachi\,\ Nagano",
"815979", "Kumano\,\ Mie",
"8186691", "Kurashiki\,\ Okayama",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"8126176", "Omachi\,\ Nagano",
"814758", "Togane\,\ Chiba",
"812376", "Sagae\,\ Yamagata",
"81126", "Iwamizawa\,\ Hokkaido",
"81569", "Handa\,\ Aichi",
"81485", "Kumagaya\,\ Saitama",
"8186552", "Kurashiki\,\ Okayama",
"815984", "Matsusaka\,\ Mie",
"815973", "Owase\,\ Mie",
"811396", "Esashi\,\ Hokkaido",
"81246", "Iwaki\,\ Fukushima",
"81958", "Nagasaki\,\ Nagasaki",
"81425", "Tachikawa\,\ Tokyo",
"815753", "Sekigahara\,\ Gifu",
"811363", "Kutchan\,\ Hokkaido",
"812412", "Kitakata\,\ Fukushima",
"812937", "Mito\,\ Ibaraki",
"811464", "Shizunai\,\ Hokkaido",
"81476", "Narita\,\ Chiba",
"812679", "Saku\,\ Nagano",
"818806", "Sukumo\,\ Kochi",
"818957", "Misho\,\ Ehime",
"811632", "Teshio\,\ Hokkaido",
"818556", "Gotsu\,\ Shimane",
"812562", "Sanjo\,\ Niigata",
"819727", "Usuki\,\ Oita",
"818588", "Koge\,\ Tottori",
"817677", "Nanao\,\ Ishikawa",
"819599", "Oseto\,\ Nagasaki",
"812486", "Sukagawa\,\ Fukushima",
"819967", "Izumi\,\ Kagoshima",
"812673", "Komoro\,\ Nagano",
"817992", "Sumoto\,\ Hyogo",
"81492", "Kawagoe\,\ Saitama",
"818206", "Yanai\,\ Yamaguchi",
"811858", "Noshiro\,\ Akita",
"819593", "Oseto\,\ Nagasaki",
"818874", "Aki\,\ Kochi",
"818669", "Soja\,\ Okayama",
"811559", "Obihiro\,\ Hokkaido",
"819685", "Tamana\,\ Kumamoto",
"812835", "Sano\,\ Tochigi",
"811944", "Iwaizumi\,\ Iwate",
"819824", "Nobeoka\,\ Miyazaki",
"8163", "Osaka\,\ Osaka",
"81493", "Higashimatsuyama\,\ Saitama",
"81564", "Okazaki\,\ Aichi",
"81979", "Nakatsu\,\ Oita",
"812550", "Yasuzuka\,\ Niigata",
"818663", "Soja\,\ Okayama",
"811553", "Obihiro\,\ Hokkaido",
"811585", "Engaru\,\ Hokkaido",
"817368", "Iwade\,\ Wakayama",
"8198293", "Nobeoka\,\ Miyazaki",
"812235", "Sendai\,\ Miyagi",
"817717", "Sonobe\,\ Kyoto",
"8183766", "Shimonoseki\,\ Yamaguchi",
"819737", "Kusu\,\ Oita",
"818696", "Bizen\,\ Okayama",
"819546", "Kashima\,\ Saga",
"819947", "Shibushi\,\ Kagoshima",
"81886", "Tokushima\,\ Tokushima",
"81925", "Fukuoka\,\ Fukuoka",
"818363", "Ube\,\ Yamaguchi",
"81534", "Hamamatsu\,\ Shizuoka",
"818514", "Ama\,\ Shimane",
"812244", "Shiroishi\,\ Miyagi",
"812782", "Numata\,\ Gunma",
"8178", "Kobe\,\ Hyogo",
"812618", "Omachi\,\ Nagano",
"811935", "Kamaishi\,\ Iwate",
"81985", "Miyazaki\,\ Miyazaki",
"81474", "Funabashi\,\ Chiba",
"811646", "Haboro\,\ Hokkaido",
"81778", "Takefu\,\ Fukui",
"812542", "Shibata\,\ Niigata",
"81950", "Hirado\,\ Nagasaki",
"8188095", "Tosashimizu\,\ Kochi",
"8112398", "Kuriyama\,\ Hokkaido",
"8166", "Osaka\,\ Osaka",
"818369", "Ube\,\ Yamaguchi",
"811734", "Goshogawara\,\ Aomori",
"819786", "Kitsuki\,\ Oita",
"819978", "Tokunoshima\,\ Kagoshima",
"817492", "Hikone\,\ Shiga",
"81566", "Kariya\,\ Aichi",
"814755", "Togane\,\ Chiba",
"8126179", "Omachi\,\ Nagano",
"812587", "Nagaoka\,\ Niigata",
"8186995", "Seto\,\ Okayama",
"812384", "Yonezawa\,\ Yamagata",
"812373", "Murayama\,\ Yamagata",
"811237", "Kuriyama\,\ Hokkaido",
"811393", "Matsumae\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"8125483", "Murakami\,\ Niigata",
"811366", "Suttsu\,\ Hokkaido",
"81249", "Koriyama\,\ Fukushima",
"812747", "Tomioka\,\ Gunma",
"81227", "Sendai\,\ Miyagi",
"811332", "Tobetsu\,\ Hokkaido",
"812998", "Itako\,\ Ibaraki",
"818248", "Shobara\,\ Hiroshima",
"811947", "Kuji\,\ Iwate",
"819827", "Takachiho\,\ Miyazaki",
"811546", "Kushiro\,\ Hokkaido",
"812965", "Shimodate\,\ Ibaraki",
"8165", "Osaka\,\ Osaka",
"8111", "Sapporo\,\ Hokkaido",
"81486", "Urawa\,\ Saitama",
"817452", "Yamatotakada\,\ Nara",
"81125", "Takikawa\,\ Hokkaido",
"814795", "Choshi\,\ Chiba",
"818372", "Nagato\,\ Yamaguchi",
"815769", "Shokawa\,\ Gifu",
"817915", "Aioi\,\ Hyogo",
"81426", "Hachioji\,\ Tokyo",
"819935", "Kaseda\,\ Kagoshima",
"81245", "Fukushima\,\ Fukushima",
"815395", "Hamamatsu\,\ Shizuoka",
"815368", "Shitara\,\ Aichi",
"81468", "Yokosuka\,\ Kanagawa",
"819734", "Hita\,\ Oita",
"817940", "Kakogawa\,\ Hyogo",
"817714", "Kameoka\,\ Kyoto",
"811353", "Yoichi\,\ Hokkaido",
"814291", "Hanno\,\ Saitama",
"81764", "Toyama\,\ Toyama",
"811978", "Kitakami\,\ Iwate",
"815763", "Gero\,\ Gifu",
"8153976", "Hamamatsu\,\ Shizuoka",
"81929", "Fukuoka\,\ Fukuoka",
"818388", "Tamagawa\,\ Yamaguchi",
"818954", "Uwajima\,\ Ehime",
"818975", "Niihama\,\ Ehime",
"81947", "Tagawa\,\ Fukuoka",
"812934", "Takahagi\,\ Ibaraki",
"817683", "Wajima\,\ Ishikawa",
"817674", "Hakui\,\ Ishikawa",
"817476", "Shimonoseki\,\ Yamaguchi",
"819724", "Saiki\,\ Oita",
"818543", "Yasugi\,\ Shimane",
"811982", "Hanamaki\,\ Iwate",
"819964", "Satsumasendai\,\ Kagoshima",
"81989", "Naha\,\ Okinawa",
"8198298", "Hyuga\,\ Miyazaki",
"815992", "Toba\,\ Mie",
"812573", "Kashiwazaki\,\ Niigata",
"812584", "Nagaoka\,\ Niigata",
"819666", "Minamata\,\ Kumamoto",
"814777", "Funabashi\,\ Chiba",
"81728", "Neyagawa\,\ Osaka",
"817612", "Komatsu\,\ Ishikawa",
"818895", "Susaki\,\ Kochi",
"811234", "Chitose\,\ Hokkaido",
"815743", "Minokamo\,\ Gifu",
"81766", "Takaoka\,\ Toyama",
"812387", "Nagai\,\ Yamagata",
"818295", "Hatsukaichi\,\ Hiroshima",
"817355", "Shingu\,\ Fukuoka",
"81892", "Kumakogen\,\ Ehime",
"811532", "Nemuro\,\ Hokkaido",
"815583", "Shimoda\,\ Shizuoka",
"818475", "Fuchu\,\ Hiroshima",
"818656", "Kasaoka\,\ Okayama",
"8112393", "Yubari\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"818688", "Mimasaka\,\ Okayama",
"812744", "Fujioka\,\ Gunma",
"8145", "Yokohama\,\ Kanagawa",
"81484", "Kawaguchi\,\ Saitama",
"8124196", "Yanaizu\,\ Fukushima",
"81554", "Otsuki\,\ Yamanashi",
"818563", "Masuda\,\ Shimane",
"81893", "Ozu\,\ Ehime",
"81438", "Kisarazu\,\ Chiba",
"819809", "Yaeyama\ District\,\ Okinawa",
"811522", "Shari\,\ Hokkaido",
"81734", "Wakayama\,\ Wakayama",
"819944", "Kanoya\,\ Kagoshima",
"819435", "Yame\,\ Fukuoka",
"811653", "Shibetsu\,\ Hokkaido",
"814289", "Ome\,\ Tokyo",
"812878", "Nasukarasuyama\,\ Tochigi",
"812247", "Ogawara\,\ Miyagi",
"81277", "Kiryu\,\ Gunma",
"818596", "Yonago\,\ Tottori",
"819803", "Nago\,\ Okinawa",
"81179", "Sannohe\,\ Aomori",
"8153967", "Hamamatsu\,\ Shizuoka",
"819553", "Imari\,\ Saga",
"814283", "Ome\,\ Tokyo",
"817705", "Obama\,\ Fukui",
"8125488", "Tsugawa\,\ Niigata",
"811865", "Odate\,\ Akita",
"8152", "Nagoya\,\ Aichi",
"81578", "Kamioka\,\ Akita",
"817952", "Nishiwaki\,\ Hyogo",
"81930", "Yukuhashi\,\ Fukuoka",
"817904", "Fukusaki\,\ Hyogo",
"814798", "Yokaichiba\,\ Chiba",
"811543", "Kushiro\,\ Hokkaido",
"81565", "Toyota\,\ Aichi",
"812794", "Shibukawa\,\ Gunma",
"81489", "Soka\,\ Saitama",
"81222", "Sendai\,\ Miyagi",
"812995", "Ishioka\,\ Ibaraki",
"818245", "Miyoshi\,\ Hiroshima",
"812968", "Kasama\,\ Ibaraki",
"81282", "Tochigi\,\ Tochigi",
"811549", "Kushiro\,\ Hokkaido",
"81142", "Date\,\ Hokkaido",
"811954", "Ninohe\,\ Iwate",
"811975", "Mizusawa\,\ Iwate",
"818467", "Mima\,\ Tokushima",
"815398", "Hamamatsu\,\ Shizuoka",
"815732", "Ena\,\ Gifu",
"811356", "Iwanai\,\ Hokkaido",
"812780", "Maebashi\,\ Gunma",
"815766", "Gero\,\ Gifu",
"819938", "Kaseda\,\ Kagoshima",
"81429", "Tokorozawa\,\ Saitama",
"81885", "Komatsushima\,\ Tokushima",
"81143", "Muroran\,\ Hokkaido",
"817686", "Noto\,\ Ishikawa",
"812897", "Kanuma\,\ Tochigi",
"817484", "Yokaichi\,\ Shiga",
"818385", "Hagi\,\ Yamaguchi",
"8126174", "Omachi\,\ Nagano",
"8153979", "Hamamatsu\,\ Shizuoka",
"81926", "Fukuoka\,\ Fukuoka",
"81174", "Kanita\,\ Aomori",
"818978", "Hakata\,\ Ehime",
"818947", "Uwajima\,\ Ehime",
"818546", "Kakeya\,\ Shimane",
"811877", "Omagari\,\ Akita",
"812477", "Miharu\,\ Fukushima",
"81986", "Miyakonojo\,\ Miyazaki",
"81739", "Tanabe\,\ Wakayama",
"81460", "Odawara\,\ Kanagawa",
"81825", "Hiroshima\,\ Hiroshima",
"811372", "Shikabe\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"81591", "Tsu\,\ Mie",
"812576", "Tokamachi\,\ Niigata",
"819663", "Hitoyoshi\,\ Kumamoto",
"8147955", "Yokaichiba\,\ Chiba",
"815746", "Minokamo\,\ Gifu",
"811563", "Honbetsu\,\ Hokkaido",
"819572", "Isahaya\,\ Nagasaki",
"815586", "Shimoda\,\ Shizuoka",
"818685", "Tsuyama\,\ Okayama",
"812560", "Itoigawa\,\ Niigata",
"812692", "Nakano\,\ Nagano",
"818478", "Tojo\,\ Hiroshima",
"81938", "Kitakyushu\,\ Fukuoka",
"818298", "Hatsukaichi\,\ Hiroshima",
"812552", "Joetsu\,\ Niigata",
"818834", "Kamojima\,\ Tokushima",
"81192", "Ofunato\,\ Iwate",
"81984", "Kobayashi\,\ Miyazaki",
"811454", "Mukawa\,\ Hokkaido",
"812854", "Oyama\,\ Tochigi",
"812875", "Otawara\,\ Tochigi",
"8147950", "Yokaichiba\,\ Chiba",
"811656", "Bifuka\,\ Hokkaido",
"819438", "Tanushimaru\,\ Fukuoka",
"818593", "Yonago\,\ Tottori",
"819556", "Karatsu\,\ Saga",
"814286", "Sagamihara\,\ Kanagawa",
"819957", "Kajiki\,\ Kagoshima",
"811868", "Takanosu\,\ Akita",
"81176", "Towada\,\ Aomori",
"81924", "Fukuoka\,\ Fukuoka",
"81535", "Hamamatsu\,\ Shizuoka",
"81583", "Gifu\,\ Gifu",
"814240", "Kokubunji\,\ Tokyo",
"817912", "Aioi\,\ Hyogo",
"819932", "Ibusuki\,\ Kagoshima",
"8112390", "Yubari\,\ Hokkaido",
"815392", "Hamamatsu\,\ Shizuoka",
"81157", "Kitami\,\ Hokkaido",
"812487", "Sukagawa\,\ Fukushima",
"815738", "Nakatsugawa\,\ Gifu",
"819966", "Izumi\,\ Kagoshima",
"81862", "Okayama\,\ Okayama",
"818557", "Kawamoto\,\ Shimane",
"8186998", "Seto\,\ Okayama",
"818956", "Uwajima\,\ Ehime",
"812962", "Shimodate\,\ Ibaraki",
"818807", "Sukumo\,\ Kochi",
"812936", "Mito\,\ Ibaraki",
"817455", "Yamatotakada\,\ Nara",
"817483", "Yokaichi\,\ Shiga",
"817676", "Nanao\,\ Ishikawa",
"81259", "Sado\,\ Niigata",
"814792", "Choshi\,\ Chiba",
"818375", "Mine\,\ Yamaguchi",
"819726", "Usuki\,\ Oita",
"811378", "Imakane\,\ Hokkaido",
"811953", "Ninohe\,\ Iwate",
"812799", "Naganohara\,\ Gunma",
"81863", "Tamano\,\ Okayama",
"818697", "Bizen\,\ Okayama",
"817716", "Sonobe\,\ Kyoto",
"8112391", "Yubari\,\ Hokkaido",
"815995", "Ago\,\ Mie",
"81744", "Yamatotakada\,\ Nara",
"8188098", "Tosashimizu\,\ Kochi",
"8112395", "Kuriyama\,\ Hokkaido",
"818972", "Niihama\,\ Ehime",
"811544", "Kushiro\,\ Hokkaido",
"81940", "Munakata\,\ Fukuoka",
"81582", "Gifu\,\ Gifu",
"812793", "Shibukawa\,\ Gunma",
"817238", "Neyagawa\,\ Osaka",
"818292", "Hiroshima\,\ Hiroshima",
"817352", "Shingu\,\ Fukuoka",
"811535", "Akkeshi\,\ Hokkaido",
"811647", "Haboro\,\ Hokkaido",
"8199347", "Kagoshima\,\ Kagoshima",
"812698", "Iiyama\,\ Nagano",
"812859", "Oyama\,\ Tochigi",
"819578", "Shimabara\,\ Nagasaki",
"819787", "Kunisaki\,\ Oita",
"818833", "Kamojima\,\ Tokushima",
"818397", "Ogori\,\ Yamaguchi",
"819946", "Kanoya\,\ Kagoshima",
"817615", "Komatsu\,\ Ishikawa",
"812853", "Oyama\,\ Tochigi",
"819547", "Kashima\,\ Saga",
"811453", "Hayakita\,\ Hokkaido",
"818892", "Sakawa\,\ Kochi",
"81235", "Tsuruoka\,\ Yamagata",
"81833", "Kudamatsu\,\ Yamaguchi",
"818594", "Yonago\,\ Tottori",
"811564", "Kamishihoro\,\ Hokkaido",
"815977", "Kumano\,\ Mie",
"817702", "Tsuruga\,\ Fukui",
"818675", "Kuse\,\ Okayama",
"818654", "Kamogata\,\ Okayama",
"811862", "Kazuno\,\ Akita",
"81832", "Shimonoseki\,\ Yamaguchi",
"812746", "Tomioka\,\ Gunma",
"811367", "Suttsu\,\ Hokkaido",
"817955", "Sanda\,\ Hyogo",
"81937", "Kitakyushu\,\ Fukuoka",
"812586", "Nagaoka\,\ Niigata",
"811525", "Abashiri\,\ Hokkaido",
"8153964", "Hamamatsu\,\ Shizuoka",
"819664", "Hitoyoshi\,\ Kumamoto",
"819432", "Yame\,\ Fukuoka",
"811236", "Chitose\,\ Hokkaido",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81270", "Isesaki\,\ Gunma",
"819742", "Mie\,\ Oita",
"811972", "Mizusawa\,\ Iwate",
"81531", "Tahara\,\ Aichi",
"818544", "Kisuki\,\ Shimane",
"812939", "Mito\,\ Ibaraki",
"818842", "Anan\,\ Tokushima",
"812677", "Saku\,\ Nagano",
"819963", "Satsumasendai\,\ Kagoshima",
"811752", "Mutsu\,\ Aomori",
"819597", "Fukue\,\ Nagasaki",
"815362", "Shinshiro\,\ Aichi",
"815735", "Ena\,\ Gifu",
"818378", "Shimonoseki\,\ Yamaguchi",
"818953", "Uwajima\,\ Ehime",
"812933", "Takahagi\,\ Ibaraki",
"81948", "Iizuka\,\ Fukuoka",
"817486", "Minakuchi\,\ Shiga",
"812648", "Nagano\,\ Nagano",
"817684", "Wajima\,\ Ishikawa",
"817673", "Hakui\,\ Ishikawa",
"812911", "Hokota\,\ Ibaraki",
"81471", "Kashiwa\,\ Chiba",
"818242", "Higashi\-ku\,\ Hiroshima",
"8186698", "Kurashiki\,\ Okayama",
"812992", "Ishioka\,\ Ibaraki",
"819723", "Saiki\,\ Oita",
"81162", "Wakkanai\,\ Hokkaido",
"811956", "Iwate\,\ Iwate",
"8153972", "Hamamatsu\,\ Shizuoka",
"815998", "Ago\,\ Mie",
"818667", "Ibara\,\ Okayama",
"819733", "Hita\,\ Oita",
"81467", "Fujisawa\,\ Kanagawa",
"8182920", "Hatsukaichi\,\ Hiroshima",
"817713", "Kameoka\,\ Kyoto",
"811354", "Yoichi\,\ Hokkaido",
"811375", "Yakumo\,\ Hokkaido",
"815764", "Gero\,\ Gifu",
"81952", "Saga\,\ Saga",
"81857", "Tottori\,\ Tottori",
"81545", "Fuji\,\ Shizuoka",
"812796", "Shibukawa\,\ Gunma",
"818382", "Hagi\,\ Yamaguchi",
"819804", "Nago\,\ Okinawa",
"814284", "Tachikawa\,\ Tokyo",
"819575", "Isahaya\,\ Nagasaki",
"819554", "Imari\,\ Saga",
"818682", "Tsuyama\,\ Okayama",
"812695", "Nakano\,\ Nagano",
"81577", "Takayama\,\ Gifu",
"817903", "Fukusaki\,\ Hyogo",
"818262", "Kake\,\ Hiroshima",
"818564", "Masuda\,\ Shimane",
"818836", "Mima\,\ Tokushima",
"819943", "Kanoya\,\ Kagoshima",
"812856", "Mooka\,\ Tochigi",
"811654", "Nayoro\,\ Hokkaido",
"817618", "Kaga\,\ Ishikawa",
"818367", "Ube\,\ Yamaguchi",
"81998", "Kagoshima\,\ Kagoshima",
"811397", "Okushiri\,\ Hokkaido",
"812589", "Nagaoka\,\ Niigata",
"812830", "Utsunomiya\,\ Tochigi",
"815584", "Shimoda\,\ Shizuoka",
"812743", "Fujioka\,\ Gunma",
"818678", "Niimi\,\ Okayama",
"812583", "Nagaoka\,\ Niigata",
"812555", "Itoigawa\,\ Niigata",
"812574", "Kashiwazaki\,\ Niigata",
"81727", "Ikeda\,\ Osaka",
"812872", "Otawara\,\ Tochigi",
"81561", "Seto\,\ Aichi",
"811233", "Chitose\,\ Hokkaido",
"812377", "Sagae\,\ Yamagata",
"812230", "Sendai\,\ Miyagi",
"815744", "Minokamo\,\ Gifu",
"811528", "Bihoro\,\ Hokkaido",
"815999", "Tsu\,\ Mie",
"817682", "Wajima\,\ Ishikawa",
"81721", "Tondabayashi\,\ Osaka",
"814998", "Ogasawara\,\ Tokyo",
"81923", "Fukuoka\,\ Fukuoka",
"818244", "Miyoshi\,\ Hiroshima",
"812994", "Ishioka\,\ Ibaraki",
"8188096", "Tosashimizu\,\ Kochi",
"81286", "Utsunomiya\,\ Tochigi",
"81567", "Tsushima\,\ Aichi",
"812795", "Shibukawa\,\ Gunma",
"811754", "Mutsu\,\ Aomori",
"81226", "Kesennuma\,\ Miyagi",
"815993", "Toba\,\ Mie",
"811376", "Yakumo\,\ Hokkaido",
"8182941", "Hiroshima\,\ Hiroshima",
"81983", "Takanabe\,\ Miyazaki",
"811955", "Ninohe\,\ Iwate",
"811983", "Hanamaki\,\ Iwate",
"811974", "Mizusawa\,\ Iwate",
"818542", "Yasugi\,\ Shimane",
"817367", "Iwade\,\ Wakayama",
"81268", "Ueda\,\ Nagano",
"819738", "Kusu\,\ Oita",
"818844", "Anan\,\ Tokushima",
"817718", "Sonobe\,\ Kyoto",
"817485", "Yokaichi\,\ Shiga",
"817453", "Yamatotakada\,\ Nara",
"812938", "Mito\,\ Ibaraki",
"818373", "Nagato\,\ Yamaguchi",
"818384", "Hagi\,\ Yamaguchi",
"818958", "Misho\,\ Ehime",
"818587", "Koge\,\ Tottori",
"819728", "Usuki\,\ Oita",
"817678", "Nanao\,\ Ishikawa",
"819968", "Izumi\,\ Kagoshima",
"815736", "Nakatsugawa\,\ Gifu",
"81827", "Iwakuni\,\ Yamaguchi",
"81849", "Fukuyama\,\ Hiroshima",
"81922", "Fukuoka\,\ Fukuoka",
"811352", "Yoichi\,\ Hokkaido",
"8112397", "Kuriyama\,\ Hokkaido",
"815762", "Gero\,\ Gifu",
"8186996", "Seto\,\ Okayama",
"812649", "Nagano\,\ Nagano",
"814700", "Kamogawa\,\ Chiba",
"811857", "Noshiro\,\ Akita",
"81899", "Matsuyama\,\ Ehime",
"812588", "Nagaoka\,\ Niigata",
"818690", "Okayama\,\ Okayama",
"817959", "Sanda\,\ Hyogo",
"818562", "Masuda\,\ Shimane",
"812556", "Itoigawa\,\ Niigata",
"811523", "Shari\,\ Hokkaido",
"812957", "Daigo\,\ Ibaraki",
"818679", "Niimi\,\ Okayama",
"811652", "Shibetsu\,\ Hokkaido",
"811238", "Kuriyama\,\ Hokkaido",
"8186553", "Kurashiki\,\ Okayama",
"817953", "Nishiwaki\,\ Hyogo",
"81284", "Ashikaga\,\ Tochigi",
"81144", "Tomakomai\,\ Hokkaido",
"819802", "Minamidaito\,\ Okinawa",
"8199345", "Kagoshima\,\ Kagoshima",
"819552", "Imari\,\ Saga",
"814282", "Ome\,\ Tokyo",
"818684", "Tsuyama\,\ Okayama",
"812748", "Tomioka\,\ Gunma",
"819948", "Shibushi\,\ Kagoshima",
"81495", "Honjo\,\ Saitama",
"815742", "Minokamo\,\ Gifu",
"81172", "Hirosaki\,\ Aomori",
"812572", "Kashiwazaki\,\ Niigata",
"818835", "Mima\,\ Tokushima",
"817613", "Komatsu\,\ Ishikawa",
"812874", "Otawara\,\ Tochigi",
"812855", "Oyama\,\ Tochigi",
"811455", "Mukawa\,\ Hokkaido",
"812696", "Iiyama\,\ Nagano",
"81537", "Kakegawa\,\ Shizuoka",
"811533", "Nemuro\,\ Hokkaido",
"819576", "Shimabara\,\ Nagasaki",
"819977", "Setouchi\,\ Kagoshima",
"81196", "Morioka\,\ Iwate",
"815582", "Shimoda\,\ Shizuoka",
"812798", "Naganohara\,\ Gunma",
"814794", "Choshi\,\ Chiba",
"8188099", "Tosashimizu\,\ Kochi",
"819687", "Tamana\,\ Kumamoto",
"812964", "Shimodate\,\ Ibaraki",
"812837", "Sano\,\ Tochigi",
"81548", "Haibara\,\ Shizuoka",
"819735", "Hita\,\ Oita",
"817715", "Kameoka\,\ Kyoto",
"812237", "Sendai\,\ Miyagi",
"81482", "Kawaguchi\,\ Saitama",
"815996", "Ago\,\ Mie",
"811958", "Iwate\,\ Iwate",
"8126170", "Omachi\,\ Nagano",
"817914", "Aioi\,\ Hyogo",
"811587", "Nakayubetsu\,\ Hokkaido",
"811986", "Tono\,\ Iwate",
"819934", "Ibusuki\,\ Kagoshima",
"8198292", "Nobeoka\,\ Miyazaki",
"815394", "Hamamatsu\,\ Shizuoka",
"81553", "Yamanashi\,\ Yamanashi",
"817239", "Neyagawa\,\ Osaka",
"817456", "Yamatotakada\,\ Nara",
"817675", "Nanao\,\ Ishikawa",
"818376", "Mine\,\ Yamaguchi",
"819725", "Saiki\,\ Oita",
"81552", "Kofu\,\ Yamanashi",
"818955", "Uwajima\,\ Ehime",
"818974", "Niihama\,\ Ehime",
"811542", "Kushiro\,\ Hokkaido",
"817488", "Minakuchi\,\ Shiga",
"812646", "Nagano\,\ Nagano",
"812935", "Mito\,\ Ibaraki",
"8126171", "Omachi\,\ Nagano",
"814297", "Hanno\,\ Saitama",
"815733", "Ena\,\ Gifu",
"818360", "Ogori\,\ Yamaguchi",
"8126175", "Omachi\,\ Nagano",
"81260", "Anan\,\ Nagano",
"8186999", "Seto\,\ Okayama",
"81423", "Kokubunji\,\ Tokyo",
"819965", "Satsumasendai\,\ Kagoshima",
"818894", "Susaki\,\ Kochi",
"811235", "Yubari\,\ Hokkaido",
"818592", "Yonago\,\ Tottori",
"818660", "Seto\,\ Okayama",
"812585", "Nagaoka\,\ Niigata",
"812553", "Joetsu\,\ Niigata",
"814757", "Togane\,\ Chiba",
"811526", "Abashiri\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"81977", "Beppu\,\ Oita",
"812745", "Fujioka\,\ Gunma",
"817956", "Sanda\,\ Hyogo",
"81762", "Kanazawa\,\ Ishikawa",
"8125482", "Murakami\,\ Niigata",
"818294", "Hatsukaichi\,\ Hiroshima",
"817354", "Shingu\,\ Fukuoka",
"812559", "Yasuzuka\,\ Niigata",
"818676", "Kuse\,\ Okayama",
"818474", "Fuchu\,\ Hiroshima",
"81763", "Fukuno\,\ Toyama",
"812858", "Mooka\,\ Tochigi",
"819744", "Mie\,\ Oita",
"819662", "Hitoyoshi\,\ Kumamoto",
"814771", "Ichikawa\,\ Chiba",
"819945", "Kanoya\,\ Kagoshima",
"817616", "Komatsu\,\ Ishikawa",
"818797", "Tonosho\,\ Kagawa",
"819434", "Yame\,\ Fukuoka",
"812693", "Nakano\,\ Nagano",
"81199", "Morioka\,\ Iwate",
"817905", "Fukusaki\,\ Hyogo",
"811562", "Honbetsu\,\ Hokkaido",
"811536", "Akkeshi\,\ Hokkaido",
"817704", "Tsuruga\,\ Fukui",
"819573", "Isahaya\,\ Nagasaki",
"811864", "Odate\,\ Akita",
"818652", "Kurashiki\,\ Okayama",
"811937", "Miyako\,\ Iwate",
"815734", "Ena\,\ Gifu",
"81779", "Ono\,\ Gifu",
"8153978", "Hamamatsu\,\ Shizuoka",
"818545", "Kisuki\,\ Shimane",
"817737", "Maizuru\,\ Kyoto",
"811952", "Ninohe\,\ Iwate",
"812657", "Ina\,\ Nagano",
"813", "Tokyo",
"81252", "Niigata\,\ Niigata",
"817685", "Wajima\,\ Ishikawa",
"81134", "Otaru\,\ Hokkaido",
"818973", "Niihama\,\ Ehime",
"812792", "Shibukawa\,\ Gunma",
"8198296", "Hyuga\,\ Miyazaki",
"811756", "Noheji\,\ Aomori",
"81465", "Odawara\,\ Kanagawa",
"815366", "Shitara\,\ Aichi",
"811374", "Mori\,\ Hokkaido",
"8199343", "Kagoshima\,\ Kagoshima",
"815765", "Gero\,\ Gifu",
"81956", "Sasebo\,\ Nagasaki",
"819933", "Ibusuki\,\ Kagoshima",
"81188", "Akita\,\ Akita",
"811976", "Kitakami\,\ Iwate",
"814770", "Ichikawa\,\ Chiba",
"815393", "Hamamatsu\,\ Shizuoka",
"817482", "Yokaichi\,\ Shiga",
"814793", "Choshi\,\ Chiba",
"818246", "Miyoshi\,\ Hiroshima",
"812996", "Itako\,\ Ibaraki",
"812917", "Mito\,\ Ibaraki",
"8112394", "Yubari\,\ Hokkaido",
"811548", "Teshikaga\,\ Hokkaido",
"81253", "Niigata\,\ Niigata",
"81166", "Asahikawa\,\ Hokkaido",
"812963", "Shimodate\,\ Ibaraki",
"81547", "Shimada\,\ Shizuoka",
"812694", "Nakano\,\ Nagano",
"819805", "Nago\,\ Okinawa",
"814285", "Sagamihara\,\ Kanagawa",
"819574", "Isahaya\,\ Nagasaki",
"819555", "Karatsu\,\ Saga",
"817703", "Tsuruga\,\ Fukui",
"811863", "Kazuno\,\ Akita",
"8125486", "Tsugawa\,\ Niigata",
"819743", "Mie\,\ Oita",
"818565", "Masuda\,\ Shimane",
"811869", "Odate\,\ Akita",
"81298", "Tsuchiura\,\ Ibaraki",
"811655", "Nayoro\,\ Hokkaido",
"819433", "Yame\,\ Fukuoka",
"812876", "Kuroiso\,\ Tochigi",
"8182943", "Hiroshima\,\ Hiroshima",
"818293", "Hatsukaichi\,\ Hiroshima",
"817353", "Shingu\,\ Fukuoka",
"8153965", "Hamamatsu\,\ Shizuoka",
"815585", "Shimoda\,\ Shizuoka",
"818686", "Tsuyama\,\ Okayama",
"818893", "Sakawa\,\ Kochi",
"815745", "Minokamo\,\ Gifu",
"817947", "Miki\,\ Hyogo",
"818490", "Onomichi\,\ Hiroshima",
"819668", "Minamata\,\ Kumamoto",
"812575", "Tokamachi\,\ Niigata",
"812554", "Joetsu\,\ Niigata",
"818299", "Hiroshima\,\ Hiroshima",
"818832", "Kamojima\,\ Tokushima",
"81725", "Izumi\,\ Osaka",
"818479", "Tojo\,\ Hiroshima",
"811452", "Hayakita\,\ Hokkaido",
"81839", "Yamaguchi\,\ Yamaguchi",
"812852", "Oyama\,\ Tochigi",
"8162", "Osaka\,\ Osaka",
"819732", "Hita\,\ Oita",
"817712", "Kameoka\,\ Kyoto",
"81828", "Hiroshima\,\ Hiroshima",
"81776", "Fukui\,\ Fukui",
"817475", "Shimonoseki\,\ Yamaguchi",
"817454", "Yamatotakada\,\ Nara",
"8198299", "Hyuga\,\ Miyazaki",
"81792", "Himeji\,\ Hyogo",
"818374", "Nagato\,\ Yamaguchi",
"818383", "Hagi\,\ Yamaguchi",
"8168", "Osaka\,\ Osaka",
"81888", "Kochi\,\ Kochi",
"818976", "Niihama\,\ Ehime",
"817688", "Noto\,\ Ishikawa",
"81965", "Yatsushiro\,\ Kumamoto",
"811753", "Mutsu\,\ Aomori",
"815994", "Ago\,\ Mie",
"81834", "Tokuyama\,\ Yamaguchi",
"815363", "Shinshiro\,\ Aichi",
"81793", "Himeji\,\ Hyogo",
"818249", "Higashi\-ku\,\ Hiroshima",
"812999", "Itako\,\ Ibaraki",
"815768", "Gero\,\ Gifu",
"819936", "Kaseda\,\ Kagoshima",
"817997", "Tsuna\,\ Hyogo",
"811984", "Hanamaki\,\ Iwate",
"811973", "Mizusawa\,\ Iwate",
"818843", "Anan\,\ Tokushima",
"81586", "Ichinomiya\,\ Aichi",
"819962", "Satsumasendai\,\ Kagoshima",
"817672", "Hakui\,\ Ishikawa",
"8186992", "Bizen\,\ Okayama",
"814796", "Yokaichiba\,\ Chiba",
"812993", "Ishioka\,\ Ibaraki",
"818243", "Higashi\-ku\,\ Hiroshima",
"819722", "Saiki\,\ Oita",
"811545", "Kushiro\,\ Hokkaido",
"818952", "Uwajima\,\ Ehime",
"81568", "Kasugai\,\ Aichi",
"812932", "Takahagi\,\ Ibaraki",
"811337", "Ishikari\,\ Hokkaido",
"819558", "Karatsu\,\ Saga",
"814288", "Ome\,\ Tokyo",
"812742", "Fujioka\,\ Gunma",
"819808", "Yaeyama\ District\,\ Okinawa",
"81538", "Iwata\,\ Shizuoka",
"812890", "Utsunomiya\,\ Tochigi",
"814220", "Kokubunji\,\ Tokyo",
"812879", "Nasukarasuyama\,\ Tochigi",
"8126173", "Omachi\,\ Nagano",
"817706", "Obama\,\ Fukui",
"811534", "Nakashibetsu\,\ Hokkaido",
"811866", "Takanosu\,\ Akita",
"81743", "Nara\,\ Nara",
"8147957", "Yokaichiba\,\ Chiba",
"811232", "Chitose\,\ Hokkaido",
"811658", "Kamikawa\,\ Hokkaido",
"818568", "Tsuwano\,\ Shimane",
"819746", "Taketa\,\ Oita",
"818595", "Yonago\,\ Tottori",
"81864", "Kurashiki\,\ Okayama",
"812582", "Nagaoka\,\ Niigata",
"81774", "Uji\,\ Kyoto",
"817614", "Komatsu\,\ Ishikawa",
"817497", "Nagahama\,\ Shiga",
"8125489", "Tsugawa\,\ Niigata",
"812873", "Otawara\,\ Tochigi",
"81478", "Sawara\,\ Chiba",
"81935", "Kitakyushu\,\ Fukuoka",
"817954", "Nishiwaki\,\ Hyogo",
"817902", "Fukusaki\,\ Hyogo",
"818263", "Kake\,\ Hiroshima",
"81742", "Nara\,\ Nara",
"818296", "Hiroshima\,\ Hiroshima",
"8199331", "Kagoshima\,\ Kagoshima",
"812547", "Murakami\,\ Niigata",
"817356", "Kushimoto\,\ Wakayama",
"818476", "Fuchu\,\ Hiroshima",
"818683", "Tsuyama\,\ Okayama",
"818674", "Kuse\,\ Okayama",
"818655", "Kamogata\,\ Okayama",
"818896", "Susaki\,\ Kochi",
"812787", "Numata\,\ Gunma",
"812578", "Muika\,\ Niigata",
"819665", "Hitoyoshi\,\ Kumamoto",
"811524", "Abashiri\,\ Hokkaido",
"818689", "Okayama\,\ Okayama",
"818391", "Ogori\,\ Yamaguchi",
"81584", "Ogaki\,\ Gifu",
"814701", "Kamogawa\,\ Chiba",
"811558", "Hiroo\,\ Hokkaido",
"812236", "Sendai\,\ Miyagi",
"818668", "Ibara\,\ Okayama",
"815997", "Ago\,\ Mie",
"818695", "Seto\,\ Okayama",
"81593", "Yokkaichi\,\ Mie",
"811987", "Tono\,\ Iwate",
"81939", "Kitakyushu\,\ Fukuoka",
"817994", "Sumoto\,\ Hyogo",
"811586", "Nakayubetsu\,\ Hokkaido",
"81281", "Utsunomiya\,\ Tochigi",
"8167", "Osaka\,\ Osaka",
"819232", "Maebaru\,\ Fukuoka",
"81878", "Takamatsu\,\ Kagawa",
"81464", "Atsugi\,\ Kanagawa",
"811462", "Urakawa\,\ Hokkaido",
"81726", "Ibaraki\,\ Osaka",
"819686", "Tamana\,\ Kumamoto",
"811634", "Hamatonbetsu\,\ Hokkaido",
"812836", "Sano\,\ Tochigi",
"812564", "Sanjo\,\ Niigata",
"818205", "Yanai\,\ Yamaguchi",
"812678", "Saku\,\ Nagano",
"812485", "Shirakawa\,\ Fukushima",
"811853", "Oga\,\ Akita",
"819598", "Fukue\,\ Nagasaki",
"818377", "Shimonoseki\,\ Yamaguchi",
"817457", "Yamatotakada\,\ Nara",
"818872", "Muroto\,\ Kochi",
"812647", "Nagano\,\ Nagano",
"811541", "Teshikaga\,\ Hokkaido",
"81436", "Ichihara\,\ Chiba",
"81592", "Tsu\,\ Mie",
"811942", "Iwaizumi\,\ Iwate",
"819822", "Nobeoka\,\ Miyazaki",
"818555", "Gotsu\,\ Shimane",
"818583", "Kurayoshi\,\ Tottori",
"815755", "Sekigahara\,\ Gifu",
"811398", "Kumaishi\,\ Hokkaido",
"811732", "Goshogawara\,\ Aomori",
"811365", "Kutchan\,\ Hokkaido",
"81466", "Fujisawa\,\ Kanagawa",
"818677", "Niimi\,\ Okayama",
"81542", "Shizuoka\,\ Shizuoka",
"812544", "Shibata\,\ Niigata",
"8126178", "Omachi\,\ Nagano",
"8175", "Kyoto\,\ Kyoto",
"818512", "Nishigo\,\ Fukushima",
"812242", "Shiroishi\,\ Miyagi",
"81488", "Urawa\,\ Saitama",
"812784", "Numata\,\ Gunma",
"814756", "Togane\,\ Chiba",
"811527", "Bihoro\,\ Hokkaido",
"812378", "Sagae\,\ Yamagata",
"819785", "Bungotakada\,\ Oita",
"81191", "Ichinoseki\,\ Iwate",
"812613", "Omachi\,\ Nagano",
"81738", "Gobo\,\ Wakayama",
"811936", "Miyako\,\ Iwate",
"811537", "Nakashibetsu\,\ Hokkaido",
"811645", "Rumoi\,\ Hokkaido",
"81434", "Chiba\,\ Chiba",
"812382", "Yonezawa\,\ Yamagata",
"812619", "Omachi\,\ Nagano",
"81969", "Amakusa\,\ Kumamoto",
"818796", "Tonosho\,\ Kagawa",
"817494", "Hikone\,\ Shiga",
"817617", "Kaga\,\ Ishikawa",
"819979", "Tokunoshima\,\ Kagoshima",
"814772", "Ichikawa\,\ Chiba",
"8186697", "Kurashiki\,\ Okayama",
"814705", "Tateyama\,\ Chiba",
"81543", "Shizuoka\,\ Shizuoka",
"8112399", "Kuriyama\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"81936", "Kitakyushu\,\ Fukuoka",
"817964", "Toyooka\,\ Hyogo",
"811377", "Yakumo\,\ Hokkaido",
"8153973", "Hamamatsu\,\ Shizuoka",
"812233", "Iwanuma\,\ Miyagi",
"812472", "Ishikawa\,\ Fukushima",
"815566", "Minobu\,\ Yamanashi",
"812580", "Tokamachi\,\ Niigata",
"818665", "Takahashi\,\ Okayama",
"818698", "Bizen\,\ Okayama",
"817366", "Iwade\,\ Wakayama",
"818942", "Yawatahama\,\ Ehime",
"812839", "Sano\,\ Tochigi",
"811583", "Monbetsu\,\ Hokkaido",
"811555", "Obihiro\,\ Hokkaido",
"812914", "Hokota\,\ Ibaraki",
"81233", "Shinjo\,\ Yamagata",
"81729", "Yao\,\ Osaka",
"8125484", "Murakami\,\ Niigata",
"81835", "Hofu\,\ Yamaguchi",
"812239", "Sendai\,\ Miyagi",
"812892", "Utsunomiya\,\ Tochigi",
"817724", "Miyazu\,\ Kyoto",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819683", "Yamaga\,\ Kumamoto",
"811589", "Okoppe\,\ Hokkaido",
"812833", "Utsunomiya\,\ Tochigi",
"81178", "Hachinohe\,\ Aomori",
"815737", "Nakatsugawa\,\ Gifu",
"812488", "Sukagawa\,\ Fukushima",
"818462", "Takehara\,\ Hiroshima",
"812675", "Saku\,\ Nagano",
"812654", "Iida\,\ Nagano",
"811856", "Noshiro\,\ Akita",
"819940", "Shibushi\,\ Kagoshima",
"817734", "Fukuchiyama\,\ Kyoto",
"818558", "Kawamoto\,\ Shimane",
"81439", "Kisarazu\,\ Chiba",
"818808", "Tosashimizu\,\ Kochi",
"818586", "Kurayoshi\,\ Tottori",
"815978", "Kumano\,\ Mie",
"819952", "Okuchi\,\ Kagoshima",
"81585", "Ibigawa\,\ Gifu",
"811395", "Esashi\,\ Hokkaido",
"814281", "Sagamihara\,\ Kanagawa",
"8188097", "Tosashimizu\,\ Kochi",
"81550", "Gotenba\,\ Shizuoka",
"817944", "Kakogawa\,\ Hyogo",
"81934", "Kitakyushu\,\ Fukuoka",
"812375", "Murayama\,\ Yamagata",
"8198294", "Nobeoka\,\ Miyazaki",
"814753", "Mobara\,\ Chiba",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81262", "Nagano\,\ Nagano",
"812414", "Yanaizu\,\ Fukushima",
"812616", "Omachi\,\ Nagano",
"812697", "Iiyama\,\ Nagano",
"81797", "Nishinomiya\,\ Hyogo",
"819976", "Naze\,\ Kagoshima",
"81263", "Matsumoto\,\ Nagano",
"81988", "Naha\,\ Okinawa",
"811933", "Kamaishi\,\ Iwate",
"815982", "Matsusaka\,\ Mie",
"819577", "Shimabara\,\ Nagasaki",
"81775", "Otsu\,\ Shiga",
"81420", "Tokorozawa\,\ Saitama",
"819788", "Kunisaki\,\ Oita",
"812930", "Mito\,\ Ibaraki",
"81928", "Fukuoka\,\ Fukuoka",
"818398", "Ogori\,\ Yamaguchi",
"8186997", "Seto\,\ Okayama",
"818365", "Ube\,\ Yamaguchi",
"8112396", "Kuriyama\,\ Hokkaido",
"81480", "Kuki\,\ Saitama",
"817464", "Yoshino\,\ Nara",
"812571", "Muika\,\ Niigata",
"811939", "Miyako\,\ Iwate",
"81532", "Toyohashi\,\ Aichi",
"811465", "Shizunai\,\ Hokkaido",
"812659", "Ina\,\ Nagano",
"812898", "Kanuma\,\ Tochigi",
"818977", "Hakata\,\ Ehime",
"814280", "Tachikawa\,\ Tokyo",
"818948", "Uwajima\,\ Ehime",
"81177", "Aomori\,\ Aomori",
"812478", "Miharu\,\ Fukushima",
"811878", "Omagari\,\ Akita",
"818692", "Oku\,\ Okayama",
"812653", "Iida\,\ Nagano",
"817733", "Fukuchiyama\,\ Kyoto",
"812913", "Hokota\,\ Ibaraki",
"817969", "Hamasaka\,\ Hyogo",
"814797", "Yokaichiba\,\ Chiba",
"817723", "Miyazu\,\ Kyoto",
"81473", "Ichikawa\,\ Chiba",
"812834", "Utsunomiya\,\ Tochigi",
"819684", "Yamaga\,\ Kumamoto",
"812967", "Kasama\,\ Ibaraki",
"812566", "Sanjo\,\ Niigata",
"818552", "Hamada\,\ Shimane",
"819825", "Hyuga\,\ Miyazaki",
"811945", "Kuji\,\ Iwate",
"818202", "Yanai\,\ Yamaguchi",
"817963", "Toyooka\,\ Hyogo",
"81533", "Toyohashi\,\ Aichi",
"812234", "Sendai\,\ Miyagi",
"812482", "Shirakawa\,\ Fukushima",
"819937", "Kaseda\,\ Kagoshima",
"817996", "Tsuna\,\ Hyogo",
"811584", "Engaru\,\ Hokkaido",
"819679", "Takamori\,\ Kumamoto",
"819747", "Taketa\,\ Oita",
"81927", "Fukuoka\,\ Fukuoka",
"812245", "Ogawara\,\ Miyagi",
"81822", "Hiroshima\,\ Hiroshima",
"812419", "Tajima\,\ Fukushima",
"817463", "Yoshino\,\ Nara",
"81949", "Nogata\,\ Fukuoka",
"817496", "Nagahama\,\ Shiga",
"819437", "Tanushimaru\,\ Fukuoka",
"81563", "Nishio\,\ Aichi",
"81494", "Chichibu\,\ Saitama",
"815752", "Sekigahara\,\ Gifu",
"811735", "Goshogawara\,\ Aomori",
"811362", "Kutchan\,\ Hokkaido",
"812413", "Kitakata\,\ Fukushima",
"81798", "Nishinomiya\,\ Hyogo",
"811336", "Ishikari\,\ Hokkaido",
"81987", "Nichinan\,\ Miyazaki",
"811934", "Kamaishi\,\ Iwate",
"811867", "Takanosu\,\ Akita",
"817707", "Obama\,\ Fukui",
"815972", "Owase\,\ Mie",
"817943", "Kakogawa\,\ Hyogo",
"812385", "Yonezawa\,\ Yamagata",
"812786", "Numata\,\ Gunma",
"819542", "Takeo\,\ Saga",
"81250", "Niitsu\,\ Niigata",
"814754", "Mobara\,\ Chiba",
"814775", "Funabashi\,\ Chiba",
"814702", "Tateyama\,\ Chiba",
"81823", "Kure\,\ Hiroshima",
"819782", "Bungotakada\,\ Oita",
"817949", "Kakogawa\,\ Hyogo",
"81225", "Ishinomaki\,\ Miyagi",
"8112392", "Yubari\,\ Hokkaido",
"818477", "Tojo\,\ Hiroshima",
"817357", "Kushimoto\,\ Wakayama",
"812546", "Murakami\,\ Niigata",
"818297", "Hatsukaichi\,\ Hiroshima",
"81740", "Imazu\,\ Shiga",
"81276", "Ota\,\ Gunma",
"818387", "Tamagawa\,\ Yamaguchi",
"812895", "Utsunomiya\,\ Tochigi",
"818584", "Kurayoshi\,\ Tottori",
"8153968", "Hamamatsu\,\ Shizuoka",
"8125487", "Tsugawa\,\ Niigata",
"818662", "Takahashi\,\ Okayama",
"812656", "Ina\,\ Nagano",
"811875", "Kakunodate\,\ Akita",
"811854", "Oga\,\ Akita",
"812475", "Ishikawa\,\ Fukushima",
"81944", "Setaka\,\ Fukuoka",
"81292", "Mito\,\ Ibaraki",
"817736", "Maizuru\,\ Kyoto",
"811552", "Obihiro\,\ Hokkaido",
"818945", "Yawatahama\,\ Ehime",
"81877", "Marugame\,\ Kagawa",
"819828", "Takachiho\,\ Miyazaki",
"812997", "Itako\,\ Ibaraki",
"818247", "Shobara\,\ Hiroshima",
"819676", "Takamori\,\ Kumamoto",
"812563", "Sanjo\,\ Niigata",
"815367", "Shitara\,\ Aichi",
"819592", "Oseto\,\ Nagasaki",
"811757", "Noheji\,\ Aomori",
"812672", "Komoro\,\ Nagano",
"817993", "Sumoto\,\ Hyogo",
"811977", "Kitakami\,\ Iwate",
"812372", "Murayama\,\ Yamagata",
"817466", "Totsukawa\,\ Nara",
"817493", "Hikone\,\ Shiga",
"81946", "Amagi\,\ Fukuoka",
"812877", "Kuroiso\,\ Tochigi",
"812248", "Ogawara\,\ Miyagi",
"8153970", "Hamamatsu\,\ Shizuoka",
"812614", "Omachi\,\ Nagano",
"812416", "Tajima\,\ Fukushima",
"811333", "Tobetsu\,\ Hokkaido",
"81243", "Nihonmatsu\,\ Fukushima",
"81737", "Yuasa\,\ Wakayama",
"819974", "Yakushima\,\ Kagoshima",
"819955", "Kajiki\,\ Kagoshima",
"81183", "Yuzawa\,\ Akita",
"8198297", "Hyuga\,\ Miyazaki",
"81557", "Ito\,\ Shizuoka",
"81845", "Innoshima\,\ Hiroshima",
"811392", "Kikonai\,\ Hokkaido",
"817946", "Miki\,\ Hyogo",
"818362", "Ube\,\ Yamaguchi",
"81487", "Urawa\,\ Saitama",
"812783", "Numata\,\ Gunma",
"815959", "Kameyama\,\ Mie",
"812549", "Tsugawa\,\ Niigata",
"812388", "Nagai\,\ Yamagata",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81182", "Yokote\,\ Akita",
"8186994", "Seto\,\ Okayama",
"8128798", "Otawara\,\ Tochigi",
"812789", "Maebashi\,\ Gunma",
"8153971", "Hamamatsu\,\ Shizuoka",
"818687", "Mimasaka\,\ Okayama",
"815985", "Matsusaka\,\ Mie",
"8153975", "Hamamatsu\,\ Shizuoka",
"812543", "Shibata\,\ Niigata",
"81427", "Sagamihara\,\ Kanagawa",};
$areanames{ja} = {"81438", "木更津",
"819944", "鹿屋",
"814289", "青梅",
"812247", "大河原",
"819803", "名護",
"81179", "三戸",
"819553", "伊万里",
"817705", "小浜",
"818672", "福渡",
"811865", "大館",
"81578", "神岡",
"817952", "西脇",
"81930", "行橋",
"812573", "柏崎",
"819666", "水俣",
"814777", "船橋",
"81728", "寝屋川",
"817612", "小松",
"815589", "修善寺大仁",
"818895", "須崎",
"817960", "八鹿",
"815743", "美濃加茂",
"81766", "高岡",
"8112393", "夕張",
"81484", "川口",
"812744", "藤岡",
"81929", "福岡",
"818388", "田万川",
"818549", "石見大田",
"818975", "新居浜",
"81947", "田川",
"817683", "輪島",
"817476", "下市",
"819964", "川内",
"8198298", "日向",
"819827", "高千穂",
"811947", "久慈",
"818877", "嶺北",
"8165", "大阪",
"81486", "浦和",
"814795", "銚子",
"817915", "相生",
"819935", "加世田",
"81245", "福島",
"815395", "浜松",
"815368", "設楽",
"817940", "加古川",
"818848", "牟岐",
"811353", "余市",
"814291", "飯能",
"811978", "北上",
"81764", "富山",
"815763", "下呂",
"818834", "鴨島",
"811454", "鵡川",
"812854", "小山",
"8147950", "八日市場",
"819806", "沖縄宮古",
"819556", "唐津",
"811868", "鷹巣",
"81176", "十和田",
"81924", "福岡",
"81535", "浜松",
"812576", "十日町",
"819663", "人吉",
"815746", "美濃加茂",
"815987", "三瀬谷",
"81885", "小松島",
"814227", "武蔵野三鷹",
"81143", "室蘭",
"817686", "能都",
"817473", "五条",
"818385", "萩",
"818978", "伯方",
"81174", "蟹田",
"81926", "福岡",
"818947", "宇和",
"811877", "大曲",
"812477", "三春",
"81460", "小田原",
"814798", "八日市場",
"81489", "草加",
"812794", "渋川",
"81282", "栃木",
"811549", "釧路",
"81142", "伊達",
"811975", "水沢",
"818845", "丹生谷",
"815398", "浜松",
"815732", "恵那",
"811356", "岩内",
"812780", "前橋",
"815766", "下呂",
"819938", "加世田",
"817702", "敦賀",
"818675", "久世",
"811862", "鹿角",
"81832", "下関",
"812746", "富岡",
"81937", "北九州",
"817955", "三田",
"819664", "人吉",
"811647", "羽幌",
"8199347", "鹿児島",
"819787", "国東",
"814707", "大原",
"818833", "鴨島",
"819946", "鹿屋",
"817615", "小松",
"812853", "小山",
"811453", "早来",
"818892", "佐川",
"81235", "鶴岡",
"81833", "下松",
"818697", "備前",
"8188098", "土佐清水",
"818972", "新居浜",
"81940", "宗像",
"81582", "岐阜",
"812793", "渋川",
"817238", "寝屋川",
"81583", "岐阜",
"817912", "相生",
"819932", "指宿",
"8112390", "夕張",
"815392", "浜松",
"81157", "北見",
"815738", "中津川",
"819966", "出水",
"818557", "川本",
"8186998", "岡山瀬戸",
"818807", "宿毛",
"817474", "五条",
"814792", "銚子",
"817958", "丹波柏原",
"81998", "鹿児島",
"812589", "長岡",
"812830", "宇都宮",
"812743", "藤岡",
"818678", "新見",
"812574", "柏崎",
"812377", "寒河江",
"815744", "美濃加茂",
"819804", "名護",
"819554", "伊万里",
"818836", "脇町",
"819943", "鹿屋",
"812856", "真岡",
"811456", "門別富川",
"817618", "加賀",
"811557", "十勝池田",
"818667", "井原",
"81467", "藤沢",
"811354", "余市",
"8126177", "長野",
"815764", "下呂",
"81952", "佐賀",
"81857", "鳥取",
"81545", "富士",
"812796", "渋川",
"818382", "萩",
"811972", "水沢",
"81531", "田原",
"818842", "阿南",
"812939", "水戸",
"819963", "川内",
"811752", "むつ",
"815362", "新城",
"815735", "恵那",
"812911", "鉾田",
"817684", "輪島",
"81471", "柏",
"8186698", "倉敷",
"819557", "唐津",
"819807", "沖縄宮古",
"812243", "白石",
"817498", "長浜",
"817465", "吉野",
"819972", "種子島",
"81587", "一宮",
"815986", "松阪",
"81266", "諏訪",
"8182942", "広島",
"812389", "米沢",
"812612", "大町",
"81228", "築館",
"815958", "亀山",
"812577", "六日町",
"815747", "美濃白川",
"812374", "村山",
"811876", "大曲",
"812655", "飯田",
"812476", "三春",
"815562", "鰍沢青柳",
"817735", "福知山",
"817362", "和歌山橋本",
"818946", "宇和",
"81551", "韮崎",
"81933", "北九州",
"814226", "武蔵野三鷹",
"817687", "能都",
"818664", "高梁",
"811554", "帯広",
"815767", "下呂",
"811357", "岩内",
"818873", "安芸",
"818290", "広島",
"817725", "宮津",
"819675", "熊本一の宮",
"818582", "倉吉",
"811943", "岩泉",
"819823", "延岡",
"811638", "利尻礼文",
"81932", "北九州",
"812568", "巻",
"811644", "留萌",
"8153977", "天竜",
"8164", "大阪",
"819784", "豊後高田",
"81463", "平塚",
"817495", "長浜",
"817468", "上北山",
"81594", "桑名",
"81280", "古河",
"814704", "館山",
"81853", "出雲",
"812246", "大河原",
"811932", "釜石",
"81852", "松江",
"8198295", "日向",
"815955", "上野",
"815983", "松阪",
"812545", "村上",
"8198291", "延岡",
"812979", "竜ケ崎",
"818240", "東広島",
"819667", "水俣",
"814776", "船橋",
"81462", "厚木",
"811873", "角館",
"812473", "石川",
"8125480", "村上",
"81596", "伊勢",
"811582", "紋別",
"818943", "八幡浜",
"817738", "舞鶴",
"812658", "伊那",
"812899", "鹿沼",
"812232", "岩沼",
"814223", "武蔵野三鷹",
"818804", "土佐中村",
"818554", "浜田",
"818694", "岡山",
"818876", "土佐山田",
"81898", "今治",
"811635", "浜頓別",
"818680", "岡山",
"812565", "三条",
"811946", "久慈",
"819826", "日向",
"8124197", "柳津",
"819678", "矢部",
"817728", "峰山",
"815979", "熊野",
"8186691", "倉敷",
"812955", "常陸大宮",
"812376", "寒河江",
"81569", "半田",
"81126", "岩見沢",
"8186552", "倉敷",
"815984", "松阪",
"81425", "立川",
"812857", "真岡",
"811457", "門別富川",
"818837", "阿波池田",
"814703", "館山",
"819975", "名瀬",
"81942", "久留米",
"811643", "石狩深川",
"81294", "常陸太田",
"812640", "長野",
"81555", "吉田",
"819783", "豊後高田",
"811938", "宮古",
"812615", "大町",
"812797", "渋川",
"815565", "鰍沢青柳",
"812652", "飯田",
"812238", "仙台",
"818666", "井原",
"817365", "和歌山橋本",
"817732", "福知山",
"811556", "帯広",
"811588", "興部",
"81124", "芦別",
"818693", "邑久",
"814224", "武蔵野三鷹",
"818803", "土佐中村",
"812489", "須賀川",
"817722", "宮津",
"819672", "熊本一の宮",
"818553", "浜田",
"818585", "倉吉",
"812474", "石川",
"814298", "飯能",
"811874", "角館",
"818944", "八幡浜",
"817492", "彦根",
"81566", "刈谷",
"8186995", "岡山瀬戸",
"812373", "村山",
"8125483", "村上",
"812747", "富岡",
"819947", "志布志",
"814706", "大原",
"818514", "海士",
"812244", "白石",
"8178", "神戸",
"812618", "大町",
"81985", "宮崎",
"811935", "釜石",
"811646", "羽幌",
"815952", "上野",
"8188091", "窪川",
"812542", "新発田",
"81778", "武生",
"81950", "平戸",
"8188095", "土佐清水",
"818369", "宇部",
"819786", "杵築",
"819978", "徳之島",
"818874", "安芸",
"811944", "岩泉",
"819824", "延岡",
"8163", "大阪",
"81493", "東松山",
"81979", "中津",
"81564", "岡崎",
"812550", "安塚",
"818663", "総社",
"811585", "遠軽",
"811553", "帯広",
"817368", "岩出",
"812235", "仙台",
"8183766", "下関",
"818696", "備前",
"812679", "佐久",
"818806", "宿毛",
"811632", "天塩",
"818556", "江津",
"812562", "三条",
"818588", "郡家",
"819599", "大瀬戸",
"819967", "出水",
"81492", "川越",
"819785", "豊後高田",
"81191", "一関",
"812613", "大町",
"81738", "御坊",
"819973", "種子島",
"811936", "宮古",
"811645", "留萌",
"817494", "彦根",
"817617", "加賀",
"814772", "市川",
"814705", "館山",
"817957", "丹波柏原",
"81466", "藤沢",
"818677", "新見",
"815954", "上野",
"812544", "新発田",
"818512", "西郷",
"812242", "白石",
"812378", "寒河江",
"818872", "室戸",
"818805", "土佐中村",
"81592", "津",
"811942", "岩泉",
"819822", "延岡",
"818555", "江津",
"818583", "倉吉",
"811558", "広尾",
"812236", "仙台",
"818668", "井原",
"818695", "岡山瀬戸",
"815563", "鰍沢青柳",
"81593", "四日市",
"81939", "北九州",
"817363", "和歌山橋本",
"811586", "中湧別",
"8167", "大阪",
"81464", "厚木",
"811634", "浜頓別",
"812564", "三条",
"812616", "大町",
"811648", "焼尻",
"81797", "西宮",
"81263", "松本",
"819976", "名瀬",
"811933", "釜石",
"81988", "那覇",
"815982", "松阪",
"81775", "大津",
"819788", "国東",
"812930", "水戸",
"814708", "大原",
"81480", "久喜",
"817464", "吉野",
"812571", "六日町",
"81934", "北九州",
"812375", "村山",
"8198294", "延岡",
"812956", "常陸大宮",
"81262", "長野",
"815737", "中津川",
"812654", "飯田",
"817734", "福知山",
"818558", "川本",
"818808", "土佐清水",
"818586", "倉吉",
"81936", "北九州",
"812233", "岩沼",
"815566", "身延",
"812472", "石川",
"812580", "十日町",
"818665", "高梁",
"818698", "備前",
"817366", "岩出",
"812839", "佐野",
"818942", "八幡浜",
"811555", "帯広",
"811583", "紋別",
"812914", "鉾田",
"814222", "武蔵野三鷹",
"8183768", "下関",
"817724", "宮津",
"819674", "熊本一の宮",
"814775", "船橋",
"814702", "館山",
"81823", "呉",
"819782", "豊後高田",
"817949", "加古川",
"81225", "石巻",
"815988", "三瀬谷",
"81562", "尾張横須賀",
"811642", "石狩深川",
"815956", "上野",
"812546", "村上",
"81927", "福岡",
"812245", "大河原",
"812419", "田島",
"817463", "吉野",
"81822", "広島",
"81949", "直方",
"817496", "長浜",
"81563", "西尾",
"81494", "秩父",
"811934", "釜石",
"811867", "鷹巣",
"817707", "小浜",
"817969", "浜坂",
"812913", "鉾田",
"814797", "八日市場",
"818875", "土佐山田",
"818802", "窪川",
"817723", "宮津",
"811636", "北見枝幸",
"819673", "熊本一の宮",
"818552", "浜田",
"812566", "三条",
"811945", "久慈",
"819825", "日向",
"812234", "仙台",
"815397", "浜松",
"819937", "加世田",
"811584", "遠軽",
"817917", "竜野",
"814228", "武蔵野三鷹",
"818977", "伯方",
"814280", "立川",
"81177", "青森",
"818948", "宇和",
"812478", "三春",
"811878", "大曲",
"818692", "邑久",
"812653", "飯田",
"817733", "福知山",
"81487", "浦和",
"8186994", "岡山瀬戸",
"812789", "前橋",
"815985", "松阪",
"815953", "上野",
"812543", "新発田",
"812372", "村山",
"817466", "十津川",
"817493", "彦根",
"81946", "甘木",
"8188094", "窪川",
"812248", "大河原",
"812614", "大町",
"819974", "屋久島",
"819828", "高千穂",
"81877", "丸亀",
"818878", "嶺北",
"817726", "峰山",
"819676", "高森",
"812563", "三条",
"815367", "設楽",
"811757", "野辺地",
"815564", "鰍沢青柳",
"818847", "牟岐",
"817364", "和歌山橋本",
"811977", "北上",
"818387", "田万川",
"814225", "武蔵野三鷹",
"818584", "倉吉",
"8125487", "津川",
"811875", "角館",
"812656", "伊那",
"818662", "高梁",
"812475", "石川",
"81944", "瀬高",
"81292", "水戸",
"817736", "舞鶴",
"811552", "帯広",
"818945", "八幡浜",
"819948", "志布志",
"815742", "美濃加茂",
"81172", "弘前",
"812572", "柏崎",
"818835", "脇町",
"817613", "小松",
"812855", "小山",
"811539", "根室標津",
"811455", "鵡川",
"812617", "大町",
"819977", "瀬戸内",
"812957", "大子",
"817953", "西脇",
"81284", "足利",
"819802", "南大東",
"81144", "苫小牧",
"819552", "伊万里",
"818673", "福渡",
"812748", "富岡",
"818384", "萩",
"818587", "郡家",
"81827", "岩国",
"819968", "出水",
"815736", "中津川",
"817459", "大和榛原",
"81849", "福山",
"81922", "福岡",
"811352", "余市",
"8112397", "栗山",
"815762", "下呂",
"8186996", "岡山瀬戸",
"812649", "長野",
"815999", "津",
"817682", "輪島",
"81721", "富田林",
"81923", "福岡",
"8188096", "土佐清水",
"81286", "宇都宮",
"81567", "津島",
"812795", "渋川",
"811754", "むつ",
"8153963", "天竜",
"8182941", "広島",
"811974", "水沢",
"817367", "岩出",
"818844", "阿南",
"81763", "福野",
"812858", "真岡",
"818838", "阿波池田",
"819662", "人吉",
"819945", "鹿屋",
"814771", "市川",
"817616", "小松",
"817704", "敦賀",
"811864", "大館",
"811937", "宮古",
"818894", "須崎",
"81977", "別府",
"812745", "藤岡",
"817956", "三田",
"81762", "金沢",
"812559", "安塚",
"818676", "久世",
"818974", "新居浜",
"814297", "飯能",
"815733", "恵那",
"818360", "小郡",
"81260", "阿南町",
"8186999", "岡山瀬戸",
"819965", "川内",
"817472", "五条",
"812798", "長野原",
"814794", "銚子",
"8188099", "土佐清水",
"81548", "榛原",
"812237", "仙台",
"81482", "川口",
"817914", "相生",
"811587", "中湧別",
"8198292", "延岡",
"819934", "指宿",
"815394", "浜松",
"818893", "佐川",
"815745", "美濃加茂",
"818490", "尾道",
"819668", "水俣",
"812575", "十日町",
"818832", "鴨島",
"818299", "広島",
"81725", "和泉",
"818479", "東城",
"811452", "早来",
"812852", "小山",
"81839", "山口",
"8153960", "天竜",
"819805", "名護",
"819555", "唐津",
"817703", "敦賀",
"811863", "鹿角",
"811756", "野辺地",
"815366", "設楽",
"8199343", "鹿児島",
"815765", "下呂",
"81956", "佐世保",
"819933", "指宿",
"81188", "秋田",
"811976", "北上",
"818846", "丹生谷",
"815393", "浜松",
"814793", "銚子",
"812917", "水戸",
"819677", "矢部",
"817727", "峰山",
"815734", "恵那",
"817737", "舞鶴",
"812657", "伊那",
"811551", "十勝池田",
"813", "東京",
"817685", "輪島",
"81134", "小樽",
"818973", "新居浜",
"812792", "渋川",
"8198296", "日向",
"817954", "西脇",
"812547", "村上",
"815957", "上野",
"818674", "久世",
"818896", "須崎",
"812578", "六日町",
"815748", "美濃白川",
"819665", "人吉",
"818689", "岡山",
"819942", "大根占",
"81584", "大垣",
"814701", "鴨川",
"819558", "唐津",
"812742", "藤岡",
"819808", "八重山",
"81538", "磐田",
"812890", "宇都宮",
"812879", "烏山",
"817706", "小浜",
"811866", "鷹巣",
"8147957", "八日市場",
"817614", "小松",
"817497", "長浜",
"81478", "佐原",
"811753", "むつ",
"81834", "徳山",
"815363", "新城",
"81793", "姫路",
"812999", "潮来",
"818249", "東広島",
"817916", "竜野",
"815768", "下呂",
"819936", "加世田",
"811973", "水沢",
"818843", "阿南",
"81586", "一宮",
"815396", "浜松",
"819962", "川内",
"8186992", "備前",
"814796", "八日市場",
"812567", "巻",
"811637", "北見枝幸",
"8162", "大阪",
"8188092", "窪川",
"817475", "下市",
"8198299", "日向",
"81792", "姫路",
"818383", "萩",
"81888", "高知",
"818976", "新居浜",
"817688", "能都",
"81965", "八代",
"81554", "大月",
"818563", "益田",
"81893", "大洲",
"819809", "八重山",
"811522", "斜里",
"81734", "和歌山",
"819435", "八女",
"811653", "士別",
"812878", "烏山",
"81277", "桐生",
"818596", "米子",
"814283", "青梅",
"8125488", "津川",
"8152", "名古屋",
"811737", "鰺ケ沢",
"817904", "福崎",
"812584", "長岡",
"81424", "武蔵野三鷹",
"811234", "千歳",
"812387", "長井",
"818295", "廿日市",
"811566", "十勝清水",
"812579", "小出",
"818268", "千代田",
"817355", "新宮",
"81892", "久万",
"811532", "根室",
"818475", "府中",
"815583", "下田",
"818656", "笠岡",
"81975", "大分",
"818688", "美作",
"8145", "横浜",
"8124196", "柳津",
"818954", "宇和島",
"812934", "高萩",
"817674", "羽咋",
"819724", "佐伯",
"818543", "安来",
"811982", "花巻",
"81989", "那覇",
"815992", "鳥羽",
"812998", "潮来",
"818248", "庄原",
"811546", "釧路",
"812965", "下館",
"812642", "木曾福島",
"814994", "三宅",
"8111", "札幌",
"817452", "大和高田",
"81125", "滝川",
"815769", "荘川",
"818372", "長門",
"81426", "八王子",
"81468", "横須賀",
"819734", "日田",
"817714", "亀岡",
"812552", "上越",
"81192", "大船渡",
"81984", "小林",
"812875", "大田原",
"811656", "美深",
"819438", "田主丸",
"818593", "米子",
"814286", "相模原",
"819957", "加治木",
"812977", "竜ケ崎",
"8147955", "八日市場",
"811563", "本別",
"819572", "諫早",
"815586", "下田",
"818685", "津山",
"812560", "糸魚川",
"812692", "中野",
"818478", "東城",
"81938", "北九州",
"818298", "廿日市",
"818265", "安芸吉田",
"812897", "鹿沼",
"817484", "八日市",
"818546", "掛合",
"81986", "都城",
"81739", "田辺",
"81825", "広島",
"811372", "鹿部",
"81591", "津",
"81559", "沼津",
"811543", "釧路",
"81565", "豊田",
"81222", "仙台",
"812995", "石岡",
"818245", "三次",
"812968", "笠間",
"811954", "二戸",
"818467", "木江",
"81429", "所沢",
"811564", "上士幌",
"815977", "熊野",
"818654", "鴨方",
"811367", "寿都",
"815757", "郡上八幡",
"812586", "長岡",
"811525", "網走",
"819432", "八女",
"811236", "千歳",
"8183767", "下関",
"812558", "新井",
"81270", "伊勢崎",
"819742", "三重",
"818292", "広島",
"817352", "新宮",
"811535", "厚岸",
"812698", "飯山",
"812859", "小山",
"818472", "甲山",
"819578", "島原",
"817906", "播磨山崎",
"818397", "小郡",
"819547", "鹿島",
"818594", "米子",
"811378", "今金",
"811953", "二戸",
"812799", "長野原",
"81863", "玉野",
"817716", "園部",
"8112391", "夕張",
"815995", "阿児",
"81744", "大和高田",
"8112395", "栗山",
"811544", "釧路",
"814996", "八丈島",
"814240", "国分寺",
"812487", "須賀川",
"818207", "久賀",
"81862", "岡山",
"818956", "宇和島",
"812962", "下館",
"812645", "木曾福島",
"812936", "水戸",
"817455", "大和高田",
"817483", "八日市",
"817676", "七尾",
"81259", "佐渡",
"818375", "美祢",
"819726", "臼杵",
"811397", "奥尻",
"815584", "下田",
"812555", "糸魚川",
"812583", "長岡",
"81727", "池田",
"812872", "大田原",
"81561", "瀬戸",
"811233", "千歳",
"812230", "仙台",
"811528", "美幌",
"819575", "諫早",
"814284", "立川",
"818682", "津山",
"819949", "大根占",
"812695", "中野",
"811538", "根室標津",
"81577", "高山",
"818262", "加計",
"817903", "福崎",
"818564", "益田",
"811654", "名寄",
"819204", "郷ノ浦",
"818367", "宇部",
"81162", "稚内",
"811956", "岩手",
"815998", "阿児",
"819733", "日田",
"8182920", "廿日市",
"817713", "亀岡",
"811375", "八雲",
"818544", "木次",
"812677", "佐久",
"819597", "福江",
"818378", "下関",
"818953", "宇和島",
"819969", "中甑",
"817458", "大和榛原",
"812933", "高萩",
"81948", "飯塚",
"817486", "水口",
"812648", "長野",
"817673", "羽咋",
"812992", "石岡",
"818242", "東広島",
"819723", "佐伯",
"819956", "加治木",
"81962", "熊本",
"814287", "青梅",
"811733", "五所川原",
"812415", "柳津",
"81234", "酒田",
"812551", "上越",
"818567", "津和野",
"818364", "宇部",
"815587", "修善寺大仁",
"811394", "松前",
"812788", "前橋",
"81963", "熊本",
"812976", "竜ケ崎",
"81288", "今市",
"817945", "加古川",
"812383", "米沢",
"81549", "静岡",
"812674", "小諸",
"818547", "掛合",
"819594", "有川",
"811463", "浦河",
"819233", "前原",
"812896", "鹿沼",
"81236", "山形",
"811852", "男鹿",
"818466", "木江",
"818879", "室戸",
"817998", "津名",
"817965", "豊岡",
"818493", "尾道",
"812418", "会津山口",
"819953", "大口",
"81848", "尾道",
"811736", "五所川原",
"81220", "迫",
"8198290", "延岡",
"819544", "武雄",
"814752", "茂原",
"818597", "根雨",
"818657", "笠岡",
"815974", "尾鷲",
"811567", "十勝清水",
"815754", "関",
"811364", "倶知安",
"818792", "三本松",
"81546", "静岡",
"812973", "水海道",
"81167", "富良野",
"817948", "三木",
"812386", "長井",
"812785", "沼田",
"812484", "白河",
"814229", "武蔵野三鷹",
"81432", "千葉",
"818204", "柳井",
"8188093", "窪川",
"811466", "えりも",
"812832", "佐野",
"818949", "宇和",
"819682", "山鹿",
"81723", "堺",
"8144", "川崎",
"812893", "宇都宮",
"81572", "多治見",
"81544", "富士宮",
"818463", "竹原",
"81722", "堺",
"817995", "洲本",
"817968", "浜坂",
"8125481", "村上",
"8125485", "津川",
"81433", "千葉",
"8169", "大阪",
"8186993", "備前",
"811547", "白糠",
"812974", "水海道",
"814758", "東金",
"81485", "熊谷",
"815973", "尾鷲",
"811396", "江差",
"81246", "いわき",
"81958", "長崎",
"815753", "関",
"811363", "倶知安",
"812412", "喜多方",
"819543", "武雄",
"819789", "杵築",
"817942", "加古川",
"818366", "宇部",
"818798", "土庄",
"819954", "加治木",
"814709", "鴨川",
"81244", "原町",
"81992", "鹿児島",
"8161", "大阪",
"81184", "本荘",
"812838", "佐野",
"819688", "玉名",
"81875", "観音寺",
"81765", "魚津",
"817950", "三田",
"81273", "高崎",
"818464", "竹原",
"8153962", "天竜",
"811957", "岩手",
"817487", "水口",
"812894", "宇都宮",
"812483", "白河",
"812676", "佐久",
"811855", "能代",
"818559", "川本",
"81272", "前橋",
"817962", "豊岡",
"818203", "柳井",
"819596", "福江",
"81138", "函館",
"814755", "東金",
"8153974", "天竜",
"812587", "長岡",
"812384", "米沢",
"811237", "栗山",
"811393", "松前",
"817230", "寝屋川",
"815756", "郡上八幡",
"811366", "寿都",
"81249", "郡山",
"8188090", "窪川",
"81227", "仙台",
"811332", "当別",
"818795", "三本松",
"819546", "鹿島",
"81886", "徳島",
"81925", "福岡",
"818363", "宇部",
"81534", "浜松",
"812782", "沼田",
"81474", "船橋",
"8112398", "栗山",
"8166", "大阪",
"817907", "播磨山崎",
"811734", "五所川原",
"818669", "総社",
"811559", "帯広",
"819685", "玉名",
"812835", "佐野",
"8198293", "延岡",
"817717", "園部",
"819737", "玖珠",
"812937", "水戸",
"811464", "静内",
"81476", "成田",
"818957", "御荘",
"819727", "臼杵",
"817677", "七尾",
"812486", "須賀川",
"812673", "小諸",
"817992", "洲本",
"818206", "柳井",
"811858", "能代",
"819913", "硫黄島",
"819593", "大瀬戸",
"811537", "中標津",
"81434", "千葉",
"812382", "米沢",
"812619", "大町",
"81969", "天草",
"818796", "土庄",
"819979", "徳之島",
"8186697", "倉敷",
"81543", "静岡",
"8112399", "栗山",
"818368", "宇部",
"811398", "熊石",
"815755", "関",
"811732", "五所川原",
"811365", "倶知安",
"81542", "静岡",
"81724", "岸和田貝塚",
"8175", "京都",
"812784", "沼田",
"81488", "浦和",
"811527", "美幌",
"814756", "東金",
"818205", "柳井",
"812678", "佐久",
"812485", "白河",
"819598", "福江",
"811853", "男鹿",
"818377", "下関",
"817457", "大和高田",
"812647", "長野",
"811541", "弟子屈",
"81436", "市原",
"815997", "阿児",
"817994", "洲本",
"811987", "遠野",
"81281", "宇都宮",
"819232", "前原",
"81878", "高松",
"811462", "浦河",
"81726", "茨木",
"819686", "玉名",
"812836", "佐野",
"812414", "柳津",
"812697", "飯山",
"819577", "島原",
"81420", "所沢",
"81928", "福岡",
"818398", "小郡",
"818365", "宇部",
"8186997", "岡山瀬戸",
"8112396", "栗山",
"818793", "三本松",
"811939", "宮古",
"812972", "水海道",
"815978", "熊野",
"819952", "大口",
"81585", "揖斐川",
"815758", "郡上八幡",
"811395", "江差",
"814281", "相模原",
"8188097", "土佐清水",
"81550", "御殿場",
"817944", "加古川",
"814753", "茂原",
"812557", "新井",
"81178", "八戸",
"819595", "有川",
"812488", "須賀川",
"818462", "竹原",
"812675", "佐久",
"811856", "能代",
"81964", "松橋",
"819940", "志布志",
"818208", "久賀",
"81439", "木更津",
"817964", "豊岡",
"811377", "八雲",
"81233", "新庄",
"81729", "八尾",
"8125484", "村上",
"812239", "仙台",
"81835", "防府",
"812892", "宇都宮",
"819683", "山鹿",
"811589", "興部",
"812833", "宇都宮",
"817943", "加古川",
"812978", "竜ケ崎",
"812385", "米沢",
"812786", "沼田",
"819542", "武雄",
"81250", "新津",
"814754", "茂原",
"8112392", "夕張",
"818477", "東城",
"817357", "串本",
"818297", "廿日市",
"819747", "竹田",
"819437", "田主丸",
"818794", "三本松",
"815752", "関",
"811362", "倶知安",
"811735", "五所川原",
"812413", "喜多方",
"81798", "西宮",
"811336", "石狩",
"81987", "日南",
"815972", "尾鷲",
"81473", "市川",
"812834", "宇都宮",
"819684", "山鹿",
"812967", "笠間",
"818202", "柳井",
"817963", "豊岡",
"81533", "豊橋",
"812570", "小出",
"812482", "白河",
"817996", "津名",
"819679", "高森",
"81532", "豊橋",
"811465", "静内",
"812898", "鹿沼",
"812659", "伊那",
"817946", "三木",
"818362", "宇部",
"812783", "沼田",
"815959", "亀山",
"812975", "水海道",
"812549", "津川",
"81242", "会津若松",
"812388", "長井",
"81182", "横手",
"818267", "千代田",
"8128798", "大田原",
"818687", "美作",
"81427", "相模原",
"812877", "黒磯",
"812416", "田島",
"811333", "当別",
"81243", "二本松",
"81183", "湯沢",
"819955", "加治木",
"81737", "湯浅",
"8198297", "日向",
"81845", "因島",
"81557", "伊東",
"811392", "木古内",
"811738", "鰺ケ沢",
"818247", "庄原",
"812997", "潮来",
"817966", "八鹿",
"819592", "大瀬戸",
"819912", "中之島",
"81581", "高富",
"812672", "小諸",
"812569", "巻",
"817993", "洲本",
"811639", "利尻礼文",
"81740", "今津",
"81276", "太田",
"812895", "宇都宮",
"811854", "男鹿",
"81495", "本庄",
"812874", "大田原",
"812696", "飯山",
"81537", "掛川",
"817908", "播磨山崎",
"811533", "根室",
"819576", "島原",
"81196", "盛岡",
"815582", "下田",
"81899", "松山",
"812588", "長岡",
"817959", "三田",
"818690", "岡山",
"818562", "益田",
"812556", "糸魚川",
"811523", "斜里",
"818679", "新見",
"811238", "栗山",
"811652", "士別",
"8186553", "倉敷",
"818264", "安芸吉田",
"8199345", "鹿児島",
"814282", "青梅",
"818684", "津山",
"817485", "八日市",
"817453", "大和高田",
"812938", "水戸",
"818373", "長門",
"818958", "御荘",
"819728", "臼杵",
"817678", "七尾",
"812643", "木曾福島",
"814700", "鴨川",
"811857", "能代",
"814998", "小笠原",
"812994", "石岡",
"818244", "三次",
"81226", "気仙沼",
"815993", "鳥羽",
"811376", "八雲",
"81983", "高鍋",
"811955", "二戸",
"811983", "花巻",
"81268", "上田",
"818542", "安来",
"819738", "玖珠",
"817718", "園部",
"819744", "三重",
"818797", "土庄",
"819434", "八女",
"812693", "中野",
"81199", "盛岡",
"817905", "福崎",
"811562", "本別",
"811536", "厚岸",
"819573", "諫早",
"818652", "倉敷",
"811235", "夕張",
"818592", "米子",
"812585", "長岡",
"818660", "岡山瀬戸",
"812553", "上越",
"814757", "東金",
"811526", "網走",
"81896", "伊予三島",
"8125482", "村上",
"818294", "廿日市",
"817354", "新宮",
"818474", "府中",
"817456", "大和高田",
"817675", "七尾",
"818376", "美祢",
"819725", "佐伯",
"81552", "甲府",
"818955", "宇和島",
"811542", "釧路",
"812646", "長野",
"817488", "水口",
"812935", "水戸",
"81423", "国分寺",
"819687", "玉名",
"812964", "下館",
"812837", "佐野",
"819735", "日田",
"817715", "亀岡",
"815996", "阿児",
"811958", "岩手",
"811986", "遠野",
"81229", "古川",
"81553", "山梨",
"817239", "寝屋川",
"818266", "千代田",
"8182943", "広島",
"818293", "廿日市",
"817353", "新宮",
"818473", "甲山",
"815585", "下田",
"8153961", "天竜",
"818686", "津山",
"817947", "三木",
"812554", "上越",
"812694", "中野",
"812417", "会津山口",
"819574", "諫早",
"814285", "相模原",
"819205", "厳原",
"8125486", "津川",
"819743", "三重",
"818565", "益田",
"818598", "根雨",
"811869", "大館",
"81298", "土浦",
"812876", "黒磯",
"819433", "八女",
"811655", "名寄",
"81465", "小田原",
"811374", "森",
"817967", "八鹿",
"814770", "市川",
"817482", "八日市",
"812996", "潮来",
"818246", "三次",
"8112394", "夕張",
"811548", "弟子屈",
"81253", "新潟",
"81166", "旭川",
"812963", "下館",
"81547", "島田",
"815399", "天竜",
"81779", "大野",
"818545", "木次",
"811952", "二戸",
"81252", "新潟",
"815588", "修善寺大仁",
"81935", "北九州",
"818263", "加計",
"817902", "福崎",
"81742", "奈良",
"818296", "広島",
"8199331", "鹿児島",
"817356", "串本",
"818476", "府中",
"818683", "津山",
"818655", "鴨方",
"812787", "沼田",
"811524", "網走",
"818391", "小郡",
"814288", "青梅",
"811337", "石狩",
"814220", "国分寺",
"811534", "中標津",
"81743", "奈良",
"811232", "千歳",
"811658", "上川",
"818568", "津和野",
"819746", "竹田",
"818595", "米子",
"812582", "長岡",
"81864", "倉敷",
"81774", "宇治",
"819208", "対馬佐賀",
"8125489", "津川",
"812873", "大田原",
"815994", "阿児",
"811984", "花巻",
"817997", "津名",
"817672", "羽咋",
"812993", "石岡",
"818243", "東広島",
"819722", "佐伯",
"811545", "釧路",
"818952", "宇和島",
"81568", "春日井",
"812932", "高萩",
"819732", "日田",
"81828", "広島",
"817712", "亀岡",
"818548", "石見大田",
"81240", "磐城富岡",
"81776", "福井",
"817454", "大和高田",
"818374", "長門",
"8168", "大阪",
"812644", "木曾福島",
"814992", "伊豆大島",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ],
               '70859' => [
                            'Asia/Tokyo'
                          ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;