#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use FindBin;
require "$FindBin::Bin/../util.pl";

my $test = Net::DRI::Test->new_epp(['Afilias::Association', 'Afilias::IPR']);
my $dri = $test->dri();

use Test::More tests => 5;

my ($ext, $rc);

# See comments in Afilias/IPR.pm
$test->{dri}{registries}{EXAMPLE}{profiles}{p1}{protocol}{ns}{ipr} = 'urn:afilias:params:xml:ns:ipr-1.1';

####################################################################################################
## Association domain operations
## Domain create

$test->set_response();
my $cs = $dri->local_object('contactset');
$cs->add($dri->local_object('contact')->srid('C1-XXX'), 'registrant');
$cs->add($dri->local_object('contact')->srid('C2-XXX'), 'admin');
$cs->add($dri->local_object('contact')->srid('C3-XXX'), 'tech');
$cs->add($dri->local_object('contact')->srid('C4-XXX'), 'billing');
my $ns = $dri->local_object('hosts');
$ns->add('ns1.eppvalid.example');
$ns->add('ns2.eppvalid.example');
$rc = $dri->domain_create('epptest.example', {
                pure_create =>  1,
				contact =>	$cs,
				ns =>		$ns,
				auth =>		{ pw => 'bleblubleu' },
				association => { id => 'CX1-XXX', pw => 'acdcda' },
				ipr => { class => 'nonResolver' },
	});

$ext = '<extension><association:create xmlns:association="urn:afilias:params:xml:ns:association-1.0"><association:contact type="membership"><association:id>CX1-XXX</association:id><association:authInfo><association:pw>acdcda</association:pw></association:authInfo></association:contact></association:create><ipr:create xmlns:ipr="urn:afilias:params:xml:ns:ipr-1.1"><ipr:class>nonResolver</ipr:class></ipr:create></extension>';
is_string($test->get_command(), '<command><create><domain:create xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>epptest.example</domain:name><domain:ns><domain:hostObj>ns1.eppvalid.example</domain:hostObj><domain:hostObj>ns2.eppvalid.example</domain:hostObj></domain:ns><domain:registrant>C1-XXX</domain:registrant><domain:contact type="admin">C2-XXX</domain:contact><domain:contact type="billing">C4-XXX</domain:contact><domain:contact type="tech">C3-XXX</domain:contact><domain:authInfo><domain:pw>bleblubleu</domain:pw></domain:authInfo></domain:create></create>'.$ext.'<clTRID>ABC-12345</clTRID></command>', 'domain_create +association build');
is($rc->is_success(),1,'domain_create +association is_success');

## Domain update
my $todo = $dri->local_object('changes');
$todo->add('association', { id => 'CX2-XXX', pw => '54321a' } );
$todo->del('association', { id => 'CX9-XXX' } );
$rc = $dri->domain_update('epptest.example', $todo);
$ext = '<extension><association:update xmlns:association="urn:afilias:params:xml:ns:association-1.0"><association:add><association:contact type="membership"><association:id>CX2-XXX</association:id><association:authInfo><association:pw>54321a</association:pw></association:authInfo></association:contact></association:add><association:rem><association:contact type="membership"><association:id>CX9-XXX</association:id></association:contact></association:rem></association:update></extension>';	
is_string($test->get_command(), '<command><update><domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>epptest.example</domain:name></domain:update></update>'.$ext.'<clTRID>ABC-12345</clTRID></command>', 'domain_update build');
is($rc->is_success(),1,'domain_update is_success');

## Domain info
$ext = '<extension><association:infData xmlns:association="urn:afilias:params:xml:ns:association-1.0"><association:contact type="membership"><association:id>CX1-XXX</association:id></association:contact></association:infData></extension>';	
$test->set_response('<resData><domain:infData xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>epptest.example</domain:name><domain:roid>U13423-XXX</domain:roid><domain:status s="ok"/><domain:registrant>C1-XXX</domain:registrant><domain:contact type="billing">C2-XXX</domain:contact><domain:contact type="tech">C3-XXX</domain:contact><domain:contact type="admin">C4-XXX</domain:contact><domain:ns><domain:hostObj>ns1.eppvalid.example</domain:hostObj><domain:hostObj>ns2.eppvalid.example</domain:hostObj></domain:ns><domain:clID>client1</domain:clID><domain:crID>client1</domain:crID><domain:crDate>2007-11-09T08:48:08.0Z</domain:crDate><domain:upID>client1</domain:upID><domain:upDate>2008-04-28T09:45:15.0Z</domain:upDate><domain:exDate>2012-11-09T08:48:08.0Z</domain:exDate><domain:authInfo><domain:pw>blablabla</domain:pw></domain:authInfo></domain:infData></resData>' .$ext);
$rc = $dri->domain_info('epptest.example');
my $as = $dri->get_info('association');
is ($as->{'id'},'CX1-XXX','domain_info association ID');

exit 0;
