/* Vt.h -- header file for voltage as func of time			*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

#ifndef	VT_H
#define	VT_H
#include <stdio.h>

#define	VEOF	(0x10000)		/* impossible: signals EOF	*/

typedef	long	TIME;
typedef	long	VOLTAGE;
typedef	struct V_INFO {
    char	*V_format;		/* name of file format		*/
    char	*V_comment;		/* user comment			*/
    long	V_np;			/* number points		*/
    TIME	V_tlo;			/* earliest time		*/
    TIME	V_thi;			/* last time + 1		*/
    VOLTAGE	V_vlo;			/* lowest voltage in format	*/
    VOLTAGE	V_vhi;			/* largest voltage in format	*/
    double	V_tscale;		/* time scale			*/
    double	V_vscale;		/* voltage scale		*/
}		V_INFO;

extern	VOLTAGE	*V_infbuf;
extern	int	V_ibnv;
extern	TIME	V_ibt0;
extern	TIME	V_lastt;
extern	char	*V_errmsg;

int	Vstream(FILE *, char *, unsigned);
void	Vend(void);
V_INFO	*Vinfo(void);
VOLTAGE	fV(TIME);

#define	V(t)	(V_lastt=(t), ((V_lastt >= V_ibt0) && (V_lastt < V_ibnv+V_ibt0)) ? \
		     V_infbuf[V_lastt-V_ibt0] : fV(V_lastt) \
		)

#endif	/* not VT_H */
