/****************************************************************************
*  Copyright (C) 1996 by Leo Khramov
*  email:     leo@pop.convey.ru
*  Fido:      2:5030/627.15
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "xh.h"
#include "../scroll.h"
const int  maxlines=10000;
const int  maxsyms=250;
Atom ast;
extern Atom wmDeleteWindow;
extern Win *vdw;
extern KEY *vdok;
extern KEY *vdcan;
extern Input *vdin;
extern char *syspath;
KEY *vdex=NULL;
Editor *ew=NULL;
Switch *esw1=NULL,*esw2=NULL;
extern Text *vdt1,*vdt2,*vdt3;
char edbuf[256];
int ednum;
int vcenterx,vcentery;
char rustbl[256];
char wintbl[256];
char wrustbl[256];
char dostbl[256];
char rtbl[128];

void genrtbl()
{
 char dos[73];
 char koi[73];
 char tmp[256];
 int i;
 strcpy(tmp,syspath);
 strcat(tmp,"/ru.key1");
 int fp1=open(tmp,O_RDONLY);
 strcpy(tmp,syspath);
 strcat(tmp,"/ru.key2");
 int fp2=open(tmp,O_RDONLY);
 if(fp1== -1 || fp2== -1)
 {
  fprintf(stderr,"Russian mapping failed...\n");
  if(fp1>0)close(fp1);
  if(fp2>0)close(fp2);
  return;
 }
 read(fp1,dos,73);
 read(fp2,koi,73);
 close(fp1);
 close(fp2);
 for(i=0;i<128;i++)
  rtbl[i]=i;
 for(i=0;i<73;i++)
  rtbl[dos[i]]=koi[i];
}
 

void genrustbl()
{
 char dos[66];
 char koi[66];
 char win[66];
 char tmp[256];
 int i;
 strcpy(tmp,syspath);
 strcat(tmp,"/ru.dos");
 int fp1=open(tmp,O_RDONLY);
 strcpy(tmp,syspath);
 strcat(tmp,"/ru.koi8");
 int fp2=open(tmp,O_RDONLY);
 strcpy(tmp,syspath);
 strcat(tmp,"/ru.win");
 int fp3=open(tmp,O_RDONLY);
 if(fp1== -1 || fp2== -1 || fp3==-1)
 {
  fprintf(stderr,"Generating Russian mapping failed...\n");
  if(fp1>0)close(fp1);
  if(fp2>0)close(fp2);
  if(fp3>0)close(fp3);
  return;
 }
 read(fp1,dos,66);
 read(fp2,koi,66);
 read(fp3,win,66);
 close(fp1);
 close(fp2);
 close(fp3);
 for(i=0;i<256;i++)
  rustbl[i]=dostbl[i]=wintbl[i]=wrustbl[i]=i;
 for(i=0;i<66;i++)
 {
  rustbl[dos[i]]=koi[i];
  dostbl[koi[i]]=dos[i];
  wrustbl[win[i]]=koi[i];
  wintbl[koi[i]]=win[i];
 }
 genrtbl();
}
 

void eok()
{
 if(vdin->bl)
 {
 vdin->hide();
 if(esw1)
 {
  ew->dos=esw1->sw;
  ew->dos|=esw2->sw<<1;
  esw1->hide();
  delete esw1;
  esw1=NULL;
  esw2->hide();
  delete esw2;
  esw2=NULL;
 }
 vdok->hide();
 vdcan->hide();
 vdw->hide();
 if(vdex) {vdex->hide();delete vdex;vdex=NULL;};
 if(esw1) {esw1->hide();delete esw1; esw1=NULL;};
 if(esw2) {esw2->hide();delete esw2; esw2=NULL;};
 delete vdw;
 delete vdin;
 delete vdok;
 delete vdcan;
 delete vdt1;
  XSetInputFocus(disp,ew->w,RevertToParent,CurrentTime);
 vdw=NULL;
 ew->func(ednum);
 }
}

void eexit()
{
 if(vdin->bl)
 {
 vdin->hide();
 ew->dos=esw1->sw;
 ew->dos|=esw2->sw<<1;
 esw1->hide();
 esw2->hide();
 vdok->hide();
 vdcan->hide();
 vdw->hide();
 vdex->hide();
 delete vdw;
 delete vdin;
 delete vdok;
 delete vdcan;
 delete vdt1;
 delete vdex;
 delete esw1;
 delete esw2;
 vdex=NULL;
  XSetInputFocus(disp,ew->w,RevertToParent,CurrentTime);
 vdw=NULL;
 ew->func(ednum+1);
 }
}

void ecan()
{
 vdin->hide();
 if(esw1)
 {
 esw1->hide();
 delete esw1;
 esw1=NULL;
 }
 vdok->hide();
 vdcan->hide();
 vdw->hide();
 if(vdex) {vdex->hide();delete vdex;vdex=NULL;};
 if(esw1) {esw1->hide();delete esw1; esw1=NULL;};
 if(esw2) {esw2->hide();delete esw2; esw2=NULL;};
 delete vdw;
 delete vdin;
 delete vdok;
 delete vdcan;
 delete vdt1;
 vdw=NULL;
  XSetInputFocus(disp,ew->w,RevertToParent,CurrentTime);
}

void eask(char *head,char *mes,Editor* ivw,int inum)
{
 if(vdw==NULL)
 {
 ew=ivw;
 ednum=inum;
 vcenterx=ivw->l/2;
 vcentery=ivw->h/2;
 vdw=new Win(vcenterx-150,vcentery-70,303,130,head,5);
 vdok=new KEY(40,-20,80,25,"OK",1,eok);
 vdcan=new KEY(-40,-20,80,25,"Cancel",2,ecan);
 vdin=new Input(10,50,280,1,eok);
 vdt1=new Text(10,40,mes,5);
 vdin->set_escapefunc(ecan);
 vdok->set_escapefunc(ecan);
 vdw->init(ew->w);
 vdin->init(vdw->w);
 vdok->init(vdw->w);
 vdcan->init(vdw->w);
 vdt1->init(vdw->w);
 vdw->link(vdin);
 vdin->link(vdok);
 vdok->link(vdcan);
 vdcan->link(vdin);
 edbuf[0]=0;
 if(ednum==0)  strcpy(edbuf,ew->node->name);
 vdin->setbuf(edbuf,255);
 vdw->show();
 vdin->show();
 vdok->show();
 vdcan->show();
 vdt1->show();
 }
}

void eentire()
{
 ew->ent=1;
}

void ebackward()
{
 ew->bw=1;
 }
 
void efind(Editor* ivw,int inum)
{
 if(vdw==NULL)
 {
 ew=ivw;
 ednum=inum;
 vcenterx=ivw->l/2;
 vcentery=ivw->h/2;
 vdw=new Win(vcenterx-150,vcentery-70,303,150,"Find",5);
 vdok=new KEY(-20,-45,80,25,"Find",1,eok);
 vdcan=new KEY(-20,-15,80,25,"Cancel",2,ecan);
 vdin=new Input(10,50,280,1,eok);
 vdt1=new Text(10,40,"Text to find:",5);
 esw1=new Switch(20, 85,150,"Entire scope",4,eentire);
 esw2=new Switch(20,110,150,"Backwards",4,ebackward);
 vdin->set_escapefunc(ecan);
 vdok->set_escapefunc(ecan);
 vdw->init(ew->w);
 vdin->init(vdw->w);
 vdok->init(vdw->w);
 vdcan->init(vdw->w);
 vdt1->init(vdw->w);
 esw1->init(vdw->w);
 esw2->init(vdw->w);
 vdw->link(vdin);
 vdin->link(esw1);
 esw1->link(esw2);
 esw2->link(vdok);
 vdok->link(vdcan);
 vdcan->link(vdin);
 edbuf[0]=0;
 if(ednum==0)  strcpy(edbuf,ew->node->name);
 else strcpy(edbuf,ew->findbuf);
 vdin->setbuf(edbuf,255);
 vdw->show();
 vdin->show();
 vdok->show();
 vdcan->show();
 vdt1->show();
 esw1->show();
 esw2->show();
 }
}

void eex(Editor* ivw,int inum)
{
 if(vdw==NULL)
 {
 ew=ivw;
 ednum=inum;
 vcenterx=ivw->l/2;
 vcentery=ivw->h/2;
 if(inum)
 vdw=new Win(vcenterx-150,vcentery-90,303,185,"Save and Exit",5);
 else
 vdw=new Win(vcenterx-150,vcentery-90,303,185,"Save",5);
 esw1=new Switch(55, 83,185,"DOS text format",3,NULL);
 esw2=new Switch(55, 108,185,"KOI8 -> DOS",3,NULL);
 if(inum)
 {
 vdok=new KEY(10,-20,80,25,"Save",1,eok);
 vdex=new KEY(100,-20,80,25,"Don't save",1,eexit);
 vdcan=new KEY(-10,-20,80,25,"Cancel",2,ecan);
 } else
 {
 vdok=new KEY(20,-20,80,25,"Save",1,eok);
 vdcan=new KEY(-20,-20,80,25,"Cancel",2,ecan);
 vdex=NULL;
 }
 vdin=new Input(10,50,280,1,eok);
 vdt1=new Text(10,40,"Save as",5);
 vdin->set_escapefunc(ecan);
 vdok->set_escapefunc(ecan);
 vdw->init(ew->w);
 esw1->init(vdw->w);
 esw2->init(vdw->w);
 vdin->init(vdw->w);
 vdok->init(vdw->w);
 if(inum)
 vdex->init(vdw->w);
 vdcan->init(vdw->w);
 vdt1->init(vdw->w);
 vdw->link(vdin);
 vdin->link(esw1);
 esw1->link(esw2);
 esw2->link(vdok);
 if(inum)
 {
 vdok->link(vdex);
 vdex->link(vdcan);
 } else vdok->link(vdcan);
 vdcan->link(vdin);
 edbuf[0]=0;
 strcpy(edbuf,ew->node->name);
 vdin->setbuf(edbuf,255);
 esw1->sw=ew->dos;
 vdw->show();
 vdin->show();
 esw1->show();
 esw2->show();
 vdok->show();
 if(inum)
 vdex->show();
 vdcan->show();
 vdt1->show();
 }
}


void vmes(char* head,char* mes,Viewer *ivw);

///////////////////////////////////Editor class///////////////////////////////
void Editor::init(Window ipar)
{
 int tw;
 koi=1;rmode=0;
 XTextProperty wname;
 parent=ipar;
 XRectangle rec;
 vcenterx=l/2;
 vcentery=h/2;
 win_resize=1;
 w=create_win(name,x,y,l+20,h,ExposureMask | ButtonPressMask | 
   FocusChangeMask | KeyPressMask | StructureNotifyMask);
 gcv.background=keyscol[1];
 gcv.foreground=cols[0];
 gcv.font=fixfontstr->fid;
 gcw=XCreateGC(disp,w,GCBackground | GCFont,&gcv);
 gcv.font=vfontstr->fid;
 gct=XCreateGC(disp,w,GCBackground | GCFont | GCForeground,&gcv);
 rec.x=0;rec.y=0;rec.width=l-10;rec.height=h-46;
 XSetClipRectangles(disp,gct,4,24,&rec,1,YXSorted);
 ty=vfontstr->max_bounds.ascent+vfontstr->max_bounds.descent;
 vish=(h-48)/ty;
 tx=XTextWidth(vfontstr," ",1);
 tl=vfontstr->max_bounds.rbearing-vfontstr->min_bounds.lbearing;
 prflg=row=0;
 XStringListToTextProperty(&name,1,&wname);
 XSetWMIconName(disp,w,&wname);
 scr=new ScrollBar(-2,0,h-23,this);
 scr->setrange(0,10);
 scr->init(w);
 XSetWMProtocols (disp, w, &wmDeleteWindow, 1);
}

void Editor::reconfigure(int il,int ih)
{
 l=il-20;h=ih;
 XRectangle rec;
 vcenterx=l/2;
 vcentery=h/2;
 rec.x=0;rec.y=0;rec.width=l-10;rec.height=h-46;
 XSetClipRectangles(disp,gct,4,24,&rec,1,YXSorted);
 vish=(h-48)/ty;
 cy=cx=0;
 XClearWindow(disp,w);
 expose();
 scr->reconfigure(l+18,0,h-23);
 if(external_reconfigure) external_reconfigure(this,x,y,l+20,h);
}
 

char Editor::trans(int mode,char sym)
{
 if(mode & LockMask)
  switch(sym)
  {
   case '[':sym='{';break;
   case ']':sym='}';break;
   case ';':sym=':';break;
   case '\'':sym='\"';break;
   case ',':sym='<';break;
   case '.':sym='>';break;
   };
 sym=rtbl[sym];
 return sym;
}

void Editor::func(int num)
{
  switch(num)
  {
   case 0: save();break;
   case 1: if(mod) if(save()) break;
   case 2: endfunc(this);break;
   case 3: find();break;
   case 4: gotoln();break;
  };
}

void Editor::view()
{
 int i,f=25+vfontstr->max_bounds.ascent;
 for(i=0;i<vish;i++)
 {            
  if(i+base>=highb && i+base<highe)
   XSetForeground(disp,gct,keyscol[0]);
  else XSetForeground(disp,gct,keyscol[1]);
  XFillRectangle(disp,w,gct,4,25+i*ty,l-9,ty);
  if(i+base<maxr)
  {
  XSetForeground(disp,gct,cols[0]);
  XDrawString(disp,w,gct,5-stx,f+i*ty,buf[i+base],chl[i+base]);
  }
 }
 scr->val=base;
 scr->expose();
}

void Editor::info()
{
 int nl,k,tx;
 char str[64];
 XSetForeground(disp,gcw,keyscol[1]);
 XFillRectangle(disp,w,gcw,2,2,l-4,18);
 XSetForeground(disp,gcw,cols[0]);
 nl=strlen(node->name);
 tx=fixfontstr->max_bounds.rbearing-fixfontstr->min_bounds.lbearing;
 visl=(l-10)/tx;
 k=visl/3;
 if(nl>k) nl=k-1;
 XDrawString(disp,w,gcw,5,16,node->name,nl);
 sprintf(str,"%4d:%d (%d)",cx+dx+1,base+cy+1,maxr);
 if(mod) strcat(str,"  Mod");
 XDrawString(disp,w,gcw,10+k*tx,16,str,strlen(str));
 sprintf(str,"Size: %d",node->size);
 XDrawString(disp,w,gcw,15+k*2*tx+tx*3,16,str,strlen(str));

 XSetForeground(disp,gcw,keyscol[1]);
 XFillRectangle(disp,w,gcw,l-75,2,75,18);
   XSetForeground(disp,gcw,keyscol[2]);
   XDrawLine(disp,w,gcw,l-40,2,l-3,2);
   XDrawLine(disp,w,gcw,l-40,2,l-40,19);
   XDrawLine(disp,w,gcw,l-75,2,l-41,2);
   XDrawLine(disp,w,gcw,l-75,2,l-75,19);
   XSetForeground(disp,gcw,keyscol[0]);
   XDrawLine(disp,w,gcw,l-40,19,l-3,19);
   XDrawLine(disp,w,gcw,l-3,2,l-3,19);
   XDrawLine(disp,w,gcw,l-75,19,l-41,19);
   XDrawLine(disp,w,gcw,l-41,2,l-41,19);
   if(rmode)
   {
    XSetForeground(disp,gcw,cols[5]);
    XDrawString(disp,w,gcw,l-36,16,"Rus",3);
   } else
   {
    XSetForeground(disp,gcw,cols[3]);
    XDrawString(disp,w,gcw,l-36,16,"Eng",3);
   }
   if(koi==1) {
     XSetForeground(disp,gcw,cols[4]);
     XDrawString(disp,w,gcw,l-72,16,"KOI",3);
     }
   else if(koi==0){
    XSetForeground(disp,gcw,cols[2]);
    XDrawString(disp,w,gcw,l-72,16,"DOS",3);
    } else {
    XSetForeground(disp,gcw,cols[2]);
    XDrawString(disp,w,gcw,l-72,16,"WIN",3);
    }
}

/*
void Editor::rusconvert()
{
  int i,j;
  if(koi==0)
  {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      buf[i][j]=rustbl[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=1;
   } else if(koi==1)
   {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      buf[i][j]=dostbl[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=0;
   } else wrusconvert();
}
*/
void Editor::rusconvert()
{
  int i,j;
  unsigned char *rt=(unsigned char*)rustbl;
  unsigned char *dt=(unsigned char*)dostbl;
  unsigned char **bu=(unsigned char**) buf;
  if(koi==0)
  {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      bu[i][j]=rt[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=1;
   } else if(koi==1)
   {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      bu[i][j]=dt[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=0;
   } else wrusconvert();
}

void Editor::wrusconvert()
{
  int i,j;
  if(koi==2)
  {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      buf[i][j]=wrustbl[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=1;
   } else if(koi==1)
   {
  for(i=0;i<maxr;i++)
  {
   for(j=0;j<chl[i];j++)
      buf[i][j]=wintbl[buf[i][j]];
    if(chl[i])
    xl[i]=XTextWidth(vfontstr,buf[i],chl[i]);
   }
   koi=2;
   } else rusconvert();
}

void Editor::do_convertion()
{
 rusconvert();
 view();
 info();
 showcurs();
}

void Editor::do_wconvertion()
{
 wrusconvert();
 view();
 info();
 showcurs();
}                

void Editor::xyinfo()
{
 int nl,k,tx;
 char str[64];
 tx=fixfontstr->max_bounds.rbearing-fixfontstr->min_bounds.lbearing;
 visl=(l-10)/tx;
 k=visl/3;
 XSetForeground(disp,gcw,keyscol[1]);
 XFillRectangle(disp,w,gcw,k*tx,2,l-76-k*tx,18);
 XSetForeground(disp,gcw,cols[0]);
 sprintf(str,"%4d:%d (%d)",cx+dx+1,base+cy+1,maxr);
 if(mod) strcat(str,"  Mod");
 XDrawString(disp,w,gcw,10+k*tx,16,str,strlen(str));
 sprintf(str,"Size: %d",node->size);
 XDrawString(disp,w,gcw,15+k*2*tx+tx*3,16,str,strlen(str));
 if(maxr-1!=scr->maxval) {scr->maxval=scr->range=maxr-1;scr->setpages(maxr/vish);scr->expose();};
}

void Editor::expose()
{
   XSetForeground(disp,gcw,keyscol[0]);
   XDrawLine(disp,w,gcw,0,0,l,0);
   XDrawLine(disp,w,gcw,0,0,0,h-20);
   XDrawLine(disp,w,gcw,1,1,l-1,1);
   XDrawLine(disp,w,gcw,1,1,1,h-21);
   XDrawLine(disp,w,gcw,1,21,l-1,21);
   XSetForeground(disp,gcw,keyscol[2]);
   XDrawLine(disp,w,gcw,0,h-21,l,h-21);
   XDrawLine(disp,w,gcw,l-1,0,l-1,h-21);
   XDrawLine(disp,w,gcw,1,h-22,l-1,h-22);
   XDrawLine(disp,w,gcw,l-2,1,l-2,h-21);
   XDrawLine(disp,w,gcw,2,20,l-2,20);
   view();
   info();
   if(foc) showcurs();
   if(ffl)
   {
    XSetInputFocus(disp,w,RevertToNone,CurrentTime);
    ffl=0;
   }
}

void Editor::pagedown()
{
 if(base+vish<maxr)
 {
  if(ev.xkey.state & ShiftMask)
  {if(base+cy<highb || base+cy>highe)  highb=base+cy;
    highe=base+cy+vish;
    if(highe>maxr) highe=maxr;
  }
  showcurs(0);
  base+=vish;
  if(base+cy>=maxr) cy=maxr-base-1;
  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
  view();
  showcurs();
 }
}

void Editor::pageup()
{
 if(base>0)
 {
  showcurs(0);
  if(ev.xkey.state & ShiftMask)
  {
    if(base+cy<highb || base+cy>highe)
      highe=base+cy;
    highb=base+cy-vish;
    if(highb<0) highb=0;
  }
  base-=vish;
  if(base<0) base=0;
  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
  view();
  showcurs();
 }
}
   
void Editor::back()
{
 int i;
 int x=cx+dx,y=base+cy;
 showcurs(0);
 if(x<=chl[y])
 {
 mod=1;node->size--;
 for(i=x;i<chl[y]+1;i++)
  buf[y][i-1]=buf[y][i];
 chl[y]--;
 xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
 }
 cx--;
 if(cx<0) {cx=0;dx--;stx-=tx;view();}
 else
 showline(cy);
 showcurs();
}

void Editor::backln()
{
 int y=cy+base,i,j;
 if(y>0)
 {
 mod=1;node->size--;
 cx=chl[y-1];
 i=chl[y-1];j=0;
 while(j<=chl[y] && i<maxsyms-1)
  buf[y-1][i++]=buf[y][j++];
 if(j<=chl[y])
 {
  buf[y-1][i]=0;
  for(i=j;i<=chl[y];i++)
   buf[y][i-j]=buf[y][i];
  chl[y-1]=strlen(buf[y-1]);
  chl[y]=strlen(buf[y]);
  xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
  xl[y-1]=XTextWidth(vfontstr,buf[y-1],chl[y-1]);
 } else
 {
  chl[y-1]=strlen(buf[y-1]);
  xl[y-1]=XTextWidth(vfontstr,buf[y-1],chl[y-1]);
  if(maxr>1) node->size+=(chl[cy+base]+1);
  delln(cy);
 }
 if(cy>0){if(cy+base+1<maxr) cy--;
    while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
      }
    else if(base>0) {if(cy+base+1>=maxr) cy++;base--;
    while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
                    };
 view();showcurs();
 }
}
 
void Editor::delln(int y)
{
 int i;
 if(maxr>1)
 {
 mod=1;
 y+=base;
 node->size-=(chl[y]+1);
 delete buf[y];
 for(i=y+1;i<=maxr;i++)
 {
  buf[i-1]=buf[i];
  chl[i-1]=chl[i];
  xl[i-1]=xl[i];
 }
 maxr--;
 if(cy+base==maxr) {cy--;if(cy<0) cy=0,base--;};
 info();
 }
}

void Editor::insempty(int y)
{
  int i;                  
  for(i=maxr;i>y;i--)
  {
    buf[i]=buf[i-1];
    chl[i]=chl[i-1];
    xl[i]=xl[i-1];
   }
   buf[y]=new char[maxsyms];
   chl[y]=0;
   xl[y]=0;
   maxr++;node->size++;
}

void Editor::insertln()
{
 int y=cy+base,x=dx+cx,i;
 if(maxr+1<maxlines)
 {
 mod=1;
 node->size++;
 for(i=maxr;i>y;i--)
 {                
  buf[i]=buf[i-1];
  chl[i]=chl[i-1];
  xl[i]=xl[i-1];
 }
 buf[y+1]=new char[maxsyms];
 for(i=0;i<maxsyms;i++)
 buf[y+1][i]=0;
 for(i=0;i<chl[y];i++)
  if(buf[y][i]==' ') buf[y+1][i]=' ';
  else break;
 buf[y+1][i]=0;
 chl[y+1]=i;
 if(x<chl[y])
 {
  for(i=x;i<=chl[y];i++)
   buf[y+1][i-x]=buf[y][i];
  buf[y][x]=0;
  buf[y][x+1]=0;
  chl[y]=strlen(buf[y]);
  xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
  cx=0;
 } else cx=i;
 y++;             
 chl[y]=strlen(buf[y]);
 xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
 stx=dx=0;
 maxr++;cy++;
 if(cy+1>vish) {cy--;base++;};
 view();showcurs();
 }
}

void Editor::insert(char sym)
{
 int y=cy+base,x=cx+dx,i;
 if(sym!=0 && x+1<maxsyms)
 {                
  mod=1;
  showcurs(0);node->size++;
  for(i=chl[y];i>x;i--)
   buf[y][i]=buf[y][i-1];
  buf[y][x]=sym;
  chl[y]++;
  xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
  cx++;
  i=0;
  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;i=1;};
  if(i) view();
  else showline(cy);
  showcurs();
 }
}

void Editor::insspace()
{
 int y=cy+base,i;
 mod=1;
 for(i=chl[y];i<cx+dx;i++)
 {
  buf[y][i]=' ';
  node->size++;
 }
 buf[y][cx+dx]=0;
 chl[y]=strlen(buf[y]);
 xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
}

void Editor::sfind()
{
 ent=bw=0;efind(this,3);
 }

void Editor::sgoto()
{
  eask("Go to line...","Line number:",this,4);
 }
  
void Editor::ssave()
 {
  eex(this,0);
  }

void Editor::gotoln()
{
  int num=0;
  sscanf(edbuf,"%d",&num);
  if(num<1 || num>maxr)  vmes("Error!","Wrong line number",(Viewer*)this);
  else
  {
    num--;
    cy=num%vish;
    base=num-cy;
    dx=stx=cx=0;
    view();
    showcurs();
   }
}
/*
char selection_text[]="Transfer complete!";
void send_selection(int time,int requestor,int target,int property)
{
  XEvent event;
  
  event.xselection.type = SelectionNotify;
  event.xselection.selection = XA_PRIMARY;
  event.xselection.target = target;
  event.xselection.requestor = requestor;
  event.xselection.time = time;
  if (target == XA_STRING)
    {
      XChangeProperty(disp,requestor,property,XA_STRING,8,PropModeReplace,
                      selection_text,strlen(selection_text));
      event.xselection.property = property;
    }
  else
    {
      event.xselection.property = None;
      fprintf(stderr,"Not a string  %X=%d\n",target,target);
      XChangeProperty(disp,requestor,property,target,8,PropModeReplace,
                      selection_text,strlen(selection_text));
      event.xselection.property = property;
    }
   fprintf(stderr,"Send selection\n");
  XSendEvent(disp,requestor,False,0,&event);
}

void paste_primary(int window,int property,int Delete)
{
  Atom actual_type;
  int actual_format,i;
  long nitems, bytes_after, nread;
  unsigned char *data, *data2;

  if (property == None)
    {fprintf(stderr,"Prim None\n");return;};

  nread = 0;
      if (XGetWindowProperty(disp,window,property,nread/4,1024,Delete,
                             AnyPropertyType,&actual_type,&actual_format,
                             &nitems,&bytes_after,(unsigned char **)&data)
          != Success) fprintf(stderr,"XGetProp error\n");
 else fprintf(stderr,"Receive: %s\n",data);
}
*/
void Editor::click()
{
 XComposeStatus cs;
 Atom sel_property;
 KeySym ks;
 char sym[4];
 int j; 
 if(ev.xany.window==w)
 {
  switch(ev.type)
  {
  case Expose: expose();break;
  case UnmapNotify: unmap=1;break;
  case ButtonPress: if(ev.xbutton.y>25) {showcurs(0);cy=(ev.xbutton.y-25)/ty;if(cy>=vish) cy=vish-1;
    if(cy+base>=maxr) cy=maxr-base-1;
    cx=chl[cy+base]-dx;
    while(ev.xbutton.x<XTextWidth(vfontstr,buf[cy+base],cx)-1-stx) cx--;
      showcurs();};
     XSetInputFocus(disp,w,RevertToParent,CurrentTime);break;
  case ButtonRelease:break;
  case FocusIn: showcurs();foc=1; break;
  case FocusOut:showcurs(0);foc=0; break;
  case ConfigureNotify: if(ev.xconfigure.width!=l+20 || ev.xconfigure.height!=h)
   reconfigure(ev.xconfigure.width,ev.xconfigure.height);break;
//  case SelectionNotify: paste_primary(w,ev.xselection.property,True);break;
//  case SelectionRequest: send_selection(ev.xselectionrequest.time,ev.xselectionrequest.requestor,
//                 ev.xselectionrequest.target,ev.xselectionrequest.property);break;
  case KeyPress:
   ks=XLookupKeysym(&ev.xkey,0);
   switch(ks)
    {
     case XK_Down:if(cy+1+base<maxr){ j=0;
                  if(ev.xkey.state & ShiftMask) {if(cy+base<highb || cy+base>highe) {highb=cy+base;
                  highe=highb+1;j=1;} else if(cy+base<=highe) {highe=cy+base+1;j=1;};};
                  showcurs(0);cy++;
                  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;j=1;};
                   if(cy+1>vish) {cy--;base++;j=1;};if(j) view();showcurs();};break;
     case XK_Up: if(cy+base>0){j=0;
                  if(ev.xkey.state & ShiftMask) {if(cy+base-1<highb || cy+base>highe)
                    {if(cy+base!=highb) highe=cy+base;highb=cy+base-1;j=1;} else {highe=cy+base-1;j=1;};};
                  if(cy>0) {showcurs(0);cy--;
                  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;j=1;};
                  if(j) view();showcurs();}
                 else if(base>0) {base--;
                  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
                 view();showcurs();};}; break;
     case XK_Next:if(ev.xkey.state & ControlMask)
                   {showcurs(0);cx=cy=0;base=maxr-vish;if(base<0) base=0;view();
                    showcurs();}else
                    pagedown();break;
     case XK_Prior: if(ev.xkey.state & ControlMask)
                   {showcurs(0);base=cx=cy=0;view();showcurs();} 
                   else pageup();break;
     case XK_Tab:  if(cx+dx>chl[base+cy]) insspace();for(j=0;j<8;j++) insert(' ');break;
     case XK_Right:if(cx+dx+1<maxsyms){showcurs(0);
                   if(calclen(cx+dx,cy)>=l-15) {stx+=tx;dx++;view();}
                   else cx++;showcurs();}; break;
     case XK_Left: if(cx>0) {showcurs(0);cx--;showcurs();}
                   else if(dx>0) {dx--;stx-=tx;view();showcurs();};break;
     case XK_Home: 
                    showcurs(0);cx=0;
                    if(dx>0) {dx=stx=0;view();};showcurs();break;
     case XK_a:
     case XK_A: if(ev.xkey.state & ControlMask) 
                        {
                     //Do the same as XK_Home
                    showcurs(0);cx=0;
                    if(dx>0) {dx=stx=0;view();};showcurs();break;
                        }
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_E:
     case XK_e: if(ev.xkey.state & ControlMask) 
                        {
                  //Do the same as XK_End
                  if(cx!=chl[cy+base]){
                  showcurs(0);if(dx) j=1;dx=stx=0;cx=chl[cy+base];
                  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
                  if(dx!=0 || j!=0) view();showcurs();};break;
                        }
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_End: 
                  if(cx!=chl[cy+base]){
                  showcurs(0);if(dx) j=1;dx=stx=0;cx=chl[cy+base];
                  while (calclen(cx+dx,cy)>=l-15) {cx--;dx++;stx+=tx;};
                  if(dx!=0 || j!=0) view();showcurs();};break;
     case XK_Execute: 
     case XK_Escape:
     case XK_F10:
        if(mod) eex(this,1);else endfunc(this);break;
     case XK_F2: ssave(); break;
     case XK_F3: copy();break;
     case XK_F4:paste();break;
     case XK_F5:cut();break;
     case XK_F6:if(swfunc) swfunc(this);break;
     case XK_F8:sgoto();break;
     case XK_F9:del();break;
/*     case XK_F11:
       XSetSelectionOwner(disp,XA_PRIMARY,w,ev.xkey.time);
       if (XGetSelectionOwner(disp,XA_PRIMARY) != w)
        fprintf(stderr,"Error owning XA_PRIMARY\n");
        else fprintf(stderr,"Owned\n");
           break;
     case XK_F12:
  sel_property = XInternAtom(disp,"IVES_SELECTION",False);
  XConvertSelection(disp,XA_PRIMARY,XA_STRING,sel_property,w,ev.xkey.time);
*/     
     case XK_F11: if((ev.xkey.state & ControlMask) || (ev.xkey.state & ShiftMask)) {koi++;if(koi>2) koi=0;info();break;};
              rusconvert();view();info();showcurs();break;
     case XK_F12: wrusconvert();view();info();showcurs();break;
     case XK_Y:
     case XK_y: if(ev.xkey.state & ControlMask) {delln(cy);view();showcurs();}
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_B:
     case XK_b: if(ev.xkey.state & ControlMask) {find_brackets();}
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_C:
     case XK_c: if(ev.xkey.state & ControlMask) {copy();break;}
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_V:
     case XK_v: if(ev.xkey.state & ControlMask) {paste();break;}
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_X:
     case XK_x: if(ev.xkey.state & ControlMask) {cut();break;}
                          else {XLookupString(&ev.xkey,sym,4,&ks,&cs);
                          insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);};break;
     case XK_F7:
     case XK_Find: sfind();break;
     case XK_BackSpace:if(cx+dx>0) back();else backln();break;
     case XK_Delete: if(ev.xkey.state & ControlMask) {del();break;};
                     showcurs(0);if(cx+dx<chl[base+cy]){cx++;back();}
                     else if(cy+1+base<maxr) {cx=dx=stx=0;cy++;backln();} else showcurs();break;
     case XK_KP_Enter:
     case XK_Return: insertln();break;
#ifndef NO_ALT
     case XK_Mode_switch:
     case XK_Alt_R: rmode^=1;info();break;
#else
     case XK_Alt_R: break;
#endif
     case XK_KP_Multiply:
      if(cx+dx>chl[base+cy]) insspace();
      insert('*');break;
     case XK_KP_Divide:
      if(cx+dx>chl[base+cy]) insspace();
      insert('/');break;
     case XK_KP_Add:
      if(cx+dx>chl[base+cy]) insspace();
      insert('+');break;
     case XK_KP_Subtract:
      if(cx+dx>chl[base+cy]) insspace();
      insert('-');break;
     case XK_Caps_Lock:
     case XK_Control_L:
     case XK_Control_R:
     case XK_Alt_L:
     case XK_Shift_L:
     case XK_Shift_R: break;
     case XK_l:
     case XK_L:if(ev.xkey.state & ControlMask) {find();break;};
     default:if(cx+dx>chl[base+cy]) insspace();
      XLookupString(&ev.xkey,sym,4,&ks,&cs);
      j=strlen(sym);
      if(j>=1 && ev.xkey.state!=ControlMask)
      insert(rmode ? trans(ev.xkey.state,sym[0]):sym[0]);break;
        
    };break;
  case ClientMessage:
    if (ev.xclient.format == 32 && ev.xclient.data.l[0] == wmDeleteWindow)
        if(mod) eex(this,1);else if(endfunc) endfunc(this);
     break;
     
  };
 }
}

void Editor::exit_and_save()
{
 if(mod) eex(this,1);else endfunc(this);
}

void Editor::copy()
{
  char *cutbuf;
  int cl=0,i,j,k;
  if(highb!=highe)
  {
  for(i=highb;i<highe;i++)
    cl+=chl[i]+1;
  cutbuf=new char[cl];
  cl--;
  k=0;
  for(i=highb;i<highe;i++)
  {
    for(j=0;j<chl[i];j++)
      cutbuf[k++]=buf[i][j];
     cutbuf[k++]=0xa;
   }
   XStoreBytes(disp,cutbuf,cl);
   delete cutbuf;
   }
}
  
void Editor::cut()
{
  char *cutbuf;
  int cl=0,i,j,k;
  if(highb!=highe)
  {
  for(i=highb;i<highe;i++)
    cl+=chl[i]+1;
  cutbuf=new char[cl];
  cl--;
  k=0;
  for(i=highb;i<highe;i++)
  {
    for(j=0;j<chl[i];j++)
      cutbuf[k++]=buf[i][j];
     cutbuf[k++]=0xa;
   }
   XStoreBytes(disp,cutbuf,cl);
   delete cutbuf;
   for(i=highb;i<highe;i++)
     delln(highb-base);
   highe=highb;
   if(cy+base>highb) {cy=highb%vish;base=highb-cy;};
   view();
   showcurs();
   }
}
  

void Editor::del()
{
  int i;
  if(highb!=highe)
  {
   for(i=highb;i<highe;i++)
     delln(highb-base);
   highe=highb;
   if(cy+base>highb) {cy=highb%vish;base=highb-cy;};
   view();
   showcurs();
   }
}
  
  
void Editor::paste()
{
  int cl,i,j=0,y;    
  char *cutbuf;
  cutbuf=XFetchBytes(disp,&cl);
  if(cl>0)
  {
   y=base+cy;highb=y;
   cutbuf[cl]=0;
   insempty(y);
   for(i=0;i<cl;i++)
   {
     if(cutbuf[i]!=0xa) buf[y][j++]=cutbuf[i];
     else 
     {
       chl[y]=j;
       xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
       buf[y][j]=0;y++;j=0;node->size+=chl[y];
       insempty(y);
       node->size--;
      }
   }
   chl[y]=j;
   node->size+=cl;
   xl[y]=XTextWidth(vfontstr,buf[y],chl[y]);
   buf[y][j]=0;
   highe=y+1;
   mod=1;
   view();showcurs();
   XFree(cutbuf);
  }
}

void Editor::showcurs(int f)
{
 int curl;
 if(base+cy>=maxr) cy=maxr-base-1;
 if(f) XSetForeground(disp,gct,cols[1]);
 else 
  if(cy+base>=highb && cy+base<highe)
   XSetForeground(disp,gct,keyscol[0]);
  else XSetForeground(disp,gct,keyscol[1]);
 if(cx+dx<chl[cy+base])
  curl=XTextWidth(vfontstr,buf[cy+base],cx+dx)-1-stx;
 else curl=xl[cy+base]+(cx+dx-chl[cy+base])*tx-1-stx;
 XDrawLine(disp,w,gct,5+curl,25+ty*cy,5+curl,24+ty*cy+ty);
 XDrawLine(disp,w,gct,6+curl,25+ty*cy,6+curl,24+ty*cy+ty);
 if(f==0) 
 {
 XSetForeground(disp,gct,cols[0]);
 XDrawString(disp,w,gct,5-stx,25+vfontstr->max_bounds.ascent+cy*ty,
 buf[cy+base],chl[cy+base]);
 }
 xyinfo();
}

void Editor::scroll(Gui* o)
{
 ScrollBar* oo=(ScrollBar*)o;
 base=oo->val;
 view();showcurs();xyinfo();
}

void Editor::scrollup(Gui* o)
{
 scroll(o);
}

void Editor::scrolling(Gui* o)
{
 scroll(o);
}

void Editor::scrolldown(Gui* o)
{
 scroll(o);
}

void Editor::showline(int nl)
{
  if(nl+base>=highb && nl+base<highe)
   XSetForeground(disp,gct,keyscol[0]);
  else XSetForeground(disp,gct,keyscol[1]);
 XFillRectangle(disp,w,gct,4,25+nl*ty,l-9,ty);
 XSetForeground(disp,gct,cols[0]);
 XDrawString(disp,w,gct,5-stx,25+vfontstr->max_bounds.ascent+nl*ty,
             buf[nl+base],chl[nl+base]);
}

int Editor::calclen(int ix,int iy)
{
 int il=chl[base+iy];
 if(ix<il) return XTextWidth(vfontstr,buf[iy+base],ix)-stx;
 return xl[iy+base]+(ix-il)*tx-stx;
}

void Editor::show() 
{
// oldel=el.next;
// el.next=NULL;
 XMapRaised(disp,w);
 addto_el(this,w);
 scr->show();
 ffl=1;
 buf=new char* [maxlines];
 for(int i=0;i<maxlines;i++)
  buf[i]=NULL;
 xl=new int[maxlines];
 chl=new int[maxlines];
}

void Editor::hide()
{
 int i;
 scr->hide();
 XUnmapWindow(disp,w);
 delfrom_el(this);
 delfrom_exp(this);
// el.next=oldel;
 for(i=0;i<maxlines;i++)
  if(buf[i]!=NULL) delete buf[i];
 delete buf;
 buf=NULL;
 delete chl;
 delete xl;
 delete scr;
}     


void Editor::newfile(FList* cur)
{
  node=cur;
  maxr=1;
  buf[0]=new char[maxsyms];
  chl[0]=0;
  xl[0]=0;
  cy=base=cx=dx=stx=mod=highb=highe=0;
  dos=0;
}

void Editor::load(FList* cur)
{
 char *tmp;
 int i,j,k,q;
 node=cur;
 dos=0;koi=1;
 int fp=open(cur->name,O_RDONLY);
 if(fp!=-1)
 {
  if(buf!=NULL)
  {
   for(i=0;i<maxlines;i++)
   if(buf[i]){ delete buf[i];buf[i]=NULL;};
  }
  tmp=new char[node->size];
  if(read(fp,tmp,node->size)<0)
     vmes("FATAL Error!","Error loading file...",(Viewer*)this);
  close(fp);
  i=j=k=0;
  buf[i]=new char[maxsyms];
  while(k<node->size)
  {
   if(tmp[k]==0xd) {k++;dos=1;};
   if(tmp[k]==0x9) 
    {
       k++;
       if(j+10>maxsyms) continue;
       for(q=0;q<8;q++)
          buf[i][j++]=' ';
       continue;
    }
//   if((unsigned char)tmp[k]>=0x80 && (unsigned char)tmp[k]<0xc0) {koi=0;};
   buf[i][j]=tmp[k++];
   if(j+2>=maxsyms)
   {
    j++;
    buf[i][j]=0;
    chl[i]=j;
    if(j>0)
    xl[i]=XTextWidth(vfontstr,buf[i],j);
    else xl[i]=0;
    j=0;
    buf[++i]=new char[maxsyms];
   } else
   if(buf[i][j]==0xa)
   {
    buf[i][j]=0;
    chl[i]=j;
    if(j>0)
    xl[i]=XTextWidth(vfontstr,buf[i],j);
    else xl[i]=0;
    j=0;
    buf[++i]=new char[maxsyms];
   } else j++;
  if(i>=maxlines)
   {
     vmes("Error!!!","Maximum lines exeeded!",(Viewer*)this);
     break;
    }
  }
  delete tmp;
  buf[i][j]=0;chl[i]=j;xl[i]=XTextWidth(vfontstr,buf[i],j);
  maxr=i+1;
  scr->setpages(maxr/vish);
  scr->setrange(0,maxr-1);
  base=cx=cy=stx=dx=mod=0;highb=highe=0;
 } else {vmes("FATAL Error","Error loading file!",(Viewer*)this);newfile(cur);};
}

int Editor::save()
{
 int i;
 char *b;
 FILE* fp;
 if(strcmp(edbuf,node->name)==0)
 {
  strcpy(fname,node->name);
  if(dos&1)
  {
   b=strchr(fname,'.');
   if(b==NULL) b=fname+strlen(fname);
   if(strcmp(b,".bug")==0) strcpy(b,".old");
   else strcpy(b,".bug");
//   fprintf(stderr,"BNAME: %s\n",fname);
  } else
  strcat(fname,".old");
  rename(node->name,fname);
 }
 strcpy(fname,edbuf);
 fp=fopen(fname,"w");
 if(fp!=NULL)
 {
 if((dos&2) && (koi==1)) rusconvert();
 for(i=0;i<maxr-1;i++)
 {
  buf[i][chl[i]]=0;
  if(dos&1)
  fprintf(fp,"%s\r\n",buf[i]);
  else
  fprintf(fp,"%s\n",buf[i]);
 }
 buf[i][chl[i]]=0;
 fprintf(fp,"%s",buf[i]);
 fclose(fp);
// delete node->name;
// node->name=new char[strlen(fname)+1];
 strcpy(node->name,fname);
 chmod(node->name,node->mode);
 mod=0;
 info();
 } else  {vmes("Error","Error saving file!!!",(Viewer*)this);return 1;};
 return 0;
}

void Editor::reverse_find_bracket()
{
  char br1[]="{[(<";
  char br2[]="}])>";
  int i1,i,j,brcoun=0;
  for(i1=0;br2[i1]!=0;i1++)
    if(br2[i1]==buf[base+cy][cx+dx]) 
        break;
  if(br2[i1]==0)
  {
        vmes("Warning!","Symbol not a bracket!",(Viewer*)this);
        return;
  }
  for(i=base+cy;i>=0;i--)
  {
          for(j=(cy+base==i ? cx+dx : chl[i]-1);j>=0;j--)
          {
                  if(buf[i][j]==br2[i1])
                          brcoun++;
                  else
                  if(buf[i][j]==br1[i1])
                          brcoun--;
                  if(brcoun==0)
                  {
                    cy=i%vish;
                    base=i-cy;
                    cx=j;dx=0;stx=0;
                    view();
                    showcurs();
                    return;
                  }
          }
  }
  vmes("Warning!","Another bracket not found!",(Viewer*)this);
}

void Editor::find_brackets()
{
  char br1[]="{[(<";
  char br2[]="}])>";
  int i1,i,j,brcoun=0;
  for(i1=0;br1[i1]!=0;i1++)
    if(br1[i1]==buf[base+cy][cx+dx]) 
        break;
  if(br1[i1]==0)
  {
          reverse_find_bracket();
          return;
  }
  for(i=base+cy;i<maxr;i++)
  {
          for(j=(cy+base==i ? cx+dx : 0);j<chl[i];j++)
          {
                  if(buf[i][j]==br1[i1])
                          brcoun++;
                  else
                  if(buf[i][j]==br2[i1])
                          brcoun--;
                  if(brcoun==0)
                  {
                    cy=i%vish;
                    base=i-cy;
                    cx=j;dx=0;stx=0;
                    view();
                    showcurs();
                    return;
                  }
          }
  }
  vmes("Warning!","Another bracket not found!",(Viewer*)this);
}
  
void Editor::find()
{
  int i,j,k=0;
  strcpy(findbuf,edbuf);
  if(bw==0)
  for(i=(ent ? 0 : base+cy);i<maxr;i++)
  {
    for(j=(cy+base==i ? cx+dx : 0);j<chl[i];j++)
     if(findbuf[0]==buf[i][j])
     {
       k=1;
       while(findbuf[k]==buf[i][j+k] && findbuf[k]!=0) k++;
       if(findbuf[k]==0) break;
      }
    if(findbuf[k]==0) break;
  } else
  for(i=(ent ? maxr-1 : base+cy);i>=0;i--)
  {
    for(j=(cy+base==i ? cx+dx : 0);j<chl[i];j++)
     if(findbuf[0]==buf[i][j])
     {
       k=1;
       while(findbuf[k]==buf[i][j+k] && findbuf[k]!=0) k++;
       if(findbuf[k]==0) break;
      }
    if(findbuf[k]==0) break;
  }
  if(findbuf[k]==0)
  {
    cy=i%vish;
    base=i-cy;
    cx=k+j;dx=0;stx=0;
    view();
    showcurs();
   } else vmes("Warning!","String not found",(Viewer*)this);
  ent=0;
}
/////////////////////////////////End of file//////////////////////////////


