/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "query_windows.h"

/////////This file contains function for different window queries
/////////needed by Listers.

Win   *ww = NULL;
Win   *ow_win;
Text  *ow_t1, *ow_t2, *ow_t3, *ow_t4;
KEY   *ow_kyes, *ow_kyes_to_all, *ow_kno, *ow_kcancel;
Input *winp = NULL;
Switch *symsw = NULL;
int    update_query_work, update_ok;

extern char *fschr[];                //Array of VFS names (defined in bookmark.cxx)

extern int fsmax;                //Number of VFS types

void   wait_for_query_done()
{
  while (ow_query_work)
    {
      XNextEvent(disp, &ev);
      process_x_event(&ev);
    }
  XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
}

void   to_infowin_lastused();

void   ow_f()
{
  ow_query_work = 0;
  ow_kyes->hide();
  ow_kyes_to_all->hide();
  ow_kno->hide();
  ow_kcancel->hide();
  ow_win->hide();
  delete ow_kyes;
  delete ow_kno;
  delete ow_kyes_to_all;
  delete ow_kcancel;
  delete ow_t1;
  delete ow_t2;
  delete ow_t3;
  delete ow_t4;
  delete ow_win;
  panel->expose();
  if (panel->lay == 0)
    panel->panel2->expose();
  XFlush(disp);
  to_infowin_lastused();
}

void   up_f_cancel()
{
  update_query_work = 0;
  ow_kyes->hide();
  ow_kcancel->hide();
  ow_win->hide();
  delete ow_kyes;
  delete ow_kcancel;
  delete ow_t1;
  delete ow_t2;
  delete ow_win;
  panel->expose();
  if (panel->lay == 0)
    panel->panel2->expose();
  XFlush(disp);
  to_infowin_lastused();
}

void   up_f_ok()
{
  update_ok = 1;
  up_f_cancel();
}

void   ow_f_yes()
{
  ow_file = 1;
  ow_f();
}

void   ow_f_yes_to_all()
{
  ow_all = 1;
  ow_f();
}

void   ow_f_no()
{
  ow_file = ow_all = 0;
  ow_cancel = 0;
  ow_no = 1;
  ow_f();
}


void   ow_f_cancel()
{
  ow_file = ow_all = 0;
  ow_cancel = 254;
  ow_f();
}

void   ask_for_update()
{
  ow_win = new Win(centerx - 205, centery - 80, 410, 160, "User prompt", 5);
  ow_t1 = new Text(10, 50, "Update archive before exiting from it?", 5);
  ow_t2 = new Text(25, 85, "Press 'Update' if You change files", 1);
  ow_kyes = new KEY(10, -20, 180, 25, "Update", 1, up_f_ok);
  ow_kcancel = new KEY(-10, -20, 180, 25, "Cancel", 2, up_f_cancel);
  ow_win->init(Main);
  ow_t1->init(ow_win->w);
  ow_t2->init(ow_win->w);
  ow_kyes->init(ow_win->w);
  ow_kcancel->init(ow_win->w);
  ow_win->link(ow_kyes);
  ow_kyes->link(ow_kcancel);
  ow_kcancel->link(ow_kyes);
  ow_win->show();
  ow_t1->show();
  ow_t2->show();
  ow_kyes->show();
  ow_kcancel->show();
  XFlush(disp);
  update_query_work = 1;
  update_ok = 0;
  while (update_query_work)
    {
      XNextEvent(disp, &ev);
      process_x_event(&ev);
    }
  XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
}

void   init_overwrite_query(char *head, char *file)
{
  if (ow_query_work)
    return;
  ow_query_work = 1;
  ow_win = new Win(centerx - 200, centery - 80, 400, 160, head, 5);
  ow_t1 = new Text(10, 50, "File:", 5);
  ow_t2 = new Text(75, 50, file, 1);
  ow_t3 = new Text(65, 72, "This file already exists!", 1);
  ow_t4 = new Text(55, 95, "Overwrite existing file???", 5);
  ow_kyes = new KEY(10, -20, 80, 25, "Yes", 1, ow_f_yes);
  ow_kyes_to_all = new KEY(100, -20, 93, 25, "Yes to All", 1, ow_f_yes_to_all);
  ow_kcancel = new KEY(-10, -20, 80, 25, "Cancel", 2, ow_f_cancel);
  ow_kno = new KEY(-100, -20, 93, 25, "No", 1, ow_f_no);
  ow_win->init(Main);
  ow_t1->init(ow_win->w);
  ow_t2->init(ow_win->w);
  ow_t3->init(ow_win->w);
  ow_t4->init(ow_win->w);
  ow_kyes->init(ow_win->w);
  ow_kyes_to_all->init(ow_win->w);
  ow_kno->init(ow_win->w);
  ow_kcancel->init(ow_win->w);
  ow_win->link(ow_kyes);
  ow_kyes->link(ow_kyes_to_all);
  ow_kyes_to_all->link(ow_kno);
  ow_kno->link(ow_kcancel);
  ow_kcancel->link(ow_kyes);
  ow_win->show();
  ow_t1->show();
  ow_t2->show();
  ow_t3->show();
  ow_t4->show();
  ow_kyes->show();
  ow_kyes_to_all->show();
  ow_kno->show();
  ow_kcancel->show();
  XFlush(disp);
}


KEY   *wwk1, *wwk2, *wwk3;
Text  *wt1, *wt2, *wt3, *wt4, *wt5, *wt02;
Panel *pan, *pan2;
int    num;
int    attrmode;
char   wpath[256] = "Path:  none";
char   w_to_path[256] = "Path:  none";
char   wfile[80] = "File:  unknown";
char   wsize[30] = "Size:  unknown";
char   wattr[30] = "Status: rwxrwxrwx";
char   wowner[40] = "Owner: *********";
char   combuffer[100];
int    comnumber;

FList *acur;
MenuItem swt[] =
{"Read", 4, NULL, NULL,
 "Write", 4, NULL, NULL,
 "Execute", 4, NULL, NULL
};
MenuItem kills[] =
{"KILL [9]", 4, NULL, NULL,
 "Stop [19]", 4, NULL, NULL,
 "Cont [18]", 4, NULL, NULL,
 "Int [2]", 4, NULL, NULL,
 "Hup [1]", 4, NULL, NULL,
 "Term [15]", 4, NULL, NULL,
 "Alarm [14]", 4, NULL, NULL,
 "User1 [10]", 4, NULL, NULL,
 "User2 [12]", 4, NULL, NULL};

int    sigkills[10] =
{SIGKILL, SIGSTOP, SIGCONT, SIGINT, SIGHUP, SIGTERM, SIGALRM, SIGUSR1, SIGUSR2, SIGKILL};
Sw_panel *wot, *wow, *wgr, *swkill = NULL;

int    meswinnum;
void   meswinok()
{
  wwk1->hide();
  delete wwk1;
  wt1->hide();
  delete wt1;
  ww->hide();
  delete ww;
  ww = NULL;
  if (panel)
    {
      XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
      panel->funcs(meswinnum);
    }
  XFlush(disp);
}

void   create_meswin(char *head, char *te, int n)
{
  if (ww == NULL)
    {
      meswinnum = n;
      ww = new Win(centerx - 140, centery - 80, 290, 125, head, 5);
      wt1 = new Text(60, 50, te, 5);
      wwk1 = new KEY(65, -20, 160, 25, "OK", 1, meswinok);
      wt1->recalc();
      ww->init(Main);
      wt1->init(ww->w);
      wwk1->init(ww->w);
      ww->link(wt1);
      wt1->link(wwk1);
      wwk1->link(wwk1);
      ww->show();
      wt1->show();
      wwk1->show();
      XFlush(disp);
    }
}

void   testok()
{
  int    i, mask = S_IRUSR;
  for (i = 0; i < 3; i++)
    {
      if (wow->get(i))
        acur->mode |= mask;
      else if (acur->mode & mask)
        acur->mode ^= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wgr->get(i))
        acur->mode |= mask;
      else if (acur->mode & mask)
        acur->mode ^= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wot->get(i))
        acur->mode |= mask;
      else if (acur->mode & mask)
        acur->mode ^= mask;
      mask >>= 1;
    }
  wwk1->hide();
  wwk2->hide();
  wow->hide();
  wot->hide();
  wgr->hide();
  ww->hide();
  wt2->hide();
  wt1->hide();
  delete ww;
  delete wwk1;
  delete wwk2;
  delete wow;
  delete wot;
  delete wgr;
  delete wt2;
  delete wt1;
  ww = NULL;
  if (panel)
    {
      XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
      panel->funcs(num);
    }
}

void   testcan()
{
  wwk1->hide();
  wwk2->hide();
  wow->hide();
  wot->hide();
  wgr->hide();
  ww->hide();
  wt2->hide();
  wt1->hide();
  delete ww;
  delete wwk1;
  delete wwk2;
  delete wow;
  delete wot;
  delete wgr;
  delete wt2;
  delete wt1;
  ww = NULL;
  if (panel)
    XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   atcan()
{
  wwk1->hide();
  wwk2->hide();
  wwk3->hide();
  wow->hide();
  wot->hide();
  wgr->hide();
  ww->hide();
  wt2->hide();
  delete ww;
  delete wwk1;
  delete wwk2;
  delete wow;
  delete wot;
  delete wgr;
  delete wt2;
  delete wwk3;
  ww = NULL;
  if (panel)
    XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   atset()
{
  attrmode = 0;
  int    i, mask = S_IRUSR;
  for (i = 0; i < 3; i++)
    {
      if (wow->get(i))
        attrmode |= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wgr->get(i))
        attrmode |= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wot->get(i))
        attrmode |= mask;
      mask >>= 1;
    }
  atcan();
  panel->setattrs(1);
}

void   atclear()
{
  attrmode = 0xffffffff;
  int    i, mask = S_IRUSR;
  for (i = 0; i < 3; i++)
    {
      if (wow->get(i))
        attrmode ^= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wgr->get(i))
        attrmode ^= mask;
      mask >>= 1;
    }
  for (i = 0; i < 3; i++)
    {
      if (wot->get(i))
        attrmode ^= mask;
      mask >>= 1;
    }
  atcan();
  panel->setattrs(0);
}

void   attrib(FList * cur, int inum)
{
  int    i, mask = S_IRUSR;
  if (ww == NULL)
    {
      num = inum;
      acur = cur;
      sprintf(wfile, "File: %s", cur->name);
      ww = new Win(centerx - 140, centery - 150, 290, 305, "Attributes", 5);
      wwk1 = new KEY(150, -70, 120, 25, "OK", 1, testok);
      wwk2 = new KEY(150, -20, 120, 25, "Cancel", 2, testcan);
      wow = new Sw_panel(10, 70, 120, "Owner:", swt, 3);
      wgr = new Sw_panel(150, 70, 120, "Group:", swt, 3);
      wot = new Sw_panel(10, 190, 120, "Other:", swt, 3);
      wt2 = new Text(10, 40, wfile, 1);
      wt2->recalc();
      sprintf(wowner, "Owner: %s.%s", finduser(cur->uid), findgroup(cur->gid));
      wt1 = new Text(10, 60, wowner, 1);
      wt1->recalc();
      ww->init(Main);
      wwk1->init(ww->w);
      wwk2->init(ww->w);
      wow->init(ww->w);
      wot->init(ww->w);
      wgr->init(ww->w);
      wt2->init(ww->w);
      wt1->init(ww->w);
      ww->link(wwk1);
      wwk1->link(wwk2);
      wwk2->link(wow->ar[0]);
      wow->link(wot->ar[0]);
      wot->link(wgr->ar[0]);
      wgr->link(wwk1);
      wwk1->set_escapefunc(testcan);
      wwk2->set_escapefunc(testcan);
      for (i = 0; i < 3; i++)
        {
          if ((cur->mode & mask) == 0)
            wow->set(i, 0);
          else
            wow->set(i, 1);
          mask >>= 1;
        }
      for (i = 0; i < 3; i++)
        {
          if ((cur->mode & mask) == 0)
            wgr->set(i, 0);
          else
            wgr->set(i, 1);
          mask >>= 1;
        }
      for (i = 0; i < 3; i++)
        {
          if ((cur->mode & mask) == 0)
            wot->set(i, 0);
          else
            wot->set(i, 1);
          mask >>= 1;
        }
      ww->show();
      wwk1->show();
      wwk2->show();
      wow->show();
      wgr->show();
      wot->show();
      wt2->show();
      wt1->show();
    }
}

void   attrib2()
{
  if (ww == NULL)
    {
      strcpy(wfile, "For all selected files:");
      ww = new Win(centerx - 140, centery - 150, 290, 305, "Set/Clear attributes", 5);
      wwk1 = new KEY(150, -90, 120, 25, "Set", 1, atset);
      wwk2 = new KEY(150, -50, 120, 25, "Clear", 1, atclear);
      wwk3 = new KEY(150, -15, 120, 25, "Cancel", 2, atcan);
      wow = new Sw_panel(10, 70, 120, "Owner:", swt, 3);
      wgr = new Sw_panel(150, 70, 120, "Group:", swt, 3);
      wot = new Sw_panel(10, 190, 120, "Other:", swt, 3);
      wt2 = new Text(10, 50, wfile, 1);
      wt2->recalc();
      ww->init(Main);
      wwk1->init(ww->w);
      wwk2->init(ww->w);
      wwk3->init(ww->w);
      wow->init(ww->w);
      wot->init(ww->w);
      wgr->init(ww->w);
      wt2->init(ww->w);
      ww->link(wwk1);
      wwk1->link(wwk2);
      wwk2->link(wwk3);
      wwk3->link(wow->ar[0]);
      wow->link(wot->ar[0]);
      wot->link(wgr->ar[0]);
      wgr->link(wwk1);
      wwk1->set_escapefunc(atcan);
      wwk2->set_escapefunc(atcan);
      wwk3->set_escapefunc(atcan);
      ww->show();
      wwk1->show();
      wwk2->show();
      wwk3->show();
      wow->show();
      wgr->show();
      wot->show();
      wt2->show();
    }
}

void   okquery()
{
  if (winp)                        //Check dbuf for directory existance

    {
      char   type[20];
      struct stat st;
      char  *b = strchr(dbuf, ':');
      if (b == NULL)
        strcpy(type, "DFS");
      else
        strncpy(type, dbuf, b - dbuf);
      if (detect_fs(type) == DFS_TYPE)        //Currently  do checking only on DFS

        {
          if (stat(b ? b + 1 : dbuf, &st) == -1 || S_ISDIR(st.st_mode) == 0)
            {
              XBell(disp, 0);
              return;
            }
        }
    }
  wwk2->hide();
  wwk1->hide();
  if (symsw)
    {
      symlink_as_is = symsw->sw;
      symsw->hide();
      delete symsw;
      symsw = NULL;
      winp->hide();
      delete winp;
      winp = NULL;
    }
  else
    {
      delete wt02;
      delete wt5;
    }
  ww->hide();
  delete ww;
  delete wwk1;
  delete wwk2;
  delete wt1;
  delete wt2;
  delete wt3;
  delete wt4;
  ww = NULL;
  if (panel)
    {
      XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
      panel->funcs(num);
    }
}

void   canquery()
{
  wwk2->hide();
  wwk1->hide();
  if (symsw)
    {
      symsw->hide();
      delete symsw;
      symsw = NULL;
      winp->hide();
      delete winp;
      winp = NULL;
    }
  else
    {
      delete wt5;
      delete wt02;
    }
  ww->hide();
  delete ww;
  delete wwk1;
  delete wwk2;
  delete wt1;
  delete wt2;
  delete wt3;
  delete wt4;
  if (afstmp_defined)
    {
      afstmp.delete_vfs_list();
      afstmp_defined = 0;
    }
  bmark->set_recycle_image(0);
  if (panel)
    XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
  ww = NULL;
}

void   initquery(char *head, Lister * p1, VFS * vfs, int inum)
{
  int    tl;
  int    i, mask = S_IRUSR;
  if (ww == NULL)
    {
      num = inum;
      sprintf(wpath, "From: %s", p1->curdir);
      if (inum == 0)
        sprintf(w_to_path, "To:   Recycle Bin");
      else if (inum == 8)
        sprintf(w_to_path, "To:   Printer");
      else if (vfs->need_dir_prefix)
        {
          sprintf(dbuf, "%s:%s", vfs->vfs_prefix, vfs->curdir);
          sprintf(w_to_path, "To:   %s", dbuf);
        }
      else
        {
          sprintf(w_to_path, "To:   %s", vfs->curdir);
          strcpy(dbuf, vfs->curdir);
        }
      strcpy(wattr, "Status: rwxrwxrwx");
      if (p1->selfiles)
        {
          sprintf(wfile, "File:   %d selected files", p1->selfiles);
          sprintf(wsize, "Size:   %d", p1->selsize);
          strcpy(wattr, "Status: *********");
          strcpy(wowner, "Owner:  *********");
        }
      else
        {
          sprintf(wfile, "File:   %s", p1->cur->name);
          sprintf(wsize, "Size:   %d", p1->cur->size);
          for (i = 0; i < 9; i++)
            {
              if ((p1->cur->mode & mask) == 0)
                wattr[i + 8] = '-';
              mask >>= 1;
            }
          sprintf(wowner, "Owner:  %s.%s", finduser(p1->cur->uid), findgroup(p1->cur->gid));
        }
      wt1 = new Text(10, 45, wpath, 1);
      wt02 = new Text(10, 65, w_to_path, 1);
      wt2 = new Text(10, 85, wfile, 5);
      wt3 = new Text(10, 105, wowner, 1);
      wt4 = new Text(10, 125, wattr, 1);
      wt5 = new Text(10, 145, wsize, 1);
      wt1->recalc();
      wt2->recalc();
      wt02->recalc();
      wt3->recalc();
      wt4->recalc();
      wt5->recalc();
      tl = wt2->l + 140;
      if (wt1->l >= wt2->l && wt1->l >= wt4->l && wt1->l >= wt3->l)
        tl = wt1->l + 140;
      if (wt4->l >= wt2->l && wt4->l >= wt1->l && wt4->l >= wt3->l)
        tl = wt4->l + 140;
      if (wt3->l >= wt2->l && wt3->l >= wt1->l && wt3->l >= wt4->l)
        tl = wt3->l + 140;
      ww = new Win(centerx - tl / 2, Mainh / 2 - 100, tl, 160, head, 5);
      wwk1 = new KEY(-20, -60, 80, 25, "OK", 1, okquery);
      wwk2 = new KEY(-20, -20, 80, 25, "Cancel", 2, canquery);
      wwk1->set_escapefunc(canquery);
      wwk2->set_escapefunc(canquery);
      ww->link(wwk1);
      wwk1->link(wwk2);
      wwk2->link(wwk1);
      ww->init(Main);
      wwk1->init(ww->w);
      wwk2->init(ww->w);
      wt1->init(ww->w);
      wt02->init(ww->w);
      wt2->init(ww->w);
      wt3->init(ww->w);
      wt4->init(ww->w);
      wt5->init(ww->w);
      ww->show();
      wwk1->show();
      wwk2->show();
      wt1->show();
      wt2->show();
      wt02->show();
      wt3->show();
      wt4->show();
      wt5->show();
    }
}

void   init_copymove_query(char *head, Lister * p1, VFS * vfs, int inum)
{
  int    tl;
  if (ww == NULL)
    {
      num = inum;
      sprintf(wpath, "From: %s", p1->curdir);
      if (vfs->need_dir_prefix)
        {
          sprintf(dbuf, "%s:%s", vfs->vfs_prefix, vfs->curdir);
        }
      else
        {
          strcpy(dbuf, vfs->curdir);
        }
      sprintf(wfile, "File:   %d selected files", p1->selfiles);
      sprintf(wsize, "Size:   %d", p1->selsize);

      wt1 = new Text(10, 45, wpath, 1);
      wt2 = new Text(10, 135, wfile, 5);
      wt3 = new Text(10, 155, wsize, 5);
      wt4 = new Text(10, 72, "To:", 1);
      wt1->recalc();
      wt2->recalc();
      wt3->recalc();
      wt4->recalc();
      tl = wt1->l + 140;
      if (tl < 400)
        tl = 400;
      ww = new Win(centerx - tl / 2, Mainh / 2 - 100, tl, 170, head, 5);
      wwk1 = new KEY(-20, -50, 80, 25, "OK", 1, okquery);
      wwk2 = new KEY(-20, -15, 80, 25, "Cancel", 2, canquery);
      winp = new Input(50, 55, tl - 70, 1, okquery);
      symsw = new Switch(55, 90, 250, "Translate symlinks as is.", 1);
      symsw->sw= inum==1 ? 0 : 1;
      symsw->disable=symsw->sw;
      winp->set_escapefunc(canquery);
      wwk1->set_escapefunc(canquery);
      wwk2->set_escapefunc(canquery);
      ww->link(winp);
      winp->link(symsw);
      symsw->link(wwk1);
      wwk1->link(wwk2);
      wwk2->link(winp);
      ww->init(Main);
      winp->init(ww->w);
      symsw->init(ww->w);
      wwk1->init(ww->w);
      wwk2->init(ww->w);
      wt1->init(ww->w);
      wt2->init(ww->w);
      wt3->init(ww->w);
      wt4->init(ww->w);
      winp->setbuf(dbuf, 1023);
      ww->show();
      winp->show();
      symsw->show();
      wwk1->show();
      wwk2->show();
      wt1->show();
      wt2->show();
      wt3->show();
      wt4->show();
    }
}

//////////////////////////////////////////////////////////////////////////////
Win   *dw = NULL;
KEY   *dok;
KEY   *dcan;
Input *din;
Text  *dt1, *dt2, *dt3, *dt4, *dt5;

void   dialogok()
{
  if (din->bl)
    {
      din->hide();
      dok->hide();
      dcan->hide();
      if (symsw)
        {
          symlink_as_is = symsw->sw;
          symsw->hide();
          delete symsw;
          symsw = NULL;
        }
      dw->hide();
      delete dw;
      delete din;
      delete dok;
      delete dcan;
      delete dt1;
      delete dt2;
      delete dt3;
      dw = NULL;
      XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
      panel->funcs(num);
    }
}

void   dialogcan()
{
  din->hide();
  dok->hide();
  dcan->hide();
  if (symsw)
    {
      symsw->hide();
      delete symsw;
      symsw = NULL;
    }
  dw->hide();
  delete dw;
  delete din;
  delete dok;
  delete dcan;
  delete dt1;
  delete dt2;
  delete dt3;
  dw = NULL;
  if (afstmp_defined)
    {
      afstmp.delete_vfs_list();
      afstmp_defined = 0;
    }
  XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   nfok()
{
  if (din->bl)
    {
      din->hide();
      dok->hide();
      dcan->hide();
      dw->hide();
      delete dw;
      delete din;
      delete dok;
      delete dcan;
      delete dt1;
      XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
      dw = NULL;
      panel->funcs(num);
    }
}

void   nfcan()
{
  din->hide();
  dok->hide();
  dcan->hide();
  dw->hide();
  delete dw;
  delete din;
  delete dok;
  delete dcan;
  delete dt1;
  dw = NULL;
  XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   mes_cancel()
{
  dok->hide();
  dw->hide();
  delete dw;
  delete dok;
  delete dt1;
  dw = NULL;
  XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   fchowncan()
{
  din->hide();
  dok->hide();
  dcan->hide();
  pan->hide();
  pan2->hide();
  dw->hide();
  delete dw;
  delete din;
  delete dok;
  delete dcan;
  delete dt1;
  delete dt2;
  delete dt3;
  delete dt4;
  delete dt5;
  delete pan;
  delete pan2;
  dw = NULL;
  for (int i = 0; i < 200; i++)
    panlist[i] = NULL;
  XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   fchownok()
{
  fchowncan();
  panel->funcs(20);
}

int    panusr(int, char *m)
{
  char   str[30] = "";
  int    i = 0;
  while (dbuf[i] != '.' && dbuf[i] != 0)
    i++;
  if (dbuf[i] == '.')
    strcpy(str, dbuf + i);
  strcpy(dbuf, m);
  strcat(dbuf, str);
  din->setbuf(dbuf, 56);
  din->expose();
}

int    pangrp(int, char *m)
{
  int    i = 0;
  while (dbuf[i] != '.' && dbuf[i] != 0)
    i++;
  if (dbuf[i] == '.')
    strcpy(dbuf + i + 1, m);
  else
    {
      strcat(dbuf, ".");
      strcat(dbuf, m);
    }
  din->setbuf(dbuf, 56);
  din->expose();
}

void   init_chown_dialog(FList * cur)
{
  USR   *o = users.next;
  char  *at = "rwxrwxrwx";
  int    mask = 0400, u = 0, g = 0, i;
  if (dw == NULL)
    {
      while (o != NULL)
        {
          panlist[u] = o->name;
          u++;
          o = o->next;
        }
      o = groups.next;
      while (o != NULL)
        {
          panlist2[g] = o->name;
          g++;
          o = o->next;
        }
      if (panel->selfiles == 0)
        {
          sprintf(wfile, "File:  %s", cur->name);
          sprintf(dbuf, "%s.%s", finduser(cur->uid), findgroup(cur->gid));
          strcpy(wowner, "Attributes: ");
          for (i = 0; i < 9; i++)
            {
              if (cur->mode & mask)
                wowner[12 + i] = at[i];
              else
                wowner[12 + i] = '-';
              mask >>= 1;
            }
          wowner[12 + i] = 0;
        }
      else
        {
          sprintf(wfile, "File: %d selected", panel->selfiles);
          strcpy(wowner, "Attributes: *********");
          sprintf(dbuf, "%s.%s", finduser(cur->uid), findgroup(cur->gid));
        }
      dw = new Win(centerx - 200, centery - 180, 403, 340, "Change Owner", 5);
      dok = new KEY(40, -20, 110, 25, "Change", 1, fchownok);
      dcan = new KEY(-40, -20, 110, 25, "Cancel", 2, fchowncan);
      din = new Input(10, 89, 380, 1, fchownok);
      dt1 = new Text(10, 40, wfile, 1);
      dt2 = new Text(10, 60, wowner, 1);
      dt3 = new Text(10, 80, "Owner:", 5);
      dt4 = new Text(10, 130, "Users:", 5);
      dt5 = new Text(210, 130, "Groups:", 5);
      pan = new Panel(10, 135, 180, 150, panlist, u, 1, panusr);
      pan->escfunc(fchowncan);
      pan2 = new Panel(210, 135, 180, 150, panlist2, g, 1, pangrp);
      pan2->escfunc(fchowncan);
      din->set_escapefunc(fchowncan);
      dok->set_escapefunc(fchowncan);
      dcan->set_escapefunc(fchowncan);
      dw->init(Main);
      din->init(dw->w);
      pan->init(dw->w);
      pan2->init(dw->w);
      dok->init(dw->w);
      dcan->init(dw->w);
      dt1->init(dw->w);
      dt2->init(dw->w);
      dt3->init(dw->w);
      dt4->init(dw->w);
      dt5->init(dw->w);
      dw->link(din);
      din->link(pan);
      pan->link(pan2);
      pan2->link(dok);
      dok->link(dcan);
      dcan->link(din);
      din->setbuf(dbuf, 56);
      dw->show();
      din->show();
      dok->show();
      dcan->show();
      pan->show();
      pan2->show();
      dt1->show();
      dt2->show();
      dt3->show();
      dt4->show();
      dt5->show();
      pan->find_and_set(finduser(cur->uid));
      pan2->find_and_set(findgroup(cur->gid));
    }
}

void   initdialog(char *head, Lister * l1, VFS * vf, int inum)
{
  if (dw == NULL)
    {
      num = inum;
      sprintf(wfile, "File:  %s", l1->cur->name);
      sprintf(wowner, "Owner:  %s.%s", finduser(l1->cur->uid), findgroup(l1->cur->gid));
      dw = new Win(centerx - 200, centery - 120, 403, 195, head, 5);
      dok = new KEY(40, -20, 80, 25, "OK", 1, dialogok);
      dcan = new KEY(-40, -20, 80, 25, "Cancel", 2, dialogcan);
      din = new Input(10, 89, 380, 1, dialogok);
      dt1 = new Text(10, 40, wfile, 5);
      dt2 = new Text(10, 60, wowner, 3);
      dt3 = new Text(10, 80, "To directory:", 5);
      symsw = new Switch(20, 120, 300, "Translate symlinks as is.", 5);
      symsw->sw = (inum==2);
      symsw->disable=symsw->sw;
      din->set_escapefunc(dialogcan);
      dok->set_escapefunc(dialogcan);
      dcan->set_escapefunc(dialogcan);
      dw->init(Main);
      din->init(dw->w);
      dok->init(dw->w);
      dcan->init(dw->w);
      dt1->init(dw->w);
      dt2->init(dw->w);
      dt3->init(dw->w);
      symsw->init(dw->w);
      dw->link(din);
      din->link(symsw);
      symsw->link(dok);
      dok->link(dcan);
      dcan->link(din);
      dbuf[0] = 0;
      if (vf)
        {
          if (vf->need_dir_prefix)
            sprintf(dbuf, "%s:%s", vf->vfs_prefix, vf->curdir);
          else
            strcpy(dbuf, vf->curdir);
          if (dbuf[strlen(dbuf) - 1] != '/')
            strcat(dbuf, "/");
        }
      din->setbuf(dbuf, 255);
      dw->show();
      din->show();
      dok->show();
      dcan->show();
      dt1->show();
      dt2->show();
      dt3->show();
      symsw->show();
    }
}

void   newtextfile(char *head, Lister * l1, int inum)
{
  if (dw == NULL)
    {
      num = inum;
      dw = new Win(centerx - 150, 120, 303, 130, head, 5);
      dok = new KEY(40, -20, 80, 25, "OK", 1, nfok);
      dcan = new KEY(-40, -20, 80, 25, "Cancel", 2, nfcan);
      din = new Input(10, 50, 280, 1, nfok);
      dt1 = new Text(10, 40, "New Name:", 5);
      dok->set_escapefunc(nfcan);
      dcan->set_escapefunc(nfcan);
      din->set_escapefunc(nfcan);
      dw->init(Main);
      din->init(dw->w);
      dok->init(dw->w);
      dcan->init(dw->w);
      dt1->init(dw->w);
      dw->link(din);
      din->link(dok);
      dok->link(dcan);
      dcan->link(din);
      dbuf[0] = 0;
      din->setbuf(dbuf, 255);
      dw->show();
      din->show();
      dok->show();
      dcan->show();
      dt1->show();
    }
}

void   simple_mes(char *head, char *mes)
{
  if (dw == NULL)
    {
      dt1 = new Text(20, 50, mes, 1);
      dt1->recalc();
      dw = new Win(centerx - dt1->l / 2 - 20, centery - 80, dt1->l + 40, 110, head, 5);
      dok = new KEY(30, -20, dt1->l - 30, 25, "OK", 1, mes_cancel);
      dok->set_escapefunc(mes_cancel);
      dw->init(Main);
      dw->add_toexpose(dt1);
      dok->init(dw->w);
      dt1->init(dw->w);
      dw->link(dok);
      dok->link(dok);
      dw->show();
      dok->show();
      dt1->show();
    }
}

void   show_vfs_error()
{
  simple_mes(vfshead, vfserr);
}


void   pancan()
{
  dw->hide();
  pan->hide();
  if (swkill)
    {
      swkill->hide();
      dok->hide();
      dcan->hide();
      delete swkill;
      delete dok;
      delete dcan;
      swkill = NULL;
    }
  delete pan;
  delete dw;
  dw = NULL;
  if (psmax > 0)
    {
      delps(psmax);
      psmax = 0;
    };
  XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

int    panexec(int i, char *m)
{
  pancan();
  panel->ext_exec(m);
  return 0;
}

int    panexec2(int i, char *m)
{
  pancan();
  comnumber = i;
  panel->menu_exec(menucom[i]);
  return 0;
}

char   mntmnt[80];
int    panmnt(int i, char *m)
{
  pancan();
  tt_printf("umount %s\n", m);
  strcpy(mntmnt, m);
  create_meswin("Remounting", "Change DEVICE NOW", 22);
}

int    panmntmnt()
{
  tt_printf("mount %s\n", mntmnt);
  panel->reread();
  if (panel->lay == 0)
    panel->panel2->reread();
  return 0;
}

int    pankill(int i, char *m)
{
  int    pid, ii;
  if (i > 0)
    {
      sscanf(m, "%d", &pid);
      for (ii = 0; ii < 9; ii++)
        if (swkill->get(ii))
          break;
      pid = kill(pid, sigkills[ii]);
      pancan();
      if (pid == -1)
        simple_mes("Error", "Kill failed");
    }
}

void   menukey(KeySym ks, Panel *)
{
  int    i = findmenukey(ks);
  if (i != -1)
    panexec2(i, NULL);
}

void   newpanel(char *head, int n, int (*prfunc) (int, char *), int wl)
{
  if (dw == NULL)
    {
      dw = new Win(centerx - wl / 2, centery - 100, wl, 200, head, 5);
      pan = new Panel(20, 30, wl - 40, 150, panlist, n, 1, prfunc);
      dw->set_escapefunc(pancan);
      pan->escfunc(pancan);
      dw->init(Main);
      pan->init(dw->w);
      dw->link(pan);
      pan->link(pan);
      dw->show();
      pan->show();
    }
}

void   pankillok()
{
  pan->activate_function();
}

void   newkillpanel(char *head, int n, int (*prfunc) (int, char *), int wl)
{
  if (dw == NULL)
    {
      dw = new Win(centerx - wl / 2, centery - 200, wl, 320, head, 5);
      pan = new Panel(20, 30, wl - 40, 150, panlist, n, 1, prfunc);
      swkill = new Sw_panel(20, 196, 150, "Signals for sending:", kills, 9, 3);
      dok = new KEY(-15, 220, 100, 25, "Send", 1, pankillok);
      dcan = new KEY(-15, 255, 100, 25, "Cancel", 2, pancan);
      pan->escfunc(pancan);
      dw->set_escapefunc(pancan);
      dw->init(Main);
      pan->init(dw->w);
      swkill->init(dw->w);
      dok->init(dw->w);
      dcan->init(dw->w);
      dw->link(pan);
      pan->link(swkill->ar[0]);
      swkill->link(dok);
      dok->link(dcan);
      dcan->link(pan);
      swkill->excl();
      swkill->set(0, 1);
      dw->show();
      pan->show();
      swkill->show();
      dok->show();
      dcan->show();
    }
}

void   dfs_info(int wl)
{
  if (dw == NULL)
    {
      dw = new Win(centerx - wl / 2, centery - 100, wl, 200, "Disk Free Space", 5);
      pan = new Panel(20, 30, wl - 40, 150, panlist, 0, 1, NULL);
      pan->escfunc(pancan);
      dw->set_escapefunc(pancan);
      dw->init(Main);
      pan->init(dw->w);
      dw->link(pan);
      pan->link(pan);
      dw->show();
      pan->show();
      psmax = getdf(pan);
    }
}

void   free_info(int wl)
{
  if (dw == NULL)
    {
      dw = new Win(centerx - wl / 2, centery - 80, wl, 160, "Memory Information", 5);
      pan = new Panel(20, 30, wl - 40, 110, panlist, 0, 1, NULL);
      pan->escfunc(pancan);
      dw->set_escapefunc(pancan);
      dw->init(Main);
      pan->init(dw->w);
      dw->link(pan);
      pan->link(pan);
      dw->show();
      pan->show();
      psmax = getfree(pan);
    }
}

void   menupanel(int (*prfunc) (int, char *))
{
  if (dw == NULL)
    {
      dw = new Win(centerx - 225, centery - 100, 453, 200, "Menu commands", 5);
      pan = new Panel(20, 30, 410, 150, menunames, menumax, 1, prfunc);
      dw->set_escapefunc(pancan);
      pan->escfunc(pancan);
      pan->setkeyfunc(menukey);
      dw->init(Main);
      pan->init(dw->w);
      dw->link(pan);
      pan->link(pan);
      dw->show();
      pan->show();
    }
}

void   selectmask(Lister * l1, int inum)
{
  if (dw == NULL)
    {
      num = inum;
      if (num == 5)
        dw = new Win(centerx - 125, 150, 253, 130, "Select files", 5);
      else
        dw = new Win(centerx - 125, 150, 253, 130, "Deselect files", 5);
      dok = new KEY(20, -20, 80, 25, "OK", 1, nfok);
      dcan = new KEY(-20, -20, 80, 25, "Cancel", 2, nfcan);
      din = new Input(10, 50, 230, 1, nfok);
      dt1 = new Text(10, 40, "Mask:", 5);
      din->set_escapefunc(nfcan);
      dw->init(Main);
      din->init(dw->w);
      dok->init(dw->w);
      dcan->init(dw->w);
      dt1->init(dw->w);
      dw->link(din);
      din->link(dok);
      dok->link(dcan);
      dcan->link(din);
      strcpy(dbuf, l1->maskchr);
      din->setbuf(dbuf, 255);
      dw->show();
      din->show();
      dok->show();
      dcan->show();
      dt1->show();
    }
}
