XCOMM!/bin/sh
XCOMM xplore setup script

XCOMM Create the user's xplore setup. Currently, this only copies the standard
XCOMM shelf from the library directory and puts some links in there.

sysxplorerc=system.xplorerc
userxplorerc=.xplorerc
sysmagic=magic
usermagic=.magic
sysshelf=shelf
usershelf=shelf

if [ -d "$XPLORELIBDIR" ]; then
  cd "$XPLORELIBDIR"
else
  cd XPLORELIBDIR
fi

if [ ! -d "$sysshelf" -o ! -f "$sysxplorerc" -o ! -f "$sysmagic" ]; then
  echo $0: fatal error: invalid library directory
  echo "(Please check the value of the XPLORELIBDIR environment variable.)"
  exit 1
fi

XCOMM If you would like to copy the configuration files as well, uncomment the
XCOMM lines below.

XCOMM if [ ! -f "$HOME/$userxplorerc" ]; then
XCOMM   echo $0: installing the configuration file
XCOMM   cp $sysxplorerc $HOME/$userxplorerc
XCOMM fi

XCOMM if [ ! -f "$HOME/$usermagic" ]; then
XCOMM   echo $0: installing the magic file
XCOMM   cp $sysmagic $HOME/$usermagic
XCOMM fi

if [ ! -d "$HOME/$usershelf" ]; then

  echo $0: installing the shelf
  mkdir "$HOME/$usershelf"
  cd "$sysshelf"
  tar cf - * | tar xfC - "$HOME/$usershelf"

XCOMM Make some links to devices and the user's home directory.
XCOMM Note: These are only examples. You might have to adapt this (and the
XCOMM system.xplorerc file) to your local setup.

  if [ -d /dos/a ]; then
    ln -s /dos/a "$HOME/$usershelf/Desk/A:"
  fi
  if [ -d /dos/c ]; then
    ln -s /dos/c "$HOME/$usershelf/Desk/C:"
  fi
  if [ -d /cdrom ]; then
    ln -s /cdrom "$HOME/$usershelf/Desk/CDROM"
  fi

  ln -s "$HOME" "$HOME/$usershelf/Desk/Home"

XCOMM Install some common applications in the Programs shelf.
XCOMM Note: This requires the which(1) program.

  apps="editres emacs netscape xfig xgrab xpaint xterm"
  if [ -d "$HOME/$usershelf/Programs" ]; then
    for app in $apps; do
      if [ -x "`which $app`" ]; then
        ln -s "`which $app`" "$HOME/$usershelf/Programs"
      fi
    done
  fi

fi
