/* ICodeWriter.C */

#include "ICodeWriter.h"
// Super Class : None

/*oodB%ICodeWriter*** Global Declarations and Stuffs ****/
#include "Guide.h"
#include "DesignEditor.h"
/*oodE***************************************************/

ICodeWriter::~ICodeWriter()
{
	// Empty
}

ICodeWriter::ICodeWriter(Guide* guide)
{
  _guide = guide;
  _makefileT = _guide->getTemplatePath() + "/Makefile";
  _designEditor = _guide->getDesignEditor();
}

void ICodeWriter::writeFile(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  delete newfile;
}

void ICodeWriter::writeInterfaces(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());

  _guide->codeInterfaces(newfile);
  delete newfile;
}

void ICodeWriter::writeOther(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeOthers(newfile);
  delete newfile;
}

void ICodeWriter::writeMakefile(String filename)
{
  ifstream *makefileT;
  ofstream *newfile;
  String makefileTemplate;
  char buffer[BUFSIZ];

  makefileT = new ifstream(_makefileT.data());
  newfile = new ofstream(filename.data());

  while(makefileT->getline(buffer,BUFSIZ) != NULL)
  { /* the file is not empty */

    makefileTemplate += buffer;
    makefileTemplate += "\n";

    // if this is the end of the file stop
    if(makefileT->eof())
      break;
  } /* the file is not empty */

  cout << makefileTemplate << endl;

  *newfile << makefileTemplate << endl;

  delete newfile;
  delete makefileT;
}

void ICodeWriter::writeResources(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeXResources(newfile);
  delete newfile;
}

void ICodeWriter::writeExterns(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeExterns(newfile);
  delete newfile;
}

void ICodeWriter::writeCallbacks(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeCallbacks(newfile);
  delete newfile;
}

void ICodeWriter::writeEvents(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeEvents(newfile);
  delete newfile;
}

void ICodeWriter::writeMain(String filename)
{
  ofstream *newfile;
  newfile = new ofstream(filename.data());
  _guide->codeMain(newfile);
  delete newfile;
}
