/* XMBulletinBoard.C */

#include "XMBulletinBoard.h"
// Super Class : XtManager

/*oodB%XMBulletinBoard*** Global Declarations and Stuffs ****/
Pixmap XMBulletinBoard::XMBulletinBoard_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMBulletinBoard::_bulletinBoardResources[16] = {
  /* name type value default option get set create modified */
  "allowOverlap","Boolean","True","True","True,False",
  True,True,True,False,
  "If True (default), child widgets are allowed to overlap.",
  "autoUnmanage","Boolean","True","True","True,False",
  True,True,True,False,
  "If True (default), the bulletinboard is automatically unmanaged \
after a button is activated unless the button is an Apply or Help button.",
  "buttonFontList","XmFontList","dynamic","dynamic","NONE",
  True,False,False,False,
  "The fontlist used for the button children of the bulletinboard widget.",
  "cancelButton","Window","NULL","NULL","NONE",
  True,False,False,False,
  "The widget ID of the CANCEL button. The subclasses of the \
bulletinboard define a cancel button and set this resource.",
  "defaultButton","Window","NULL","NULL","NONE",
  True,False,False,False,
  "The widget ID of the default button. Some of the subclasses of the \
bulletinboard widget define a default button and set this resource. \
To indicate that it is the default this button appears different \
from the others.",
  "defaultPosition","Boolean","True","True","True,False",
  True,True,True,False,
  "If True (default), and if the bulletinbaord is a child of the \
dialogshell, then the bulletinboard is centered relative to the \
dialogshell's parent.",
  "dialogStyle","UnsignedChar","dynamic","dynamic","XmDIALOG_WORK_AREA,XmDIALOG_MODELESS,XmDIALOG_FULL_APPLICATION_MODAL,XmDIALOG_APPLICATION_MODAL,XmDIALOG_PRIMARY_APPLICATION_MODAL,XmDIALOG_SYSTEM_MODAL",
  True,True,True,False,
  "The bulletinboard's dialog style, whose value can be set only \
if the bulletinboard is unmanaged.",
  "dialogTitle","XmString","NULL","NULL","NONE",
  True,False,False,False,
  "The dialog title. Setting this resource also set the resources \
XmNtitle and XmNtitleEncoding in a parent that is a subclass of WMShell.",
  "labelFontList","XmFontList","dynamic","dynamic","NONE",
  True,False,False,False,
  "The font list used for label children.",
  "marginHeight","Dimension","10","10","NONE",
  True,True,True,False,
  "Minimum spacing between the bulletinboard top and bottom edges and \
any child widget.",
  "marginWidth","Dimension","10","10","NONE",
  True,True,True,False,
  "Minimum spacing between the bulletinboard left and right edges and \
any child widget.",
  "noResize","Boolean","False","False","True,False",
  True,True,True,False,
  "If False (default), mwm includes resize controls in the window manager \
frame of the bulletinboards parent.",
  "resizePolicy","UnsignedChar","XmRESIZE_ANY","XmRESIZE_ANY","XmRESIZE_NONE,XmRESIZE_GROW,XmRESIZE_ANY",
  True,True,True,False,
  "How bulletinboard widgets are resized.",
  "shadowType","UnsignedChar","XmSHADOW_OUT","XmSHADOW_OUT","XmSHADOW_IN,XmSHADOW_OUT,XmSHADOW_ETCHED_IN,XmSHADOW_ETCHED_OUT",
  True,True,True,False,
  "The style in which shadows are drawn.",
  "textFontList","XmFontList","dynamic","dynamic","NONE",
  True,False,False,False,
  "The font list used for text children.",
  "textTranslations","XtTranslations","NULL","NULL","NONE",
  True,False,False,False,
  "For any text widget or its subclass that is a child of the \
bulletinboard, this resource adds translations."
};
/*oodE*******************************************************/

XMBulletinBoard::XMBulletinBoard()
{
  _numResources = 16;
}

XMBulletinBoard::~XMBulletinBoard()
{
	// Empty
}

XMBulletinBoard::XMBulletinBoard(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);  
  setParent(parent);
  createWidget(bulletinboard_v);

  _numResources = 16;

  /* IF no pixmaps has been created */
  if(XMBulletinBoard_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMBulletinBoard_xpm, 
                                 &XMBulletinBoard_pixmap, NULL, NULL ) != 0 )
       XMBulletinBoard_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMBulletinBoard::getPixmap(void)
{
	return XMBulletinBoard_pixmap;
}

res_rec * XMBulletinBoard::getResources(void)
{
  return _resources;
}

res_rec * XMBulletinBoard::getStaticResources(void)
{
  return _bulletinBoardResources;
}

int XMBulletinBoard::getStaticNumResources(void)
{
  return 14;
}

int XMBulletinBoard::getNumResources(void)
{
  return _numResources;
}

void XMBulletinBoard::storeResources(void)
{
  res_rec * compositeResources = XtComposite::getResources();
  int compositeNumResources = XtComposite::getNumResources();
  res_rec * managerResources = XtManager::getResources();
  int managerNumResources = XtManager::getNumResources();
  _resources = (res_rec *)malloc(_numResources*sizeof(res_rec));
  int totalNumResources;

  totalNumResources = _numResources + 
                      compositeNumResources + 
                      managerNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  if(_resources == NULL)
    cout<< "malloc failed" << endl;

  memmove(_resources,_bulletinBoardResources,_numResources*sizeof(res_rec));

  memmove(&_resources[_numResources],
          compositeResources,compositeNumResources*sizeof(res_rec));

  _numResources = _numResources + compositeNumResources;
  memmove(&_resources[_numResources],
          managerResources,managerNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
}
