/* XMPopupMenu.C */

#include "XMPopupMenu.h"
// Super Class : XMRowColumn

/*oodB%XMPopupMenu*** Global Declarations and Stuffs ****/
Pixmap XMPopupMenu::XMPopupMenu_pixmap = XmUNSPECIFIED_PIXMAP; 
/*oodE****************************************************/

XMPopupMenu::~XMPopupMenu()
{
	// Empty
}

XMPopupMenu::XMPopupMenu(Widget parent,Arg* al,int ac)
{

  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(popupmenu_v);

  /* IF no pixmaps has been created */
  if(XMPopupMenu_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMPopupMenu_xpm, 
                                 &XMPopupMenu_pixmap, NULL, NULL ) != 0 )
       XMPopupMenu_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
  
  XtAddEventHandler(parent,                /* register event with widget */
       (EventMask) (ButtonPressMask),      /* events desired */
                    0,                     /* non_maskable events */ 
                    XMPopupMenu::popupEV,  /* function */
                    (XtPointer) this       /* clientdata */);
}

Pixmap XMPopupMenu::getPixmap(void)
{
	return XMPopupMenu_pixmap;
}

void XMPopupMenu::popupCB(Widget w, XtPointer client, XtPointer call)
{
  XMPopupMenu * pop = (XMPopupMenu *) client;
  Widget popupMenu = pop->getWidget();
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) call;

  /* check which button has been pressed */
  if(cbs->event->xany.type != ButtonPress)
    return;

  switch(cbs->event->xbutton.button)
  {
    case 1:
    break;
    case 2:
    break;
    case 3:
      XmMenuPosition(popupMenu, (XButtonPressedEvent *) (cbs->event));
      XtManageChild(popupMenu);
    break;
  }
}

void  XMPopupMenu::popupEV(Widget w, 
                           XtPointer client_data, 
                           XEvent * event, 
                           char * dummy)
{
  XMPopupMenu * pop = (XMPopupMenu *) client_data;
  Widget popupMenu = pop->getWidget();
  XEvent new_event;
  memmove(&new_event,event,sizeof(XEvent));

  /* check which button has been pressed */
  if(new_event.xany.type != ButtonPress)
    return;

  switch(new_event.xbutton.button)
  {
    case 1:
    break;
    case 2:
    break;
    case 3:
      XmMenuPosition(popupMenu, (XButtonPressedEvent *) &new_event);
      XtManageChild(popupMenu);
    break;
  }
}
