# Biff (mail-checking, mailer-launching) Client Tcl code for tkgoodstuff
# Mark Crimmins (markcrim@umich.edu)

setifunset Biff_user $env(USER)
setifunset Biff_file {/usr/spool/mail/$Biff_user}
setifunset Biff_mailer {xmh}
setifunset Biff_update_interval 60
setifunset Biff_update_offset 1
setifunset Biff_vigilance_interval 5
setifunset Biff_vigilance_offset 5
setifunset Biff_vigilance_duration 30

setifunset Biff_method atime

setifunset Biff_frm 0
setifunset Biff_frm_command {frm -s new $Biff_user}
setifunset Biff_frm_image $images/letters
setifunset Biff_nolabel 0
setifunset Biff_nobeep 0

setifunset Biff_newmail_image $images/biffnew.$TKG_defformat
setifunset Biff_nomail_image $images/biffno.$TKG_defformat

# Code to set up periodic processing
set TKG_async_map(Biff_update) [list $Biff_update_interval $Biff_update_offset Biff_update]

proc Biff_update {} {
    global Biff-params Biff_nobeep TKG_nobeep TKG_nonotices
    global Biff_method Biff_nolabel
    global Biff_frm Biff_frm_command
    global labelsonly

    if [Biff-test-$Biff_method] {
	if {[set Biff-params(mode)] != "newmail" } {
	    TKGButton Biff -mode newmail -image Biff_newmail_image
	    if !$Biff_nolabel { TKGButton Biff -text "New Mail"}
	    if { ! ( $Biff_nobeep || $TKG_nobeep ) } {
		catch { bell; bell }
	    }
	    if { ($Biff_frm && ! $TKG_nonotices) } {Biff_do_frm}
	    Biff_novigilance
	    update
	}
    } elseif { [set Biff-params(mode)] != "nomail" } {
	TKGButton Biff -mode nomail -image Biff_nomail_image
	if !$Biff_nolabel {TKGButton Biff -text "No Mail"}
	Biff_novigilance
	update
    }
}

proc Biff-test-filesize {} {
    global Biff_file Biff_filesize
    if [catch "set filesize [file size $Biff_file]"] {
	set filesize 0
    }
    if { $filesize > $Biff_filesize } {
	return 1
    } elseif { ($filesize <  $Biff_filesize) \
	       || ( $filesize == 0 ) } {
	set Biff_filesize $filesize
	return 0
    } else {
	return 0
    }
}

proc Biff-ignore-filesize {} {
    global Biff_file Biff_filesize
    if [catch "set Biff_filesize [file size $Biff_file]"] {
	set Biff_filesize 0
    }
    Biff_update
}

proc Biff-test-atime {} {
    global Biff_file
    if {  [file exists $Biff_file] \
	      && ([file stat $Biff_file a] == "") \
	      && ( $a(size) > 0) \
	      && ($a(mtime) >= $a(atime)) } {
	return 1
    } else { return 0 }
}

proc Biff-ignore-atime {} {
    global Biff_file
    exec touch -a $Biff_file
    Biff_update
}

proc Biff_vigilance {} {
    global TKG_async_map TKGcounter
    global Biff_vigilance_interval Biff_vigilance_offset Biff_vigilance_duration
    DEBUG "Starting Biff vigilance"
    if { [array names TKG_async_map Biff_update] == "Biff_update" } {
	set TKG_async_map(Biff_update) \
	    [list $Biff_vigilance_interval [expr $Biff_vigilance_offset + $TKGcounter] Biff_update]
	set TKG_async_map(Biff_novigilance) \
    [list $Biff_vigilance_duration [ expr $TKGcounter - 1] Biff_novigilance]
    }
}

proc Biff_novigilance {} {
    global TKG_async_map TKGcounter
    global Biff_update_interval
    DEBUG "Ending Biff vigilance"
    catch {unset TKG_async_map(Biff_novigilance) }
    set TKG_async_map(Biff_update) \
	[list $Biff_update_interval [expr $Biff_update_interval + $TKGcounter] Biff_update]
}


proc Biff_do_frm {} {
    global Biff_frm_command images Biff_user Biff_frm_image
    catch { eval exec $Biff_frm_command | cut -c 1-80 } Biff_frm_text
    set showtype message
    message .dummy -text $Biff_frm_text
    if { ( [winfo reqheight .dummy] > 550 ) } {
	set showtype text
    }
    destroy .dummy
    if {( [lsearch [image names] Biff_frm_image] == -1 )} {
	SetImage Biff_frm_image $Biff_frm_image
    }
    TKGDialog biff_frm \
	-wmtitle "tkgoodstuff: Mail"\
	-image $Biff_frm_image \
	-title "Mail" \
	-$showtype $Biff_frm_text\
	-nodismiss \
	-buttons { 
	    {launch "Read Mail" \
		 { Biff_launch_mailer; destroy .biff_frm }
	    }
	    {dismiss "Dismiss" {Biff_update;destroy .biff_frm}}
	}
}

proc Biff_ignore {} {
    global Biff_file
    exec touch -a $Biff_file
    Biff_update
}

proc Biff_launch_mailer {} {
    global Biff_mailer Biff-params TKG_async_map TKGcounter
    DEBUG "Biff: launching mailer: $Biff_mailer"
    if ![info exists Biff-params(pid)] {
	[set Biff-params(window)] config -relief sunken
	set Biff-params(pid) [eval exec $Biff_mailer &]
	set TKG_async_map(Biff-waitpid) [list 3 $TKGcounter "TKG_pidgone Biff"]
	if {[set Biff-params(mode)] == "newmail"} Biff_vigilance
    }
}

proc create-Biff-window {} {
    global Biff_nomail_image  Biff_newmail_image Biff-params
    global Biff_pop Biff_pop_interval Biff_do_pop TKG_async_map
    global Biff_nolabel Biff_mailer Biff_file Biff_user
    global Biff_newmailforeground Biff_newmailbackground
    global Biff_nomailforeground Biff_nomailbackground 
    global Biff_method Biff_filesize

    uplevel {
	setifunset Biff_newmailforeground #7fff00
	setifunset Biff_newmailbackground $TKGbuttonbackground
	setifunset Biff_nomailforeground $TKGbuttonforeground
	setifunset Biff_nomailbackground $TKGbuttonbackground
    }

    SetImage Biff_nomail_image $Biff_nomail_image
    SetImage Biff_newmail_image $Biff_newmail_image
    set Biff_file [subst $Biff_file]
    set Biff_filesize 0
    
    if { $Biff_nolabel } {
 	set t ""
    } else {
	set t "No Mail"
    }
    TKGButton Biff \
	-image Biff_nomail_image \
        -text $t \
        -unixcmd $Biff_mailer \
	-foreground(nomail) $Biff_nomailforeground \
	-activeforeground(nomail) $Biff_nomailforeground \
	-background(nomail) $Biff_nomailbackground \
	-foreground(newmail) $Biff_newmailforeground \
	-activeforeground(newmail) $Biff_newmailforeground \
	-background(newmail) $Biff_newmailbackground \
	-mode nomail
    # This is how we add a tcl script to the button's unix command
    RecursiveBind [set Biff-params(window)] <1> "+
   	  if \{ \[info exists Biff-params(pid)\]  && \
		   (\[set Biff-params(mode)\] == \"newmail\")\} \{
	      Biff_vigilance
	  \}
    "
    RecursiveBind [set Biff-params(window)] <2> Biff-ignore-$Biff_method
    RecursiveBind [set Biff-params(window)] <3> Biff_do_frm
    TKGPopupAddClient Biff
    .tkgpopup.biff add command\
	-label "Run Mail Program" -command {Biff_launch_mailer}
    .tkgpopup.biff add command\
	-label "List New Mail" -command {Biff_do_frm}
    .tkgpopup.biff add command\
	-label "Treat Current New Mail As Old " -command {Biff_ignore}
    .tkgpopup.biff add command\
	-label "Remove Mail Button " -command {
	    catch {unset TKG_async_map(Biff_update)}
	    destroy [set Biff-params(window)]
	    set index [.tkgpopup index "BIFF:"]
	    .tkgpopup delete $index [expr $index +1]
	    set index [lsearch $Clients Biff]
	    set Clients [ lreplace $Clients $index $index ]
	}
}

DEBUG "Loaded Biff.tcl"
