/* --------------------------------- command.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* process user commands.
*/

#include "fly.h"
#include "plane.h"


static void NEAR
swap_view (short old, short new)
{
	int	i;

	for (i = 0; i < NHDD; ++i) {
		if ((st.hdd[i].flags & HDF_ON) && st.hdd[i].type == old) {
			st.hdd[i].type = new;
			break;
		}
	}
}

static void NEAR
update_viewer (void)
{
	OBJECT *p;

	if (T(p = get_viewer ((st.flags1 & SF_EXTVIEW) ? st.extview : 0)))
		save_viewport (p);
	if (!(st.flags1 & SF_EXTVIEW))
		save_viewport (CV);
}

static int NEAR
one_command (int ch)
{
	int	i, j;
	char	msg[80];
	OBJECT	*p;
	E_PLANE	*ecv;

	ecv = IS_PLANE(CV) ? EE(CV) : 0;

	switch (ch) {

#define WSTEP	FONE/64		/* ++++++++++++ start debug keys ++++++++++ */

/* arrows */	case KF_XRIGHT:					/* move */
		case KF_XLEFT:
		case KF_XUP:
		case KF_XDOWN:
			if (CP->zoom > 0) {
				i = 1 << (CP->zoom / 3);
				j = CP->zoom % 3;
				if (1 == j)
					i += fmul (i, FCON(0.26));
				else if (2 == j)
					i += fmul (i, FCON(0.59));
			} else
				i = 1;
			i = D90/(18*i);
			if (KF_XRIGHT == ch)
				CP->rotz += i;
			else if (KF_XLEFT == ch)
				CP->rotz -= i;
			else if (KF_XUP == ch)
				CP->rotx += i;
			else
				CP->rotx -= i;
			if (iabs (CP->rotz) < (Uint)i/2)
				CP->rotz = 0;
			if (iabs (CP->rotx) < (Uint)i/2)
				CP->rotx = 0;
			break;
#if 0
		case KF_RIGHT:
			if (CW->orgx + CW->maxx < FONE-WSTEP) {
				show_fixed (1);
				CW->orgx += WSTEP;
				show_fixed (0);
			}
			break;
		case KF_XLEFT:
			if (CW->orgx - CW->maxx > WSTEP) {
				show_fixed (1);
				CW->orgx -= WSTEP;
				show_fixed (0);
			}
			break;
		case KF_XUP:
			if (CW->orgy - CW->maxy > WSTEP) {
				show_fixed (1);
				CW->orgy -= WSTEP;
				show_fixed (0);
			}
			break;
		case KF_XDOWN:
			if (CW->orgy + CW->maxy < FONE-WSTEP) {
				show_fixed (1);
				CW->orgy += WSTEP;
				show_fixed (0);
			}
			break;
#endif

/* AltArrows */	case KF_YRIGHT:					/* resize x */
			show_fixed (1);
			CW->maxx += WSTEP;
			if (CW->orgx + CW->maxx > FONE)
				CW->maxx = FONE - CW->orgx;
			if (CW->orgx - CW->maxx < 0)
				CW->maxx = CW->orgx;
			show_fixed (0);
			break;
		case KF_YLEFT:
			show_fixed (1);
			CW->maxx -= WSTEP;
			if (CW->maxx < FONE/128)
				CW->maxx = FONE/128;
			show_fixed (0);
			break;

		case KF_YUP:					/* resize y */
			show_fixed (1);
			CW->maxy += WSTEP;
			if (CW->orgy + CW->maxy > FONE)
				CW->maxy = FONE - CW->orgy;
			if (CW->orgy - CW->maxy < 0)
				CW->maxy = CW->orgy;
			show_fixed (0);
			break;
		case KF_YDOWN:
			show_fixed (1);
			CW->maxy -= WSTEP;
			if (CW->maxy < FONE/128)
				CW->maxy = FONE/128;
			show_fixed (0);
			break;

#undef WSTEP		/* ++++++++++++++ end   debug keys ++++++++++++++ */

		case KF_ZOOMIN:
			if (!(st.flags1 & SF_EXTVIEW) || scenery (st.extview)) {
				zoom (CP, 1);
				update_viewer ();
			}
			break;
		case KF_ZOOMOUT:
			if (!(st.flags1 & SF_EXTVIEW) || scenery (st.extview)) {
				zoom (CP, -1);
				update_viewer ();
			}
			break;

		case KF_ESC:
			st.flags &= ~SF_LISTS;
			if (menu_top ())
				return (1);
			break;

		case 'A':
			if (ecv) {
				i = (ecv->radar&R_MODES)/R_MODE;
				i = (i+1)%5;
				ecv->radar &= ~R_MODES;
				ecv->radar |= i*R_MODE;
			}
			break;
		case 'B':
			menu_btn ();
			break;
		case 'c':
			clear_text ();
			Gr->SetTextPos (2, 1);
			msg_clear ();
			break;
		case 'C':
			if (ecv)
				ecv->flags ^= PF_CHASE;
			break;
		case 'd':
			if (ecv)
				ecv->hudmode ^= HM_DECLUTTER;
			break;
		case 'D':
			if (O_CHUTE == CV->name) {
				i = 5*2*VONE;		/* 2 seconds worth */
				if (CV->R[Z] > i)
					CV->R[Z] = i;
				if (CV->V[Z] > 0)
					CV->V[Z] = 0;
			}
			break;
		case 'E':
			if (CC->gpflags & GPF_PILOT)
				eject (CC);
			break;
		case 'f':
			if (ecv) {
				if (ecv->radar & R_SELECT3)
					ecv->radar ^= R_SELECT3|R_SELECT20;
				else if (ecv->radar & R_SELECT20)
					ecv->radar ^= R_SELECT20|R_SELECT5;
				else if (ecv->radar & R_SELECT5)
					ecv->radar ^= R_SELECT5;
				else
					ecv->radar ^= R_SELECT3;
				ecv->target = 0;	/* re-select target */
			}
			break;
		case 'h':
		case '?':
			if (!(st.flags & SF_HELP))
				st.flags &= ~SF_LISTS;
			st.flags ^= SF_HELP;
			break;
		case 'i':
			if (ecv)
				ecv->radar ^= R_INTEL;
			break;
		case 'j':
			if (ecv)
				ecv->radar ^= R_INTELCC;
			break;
		case 'k':
			if (ecv)
				ecv->flags ^= PF_KILL;
			break;
		case 'l':
			if (ecv)
				ecv->radar ^= R_LOCK;
			break;
		case 'm':
			if (!(st.flags & SF_MODES))
				st.flags &= ~SF_LISTS;
			st.flags ^= SF_MODES;
			break;
		case 'n':
			if (!(st.flags & SF_NET))
				st.flags &= ~SF_LISTS;
			st.flags ^= SF_NET;
			break;
		case 'O':
		case 'o':
			if (st.network & NET_ON) {
				MsgWPrintf (50, "Net active!");
				break;
			}
#if 0
			flags = st.flags;
			st.flags |= SF_PAUSED;
#endif
			for (i = 1, p = CO; p; p = p->next, ++i) {
				char	msg[80], m[80];
				if (ch == 'o' && (p->name == O_M61 ||
						  p->name == O_MK82 ||
						  p->name == O_BROKEN))
					continue;
				if (p == CV)
					j = 'V';
				else if (p->flags & F_CC)
					j = 'C';
				else if (IS_PLANE(CC) && p == EE(CC)->target)
					j = 'L';
				else
					j = ' ';
				sprintf (msg, "%c%3u ", j, i);
/*Gr->TextColor (p->color, st.tbg);*/
				sprintf (m, "%-6s", TITLE(p));
				strcat (msg, m);
				if (p->flags & F_IMPORTED) {
					if (p->rplayer)
						sprintf (m, " %s",
							p->rplayer->name);
					else
						sprintf (m, " I");
				} else if (p->flags & F_EXPORTED)
					sprintf (m, " ***");
				else
					m[0] = '\0';
				strcat (msg, m);
/*Gr->TextColor (st.tfg, st.tbg);*/
				sprintf (m, " (%ld,%ld,%ld)",
					vuscale (p->R[X]),
					vuscale (p->R[Y]),
					vuscale (p->R[Z]));
				strcat (msg, m);
				MsgPrintf (200, msg);
			}
			do {
				getstr ("choose viewer", msg, sizeof (msg) - 1);
				if ('\0' == msg[0]) {
					j = 0;
					break;
				}
				if ('c' == msg[0]) {
					j = -1;
					break;
				} else if ('l' == msg[0]) {
					j = -2;
					break;
				}
			} while (1 != sscanf (msg, "%u", &j) ||
					j < 0 || j >= i);
			if (0 == j)
				p = 0;
			else if (-1 == j)
				p = CC;
			else if (-2 == j) {
				if (IS_PLANE(CC))
					p = EE(CC)->target;
			} else {
				for (i = 1, p = CO; p && i != j;)
					p = p->next;
			}
			if (p) {
#if 0
				if (!IS_PLANE(p))
					goto again;
#endif
				save_viewport (CV);
				get_viewport (p);
				CV = p;
			}
#if 0
			st.flags = flags;
#endif
			break;
		case 'p':
			if (st.flags & SF_PAUSED) {
				st.flags &= ~SF_PAUSED;
				GrPrintf ("Resumed \n");
				break;
			}
			if (st.network & NET_ON)
				MsgWPrintf (50, "Net active!");
			else {
				GrPrintf ("Paused \n");
				st.flags |= SF_PAUSED;
			}
			break;
#if 0
		case 'P':		/* show pallete */
			for (i = 0; i < 256; ++i) {
				Gr->TextColor (i, st.black);
				GrPrintf ("%02x%s", i, (i%8==7 ? "\n" : ""));
			}
			Gr->TextColor (st.tfg, st.tbg);
			break;
#endif
		case 'q':
			st.quiet = (st.quiet+1)%3;
			break;
		case 'r':
			if (ecv)
				ecv->radar ^= R_ON;
			break;
		case 's':
			for (i = 0; i < O_INT; ++i) {
				j = 0;
				for (p = CO; p; p = p->next) {
					if (p->name == i)
						++j;
				}
				if (j)
					MsgPrintf (100, "%4u %s",
						j, st.bodies[i]->title);
			}
			break;
		case 'S':
			if (ecv)
				supply (CV, 1);
			break;
		case 'u':
			if (ecv)
				menu_hud ();
			break;
		case 'v':
			if (scenery (st.extview)) {
				if (!(p = get_viewer (st.extview))) {
					MsgWPrintf (50, "No viewer");
					break;
				}
			} else
				p = 0;
			if (st.flags1 & SF_EXTVIEW) {
				if (p) {
					save_viewport (p);
					get_viewport (CV);
				}
				swap_view (HDT_FRONT, st.extview);
			} else {
				if (p) {
					save_viewport (CV);
					get_viewport (p);
				}
				swap_view (st.extview, HDT_FRONT);
			}
			st.flags1 ^= SF_EXTVIEW;
			break;
		case 'w':
			if (ecv)
				ecv->weapon = (ecv->weapon+1)%3;
			break;
		case 'W':
			if (ecv)
				memset (ecv->stores, 0, sizeof (ecv->stores));
			break;
		case 'x':
			(*CC->pointer->control->Cal)(CC->pointer);
			break;
		case '-':
			CP->rotz += D90/2;
			break;
		case '*':
			CP->rotx = 0;
			CP->rotz = 0;
			CP->rotz = 0;
			break;
		case '/':
			CP->rotz -= D90/2;
			break;
		case '!':
			Gr->Term (CS->device);
			Sys->Shell ();
			if (Gr->Init (CS->device, st.grname)) {
				LogPrintf ("device init failed after shell\n");
				die ();
			}
			set_palette ();
			show_fixed (0);
			break;
		default:
			(*CC->pointer->control->Key)(CC->pointer, ch);
			break;
	}
	return (0);
}

static void NEAR
misc_actions (void)
{
	int	n, r;
	OBJECT	*p;
	HMSG	*m;

	if (st.drones) {			/* top up planes */
		for (n = r = 0, p = CO; p; p = p->next) {
			if (p->name == O_PLANE && !(p->flags & F_CC) &&
			    !(p->flags & F_IMPORTED)) {
				++n;
				if (EX->radar & R_ON)
					++r;
			}
		}
		if (n < st.drones && st.DroneTime <= st.present) {
			emit_drone ();
			st.DroneTime = st.present + TO_DRONE;
		}
		if (r < st.killers) {
			for (p = CO; p; p = p->next) {
				if (p->name == O_PLANE &&
				    !(p->flags & F_CC) &&
				    !(p->flags & F_IMPORTED) &&
				    !(EX->radar & R_ON)) {
					EX->radar |= R_ON|R_LOCK|R_INTELCC;
					EX->flags |= PF_CHASE | PF_KILL;
					EX->weapon = WE_M61;  /*fix 1*/
					if (++r >= st.killers)
						break;
				}
			}
		}
	}

	if (st.ShutdownTime && st.present > st.ShutdownTime) {
		static Ushort	keys[] = {KF_ESC, 'x', 'y'};

		mac_interpret (keys, rangeof (keys));
	}

	if ((st.flags1 & SF_TESTING) && !st.ntargets) {	/* score result */
		if (st.quiet) {
			TnGone[0] = 0;
			Snd->List (TnGone, 0);
		}

		MsgPrintf (100, "All gone");
		m = MsgWPrintf (0, "Hit Any key");

		st.flags |= SF_INTERACTIVE;
		Kbd->Wait ();
		st.flags &= ~SF_INTERACTIVE;

		msg_del (m);

		if (st.quiet)
			TnGone[0] = -1;
		st.flags1 &= ~(SF_TESTING|SF_INFO);
	}

	memory_check ();			/* top up memory */
}

extern int FAR
user_command (void)
{
	int	i, ch;

	do {
		sys_poll ();
		misc_actions ();
		for (i = 0; -1 != (ch = mread ());) {
			st.flags |= SF_INTERACTIVE;
			if (T(i = one_command (ch)))
				break;
			st.flags &= ~SF_INTERACTIVE;
			if (T(i = st.flags1 & SF_TERM))
				break;
		}
	} while (!i);
	return (i);
}
