/* --------------------------------- hudmenu.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* HUD Menus.
*/

#include "fly.h"
#include "hud.h"


/* Select HUD type
*/

static MENU FAR	MenuHudType[] = {
	{'0', "Classic"},	/*  0 */
	{'1', "FA18"},		/*  1 */
	{'2', "F16"},		/*  2 */
	{'3', "F15"},		/*  3 */
	{'4', "Ether"},		/*  4 */
{'\0', 0}};

extern int FAR
menu_hudtype (void)
{
	int	sel;

	sel = (EE(CV)->hud1&HUD_TYPES)/HUD_TYPE;
	sel = menu_open (MenuHudType, sel);

	switch (sel) {
	case MENU_ABORTED:
	case MENU_FAILED:
		break;
	default:
		EE(CV)->hud1 = (EE(CV)->hud1 & ~HUD_TYPES) | (sel*HUD_TYPE);
		hud_setup (CV);
		break;
	}
	if (MENU_FAILED != sel)
		menu_close ();

	return (0);
}

/* Select ladder sizes;
*/

static MENU FAR	MenuLdSize[] = {
	{'g', "gap"},		/*  0 */
	{'s', "step"},		/*  1 */
	{'h', "horizon"},	/*  2 */
	{'l', "land"},		/*  3 */
	{'t', "tip"},		/*  4 */
	{'n', "ndash"},		/*  5 */
{'\0', 0}};

static int NEAR
menu_ldsize (void)
{
	int	sel, quit;

	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuLdSize, 0);
		switch (sel) {
		case MENU_ABORTED:
		default:
			quit = 1;
			break;
		case 0:
			get_num ("gap size", &EE(CV)->ldgap, MT_SHORT,
					0, FONE, FONE/128);
			break;
		case 1:
			get_num ("step size", &EE(CV)->ldstep, MT_SHORT,
					0, FONE, FONE/128);
			break;
		case 2:
			get_num ("horizon size", &EE(CV)->ldstep0, MT_SHORT,
					0, FONE, FONE/128);
			break;
		case 3:
			get_num ("land size", &EE(CV)->ldstepg, MT_SHORT,
					0, FONE, FONE/128);
			break;
		case 4:
			get_num ("tip size", &EE(CV)->ldtip, MT_SHORT,
					0, FONE, FONE/128);
			break;
		case 5:
			get_num ("ndash", &EE(CV)->ldndash, MT_SHORT,
					0, 8, 1);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}
	return (0);
}

/* Select ladder style
*/

static MENU FAR	MenuLadder[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'l', "ladder"},	/*  3 */
	{'p', "pinned"},	/*  4 */
	{'r', "right"},		/*  5 */
	{'e', "erect"},		/*  6 */
	{'c', "color"},		/*  7 */
	{'f', "funnel"},	/*  8 */
	{'s', "slant"},		/*  9 */
	{'z', "zenith"},	/* 10 */
	{'u', "under"},		/* 11 */
	{'t', "tip0"},		/* 12 */
	{'h', "hold"},		/* 13 */
	{'R', "h roll"},	/* 14 */
	{'S', "sun"},		/* 15 */
	{'i', "negtip"},	/* 16 */
	{'x', "sizes"},		/* 17 */
{'\0', 0}};

static int NEAR
menu_ladder (void)
{
	int	sel, quit;

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuLadder, 0);
		switch (sel) {
		case MENU_ABORTED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			SetOption (&EE(CV)->hud, HUD_LADDER);
			break;
		case 4:
			SetOption (&EE(CV)->ladder, LD_FIXED);
			break;
		case 5:
			SetOption (&EE(CV)->ladder, LD_RIGHT);
			break;
		case 6:
			SetOption (&EE(CV)->ladder, LD_ERECT);
			break;
		case 7:
			SetOption (&EE(CV)->ladder, LD_COLOR);
			break;
		case 8:
			SetOption (&EE(CV)->ladder, LD_FUNNEL);
			break;
		case 9:
			SetOption (&EE(CV)->ladder, LD_SLANT);
			break;
		case 10:
			SetOption (&EE(CV)->ladder, LD_ZENITH);
			break;
		case 11:
			SetOption (&EE(CV)->ladder, LD_UNDER);
			break;
		case 12:
			SetOption (&EE(CV)->ladder, LD_TIP0);
			break;
		case 13:
			SetOption (&EE(CV)->ladder, LD_HOLD);
			break;
		case 14:
			SetOption (&EE(CV)->ladder, LD_HOLDROLL);
			break;
		case 15:
			SetOption (&EE(CV)->ladder, LD_SUN);
			break;
		case 16:
			SetOption (&EE(CV)->ladder, LD_NEGTIP);
			break;
		case 17:
			menu_ldsize ();
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}
	return (0);
}

/* Select HUD parts
*/

static MENU FAR	MenuHudParts[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'l', "ladder"},	/*  3 */
	{'a', "altitude"},	/*  4 */
	{'s', "speed"},		/*  5 */
	{'h', "heading"},	/*  6 */
	{'g', "gnd ptr"},	/*  7 */
	{'b', "border"},	/*  8 */
	{'v', "vv"},		/*  9 */
	{'w', "vw"},		/* 10 */
	{'+', "plus"},		/* 11 */
	{'P', "pointer"},	/* 12 */
	{'B', "beta"},		/* 13 */
	{'x', "xbreak"},	/* 14 */
	{'i', "xgrid"},		/* 15 */
	{'d', "director"},	/* 16 */
	{'y', "waypoint"},	/* 17 */
	{'t', "tracers"},	/* 18 */
{'\0', 0}};

static int NEAR
menu_hudparts (void)
{
	int	sel, quit;

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudParts, 0);
		switch (sel) {
		case MENU_ABORTED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			menu_ladder ();
			quit = 1;
			break;
		case 4:
			SetOption (&EE(CV)->hud2, HUD_ALTITUDE);
			break;
		case 5:
			SetOption (&EE(CV)->hud2, HUD_SPEED);
			break;
		case 6:
			SetOption (&EE(CV)->hud2, HUD_HEADING);
			break;
		case 7:
			SetOption (&EE(CV)->hud1, HUD_PENDULUM);
			break;
		case 8:
			SetOption (&EE(CV)->hud1, HUD_BORDER);
			break;
		case 9:
			SetOption (&EE(CV)->hud, HUD_VV);
			break;
		case 10:
			SetOption (&EE(CV)->hud2, HUD_VW);
			break;
		case 11:
			SetOption (&EE(CV)->hud, HUD_PLUS);
			break;
		case 12:
			SetOption (&EE(CV)->hud, HUD_CURSOR);
			break;
		case 13:
			SetOption (&EE(CV)->hud2, HUD_BETA);
			break;
		case 14:
			SetOption (&EE(CV)->hud2, HUD_XBREAK);
			break;
		case 15:
			SetOption (&EE(CV)->hud2, HUD_XGRID);
			break;
		case 16:
			SetOption (&EE(CV)->hud2, HUD_DIRECTOR);
			break;
		case 17:
			SetOption (&EE(CV)->hud2, HUD_WAYPOINT);
			break;
		case 18:
			SetOption (&EE(CV)->hud2, HUD_HISTORY);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD options.
*/

static MENU FAR	MenuHudOptions1[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'3', "heading"},	/*  3 */
	{'k', "knots"},		/*  4 */
	{'T', "top"},		/*  5 */
	{'f', "fine"},		/*  6 */
	{'x', "xfine"},		/*  7 */
	{'b', "big"},		/*  8 */
	{'l', "scale"},		/*  9 */
	{'a', "area"},		/* 10 */
	{'c', "cas"},		/* 11 */
{'\0', 0}};

static int NEAR
menu_hudoptions1 (void)
{
	int	sel, quit, ch;
	char	msg[80], prompt[80];

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudOptions1, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			SetOption (&EE(CV)->hud, HUD_FULLHEADING);
			break;
		case 4:
			SetOption (&EE(CV)->hud1, HUD_KNOTS);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_TOP);
			break;
		case 6:
			SetOption (&EE(CV)->hud, HUD_FINE);
			if (EE(CV)->hud & HUD_FINE)
				EE(CV)->hud &= ~HUD_XFINE;
			break;
		case 7:
			SetOption (&EE(CV)->hud, HUD_XFINE);
			if (EE(CV)->hud & HUD_XFINE)
				EE(CV)->hud &= ~HUD_FINE;
			break;
		case 8:
			SetOption (&EE(CV)->hud, HUD_BIG);
			break;
		case 9:
			for (;;) {
				sprintf (prompt, "scale len(%d)?[10-25]?",
					(int)EE(CV)->tapelen);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 10 && ch <= 25) {
					EE(CV)->tapelen = (short)ch;
					break;
				}
			}
			break;
		case 10:
			for (;;) {
				sprintf (prompt, "hud area(%dDeg)?[1-45]?",
					(int)EE(CV)->hudarea);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 1 && ch <= 45) {
					EE(CV)->hudarea = (short)ch;
					break;
				}
			}
			break;
		case 11:
			SetOption (&EE(CV)->hud2, HUD_CALIBRATED);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

static MENU FAR	MenuHudOptions2[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'A', "a alarm"},	/*  3 */
	{'V', "v alarm"},	/*  4 */
	{'p', "panel"},		/*  5 */
	{'F', "font"},		/*  6 */
	{'S', "fontsize"},	/*  7 */
{'\0', 0}};

static int NEAR
menu_hudoptions2 (void)
{
	int	sel, quit, ch;
	char	msg[80], prompt[80];
	HMSG	*m;

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudOptions2, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			SetOption (&EE(CV)->hud1, HUD_AALARM);
			break;
		case 4:
			SetOption (&EE(CV)->hud1, HUD_VALARM);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_PANEL);
			break;
		case 6:
			for (;;) {
				m = MsgPrintf (0, "StFont(%d)?[0-9]",
					(int)st.StFont);
				ch = mgetch ();
				msg_del (m);
				if (ch >= '0' && ch <= '9') {
					font_set (ch - '0');
					break;
				}
			}
			break;
		case 7:
			for (;;) {
				sprintf (prompt, "StFontSize(%d)?[4-64]?",
					(int)st.StFontSize);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 8/2 && ch <= 8*8) {
					st.StFontSize = ch;
					break;
				}
			}
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD radar options.
*/

static MENU FAR	MenuHudRadar[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'C', "corner"},	/*  3 */
	{'d', "data"},		/*  4 */
	{'D', "distance"},	/*  5 */
	{'n', "name"},		/*  6 */
	{'a', "accvect"},	/*  7 */
	{'r', "reticle"},	/*  8 */
	{'t', "target"},	/*  9 */
	{'z', "ross"},		/* 10 */
	{'L', "limit"},		/* 11 */
	{'H', "thick"},		/* 12 */
	{'h', "hidetgt"},	/* 13 */
	{'p', "tpointer"},	/* 14 */
	{'v', "vpointer"},	/* 15 */
{'\0', 0}};

static int NEAR
menu_hudradar (void)
{
	int	sel, quit;

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudRadar, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:

		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			SetOption (&EE(CV)->hud1, HUD_CORNER);
			break;
		case 4:
			SetOption (&EE(CV)->hud, HUD_DATA);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_IDIST);
			break;
		case 6:
			SetOption (&EE(CV)->hud1, HUD_INAME);
			break;
		case 7:
			SetOption (&EE(CV)->hud1, HUD_ACCVECT);
			break;
		case 8:
			SetOption (&EE(CV)->hud, HUD_RETICLE);
			break;
		case 9:
			SetOption (&EE(CV)->hud, HUD_TARGET);
			break;
		case 10:
			SetOption (&EE(CV)->hud, HUD_ROSS);
			break;
		case 11:
			SetOption (&EE(CV)->hud1, HUD_LIMIT);
			break;
		case 12:
			SetOption (&EE(CV)->hud1, HUD_THICK);
			break;
		case 13:
			SetOption (&EE(CV)->hud2, HUD_HIDETGT);
			break;
		case 14:
			SetOption (&EE(CV)->hud2, HUD_TPOINTER);
			break;
		case 15:
			SetOption (&EE(CV)->hud2, HUD_VPOINTER);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HDD options.
*/

static MENU FAR	MenuHdd[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'i', "instruments"},	/*  3 */
	{'n', "nav"},		/*  4 */
	{'c', "compass"},	/*  5 */
	{'q', " square"},	/*  6 */
	{'o', " ortho"},	/*  7 */
{'\0', 0}};

static int NEAR
menu_hdd (void)
{
	int	sel, quit;

	SetOption (0, 2);
	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHdd, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			SetOption (0, sel);
			break;
		case 3:
			SetOption (&EE(CV)->hdd, HDD_INSTRUMENTS);
			break;
		case 4:
			SetOption (&EE(CV)->hdd, HDD_NAV);
			break;
		case 5:
			SetOption (&EE(CV)->hdd, HDD_COMPASS);
			break;
		case 6:
			SetOption (&EE(CV)->hdd, HDD_SQRCOMPASS);
			break;
		case 7:
			SetOption (&EE(CV)->hdd, HDD_ORTCOMPASS);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD sub-menu
*/

static MENU FAR	MenuHud[] = {
	{'0', "HUD off"},	/*  0 */
	{'u', "HUD on"},	/*  1 */
	{'t', "type"},		/*  2 */
	{'p', "parts"},		/*  3 */
	{'1', "options 1"},	/*  4 */
	{'2', "options 2"},	/*  5 */
	{'r', "radar"},		/*  6 */
	{'i', "ils"},		/*  7 */
	{'d', "hdd"},		/*  8 */
{'\0', 0}};

extern int FAR
menu_hud (void)
{
	int	sel;

	if (!IS_PLANE(CV))
		return (0);

	st.flags &= ~SF_LISTS;
	st.flags |= SF_HUD;

	sel = menu_open (MenuHud, 0);

	switch (sel) {
	case MENU_ABORTED:
	case MENU_FAILED:
	default:
		break;
	case 0:
		EE(CV)->hud &= ~HUD_ON;
		break;
	case 1:
		EE(CV)->hud |= HUD_ON;
		break;
	case 2:
		menu_hudtype ();
		break;
	case 3:
		menu_hudparts ();
		break;
	case 4:
		menu_hudoptions1 ();
		break;
	case 5:
		menu_hudoptions2 ();
		break;
	case 6:
		menu_hudradar ();
		break;
	case 7:
		menu_ils ();
		break;
	case 8:
		menu_hdd ();
		break;
	}
	if (MENU_FAILED != sel)
		menu_close ();

	st.flags &= ~SF_HUD;
	return (0);
}
