/* --------------------------------- log.c ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* log file stuff.
*/

#include "fly.h"


#define LOGSCHEDULED	st.stats[43]
#define LOGDELAY	1000L

static FILE *flog = 0;

extern int FAR
log_init (void)
{
	if (!st.lname)
		st.lname = xstrdup (LOGFILE);

	if (!st.lname) {
#ifndef NOSTDERR
		fprintf (stderr, "missing log file name\n");
#endif
		return (1);
	}
	if (!(flog = fopen (st.lname, ATMODE))) {
#ifndef NOSTDERR
		fprintf (stderr, "open failed for log file '%s'\n", st.lname);
#endif
		return (1);
	}
	return (0);
}

extern void FAR
log_term (void)
{
	if (flog) {
		fclose (flog);
		flog = 0;
	}
}

extern int FAR
log_flush (int now)
{
	if (!LOGSCHEDULED)
		return (0);
	if (!now && st.present < (Ulong)LOGSCHEDULED)
		return (0);
	LOGSCHEDULED = 0;
	if (flog) {
		log_term ();
		if (log_init())
			return (-1);
	}
	return (0);
}

extern int FAR
LogPrintf (const char *fmt, ...)
{
	va_list		ap;
	int		i;

	if (!flog) {
#ifndef NOSTDERR
		va_start (ap, fmt);
		i = vfprintf (stderr, fmt, ap);
		fflush (stderr);
		va_end (ap);
		return (i);
#endif
		return (-1);
	}

	va_start (ap, fmt);
	i = vfprintf (flog, fmt, ap);
	va_end (ap);
	LOGSCHEDULED = st.present + LOGDELAY;

/* try and keep every last message in the log.
*/
	if ((st.flags1 & SF_FLUSHLOG) && log_flush (1))
		return (-1);

	return (i);
}
