/* --------------------------------- opaddoc.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: paddoc.
*/

#include "fly.h"


#define S	400

static void FAR
paddoc_term (BODY *b)
{
	if (!b->shape)
		return;
	b->shape->v = xfree (b->shape->v);
	DEL0 (b->shape);
	b->term = 0;
	b->create = 0;
	b->delete = 0;
	b->dynamics = 0;
}

static int FAR
paddoc_create (OBJECT *p)
{
	p->color = st.green;
	p->time = FOREVER;
	p->flags |= F_VISIBLE;
	Mident (p->T);
	return (0);
}

static void FAR
paddoc_dynamics (OBJECT *p, int interval)
{}

extern int FAR
paddoc_init (BODY *b)
{
	VERTEX	*v;

	b->title = "PADDOC";
	if (!NEW (b->shape))
		return (1);
	v = (VERTEX *) xcalloc (sizeof (VERTEX), 6);
	if (!v) {
		b->shape = xfree(b->shape);
		return (1);
	}
	b->shape->v = v;

	v->V[X] = -S;	v->V[Y] = -S;	v->flags = V_MOVE;	++v;
	v->V[X] = -S;	v->V[Y] =  S;	v->flags = V_DRAW;	++v;
	v->V[X] =  S;	v->V[Y] =  S;	v->flags = V_DRAW;	++v;
	v->V[X] =  S;	v->V[Y] = -S;	v->flags = V_DRAW;	++v;
	v->V[X] = -S;	v->V[Y] = -S;	v->flags = V_DRAW;
	b->shape->extent = S;
	b->shape->weight = 1L;
	b->shape->drag = 0;

	b->term = paddoc_term;
	b->create = paddoc_create;
	b->delete = body_delete;
	b->dynamics = paddoc_dynamics;
	b->hit = body_hit;

	return (0);
}

#undef S
