/* --------------------------------- util.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* General purpose utility functions.
*/

#include "fly.h"


extern int FAR
opt36 (int c)
{
	if (c >= '0' && c <= '9')
		return (c - '0');
	if (c >= 'a' && c <= 'z')	/* Warning: ASCII only !!! */
		return (c - 'a' + 10);
	if (c >= 'A' && c <= 'Z')
		return (c - 'A' + 10);
	return (-1);
}

extern int FAR
get_long (char *p, long *lp)
{
	long	l;

	if (p[0] == '0') {
		if (p[1] == 'x' || p[1] == 'X')
			if (1 != sscanf (p+2, "%lx", &l))
				return (1);
			else
				{}
		else if (1 != sscanf (p, "%lo", &l))
			return (1);
		else
			{}
	} else if (1 != sscanf (p, "%ld", &l))
		return (1);
	else
		{}
	*lp = l;
	return (0);
}

extern int FAR
get_int (char *p, int *li)
{
	long	l;

	if (get_long (p, &l) || l != (long)(int)l)
		return (1);
	*li = (int)l;
	return (0);
}

/* The following functions are used by the drivers to retrieve user options.
 *
 * The general format is ":[opt]:[opt]:[opt]..."
 *	un-specified options are left out. Trailing ':::' not needed.
 * an option is either "NameValue" or "Value". The first two functions
 * use the Name and return the Value (either a pointer[non-terminated] or
 * a long) while the last two (get_i*) return the Value for the i-th (first
 * is zero) option (no Name expected). NULL/-1L pointer means not present.
 *	get_arg() returns a pointer to the option Value
 *	get_narg() returns the Value as a long
 *	get_iarg() returns a pointer to the i-th option Value
 *	get_inarg() returnd the i-th option  Value as a long
*/

extern char * FAR
get_arg (char *options, char *argname)
{
	char	*p;
	int	len;

	len = strlen (argname);

	for (p = options;p ; p = strchr (p, ':')) {
		++p;
		if (!strnicmp (p, argname, len)) {
			p += len;
			break;
		}
	}
	return (p);
}

extern int FAR
get_narg (char *options, char *argname, long *lp)
{
	char	*p;
	long	l;

	if (F(p = get_arg (options, argname)) || get_long (p, &l))
		return (1);
	*lp = l;
	return (0);
}

extern char * FAR
get_iarg (char *options, int argno)
{
	char	*p;
	int	i;

	for (i = 0, p = options; p ; p = strchr (p, ':'), ++i) {
		++p;
		if (i == argno)
			break;
	}
	return (p);
}

extern char * FAR
get_parg (char *options, int argno)
{
	char	*p, *q;
	int	t;

	if (!(p = get_iarg (options, argno)))
		return (0);
	q = strchr (p, ':');
	if (!q)
		p = xstrdup (p);
	else {
		t = *q;
		*q = '\0';
		p = xstrdup (p);
		*q = (char)t;
	}
	return (p);
}

extern int FAR
get_inarg (char *options, int argno, long *lp)
{
	char	*p;
	long	l;

	if (F(p = get_iarg (options, argno)) || get_long (p, &l))
		return (1);
	*lp = l;
	return (0);
}

extern int FAR			/* debug utility */
looping (int i)
{
	static int	n;

	if (!i)
		n = 0;
	else if (++n > i)
		return (1);

	return (0);
}

static Ulong	rand_seed = 1;

extern int FAR
Frand (void)
{
	rand_seed = rand_seed * 1103515245UL + 12345;
	return ((int)(rand_seed >> 16) & 0x7fff);
}

extern void FAR
Fsrand (Uint seed)
{
	rand_seed = (Ulong) seed;
}

extern void FAR
Frandomize (void)
{
	Fsrand (Tm->Hires ());
}
