.\" $Xorg: xconsole.man,v 1.4 2001/02/09 02:05:40 xorgcvs Exp $
.\" Copyright 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" The Open Group.
.\"
.\" $XFree86: xc/programs/xconsole/xconsole.man,v 1.11 2005/02/11 03:03:17 dawes Exp $
.\"
.TH XCONSOLE 1 __vendorversion__
.SH NAME
xconsole \- monitor system console messages with X
.SH SYNOPSIS
.ta 8n
\fBxconsole\fP [-\fItoolkitoption\fP ...] [-file \fIfile-name\fP]
[-notify] [-stripNonprint] [-daemon] [-verbose] [-exitOnFail]
.SH DESCRIPTION
The
.I xconsole
program displays messages which are usually sent to /dev/console.
.SH OPTIONS
.I Xconsole
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-file \fIfile-name\fP
To monitor some other device, use this option to specify the device name.
This does not work on regular files as they are always ready to be read from.
.TP 8
.B \-notify \-nonotify
When new data are received from the console and the notify option is set,
the icon name of the application has " *" appended, so that it is evident
even when the application is iconified.  \-notify is the default.
.TP 8
.B \-daemon
This option causes
.I xconsole
to place itself in the background, using fork/exit.
.TP 8
.B \-verbose
When set, this option directs
.I xconsole
to display an informative message in the first line of the text buffer.
.TP 8
.B \-exitOnFail
When set, this option directs
.I xconsole
to exit when it is unable to redirect the console output.
.TP 8
.B \-saveLines \fIcount\fP
When set,
.I xconsole
only preserves
.I count
lines of message history instead of growing the text buffer without bound
(a
.I count
of zero \- the default \- is treated as placing no limit on the history).
.SH X DEFAULTS
This program uses the
.I Athena Text
widget, look in the
.I Athena Widget Set
documentation for controlling it.
.PP
.I Xconsole
otherwise accepts resources of the same names as the command-line options
(without the leading dash).  "file" is a string type, "saveLines" an
integer, and the remaining options are booleans.
.SH WIDGETS
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxconsole\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.sp
.nf
.TA .5i
.ta .5i
XConsole  xconsole
	XConsole  text
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
.TP
.I __apploaddir__/XConsole
specifies required resources
.SH "SEE ALSO"
X(__miscmansuffix__), xrdb(1), Athena Text widget
.SH AUTHOR
Keith Packard (MIT X Consortium)
