/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#ifndef __MAGICAPTURE_COMMON_H__
#define __MAGICAPTURE_COMMON_H__

/* Types */

typedef enum _CaptureType
{
    SINGLE_WINDOW,
    SINGLE_WINDOW_DECOR,
    FULL_SCREEN
} CaptureType;

typedef struct _OptionData
{
    gboolean preview;
    gboolean hide_panel;
    gboolean dither;
} OptionData;

/* Constants */

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */

#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

#define MAX_FILENAME 1024
#define MAX_LINE 1024
#define MAX_FILETYPE 1024

/* Defaults */

#define DEFAULT_TYPE SINGLE_WINDOW
#define DEFAULT_SHOW 1
#define DEFAULT_DELAY 3
#define DEFAULT_DELAY_STR "3"

#endif /* __MAGICAPTURE_COMMON_H__ */
