package Daje::Workflow::Client::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;
use v5.40;


# NAME
# ====
#
# Daje::Client::Activity - Create a client
#
# SYNOPSIS
# ========
#
#     use Daje::Client::Activity;
#
# DESCRIPTION
# ===========
#
# Daje::Client::Activity is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Daje::Database::Model::Users;
use Daje::Database::Model::Companies;

our $VERSION = "0.01";

sub create_client($self) {

    $self->model->insert_history("New client will be created", "Daje::Workflow::Client::Activity");

    my $user = $self->context()->{user};
    my $company = $self->context->{company};

    my $user_obj = Daje::Database::Model::Users->new(
        db => $self->db
    );
    $user_obj->insert_users($user);

    my $company_obj->Daje::Database::Model::Companies->new(
        db => $self->db
    );
    $company_obj->insert_companies($company);

}

1;
__END__




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Client::Activity - Create a client



=head1 SYNOPSIS


    use Daje::Client::Activity;



=head1 DESCRIPTION


Daje::Client::Activity is ...



=head1 REQUIRES

L<Daje::Client::Create> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 create_client($self)

 create_client($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

