# Generated by default/object.tt
package Paws::ManagedBlockchain::NodeFabricLogPublishingConfiguration;
  use Moose;
  has ChaincodeLogs => (is => 'ro', isa => 'Paws::ManagedBlockchain::LogConfigurations');
  has PeerLogs => (is => 'ro', isa => 'Paws::ManagedBlockchain::LogConfigurations');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ManagedBlockchain::NodeFabricLogPublishingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ManagedBlockchain::NodeFabricLogPublishingConfiguration object:

  $service_obj->Method(Att1 => { ChaincodeLogs => $value, ..., PeerLogs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ManagedBlockchain::NodeFabricLogPublishingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ChaincodeLogs

=head1 DESCRIPTION

Configuration properties for logging events associated with a peer node
owned by a member in a Managed Blockchain network.

=head1 ATTRIBUTES


=head2 ChaincodeLogs => L<Paws::ManagedBlockchain::LogConfigurations>

Configuration properties for logging events associated with chaincode
execution on a peer node. Chaincode logs contain the results of
instantiating, invoking, and querying the chaincode. A peer can run
multiple instances of chaincode. When enabled, a log stream is created
for all chaincodes, with an individual log stream for each chaincode.


=head2 PeerLogs => L<Paws::ManagedBlockchain::LogConfigurations>

Configuration properties for a peer node log. Peer node logs contain
messages generated when your client submits transaction proposals to
peer nodes, requests to join channels, enrolls an admin peer, and lists
the chaincode instances on a peer node.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ManagedBlockchain>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

