/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDStructureTreeRoot
extends PDStructureNode {
    public static final String TYPE = "StructTreeRoot";

    public PDStructureTreeRoot() {
        super(TYPE);
    }

    public PDStructureTreeRoot(COSDictionary dic) {
        super(dic);
    }

    public PDNameTreeNode getIDTree() {
        COSDictionary idTreeDic = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.ID_TREE);
        if (idTreeDic != null) {
            return new PDNameTreeNode(idTreeDic, PDStructureElement.class);
        }
        return null;
    }

    public void setIDTree(PDNameTreeNode idTree) {
        this.getCOSDictionary().setItem(COSName.ID_TREE, (COSObjectable)idTree);
    }

    public int getParentTreeNextKey() {
        return this.getCOSDictionary().getInt(COSName.PARENT_TREE_NEXT_KEY);
    }

    public Map<String, String> getRoleMap() {
        COSBase rm = this.getCOSDictionary().getDictionaryObject(COSName.ROLE_MAP);
        if (rm instanceof COSDictionary) {
            try {
                return COSDictionaryMap.convertBasicTypesToMap((COSDictionary)rm);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Hashtable<String, String>();
    }

    public void setRoleMap(Map<String, String> roleMap) {
        COSDictionary rmDic = new COSDictionary();
        for (String key : roleMap.keySet()) {
            rmDic.setName(key, roleMap.get(key));
        }
        this.getCOSDictionary().setItem(COSName.ROLE_MAP, (COSBase)rmDic);
    }
}

