######################################################################
#
# 1100_jipsj_by_jef.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x4F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x4A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x59",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x62",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x70",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x71",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x72",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x73",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x74",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x75",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x76",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x77",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x78",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x80",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x8B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x9B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x9C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\xA0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x6A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x21",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\x22",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\x23",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\x24",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\x25",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\x06",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\x17",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\x28",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\x29",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\x2A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\x2B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x2C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\x09",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\x0A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\x1B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\x30",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\x31",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\x1A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\x33",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\x34",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\x35",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\x36",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\x08",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\x38",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\x39",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\x3A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\x3B",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x04",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x14",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\x3E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\x57",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x41",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x42",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\x43",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\x44",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\x45",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\x46",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\x47",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\x48",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\x49",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\x51",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\x52",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x53",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\x54",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\x55",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\x56",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\x58",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x81",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x82",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\x83",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x84",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x85",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x86",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x87",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x88",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x89",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x8A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\x8C",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\x8D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\x8E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\x8F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\x90",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\x91",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x92",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x93",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x94",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x95",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x96",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x97",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x98",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x99",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x9A",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x9D",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\x9E",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\x9F",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'jipsj','jef',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\xA1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x21"],
        ["\xA1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x22"],
        ["\xA1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x23"],
        ["\xA1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x24"],
        ["\xA1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x25"],
        ["\xA1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x26"],
        ["\xA1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x27"],
        ["\xA1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x28"],
        ["\xA1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x29"],
        ["\xA1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2A"],
        ["\xA1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2B"],
        ["\xA1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2C"],
        ["\xA1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2D"],
        ["\xA1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2E"],
        ["\xA1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x2F"],
        ["\xA1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x30"],
        ["\xA1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x31"],
        ["\xA1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x32"],
        ["\xA1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x33"],
        ["\xA1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x34"],
        ["\xA1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x35"],
        ["\xA1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x36"],
        ["\xA1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x37"],
        ["\xA1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x38"],
        ["\xA1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x39"],
        ["\xA1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3A"],
        ["\xA1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3B"],
        ["\xA1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3C"],
        ["\xA1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3D"],
        ["\xA1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3E"],
        ["\xA1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x3F"],
        ["\xA1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x40"],
        ["\xA1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x41"],
        ["\xA1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x42"],
        ["\xA1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x43"],
        ["\xA1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x44"],
        ["\xA1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x45"],
        ["\xA1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x46"],
        ["\xA1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x47"],
        ["\xA1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x48"],
        ["\xA1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x49"],
        ["\xA1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4A"],
        ["\xA1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4B"],
        ["\xA1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4C"],
        ["\xA1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4D"],
        ["\xA1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4E"],
        ["\xA1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x4F"],
        ["\xA1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x50"],
        ["\xA1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x51"],
        ["\xA1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x52"],
        ["\xA1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x53"],
        ["\xA1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x54"],
        ["\xA1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x55"],
        ["\xA1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x56"],
        ["\xA1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x57"],
        ["\xA1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x58"],
        ["\xA1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x59"],
        ["\xA1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5A"],
        ["\xA1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5B"],
        ["\xA1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5C"],
        ["\xA1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5D"],
        ["\xA1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5E"],
        ["\xA1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x5F"],
        ["\xA1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x60"],
        ["\xA1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x61"],
        ["\xA1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x62"],
        ["\xA1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x63"],
        ["\xA1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x64"],
        ["\xA1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x65"],
        ["\xA1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x66"],
        ["\xA1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x67"],
        ["\xA1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x68"],
        ["\xA1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x69"],
        ["\xA1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6A"],
        ["\xA1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6B"],
        ["\xA1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6C"],
        ["\xA1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6D"],
        ["\xA1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6E"],
        ["\xA1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x6F"],
        ["\xA1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x70"],
        ["\xA1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x71"],
        ["\xA1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x72"],
        ["\xA1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x73"],
        ["\xA1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x74"],
        ["\xA1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x75"],
        ["\xA1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x76"],
        ["\xA1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x77"],
        ["\xA1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x78"],
        ["\xA1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x79"],
        ["\xA1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x7A"],
        ["\xA1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x7B"],
        ["\xA1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x7C"],
        ["\xA1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x7D"],
        ["\xA1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x21\x7E"],
        ["\xA2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x21"],
        ["\xA2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x22"],
        ["\xA2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x23"],
        ["\xA2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x24"],
        ["\xA2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x25"],
        ["\xA2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x26"],
        ["\xA2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x27"],
        ["\xA2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x28"],
        ["\xA2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x29"],
        ["\xA2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2A"],
        ["\xA2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2B"],
        ["\xA2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2C"],
        ["\xA2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2D"],
        ["\xA2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x7F\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\x7F\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\x7F\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF4"],
        ["\x7F\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF5"],
        ["\x7F\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\x7F\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\x7F\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x7C"],
        ["\x7F\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x7B"],
        ["\x7F\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\x7F\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\x76\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x7F\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF6"],
        ["\x7F\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF7"],
        ["\x7F\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\x7F\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\x7F\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x77"],
        ["\x7F\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x76"],
        ["\x7F\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF8"],
        ["\x7F\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\x7F\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xF9"],
        ["\x76\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x71"],
        ["\x76\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x70"],
        ["\x7F\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\x7F\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\x7F\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x75"],
        ["\x7F\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\x7F\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\x76\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x7A"],
        ["\x7F\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x72"],
        ["\x7F\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xFA"],
        ["\x76\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\x76\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xFE"],
        ["\x7F\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xFB"],
        ["\x7F\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xFC"],
        ["\x7F\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xFD"],
        ["\x7F\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\x7F\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\x7F\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\x7F\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xFE"],
        ["\xA3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x30"],
        ["\xA3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x31"],
        ["\xA3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x32"],
        ["\xA3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x33"],
        ["\xA3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x34"],
        ["\xA3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x35"],
        ["\xA3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x36"],
        ["\xA3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x37"],
        ["\xA3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x38"],
        ["\xA3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x39"],
        ["\xA3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x41"],
        ["\xA3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x42"],
        ["\xA3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x43"],
        ["\xA3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x44"],
        ["\xA3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x45"],
        ["\xA3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x46"],
        ["\xA3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x47"],
        ["\xA3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x48"],
        ["\xA3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x49"],
        ["\xA3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4A"],
        ["\xA3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4B"],
        ["\xA3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4C"],
        ["\xA3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4D"],
        ["\xA3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4E"],
        ["\xA3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x4F"],
        ["\xA3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x50"],
        ["\xA3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x51"],
        ["\xA3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x52"],
        ["\xA3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x53"],
        ["\xA3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x54"],
        ["\xA3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x55"],
        ["\xA3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x56"],
        ["\xA3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x57"],
        ["\xA3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x58"],
        ["\xA3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x59"],
        ["\xA3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x5A"],
        ["\xA3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x61"],
        ["\xA3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x62"],
        ["\xA3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x63"],
        ["\xA3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x64"],
        ["\xA3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x65"],
        ["\xA3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x66"],
        ["\xA3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x67"],
        ["\xA3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x68"],
        ["\xA3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x69"],
        ["\xA3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6A"],
        ["\xA3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6B"],
        ["\xA3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6C"],
        ["\xA3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6D"],
        ["\xA3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6E"],
        ["\xA3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x6F"],
        ["\xA3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x70"],
        ["\xA3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x71"],
        ["\xA3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x72"],
        ["\xA3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x73"],
        ["\xA3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x74"],
        ["\xA3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x75"],
        ["\xA3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x76"],
        ["\xA3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x77"],
        ["\xA3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x78"],
        ["\xA3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x79"],
        ["\xA3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x23\x7A"],
        ["\xA4\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x21"],
        ["\xA4\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x22"],
        ["\xA4\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x23"],
        ["\xA4\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x24"],
        ["\xA4\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x25"],
        ["\xA4\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x26"],
        ["\xA4\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x27"],
        ["\xA4\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x28"],
        ["\xA4\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x29"],
        ["\xA4\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2A"],
        ["\xA4\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2B"],
        ["\xA4\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2C"],
        ["\xA4\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2D"],
        ["\xA4\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2E"],
        ["\xA4\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x2F"],
        ["\xA4\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x30"],
        ["\xA4\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x31"],
        ["\xA4\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x32"],
        ["\xA4\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x33"],
        ["\xA4\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x34"],
        ["\xA4\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x35"],
        ["\xA4\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x36"],
        ["\xA4\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x37"],
        ["\xA4\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x38"],
        ["\xA4\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x39"],
        ["\xA4\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3A"],
        ["\xA4\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3B"],
        ["\xA4\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3C"],
        ["\xA4\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3D"],
        ["\xA4\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3E"],
        ["\xA4\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x3F"],
        ["\xA4\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x40"],
        ["\xA4\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x41"],
        ["\xA4\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x42"],
        ["\xA4\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x43"],
        ["\xA4\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x44"],
        ["\xA4\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x45"],
        ["\xA4\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x46"],
        ["\xA4\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x47"],
        ["\xA4\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x48"],
        ["\xA4\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x49"],
        ["\xA4\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4A"],
        ["\xA4\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4B"],
        ["\xA4\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4C"],
        ["\xA4\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4D"],
        ["\xA4\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4E"],
        ["\xA4\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x4F"],
        ["\xA4\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x50"],
        ["\xA4\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x51"],
        ["\xA4\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x52"],
        ["\xA4\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x53"],
        ["\xA4\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x54"],
        ["\xA4\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x55"],
        ["\xA4\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x56"],
        ["\xA4\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x57"],
        ["\xA4\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x58"],
        ["\xA4\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x59"],
        ["\xA4\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5A"],
        ["\xA4\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5B"],
        ["\xA4\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5C"],
        ["\xA4\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5D"],
        ["\xA4\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5E"],
        ["\xA4\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x5F"],
        ["\xA4\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x60"],
        ["\xA4\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x61"],
        ["\xA4\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x62"],
        ["\xA4\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x63"],
        ["\xA4\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x64"],
        ["\xA4\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x65"],
        ["\xA4\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x66"],
        ["\xA4\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x67"],
        ["\xA4\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x68"],
        ["\xA4\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x69"],
        ["\xA4\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6A"],
        ["\xA4\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6B"],
        ["\xA4\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6C"],
        ["\xA4\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6D"],
        ["\xA4\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6E"],
        ["\xA4\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x6F"],
        ["\xA4\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x70"],
        ["\xA4\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x71"],
        ["\xA4\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x72"],
        ["\xA4\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x24\x73"],
        ["\xA5\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x21"],
        ["\xA5\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x22"],
        ["\xA5\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x23"],
        ["\xA5\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x24"],
        ["\xA5\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x25"],
        ["\xA5\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x26"],
        ["\xA5\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x27"],
        ["\xA5\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x28"],
        ["\xA5\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x29"],
        ["\xA5\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2A"],
        ["\xA5\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2B"],
        ["\xA5\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2C"],
        ["\xA5\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2D"],
        ["\xA5\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2E"],
        ["\xA5\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x2F"],
        ["\xA5\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x30"],
        ["\xA5\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x31"],
        ["\xA5\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x32"],
        ["\xA5\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x33"],
        ["\xA5\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x34"],
        ["\xA5\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x35"],
        ["\xA5\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x36"],
        ["\xA5\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x37"],
        ["\xA5\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x38"],
        ["\xA5\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x39"],
        ["\xA5\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3A"],
        ["\xA5\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3B"],
        ["\xA5\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3C"],
        ["\xA5\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3D"],
        ["\xA5\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3E"],
        ["\xA5\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x3F"],
        ["\xA5\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x40"],
        ["\xA5\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x41"],
        ["\xA5\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x42"],
        ["\xA5\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x43"],
        ["\xA5\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x44"],
        ["\xA5\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x45"],
        ["\xA5\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x46"],
        ["\xA5\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x47"],
        ["\xA5\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x48"],
        ["\xA5\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x49"],
        ["\xA5\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4A"],
        ["\xA5\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4B"],
        ["\xA5\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4C"],
        ["\xA5\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4D"],
        ["\xA5\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4E"],
        ["\xA5\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x4F"],
        ["\xA5\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x50"],
        ["\xA5\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x51"],
        ["\xA5\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x52"],
        ["\xA5\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x53"],
        ["\xA5\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x54"],
        ["\xA5\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x55"],
        ["\xA5\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x56"],
        ["\xA5\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x57"],
        ["\xA5\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x58"],
        ["\xA5\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x59"],
        ["\xA5\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5A"],
        ["\xA5\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5B"],
        ["\xA5\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5C"],
        ["\xA5\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5D"],
        ["\xA5\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5E"],
        ["\xA5\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x5F"],
        ["\xA5\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x60"],
        ["\xA5\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x61"],
        ["\xA5\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x62"],
        ["\xA5\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x63"],
        ["\xA5\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x64"],
        ["\xA5\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x65"],
        ["\xA5\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x66"],
        ["\xA5\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x67"],
        ["\xA5\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x68"],
        ["\xA5\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x69"],
        ["\xA5\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6A"],
        ["\xA5\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6B"],
        ["\xA5\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6C"],
        ["\xA5\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6D"],
        ["\xA5\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6E"],
        ["\xA5\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x6F"],
        ["\xA5\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x70"],
        ["\xA5\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x71"],
        ["\xA5\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x72"],
        ["\xA5\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x73"],
        ["\xA5\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x74"],
        ["\xA5\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x75"],
        ["\xA5\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x25\x76"],
        ["\xA6\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x21"],
        ["\xA6\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x22"],
        ["\xA6\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x23"],
        ["\xA6\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x24"],
        ["\xA6\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x25"],
        ["\xA6\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x26"],
        ["\xA6\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x27"],
        ["\xA6\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x28"],
        ["\xA6\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x29"],
        ["\xA6\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2A"],
        ["\xA6\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2B"],
        ["\xA6\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2C"],
        ["\xA6\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2D"],
        ["\xA6\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2E"],
        ["\xA6\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x2F"],
        ["\xA6\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x30"],
        ["\xA6\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x31"],
        ["\xA6\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x32"],
        ["\xA6\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x33"],
        ["\xA6\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x34"],
        ["\xA6\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x35"],
        ["\xA6\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x36"],
        ["\xA6\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x37"],
        ["\xA6\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x38"],
        ["\xA6\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x41"],
        ["\xA6\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x42"],
        ["\xA6\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x43"],
        ["\xA6\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x44"],
        ["\xA6\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x45"],
        ["\xA6\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x46"],
        ["\xA6\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x47"],
        ["\xA6\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x48"],
        ["\xA6\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x49"],
        ["\xA6\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4A"],
        ["\xA6\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4B"],
        ["\xA6\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4C"],
        ["\xA6\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4D"],
        ["\xA6\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4E"],
        ["\xA6\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x4F"],
        ["\xA6\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x50"],
        ["\xA6\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x51"],
        ["\xA6\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x52"],
        ["\xA6\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x53"],
        ["\xA6\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x54"],
        ["\xA6\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x55"],
        ["\xA6\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x56"],
        ["\xA6\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x57"],
        ["\xA6\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x26\x58"],
        ["\xA7\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x21"],
        ["\xA7\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x22"],
        ["\xA7\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x23"],
        ["\xA7\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x24"],
        ["\xA7\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x25"],
        ["\xA7\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x26"],
        ["\xA7\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x27"],
        ["\xA7\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x28"],
        ["\xA7\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x29"],
        ["\xA7\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2A"],
        ["\xA7\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2B"],
        ["\xA7\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2C"],
        ["\xA7\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2D"],
        ["\xA7\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2E"],
        ["\xA7\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x2F"],
        ["\xA7\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x30"],
        ["\xA7\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x31"],
        ["\xA7\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x32"],
        ["\xA7\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x33"],
        ["\xA7\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x34"],
        ["\xA7\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x35"],
        ["\xA7\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x36"],
        ["\xA7\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x37"],
        ["\xA7\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x38"],
        ["\xA7\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x39"],
        ["\xA7\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3A"],
        ["\xA7\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3B"],
        ["\xA7\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3C"],
        ["\xA7\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3D"],
        ["\xA7\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3E"],
        ["\xA7\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x3F"],
        ["\xA7\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x40"],
        ["\xA7\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x41"],
        ["\xA7\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x51"],
        ["\xA7\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x52"],
        ["\xA7\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x53"],
        ["\xA7\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x54"],
        ["\xA7\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x55"],
        ["\xA7\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x56"],
        ["\xA7\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x57"],
        ["\xA7\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x58"],
        ["\xA7\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x59"],
        ["\xA7\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5A"],
        ["\xA7\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5B"],
        ["\xA7\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5C"],
        ["\xA7\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5D"],
        ["\xA7\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5E"],
        ["\xA7\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x5F"],
        ["\xA7\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x60"],
        ["\xA7\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x61"],
        ["\xA7\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x62"],
        ["\xA7\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x63"],
        ["\xA7\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x64"],
        ["\xA7\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x65"],
        ["\xA7\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x66"],
        ["\xA7\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x67"],
        ["\xA7\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x68"],
        ["\xA7\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x69"],
        ["\xA7\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6A"],
        ["\xA7\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6B"],
        ["\xA7\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6C"],
        ["\xA7\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6D"],
        ["\xA7\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6E"],
        ["\xA7\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x6F"],
        ["\xA7\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x70"],
        ["\xA7\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x27\x71"],
        ["\x7C\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x24"],
        ["\x7C\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x26"],
        ["\x7C\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x30"],
        ["\x7C\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x34"],
        ["\x7C\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x3C"],
        ["\x7C\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x38"],
        ["\x7C\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x40"],
        ["\x7C\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x50"],
        ["\x7C\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x48"],
        ["\x7C\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x58"],
        ["\x7C\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x60"],
        ["\x7C\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x25"],
        ["\x7C\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x27"],
        ["\x7C\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x33"],
        ["\x7C\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x37"],
        ["\x7C\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x3F"],
        ["\x7C\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x3B"],
        ["\x7C\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x47"],
        ["\x7C\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x57"],
        ["\x7C\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x4F"],
        ["\x7C\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x5F"],
        ["\x7C\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x6F"],
        ["\x7C\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x44"],
        ["\x7C\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x53"],
        ["\x7C\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x4C"],
        ["\x7C\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x5B"],
        ["\x7C\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x63"],
        ["\x7F\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x41"],
        ["\x7F\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x54"],
        ["\x7F\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x49"],
        ["\x7F\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x5C"],
        ["\x7C\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2C\x66"],
        ["\x77\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x21"],
        ["\x77\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x22"],
        ["\x77\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x23"],
        ["\x77\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x24"],
        ["\x77\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x25"],
        ["\x77\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x26"],
        ["\x77\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x27"],
        ["\x77\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x28"],
        ["\x77\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x29"],
        ["\x77\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2A"],
        ["\x77\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2B"],
        ["\x77\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2C"],
        ["\x77\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2D"],
        ["\x77\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2E"],
        ["\x77\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x2F"],
        ["\x77\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x30"],
        ["\x77\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x31"],
        ["\x77\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x32"],
        ["\x77\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x33"],
        ["\x77\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x34"],
        ["\x77\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x35"],
        ["\x77\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x36"],
        ["\x77\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x37"],
        ["\x77\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x38"],
        ["\x77\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x39"],
        ["\x77\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x3A"],
        ["\x77\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x3B"],
        ["\x77\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x3C"],
        ["\x77\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x3D"],
        ["\x77\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x3E"],
        ["\x76\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x40"],
        ["\x76\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x41"],
        ["\x76\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x42"],
        ["\x76\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x43"],
        ["\x76\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x44"],
        ["\x76\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x45"],
        ["\x76\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x46"],
        ["\x76\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x47"],
        ["\x76\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x49"],
        ["\x76\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4A"],
        ["\x76\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4B"],
        ["\x76\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4C"],
        ["\x76\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4D"],
        ["\x76\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4E"],
        ["\x76\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x4F"],
        ["\x76\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x50"],
        ["\x76\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x51"],
        ["\x76\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x52"],
        ["\x76\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x53"],
        ["\x76\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x54"],
        ["\x76\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x55"],
        ["\x76\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x56"],
        ["\x76\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x62"],
        ["\x76\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x63"],
        ["\x76\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x64"],
        ["\x78\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x6A"],
        ["\x78\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x6B"],
        ["\x78\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x2D\x6C"],
        ["\xB0\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x21"],
        ["\xB0\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x22"],
        ["\xB0\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x23"],
        ["\xB0\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x24"],
        ["\xB0\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x25"],
        ["\xB0\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x26"],
        ["\xB0\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x27"],
        ["\xB0\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x28"],
        ["\xB0\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x29"],
        ["\xB0\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2A"],
        ["\xB0\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2B"],
        ["\xB0\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2C"],
        ["\xB0\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2D"],
        ["\xB0\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2E"],
        ["\xB0\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x2F"],
        ["\xB0\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x30"],
        ["\xB0\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x31"],
        ["\xB0\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x32"],
        ["\xF2\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],
        ["\xB0\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x34"],
        ["\xB0\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x35"],
        ["\xB0\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x36"],
        ["\xB0\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x37"],
        ["\xB0\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x38"],
        ["\xB0\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x39"],
        ["\xB0\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3A"],
        ["\xB0\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3B"],
        ["\xB0\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3C"],
        ["\xB0\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3D"],
        ["\xB0\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3E"],
        ["\xB0\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x3F"],
        ["\xB0\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x40"],
        ["\xB0\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x41"],
        ["\xB0\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x42"],
        ["\xB0\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x43"],
        ["\xB0\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x44"],
        ["\xB0\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x45"],
        ["\xB0\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x46"],
        ["\xB0\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x47"],
        ["\xB0\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x48"],
        ["\xB0\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x49"],
        ["\xB0\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4A"],
        ["\xB0\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4B"],
        ["\xB0\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4C"],
        ["\xB0\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4D"],
        ["\xB0\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4E"],
        ["\xB0\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x4F"],
        ["\xB0\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x50"],
        ["\xB0\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x51"],
        ["\xB0\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x52"],
        ["\xB0\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x53"],
        ["\xB0\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x54"],
        ["\xB0\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x55"],
        ["\xB0\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x56"],
        ["\xB0\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x57"],
        ["\xB0\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x58"],
        ["\xB0\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x59"],
        ["\xB0\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5A"],
        ["\xB0\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5B"],
        ["\xB0\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5C"],
        ["\xB0\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5D"],
        ["\xB0\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5E"],
        ["\xB0\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x5F"],
        ["\xB0\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x60"],
        ["\xB0\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x61"],
        ["\xB0\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x62"],
        ["\xB0\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x63"],
        ["\xB0\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x64"],
        ["\xB0\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x65"],
        ["\xB0\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x66"],
        ["\xB0\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x67"],
        ["\xB0\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x68"],
        ["\xB0\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x69"],
        ["\xB0\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6A"],
        ["\xB0\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6B"],
        ["\xB0\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6C"],
        ["\xB0\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6D"],
        ["\xB0\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6E"],
        ["\xB0\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x6F"],
        ["\xB0\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x70"],
        ["\xB0\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x71"],
        ["\xB0\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x72"],
        ["\xB0\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x73"],
        ["\xB0\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x74"],
        ["\xB0\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x75"],
        ["\xB0\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x76"],
        ["\xB0\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x77"],
        ["\xB0\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x78"],
        ["\xB0\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x79"],
        ["\xB0\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x7A"],
        ["\xB0\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x7B"],
        ["\xB0\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x7C"],
        ["\xB0\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x7D"],
        ["\xB0\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x7E"],
        ["\xB1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x21"],
        ["\xB1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x22"],
        ["\xB1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x23"],
        ["\xB1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x24"],
        ["\xB1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x25"],
        ["\xB1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x26"],
        ["\xB1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x27"],
        ["\xB1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x28"],
        ["\xB1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x29"],
        ["\xB1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2A"],
        ["\xB1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2B"],
        ["\xB1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2C"],
        ["\xB1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2D"],
        ["\xB1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2E"],
        ["\xB1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x2F"],
        ["\xB1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x30"],
        ["\xB1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x31"],
        ["\xB1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x32"],
        ["\xB1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x33"],
        ["\xB1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x34"],
        ["\xB1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x35"],
        ["\xB1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x36"],
        ["\xB1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x37"],
        ["\xB1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x38"],
        ["\xB1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x39"],
        ["\xB1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3A"],
        ["\xB1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3B"],
        ["\xB1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3C"],
        ["\xB1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3D"],
        ["\xB1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3E"],
        ["\xB1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x3F"],
        ["\xB1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x40"],
        ["\xB1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x41"],
        ["\xB1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x42"],
        ["\xB1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x43"],
        ["\xB1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x44"],
        ["\xB1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x45"],
        ["\xB1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x46"],
        ["\xB1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x47"],
        ["\xB1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x48"],
        ["\xB1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x49"],
        ["\xB1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4A"],
        ["\xB1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4B"],
        ["\xB1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4C"],
        ["\xB1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4D"],
        ["\xB1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4E"],
        ["\xB1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x4F"],
        ["\xB1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x50"],
        ["\xB1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x51"],
        ["\xB1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x52"],
        ["\xB1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x53"],
        ["\xB1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x54"],
        ["\xB1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x55"],
        ["\xB1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x56"],
        ["\xB1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x57"],
        ["\xB1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x58"],
        ["\xB1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x59"],
        ["\xB1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5A"],
        ["\xB1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5B"],
        ["\xB1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5C"],
        ["\xB1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5D"],
        ["\xB1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5E"],
        ["\xB1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x5F"],
        ["\xB1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x60"],
        ["\xB1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x61"],
        ["\xB1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x62"],
        ["\xB1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x63"],
        ["\xB1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x64"],
        ["\xB1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x65"],
        ["\xB1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x66"],
        ["\xB1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x67"],
        ["\xB1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x68"],
        ["\xB1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x69"],
        ["\xB1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6A"],
        ["\xB1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6B"],
        ["\xB1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6C"],
        ["\xB1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6D"],
        ["\xB1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6E"],
        ["\xB1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x6F"],
        ["\xB1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x70"],
        ["\xB1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x71"],
        ["\xB1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x72"],
        ["\xB1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x73"],
        ["\xB1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x74"],
        ["\xB1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x75"],
        ["\xB1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x76"],
        ["\xB1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x77"],
        ["\xB1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x78"],
        ["\xB1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x79"],
        ["\xB1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x7A"],
        ["\xB1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x7B"],
        ["\xB1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x7C"],
        ["\xB1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x7D"],
        ["\xB1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\x7E"],
        ["\xB2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x21"],
        ["\xB2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x22"],
        ["\xB2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x23"],
        ["\xB2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x24"],
        ["\xB2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x25"],
        ["\xB2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x26"],
        ["\xB2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x27"],
        ["\xB2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x28"],
        ["\xF2\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],
        ["\xB2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2A"],
        ["\xB2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2B"],
        ["\xB2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2C"],
        ["\xB2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2D"],
        ["\xB2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2E"],
        ["\xB2\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x2F"],
        ["\xB2\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x30"],
        ["\xB2\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x31"],
        ["\xB2\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x32"],
        ["\xB2\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x33"],
        ["\xB2\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x34"],
        ["\xB2\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x35"],
        ["\xB2\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x36"],
        ["\xB2\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x37"],
        ["\xB2\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x38"],
        ["\xB2\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x39"],
        ["\xB2\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3A"],
        ["\xB2\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3B"],
        ["\xB2\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3C"],
        ["\xB2\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3D"],
        ["\xB2\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3E"],
        ["\xB2\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x3F"],
        ["\xB2\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x40"],
        ["\xB2\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x41"],
        ["\xB2\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x42"],
        ["\xB2\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x43"],
        ["\xB2\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x44"],
        ["\xB2\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x45"],
        ["\xB2\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x46"],
        ["\xB2\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x47"],
        ["\xB2\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x48"],
        ["\xB2\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x49"],
        ["\xB2\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4A"],
        ["\xB2\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4B"],
        ["\xB2\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4C"],
        ["\xB2\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4D"],
        ["\xB2\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4E"],
        ["\xB2\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x4F"],
        ["\xB2\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x50"],
        ["\xB2\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x51"],
        ["\xB2\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x52"],
        ["\xB2\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x53"],
        ["\xB2\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x54"],
        ["\xB2\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x55"],
        ["\xB2\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x56"],
        ["\xB2\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x57"],
        ["\xB2\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x58"],
        ["\xB2\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x59"],
        ["\xB2\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5A"],
        ["\xB2\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5B"],
        ["\xB2\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5C"],
        ["\xB2\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5D"],
        ["\xB2\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5E"],
        ["\xB2\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x5F"],
        ["\xB2\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x60"],
        ["\xB2\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x61"],
        ["\xB2\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x62"],
        ["\xB2\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x63"],
        ["\xB2\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x64"],
        ["\xB2\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x65"],
        ["\xB2\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x66"],
        ["\xB2\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x67"],
        ["\xB2\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x68"],
        ["\xB2\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x69"],
        ["\xB2\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6A"],
        ["\xB2\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6B"],
        ["\xB2\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6C"],
        ["\xB2\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6D"],
        ["\xB2\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6E"],
        ["\xB2\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x6F"],
        ["\xB2\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x70"],
        ["\xB2\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x71"],
        ["\xB2\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x72"],
        ["\xB2\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x73"],
        ["\xB2\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x74"],
        ["\xB2\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x75"],
        ["\xB2\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x76"],
        ["\xB2\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x77"],
        ["\xB2\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x78"],
        ["\xB2\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x79"],
        ["\xB2\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x7A"],
        ["\xB2\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x7B"],
        ["\xB2\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x7C"],
        ["\xB2\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x7D"],
        ["\xB2\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x7E"],
        ["\xB3\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x21"],
        ["\xB3\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x22"],
        ["\xB3\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x23"],
        ["\xB3\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x24"],
        ["\xB3\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x25"],
        ["\xB3\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x26"],
        ["\xB3\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x27"],
        ["\xB3\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x28"],
        ["\xB3\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x29"],
        ["\xB3\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2A"],
        ["\xB3\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2B"],
        ["\xB3\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2C"],
        ["\xB3\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2D"],
        ["\xB3\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2E"],
        ["\xB3\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x2F"],
        ["\xB3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x30"],
        ["\xB3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x31"],
        ["\xB3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x32"],
        ["\xB3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x33"],
        ["\xB3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x34"],
        ["\xB3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x35"],
        ["\xB3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x36"],
        ["\xB3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x37"],
        ["\xB3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x38"],
        ["\xB3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x39"],
        ["\xB3\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3A"],
        ["\xB3\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3B"],
        ["\xB3\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3C"],
        ["\xB3\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3D"],
        ["\xB3\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3E"],
        ["\xB3\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x3F"],
        ["\xB3\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x40"],
        ["\xB3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x41"],
        ["\xE9\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],
        ["\xB3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x43"],
        ["\xB3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x44"],
        ["\xB3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x45"],
        ["\xB3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x46"],
        ["\xB3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x47"],
        ["\xB3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x48"],
        ["\xD9\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\xB3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4A"],
        ["\xB3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4B"],
        ["\xB3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4C"],
        ["\xB3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4D"],
        ["\xB3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4E"],
        ["\xB3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x4F"],
        ["\xB3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x50"],
        ["\xB3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x51"],
        ["\xB3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x52"],
        ["\xB3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x53"],
        ["\xB3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x54"],
        ["\xB3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x55"],
        ["\xB3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x56"],
        ["\xB3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x57"],
        ["\xB3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x58"],
        ["\xB3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x59"],
        ["\xB3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5A"],
        ["\xB3\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5B"],
        ["\xB3\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5C"],
        ["\xB3\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5D"],
        ["\xB3\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5E"],
        ["\xB3\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x5F"],
        ["\xB3\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x60"],
        ["\xB3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x61"],
        ["\xB3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x62"],
        ["\xB3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x63"],
        ["\xB3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x64"],
        ["\xB3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x65"],
        ["\xB3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x66"],
        ["\xB3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x67"],
        ["\xB3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x68"],
        ["\xB3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x69"],
        ["\xB3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6A"],
        ["\xB3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6B"],
        ["\xB3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6C"],
        ["\xB3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6D"],
        ["\xB3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6E"],
        ["\xB3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x6F"],
        ["\xB3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x70"],
        ["\xB3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x71"],
        ["\xB3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x72"],
        ["\xB3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x73"],
        ["\xB3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x74"],
        ["\xB3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x75"],
        ["\xE3\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\xB3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x77"],
        ["\xB3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x78"],
        ["\xB3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x79"],
        ["\xB3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x7A"],
        ["\xB3\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x7B"],
        ["\xB3\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x7C"],
        ["\xB3\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x7D"],
        ["\xB3\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x7E"],
        ["\xB4\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x21"],
        ["\xB4\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x22"],
        ["\xB4\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x23"],
        ["\xB4\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x24"],
        ["\xB4\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x25"],
        ["\xB4\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x26"],
        ["\xB4\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x27"],
        ["\xB4\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x28"],
        ["\xB4\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x29"],
        ["\xB4\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2A"],
        ["\xB4\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2B"],
        ["\xB4\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2C"],
        ["\xB4\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2D"],
        ["\xB4\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2E"],
        ["\xB4\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x2F"],
        ["\xB4\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x30"],
        ["\xB4\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x31"],
        ["\xB4\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x32"],
        ["\xB4\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x33"],
        ["\xB4\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x34"],
        ["\xB4\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x35"],
        ["\xB4\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x36"],
        ["\xB4\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x37"],
        ["\xB4\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x38"],
        ["\xB4\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x39"],
        ["\xB4\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3A"],
        ["\xB4\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3B"],
        ["\xB4\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3C"],
        ["\xB4\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3D"],
        ["\xB4\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3E"],
        ["\xB4\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x3F"],
        ["\xB4\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x40"],
        ["\xB4\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x41"],
        ["\xB4\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x42"],
        ["\xDE\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\xB4\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x44"],
        ["\xB4\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x45"],
        ["\xB4\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x46"],
        ["\xB4\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x47"],
        ["\xB4\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x48"],
        ["\xB4\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x49"],
        ["\xB4\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4A"],
        ["\xB4\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4B"],
        ["\xB4\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4C"],
        ["\xB4\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4D"],
        ["\xB4\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4E"],
        ["\xB4\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x4F"],
        ["\xB4\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x50"],
        ["\xB4\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x51"],
        ["\xEB\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5D"],
        ["\xB4\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x53"],
        ["\xB4\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x54"],
        ["\xB4\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x55"],
        ["\xB4\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x56"],
        ["\xB4\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x57"],
        ["\xB4\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x58"],
        ["\xB4\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x59"],
        ["\xB4\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5A"],
        ["\xB4\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5B"],
        ["\xB4\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5C"],
        ["\xB4\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5D"],
        ["\xB4\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5E"],
        ["\xB4\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x5F"],
        ["\xB4\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x60"],
        ["\xB4\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x61"],
        ["\xB4\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x62"],
        ["\xB4\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x63"],
        ["\xB4\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x64"],
        ["\xB4\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x65"],
        ["\xB4\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x66"],
        ["\xB4\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x67"],
        ["\xB4\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x68"],
        ["\xB4\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x69"],
        ["\xB4\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6A"],
        ["\xB4\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6B"],
        ["\xB4\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6C"],
        ["\xB4\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6D"],
        ["\xB4\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6E"],
        ["\xB4\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x6F"],
        ["\xB4\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x70"],
        ["\xB4\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x71"],
        ["\xB4\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x72"],
        ["\xB4\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x73"],
        ["\xB4\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x74"],
        ["\xB4\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x75"],
        ["\xB4\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x76"],
        ["\xB4\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x77"],
        ["\xB4\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x78"],
        ["\xB4\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x79"],
        ["\xB4\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x7A"],
        ["\xB4\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x7B"],
        ["\xB4\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x7C"],
        ["\xB4\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x7D"],
        ["\xB4\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x7E"],
        ["\xB5\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x21"],
        ["\xB5\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x22"],
        ["\xB5\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x23"],
        ["\xB5\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x24"],
        ["\xB5\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x25"],
        ["\xB5\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x26"],
        ["\xB5\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x27"],
        ["\xB5\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x28"],
        ["\xB5\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x29"],
        ["\xB5\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2A"],
        ["\xB5\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2B"],
        ["\xB5\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2C"],
        ["\xB5\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2D"],
        ["\xB5\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2E"],
        ["\xB5\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x2F"],
        ["\xB5\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x30"],
        ["\xB5\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x31"],
        ["\xB5\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x32"],
        ["\xB5\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x33"],
        ["\xB5\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x34"],
        ["\xB5\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x35"],
        ["\xB5\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x36"],
        ["\xB5\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x37"],
        ["\xB5\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x38"],
        ["\xB5\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x39"],
        ["\xB5\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3A"],
        ["\xB5\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3B"],
        ["\xB5\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3C"],
        ["\xB5\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3D"],
        ["\xB5\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3E"],
        ["\xB5\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x3F"],
        ["\xB5\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x40"],
        ["\xB5\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x41"],
        ["\xB5\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x42"],
        ["\xB5\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x43"],
        ["\xB5\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x44"],
        ["\xB5\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x45"],
        ["\xB5\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x46"],
        ["\xB5\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x47"],
        ["\xB5\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x48"],
        ["\xB5\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x49"],
        ["\xB5\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4A"],
        ["\xB5\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4B"],
        ["\xB5\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4C"],
        ["\xB5\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4D"],
        ["\xB5\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4E"],
        ["\xB5\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x4F"],
        ["\xB5\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x50"],
        ["\xB5\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x51"],
        ["\xB5\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x52"],
        ["\xB5\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x53"],
        ["\xB5\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x54"],
        ["\xB5\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x55"],
        ["\xB5\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x56"],
        ["\xB5\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x57"],
        ["\xB5\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x58"],
        ["\xB5\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x59"],
        ["\xB5\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5A"],
        ["\xB5\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5B"],
        ["\xB5\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5C"],
        ["\xB5\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5D"],
        ["\xB5\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5E"],
        ["\xB5\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x5F"],
        ["\xB5\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x60"],
        ["\xB5\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x61"],
        ["\xB5\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x62"],
        ["\xB5\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x63"],
        ["\xB5\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x64"],
        ["\xB5\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x65"],
        ["\xB5\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x66"],
        ["\xB5\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x67"],
        ["\xB5\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x68"],
        ["\xB5\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x69"],
        ["\xB5\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6A"],
        ["\xB5\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6B"],
        ["\xB5\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6C"],
        ["\xB5\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6D"],
        ["\xB5\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6E"],
        ["\xB5\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x6F"],
        ["\xB5\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x70"],
        ["\xB5\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x71"],
        ["\xB5\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x72"],
        ["\xB5\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x73"],
        ["\xB5\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x74"],
        ["\xB5\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x75"],
        ["\xB5\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x76"],
        ["\xB5\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x77"],
        ["\xB5\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x78"],
        ["\xB5\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x79"],
        ["\xB5\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x7A"],
        ["\xB5\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x7B"],
        ["\xB5\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x7C"],
        ["\xB5\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x7D"],
        ["\xB5\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x35\x7E"],
        ["\xB6\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x21"],
        ["\xB6\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x22"],
        ["\xB6\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x23"],
        ["\xB6\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x24"],
        ["\xB6\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x25"],
        ["\xB6\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x26"],
        ["\xB6\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x27"],
        ["\xB6\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x28"],
        ["\xB6\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x29"],
        ["\xB6\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2A"],
        ["\xB6\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2B"],
        ["\xB6\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2C"],
        ["\xB6\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2D"],
        ["\xB6\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2E"],
        ["\xB6\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x2F"],
        ["\xB6\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x30"],
        ["\xB6\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x31"],
        ["\xB6\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x32"],
        ["\xB6\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x33"],
        ["\xB6\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x34"],
        ["\xB6\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x35"],
        ["\xB6\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x36"],
        ["\xB6\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x37"],
        ["\xB6\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x38"],
        ["\xB6\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x39"],
        ["\xB6\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3A"],
        ["\xB6\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3B"],
        ["\xB6\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3C"],
        ["\xB6\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3D"],
        ["\xB6\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3E"],
        ["\xB6\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x3F"],
        ["\xB6\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x40"],
        ["\xB6\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x41"],
        ["\xB6\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x42"],
        ["\xB6\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x43"],
        ["\xB6\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x44"],
        ["\xB6\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x45"],
        ["\x47\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xB6\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x47"],
        ["\xB6\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x48"],
        ["\xB6\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x49"],
        ["\xB6\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4A"],
        ["\xB6\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4B"],
        ["\xB6\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4C"],
        ["\xB6\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4D"],
        ["\xB6\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4E"],
        ["\xB6\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x4F"],
        ["\xB6\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x50"],
        ["\xB6\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x51"],
        ["\xB6\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x52"],
        ["\xB6\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x53"],
        ["\xB6\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x54"],
        ["\xB6\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x55"],
        ["\xB6\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x56"],
        ["\xB6\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x57"],
        ["\xB6\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x58"],
        ["\xB6\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x59"],
        ["\xB6\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5A"],
        ["\xB6\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5B"],
        ["\xB6\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5C"],
        ["\xB6\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5D"],
        ["\xB6\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5E"],
        ["\xB6\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x5F"],
        ["\xB6\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x60"],
        ["\xB6\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x61"],
        ["\xB6\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x62"],
        ["\xB6\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x63"],
        ["\xB6\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x64"],
        ["\xB6\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x65"],
        ["\xB6\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x66"],
        ["\xB6\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x67"],
        ["\xB6\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x68"],
        ["\xB6\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x69"],
        ["\xB6\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6A"],
        ["\xB6\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6B"],
        ["\xB6\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6C"],
        ["\xB6\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6D"],
        ["\xB6\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6E"],
        ["\xB6\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x6F"],
        ["\xB6\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x70"],
        ["\xB6\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x71"],
        ["\xB6\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x72"],
        ["\xB6\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x73"],
        ["\xB6\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x74"],
        ["\xB6\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x75"],
        ["\xB6\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x76"],
        ["\xB6\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x77"],
        ["\xB6\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x78"],
        ["\xB6\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x79"],
        ["\xB6\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x7A"],
        ["\xB6\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x7B"],
        ["\xB6\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x7C"],
        ["\xB6\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x7D"],
        ["\xB6\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x7E"],
        ["\xB7\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x21"],
        ["\xB7\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x22"],
        ["\xB7\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x23"],
        ["\xB7\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x24"],
        ["\xB7\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x25"],
        ["\xB7\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x26"],
        ["\xB7\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x27"],
        ["\xB7\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x28"],
        ["\xB7\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x29"],
        ["\xB7\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2A"],
        ["\xB7\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2B"],
        ["\xB7\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2C"],
        ["\xB7\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2D"],
        ["\xB7\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2E"],
        ["\xB7\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x2F"],
        ["\xB7\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x30"],
        ["\xB7\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x31"],
        ["\xB7\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x32"],
        ["\xB7\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x33"],
        ["\xB7\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x34"],
        ["\xB7\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x35"],
        ["\xB7\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x36"],
        ["\xB7\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x37"],
        ["\xB7\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x38"],
        ["\xB7\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x39"],
        ["\xB7\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3A"],
        ["\xB7\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3B"],
        ["\xB7\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3C"],
        ["\xB7\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3D"],
        ["\xB7\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3E"],
        ["\xB7\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x3F"],
        ["\xB7\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x40"],
        ["\xB7\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x41"],
        ["\xB7\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x42"],
        ["\xB7\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x43"],
        ["\xB7\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x44"],
        ["\xB7\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x45"],
        ["\xB7\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x46"],
        ["\xB7\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x47"],
        ["\xB7\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x48"],
        ["\xB7\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x49"],
        ["\xB7\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4A"],
        ["\xB7\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4B"],
        ["\xB7\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4C"],
        ["\xB7\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4D"],
        ["\xB7\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4E"],
        ["\xB7\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x4F"],
        ["\xB7\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x50"],
        ["\xB7\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x51"],
        ["\xB7\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x52"],
        ["\xB7\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x53"],
        ["\xB7\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x54"],
        ["\xB7\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x55"],
        ["\xB7\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x56"],
        ["\xB7\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x57"],
        ["\xB7\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x58"],
        ["\xB7\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x59"],
        ["\xB7\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5A"],
        ["\xF0\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],
        ["\xB7\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5C"],
        ["\xB7\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5D"],
        ["\xB7\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5E"],
        ["\xB7\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5F"],
        ["\xB7\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x60"],
        ["\xB7\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x61"],
        ["\xB7\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x62"],
        ["\xB7\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x63"],
        ["\xB7\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x64"],
        ["\xB7\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x65"],
        ["\xB7\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x66"],
        ["\xB7\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x67"],
        ["\xB7\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x68"],
        ["\xB7\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x69"],
        ["\xB7\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6A"],
        ["\xB7\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6B"],
        ["\xB7\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6C"],
        ["\xB7\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6D"],
        ["\xB7\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6E"],
        ["\xB7\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x6F"],
        ["\xB7\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x70"],
        ["\xB7\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x71"],
        ["\xB7\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x72"],
        ["\xB7\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x73"],
        ["\xB7\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x74"],
        ["\xB7\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x75"],
        ["\xB7\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x76"],
        ["\xB7\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x77"],
        ["\xB7\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x78"],
        ["\xB7\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x79"],
        ["\xB7\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x7A"],
        ["\xB7\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x7B"],
        ["\xB7\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x7C"],
        ["\xB7\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x7D"],
        ["\xB7\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x7E"],
        ["\xB8\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x21"],
        ["\xB8\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x22"],
        ["\xB8\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x23"],
        ["\xB8\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x24"],
        ["\xB8\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x25"],
        ["\xB8\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x26"],
        ["\xB8\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x27"],
        ["\xB8\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x28"],
        ["\xB8\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x29"],
        ["\xB8\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2A"],
        ["\xB8\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2B"],
        ["\xB8\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2C"],
        ["\xB8\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2D"],
        ["\xB8\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2E"],
        ["\xB8\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x2F"],
        ["\xB8\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x30"],
        ["\xB8\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x31"],
        ["\xB8\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x32"],
        ["\xB8\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x33"],
        ["\xB8\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x34"],
        ["\xB8\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x35"],
        ["\xB8\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x36"],
        ["\xB8\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x37"],
        ["\xB8\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x38"],
        ["\xB8\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x39"],
        ["\xB8\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3A"],
        ["\xB8\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3B"],
        ["\xB8\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3C"],
        ["\xB8\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3D"],
        ["\xB8\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3E"],
        ["\xB8\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x3F"],
        ["\xB8\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x40"],
        ["\xB8\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x41"],
        ["\xB8\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x42"],
        ["\xB8\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x43"],
        ["\xB8\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x44"],
        ["\xB8\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x45"],
        ["\xB8\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x46"],
        ["\xB8\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x47"],
        ["\xB8\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x48"],
        ["\xB8\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x49"],
        ["\xB8\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4A"],
        ["\xB8\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4B"],
        ["\xB8\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4C"],
        ["\xB8\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4D"],
        ["\xB8\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4E"],
        ["\xB8\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x4F"],
        ["\xB8\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x50"],
        ["\xB8\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x51"],
        ["\xB8\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x52"],
        ["\xB8\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x53"],
        ["\xB8\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x54"],
        ["\xB8\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x55"],
        ["\xB8\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x56"],
        ["\xB8\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x57"],
        ["\xB8\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x58"],
        ["\xB8\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x59"],
        ["\xB8\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5A"],
        ["\xB8\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5B"],
        ["\xB8\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5C"],
        ["\xB8\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5D"],
        ["\xB8\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5E"],
        ["\xB8\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x5F"],
        ["\xB8\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x60"],
        ["\xB8\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x61"],
        ["\xB8\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x62"],
        ["\xB8\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x63"],
        ["\xB8\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x64"],
        ["\xB8\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x65"],
        ["\xB8\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x66"],
        ["\xB8\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x67"],
        ["\xB8\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x68"],
        ["\xB8\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x69"],
        ["\xB8\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6A"],
        ["\xB8\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6B"],
        ["\xB8\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6C"],
        ["\xB8\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6D"],
        ["\xB8\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6E"],
        ["\xB8\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x6F"],
        ["\xB8\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x70"],
        ["\xB8\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x71"],
        ["\xB8\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x72"],
        ["\xB8\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x73"],
        ["\xB8\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x74"],
        ["\xB8\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x75"],
        ["\xB8\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x76"],
        ["\xB8\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x77"],
        ["\xB8\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x78"],
        ["\xB8\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x79"],
        ["\xB8\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x7A"],
        ["\xB8\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x7B"],
        ["\xB8\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x7C"],
        ["\xB8\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x7D"],
        ["\xB8\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x38\x7E"],
        ["\xB9\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x21"],
        ["\xB9\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x22"],
        ["\xB9\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x23"],
        ["\xB9\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x24"],
        ["\xB9\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x25"],
        ["\xB9\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x26"],
        ["\xB9\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x27"],
        ["\xB9\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x28"],
        ["\xB9\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x29"],
        ["\xB9\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2A"],
        ["\xB9\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2B"],
        ["\xB9\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2C"],
        ["\xB9\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2D"],
        ["\xB9\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2E"],
        ["\xB9\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x2F"],
        ["\xB9\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x30"],
        ["\xB9\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x31"],
        ["\xB9\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x32"],
        ["\xB9\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x33"],
        ["\xB9\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x34"],
        ["\xB9\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x35"],
        ["\xB9\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x36"],
        ["\x50\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xB9\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x38"],
        ["\xB9\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x39"],
        ["\xB9\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3A"],
        ["\xB9\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3B"],
        ["\xB9\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3C"],
        ["\xB9\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3D"],
        ["\xB9\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3E"],
        ["\xB9\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x3F"],
        ["\xB9\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x40"],
        ["\xB9\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x41"],
        ["\xB9\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x42"],
        ["\xB9\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x43"],
        ["\xB9\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x44"],
        ["\xB9\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x45"],
        ["\xB9\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x46"],
        ["\xB9\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x47"],
        ["\xB9\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x48"],
        ["\xB9\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x49"],
        ["\xB9\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4A"],
        ["\xB9\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4B"],
        ["\xB9\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4C"],
        ["\xB9\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4D"],
        ["\xB9\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4E"],
        ["\xB9\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x4F"],
        ["\xB9\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x50"],
        ["\xB9\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x51"],
        ["\xB9\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x52"],
        ["\xB9\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x53"],
        ["\xB9\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x54"],
        ["\xB9\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x55"],
        ["\xB9\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x56"],
        ["\xB9\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x57"],
        ["\xB9\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x58"],
        ["\xB9\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x59"],
        ["\xB9\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5A"],
        ["\xB9\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5B"],
        ["\xE2\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\xB9\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5D"],
        ["\xB9\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5E"],
        ["\xB9\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5F"],
        ["\xB9\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x60"],
        ["\xB9\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x61"],
        ["\xB9\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x62"],
        ["\xB9\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x63"],
        ["\xB9\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x64"],
        ["\xB9\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x65"],
        ["\xB9\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x66"],
        ["\xB9\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x67"],
        ["\xB9\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x68"],
        ["\xB9\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x69"],
        ["\xB9\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6A"],
        ["\xB9\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6B"],
        ["\xB9\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6C"],
        ["\x6F\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xB9\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6E"],
        ["\xB9\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6F"],
        ["\xB9\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x70"],
        ["\xB9\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x71"],
        ["\xB9\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x72"],
        ["\xB9\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x73"],
        ["\xB9\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x74"],
        ["\xB9\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x75"],
        ["\xB9\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x76"],
        ["\xB9\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x77"],
        ["\xB9\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x78"],
        ["\xB9\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x79"],
        ["\xB9\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x7A"],
        ["\xB9\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x7B"],
        ["\xB9\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x7C"],
        ["\xB9\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x7D"],
        ["\xB9\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x7E"],
        ["\xBA\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x21"],
        ["\xBA\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x22"],
        ["\xBA\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x23"],
        ["\xBA\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x24"],
        ["\xBA\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x25"],
        ["\xBA\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x26"],
        ["\xBA\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x27"],
        ["\xBA\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x28"],
        ["\xBA\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x29"],
        ["\xBA\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2A"],
        ["\xBA\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2B"],
        ["\xBA\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2C"],
        ["\xBA\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2D"],
        ["\xBA\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2E"],
        ["\xBA\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x2F"],
        ["\xBA\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x30"],
        ["\xBA\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x31"],
        ["\xBA\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x32"],
        ["\xBA\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x33"],
        ["\xBA\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x34"],
        ["\xBA\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x35"],
        ["\xBA\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x36"],
        ["\xBA\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x37"],
        ["\xBA\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x38"],
        ["\xBA\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x39"],
        ["\xBA\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3A"],
        ["\xBA\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3B"],
        ["\xBA\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3C"],
        ["\xBA\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3D"],
        ["\xBA\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3E"],
        ["\xBA\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x3F"],
        ["\xBA\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x40"],
        ["\xBA\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x41"],
        ["\xBA\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x42"],
        ["\xBA\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x43"],
        ["\xBA\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x44"],
        ["\xBA\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x45"],
        ["\xBA\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x46"],
        ["\xBA\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x47"],
        ["\xBA\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x48"],
        ["\xBA\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x49"],
        ["\xBA\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4A"],
        ["\xBA\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4B"],
        ["\xBA\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4C"],
        ["\xBA\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4D"],
        ["\xBA\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4E"],
        ["\xBA\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x4F"],
        ["\xBA\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x50"],
        ["\xBA\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x51"],
        ["\xBA\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x52"],
        ["\xBA\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x53"],
        ["\xBA\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x54"],
        ["\xBA\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x55"],
        ["\xBA\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x56"],
        ["\xBA\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x57"],
        ["\xBA\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x58"],
        ["\xBA\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x59"],
        ["\xBA\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5A"],
        ["\xBA\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5B"],
        ["\xBA\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5C"],
        ["\xBA\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5D"],
        ["\xBA\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5E"],
        ["\xBA\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x5F"],
        ["\xBA\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x60"],
        ["\xBA\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x61"],
        ["\xBA\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x62"],
        ["\xBA\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x63"],
        ["\xBA\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x64"],
        ["\xBA\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x65"],
        ["\xBA\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x66"],
        ["\xBA\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x67"],
        ["\xBA\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x68"],
        ["\xBA\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x69"],
        ["\xBA\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6A"],
        ["\xBA\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6B"],
        ["\xBA\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6C"],
        ["\xBA\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6D"],
        ["\xBA\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6E"],
        ["\xBA\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x6F"],
        ["\xBA\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x70"],
        ["\xBA\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x71"],
        ["\xBA\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x72"],
        ["\xBA\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x73"],
        ["\xBA\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x74"],
        ["\xBA\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x75"],
        ["\xBA\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x76"],
        ["\xBA\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x77"],
        ["\xBA\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x78"],
        ["\xBA\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x79"],
        ["\xBA\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x7A"],
        ["\xBA\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x7B"],
        ["\xBA\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x7C"],
        ["\xBA\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x7D"],
        ["\xBA\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3A\x7E"],
        ["\xBB\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x21"],
        ["\xBB\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x22"],
        ["\xBB\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x23"],
        ["\xBB\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x24"],
        ["\xBB\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x25"],
        ["\xBB\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x26"],
        ["\xBB\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x27"],
        ["\xBB\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x28"],
        ["\xBB\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x29"],
        ["\xBB\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2A"],
        ["\xBB\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2B"],
        ["\xBB\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2C"],
        ["\xBB\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2D"],
        ["\xBB\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2E"],
        ["\xBB\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x2F"],
        ["\xBB\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x30"],
        ["\xBB\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x31"],
        ["\xBB\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x32"],
        ["\xBB\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x33"],
        ["\xBB\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x34"],
        ["\xBB\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x35"],
        ["\xBB\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x36"],
        ["\xBB\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x37"],
        ["\xBB\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x38"],
        ["\xBB\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x39"],
        ["\xBB\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3A"],
        ["\xBB\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3B"],
        ["\xBB\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3C"],
        ["\xBB\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3D"],
        ["\xBB\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3E"],
        ["\xBB\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x3F"],
        ["\xBB\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x40"],
        ["\xBB\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x41"],
        ["\xBB\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x42"],
        ["\xBB\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x43"],
        ["\xBB\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x44"],
        ["\xBB\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x45"],
        ["\xBB\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x46"],
        ["\xBB\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x47"],
        ["\xBB\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x48"],
        ["\xBB\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x49"],
        ["\xBB\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4A"],
        ["\xBB\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4B"],
        ["\xBB\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4C"],
        ["\xBB\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4D"],
        ["\xBB\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4E"],
        ["\xBB\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x4F"],
        ["\xBB\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x50"],
        ["\xBB\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x51"],
        ["\xBB\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x52"],
        ["\xBB\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x53"],
        ["\xBB\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x54"],
        ["\xBB\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x55"],
        ["\xBB\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x56"],
        ["\xBB\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x57"],
        ["\xBB\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x58"],
        ["\xBB\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x59"],
        ["\xBB\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5A"],
        ["\xBB\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5B"],
        ["\xBB\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5C"],
        ["\xBB\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5D"],
        ["\xBB\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5E"],
        ["\xBB\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x5F"],
        ["\xBB\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x60"],
        ["\xBB\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x61"],
        ["\xBB\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x62"],
        ["\xBB\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x63"],
        ["\xBB\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x64"],
        ["\xBB\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x65"],
        ["\xBB\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x66"],
        ["\xBB\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x67"],
        ["\xBB\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x68"],
        ["\xBB\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x69"],
        ["\xBB\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6A"],
        ["\xBB\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6B"],
        ["\xBB\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6C"],
        ["\xBB\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6D"],
        ["\xBB\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6E"],
        ["\xBB\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x6F"],
        ["\xBB\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x70"],
        ["\xBB\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x71"],
        ["\xBB\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x72"],
        ["\xBB\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x73"],
        ["\xBB\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x74"],
        ["\xBB\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x75"],
        ["\xBB\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x76"],
        ["\xBB\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x77"],
        ["\xBB\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x78"],
        ["\xBB\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x79"],
        ["\xBB\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x7A"],
        ["\xBB\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x7B"],
        ["\xBB\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x7C"],
        ["\xBB\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x7D"],
        ["\xBB\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3B\x7E"],
        ["\xBC\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x21"],
        ["\xBC\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x22"],
        ["\xBC\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x23"],
        ["\xBC\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x24"],
        ["\xBC\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x25"],
        ["\xBC\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x26"],
        ["\xBC\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x27"],
        ["\xBC\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x28"],
        ["\xBC\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x29"],
        ["\xBC\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2A"],
        ["\xBC\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2B"],
        ["\xBC\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2C"],
        ["\xBC\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2D"],
        ["\xBC\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2E"],
        ["\xBC\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x2F"],
        ["\xBC\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x30"],
        ["\xBC\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x31"],
        ["\xBC\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x32"],
        ["\xBC\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x33"],
        ["\xBC\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x34"],
        ["\xBC\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x35"],
        ["\xBC\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x36"],
        ["\xBC\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x37"],
        ["\xBC\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x38"],
        ["\xBC\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x39"],
        ["\xBC\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3A"],
        ["\xBC\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3B"],
        ["\xBC\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3C"],
        ["\xBC\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3D"],
        ["\xBC\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3E"],
        ["\xBC\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x3F"],
        ["\xBC\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x40"],
        ["\xBC\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x41"],
        ["\xBC\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x42"],
        ["\xBC\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x43"],
        ["\xBC\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x44"],
        ["\xBC\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x45"],
        ["\xBC\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x46"],
        ["\xBC\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x47"],
        ["\xBC\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x48"],
        ["\xE9\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x22"],
        ["\xBC\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4A"],
        ["\xBC\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4B"],
        ["\xBC\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4C"],
        ["\xBC\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4D"],
        ["\xBC\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4E"],
        ["\xBC\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x4F"],
        ["\xBC\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x50"],
        ["\xBC\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x51"],
        ["\xBC\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x52"],
        ["\xBC\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x53"],
        ["\xBC\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x54"],
        ["\xBC\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x55"],
        ["\xBC\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x56"],
        ["\xBC\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x57"],
        ["\xBC\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x58"],
        ["\xBC\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x59"],
        ["\xBC\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5A"],
        ["\xBC\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5B"],
        ["\xBC\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5C"],
        ["\xBC\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5D"],
        ["\xBC\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5E"],
        ["\xBC\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x5F"],
        ["\xBC\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x60"],
        ["\xBC\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x61"],
        ["\xBC\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x62"],
        ["\xBC\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x63"],
        ["\xBC\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x64"],
        ["\xBC\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x65"],
        ["\xBC\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x66"],
        ["\xBC\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x67"],
        ["\xBC\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x68"],
        ["\xBC\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x69"],
        ["\xBC\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6A"],
        ["\xBC\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6B"],
        ["\xBC\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6C"],
        ["\xBC\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6D"],
        ["\xBC\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6E"],
        ["\xBC\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x6F"],
        ["\xBC\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x70"],
        ["\xBC\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x71"],
        ["\xBC\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x72"],
        ["\xBC\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x73"],
        ["\xBC\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x74"],
        ["\xBC\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x75"],
        ["\xBC\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x76"],
        ["\xBC\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x77"],
        ["\xBC\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x78"],
        ["\xBC\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x79"],
        ["\xBC\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x7A"],
        ["\xBC\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x7B"],
        ["\xBC\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x7C"],
        ["\xBC\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x7D"],
        ["\xBC\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x7E"],
        ["\xBD\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x21"],
        ["\xBD\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x22"],
        ["\xBD\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x23"],
        ["\xBD\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x24"],
        ["\xBD\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x25"],
        ["\xBD\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x26"],
        ["\xBD\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x27"],
        ["\xBD\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x28"],
        ["\xBD\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x29"],
        ["\xBD\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2A"],
        ["\xBD\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2B"],
        ["\xBD\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2C"],
        ["\xBD\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2D"],
        ["\xBD\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2E"],
        ["\xBD\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x2F"],
        ["\xBD\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x30"],
        ["\xBD\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x31"],
        ["\xBD\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x32"],
        ["\xBD\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x33"],
        ["\xBD\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x34"],
        ["\xBD\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x35"],
        ["\xBD\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x36"],
        ["\xBD\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x37"],
        ["\xBD\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x38"],
        ["\xBD\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x39"],
        ["\xBD\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3A"],
        ["\xBD\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3B"],
        ["\xBD\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3C"],
        ["\xBD\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3D"],
        ["\xBD\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3E"],
        ["\xBD\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x3F"],
        ["\xBD\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x40"],
        ["\xBD\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x41"],
        ["\xBD\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x42"],
        ["\xBD\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x43"],
        ["\xBD\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x44"],
        ["\xBD\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x45"],
        ["\xBD\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x46"],
        ["\xBD\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x47"],
        ["\xBD\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x48"],
        ["\xBD\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x49"],
        ["\xBD\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4A"],
        ["\xBD\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4B"],
        ["\xBD\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4C"],
        ["\xBD\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4D"],
        ["\xBD\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4E"],
        ["\xBD\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x4F"],
        ["\xBD\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x50"],
        ["\xBD\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x51"],
        ["\xBD\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x52"],
        ["\xBD\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x53"],
        ["\xBD\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x54"],
        ["\xBD\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x55"],
        ["\xBD\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x56"],
        ["\xBD\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x57"],
        ["\xBD\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x58"],
        ["\xBD\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x59"],
        ["\xBD\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5A"],
        ["\xBD\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5B"],
        ["\xBD\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5C"],
        ["\xBD\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5D"],
        ["\xBD\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5E"],
        ["\xBD\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x5F"],
        ["\xBD\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x60"],
        ["\xBD\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x61"],
        ["\xBD\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x62"],
        ["\xBD\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x63"],
        ["\xBD\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x64"],
        ["\xBD\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x65"],
        ["\xBD\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x66"],
        ["\xBD\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x67"],
        ["\xBD\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x68"],
        ["\xBD\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x69"],
        ["\xBD\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6A"],
        ["\xBD\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6B"],
        ["\xBD\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6C"],
        ["\xBD\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6D"],
        ["\xBD\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6E"],
        ["\xBD\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x6F"],
        ["\xBD\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x70"],
        ["\xBD\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x71"],
        ["\xBD\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x72"],
        ["\xBD\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x73"],
        ["\xBD\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x74"],
        ["\xBD\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x75"],
        ["\xBD\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x76"],
        ["\xBD\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x77"],
        ["\xBD\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x78"],
        ["\xBD\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x79"],
        ["\xBD\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x7A"],
        ["\xBD\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x7B"],
        ["\xBD\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x7C"],
        ["\xBD\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x7D"],
        ["\xBD\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3D\x7E"],
        ["\xBE\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x21"],
        ["\xBE\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x22"],
        ["\xBE\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x23"],
        ["\xBE\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x24"],
        ["\xBE\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x25"],
        ["\xBE\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x26"],
        ["\xBE\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x27"],
        ["\xBE\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x28"],
        ["\xBE\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x29"],
        ["\xBE\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2A"],
        ["\xBE\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2B"],
        ["\xBE\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2C"],
        ["\xBE\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2D"],
        ["\xBE\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2E"],
        ["\xBE\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x2F"],
        ["\xBE\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x30"],
        ["\xBE\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x31"],
        ["\xBE\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x32"],
        ["\xBE\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x33"],
        ["\xBE\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x34"],
        ["\xBE\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x35"],
        ["\xBE\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x36"],
        ["\xBE\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x37"],
        ["\xBE\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x38"],
        ["\xBE\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x39"],
        ["\xBE\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3A"],
        ["\xBE\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3B"],
        ["\xBE\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3C"],
        ["\xBE\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3D"],
        ["\xBE\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3E"],
        ["\xBE\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x3F"],
        ["\xBE\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x40"],
        ["\xBE\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x41"],
        ["\xBE\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x42"],
        ["\xBE\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x43"],
        ["\xBE\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x44"],
        ["\xBE\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x45"],
        ["\xBE\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x46"],
        ["\xBE\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x47"],
        ["\xBE\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x48"],
        ["\xBE\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x49"],
        ["\xBE\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4A"],
        ["\xBE\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4B"],
        ["\xBE\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4C"],
        ["\xBE\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4D"],
        ["\xBE\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4E"],
        ["\xBE\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x4F"],
        ["\xBE\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x50"],
        ["\xBE\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x51"],
        ["\xBE\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x52"],
        ["\xBE\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x53"],
        ["\xBE\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x54"],
        ["\xBE\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x55"],
        ["\xBE\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x56"],
        ["\xBE\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x57"],
        ["\xBE\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x58"],
        ["\xBE\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x59"],
        ["\xBE\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5A"],
        ["\xBE\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5B"],
        ["\xBE\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5C"],
        ["\xBE\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5D"],
        ["\xBE\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5E"],
        ["\xBE\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x5F"],
        ["\xBE\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x60"],
        ["\xBE\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x61"],
        ["\xBE\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x62"],
        ["\xBE\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x63"],
        ["\xBE\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x64"],
        ["\xBE\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x65"],
        ["\xBE\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x66"],
        ["\xBE\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x67"],
        ["\xBE\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x68"],
        ["\xBE\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x69"],
        ["\xBE\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6A"],
        ["\xBE\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6B"],
        ["\xBE\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6C"],
        ["\xBE\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6D"],
        ["\xBE\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6E"],
        ["\xBE\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x6F"],
        ["\xBE\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x70"],
        ["\xBE\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x71"],
        ["\xBE\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x72"],
        ["\xBE\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x73"],
        ["\xBE\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x74"],
        ["\xBE\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x75"],
        ["\xBE\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x76"],
        ["\xBE\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x77"],
        ["\xBE\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x78"],
        ["\xBE\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x79"],
        ["\xBE\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x7A"],
        ["\xBE\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x7B"],
        ["\xBE\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x7C"],
        ["\xBE\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x7D"],
        ["\xBE\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3E\x7E"],
        ["\xBF\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x21"],
        ["\xBF\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x22"],
        ["\xBF\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x23"],
        ["\xBF\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x24"],
        ["\xBF\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x25"],
        ["\xBF\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x26"],
        ["\xBF\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x27"],
        ["\xBF\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x28"],
        ["\xBF\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x29"],
        ["\xBF\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2A"],
        ["\xBF\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2B"],
        ["\xBF\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2C"],
        ["\xBF\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2D"],
        ["\xBF\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2E"],
        ["\xBF\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x2F"],
        ["\xBF\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x30"],
        ["\xBF\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x31"],
        ["\xBF\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x32"],
        ["\xBF\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x33"],
        ["\xBF\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x34"],
        ["\xBF\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x35"],
        ["\xBF\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x36"],
        ["\xBF\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x37"],
        ["\xBF\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x38"],
        ["\xBF\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x39"],
        ["\xBF\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3A"],
        ["\xBF\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3B"],
        ["\xBF\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3C"],
        ["\xBF\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3D"],
        ["\xBF\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3E"],
        ["\xBF\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x3F"],
        ["\xBF\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x40"],
        ["\xBF\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x41"],
        ["\xBF\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x42"],
        ["\xBF\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x43"],
        ["\xBF\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x44"],
        ["\xBF\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x45"],
        ["\xBF\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x46"],
        ["\xBF\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x47"],
        ["\xBF\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x48"],
        ["\xBF\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x49"],
        ["\xBF\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4A"],
        ["\xBF\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4B"],
        ["\xBF\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4C"],
        ["\xBF\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4D"],
        ["\xBF\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4E"],
        ["\xBF\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x4F"],
        ["\xBF\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x50"],
        ["\xBF\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x51"],
        ["\xBF\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x52"],
        ["\xBF\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x53"],
        ["\xBF\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x54"],
        ["\xBF\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x55"],
        ["\xBF\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x56"],
        ["\xBF\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x57"],
        ["\xBF\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x58"],
        ["\xF0\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],
        ["\xBF\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5A"],
        ["\xBF\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5B"],
        ["\xBF\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5C"],
        ["\xBF\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5D"],
        ["\xBF\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5E"],
        ["\xBF\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x5F"],
        ["\xBF\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x60"],
        ["\xBF\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x61"],
        ["\xBF\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x62"],
        ["\xBF\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x63"],
        ["\xBF\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x64"],
        ["\xBF\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x65"],
        ["\xBF\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x66"],
        ["\xBF\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x67"],
        ["\xBF\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x68"],
        ["\xBF\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x69"],
        ["\xBF\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6A"],
        ["\xBF\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6B"],
        ["\xBF\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6C"],
        ["\xBF\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6D"],
        ["\xBF\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6E"],
        ["\xBF\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x6F"],
        ["\xBF\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x70"],
        ["\xBF\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x71"],
        ["\xBF\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x72"],
        ["\xBF\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x73"],
        ["\xBF\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x74"],
        ["\xBF\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x75"],
        ["\xBF\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x76"],
        ["\xBF\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x77"],
        ["\xBF\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x78"],
        ["\xBF\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x79"],
        ["\xBF\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x7A"],
        ["\xBF\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x7B"],
        ["\xBF\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x7C"],
        ["\xBF\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x7D"],
        ["\xBF\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x7E"],
        ["\xC0\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x21"],
        ["\xC0\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x22"],
        ["\xC0\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x23"],
        ["\xC0\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x24"],
        ["\xC0\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x25"],
        ["\xC0\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x26"],
        ["\xC0\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x27"],
        ["\xC0\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x28"],
        ["\xC0\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x29"],
        ["\xC0\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2A"],
        ["\xC0\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2B"],
        ["\xC0\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2C"],
        ["\xC0\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2D"],
        ["\xC0\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2E"],
        ["\xC0\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x2F"],
        ["\xC0\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x30"],
        ["\xC0\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x31"],
        ["\xC0\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x32"],
        ["\xC0\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x33"],
        ["\xC0\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x34"],
        ["\xC0\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x35"],
        ["\xC0\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x36"],
        ["\xC0\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x37"],
        ["\xC0\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x38"],
        ["\xC0\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x39"],
        ["\xC0\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3A"],
        ["\xC0\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3B"],
        ["\xC0\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3C"],
        ["\xC0\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3D"],
        ["\xC0\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3E"],
        ["\xC0\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x3F"],
        ["\xC0\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\xC0\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x41"],
        ["\xC0\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x42"],
        ["\xC0\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x43"],
        ["\xC0\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x44"],
        ["\xC0\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x45"],
        ["\xC0\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x46"],
        ["\xC0\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x47"],
        ["\xC0\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x48"],
        ["\xC0\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x49"],
        ["\xC0\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4A"],
        ["\xC0\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4B"],
        ["\xC0\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4C"],
        ["\xC0\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4D"],
        ["\xC0\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4E"],
        ["\xC0\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x4F"],
        ["\xC0\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x50"],
        ["\xC0\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x51"],
        ["\xC0\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x52"],
        ["\xC0\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x53"],
        ["\xC0\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x54"],
        ["\xC0\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x55"],
        ["\xC0\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x56"],
        ["\xC0\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x57"],
        ["\xC0\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x58"],
        ["\xC0\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x59"],
        ["\xC0\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5A"],
        ["\xC0\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5B"],
        ["\xC0\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5C"],
        ["\xC0\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5D"],
        ["\xC0\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5E"],
        ["\xC0\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x5F"],
        ["\xC0\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x60"],
        ["\xC0\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x61"],
        ["\xC0\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x62"],
        ["\xC0\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x63"],
        ["\xC0\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x64"],
        ["\xC0\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x65"],
        ["\xC0\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x66"],
        ["\xC0\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x67"],
        ["\xC0\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x68"],
        ["\xC0\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x69"],
        ["\xC0\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6A"],
        ["\xC0\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6B"],
        ["\xC0\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6C"],
        ["\xC0\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6D"],
        ["\xC0\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6E"],
        ["\xC0\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x6F"],
        ["\xC0\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x70"],
        ["\xC0\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x71"],
        ["\xC0\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x72"],
        ["\xC0\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x73"],
        ["\xC0\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x74"],
        ["\xC0\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x75"],
        ["\xC0\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x76"],
        ["\xC0\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x77"],
        ["\xC0\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x78"],
        ["\xC0\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x79"],
        ["\xC0\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x7A"],
        ["\xC0\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x7B"],
        ["\xC0\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x7C"],
        ["\xC0\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x7D"],
        ["\xC0\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x40\x7E"],
        ["\xC1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x21"],
        ["\xC1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x22"],
        ["\xC1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x23"],
        ["\xC1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x24"],
        ["\xC1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x25"],
        ["\xC1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x26"],
        ["\xC1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x27"],
        ["\xEC\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],
        ["\xC1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x29"],
        ["\xC1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2A"],
        ["\xC1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2B"],
        ["\xC1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2C"],
        ["\xC1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2D"],
        ["\xC1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2E"],
        ["\xC1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x2F"],
        ["\xC1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x30"],
        ["\xC1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x31"],
        ["\xC1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x32"],
        ["\xC1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x33"],
        ["\xC1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x34"],
        ["\xC1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x35"],
        ["\xC1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x36"],
        ["\xC1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x37"],
        ["\xC1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x38"],
        ["\xC1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x39"],
        ["\xC1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3A"],
        ["\xC1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3B"],
        ["\xC1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3C"],
        ["\xC1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3D"],
        ["\xC1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3E"],
        ["\xC1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x3F"],
        ["\xC1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x40"],
        ["\xC1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\xC1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\xC1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\xC1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\xC1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\xC1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\xC1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\xC1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\xC1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\xC1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\xC1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\xC1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\xC1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\xC1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\xC1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\xC1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\xC1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\xC1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\xC1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\xC1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\xC1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\xC1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\xC1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\xC1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\xC1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x59"],
        ["\xC1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5A"],
        ["\xC1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5B"],
        ["\xC1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5C"],
        ["\xC1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5D"],
        ["\xC1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5E"],
        ["\xC1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x5F"],
        ["\xC1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x60"],
        ["\xC1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\xC1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\xC1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\xC1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\xC1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\xC1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\xC1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\xC1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\xC1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\xC1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\xC1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\xC1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\xC1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\xC1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\xC1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\xC1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\xC1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\xC1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\xC1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\xC1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\xC1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\xC1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\xC1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\xC1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\xC1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x79"],
        ["\xC1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x7A"],
        ["\xC1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x7B"],
        ["\xC1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x7C"],
        ["\xC1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x7D"],
        ["\xC1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x7E"],
        ["\xC2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x21"],
        ["\xC2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x22"],
        ["\xC2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x23"],
        ["\xC2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x24"],
        ["\xC2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x25"],
        ["\xC2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x26"],
        ["\xC2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x27"],
        ["\xC2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x28"],
        ["\xC2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x29"],
        ["\xC2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2A"],
        ["\xC2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2B"],
        ["\xC2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2C"],
        ["\xC2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2D"],
        ["\xC2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2E"],
        ["\xC2\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x2F"],
        ["\xC2\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x30"],
        ["\xC2\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x31"],
        ["\xC2\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x32"],
        ["\xC2\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x33"],
        ["\xC2\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x34"],
        ["\xC2\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x35"],
        ["\xC2\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x36"],
        ["\xC2\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x37"],
        ["\xC2\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x38"],
        ["\xC2\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x39"],
        ["\xC2\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3A"],
        ["\xC2\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3B"],
        ["\xC2\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3C"],
        ["\xC2\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3D"],
        ["\xC2\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3E"],
        ["\xC2\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x3F"],
        ["\xC2\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x40"],
        ["\xC2\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x41"],
        ["\xC2\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x42"],
        ["\xC2\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x43"],
        ["\xC2\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x44"],
        ["\xC2\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x45"],
        ["\xC2\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x46"],
        ["\xC2\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x47"],
        ["\xC2\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x48"],
        ["\xC2\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x49"],
        ["\xC2\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\xC2\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\xC2\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\xC2\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\xC2\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\xC2\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\xC2\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\xC2\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x51"],
        ["\xC2\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x52"],
        ["\xC2\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x53"],
        ["\xC2\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x54"],
        ["\xC2\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x55"],
        ["\xC2\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x56"],
        ["\xC2\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x57"],
        ["\xC2\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x58"],
        ["\xC2\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x59"],
        ["\xC2\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\xC2\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\xC2\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\xC2\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\xC2\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\xC2\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\xC2\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],
        ["\xC2\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\xC2\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x62"],
        ["\xC2\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x63"],
        ["\xC2\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x64"],
        ["\xC2\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x65"],
        ["\xC2\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x66"],
        ["\xC2\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x67"],
        ["\xC2\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x68"],
        ["\xC2\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x69"],
        ["\xC2\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],
        ["\xC2\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\xC2\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\xC2\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\xC2\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\xC2\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\xC2\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x70"],
        ["\xC2\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x71"],
        ["\xC2\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x72"],
        ["\xC2\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x73"],
        ["\xC2\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x74"],
        ["\xC2\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x75"],
        ["\xC2\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x76"],
        ["\xC2\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x77"],
        ["\xC2\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x78"],
        ["\xC2\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\xC2\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\xC2\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\xC2\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\xC2\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],
        ["\xC2\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\xC3\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x21"],
        ["\xC3\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x22"],
        ["\xC3\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x23"],
        ["\xC3\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x24"],
        ["\xC3\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x25"],
        ["\xC3\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x26"],
        ["\xC3\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x27"],
        ["\xC3\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x28"],
        ["\xC3\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x29"],
        ["\xC3\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2A"],
        ["\xC3\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2B"],
        ["\xC3\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2C"],
        ["\xC3\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2D"],
        ["\xC3\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2E"],
        ["\xC3\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x2F"],
        ["\xC3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x30"],
        ["\xC3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x31"],
        ["\xC3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x32"],
        ["\xC3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x33"],
        ["\xC3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x34"],
        ["\xC3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x35"],
        ["\xC3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x36"],
        ["\xC3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x37"],
        ["\xC3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x38"],
        ["\xC3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x39"],
        ["\xC3\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3A"],
        ["\xC3\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3B"],
        ["\xC3\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3C"],
        ["\xC3\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3D"],
        ["\xC3\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3E"],
        ["\xC3\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x3F"],
        ["\xC3\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x40"],
        ["\xC3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\xC3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\xC3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\xC3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\xC3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\xC3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\xC3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\xC3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\xC3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\xC3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\xC3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\xC3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\xC3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\xC3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\xC3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\xC3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x50"],
        ["\xC3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\xC3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\xC3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\xC3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\xC3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\xC3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\xC3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\xC3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\xC3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\xC3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\xC3\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\xC3\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\xC3\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\xC3\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\xC3\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\xC3\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\xC3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\xC3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\xC3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\xC3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\xC3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\xC3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\xC3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\xC3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\xC3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\xC3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\xC3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\xC3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\xC3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\xC3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\xC3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\xC3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\xC3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\xC3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\xC3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\xC3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\xC3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\xC3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\xC3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\xC3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\xC3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\xC3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\xC3\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x7B"],
        ["\xC3\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\xC3\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\xC3\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\xC4\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x21"],
        ["\xC4\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x22"],
        ["\xC4\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x23"],
        ["\xC4\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x24"],
        ["\xC4\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x25"],
        ["\xC4\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x26"],
        ["\xC4\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x27"],
        ["\xC4\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x28"],
        ["\xC4\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x29"],
        ["\xC4\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2A"],
        ["\xC4\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2B"],
        ["\xC4\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2C"],
        ["\xC4\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2D"],
        ["\xC4\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2E"],
        ["\xC4\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x2F"],
        ["\xC4\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x30"],
        ["\xC4\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x31"],
        ["\xC4\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x32"],
        ["\xC4\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x33"],
        ["\xC4\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x34"],
        ["\xC4\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x35"],
        ["\xC4\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x36"],
        ["\xC4\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x37"],
        ["\xC4\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x38"],
        ["\xC4\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x39"],
        ["\xC4\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3A"],
        ["\xC4\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3B"],
        ["\xC4\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3C"],
        ["\xC4\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3D"],
        ["\xC4\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3E"],
        ["\xC4\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x3F"],
        ["\xC4\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x40"],
        ["\xC4\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x41"],
        ["\xC4\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\xC4\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\xC4\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\xC4\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\xC4\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\xC4\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\xC4\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\xC4\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\xC4\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],
        ["\xC4\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\xC4\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\x47\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xC4\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\xC4\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4F"],
        ["\xC4\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\xC4\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\xC4\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\xC4\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\xC4\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\xC4\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\xC4\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\xC4\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\xC4\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x58"],
        ["\xC4\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x59"],
        ["\xC4\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\xD4\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\xC4\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\xC4\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\xC4\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\xC4\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\xC4\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\xC4\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\xC4\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\xC4\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\xC4\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\xC4\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\xC4\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\xC4\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\xC4\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\xC4\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\xC4\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\xC4\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\xC4\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\xC4\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\xC4\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\xC4\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\xC4\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\xC4\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\xC4\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\xC4\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\xC4\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\xC4\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\xC4\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\xC4\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\xC4\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\xC4\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\xC4\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\xC4\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\xC4\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],
        ["\xC4\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\xC4\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\xC5\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x21"],
        ["\xC5\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x22"],
        ["\xC5\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x23"],
        ["\xC5\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x24"],
        ["\xC5\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x25"],
        ["\xC5\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x26"],
        ["\xC5\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x27"],
        ["\xC5\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x28"],
        ["\xC5\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x29"],
        ["\xC5\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2A"],
        ["\xC5\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2B"],
        ["\xC5\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2C"],
        ["\xC5\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2D"],
        ["\xC5\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2E"],
        ["\xC5\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x2F"],
        ["\xC5\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x30"],
        ["\xC5\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x31"],
        ["\xC5\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x32"],
        ["\xC5\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x33"],
        ["\xC5\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x34"],
        ["\xC5\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x35"],
        ["\x47\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xC5\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x37"],
        ["\xC5\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x38"],
        ["\xC5\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x39"],
        ["\xC5\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3A"],
        ["\xC5\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3B"],
        ["\xC5\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3C"],
        ["\xC5\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3D"],
        ["\xC5\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3E"],
        ["\x6C\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xC5\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x40"],
        ["\xC5\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\xC5\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\xC5\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\xC5\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\xC5\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\xC5\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\xC5\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\xC5\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\xC5\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\xC5\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\xC5\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\xC5\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\xC5\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\xC5\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\xC5\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\xC5\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\xC5\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\xC5\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\xC5\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\xC5\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\xC5\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\xC5\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\xE2\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\xC5\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\xC5\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\xC5\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\xC5\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\xC5\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\xC5\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\xC5\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\xC5\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\xC5\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\xC5\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\xC5\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\xC5\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\xC5\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\xC5\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\xC5\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\xC5\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\xC5\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\xC5\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\xC5\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\xC5\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\xC5\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\xC5\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\xDB\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\xC5\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\xC5\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\xC5\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\xC5\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\xDE\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x39"],
        ["\xC5\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\xC5\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\xC5\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\xC5\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\xC5\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\xC5\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\xC5\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\xC5\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\xC5\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\xC5\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\xC5\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\xC6\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x21"],
        ["\xC6\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x22"],
        ["\xC6\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x23"],
        ["\xC6\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x24"],
        ["\xC6\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x25"],
        ["\xC6\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x26"],
        ["\xC6\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x27"],
        ["\xC6\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x28"],
        ["\xC6\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x29"],
        ["\xC6\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2A"],
        ["\xC6\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2B"],
        ["\xC6\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2C"],
        ["\xC6\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2D"],
        ["\xC6\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2E"],
        ["\xC6\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x2F"],
        ["\xC6\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x30"],
        ["\xC6\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x31"],
        ["\xC6\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x32"],
        ["\xC6\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x33"],
        ["\xC6\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x34"],
        ["\xC6\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x35"],
        ["\xC6\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x36"],
        ["\xC6\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x37"],
        ["\xC6\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x38"],
        ["\xC6\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x39"],
        ["\xC6\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3A"],
        ["\xC6\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3B"],
        ["\xC6\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3C"],
        ["\xC6\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3D"],
        ["\xC6\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3E"],
        ["\xC6\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x3F"],
        ["\xC6\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x40"],
        ["\xC6\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\xC6\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\xC6\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\xC6\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\xC6\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\xC6\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\xC6\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\xC6\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\xC6\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\xC6\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\xC6\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\xC6\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\xC6\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\xC6\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\xC6\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\xC6\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\xC6\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\xC6\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\xC6\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\xC6\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\xC6\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\xC6\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\xC6\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\xC6\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\xC6\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\xC6\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\xC6\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\xC6\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\xC6\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\xC6\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\xC6\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\xC6\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\xC6\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\xC6\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\xC6\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\xC6\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\xC6\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\xC6\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\xC6\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\xC6\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\xC6\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\xC6\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\xC6\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\xC6\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\xC6\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\xC6\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\xC6\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\xC6\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\xC6\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\xC6\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\xC6\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\xC6\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\xC6\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\xED\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],
        ["\xC6\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\xC6\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\xC6\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\xC6\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\xC6\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\xC6\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\xC6\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\xC6\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\xC7\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x21"],
        ["\xC7\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x22"],
        ["\xC7\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x23"],
        ["\xC7\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x24"],
        ["\xC7\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x25"],
        ["\xC7\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x26"],
        ["\xC7\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x27"],
        ["\xC7\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x28"],
        ["\xC7\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x29"],
        ["\xC7\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2A"],
        ["\xC7\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2B"],
        ["\xC7\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2C"],
        ["\xC7\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2D"],
        ["\xC7\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2E"],
        ["\xC7\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x2F"],
        ["\xC7\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x30"],
        ["\xC7\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x31"],
        ["\xC7\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x32"],
        ["\xC7\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x33"],
        ["\xC7\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x34"],
        ["\xC7\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x35"],
        ["\xC7\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x36"],
        ["\xC7\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x37"],
        ["\xC7\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x38"],
        ["\xC7\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x39"],
        ["\xC7\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3A"],
        ["\xC7\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3B"],
        ["\xC7\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3C"],
        ["\xC7\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3D"],
        ["\xC7\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3E"],
        ["\xC7\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x3F"],
        ["\xC7\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x40"],
        ["\xC7\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\xC7\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\xC7\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\xC7\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\xC7\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\xC7\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\xC7\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\xC7\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\xC7\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\xC7\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\xC7\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\xC7\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\xC7\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\xC7\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\xC7\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\xC7\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\xC7\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\xC7\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\xC7\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\xC7\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\xC7\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\xC7\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\xC7\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\xC7\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\xC7\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\xC7\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\xC7\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\xC7\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\xC7\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\xC7\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\xC7\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\xC7\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\xC7\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\xC7\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\xC7\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\xC7\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\xC7\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\xC7\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\xC7\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\xEA\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x24"],
        ["\xC7\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\xC7\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\xC7\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\xC7\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\xC7\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\xC7\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\xC7\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\xC7\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\xC7\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\xC7\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\xC7\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\xC7\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\xC7\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\xC7\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\xC7\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\xC7\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\xC7\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\xC7\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\xC7\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\xC7\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\xC7\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\xC7\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\xC8\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x21"],
        ["\xC8\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x22"],
        ["\xC8\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x23"],
        ["\xC8\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x24"],
        ["\xC8\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x25"],
        ["\xC8\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x26"],
        ["\xC8\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x27"],
        ["\xC8\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x28"],
        ["\xC8\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x29"],
        ["\xC8\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2A"],
        ["\xC8\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2B"],
        ["\xC8\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2C"],
        ["\xC8\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2D"],
        ["\xC8\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2E"],
        ["\xC8\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x2F"],
        ["\xC8\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x30"],
        ["\xC8\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x31"],
        ["\xC8\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x32"],
        ["\xC8\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x33"],
        ["\xC8\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x34"],
        ["\xC8\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x35"],
        ["\xC8\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x36"],
        ["\xC8\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x37"],
        ["\xC8\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x38"],
        ["\xC8\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x39"],
        ["\xC8\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3A"],
        ["\xC8\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3B"],
        ["\xC8\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3C"],
        ["\xC8\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3D"],
        ["\xC8\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3E"],
        ["\xC8\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x3F"],
        ["\xC8\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x40"],
        ["\xC8\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\xC8\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\xC8\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\xC8\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\xC8\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\xC8\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\xC8\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\xC8\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\xC8\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\xC8\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\xC8\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\xC8\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\xC8\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\xC8\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\xC8\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\xC8\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\xC8\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\xC8\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\xC8\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\xC8\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\xC8\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\xC8\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\xC8\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\xC8\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\xC8\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\xC8\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\xC8\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\xC8\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\xC8\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\xC8\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\xC8\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\xC8\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\xC8\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\xC8\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\xC8\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\xC8\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\xC8\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\xC8\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\xC8\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\xC8\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\xC8\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\xC8\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\xC8\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\xC8\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\xC8\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\xC8\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\xC8\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\xC8\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\xC8\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\xC8\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\xC8\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\xC8\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\xC8\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\xC8\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\xC8\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\xC8\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\xC8\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\xC8\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\xC8\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\xC8\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\xC8\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\xC8\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\xC9\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x21"],
        ["\xC9\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x22"],
        ["\xC9\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x23"],
        ["\xC9\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x24"],
        ["\xC9\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x25"],
        ["\xC9\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x26"],
        ["\xC9\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x27"],
        ["\xC9\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x28"],
        ["\xC9\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x29"],
        ["\xC9\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2A"],
        ["\xC9\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2B"],
        ["\xC9\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2C"],
        ["\xC9\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2D"],
        ["\xC9\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2E"],
        ["\xC9\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x2F"],
        ["\xDB\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\xC9\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x31"],
        ["\xC9\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x32"],
        ["\xC9\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x33"],
        ["\xC9\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x34"],
        ["\xC9\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x35"],
        ["\xC9\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x36"],
        ["\xC9\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x37"],
        ["\xC9\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x38"],
        ["\xC9\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x39"],
        ["\xC9\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3A"],
        ["\xC9\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3B"],
        ["\xC9\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3C"],
        ["\xC9\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3D"],
        ["\xC9\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3E"],
        ["\xC9\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x3F"],
        ["\xC9\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x40"],
        ["\xC9\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\xC9\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\xC9\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\xC9\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\xC9\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\xC9\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\xC9\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\xC9\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\xC9\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\xC9\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\xC9\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\xC9\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\xC9\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\xC9\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\xC9\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\xC9\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\xC9\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\xC9\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\xC9\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\xC9\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\xC9\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\xC9\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\xC9\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\xC9\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\xC9\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\xC9\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\xC9\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\xC9\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\xC9\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\xC9\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\xC9\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\xC9\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\xC9\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\xC9\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\xC9\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\xC9\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\xC9\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\xC9\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\xC9\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\xC9\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\xC9\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\xC9\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\xC9\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\xC9\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\xC9\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\xC9\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\xC9\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\xC9\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\xC9\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\xC9\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\xC9\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\xC9\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\xC9\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\xC9\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\xC9\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\xC9\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\xC9\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\xC9\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\xC9\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\xC9\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\xC9\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\xC9\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\xCA\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x21"],
        ["\xCA\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x22"],
        ["\xCA\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x23"],
        ["\xCA\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x24"],
        ["\xCA\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x25"],
        ["\xCA\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x26"],
        ["\xCA\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x27"],
        ["\xCA\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x28"],
        ["\xCA\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x29"],
        ["\xCA\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2A"],
        ["\xCA\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2B"],
        ["\xCA\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2C"],
        ["\xCA\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2D"],
        ["\xCA\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2E"],
        ["\xCA\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x2F"],
        ["\xCA\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x30"],
        ["\xCA\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x31"],
        ["\xCA\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x32"],
        ["\xCA\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x33"],
        ["\xCA\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x34"],
        ["\xCA\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x35"],
        ["\xCA\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x36"],
        ["\xCA\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x37"],
        ["\xCA\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x38"],
        ["\xCA\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x39"],
        ["\xCA\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3A"],
        ["\xCA\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3B"],
        ["\xCA\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3C"],
        ["\xCA\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3D"],
        ["\xCA\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3E"],
        ["\xCA\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x3F"],
        ["\xCA\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x40"],
        ["\xCA\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\xCA\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\xCA\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\xCA\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\xCA\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\xCA\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\xCA\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\xCA\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\xCA\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\xCA\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\xCA\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\xCA\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\xCA\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\xCA\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\xCA\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\xCA\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\xCA\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\xCA\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\xCA\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\xCA\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\xCA\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\xCA\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\xCA\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\xCA\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\xCA\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\xCA\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\xCA\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\xCA\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\xCA\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\xCA\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\xCA\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\xCA\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\xCA\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\xCA\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\xCA\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\xCA\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\xCA\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\xCA\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\xCA\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\xCA\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\xCA\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\xCA\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\xCA\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\xCA\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\xCA\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\xCA\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\xCA\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\xCA\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\xCA\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\xCA\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\xCA\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\xCA\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\xCA\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\xCA\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\xCA\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\xCA\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\xCA\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\xCA\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\xCA\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\xCA\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\xCA\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\xCA\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\xCB\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x21"],
        ["\xCB\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x22"],
        ["\xCB\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x23"],
        ["\xCB\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x24"],
        ["\xCB\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x25"],
        ["\xCB\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x26"],
        ["\xCB\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x27"],
        ["\xCB\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x28"],
        ["\xCB\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x29"],
        ["\xCB\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2A"],
        ["\xCB\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2B"],
        ["\xCB\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2C"],
        ["\xCB\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2D"],
        ["\xCB\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2E"],
        ["\xCB\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x2F"],
        ["\xCB\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x30"],
        ["\xCB\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x31"],
        ["\xCB\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x32"],
        ["\xCB\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x33"],
        ["\xCB\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x34"],
        ["\xCB\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x35"],
        ["\xCB\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x36"],
        ["\xCB\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x37"],
        ["\xCB\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x38"],
        ["\xCB\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x39"],
        ["\xCB\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3A"],
        ["\xCB\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3B"],
        ["\xCB\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3C"],
        ["\xCB\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3D"],
        ["\xCB\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3E"],
        ["\xCB\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x3F"],
        ["\xCB\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x40"],
        ["\xCB\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\xCB\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\xCB\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\xCB\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\xCB\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\xCB\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\xCB\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\xCB\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\xCB\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\xCB\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\xCB\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\xCB\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\xCB\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\xCB\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\xCB\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\xCB\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\xCB\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\xCB\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\xCB\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\xCB\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\xCB\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\xCB\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\xCB\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\xCB\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\xCB\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\xCB\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\xCB\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\xCB\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\xCB\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\xCB\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\xCB\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\xCB\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\xCB\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\xCB\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\xCB\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\xCB\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\xCB\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\xCB\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\xCB\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\xCB\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\xCB\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\x54\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xCB\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\xCB\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\xCB\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\xCB\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\xCB\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\xCB\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\xCB\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\xCB\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\xCB\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\xCB\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\xCB\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\xCB\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\xCB\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\xCB\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\xD0\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\xCB\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\xCB\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\xCB\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\xCB\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\xCB\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\xCC\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x21"],
        ["\xCC\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x22"],
        ["\xCC\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x23"],
        ["\xCC\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x24"],
        ["\xCC\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x25"],
        ["\xCC\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x26"],
        ["\xCC\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x27"],
        ["\xCC\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x28"],
        ["\xCC\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x29"],
        ["\xCC\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2A"],
        ["\xCC\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2B"],
        ["\xCC\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2C"],
        ["\xCC\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2D"],
        ["\xCC\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2E"],
        ["\xCC\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x2F"],
        ["\xCC\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x30"],
        ["\xCC\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x31"],
        ["\xCC\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x32"],
        ["\xCC\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x33"],
        ["\xCC\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x34"],
        ["\xCC\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x35"],
        ["\xCC\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x36"],
        ["\xCC\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x37"],
        ["\xCC\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x38"],
        ["\xCC\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x39"],
        ["\xCC\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3A"],
        ["\xCC\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3B"],
        ["\xCC\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3C"],
        ["\xCC\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3D"],
        ["\xCC\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3E"],
        ["\xCC\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x3F"],
        ["\xCC\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x40"],
        ["\xCC\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\xCC\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\xCC\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\xCC\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\xCC\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\xCC\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\xCC\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\xCC\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\xCC\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\xCC\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\xCC\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\xCC\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x6F\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\xCC\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\xCC\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\xCC\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\xCC\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\xCC\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\xCC\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\xCC\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\xCC\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\xCC\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\xCC\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\xCC\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\xCC\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\xCC\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\xCC\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\xCC\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\xCC\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\xCC\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\xCC\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\xCC\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\xCC\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\xCC\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\xCC\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\xCC\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\xCC\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\xCC\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\xCC\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\xCC\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\xCC\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\xCC\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\xCC\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\xCC\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\xCC\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\xCC\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\xCC\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\xCC\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\xCC\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\xCC\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\xCC\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\xCC\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\xCC\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\xCC\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\xCC\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\xCC\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\xE9\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2E"],
        ["\xCC\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\xCC\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\xCC\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\xCC\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\xCC\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\xCD\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x21"],
        ["\xCD\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x22"],
        ["\xCD\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x23"],
        ["\xCD\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x24"],
        ["\xCD\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x25"],
        ["\xCD\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x26"],
        ["\xCD\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x27"],
        ["\xCD\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x28"],
        ["\xCD\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x29"],
        ["\xCD\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2A"],
        ["\xCD\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2B"],
        ["\xCD\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2C"],
        ["\xCD\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2D"],
        ["\xCD\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2E"],
        ["\xCD\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x2F"],
        ["\xCD\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x30"],
        ["\xCD\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x31"],
        ["\xCD\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x32"],
        ["\xCD\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x33"],
        ["\xCD\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x34"],
        ["\xCD\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x35"],
        ["\xCD\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x36"],
        ["\xCD\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x37"],
        ["\xCD\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x38"],
        ["\xCD\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x39"],
        ["\xCD\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3A"],
        ["\xCD\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3B"],
        ["\xCD\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3C"],
        ["\xCD\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3D"],
        ["\xCD\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3E"],
        ["\xCD\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x3F"],
        ["\xCD\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x40"],
        ["\xCD\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\xCD\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\xCD\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\xCD\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\xCD\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\xCD\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\xCD\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\xCD\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\xCD\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\xCD\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\xCD\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\xCD\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\xCD\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\xCD\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\xCD\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\xCD\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\xCD\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\xCD\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\xCD\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\xCD\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\xCD\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\xCD\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\xCD\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\xCD\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\xCD\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\x70\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xCD\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\xCD\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\xCD\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\xCD\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\xCD\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\xCD\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\xCD\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\xCD\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\xCD\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\xCD\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\xCD\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\xCD\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\xCD\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\xCD\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\xCD\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\xCD\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\xCD\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\xCD\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\xCD\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\xCD\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\xCD\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\xCD\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\xCD\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\xCD\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\xCD\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\xCD\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\xCD\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\xCD\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\xCD\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\xCD\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\xCD\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\xCD\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\xCD\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\xCD\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\xCD\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\xCD\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\xCE\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x21"],
        ["\xCE\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x22"],
        ["\xCE\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x23"],
        ["\xCE\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x24"],
        ["\xCE\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x25"],
        ["\xCE\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x26"],
        ["\xCE\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x27"],
        ["\xCE\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x28"],
        ["\xCE\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x29"],
        ["\xCE\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2A"],
        ["\xCE\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2B"],
        ["\xCE\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2C"],
        ["\xCE\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2D"],
        ["\xCE\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2E"],
        ["\xCE\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x2F"],
        ["\xCE\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x30"],
        ["\xCE\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x31"],
        ["\xCE\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x32"],
        ["\xCE\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x33"],
        ["\xCE\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x34"],
        ["\xCE\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x35"],
        ["\xCE\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x36"],
        ["\xCE\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x37"],
        ["\xCE\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x38"],
        ["\xCE\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x39"],
        ["\xCE\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3A"],
        ["\xCE\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3B"],
        ["\xCE\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3C"],
        ["\xCE\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3D"],
        ["\xCE\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3E"],
        ["\xCE\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x3F"],
        ["\xCE\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x40"],
        ["\xCE\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\xCE\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\xCE\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\xCE\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\xCE\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\xCE\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\xCE\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\xCE\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\xCE\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\xCE\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\xCE\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\xCE\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\xCE\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\xCE\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\xCE\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\xCE\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\xCE\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\xCE\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\xCE\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],
        ["\xCE\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\xCE\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\xCE\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\xCE\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\xCE\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\xCE\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\xCE\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\xCE\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\xCE\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\xCE\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\xCE\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\xCE\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\xCE\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\xCE\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\xCE\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\xCE\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\xCE\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\xCE\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\xCE\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\xCE\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\xCE\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\xCE\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\xCE\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\xCE\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\xCE\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\xCE\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\xCE\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\xCE\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\xCE\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\xCE\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\xCE\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\xCE\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\xCE\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\xCE\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\xCE\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\xCE\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\xCE\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\xCE\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\xCE\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\xCE\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\xCE\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\xCE\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\xCE\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\xCF\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x21"],
        ["\xCF\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x22"],
        ["\xCF\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x23"],
        ["\xCF\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x24"],
        ["\xCF\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x25"],
        ["\xCF\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x26"],
        ["\xCF\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x27"],
        ["\xCF\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x28"],
        ["\xCF\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x29"],
        ["\xCF\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2A"],
        ["\xCF\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2B"],
        ["\xCF\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2C"],
        ["\xCF\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2D"],
        ["\xCF\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2E"],
        ["\xCF\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x2F"],
        ["\xCF\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x30"],
        ["\xCF\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x31"],
        ["\xCF\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x32"],
        ["\xCF\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x33"],
        ["\xCF\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x34"],
        ["\xCF\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x35"],
        ["\xE4\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\xCF\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x37"],
        ["\xCF\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x38"],
        ["\xCF\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x39"],
        ["\xCF\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3A"],
        ["\xCF\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3B"],
        ["\xCF\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3C"],
        ["\xCF\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3D"],
        ["\xCF\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3E"],
        ["\xCF\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x3F"],
        ["\xCF\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x40"],
        ["\xCF\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\xCF\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\xCF\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\xCF\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\xCF\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\xCF\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\xCF\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\xCF\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\xCF\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\xCF\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\xCF\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\xCF\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\xCF\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\xCF\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\xCF\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\xCF\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\xCF\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\xCF\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\xCF\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\xD0\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x21"],
        ["\xD0\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x22"],
        ["\xD0\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x23"],
        ["\xD0\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x24"],
        ["\xD0\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x25"],
        ["\xD0\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x26"],
        ["\xD0\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x27"],
        ["\xD0\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x28"],
        ["\xD0\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x29"],
        ["\xD0\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2A"],
        ["\xD0\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2B"],
        ["\xD0\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2C"],
        ["\xD0\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2D"],
        ["\xD0\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2E"],
        ["\xD0\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x2F"],
        ["\xD0\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x30"],
        ["\xD0\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x31"],
        ["\xD0\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x32"],
        ["\xD0\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x33"],
        ["\xD0\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x34"],
        ["\xD0\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x35"],
        ["\xD0\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x36"],
        ["\xD0\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x37"],
        ["\xD0\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x38"],
        ["\xD0\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x39"],
        ["\xD0\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3A"],
        ["\xD0\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3B"],
        ["\xD0\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3C"],
        ["\xD0\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3D"],
        ["\xD0\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3E"],
        ["\xD0\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x3F"],
        ["\xD0\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x40"],
        ["\xD0\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\xD0\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\xD0\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\xD0\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\xD0\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\xD0\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\xD0\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\xD0\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\xD0\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\xD0\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\xD0\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\xD0\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\xD0\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\xD0\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\xD0\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\xD0\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\xD0\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\xD0\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\xD0\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\xD0\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\xD0\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\xCB\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\xD0\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\xD0\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\xD0\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\xD0\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\xD0\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\xD0\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\xD0\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\xD0\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\xD0\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\xD0\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\xD0\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\xD0\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\xD0\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\xD0\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\xD0\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\xD0\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\xD0\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\xD0\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\xD0\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\xD0\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\xD0\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\xD0\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\xD0\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\xD0\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\xD0\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\xD0\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\xD0\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\xD0\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\xD0\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\xD0\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\xD0\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\xD0\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\xD0\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\xD0\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\xD0\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\xD0\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\xD0\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\xD0\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\xD0\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\xD0\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\xD1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x21"],
        ["\xD1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x22"],
        ["\xD1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x23"],
        ["\xD1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x24"],
        ["\xD1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x25"],
        ["\xD1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x26"],
        ["\xD1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x27"],
        ["\xD1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x28"],
        ["\xD1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x29"],
        ["\xD1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2A"],
        ["\xD1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2B"],
        ["\xD1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2C"],
        ["\xD1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2D"],
        ["\xD1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2E"],
        ["\xD1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x2F"],
        ["\xD1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x30"],
        ["\xD1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x31"],
        ["\xD1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x32"],
        ["\xD1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x33"],
        ["\xD1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x34"],
        ["\xD1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x35"],
        ["\xD1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x36"],
        ["\xD1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x37"],
        ["\xD1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x38"],
        ["\xD1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x39"],
        ["\xD1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3A"],
        ["\xD1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3B"],
        ["\xD1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3C"],
        ["\xD1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3D"],
        ["\xD1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3E"],
        ["\xD1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x3F"],
        ["\xD1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x40"],
        ["\xD1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\xD1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\xD1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\xD1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\xD1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\xD1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\xD1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\xD1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\xD1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\xD1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\xD1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\xD1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\xD1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\xD1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\xD1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\xD1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\xD1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\xD1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\xD1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\xD1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\xD1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\xD1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\xD1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\xD1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\xD1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\xD1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\xD1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\xD1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\xD1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\xD1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\xD1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\xD1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\xD1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\xD1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\xD1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\xD1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\xD1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\xD1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\xD1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\xD1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\xD1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\xD1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\xD1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\xD1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\xD1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\xD1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\xD1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\xD1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\xD1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\xD1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\xD1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\xD1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\xD1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\xD1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\xD1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\xD1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\xD1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\xD1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\xD1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\xD1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\xD1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\xD1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\xD2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x21"],
        ["\xD2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x22"],
        ["\xD2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x23"],
        ["\xD2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x24"],
        ["\xD2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x25"],
        ["\xD2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x26"],
        ["\xD2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x27"],
        ["\xD2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x28"],
        ["\xD2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x29"],
        ["\xD2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2A"],
        ["\xD2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2B"],
        ["\xD2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2C"],
        ["\xD2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2D"],
        ["\xD2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2E"],
        ["\xD2\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x2F"],
        ["\xD2\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x30"],
        ["\xD2\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x31"],
        ["\xD2\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x32"],
        ["\xD2\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x33"],
        ["\xD2\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x34"],
        ["\xD2\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x35"],
        ["\xD2\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x36"],
        ["\xD2\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x37"],
        ["\xD2\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x38"],
        ["\xD2\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x39"],
        ["\xD2\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3A"],
        ["\xD2\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3B"],
        ["\xD2\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3C"],
        ["\xD2\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3D"],
        ["\xD2\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3E"],
        ["\xD2\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x3F"],
        ["\xD2\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x40"],
        ["\xD2\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\xD2\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\xD2\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\xD2\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\xD2\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\xD2\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\xD2\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\xD2\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\xD2\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\xD2\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\xD2\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],
        ["\xD2\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\xD2\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\xD2\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\xD2\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\xD2\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\xD2\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\xD2\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\xD2\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\xD2\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\xD2\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\xD2\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\xD2\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\xD2\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\xD2\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\xD2\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\xD2\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\xD2\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\xD2\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\xD2\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\xD2\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\xD2\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\xD2\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\xD2\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\xD2\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\xD2\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\xD2\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\xD2\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\xD2\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\xD2\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\xD2\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\xD2\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\xD2\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\xD2\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\xD2\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\xD2\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\xD2\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\xD2\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\xD2\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\xD2\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\xD2\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\xD2\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\xD2\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\xD2\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\xD2\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\xD2\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\xD2\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\xD2\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\xD2\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],
        ["\xD2\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\xD2\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\xD2\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\xD3\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x21"],
        ["\xD3\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x22"],
        ["\xD3\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x23"],
        ["\xD3\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x24"],
        ["\xD3\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x25"],
        ["\xD3\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x26"],
        ["\xD3\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x27"],
        ["\xD3\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x28"],
        ["\xD3\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x29"],
        ["\xD3\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2A"],
        ["\xD3\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2B"],
        ["\xD3\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2C"],
        ["\xD3\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2D"],
        ["\xD3\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2E"],
        ["\xD3\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x2F"],
        ["\xD3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x30"],
        ["\xD3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x31"],
        ["\xD3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x32"],
        ["\xD3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x33"],
        ["\xD3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x34"],
        ["\xD3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x35"],
        ["\xD3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x36"],
        ["\xD3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x37"],
        ["\xD3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x38"],
        ["\xD3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x39"],
        ["\xD3\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3A"],
        ["\xD3\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3B"],
        ["\xD3\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3C"],
        ["\xD3\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3D"],
        ["\xD3\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3E"],
        ["\xD3\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x3F"],
        ["\xD3\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x40"],
        ["\xD3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\xD3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],
        ["\xD3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\xD3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\xD3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\xD3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\xD3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\xD3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\xD3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\xD3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\xD3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\xD3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\xD3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\xD3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\xD3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\xD3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\xD3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\xD3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\xD3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\xD3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\xD3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\xD3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\xD3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\xD3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\xD3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\xD3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\xD3\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\xD3\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\xD3\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\xD3\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\xD3\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\xD3\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\xD3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\xD3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\xD3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\xD3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\xD3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\xD3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\xD3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\xD3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\xD3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\xD3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\xD3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\xD3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\xD3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\xD3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\xD3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\xD3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\xD3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\xD3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\xD3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\xD3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\xD3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\xD3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\xD3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\xD3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\xD3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\xD3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\xD3\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\xD3\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\xD3\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\xD3\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\xD4\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x21"],
        ["\xD4\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x22"],
        ["\xD4\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x23"],
        ["\xD4\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x24"],
        ["\xD4\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x25"],
        ["\xD4\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x26"],
        ["\xD4\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x27"],
        ["\xD4\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x28"],
        ["\xD4\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x29"],
        ["\xD4\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2A"],
        ["\xD4\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2B"],
        ["\xD4\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2C"],
        ["\xD4\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2D"],
        ["\xD4\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2E"],
        ["\xD4\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x2F"],
        ["\xD4\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x30"],
        ["\xD4\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x31"],
        ["\xD4\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x32"],
        ["\xD4\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x33"],
        ["\xD4\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x34"],
        ["\xD4\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x35"],
        ["\xD4\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x36"],
        ["\xD4\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x37"],
        ["\xD4\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x38"],
        ["\xD4\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x39"],
        ["\xD4\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3A"],
        ["\xD4\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3B"],
        ["\xD4\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3C"],
        ["\xD4\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3D"],
        ["\xD4\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3E"],
        ["\xD4\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x3F"],
        ["\xD4\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x40"],
        ["\xD4\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\xD4\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\xD4\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\xD4\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\xD4\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\xD4\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\xD4\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\xD4\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\xD4\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\xD4\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\xD4\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\xD4\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\xD4\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\xD4\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\xD4\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\xD4\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\xD4\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\xD4\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\xD4\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\xD4\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\xD4\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\xD4\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\xD4\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\xD4\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\xD4\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\xD4\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\xD4\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\xD4\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\xD4\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\xD4\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\xD4\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\xD4\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\xD4\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\xD4\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\xD4\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\xC4\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\xD4\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\xD4\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\xD4\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\xD4\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\xD4\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\xD4\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\xD4\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\xD4\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\xD4\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\xD4\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\xD4\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\xD4\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\xD4\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\xD4\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\xD4\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\xD4\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\xD4\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\xD4\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\xD4\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\xD4\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\xD4\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\xD4\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\xD4\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\xD4\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\xD4\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\xD4\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\xD5\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x21"],
        ["\xD5\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x22"],
        ["\xD5\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x23"],
        ["\xD5\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x24"],
        ["\xD5\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x25"],
        ["\xD5\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x26"],
        ["\xD5\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x27"],
        ["\xD5\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x28"],
        ["\xD5\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x29"],
        ["\xD5\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2A"],
        ["\xD5\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2B"],
        ["\xD5\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2C"],
        ["\xD5\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2D"],
        ["\xD5\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2E"],
        ["\xD5\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x2F"],
        ["\xD5\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x30"],
        ["\xD5\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x31"],
        ["\xD5\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x32"],
        ["\xD5\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x33"],
        ["\xD5\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x34"],
        ["\xD5\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x35"],
        ["\xD5\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x36"],
        ["\xD5\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x37"],
        ["\xD5\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x38"],
        ["\xD5\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x39"],
        ["\xD5\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3A"],
        ["\xD5\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3B"],
        ["\xD5\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3C"],
        ["\xD5\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3D"],
        ["\xD5\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3E"],
        ["\xD5\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x3F"],
        ["\xD5\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x40"],
        ["\xD5\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\xD5\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\xD5\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\xD5\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\xD5\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\xD5\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\xD5\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\xD5\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\xD5\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\xD5\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\xD5\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\xD5\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\xD5\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\xD5\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\xD5\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\xD5\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\xD5\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],
        ["\xD5\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\xD5\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\xD5\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\xD5\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\xD5\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\xD5\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\xD5\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\xD5\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\xD5\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\xD5\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\xD5\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\xD5\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\xD5\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\xD5\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\xD5\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\xD5\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\xD5\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\xD5\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\xD5\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\xD5\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\xD5\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\xD5\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\xD5\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\xD5\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\xD5\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\xD5\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\xD5\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\xD5\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\xD5\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\xD5\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\xD5\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\xD5\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\xD5\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\xD5\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\xD5\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\xD5\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\xD5\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\xD5\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\xD5\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\xD5\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\xD5\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\xD5\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\xD5\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\xD5\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\xD5\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\xD6\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x21"],
        ["\xD6\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x22"],
        ["\xD6\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x23"],
        ["\xD6\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x24"],
        ["\xD6\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x25"],
        ["\xD6\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x26"],
        ["\xD6\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x27"],
        ["\xD6\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x28"],
        ["\xD6\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x29"],
        ["\xD6\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2A"],
        ["\xD6\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2B"],
        ["\xD6\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2C"],
        ["\xD6\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2D"],
        ["\xD6\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2E"],
        ["\xD6\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x2F"],
        ["\xD6\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x30"],
        ["\xD6\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x31"],
        ["\xD6\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x32"],
        ["\xD6\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x33"],
        ["\xD6\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x34"],
        ["\xD6\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x35"],
        ["\xD6\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x36"],
        ["\xD6\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x37"],
        ["\xD6\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x38"],
        ["\xD6\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x39"],
        ["\xD6\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3A"],
        ["\xD6\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3B"],
        ["\xD6\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3C"],
        ["\xD6\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3D"],
        ["\xD6\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3E"],
        ["\xD6\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x3F"],
        ["\xD6\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x40"],
        ["\xD6\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\xD6\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\xD6\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\xD6\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],
        ["\xD6\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\xD6\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\xD6\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\xD6\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\xD6\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\xD6\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\xD6\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\xD6\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\xD6\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\xD6\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\xD6\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\xD6\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\xD6\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\xD6\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\xD6\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\xD6\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\xD6\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\xD6\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\xD6\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\xD6\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\xD6\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\xD6\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\xD6\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\xD6\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\xD6\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],
        ["\xD6\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\xD6\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\xD6\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\xD6\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\xD6\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x62"],
        ["\xD6\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\xD6\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\xD6\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],
        ["\xD6\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],
        ["\xD6\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\xD6\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\xD6\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\xD6\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6A"],
        ["\xD6\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\xD6\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\xD6\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\xD6\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],
        ["\xD6\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\xD6\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],
        ["\xD6\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],
        ["\xD6\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\xD6\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\xD6\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],
        ["\xD6\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\xD6\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\xD6\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\xD6\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\xD6\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\xD6\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\xD6\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],
        ["\xD6\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\xD6\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\xD6\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\xD7\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x21"],
        ["\xD7\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x22"],
        ["\xD7\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x23"],
        ["\xD7\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x24"],
        ["\xD7\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x25"],
        ["\xD7\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x26"],
        ["\xD7\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x27"],
        ["\xD7\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x28"],
        ["\xD7\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x29"],
        ["\xD7\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2A"],
        ["\xD7\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2B"],
        ["\xD7\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2C"],
        ["\xD7\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2D"],
        ["\xD7\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2E"],
        ["\xD7\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x2F"],
        ["\xD7\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x30"],
        ["\xD7\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x31"],
        ["\xD7\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x32"],
        ["\xD7\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x33"],
        ["\xD7\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x34"],
        ["\xD7\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x35"],
        ["\xD7\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x36"],
        ["\xD7\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x37"],
        ["\xD7\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x38"],
        ["\xD7\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x39"],
        ["\xD7\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3A"],
        ["\xD7\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3C"],
        ["\xD7\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3D"],
        ["\xD7\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3E"],
        ["\xD7\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3F"],
        ["\xD7\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x40"],
        ["\xD7\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\xD7\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\xD7\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\xD7\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\xD7\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\xD7\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\xD7\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\xD7\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\xD7\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\xD7\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\xD7\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\xD7\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\xD7\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\xD7\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\xD7\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\xD7\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\xD7\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\xD7\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\xD7\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\xD7\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\xD7\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\xD7\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x56"],
        ["\xD7\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\xD7\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],
        ["\xD7\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\xD7\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\xD7\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\xD7\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\xD7\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\xD7\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\xD7\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\xD7\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\xD7\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\xD7\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\xD7\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\xD7\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\xD7\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\xD7\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\xD7\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\xD7\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\xD7\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\xD7\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\xD7\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\xD7\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\xD7\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\xD7\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\xD7\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\xD7\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\xD7\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\xD7\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\xD7\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\xD7\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\xD7\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\xD7\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\xD7\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\xD7\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\xD7\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\xD7\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\xD7\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\xD7\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\xD7\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\xD7\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\xD8\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x21"],
        ["\xD8\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x22"],
        ["\xD8\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x23"],
        ["\xD8\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x24"],
        ["\xD8\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x25"],
        ["\xD8\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x26"],
        ["\xD8\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x27"],
        ["\xD8\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x28"],
        ["\xD8\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x29"],
        ["\xD8\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2A"],
        ["\xD8\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2B"],
        ["\xD8\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2C"],
        ["\xD8\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2D"],
        ["\xD8\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2E"],
        ["\xD8\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x2F"],
        ["\xD8\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x30"],
        ["\xD8\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x31"],
        ["\xD8\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x32"],
        ["\xD8\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x33"],
        ["\xD8\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x34"],
        ["\xD8\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x35"],
        ["\xD8\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x36"],
        ["\xD8\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x37"],
        ["\xD8\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x38"],
        ["\xD8\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x39"],
        ["\xD8\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3A"],
        ["\xD8\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3B"],
        ["\xD8\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3C"],
        ["\xD8\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3D"],
        ["\xD8\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3E"],
        ["\xD8\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x3F"],
        ["\xD8\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x40"],
        ["\xD8\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\xD8\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\xD8\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\xD8\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\xD8\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\xD8\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\xD8\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\xD8\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\xD8\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\xD8\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\xD8\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\xD8\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\xD8\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\xD8\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\xD8\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\xD8\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\xD8\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\xD8\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\xD8\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\xD8\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\xD8\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\xD8\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\xD8\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\xD8\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\xD8\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\xD8\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\xD8\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\xD8\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\xD8\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\xD8\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\xD8\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\xD8\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x60"],
        ["\xD8\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\xD8\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\xD8\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x63"],
        ["\xD8\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\xD8\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\xD8\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\xD8\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\xD8\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\xD8\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\xD8\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\xD8\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\xD8\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],
        ["\xD8\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\xD8\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\xD8\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\xD8\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],
        ["\xD8\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\xD8\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\xD8\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],
        ["\xD8\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\xD8\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\xD8\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\xD8\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],
        ["\xD8\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\xD8\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\xD8\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\xD8\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\xD8\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\xD8\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\xD8\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\xD9\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x21"],
        ["\xD9\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x22"],
        ["\xD9\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x23"],
        ["\xD9\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x24"],
        ["\xD9\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x25"],
        ["\xD9\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x26"],
        ["\xD9\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x27"],
        ["\xD9\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x28"],
        ["\xD9\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x29"],
        ["\xD9\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2A"],
        ["\xD9\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2B"],
        ["\xD9\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2C"],
        ["\xD9\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2D"],
        ["\xD9\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2E"],
        ["\xD9\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x2F"],
        ["\xD9\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x30"],
        ["\xD9\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x31"],
        ["\xD9\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x32"],
        ["\xD9\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x33"],
        ["\xD9\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x34"],
        ["\xD9\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x35"],
        ["\xD9\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x36"],
        ["\xD9\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x37"],
        ["\xD9\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x38"],
        ["\xD9\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x39"],
        ["\xD9\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3A"],
        ["\xD9\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3B"],
        ["\xD9\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3C"],
        ["\xD9\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3D"],
        ["\xD9\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3E"],
        ["\xD9\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x3F"],
        ["\xD9\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x40"],
        ["\xD9\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\xD9\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],
        ["\xD9\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\xD9\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],
        ["\xD9\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\xD9\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\xD9\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\xD9\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\xD9\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\xD9\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\xD9\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\xD9\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\xD9\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\xD9\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\xD9\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\xD9\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\xD9\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],
        ["\xD9\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\xD9\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\xD9\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\xD9\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\xD9\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\xD9\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\xD9\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\xD9\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\xD9\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\xD9\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\xD9\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\xD9\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\xD9\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\xD9\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\xD9\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\xD9\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\xD9\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\xD9\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\xD9\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\xD9\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\xD9\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\xD9\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\xD9\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\xD9\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\xD9\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\xD9\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\xD9\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\xD9\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\xD9\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\xD9\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\xD9\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\xD9\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\xD9\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\xD9\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\xD9\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\xD9\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\xD9\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\xD9\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\xB3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x49"],
        ["\xD9\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\xD9\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\xD9\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\xD9\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\xD9\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\xD9\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\xDA\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x21"],
        ["\xDA\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x22"],
        ["\xDA\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x23"],
        ["\xDA\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x24"],
        ["\xDA\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x25"],
        ["\xDA\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x26"],
        ["\xDA\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x27"],
        ["\xDA\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x28"],
        ["\xDA\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x29"],
        ["\xDA\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2A"],
        ["\xDA\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2B"],
        ["\xDA\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2C"],
        ["\xDA\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2D"],
        ["\xDA\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2E"],
        ["\xDA\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x2F"],
        ["\xDA\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x30"],
        ["\xDA\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x31"],
        ["\xDA\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x32"],
        ["\xDA\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x33"],
        ["\xDA\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x34"],
        ["\xDA\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x35"],
        ["\xDA\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x36"],
        ["\xDA\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x37"],
        ["\xDA\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x38"],
        ["\xDA\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x39"],
        ["\xDA\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3A"],
        ["\xDA\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3B"],
        ["\xDA\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3C"],
        ["\xDA\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3D"],
        ["\xDA\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3E"],
        ["\xDA\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x3F"],
        ["\xDA\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x40"],
        ["\xDA\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\xDA\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\xDA\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\xDA\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x44"],
        ["\xDA\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\xDA\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\xDA\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\xDA\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\xDA\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\xDA\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\xDA\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\xDA\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\xDA\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\xDA\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\xDA\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\xDA\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\xDA\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x51"],
        ["\xDA\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\xDA\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\xDA\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\xDA\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\xDA\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\xDA\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\xDA\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\xDA\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\xDA\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\xDA\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\xDA\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\xDA\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\xDA\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\xDA\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\xDA\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\xDA\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\xDA\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\xDA\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\xDA\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\xDA\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\xDA\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\xDA\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\xDA\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\xDA\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\xDA\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\xDA\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\xDA\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\xDA\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\xDA\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\xDA\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\xDA\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\xDA\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\xDA\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\xDA\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\xDA\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\xDA\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\xDA\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\xDA\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\xDA\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\xDA\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\xDA\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\xDA\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\xDA\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\xDA\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\xDA\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\xDB\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x21"],
        ["\xDB\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x22"],
        ["\xDB\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x23"],
        ["\xDB\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x24"],
        ["\xDB\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x25"],
        ["\xDB\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x26"],
        ["\xDB\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x27"],
        ["\xDB\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x28"],
        ["\xDB\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x29"],
        ["\xDB\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2A"],
        ["\xDB\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2B"],
        ["\xDB\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2C"],
        ["\xDB\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2D"],
        ["\xDB\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2E"],
        ["\xDB\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x2F"],
        ["\xDB\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x30"],
        ["\xDB\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x31"],
        ["\xDB\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x32"],
        ["\xDB\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x33"],
        ["\xDB\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x34"],
        ["\xDB\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x35"],
        ["\xDB\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x36"],
        ["\xDB\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x37"],
        ["\xDB\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x38"],
        ["\xDB\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x39"],
        ["\xDB\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3A"],
        ["\xDB\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3B"],
        ["\xDB\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3C"],
        ["\xDB\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3D"],
        ["\xDB\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3E"],
        ["\xDB\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x3F"],
        ["\xDB\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x40"],
        ["\xDB\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\xDB\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\xDB\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\xDB\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\xDB\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\xDB\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\xDB\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\xDB\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\xDB\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\xDB\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\xDB\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\xDB\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\xDB\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\xDB\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\xDB\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\xDB\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\xDB\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\xDB\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\xDB\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],
        ["\xDB\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],
        ["\xDB\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\xDB\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\xDB\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\xC9\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x49\x30"],
        ["\xDB\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\xDB\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\xDB\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\xDB\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\xDB\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\xDB\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\xDB\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\xDB\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\xDB\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\xDB\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\xDB\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\xDB\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\xDB\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\xDB\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\xDB\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\xDB\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\xDB\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\xDB\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\xDB\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\xDB\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\xC5\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\xDB\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\xDB\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\xDB\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\xDB\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\xDB\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\xDB\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\xDB\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\xDB\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\xDB\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\xDB\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\xDB\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\xDB\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\xDB\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\xDB\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\xDB\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\xDB\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\xDB\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\xDC\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x21"],
        ["\xDC\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x22"],
        ["\xDC\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x23"],
        ["\xDC\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x24"],
        ["\xDC\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x25"],
        ["\xDC\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x26"],
        ["\xDC\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x27"],
        ["\xDC\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x28"],
        ["\xDC\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x29"],
        ["\xDC\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2A"],
        ["\xDC\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2B"],
        ["\xDC\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2C"],
        ["\xDC\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2D"],
        ["\xDC\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2E"],
        ["\xDC\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x2F"],
        ["\xDC\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x30"],
        ["\xDC\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x31"],
        ["\xDC\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x32"],
        ["\xDC\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x33"],
        ["\xDC\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x34"],
        ["\xDC\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x35"],
        ["\xDC\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x36"],
        ["\xDC\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x37"],
        ["\xDC\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x38"],
        ["\xDC\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x39"],
        ["\xDC\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3A"],
        ["\xDC\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3B"],
        ["\xDC\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3C"],
        ["\xDC\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3D"],
        ["\xDC\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3E"],
        ["\xDC\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x3F"],
        ["\xDC\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x40"],
        ["\xDC\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\xDC\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\xDC\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\xDC\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\xDC\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\xDC\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\xDC\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\xDC\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\xDC\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\xDC\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\xDC\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\xDC\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\xDC\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\xDC\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\xDC\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\xDC\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\xDC\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\xDC\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\xDC\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\xDC\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\xDC\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\xDC\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\xDC\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\xDC\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\xDC\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\xDC\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\xDC\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\xDC\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\xDC\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\xDC\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\xDC\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],
        ["\xDC\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\xDC\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\xDC\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\xDC\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\xDC\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\xDC\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\xDC\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],
        ["\xDC\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\xDC\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\xDC\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\xDC\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\xDC\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\xDC\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\xDC\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\xDC\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],
        ["\xDC\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\xDC\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\xDC\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\xDC\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\xDC\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\xDC\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\xDC\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\xDC\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\xDC\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\xDC\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],
        ["\xDC\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],
        ["\xDC\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\xDC\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\xDC\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\xDC\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\xDC\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\xDD\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x21"],
        ["\xDD\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x22"],
        ["\xDD\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x23"],
        ["\xDD\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x24"],
        ["\xDD\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x25"],
        ["\xDD\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x26"],
        ["\xDD\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x27"],
        ["\xDD\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x28"],
        ["\xDD\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x29"],
        ["\xDD\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2A"],
        ["\xDD\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2B"],
        ["\xDD\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2C"],
        ["\xDD\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2D"],
        ["\xDD\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2E"],
        ["\xDD\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x2F"],
        ["\xDD\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x30"],
        ["\xDD\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x31"],
        ["\xDD\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x32"],
        ["\xDD\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x33"],
        ["\xDD\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x34"],
        ["\xDD\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x35"],
        ["\xDD\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x36"],
        ["\xDD\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x37"],
        ["\xDD\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x38"],
        ["\xDD\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x39"],
        ["\xDD\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3A"],
        ["\xDD\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3B"],
        ["\xDD\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3C"],
        ["\xDD\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3D"],
        ["\xDD\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3E"],
        ["\xDD\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x3F"],
        ["\xDD\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x40"],
        ["\xDD\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\xDD\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\xDD\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\xDD\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\xDD\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\xDD\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\xDD\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\xDD\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\xDD\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\xDD\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\xDD\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\xDD\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\xDD\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\xDD\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],
        ["\xDD\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\xDD\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\xDD\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\xDD\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\xDD\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\xDD\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\xDD\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\xDD\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\xDD\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\xDD\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],
        ["\xDD\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\xDD\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\xDD\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\xDD\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\xDD\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\xDD\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\xDD\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\xDD\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],
        ["\xDD\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\xDD\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x62"],
        ["\xDD\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\xDD\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\xDD\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\xDD\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\xDD\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\xDD\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\xDD\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\xDD\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\xDD\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6B"],
        ["\xDD\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\xDD\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\xDD\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\xDD\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\xDD\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\xDD\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\xDD\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],
        ["\xDD\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\xDD\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],
        ["\xDD\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\xDD\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\xDD\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\xDD\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\xDD\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\xDD\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x7A"],
        ["\xDD\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\xDD\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\xDD\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\xDD\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\xDE\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x21"],
        ["\xDE\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x22"],
        ["\xDE\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x23"],
        ["\xDE\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x24"],
        ["\xDE\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x25"],
        ["\xDE\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x26"],
        ["\xDE\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x27"],
        ["\xDE\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x28"],
        ["\xDE\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x29"],
        ["\xDE\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2A"],
        ["\xDE\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2B"],
        ["\xDE\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2C"],
        ["\xDE\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2D"],
        ["\xDE\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2E"],
        ["\xDE\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x2F"],
        ["\xDE\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x30"],
        ["\xDE\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x31"],
        ["\xDE\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x32"],
        ["\xDE\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x33"],
        ["\xDE\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x34"],
        ["\xDE\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x35"],
        ["\xDE\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x36"],
        ["\xDE\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x37"],
        ["\xDE\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x38"],
        ["\xC5\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\xDE\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3A"],
        ["\xDE\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3B"],
        ["\xDE\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3C"],
        ["\xDE\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3D"],
        ["\xDE\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3E"],
        ["\xDE\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x3F"],
        ["\xDE\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x40"],
        ["\xDE\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\xDE\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\xDE\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\xDE\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\xDE\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\xDE\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\xDE\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\xDE\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\xDE\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],
        ["\xDE\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\xDE\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\xDE\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\xDE\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\xDE\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\xDE\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\xDE\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\xDE\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\xDE\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\xDE\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\xDE\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\xDE\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\xDE\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\xDE\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\xDE\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\xDE\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\xDE\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\xDE\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\xDE\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\xDE\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\xDE\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\xDE\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\xDE\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\xDE\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\xDE\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\xDE\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\xDE\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\xDE\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\xDE\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\xDE\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\xDE\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\xDE\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\xDE\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\xDE\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\xDE\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\xDE\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\xDE\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\xDE\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\xDE\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\xDE\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\xDE\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\xDE\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\xDE\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\xB4\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x43"],
        ["\xDE\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\xDE\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\xDE\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\xDE\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\xDE\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\xDE\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\xDE\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\xDE\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\xDE\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\xDF\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x21"],
        ["\xDF\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x22"],
        ["\xDF\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x23"],
        ["\xDF\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x24"],
        ["\xDF\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x25"],
        ["\xDF\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x26"],
        ["\xDF\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x27"],
        ["\xDF\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x28"],
        ["\xDF\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x29"],
        ["\xDF\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2A"],
        ["\xDF\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2B"],
        ["\xDF\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2C"],
        ["\xDF\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2D"],
        ["\xDF\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2E"],
        ["\xDF\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x2F"],
        ["\xDF\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x30"],
        ["\xDF\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x31"],
        ["\xDF\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x32"],
        ["\xDF\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x33"],
        ["\xDF\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x34"],
        ["\xDF\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x35"],
        ["\xDF\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x36"],
        ["\xDF\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x37"],
        ["\xDF\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x38"],
        ["\xDF\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x39"],
        ["\xDF\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3A"],
        ["\xDF\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3B"],
        ["\xDF\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3C"],
        ["\xDF\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3D"],
        ["\xDF\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3E"],
        ["\xDF\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x3F"],
        ["\xDF\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x40"],
        ["\xDF\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\xDF\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\xDF\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\xDF\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\xDF\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\xDF\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\xDF\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\xDF\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\xDF\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\xDF\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\xDF\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\xDF\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\xDF\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\xDF\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\xDF\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\xDF\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\xDF\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\xDF\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\xDF\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\xDF\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\xDF\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\xDF\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\xDF\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\xDF\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\xDF\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\xDF\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\xDF\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\xDF\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\xDF\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\xDF\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\xDF\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\xDF\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\xDF\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\xDF\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\xDF\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\xDF\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\xDF\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\xDF\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\xDF\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\xDF\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\xDF\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\xDF\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\xDF\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\xDF\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\xDF\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\xDF\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\xDF\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\xDF\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\xDF\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\xDF\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\xDF\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\xDF\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\xDF\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\xDF\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\xDF\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\xDF\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\xDF\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\xDF\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\xDF\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\xDF\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\xDF\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\xDF\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\xE0\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x21"],
        ["\xE0\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x22"],
        ["\xE0\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x23"],
        ["\xE0\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x24"],
        ["\xE0\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x25"],
        ["\xE0\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x26"],
        ["\xE0\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x27"],
        ["\xE0\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x28"],
        ["\xE0\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x29"],
        ["\xE0\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2A"],
        ["\xE0\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2B"],
        ["\xE0\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2C"],
        ["\xE0\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2D"],
        ["\xE0\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2E"],
        ["\xE0\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x2F"],
        ["\xE0\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x30"],
        ["\xE0\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x31"],
        ["\xE0\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x32"],
        ["\xE0\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x33"],
        ["\xE0\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x34"],
        ["\xE0\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x35"],
        ["\xE0\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x36"],
        ["\xE0\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x37"],
        ["\xE0\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x38"],
        ["\xE0\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x39"],
        ["\xE0\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3A"],
        ["\xE0\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3B"],
        ["\xE0\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3C"],
        ["\xE0\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3D"],
        ["\xE0\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3E"],
        ["\xE0\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x3F"],
        ["\xE0\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x40"],
        ["\xE0\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\xE0\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\xE0\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\xE0\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\xE0\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\xE0\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\xE0\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\xE0\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\xE0\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\xE0\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\xE0\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\xE0\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\xE0\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\xE0\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\xE0\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\xE0\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\xE0\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\xE0\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\xE0\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\xE0\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\xE0\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\xE0\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\xE0\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\xE0\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],
        ["\xE0\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\xE0\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],
        ["\xE0\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\xE0\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\xE0\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\xE0\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\xE0\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\xE0\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\xE0\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\xE0\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\xE0\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\xE0\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\xE0\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\xE0\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\xE0\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\xE0\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\xE0\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\xE0\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\xE0\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\xE0\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\xE0\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\xE0\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\xE0\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\xE0\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\xE0\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\xE0\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\xE0\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\xE0\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\xE0\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\x59\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xE0\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\xE0\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\xE0\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\xE0\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\xE0\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\xE0\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\xE0\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\xE0\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\xE1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x21"],
        ["\xE1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x22"],
        ["\xE1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x23"],
        ["\xE1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x24"],
        ["\xE1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x25"],
        ["\xE1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x26"],
        ["\xE1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x27"],
        ["\xE1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x28"],
        ["\xE1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x29"],
        ["\xE1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2A"],
        ["\xE1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2B"],
        ["\xE1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2C"],
        ["\xE1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2D"],
        ["\xE1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2E"],
        ["\xE1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x2F"],
        ["\xE1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x30"],
        ["\xE1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x31"],
        ["\xE1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x32"],
        ["\xE1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x33"],
        ["\xE1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x34"],
        ["\xE1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x35"],
        ["\xE1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x36"],
        ["\xE1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x37"],
        ["\xE1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x38"],
        ["\xE1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x39"],
        ["\xE1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3A"],
        ["\xE1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3B"],
        ["\xE1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3C"],
        ["\xE1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3D"],
        ["\xE1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3E"],
        ["\xE1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x3F"],
        ["\xE1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x40"],
        ["\xE1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\xE1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\xE1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\xE1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\xE1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\xE1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\xE1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\xE1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\xE1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\xE1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\xE1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\xE1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\xE1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\xE1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\xE1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\xE1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\xE1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\xE1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\xE1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\xE1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\xE1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\xE1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\xE1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],
        ["\xE1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\xE1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\xE1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\xE1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\xE1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\xE1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\xE1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\xE1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\xE1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\xE1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\xE1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\xE1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\xE1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\xE1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\xE1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\xE1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\xE1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\xE1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\xE1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\xE1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\xE1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\xE1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\xE1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6E"],
        ["\xE1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\xE1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\xE1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\xE1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\xE1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\xE1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\xE1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\xE1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\xE1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x77"],
        ["\xE1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\xE1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\xE1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\xE1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\xE1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\xE1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\xE1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\xE2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x21"],
        ["\xE2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x22"],
        ["\xE2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x23"],
        ["\xE2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x24"],
        ["\xE2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x25"],
        ["\xE2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x26"],
        ["\xE2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x27"],
        ["\xE2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x28"],
        ["\xE2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x29"],
        ["\xE2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2A"],
        ["\xE2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2B"],
        ["\xE2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2C"],
        ["\xE2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2D"],
        ["\xE2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2E"],
        ["\xE2\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x2F"],
        ["\xE2\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x30"],
        ["\xE2\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x31"],
        ["\xE2\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x32"],
        ["\xE2\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x33"],
        ["\xE2\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x34"],
        ["\xE2\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x35"],
        ["\xE2\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x36"],
        ["\xE2\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x37"],
        ["\xE2\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x38"],
        ["\xE2\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x39"],
        ["\xE2\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3A"],
        ["\xE2\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3B"],
        ["\xE2\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3C"],
        ["\xE2\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3D"],
        ["\xE2\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3E"],
        ["\xE2\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x3F"],
        ["\xE2\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x40"],
        ["\xE2\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\xE2\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\xE2\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\xE2\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\xE2\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\xE2\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\xE2\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\xE2\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],
        ["\xE2\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\xE2\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\xE2\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\xE2\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\xE2\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\xE2\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\xE2\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\xE2\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\xE2\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\xE2\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\xE2\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\xE2\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\xE2\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\xE2\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\xE2\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\xE2\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\xE2\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\xE2\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\xE2\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\xE2\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\xE2\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\xE2\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\xE2\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\xE2\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\xE2\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\xE2\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\xE2\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\xE2\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\xE2\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\xE2\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\xE2\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\xB9\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x5C"],
        ["\xE2\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\xC5\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\xE2\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\xE2\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\xE2\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\xE2\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\xE2\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\xE2\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\xE2\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\xE2\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\xE2\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\xE2\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\xE2\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\xE2\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\xE2\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\xE2\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\xE2\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\xE2\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\xE2\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\xE2\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\xE2\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\xE2\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\xE3\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x21"],
        ["\xE3\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x22"],
        ["\xE3\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x23"],
        ["\xE3\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x24"],
        ["\xE3\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x25"],
        ["\xE3\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x26"],
        ["\xE3\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x27"],
        ["\xE3\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x28"],
        ["\xE3\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x29"],
        ["\xE3\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2A"],
        ["\xE3\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2B"],
        ["\xE3\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2C"],
        ["\xE3\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2D"],
        ["\xE3\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2E"],
        ["\xE3\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x2F"],
        ["\xE3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x30"],
        ["\xE3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x31"],
        ["\xE3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x32"],
        ["\xE3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x33"],
        ["\xE3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x34"],
        ["\xE3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x35"],
        ["\xE3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x36"],
        ["\xE3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x37"],
        ["\xE3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x38"],
        ["\xE3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x39"],
        ["\xE3\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3A"],
        ["\xE3\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3B"],
        ["\xE3\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3C"],
        ["\xE3\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3D"],
        ["\xE3\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3E"],
        ["\xE3\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x3F"],
        ["\xE3\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x40"],
        ["\xE3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\xE3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\xE3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\xE3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\xE3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\xE3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\xE3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\xE3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\xE3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\xE3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\xE3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\xE3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\xE3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\xE3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\xE3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\xE3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\xE3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\xE3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\xE3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\xE3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\xE3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\xE3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\xE3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\xE3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\xE3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\xE3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\xE3\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\xE3\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\xE3\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\xB3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x76"],
        ["\xE3\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\xE3\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\xE3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\xE3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\xE3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\xE3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\xE3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\xE3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\xE3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\xE3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\xE3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\xE3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\xE3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\xE3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\xE3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\xE3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\xE3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\xE3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\xE3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\xE3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\xE3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\xE3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\xE3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\xE3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\xE3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\xE3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\xE3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\xE3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\xE3\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\xE3\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\xE3\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\xE3\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\xE4\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x21"],
        ["\xE4\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x22"],
        ["\xE4\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x23"],
        ["\xE4\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x24"],
        ["\xE4\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x25"],
        ["\xE4\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x26"],
        ["\xE4\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x27"],
        ["\xE4\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x28"],
        ["\xE4\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x29"],
        ["\xE4\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2A"],
        ["\xE4\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2B"],
        ["\xE4\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2C"],
        ["\xE4\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2D"],
        ["\xE4\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2E"],
        ["\xE4\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x2F"],
        ["\xE4\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x30"],
        ["\xE4\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x31"],
        ["\xE4\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x32"],
        ["\xE4\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x33"],
        ["\xE4\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x34"],
        ["\xE4\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x35"],
        ["\xE4\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x36"],
        ["\xE4\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x37"],
        ["\xE4\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x38"],
        ["\xE4\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x39"],
        ["\xE4\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3A"],
        ["\xE4\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3B"],
        ["\xE4\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3C"],
        ["\xE4\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3D"],
        ["\xE4\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3E"],
        ["\xE4\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x3F"],
        ["\xE4\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x40"],
        ["\xE4\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\xE4\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\xE4\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\xE4\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\xE4\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x45"],
        ["\xCF\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4F\x36"],
        ["\xE4\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\xE4\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\xE4\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\xE4\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\xE4\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\xE4\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\xE4\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\xE4\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\xE4\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\xE4\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\xE4\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\xE4\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\xE4\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\xE4\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\xE4\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\xE4\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\xE4\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\xE4\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\xE4\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\xE4\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\xE4\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\xE4\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\xE4\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\xE4\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\xE4\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\xE4\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\xE4\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\xE4\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\xE4\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\xE4\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\xE4\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\xE4\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\xE4\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\xE4\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\xE4\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\xE4\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\xE4\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\xE4\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\xE4\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\xE4\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\xE4\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\xE4\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\xE4\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\xE4\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\xE4\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\xE4\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\xE4\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\xE4\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\xE4\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\xE4\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\xE4\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\xE4\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\xE4\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\xE4\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\xE4\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\xE4\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\xE5\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x21"],
        ["\xE5\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x22"],
        ["\xE5\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x23"],
        ["\xE5\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x24"],
        ["\xE5\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x25"],
        ["\xE5\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x26"],
        ["\xE5\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x27"],
        ["\xE5\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x28"],
        ["\xE5\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x29"],
        ["\xE5\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2A"],
        ["\xE5\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2B"],
        ["\xE5\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2C"],
        ["\xE5\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2D"],
        ["\xE5\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2E"],
        ["\xE5\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x2F"],
        ["\xE5\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x30"],
        ["\xE5\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x31"],
        ["\xE5\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x32"],
        ["\xE5\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x33"],
        ["\xE5\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x34"],
        ["\xE5\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x35"],
        ["\xE5\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x36"],
        ["\xE5\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x37"],
        ["\xE5\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x38"],
        ["\xE5\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x39"],
        ["\xE5\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3A"],
        ["\xE5\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3B"],
        ["\xE5\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3C"],
        ["\xE5\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3D"],
        ["\xE5\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3E"],
        ["\xE5\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x3F"],
        ["\xE5\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x40"],
        ["\xE5\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\xE5\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\xE5\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\xE5\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\xE5\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\xE5\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\xE5\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\xE5\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\xE5\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x49"],
        ["\xE5\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\xE5\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\xE5\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\xE5\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\xE5\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\xE5\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\xE5\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\xE5\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\xE5\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\xE5\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x53"],
        ["\xE5\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\xE5\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\xE5\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\xE5\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\xE5\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\xE5\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\xE5\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\xE5\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\xE5\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\xE5\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\xE5\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\xE5\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\xE5\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\xE5\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\xE5\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\xE5\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\xE5\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\xE5\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\xE5\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\xE5\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\xE5\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\xE5\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\xE5\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\xE5\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\xE5\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\xE5\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\xE5\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\xE5\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\xE5\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\xE5\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\xE5\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\xE5\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\xE5\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\xE5\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\xE5\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\xE5\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\xE5\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\xE5\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\xE5\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\xE5\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\xE5\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\xE5\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\xE5\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\xE6\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x21"],
        ["\xE6\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x22"],
        ["\xE6\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x23"],
        ["\xE6\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x24"],
        ["\xE6\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x25"],
        ["\xE6\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x26"],
        ["\xE6\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x27"],
        ["\xE6\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x28"],
        ["\xE6\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x29"],
        ["\xE6\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2A"],
        ["\xE6\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2B"],
        ["\xE6\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2C"],
        ["\xE6\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2D"],
        ["\xE6\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2E"],
        ["\xE6\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x2F"],
        ["\xE6\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x30"],
        ["\xE6\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x31"],
        ["\xE6\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x32"],
        ["\xE6\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x33"],
        ["\xE6\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x34"],
        ["\xE6\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x35"],
        ["\xE6\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x36"],
        ["\xE6\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x37"],
        ["\xE6\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x38"],
        ["\xE6\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x39"],
        ["\xE6\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3A"],
        ["\xE6\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3B"],
        ["\xE6\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3C"],
        ["\xE6\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3D"],
        ["\xE6\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3E"],
        ["\xE6\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x3F"],
        ["\xE6\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x40"],
        ["\xE6\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\xE6\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\xE6\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\xE6\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\xE6\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\xE6\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\xE6\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\xE6\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\xE6\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\xE6\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\xE6\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\xE6\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\xE6\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\xE6\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\xE6\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\xE6\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\xE6\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\xE6\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\xE6\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\xE6\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\xE6\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\xE6\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\xE6\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\xE6\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\xE6\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\xE6\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\xE6\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\xE6\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\xE6\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\xE6\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\xE6\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\xE6\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\xE6\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\xE6\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\xE6\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\xE6\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\xE6\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\xE6\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\xE6\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\xE6\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\xE6\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\xE6\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\xE6\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\xE6\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\xE6\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\xE6\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\xE6\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\xE6\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\xE6\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\xE6\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\xE6\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\xE6\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\xE6\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\xE6\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\xE6\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\xE6\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\xE6\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\xE6\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\xE6\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\xE6\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\xE6\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\xE6\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\xE7\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x21"],
        ["\xE7\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x22"],
        ["\xE7\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x23"],
        ["\xE7\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x24"],
        ["\xE7\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x25"],
        ["\xE7\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x26"],
        ["\xE7\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x27"],
        ["\xE7\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x28"],
        ["\xE7\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x29"],
        ["\xE7\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2A"],
        ["\xE7\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2B"],
        ["\xE7\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2C"],
        ["\xE7\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2D"],
        ["\xE7\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2E"],
        ["\xE7\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x2F"],
        ["\xE7\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x30"],
        ["\xE7\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x31"],
        ["\xE7\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x32"],
        ["\xE7\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x33"],
        ["\xE7\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x34"],
        ["\xE7\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x35"],
        ["\xE7\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x36"],
        ["\xE7\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x37"],
        ["\xE7\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x38"],
        ["\xE7\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x39"],
        ["\xE7\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3A"],
        ["\xE7\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3B"],
        ["\xE7\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3C"],
        ["\xE7\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3D"],
        ["\xE7\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3E"],
        ["\xE7\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x3F"],
        ["\xE7\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x40"],
        ["\xE7\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\xE7\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\xE7\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\xE7\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],
        ["\xE7\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],
        ["\xE7\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],
        ["\xE7\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],
        ["\xE7\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],
        ["\xE7\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],
        ["\xE7\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\xE7\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\xE7\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\xE7\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\xE7\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\xE7\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\xE7\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\xE7\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],
        ["\xE7\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],
        ["\xE7\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],
        ["\xE7\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],
        ["\xE7\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],
        ["\xE7\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],
        ["\xE7\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\xE7\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],
        ["\xE7\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\xE7\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\xE7\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\xE7\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\xE7\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\xE7\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\xE7\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\xE7\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\xE7\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\xE7\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\xE7\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\xE7\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\xE7\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\xE7\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\xE7\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\xE7\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\xE7\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\xE7\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\xE7\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\xE7\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\xE7\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\xE7\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\xE7\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\xE7\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\xE7\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\xE7\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\xE7\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\xE7\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\xE7\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\xE7\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\xE7\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\xE7\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\xE7\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\xE7\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\xE7\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\xE7\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\xE7\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\xE7\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\xE8\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x21"],
        ["\xE8\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x22"],
        ["\xE8\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x23"],
        ["\xE8\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x24"],
        ["\xE8\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x25"],
        ["\xE8\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x26"],
        ["\xE8\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x27"],
        ["\xE8\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x28"],
        ["\xE8\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x29"],
        ["\xE8\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2A"],
        ["\xE8\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2B"],
        ["\xE8\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2C"],
        ["\xE8\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2D"],
        ["\xE8\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2E"],
        ["\xE8\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x2F"],
        ["\xE8\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x30"],
        ["\xE8\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x31"],
        ["\xE8\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x32"],
        ["\xE8\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x33"],
        ["\xE8\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x34"],
        ["\xE8\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x35"],
        ["\xE8\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x36"],
        ["\xE8\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x37"],
        ["\xE8\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x38"],
        ["\xE8\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x39"],
        ["\xE8\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3A"],
        ["\xE8\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3B"],
        ["\xE8\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3C"],
        ["\xE8\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3D"],
        ["\xE8\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3E"],
        ["\xE8\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x3F"],
        ["\xE8\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x40"],
        ["\xE8\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],
        ["\xE8\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],
        ["\xE8\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],
        ["\xE8\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],
        ["\xE8\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],
        ["\xE8\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],
        ["\xE8\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],
        ["\xE8\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],
        ["\xE8\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],
        ["\xE8\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\xE8\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\xE8\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\xE8\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\xE8\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\xE8\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\xE8\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\xE8\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\xE8\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],
        ["\xE8\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],
        ["\xE8\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],
        ["\xE8\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],
        ["\xE8\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],
        ["\xE8\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\xE8\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],
        ["\xE8\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\xE8\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\xE8\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\xE8\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\xE8\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\xE8\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\xE8\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\xE8\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\xE8\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\xE8\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\xE8\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\xE8\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\xE8\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\xE8\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\xE8\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\xE8\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\xE8\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\xE8\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\xE8\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\xE8\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\xE8\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\xE8\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\xE8\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\xE8\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\xE8\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\xE8\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\xE8\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\xE8\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\xE8\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\xE8\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\xE8\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\xE8\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\xE8\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\xE8\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\xE8\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\xE8\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\xE8\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\xE8\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\xE9\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x21"],
        ["\xBC\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3C\x49"],
        ["\xE9\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x23"],
        ["\xE9\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x24"],
        ["\xE9\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x25"],
        ["\xE9\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x26"],
        ["\xE9\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x27"],
        ["\xE9\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x28"],
        ["\xE9\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x29"],
        ["\xE9\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2A"],
        ["\xE9\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2B"],
        ["\xE9\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2C"],
        ["\xE9\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2D"],
        ["\xCC\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\xE9\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x2F"],
        ["\xE9\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x30"],
        ["\xE9\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x31"],
        ["\xE9\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x32"],
        ["\xE9\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x33"],
        ["\xE9\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x34"],
        ["\xE9\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x35"],
        ["\xE9\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x36"],
        ["\xE9\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x37"],
        ["\xE9\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x38"],
        ["\xE9\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x39"],
        ["\xE9\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3A"],
        ["\xE9\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3B"],
        ["\xE9\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3C"],
        ["\xE9\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3D"],
        ["\xE9\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3E"],
        ["\xE9\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x3F"],
        ["\xE9\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x40"],
        ["\xE9\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x41"],
        ["\xE9\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x42"],
        ["\xE9\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x43"],
        ["\xE9\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x44"],
        ["\xE9\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x45"],
        ["\xE9\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x46"],
        ["\xE9\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x47"],
        ["\xE9\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x48"],
        ["\xE9\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x49"],
        ["\xE9\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],
        ["\xE9\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],
        ["\xE9\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],
        ["\xE9\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],
        ["\xE9\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],
        ["\xE9\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],
        ["\xE9\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],
        ["\xE9\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x51"],
        ["\xE9\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x52"],
        ["\xE9\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x53"],
        ["\xE9\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x54"],
        ["\xE9\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x55"],
        ["\xE9\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x56"],
        ["\xE9\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],
        ["\xE9\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x58"],
        ["\xE9\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],
        ["\xB3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x33\x42"],
        ["\xE9\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],
        ["\xE9\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],
        ["\xE9\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],
        ["\xE9\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],
        ["\xE9\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],
        ["\xE9\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],
        ["\xE9\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],
        ["\xE9\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],
        ["\xE9\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],
        ["\xE9\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],
        ["\xE9\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],
        ["\xE9\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],
        ["\xE9\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],
        ["\xE9\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],
        ["\xE9\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],
        ["\xE9\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],
        ["\xE9\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],
        ["\xE9\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],
        ["\xE9\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],
        ["\xE9\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],
        ["\xE9\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],
        ["\xE9\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],
        ["\xE9\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],
        ["\xE9\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],
        ["\xE9\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],
        ["\xE9\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],
        ["\xE9\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],
        ["\xE9\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],
        ["\xE9\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],
        ["\xE9\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],
        ["\xE9\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],
        ["\xE9\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],
        ["\xE9\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],
        ["\xE9\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],
        ["\xE9\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],
        ["\xE9\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],
        ["\xEA\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x21"],
        ["\xEA\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x22"],
        ["\xEA\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x23"],
        ["\xC7\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\xEA\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x25"],
        ["\xEA\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x26"],
        ["\xEA\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x27"],
        ["\xEA\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x28"],
        ["\xEA\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x29"],
        ["\xEA\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2A"],
        ["\xEA\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2B"],
        ["\xEA\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2C"],
        ["\xEA\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2D"],
        ["\xEA\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2E"],
        ["\xEA\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x2F"],
        ["\xEA\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x30"],
        ["\xEA\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x31"],
        ["\xEA\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x32"],
        ["\xEA\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x33"],
        ["\xEA\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x34"],
        ["\xEA\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x35"],
        ["\xEA\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x36"],
        ["\xEA\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x37"],
        ["\xEA\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x38"],
        ["\xEA\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x39"],
        ["\xEA\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3A"],
        ["\xEA\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3B"],
        ["\xEA\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3C"],
        ["\xEA\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3D"],
        ["\xEA\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3E"],
        ["\xEA\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x3F"],
        ["\xEA\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x40"],
        ["\xEA\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x41"],
        ["\xEA\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x42"],
        ["\xEA\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x43"],
        ["\xEA\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x44"],
        ["\xEA\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x45"],
        ["\xEA\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x46"],
        ["\xEA\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x47"],
        ["\xEA\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x48"],
        ["\xEA\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x49"],
        ["\xEA\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4A"],
        ["\xEA\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4B"],
        ["\xEA\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4C"],
        ["\xEA\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4D"],
        ["\xEA\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4E"],
        ["\xEA\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x4F"],
        ["\xEA\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x50"],
        ["\xEA\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x51"],
        ["\xEA\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x52"],
        ["\xEA\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x53"],
        ["\xEA\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x54"],
        ["\xEA\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x55"],
        ["\xEA\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x56"],
        ["\xEA\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x57"],
        ["\xEA\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x58"],
        ["\xEA\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x59"],
        ["\xEA\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5A"],
        ["\xEA\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5B"],
        ["\xEA\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5C"],
        ["\xEA\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5D"],
        ["\xEA\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5E"],
        ["\xEA\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x5F"],
        ["\xEA\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x60"],
        ["\xEA\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x61"],
        ["\xEA\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x62"],
        ["\xEA\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x63"],
        ["\xEA\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x64"],
        ["\xEA\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x65"],
        ["\xEA\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x66"],
        ["\xEA\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x67"],
        ["\xEA\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x68"],
        ["\xEA\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x69"],
        ["\xEA\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6A"],
        ["\xEA\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6B"],
        ["\xEA\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6C"],
        ["\xEA\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6D"],
        ["\xEA\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6E"],
        ["\xEA\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x6F"],
        ["\xEA\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x70"],
        ["\xEA\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x71"],
        ["\xEA\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x72"],
        ["\xEA\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x73"],
        ["\xEA\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x74"],
        ["\xEA\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x75"],
        ["\xEA\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x76"],
        ["\xEA\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x77"],
        ["\xEA\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x78"],
        ["\xEA\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x79"],
        ["\xEA\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x7A"],
        ["\xEA\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x7B"],
        ["\xEA\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x7C"],
        ["\xEA\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x7D"],
        ["\xEA\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6A\x7E"],
        ["\xEB\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x21"],
        ["\xEB\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x22"],
        ["\xEB\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x23"],
        ["\xEB\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x24"],
        ["\xEB\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x25"],
        ["\xEB\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x26"],
        ["\xEB\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x27"],
        ["\xEB\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x28"],
        ["\xEB\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x29"],
        ["\xEB\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2A"],
        ["\xEB\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2B"],
        ["\xEB\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2C"],
        ["\xEB\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2D"],
        ["\xEB\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2E"],
        ["\xEB\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x2F"],
        ["\xEB\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x30"],
        ["\xEB\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x31"],
        ["\xEB\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x32"],
        ["\xEB\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x33"],
        ["\xEB\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x34"],
        ["\xEB\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x35"],
        ["\xEB\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x36"],
        ["\xEB\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x37"],
        ["\xEB\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x38"],
        ["\xEB\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x39"],
        ["\xEB\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3A"],
        ["\xEB\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3B"],
        ["\xEB\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3C"],
        ["\xEB\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3D"],
        ["\xEB\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3E"],
        ["\xEB\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x3F"],
        ["\xEB\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x40"],
        ["\xEB\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x41"],
        ["\xEB\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x42"],
        ["\xEB\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x43"],
        ["\xEB\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x44"],
        ["\xEB\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x45"],
        ["\xEB\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x46"],
        ["\xEB\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x47"],
        ["\xEB\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x48"],
        ["\xEB\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x49"],
        ["\xEB\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],
        ["\xEB\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4B"],
        ["\xEB\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],
        ["\xEB\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4D"],
        ["\xEB\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4E"],
        ["\xEB\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x4F"],
        ["\xEB\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],
        ["\xEB\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x51"],
        ["\xEB\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x52"],
        ["\xEB\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x53"],
        ["\xEB\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x54"],
        ["\xEB\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x55"],
        ["\xEB\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x56"],
        ["\xEB\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x57"],
        ["\xEB\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x58"],
        ["\xEB\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x59"],
        ["\xEB\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5A"],
        ["\xEB\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],
        ["\xEB\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5C"],
        ["\xB4\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x34\x52"],
        ["\xEB\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],
        ["\xEB\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x5F"],
        ["\xEB\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x60"],
        ["\xEB\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x61"],
        ["\xEB\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],
        ["\xEB\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x63"],
        ["\xEB\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x64"],
        ["\xEB\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],
        ["\xEB\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x66"],
        ["\xEB\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x67"],
        ["\xEB\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x68"],
        ["\xEB\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x69"],
        ["\xEB\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6A"],
        ["\xEB\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6B"],
        ["\xEB\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],
        ["\xEB\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],
        ["\xEB\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6E"],
        ["\xEB\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],
        ["\xEB\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x70"],
        ["\xEB\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x71"],
        ["\xEB\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x72"],
        ["\xEB\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x73"],
        ["\xEB\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],
        ["\xEB\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x75"],
        ["\xEB\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x76"],
        ["\xEB\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x77"],
        ["\xEB\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x78"],
        ["\xEB\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],
        ["\xEB\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x7A"],
        ["\xEB\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x7B"],
        ["\xEB\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],
        ["\xEB\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],
        ["\xEB\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6B\x7E"],
        ["\xEC\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x21"],
        ["\xEC\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x22"],
        ["\xEC\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x23"],
        ["\xEC\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x24"],
        ["\xEC\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x25"],
        ["\xEC\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x26"],
        ["\xEC\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x27"],
        ["\xEC\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x28"],
        ["\xEC\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x29"],
        ["\xEC\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2A"],
        ["\xEC\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2B"],
        ["\xEC\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2C"],
        ["\xEC\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2D"],
        ["\xEC\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2E"],
        ["\xEC\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x2F"],
        ["\xEC\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x30"],
        ["\xEC\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x31"],
        ["\xEC\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x32"],
        ["\xEC\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x33"],
        ["\xEC\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x34"],
        ["\xEC\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x35"],
        ["\xEC\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x36"],
        ["\xEC\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x37"],
        ["\xEC\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x38"],
        ["\xEC\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x39"],
        ["\xEC\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3A"],
        ["\xEC\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3B"],
        ["\xEC\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3C"],
        ["\xEC\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3D"],
        ["\xEC\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3E"],
        ["\xEC\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x3F"],
        ["\xEC\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x40"],
        ["\xEC\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x41"],
        ["\xEC\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x42"],
        ["\xEC\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x43"],
        ["\xEC\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x44"],
        ["\xEC\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x45"],
        ["\xEC\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x46"],
        ["\xEC\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x47"],
        ["\xEC\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x48"],
        ["\xEC\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x49"],
        ["\xEC\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],
        ["\xEC\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],
        ["\xEC\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],
        ["\xC1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x41\x28"],
        ["\xEC\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],
        ["\xEC\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],
        ["\xEC\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],
        ["\xEC\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x51"],
        ["\xEC\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x52"],
        ["\xEC\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x53"],
        ["\xEC\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x54"],
        ["\xEC\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x55"],
        ["\xEC\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x56"],
        ["\xEC\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],
        ["\xEC\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x58"],
        ["\xEC\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],
        ["\xEC\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],
        ["\xEC\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],
        ["\xEC\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],
        ["\xEC\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],
        ["\xEC\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],
        ["\xEC\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],
        ["\xEC\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],
        ["\xEC\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],
        ["\xEC\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],
        ["\xEC\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],
        ["\xEC\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],
        ["\xEC\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],
        ["\xEC\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],
        ["\xEC\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],
        ["\xEC\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],
        ["\xEC\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],
        ["\xEC\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6A"],
        ["\xEC\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],
        ["\xEC\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],
        ["\xEC\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],
        ["\xEC\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],
        ["\xEC\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],
        ["\xEC\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],
        ["\xEC\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],
        ["\xEC\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],
        ["\xEC\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],
        ["\xEC\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],
        ["\xEC\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],
        ["\xEC\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],
        ["\xEC\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],
        ["\xEC\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],
        ["\xEC\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],
        ["\xEC\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],
        ["\xEC\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],
        ["\xEC\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],
        ["\xEC\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],
        ["\xEC\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],
        ["\xED\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x21"],
        ["\xED\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x22"],
        ["\xED\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x23"],
        ["\xED\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x24"],
        ["\xED\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x25"],
        ["\xED\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x26"],
        ["\xED\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x27"],
        ["\xED\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x28"],
        ["\xED\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x29"],
        ["\xED\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2A"],
        ["\xED\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2B"],
        ["\xED\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2C"],
        ["\xED\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2D"],
        ["\xED\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2E"],
        ["\xED\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x2F"],
        ["\xED\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x30"],
        ["\xED\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x31"],
        ["\xED\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x32"],
        ["\xED\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x33"],
        ["\xED\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x34"],
        ["\xED\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x35"],
        ["\xED\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x36"],
        ["\xED\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x37"],
        ["\xED\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x38"],
        ["\xED\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x39"],
        ["\xED\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3A"],
        ["\xED\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3B"],
        ["\xED\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3C"],
        ["\xED\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3D"],
        ["\xED\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3E"],
        ["\xED\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x3F"],
        ["\xED\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x40"],
        ["\xED\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x41"],
        ["\xED\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x42"],
        ["\xED\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x43"],
        ["\xED\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x44"],
        ["\xED\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x45"],
        ["\xED\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x46"],
        ["\xED\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x47"],
        ["\xED\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x48"],
        ["\xED\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x49"],
        ["\xED\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],
        ["\xED\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],
        ["\xED\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],
        ["\xED\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],
        ["\xED\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],
        ["\xED\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],
        ["\xED\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],
        ["\xED\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x51"],
        ["\xED\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x52"],
        ["\xED\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x53"],
        ["\xED\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x54"],
        ["\xED\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x55"],
        ["\xED\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x56"],
        ["\xED\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],
        ["\xED\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x58"],
        ["\xED\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],
        ["\xED\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],
        ["\xED\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],
        ["\xED\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],
        ["\xED\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],
        ["\xED\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],
        ["\xED\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],
        ["\xED\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],
        ["\xED\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],
        ["\xED\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],
        ["\xED\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],
        ["\xED\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],
        ["\xED\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],
        ["\xED\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],
        ["\xED\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],
        ["\xED\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],
        ["\xED\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],
        ["\xED\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],
        ["\xED\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],
        ["\xED\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],
        ["\xED\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],
        ["\xC6\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\xED\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],
        ["\xED\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],
        ["\xED\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],
        ["\xED\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],
        ["\xED\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],
        ["\xED\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],
        ["\xED\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],
        ["\xED\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],
        ["\xED\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],
        ["\xED\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],
        ["\xED\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],
        ["\xED\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],
        ["\xED\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],
        ["\xED\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],
        ["\xED\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],
        ["\xED\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],
        ["\xEE\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x21"],
        ["\xEE\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x22"],
        ["\xEE\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x23"],
        ["\xEE\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x24"],
        ["\xEE\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x25"],
        ["\xEE\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x26"],
        ["\xEE\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x27"],
        ["\xEE\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x28"],
        ["\xEE\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x29"],
        ["\xEE\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2A"],
        ["\xEE\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2B"],
        ["\xEE\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2C"],
        ["\xEE\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2D"],
        ["\xEE\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2E"],
        ["\xEE\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x2F"],
        ["\xEE\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x30"],
        ["\xEE\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x31"],
        ["\xEE\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x32"],
        ["\xEE\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x33"],
        ["\xEE\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x34"],
        ["\xEE\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x35"],
        ["\xEE\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x36"],
        ["\xEE\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x37"],
        ["\xEE\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x38"],
        ["\xEE\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x39"],
        ["\xEE\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3A"],
        ["\xEE\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3B"],
        ["\xEE\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3C"],
        ["\xEE\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3D"],
        ["\xEE\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3E"],
        ["\xEE\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x3F"],
        ["\xEE\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x40"],
        ["\xEE\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x41"],
        ["\xEE\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x42"],
        ["\xEE\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x43"],
        ["\xEE\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x44"],
        ["\xEE\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x45"],
        ["\xEE\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x46"],
        ["\xEE\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x47"],
        ["\xEE\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x48"],
        ["\xEE\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x49"],
        ["\xEE\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],
        ["\xEE\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],
        ["\xEE\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],
        ["\xEE\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],
        ["\xEE\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],
        ["\xEE\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],
        ["\xEE\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],
        ["\xEE\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x51"],
        ["\xEE\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x52"],
        ["\xEE\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x53"],
        ["\xEE\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x54"],
        ["\xEE\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x55"],
        ["\xEE\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x56"],
        ["\xEE\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],
        ["\xEE\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x58"],
        ["\xEE\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],
        ["\xEE\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],
        ["\xEE\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],
        ["\xEE\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],
        ["\xEE\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],
        ["\xEE\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],
        ["\xEE\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],
        ["\xEE\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],
        ["\xEE\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],
        ["\xEE\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],
        ["\xEE\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],
        ["\xEE\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],
        ["\xEE\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],
        ["\xEE\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],
        ["\xEE\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],
        ["\xEE\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],
        ["\xEE\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],
        ["\xEE\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],
        ["\xEE\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],
        ["\xEE\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],
        ["\xEE\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],
        ["\xEE\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],
        ["\xEE\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],
        ["\xEE\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],
        ["\xEE\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],
        ["\xEE\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],
        ["\xEE\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],
        ["\xEE\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],
        ["\xEE\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],
        ["\xEE\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],
        ["\xEE\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],
        ["\xEE\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],
        ["\xEE\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],
        ["\xEE\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],
        ["\xEE\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],
        ["\xEE\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],
        ["\xEE\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],
        ["\xEE\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],
        ["\xEF\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x21"],
        ["\xEF\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x22"],
        ["\xEF\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x23"],
        ["\xEF\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x24"],
        ["\xEF\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x25"],
        ["\xEF\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x26"],
        ["\xEF\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x27"],
        ["\xEF\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x28"],
        ["\xEF\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x29"],
        ["\xEF\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2A"],
        ["\xEF\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2B"],
        ["\xEF\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2C"],
        ["\xEF\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2D"],
        ["\xEF\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2E"],
        ["\xEF\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x2F"],
        ["\xEF\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x30"],
        ["\xEF\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x31"],
        ["\xEF\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x32"],
        ["\xEF\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x33"],
        ["\xEF\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x34"],
        ["\xEF\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x35"],
        ["\xEF\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x36"],
        ["\xEF\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x37"],
        ["\xEF\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x38"],
        ["\xEF\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x39"],
        ["\xEF\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3A"],
        ["\xEF\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3B"],
        ["\xEF\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3C"],
        ["\xEF\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3D"],
        ["\xEF\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3E"],
        ["\xEF\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x3F"],
        ["\xEF\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x40"],
        ["\xEF\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x41"],
        ["\xEF\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x42"],
        ["\xEF\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x43"],
        ["\xEF\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x44"],
        ["\xEF\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x45"],
        ["\xEF\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x46"],
        ["\xEF\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x47"],
        ["\xEF\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x48"],
        ["\xEF\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x49"],
        ["\xEF\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],
        ["\xEF\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],
        ["\xEF\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],
        ["\xEF\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],
        ["\xEF\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],
        ["\xEF\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],
        ["\xEF\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],
        ["\xEF\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x51"],
        ["\xEF\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x52"],
        ["\xEF\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x53"],
        ["\xEF\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x54"],
        ["\xEF\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x55"],
        ["\xEF\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x56"],
        ["\xEF\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],
        ["\xEF\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x58"],
        ["\xEF\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],
        ["\xEF\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],
        ["\xEF\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],
        ["\xEF\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],
        ["\xEF\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],
        ["\xEF\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],
        ["\xEF\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],
        ["\xEF\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],
        ["\xEF\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],
        ["\xEF\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],
        ["\xEF\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],
        ["\xEF\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],
        ["\xEF\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],
        ["\xEF\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],
        ["\xEF\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],
        ["\xEF\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],
        ["\xEF\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],
        ["\xEF\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],
        ["\xEF\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],
        ["\xEF\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],
        ["\xEF\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],
        ["\xEF\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],
        ["\xEF\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],
        ["\xEF\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],
        ["\xEF\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],
        ["\xEF\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],
        ["\xEF\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],
        ["\xEF\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],
        ["\xEF\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],
        ["\xEF\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],
        ["\xEF\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],
        ["\xEF\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],
        ["\xEF\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],
        ["\xEF\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],
        ["\xEF\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],
        ["\xEF\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],
        ["\xEF\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],
        ["\xEF\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],
        ["\xF0\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x21"],
        ["\xF0\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x22"],
        ["\xF0\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x23"],
        ["\xF0\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x24"],
        ["\xF0\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x25"],
        ["\xF0\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x26"],
        ["\xF0\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x27"],
        ["\xF0\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x28"],
        ["\xF0\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x29"],
        ["\xF0\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2A"],
        ["\xF0\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2B"],
        ["\xF0\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2C"],
        ["\xF0\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2D"],
        ["\xF0\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2E"],
        ["\xF0\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x2F"],
        ["\xF0\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x30"],
        ["\xF0\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x31"],
        ["\xF0\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x32"],
        ["\xF0\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x33"],
        ["\xF0\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x34"],
        ["\xF0\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x35"],
        ["\xF0\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x36"],
        ["\xF0\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x37"],
        ["\xF0\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x38"],
        ["\xF0\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x39"],
        ["\xF0\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3A"],
        ["\xF0\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3B"],
        ["\xF0\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3C"],
        ["\xF0\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3D"],
        ["\xF0\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3E"],
        ["\xF0\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x3F"],
        ["\xF0\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x40"],
        ["\xF0\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x41"],
        ["\xF0\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x42"],
        ["\xF0\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x43"],
        ["\xF0\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x44"],
        ["\xF0\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x45"],
        ["\xF0\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x46"],
        ["\xF0\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x47"],
        ["\xF0\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x48"],
        ["\xF0\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x49"],
        ["\xF0\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],
        ["\xF0\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],
        ["\xF0\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],
        ["\xF0\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],
        ["\xF0\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],
        ["\xF0\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],
        ["\xF0\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],
        ["\xF0\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x51"],
        ["\xF0\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x52"],
        ["\xF0\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x53"],
        ["\xF0\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x54"],
        ["\xF0\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x55"],
        ["\xF0\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x56"],
        ["\xBF\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x3F\x59"],
        ["\xF0\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x58"],
        ["\xF0\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],
        ["\xF0\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],
        ["\xF0\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],
        ["\xF0\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],
        ["\xF0\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],
        ["\xF0\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],
        ["\xF0\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],
        ["\xF0\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],
        ["\xF0\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],
        ["\xF0\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],
        ["\xF0\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],
        ["\xF0\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],
        ["\xF0\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],
        ["\xF0\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],
        ["\xF0\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],
        ["\xF0\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],
        ["\xF0\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],
        ["\xF0\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],
        ["\xF0\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],
        ["\xF0\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],
        ["\xF0\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],
        ["\xF0\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],
        ["\xF0\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],
        ["\xF0\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],
        ["\xF0\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],
        ["\xF0\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],
        ["\xF0\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],
        ["\xB7\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x37\x5B"],
        ["\xF0\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],
        ["\xF0\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],
        ["\xF0\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],
        ["\xF0\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],
        ["\xF0\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],
        ["\xF0\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],
        ["\xF0\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],
        ["\xF0\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],
        ["\xF0\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],
        ["\xF0\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],
        ["\xF1\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x21"],
        ["\xF1\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x22"],
        ["\xF1\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x23"],
        ["\xF1\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x24"],
        ["\xF1\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x25"],
        ["\xF1\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x26"],
        ["\xF1\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x27"],
        ["\xF1\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x28"],
        ["\xF1\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x29"],
        ["\xF1\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2A"],
        ["\xF1\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2B"],
        ["\xF1\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2C"],
        ["\xF1\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2D"],
        ["\xF1\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2E"],
        ["\xF1\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x2F"],
        ["\xF1\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x30"],
        ["\xF1\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x31"],
        ["\xF1\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x32"],
        ["\xF1\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x33"],
        ["\xF1\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x34"],
        ["\xF1\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x35"],
        ["\xF1\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x36"],
        ["\xF1\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x37"],
        ["\xF1\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x38"],
        ["\xF1\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x39"],
        ["\xF1\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3A"],
        ["\xF1\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3B"],
        ["\xF1\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3C"],
        ["\xF1\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3D"],
        ["\xF1\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3E"],
        ["\xF1\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x3F"],
        ["\xF1\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x40"],
        ["\xF1\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x41"],
        ["\xF1\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x42"],
        ["\xF1\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x43"],
        ["\xF1\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x44"],
        ["\xF1\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x45"],
        ["\xF1\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x46"],
        ["\xF1\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x47"],
        ["\xF1\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x48"],
        ["\xF1\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x49"],
        ["\xF1\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],
        ["\xF1\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],
        ["\xF1\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],
        ["\xF1\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],
        ["\xF1\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],
        ["\xF1\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],
        ["\xF1\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],
        ["\xF1\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x51"],
        ["\xF1\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x52"],
        ["\xF1\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x53"],
        ["\xF1\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x54"],
        ["\xF1\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x55"],
        ["\xF1\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x56"],
        ["\xF1\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],
        ["\xF1\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x58"],
        ["\xF1\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],
        ["\xF1\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],
        ["\xF1\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],
        ["\xF1\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],
        ["\xF1\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],
        ["\xF1\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],
        ["\xF1\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],
        ["\xF1\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],
        ["\xF1\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],
        ["\xF1\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],
        ["\xF1\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],
        ["\xF1\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],
        ["\xF1\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],
        ["\xF1\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],
        ["\xF1\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],
        ["\xF1\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],
        ["\xF1\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],
        ["\xF1\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],
        ["\xF1\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],
        ["\xF1\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],
        ["\xF1\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],
        ["\xF1\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],
        ["\xF1\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],
        ["\xF1\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],
        ["\xF1\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],
        ["\xF1\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],
        ["\xF1\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],
        ["\xF1\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],
        ["\xF1\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],
        ["\xF1\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],
        ["\xF1\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],
        ["\xF1\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],
        ["\xF1\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],
        ["\xF1\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],
        ["\xF1\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],
        ["\xF1\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],
        ["\xF1\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],
        ["\xF1\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],
        ["\xF2\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x21"],
        ["\xF2\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x22"],
        ["\xF2\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x23"],
        ["\xF2\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x24"],
        ["\xF2\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x25"],
        ["\xF2\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x26"],
        ["\xF2\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x27"],
        ["\xF2\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x28"],
        ["\xF2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x29"],
        ["\xF2\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2A"],
        ["\xF2\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2B"],
        ["\xF2\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2C"],
        ["\xF2\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2D"],
        ["\xF2\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2E"],
        ["\xF2\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x2F"],
        ["\xF2\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x30"],
        ["\xF2\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x31"],
        ["\xF2\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x32"],
        ["\xF2\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x33"],
        ["\xF2\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x34"],
        ["\xF2\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x35"],
        ["\xF2\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x36"],
        ["\xF2\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x37"],
        ["\xF2\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x38"],
        ["\xF2\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x39"],
        ["\xF2\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3A"],
        ["\xF2\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3B"],
        ["\xF2\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3C"],
        ["\xF2\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3D"],
        ["\xF2\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3E"],
        ["\xF2\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x3F"],
        ["\xF2\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x40"],
        ["\xF2\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x41"],
        ["\xF2\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x42"],
        ["\xF2\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x43"],
        ["\xF2\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x44"],
        ["\xF2\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x45"],
        ["\xF2\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x46"],
        ["\xF2\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x47"],
        ["\xF2\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x48"],
        ["\xF2\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x49"],
        ["\xF2\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],
        ["\xF2\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],
        ["\xF2\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],
        ["\xB0\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x30\x33"],
        ["\xF2\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],
        ["\xF2\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],
        ["\xF2\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],
        ["\xF2\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x51"],
        ["\xF2\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x52"],
        ["\xF2\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x53"],
        ["\xF2\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x54"],
        ["\xF2\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x55"],
        ["\xF2\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x56"],
        ["\xF2\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],
        ["\xF2\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x58"],
        ["\xF2\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],
        ["\xF2\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],
        ["\xF2\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],
        ["\xF2\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],
        ["\xF2\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],
        ["\xF2\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],
        ["\xF2\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],
        ["\xF2\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],
        ["\xF2\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],
        ["\xF2\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],
        ["\xF2\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],
        ["\xF2\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],
        ["\xF2\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],
        ["\xF2\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],
        ["\xF2\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],
        ["\xF2\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],
        ["\xF2\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],
        ["\xF2\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],
        ["\xF2\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],
        ["\xF2\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],
        ["\xF2\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],
        ["\xF2\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],
        ["\xF2\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],
        ["\xF2\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],
        ["\xF2\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],
        ["\xF2\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],
        ["\xF2\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],
        ["\xB2\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\x29"],
        ["\xF2\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],
        ["\xF2\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],
        ["\xF2\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],
        ["\xF2\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],
        ["\xF2\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],
        ["\xF2\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],
        ["\xF2\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],
        ["\xF2\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],
        ["\xF2\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],
        ["\xF2\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],
        ["\xF3\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x21"],
        ["\xF3\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x22"],
        ["\xF3\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x23"],
        ["\xF3\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x24"],
        ["\xF3\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x25"],
        ["\xF3\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x26"],
        ["\xF3\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x27"],
        ["\xF3\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x28"],
        ["\xF3\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x29"],
        ["\xF3\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2A"],
        ["\xF3\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2B"],
        ["\xF3\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2C"],
        ["\xF3\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2D"],
        ["\xF3\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2E"],
        ["\xF3\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x2F"],
        ["\xF3\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x30"],
        ["\xF3\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x31"],
        ["\xF3\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x32"],
        ["\xF3\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x33"],
        ["\xF3\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x34"],
        ["\xF3\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x35"],
        ["\xF3\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x36"],
        ["\xF3\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x37"],
        ["\xF3\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x38"],
        ["\xF3\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x39"],
        ["\xF3\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3A"],
        ["\xF3\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3B"],
        ["\xF3\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3C"],
        ["\xF3\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3D"],
        ["\xF3\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3E"],
        ["\xF3\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x3F"],
        ["\xF3\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x40"],
        ["\xF3\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x41"],
        ["\xF3\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x42"],
        ["\xF3\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x43"],
        ["\xF3\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x44"],
        ["\xF3\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x45"],
        ["\xF3\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x46"],
        ["\xF3\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x47"],
        ["\xF3\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x48"],
        ["\xF3\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x49"],
        ["\xF3\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],
        ["\xF3\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],
        ["\xF3\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],
        ["\xF3\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],
        ["\xF3\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],
        ["\xF3\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],
        ["\xF3\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],
        ["\xF3\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x51"],
        ["\xF3\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x52"],
        ["\xF3\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x53"],
        ["\xF3\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x54"],
        ["\xF3\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x55"],
        ["\xF3\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x56"],
        ["\xF3\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],
        ["\xF3\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x58"],
        ["\xF3\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],
        ["\xF3\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],
        ["\xF3\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],
        ["\xF3\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],
        ["\xF3\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],
        ["\xF3\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],
        ["\xF3\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],
        ["\xF3\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],
        ["\xF3\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],
        ["\xF3\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],
        ["\xF3\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],
        ["\xF3\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],
        ["\xF3\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],
        ["\xF3\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],
        ["\xF3\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],
        ["\xF3\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],
        ["\xF3\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],
        ["\xF3\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],
        ["\xF3\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],
        ["\xF3\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],
        ["\xF3\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],
        ["\xF3\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],
        ["\xF3\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],
        ["\xF3\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],
        ["\xF3\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],
        ["\xF3\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],
        ["\xF3\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],
        ["\xF3\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],
        ["\xF3\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],
        ["\xF3\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],
        ["\xF3\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],
        ["\xF3\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],
        ["\xF3\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],
        ["\xF3\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],
        ["\xF3\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],
        ["\xF3\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],
        ["\xF3\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],
        ["\xF3\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],
        ["\xB6\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x36\x46"],
        ["\xCB\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\xCD\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\xE0\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\x44\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\x58\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\x77\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\x77\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\x77\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\x77\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\x77\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\x77\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC2"],
        ["\x77\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC3"],
        ["\x77\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC4"],
        ["\x77\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC5"],
        ["\x77\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC6"],
        ["\x76\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xFB"],
        ["\x76\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\x76\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\x5F\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\x64\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\x6A\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\x69\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\x62\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\x42\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\x70\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\x51\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\x70\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\x6A\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\x51\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\x4C\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\x41\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\x41\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\x43\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\x41\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\x41\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\x41\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\x42\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\x42\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\x42\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\x42\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\x42\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\x42\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\x42\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\x42\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\x43\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\x42\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\x42\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\x42\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\x42\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\x42\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\x43\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\x43\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\x43\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\x43\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\x43\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\x43\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\x44\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\x44\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\x44\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\x44\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\x44\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\x44\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\x45\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\x45\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\x45\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\x45\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\x45\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\x45\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\x45\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\x45\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\x46\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\x46\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\x46\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\x45\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\x45\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\x48\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\x48\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\x48\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\x47\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\x47\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\x48\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xC4\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\x48\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\x48\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\x48\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\x48\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\x48\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\x48\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\x48\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\x49\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\x49\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\x49\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\x4A\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\x4A\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\x4A\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\x4A\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\x4A\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\x4A\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\x4A\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\x4B\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\x4A\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\x4B\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\x4B\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\x4B\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\x4B\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\x4B\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\x4B\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\x4B\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\x4C\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\x4C\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\x4D\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\x4D\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\x4D\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\x4D\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\x4E\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\x4D\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\x4E\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\x4E\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\x4E\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\x4E\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\x4E\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\x4E\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\x4E\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\x4E\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\x4E\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\x4F\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\x4F\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\x4F\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\x50\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\x4F\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\x50\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\x51\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\x51\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xB9\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x37"],
        ["\x51\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\x51\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\x51\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\x51\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\x51\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\x52\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\x51\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\x51\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\x51\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\x51\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\x51\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\x51\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\x51\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\x52\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\x52\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\x52\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\x70\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\x53\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\x52\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\x53\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\x53\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\x53\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\x70\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\x70\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\x53\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\x70\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\x52\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\x70\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\x70\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\x54\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\x52\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\x54\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\x54\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\x54\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\x54\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\x54\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\x55\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\x55\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\x55\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\x55\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\x55\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\x55\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\x56\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\x70\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\x56\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\x56\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\x56\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\x56\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\x70\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\x55\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\x56\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\x56\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\x56\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\x56\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\x56\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\x56\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\x57\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\x57\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\x57\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\x57\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\x57\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\x57\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\x57\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\x58\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\x58\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\x57\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\x57\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\x57\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\x70\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\x57\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\x58\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\x58\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\x58\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\x58\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\x58\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\x58\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\x59\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\x59\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\x59\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\x59\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\x5A\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\x59\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\x59\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\x59\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\x59\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\x59\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\x59\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\x5A\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\x59\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\x59\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\x5A\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\x5A\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\x5A\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\x5B\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\x5B\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\x5A\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\x5B\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\x5B\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\x5B\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\x44\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\x5B\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\x5C\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\x5C\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\x5C\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\x5C\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\x70\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\x5C\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\x5C\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\x5C\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\x5C\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\x5C\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\x5D\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\x5D\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\x5D\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\x5D\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\x5E\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\x5E\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\x5E\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\x5E\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\x5F\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\x5F\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\x5F\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\x5F\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\x5F\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\x5F\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\x60\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\x61\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\x70\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\x61\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\x61\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\x62\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\x70\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\x70\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\x62\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\x62\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\x62\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\x62\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\x62\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\x70\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\x63\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\x63\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\x63\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\x64\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\x64\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\x64\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\x65\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\x6B\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\x65\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\x65\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\x65\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\x65\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\x65\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\x66\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\x65\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\x65\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\x66\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\x66\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\x66\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xDE"],
        ["\x70\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xFD"],
        ["\x70\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\x70\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\x68\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\x68\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\x68\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\x68\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\x69\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\x69\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\x69\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\x69\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\x69\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\x69\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\x69\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\x69\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\x69\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\x69\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\x69\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\x69\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\x69\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\x69\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\x69\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\x69\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\x69\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\x6B\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\x6A\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\x69\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\x69\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\x6A\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\x6A\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\x6A\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\x6A\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\x6B\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\x6A\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\x6A\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\x6A\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\x6A\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\x6A\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\x69\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\x6B\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\x6A\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\x6A\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\x6A\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\x6A\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\x6A\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\x6A\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\x6A\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\x6A\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\x6B\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\x6B\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\x6B\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\x6B\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\x6B\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\x6B\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\x68\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\x68\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\x68\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\x68\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\x6C\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\x6C\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\x6C\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\x6C\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\x6C\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\x6C\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\x6C\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\x6C\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\x6C\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\x6D\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\x6D\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\x6D\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\x6D\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\x5C\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\x6D\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\x6E\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\x6E\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\x6E\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\x6E\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\x6E\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\x6E\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\x6E\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\x6E\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\x6F\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\x6F\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\x6F\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\x6F\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\x6F\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\x76\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\x76\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\x76\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xF7"],
        ["\x76\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x78\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x76\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x79\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\x79\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\x79\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\x79\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\x79\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\x79\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\x79\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\x79\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\x79\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\x79\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\x79\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\x79\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\x79\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\x79\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\x79\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\x79\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\x79\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\x79\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\x79\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\x79\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\x79\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\x79\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\x79\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\x79\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\x79\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\x79\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\x79\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\x79\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\x79\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\x79\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\x79\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\x79\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\x79\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\x79\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\x79\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\x79\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\x41\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\x41\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\x41\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\x41\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\x41\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\x42\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\x42\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\x42\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\x42\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\x42\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\x42\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\x43\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\x43\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\x43\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\x43\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\x43\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\x44\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\x44\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\x44\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x45\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x45\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x45\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\x45\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\x46\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\x46\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\x46\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\x46\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\x46\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\x46\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\x46\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\x46\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\x46\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\x46\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\x46\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\x47\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\x47\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\x45\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\x47\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\x46\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\x47\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\x47\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\x47\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\x47\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\x47\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\x48\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\x47\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\x48\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xC5\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x36"],
        ["\x48\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\x47\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\x48\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\x48\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\x48\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\x48\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\x48\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\x48\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\x48\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\x48\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\x49\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\x49\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\x49\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\x49\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\x49\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\x49\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\x49\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\x49\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\x49\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\x49\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\x4A\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\x4A\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\x4B\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\x4B\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\x4B\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\x4B\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\x4B\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\x4B\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\xD7\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x57\x3B"],
        ["\x4C\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\x4C\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\x4C\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\x4C\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\x4C\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\x4C\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\x4C\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\x4C\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\x4D\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\x4D\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\x4D\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\x4D\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\x4D\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\x4D\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\x4D\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\x4D\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\x4D\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\x4D\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\x4E\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\x4E\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\x4E\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\x4E\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\x4E\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\x4E\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\x4E\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\x4F\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\x4F\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\x4F\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\x4F\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\x4F\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\x4F\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\x4F\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\x4F\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\x50\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\x50\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\x50\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\x50\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\x51\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\x51\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\x51\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\x51\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\x51\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\x51\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\x51\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\x51\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\x51\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\x51\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\x52\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\x52\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\x53\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\x53\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\x53\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\x53\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\x53\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\x53\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\x53\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\x53\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\x53\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\x53\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\x53\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\x53\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\x53\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\x53\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\x53\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\x52\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\x54\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\x54\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\x54\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\x54\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\x54\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\x54\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\x54\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\x54\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\x55\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\x55\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\x55\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\x55\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\x55\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\x55\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\x55\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\x55\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\x55\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\x55\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\x55\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\x55\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\x53\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\x56\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\x56\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\x56\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\x56\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\x56\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\x56\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\x56\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\x56\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\x56\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\x56\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\x57\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\x57\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\x57\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\x57\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\x57\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\x57\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\x57\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\x57\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\x57\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\x56\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\x57\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\x57\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\x57\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\x58\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\x58\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\x58\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\x59\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\x59\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\x59\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\x59\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\x59\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\x59\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\x59\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\x59\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\x59\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\x59\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\x59\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\x59\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\x59\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\x59\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\x5A\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\x5A\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\x5A\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\x5A\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\x5A\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\x5A\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\x5A\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\x5A\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\x5A\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\x5A\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\x5A\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\x5B\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\x5B\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\x5B\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\x5B\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\x5B\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\x5B\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\x5B\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\x5C\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\x5C\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\x5C\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\x5C\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\x5C\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\x5B\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\x5C\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\x5C\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\x4C\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\x5C\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\x5C\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\x5C\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\x5D\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\x5D\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\x5D\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\x5D\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\x5D\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\x5D\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\x5E\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\x5E\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\x5E\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\x5E\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\x5E\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\x5E\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\x5E\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\x5E\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\x5E\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\x5E\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\x5E\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\x5E\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\x5F\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\x5F\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\x5E\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\x5E\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\x5F\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\x5F\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\x5E\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\x5E\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\x60\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\x60\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\x43\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\x60\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\x60\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\x5F\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\x60\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\x52\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\x52\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\x52\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\x52\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\x52\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\x61\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\x61\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\x61\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\x61\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\x61\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\x62\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\x62\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\x62\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\x62\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\x62\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\x63\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\x63\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\x63\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\x63\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\x63\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\x64\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\x64\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\x63\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\x64\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\x64\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\x64\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\x64\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\x64\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\x64\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\x64\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\x64\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\x64\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\x65\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\x65\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\x65\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\x65\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\x65\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\x65\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\x66\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\x66\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\x66\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD6"],
        ["\x66\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xE6"],
        ["\x66\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xE8"],
        ["\x66\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xEC"],
        ["\x44\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\x67\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xF1"],
        ["\x67\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xFE"],
        ["\x67\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\x67\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\x67\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x67\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\x67\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x67\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x67\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\x68\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\x68\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\x68\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\x68\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\x68\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\x68\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\x68\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\x68\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\x69\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\x69\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\x69\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\x69\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\x6A\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6A\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6A\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\x6A\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\x69\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x69\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6A\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\x6B\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\x6B\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\x6B\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\x6B\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\x6B\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\x69\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\x6B\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6B\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\x6B\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6B\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\x6B\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\x6B\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6B\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\x68\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\x68\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\x6B\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\x6B\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6C\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\x6C\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6C\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\x6C\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\x6C\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6C\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\x6C\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\x6C\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xC5\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x45\x3F"],
        ["\x6C\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6C\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\x6D\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\x6D\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6D\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\x6D\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\x6D\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6D\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\x6D\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\x6D\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6D\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\x6E\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\x6E\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\x6E\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\x6E\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\x6E\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\x6E\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\x6E\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\x6E\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\x6E\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\x6E\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\x6F\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\x6F\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xB9\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x39\x6D"],
        ["\xCC\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x70\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\x70\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\x70\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\x41\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\x41\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x41\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\x41\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\x42\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\x41\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\x42\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\x42\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\x42\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\x42\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\x42\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\x42\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\x42\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\x42\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\x42\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\x42\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\x42\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\x42\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\x42\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\x42\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x42\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\x4A\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4A\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\x4A\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\x4B\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\x4A\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\x4B\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\x4B\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\x4B\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\x4B\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\x4B\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4B\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\x4B\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\x4C\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\x4B\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\x4C\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x43\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\x43\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\x44\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\x44\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\x44\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x44\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\x45\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\x5F\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\x45\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\x45\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\x45\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\x46\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\x46\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\x46\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\x46\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\x46\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\x46\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\x46\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\x46\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\x46\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\x47\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\x47\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xAC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x45\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x46\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\x47\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\x47\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\x47\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\x47\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\x47\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\x48\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\x48\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x47\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\x48\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\x48\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\x48\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\x49\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\x49\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\x49\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\x49\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\x49\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\x49\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\x49\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\x49\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\x49\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\x49\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x48\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\x49\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x49\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\x4A\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\x4A\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4C\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\x4C\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\x4D\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\x4D\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\x4D\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\x4D\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\x4D\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\x4D\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\x4D\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\x4D\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\x4E\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\x4E\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\x4E\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\x4E\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\x4E\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\x4E\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\x4D\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\x4D\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4D\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\x4E\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\x4E\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4E\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\x4F\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\x4F\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\x4F\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\x4F\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\x4F\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\x4F\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\x4F\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\x4F\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\x4F\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\x4F\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x4F\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\x4F\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\x4F\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\x50\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\x50\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\x50\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x50\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\x51\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\x51\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\x51\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\x51\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\x50\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\x51\xA5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\x51\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\x51\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\x51\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\x51\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\x51\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\x51\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\x51\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x51\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\x52\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\x53\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\x52\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\x53\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\x53\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\x52\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\x53\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\x53\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\x53\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x53\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\x53\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\x53\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\x53\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\x52\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\x53\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\x54\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\x54\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\x54\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\x54\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\x54\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\x54\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x54\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\x55\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\x54\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\x55\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\x55\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\x55\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\x55\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\x55\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\x55\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\x55\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\x55\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\x55\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\x55\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x55\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\x56\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\x56\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\x56\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\x56\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\x56\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\x56\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\x56\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\x56\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\x56\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x56\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\x56\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\x57\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\x57\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\x57\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\x57\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\x57\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\x57\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\x57\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\x57\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\x57\xE4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\x57\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\x57\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\x57\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\x57\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\x57\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x57\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x72\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\x58\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\x58\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\x58\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x58\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\x58\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\x59\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\x59\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\x59\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\x59\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\x59\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\x59\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\x59\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\x59\xCD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\x59\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\x59\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\x59\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\x59\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\x59\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x59\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\x59\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\x5A\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\x5A\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xC9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\x5A\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\x5A\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\x5A\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\x5A\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\x5A\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5A\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\x5A\xED",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\x5A\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\x5B\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\x5B\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\x5B\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5B\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\x5B\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\x5B\xE5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\x5B\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\x5B\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\x5B\xF6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\x5B\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\x5B\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\x5C\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\x5B\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\x5C\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\x5C\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\x5C\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\x5C\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\x5C\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\x5C\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x72\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\x5C\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\x5C\xF2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\x5C\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5C\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\x5D\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\x5D\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\x5D\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\x5D\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\x5D\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xBD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\x5D\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xC3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\x5D\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xD5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xE2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5D\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\x5D\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\x5D\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\x5D\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\x5E\xA2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\x5E\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\x5E\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\x5E\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xB5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\x5E\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\x5E\xD4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\x5E\xEA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\x5E\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\x5E\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\x5E\xF9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5E\xFC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\x5F\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\x5F\xB3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\x5F\xB8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\x5F\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\x5F\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\x5F\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\x5F\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xE7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\x5F\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x5F\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\x5F\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\x5F\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\x5F\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\x60\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\x60\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\x60\xB0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\x60\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xC6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\x60\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\x52\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xB7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\x52\xC4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\x52\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x52\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\x52\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\x61\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\x61\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\x61\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x60\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xDD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x61\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xA4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xAD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xAE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\x62\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\x62\xB2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\x62\xB4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\x62\xB6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\x62\xCB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xD0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xE6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xEE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x62\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\x63\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\x63\xC5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xC8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\x63\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xCE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\x63\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\x63\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xDB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\x63\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\x63\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x63\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\x63\xF0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\x64\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\x63\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\x64\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xC7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\x64\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xE3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\x64\xEB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\x64\xF1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\x64\xF7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\x65\xB1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\x65\xB9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\x65\xC1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xBF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xC2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x64\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xD2",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xD3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x65\xD8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\x65\xDA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\x65\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\x65\xE0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\x65\xFB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xA6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\x66\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\x66\xBC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\x66\xBE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xC0",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xCC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x66\xD6",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x67\xD9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\x69\xF3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\x6A\xA1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\x6A\xA3",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6A\xEC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6B\xDE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\x68\xBA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x68\xCA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\x6C\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\x6D\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xCF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\x6E\xD1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xDC",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\x6E\xE1",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\x6E\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xE9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xF4",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\x6E\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xF8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\x6E\xFA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6E\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\x6F\xA7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\x6F\xA8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\x6F\xA9",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\x6F\xAA",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xAB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xAF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\x6F\xBB",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xD7",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xDF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xE8",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\x6F\xEF",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xF5",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\x6F\xFD",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x6F\xFE",'jipsj','jef',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
