######################################################################
#
# 2152_jipsj_by_utf8jp.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\xF3\xB0\x80\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\xF3\xB0\x80\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\xF3\xB0\x80\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\xF3\xB0\x80\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\xF3\xB0\x80\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\xF3\xB0\x80\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\xF3\xB0\x80\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\xF3\xB0\x80\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\xF3\xB0\x80\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\xF3\xB0\x80\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\xF3\xB0\x80\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\xF3\xB0\x80\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\xF3\xB0\x80\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\xF3\xB0\x80\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\xF3\xB0\x80\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\xF3\xB0\x80\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\xF3\xB0\x80\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\xF3\xB0\x80\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\xF3\xB0\x80\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\xF3\xB0\x80\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\xF3\xB0\x80\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\xF3\xB0\x80\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\xF3\xB0\x80\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\xF3\xB0\x80\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\xF3\xB0\x80\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\xF3\xB0\x80\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\xF3\xB0\x80\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\xF3\xB0\x80\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\xF3\xB0\x80\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\xF3\xB0\x80\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\xF3\xB0\x80\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\xF3\xB0\x80\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\xF3\xB0\x80\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\xF3\xB0\x80\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\xF3\xB0\x80\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\xF3\xB0\x80\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\xF3\xB0\x80\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\xF3\xB0\x80\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\xF3\xB0\x80\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\xF3\xB0\x80\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\xF3\xB0\x80\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\xF3\xB0\x80\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\xF3\xB0\x80\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\xF3\xB0\x80\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\xF3\xB0\x80\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\xF3\xB0\x80\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\xF3\xB0\x80\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\xF3\xB0\x80\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\xF3\xB0\x80\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\xF3\xB0\x80\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\xF3\xB0\x80\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\xF3\xB0\x80\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\xF3\xB0\x80\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\xF3\xB0\x80\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\xF3\xB0\x80\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\xF3\xB0\x80\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\xF3\xB0\x80\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\xF3\xB0\x80\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\xF3\xB0\x80\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\xF3\xB0\x80\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\xF3\xB0\x80\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\xF3\xB0\x80\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\xF3\xB0\x80\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\xF3\xB0\x81\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\xF3\xB0\x81\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xF3\xB0\x81\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xF3\xB0\x81\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xF3\xB0\x81\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xF3\xB0\x81\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xF3\xB0\x81\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xF3\xB0\x81\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xF3\xB0\x81\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xF3\xB0\x81\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xF3\xB0\x81\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\xF3\xB0\x81\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\xF3\xB0\x81\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\xF3\xB0\x81\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\xF3\xB0\x81\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\xF3\xB0\x81\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\xF3\xB0\x81\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\xF3\xB0\x81\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xF3\xB0\x81\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xF3\xB0\x81\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xF3\xB0\x81\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xF3\xB0\x81\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xF3\xB0\x81\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xF3\xB0\x81\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\xF3\xB0\x81\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xF3\xB0\x81\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\xF3\xB0\x81\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\xF3\xB0\x81\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\xF3\xB0\x81\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\xF3\xB0\x81\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\xF3\xB0\x81\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\xF3\xB0\x81\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\xF3\xB0\x81\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\xF3\xB0\x81\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\xF3\xB0\x81\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\xF3\xB0\x81\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\xF3\xB0\x81\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\xF3\xB0\x81\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\xF3\xB0\x81\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\xF3\xB0\x81\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\xF3\xB0\x81\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\xF3\xB0\x81\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\xF3\xB0\x81\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\xF3\xB0\x81\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\xF3\xB0\x81\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\xF3\xB0\x81\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\xF3\xB0\x81\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\xF3\xB0\x81\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\xF3\xB0\x81\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\xF3\xB0\x81\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\xF3\xB0\x81\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\xF3\xB0\x81\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\xF3\xB0\x81\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\xF3\xB0\x81\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\xF3\xB0\x81\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\xF3\xB0\x81\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\xF3\xB0\x81\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\xF3\xB0\x81\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\xF3\xB0\x81\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\xF3\xB0\x81\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\xF3\xB0\x81\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\xF3\xB0\x81\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\xF3\xB0\x81\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\xF3\xB0\x81\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F"],
        ["\xF3\xB0\x82\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80"],
        ["\xF3\xB0\x82\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xF3\xB0\x82\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xF3\xB0\x82\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xF3\xB0\x82\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xF3\xB0\x82\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xF3\xB0\x82\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xF3\xB0\x82\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xF3\xB0\x82\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xF3\xB0\x82\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xF3\xB0\x82\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xF3\xB0\x82\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B"],
        ["\xF3\xB0\x82\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xF3\xB0\x82\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xF3\xB0\x82\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xF3\xB0\x82\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xF3\xB0\x82\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xF3\xB0\x82\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xF3\xB0\x82\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xF3\xB0\x82\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xF3\xB0\x82\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xF3\xB0\x82\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xF3\xB0\x82\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xF3\xB0\x82\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xF3\xB0\x82\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xF3\xB0\x82\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xF3\xB0\x82\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xF3\xB0\x82\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B"],
        ["\xF3\xB0\x82\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C"],
        ["\xF3\xB0\x82\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xF3\xB0\x82\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xF3\xB0\x82\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xF3\xB0\x82\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA0"],
        ["\xF3\xB0\x82\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xF3\xB0\x82\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xF3\xB0\x82\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xF3\xB0\x82\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xF3\xB0\x82\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xF3\xB0\x82\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xF3\xB0\x82\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xF3\xB0\x82\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xF3\xB0\x82\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xF3\xB0\x82\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xF3\xB0\x82\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xF3\xB0\x82\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xF3\xB0\x82\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xF3\xB0\x82\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xF3\xB0\x82\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xF3\xB0\x82\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xF3\xB0\x82\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xF3\xB0\x82\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xF3\xB0\x82\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xF3\xB0\x82\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xF3\xB0\x82\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xF3\xB0\x82\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xF3\xB0\x82\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xF3\xB0\x82\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xF3\xB0\x82\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xF3\xB0\x82\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xF3\xB0\x82\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xF3\xB0\x82\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xF3\xB0\x82\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xF3\xB0\x82\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xF3\xB0\x82\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xF3\xB0\x83\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xF3\xB0\x83\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xF3\xB0\x83\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xF3\xB0\x83\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xF3\xB0\x83\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xF3\xB0\x83\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xF3\xB0\x83\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xF3\xB0\x83\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xF3\xB0\x83\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xF3\xB0\x83\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xF3\xB0\x83\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xF3\xB0\x83\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xF3\xB0\x83\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xF3\xB0\x83\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xF3\xB0\x83\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xF3\xB0\x83\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xF3\xB0\x83\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xF3\xB0\x83\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xF3\xB0\x83\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xF3\xB0\x83\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xF3\xB0\x83\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xF3\xB0\x83\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xF3\xB0\x83\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xF3\xB0\x83\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xF3\xB0\x83\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xF3\xB0\x83\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xF3\xB0\x83\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xF3\xB0\x83\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xF3\xB0\x83\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xF3\xB0\x83\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xF3\xB0\x83\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xF3\xB0\x83\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xF3\xB0\x83\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0"],
        ["\xF3\xB0\x83\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1"],
        ["\xF3\xB0\x83\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2"],
        ["\xF3\xB0\x83\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3"],
        ["\xF3\xB0\x83\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4"],
        ["\xF3\xB0\x83\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5"],
        ["\xF3\xB0\x83\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6"],
        ["\xF3\xB0\x83\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7"],
        ["\xF3\xB0\x83\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8"],
        ["\xF3\xB0\x83\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9"],
        ["\xF3\xB0\x83\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA"],
        ["\xF3\xB0\x83\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB"],
        ["\xF3\xB0\x83\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC"],
        ["\xF3\xB0\x83\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED"],
        ["\xF3\xB0\x83\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE"],
        ["\xF3\xB0\x83\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF"],
        ["\xF3\xB0\x83\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0"],
        ["\xF3\xB0\x83\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1"],
        ["\xF3\xB0\x83\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2"],
        ["\xF3\xB0\x83\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3"],
        ["\xF3\xB0\x83\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4"],
        ["\xF3\xB0\x83\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5"],
        ["\xF3\xB0\x83\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6"],
        ["\xF3\xB0\x83\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7"],
        ["\xF3\xB0\x83\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8"],
        ["\xF3\xB0\x83\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9"],
        ["\xF3\xB0\x83\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA"],
        ["\xF3\xB0\x83\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB"],
        ["\xF3\xB0\x83\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC"],
        ["\xF3\xB0\x83\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFD"],
        ["\xF3\xB0\x83\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFE"],
        ["\xF3\xB0\x83\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFF"],
        ["\xF3\xB0\x84\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x21"],
        ["\xF3\xB0\x84\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x22"],
        ["\xF3\xB0\x84\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x23"],
        ["\xF3\xB0\x84\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x24"],
        ["\xF3\xB0\x84\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x25"],
        ["\xF3\xB0\x84\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x26"],
        ["\xF3\xB0\x84\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x27"],
        ["\xF3\xB0\x84\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x28"],
        ["\xF3\xB0\x84\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x29"],
        ["\xF3\xB0\x84\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2A"],
        ["\xF3\xB0\x84\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2B"],
        ["\xF3\xB0\x84\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2C"],
        ["\xF3\xB0\x84\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2D"],
        ["\xF3\xB0\x84\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2E"],
        ["\xF3\xB0\x84\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x2F"],
        ["\xF3\xB0\x84\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x30"],
        ["\xF3\xB0\x84\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x31"],
        ["\xF3\xB0\x84\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x32"],
        ["\xF3\xB0\x84\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x33"],
        ["\xF3\xB0\x84\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x34"],
        ["\xF3\xB0\x84\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x35"],
        ["\xF3\xB0\x84\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x36"],
        ["\xF3\xB0\x84\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x37"],
        ["\xF3\xB0\x84\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x38"],
        ["\xF3\xB0\x84\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x39"],
        ["\xF3\xB0\x84\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3A"],
        ["\xF3\xB0\x84\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3B"],
        ["\xF3\xB0\x84\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3C"],
        ["\xF3\xB0\x84\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3D"],
        ["\xF3\xB0\x84\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3E"],
        ["\xF3\xB0\x84\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x3F"],
        ["\xF3\xB0\x84\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x40"],
        ["\xF3\xB0\x84\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x41"],
        ["\xF3\xB0\x84\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x42"],
        ["\xF3\xB0\x84\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x43"],
        ["\xF3\xB0\x84\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x44"],
        ["\xF3\xB0\x84\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x45"],
        ["\xF3\xB0\x84\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x46"],
        ["\xF3\xB0\x84\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x47"],
        ["\xF3\xB0\x84\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x48"],
        ["\xF3\xB0\x84\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x49"],
        ["\xF3\xB0\x84\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4A"],
        ["\xF3\xB0\x84\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4B"],
        ["\xF3\xB0\x84\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4C"],
        ["\xF3\xB0\x84\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4D"],
        ["\xF3\xB0\x84\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4E"],
        ["\xF3\xB0\x84\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x4F"],
        ["\xF3\xB0\x84\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x50"],
        ["\xF3\xB0\x84\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x51"],
        ["\xF3\xB0\x84\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x52"],
        ["\xF3\xB0\x84\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x53"],
        ["\xF3\xB0\x84\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x54"],
        ["\xF3\xB0\x84\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x55"],
        ["\xF3\xB0\x84\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x56"],
        ["\xF3\xB0\x84\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x57"],
        ["\xF3\xB0\x84\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x58"],
        ["\xF3\xB0\x84\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x59"],
        ["\xF3\xB0\x84\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5A"],
        ["\xF3\xB0\x84\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5B"],
        ["\xF3\xB0\x84\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5C"],
        ["\xF3\xB0\x84\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5D"],
        ["\xF3\xB0\x84\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5E"],
        ["\xF3\xB0\x84\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x5F"],
        ["\xF3\xB0\x84\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x60"],
        ["\xF3\xB0\x85\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x61"],
        ["\xF3\xB0\x85\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x62"],
        ["\xF3\xB0\x85\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x63"],
        ["\xF3\xB0\x85\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x64"],
        ["\xF3\xB0\x85\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x65"],
        ["\xF3\xB0\x85\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x66"],
        ["\xF3\xB0\x85\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x67"],
        ["\xF3\xB0\x85\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x68"],
        ["\xF3\xB0\x85\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x69"],
        ["\xF3\xB0\x85\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6A"],
        ["\xF3\xB0\x85\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6B"],
        ["\xF3\xB0\x85\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6C"],
        ["\xF3\xB0\x85\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6D"],
        ["\xF3\xB0\x85\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6E"],
        ["\xF3\xB0\x85\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x6F"],
        ["\xF3\xB0\x85\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x70"],
        ["\xF3\xB0\x85\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x71"],
        ["\xF3\xB0\x85\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x72"],
        ["\xF3\xB0\x85\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x73"],
        ["\xF3\xB0\x85\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x74"],
        ["\xF3\xB0\x85\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x75"],
        ["\xF3\xB0\x85\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x76"],
        ["\xF3\xB0\x85\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x77"],
        ["\xF3\xB0\x85\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x78"],
        ["\xF3\xB0\x85\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x79"],
        ["\xF3\xB0\x85\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x7A"],
        ["\xF3\xB0\x85\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x7B"],
        ["\xF3\xB0\x85\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x7C"],
        ["\xF3\xB0\x85\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x7D"],
        ["\xF3\xB0\x85\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21\x7E"],
        ["\xF3\xB0\x85\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x21"],
        ["\xF3\xB0\x85\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x22"],
        ["\xF3\xB0\x85\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x23"],
        ["\xF3\xB0\x85\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x24"],
        ["\xF3\xB0\x85\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x25"],
        ["\xF3\xB0\x85\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x26"],
        ["\xF3\xB0\x85\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x27"],
        ["\xF3\xB0\x85\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x28"],
        ["\xF3\xB0\x85\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x29"],
        ["\xF3\xB0\x85\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x2A"],
        ["\xF3\xB0\x85\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x2B"],
        ["\xF3\xB0\x85\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x2C"],
        ["\xF3\xB0\x85\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x2D"],
        ["\xF3\xB0\x85\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\xF3\xB0\x85\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xF3\xB0\x85\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xF3\xB0\x85\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF4"],
        ["\xF3\xB0\x85\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF5"],
        ["\xF3\xB0\x85\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xF3\xB0\x85\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xF3\xB0\x85\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x7C"],
        ["\xF3\xB0\x85\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x7B"],
        ["\xF3\xB0\x86\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xF3\xB0\x86\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xF3\xB0\x86\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF6"],
        ["\xF3\xB0\x86\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF7"],
        ["\xF3\xB0\x86\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xF3\xB0\x86\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xF3\xB0\x86\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x77"],
        ["\xF3\xB0\x86\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x76"],
        ["\xF3\xB0\x86\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF8"],
        ["\xF3\xB0\x86\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xF3\xB0\x86\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xF9"],
        ["\xF3\xB0\x86\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x71"],
        ["\xF3\xB0\x86\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x70"],
        ["\xF3\xB0\x86\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xF3\xB0\x86\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xF3\xB0\x86\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x75"],
        ["\xF3\xB0\x86\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xF3\xB0\x86\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xF3\xB0\x86\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x7A"],
        ["\xF3\xB0\x86\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x72"],
        ["\xF3\xB0\x86\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFA"],
        ["\xF3\xB0\x86\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xF3\xB0\x86\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xFE"],
        ["\xF3\xB0\x86\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFB"],
        ["\xF3\xB0\x86\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFC"],
        ["\xF3\xB0\x86\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFD"],
        ["\xF3\xB0\x86\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xF3\xB0\x86\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xF3\xB0\x86\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xF3\xB0\x86\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFE"],
        ["\xF3\xB0\x87\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x30"],
        ["\xF3\xB0\x87\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x31"],
        ["\xF3\xB0\x87\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x32"],
        ["\xF3\xB0\x87\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x33"],
        ["\xF3\xB0\x87\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x34"],
        ["\xF3\xB0\x87\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x35"],
        ["\xF3\xB0\x87\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x36"],
        ["\xF3\xB0\x87\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x37"],
        ["\xF3\xB0\x87\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x38"],
        ["\xF3\xB0\x87\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x39"],
        ["\xF3\xB0\x87\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x41"],
        ["\xF3\xB0\x87\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x42"],
        ["\xF3\xB0\x87\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x43"],
        ["\xF3\xB0\x87\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x44"],
        ["\xF3\xB0\x87\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x45"],
        ["\xF3\xB0\x87\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x46"],
        ["\xF3\xB0\x87\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x47"],
        ["\xF3\xB0\x87\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x48"],
        ["\xF3\xB0\x87\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x49"],
        ["\xF3\xB0\x87\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4A"],
        ["\xF3\xB0\x87\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4B"],
        ["\xF3\xB0\x87\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4C"],
        ["\xF3\xB0\x87\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4D"],
        ["\xF3\xB0\x87\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4E"],
        ["\xF3\xB0\x87\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x4F"],
        ["\xF3\xB0\x87\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x50"],
        ["\xF3\xB0\x87\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x51"],
        ["\xF3\xB0\x87\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x52"],
        ["\xF3\xB0\x87\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x53"],
        ["\xF3\xB0\x87\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x54"],
        ["\xF3\xB0\x87\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x55"],
        ["\xF3\xB0\x87\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x56"],
        ["\xF3\xB0\x87\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x57"],
        ["\xF3\xB0\x87\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x58"],
        ["\xF3\xB0\x87\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x59"],
        ["\xF3\xB0\x87\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x5A"],
        ["\xF3\xB0\x87\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x61"],
        ["\xF3\xB0\x87\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x62"],
        ["\xF3\xB0\x87\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x63"],
        ["\xF3\xB0\x87\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x64"],
        ["\xF3\xB0\x88\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x65"],
        ["\xF3\xB0\x88\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x66"],
        ["\xF3\xB0\x88\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x67"],
        ["\xF3\xB0\x88\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x68"],
        ["\xF3\xB0\x88\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x69"],
        ["\xF3\xB0\x88\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6A"],
        ["\xF3\xB0\x88\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6B"],
        ["\xF3\xB0\x88\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6C"],
        ["\xF3\xB0\x88\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6D"],
        ["\xF3\xB0\x88\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6E"],
        ["\xF3\xB0\x88\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x6F"],
        ["\xF3\xB0\x88\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x70"],
        ["\xF3\xB0\x88\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x71"],
        ["\xF3\xB0\x88\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x72"],
        ["\xF3\xB0\x88\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x73"],
        ["\xF3\xB0\x88\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x74"],
        ["\xF3\xB0\x88\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x75"],
        ["\xF3\xB0\x88\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x76"],
        ["\xF3\xB0\x88\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x77"],
        ["\xF3\xB0\x88\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x78"],
        ["\xF3\xB0\x88\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x79"],
        ["\xF3\xB0\x88\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23\x7A"],
        ["\xF3\xB0\x88\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x21"],
        ["\xF3\xB0\x88\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x22"],
        ["\xF3\xB0\x88\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x23"],
        ["\xF3\xB0\x88\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x24"],
        ["\xF3\xB0\x88\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x25"],
        ["\xF3\xB0\x88\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x26"],
        ["\xF3\xB0\x88\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x27"],
        ["\xF3\xB0\x88\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x28"],
        ["\xF3\xB0\x88\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x29"],
        ["\xF3\xB0\x88\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2A"],
        ["\xF3\xB0\x88\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2B"],
        ["\xF3\xB0\x88\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2C"],
        ["\xF3\xB0\x88\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2D"],
        ["\xF3\xB0\x88\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2E"],
        ["\xF3\xB0\x88\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x2F"],
        ["\xF3\xB0\x88\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x30"],
        ["\xF3\xB0\x88\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x31"],
        ["\xF3\xB0\x88\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x32"],
        ["\xF3\xB0\x88\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x33"],
        ["\xF3\xB0\x88\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x34"],
        ["\xF3\xB0\x88\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x35"],
        ["\xF3\xB0\x88\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x36"],
        ["\xF3\xB0\x88\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x37"],
        ["\xF3\xB0\x88\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x38"],
        ["\xF3\xB0\x88\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x39"],
        ["\xF3\xB0\x88\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3A"],
        ["\xF3\xB0\x88\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3B"],
        ["\xF3\xB0\x88\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3C"],
        ["\xF3\xB0\x88\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3D"],
        ["\xF3\xB0\x88\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3E"],
        ["\xF3\xB0\x88\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x3F"],
        ["\xF3\xB0\x88\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x40"],
        ["\xF3\xB0\x88\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x41"],
        ["\xF3\xB0\x88\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x42"],
        ["\xF3\xB0\x88\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x43"],
        ["\xF3\xB0\x88\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x44"],
        ["\xF3\xB0\x88\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x45"],
        ["\xF3\xB0\x88\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x46"],
        ["\xF3\xB0\x89\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x47"],
        ["\xF3\xB0\x89\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x48"],
        ["\xF3\xB0\x89\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x49"],
        ["\xF3\xB0\x89\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4A"],
        ["\xF3\xB0\x89\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4B"],
        ["\xF3\xB0\x89\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4C"],
        ["\xF3\xB0\x89\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4D"],
        ["\xF3\xB0\x89\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4E"],
        ["\xF3\xB0\x89\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x4F"],
        ["\xF3\xB0\x89\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x50"],
        ["\xF3\xB0\x89\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x51"],
        ["\xF3\xB0\x89\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x52"],
        ["\xF3\xB0\x89\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x53"],
        ["\xF3\xB0\x89\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x54"],
        ["\xF3\xB0\x89\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x55"],
        ["\xF3\xB0\x89\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x56"],
        ["\xF3\xB0\x89\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x57"],
        ["\xF3\xB0\x89\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x58"],
        ["\xF3\xB0\x89\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x59"],
        ["\xF3\xB0\x89\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5A"],
        ["\xF3\xB0\x89\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5B"],
        ["\xF3\xB0\x89\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5C"],
        ["\xF3\xB0\x89\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5D"],
        ["\xF3\xB0\x89\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5E"],
        ["\xF3\xB0\x89\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x5F"],
        ["\xF3\xB0\x89\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x60"],
        ["\xF3\xB0\x89\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x61"],
        ["\xF3\xB0\x89\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x62"],
        ["\xF3\xB0\x89\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x63"],
        ["\xF3\xB0\x89\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x64"],
        ["\xF3\xB0\x89\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x65"],
        ["\xF3\xB0\x89\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x66"],
        ["\xF3\xB0\x89\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x67"],
        ["\xF3\xB0\x89\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x68"],
        ["\xF3\xB0\x89\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x69"],
        ["\xF3\xB0\x89\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6A"],
        ["\xF3\xB0\x89\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6B"],
        ["\xF3\xB0\x89\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6C"],
        ["\xF3\xB0\x89\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6D"],
        ["\xF3\xB0\x89\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6E"],
        ["\xF3\xB0\x89\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x6F"],
        ["\xF3\xB0\x89\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x70"],
        ["\xF3\xB0\x89\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x71"],
        ["\xF3\xB0\x89\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x72"],
        ["\xF3\xB0\x89\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24\x73"],
        ["\xF3\xB0\x89\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x21"],
        ["\xF3\xB0\x89\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x22"],
        ["\xF3\xB0\x89\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x23"],
        ["\xF3\xB0\x89\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x24"],
        ["\xF3\xB0\x89\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x25"],
        ["\xF3\xB0\x89\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x26"],
        ["\xF3\xB0\x89\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x27"],
        ["\xF3\xB0\x89\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x28"],
        ["\xF3\xB0\x8A\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x29"],
        ["\xF3\xB0\x8A\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2A"],
        ["\xF3\xB0\x8A\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2B"],
        ["\xF3\xB0\x8A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2C"],
        ["\xF3\xB0\x8A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2D"],
        ["\xF3\xB0\x8A\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2E"],
        ["\xF3\xB0\x8A\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x2F"],
        ["\xF3\xB0\x8A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x30"],
        ["\xF3\xB0\x8A\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x31"],
        ["\xF3\xB0\x8A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x32"],
        ["\xF3\xB0\x8A\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x33"],
        ["\xF3\xB0\x8A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x34"],
        ["\xF3\xB0\x8A\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x35"],
        ["\xF3\xB0\x8A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x36"],
        ["\xF3\xB0\x8A\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x37"],
        ["\xF3\xB0\x8A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x38"],
        ["\xF3\xB0\x8A\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x39"],
        ["\xF3\xB0\x8A\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3A"],
        ["\xF3\xB0\x8A\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3B"],
        ["\xF3\xB0\x8A\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3C"],
        ["\xF3\xB0\x8A\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3D"],
        ["\xF3\xB0\x8A\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3E"],
        ["\xF3\xB0\x8A\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x3F"],
        ["\xF3\xB0\x8A\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x40"],
        ["\xF3\xB0\x8A\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x41"],
        ["\xF3\xB0\x8A\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x42"],
        ["\xF3\xB0\x8A\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x43"],
        ["\xF3\xB0\x8A\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x44"],
        ["\xF3\xB0\x8A\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x45"],
        ["\xF3\xB0\x8A\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x46"],
        ["\xF3\xB0\x8A\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x47"],
        ["\xF3\xB0\x8A\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x48"],
        ["\xF3\xB0\x8A\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x49"],
        ["\xF3\xB0\x8A\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4A"],
        ["\xF3\xB0\x8A\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4B"],
        ["\xF3\xB0\x8A\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4C"],
        ["\xF3\xB0\x8A\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4D"],
        ["\xF3\xB0\x8A\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4E"],
        ["\xF3\xB0\x8A\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x4F"],
        ["\xF3\xB0\x8A\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x50"],
        ["\xF3\xB0\x8A\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x51"],
        ["\xF3\xB0\x8A\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x52"],
        ["\xF3\xB0\x8A\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x53"],
        ["\xF3\xB0\x8A\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x54"],
        ["\xF3\xB0\x8A\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x55"],
        ["\xF3\xB0\x8A\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x56"],
        ["\xF3\xB0\x8A\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x57"],
        ["\xF3\xB0\x8A\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x58"],
        ["\xF3\xB0\x8A\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x59"],
        ["\xF3\xB0\x8A\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5A"],
        ["\xF3\xB0\x8A\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5B"],
        ["\xF3\xB0\x8A\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5C"],
        ["\xF3\xB0\x8A\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5D"],
        ["\xF3\xB0\x8A\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5E"],
        ["\xF3\xB0\x8A\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x5F"],
        ["\xF3\xB0\x8A\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x60"],
        ["\xF3\xB0\x8A\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x61"],
        ["\xF3\xB0\x8A\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x62"],
        ["\xF3\xB0\x8A\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x63"],
        ["\xF3\xB0\x8A\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x64"],
        ["\xF3\xB0\x8A\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x65"],
        ["\xF3\xB0\x8A\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x66"],
        ["\xF3\xB0\x8A\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x67"],
        ["\xF3\xB0\x8A\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x68"],
        ["\xF3\xB0\x8B\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x69"],
        ["\xF3\xB0\x8B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6A"],
        ["\xF3\xB0\x8B\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6B"],
        ["\xF3\xB0\x8B\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6C"],
        ["\xF3\xB0\x8B\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6D"],
        ["\xF3\xB0\x8B\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6E"],
        ["\xF3\xB0\x8B\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x6F"],
        ["\xF3\xB0\x8B\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x70"],
        ["\xF3\xB0\x8B\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x71"],
        ["\xF3\xB0\x8B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x72"],
        ["\xF3\xB0\x8B\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x73"],
        ["\xF3\xB0\x8B\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x74"],
        ["\xF3\xB0\x8B\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x75"],
        ["\xF3\xB0\x8B\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25\x76"],
        ["\xF3\xB0\x8B\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x21"],
        ["\xF3\xB0\x8B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x22"],
        ["\xF3\xB0\x8B\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x23"],
        ["\xF3\xB0\x8B\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x24"],
        ["\xF3\xB0\x8B\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x25"],
        ["\xF3\xB0\x8B\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x26"],
        ["\xF3\xB0\x8B\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x27"],
        ["\xF3\xB0\x8B\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x28"],
        ["\xF3\xB0\x8B\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x29"],
        ["\xF3\xB0\x8B\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2A"],
        ["\xF3\xB0\x8B\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2B"],
        ["\xF3\xB0\x8B\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2C"],
        ["\xF3\xB0\x8B\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2D"],
        ["\xF3\xB0\x8B\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2E"],
        ["\xF3\xB0\x8B\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x2F"],
        ["\xF3\xB0\x8B\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x30"],
        ["\xF3\xB0\x8B\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x31"],
        ["\xF3\xB0\x8B\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x32"],
        ["\xF3\xB0\x8B\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x33"],
        ["\xF3\xB0\x8B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x34"],
        ["\xF3\xB0\x8B\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x35"],
        ["\xF3\xB0\x8B\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x36"],
        ["\xF3\xB0\x8B\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x37"],
        ["\xF3\xB0\x8B\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x38"],
        ["\xF3\xB0\x8B\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x41"],
        ["\xF3\xB0\x8B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x42"],
        ["\xF3\xB0\x8B\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x43"],
        ["\xF3\xB0\x8B\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x44"],
        ["\xF3\xB0\x8B\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x45"],
        ["\xF3\xB0\x8B\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x46"],
        ["\xF3\xB0\x8B\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x47"],
        ["\xF3\xB0\x8B\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x48"],
        ["\xF3\xB0\x8B\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x49"],
        ["\xF3\xB0\x8B\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4A"],
        ["\xF3\xB0\x8C\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4B"],
        ["\xF3\xB0\x8C\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4C"],
        ["\xF3\xB0\x8C\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4D"],
        ["\xF3\xB0\x8C\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4E"],
        ["\xF3\xB0\x8C\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x4F"],
        ["\xF3\xB0\x8C\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x50"],
        ["\xF3\xB0\x8C\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x51"],
        ["\xF3\xB0\x8C\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x52"],
        ["\xF3\xB0\x8C\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x53"],
        ["\xF3\xB0\x8C\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x54"],
        ["\xF3\xB0\x8C\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x55"],
        ["\xF3\xB0\x8C\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x56"],
        ["\xF3\xB0\x8C\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x57"],
        ["\xF3\xB0\x8C\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26\x58"],
        ["\xF3\xB0\x8C\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x21"],
        ["\xF3\xB0\x8C\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x22"],
        ["\xF3\xB0\x8C\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x23"],
        ["\xF3\xB0\x8C\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x24"],
        ["\xF3\xB0\x8C\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x25"],
        ["\xF3\xB0\x8C\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x26"],
        ["\xF3\xB0\x8C\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x27"],
        ["\xF3\xB0\x8C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x28"],
        ["\xF3\xB0\x8C\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x29"],
        ["\xF3\xB0\x8C\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2A"],
        ["\xF3\xB0\x8C\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2B"],
        ["\xF3\xB0\x8C\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2C"],
        ["\xF3\xB0\x8D\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2D"],
        ["\xF3\xB0\x8D\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2E"],
        ["\xF3\xB0\x8D\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x2F"],
        ["\xF3\xB0\x8D\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x30"],
        ["\xF3\xB0\x8D\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x31"],
        ["\xF3\xB0\x8D\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x32"],
        ["\xF3\xB0\x8D\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x33"],
        ["\xF3\xB0\x8D\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x34"],
        ["\xF3\xB0\x8D\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x35"],
        ["\xF3\xB0\x8D\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x36"],
        ["\xF3\xB0\x8D\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x37"],
        ["\xF3\xB0\x8D\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x38"],
        ["\xF3\xB0\x8D\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x39"],
        ["\xF3\xB0\x8D\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3A"],
        ["\xF3\xB0\x8D\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3B"],
        ["\xF3\xB0\x8D\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3C"],
        ["\xF3\xB0\x8D\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3D"],
        ["\xF3\xB0\x8D\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3E"],
        ["\xF3\xB0\x8D\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x3F"],
        ["\xF3\xB0\x8D\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x40"],
        ["\xF3\xB0\x8D\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x41"],
        ["\xF3\xB0\x8D\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x51"],
        ["\xF3\xB0\x8D\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x52"],
        ["\xF3\xB0\x8D\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x53"],
        ["\xF3\xB0\x8D\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x54"],
        ["\xF3\xB0\x8D\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x55"],
        ["\xF3\xB0\x8D\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x56"],
        ["\xF3\xB0\x8D\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x57"],
        ["\xF3\xB0\x8D\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x58"],
        ["\xF3\xB0\x8D\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x59"],
        ["\xF3\xB0\x8D\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5A"],
        ["\xF3\xB0\x8D\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5B"],
        ["\xF3\xB0\x8D\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5C"],
        ["\xF3\xB0\x8D\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5D"],
        ["\xF3\xB0\x8D\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5E"],
        ["\xF3\xB0\x8D\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x5F"],
        ["\xF3\xB0\x8D\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x60"],
        ["\xF3\xB0\x8D\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x61"],
        ["\xF3\xB0\x8D\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x62"],
        ["\xF3\xB0\x8D\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x63"],
        ["\xF3\xB0\x8D\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x64"],
        ["\xF3\xB0\x8D\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x65"],
        ["\xF3\xB0\x8D\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x66"],
        ["\xF3\xB0\x8D\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x67"],
        ["\xF3\xB0\x8D\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x68"],
        ["\xF3\xB0\x8D\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x69"],
        ["\xF3\xB0\x8D\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6A"],
        ["\xF3\xB0\x8D\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6B"],
        ["\xF3\xB0\x8D\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6C"],
        ["\xF3\xB0\x8E\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6D"],
        ["\xF3\xB0\x8E\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6E"],
        ["\xF3\xB0\x8E\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x6F"],
        ["\xF3\xB0\x8E\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x70"],
        ["\xF3\xB0\x8E\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27\x71"],
        ["\xF3\xB0\x8E\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x24"],
        ["\xF3\xB0\x8E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x26"],
        ["\xF3\xB0\x8E\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x30"],
        ["\xF3\xB0\x8E\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x34"],
        ["\xF3\xB0\x8E\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x3C"],
        ["\xF3\xB0\x8E\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x38"],
        ["\xF3\xB0\x8E\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x40"],
        ["\xF3\xB0\x8E\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x50"],
        ["\xF3\xB0\x8E\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x48"],
        ["\xF3\xB0\x8E\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x58"],
        ["\xF3\xB0\x8E\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x60"],
        ["\xF3\xB0\x8E\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x25"],
        ["\xF3\xB0\x8E\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x27"],
        ["\xF3\xB0\x8E\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x33"],
        ["\xF3\xB0\x8E\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x37"],
        ["\xF3\xB0\x8E\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x3F"],
        ["\xF3\xB0\x8E\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x3B"],
        ["\xF3\xB0\x8E\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x47"],
        ["\xF3\xB0\x8E\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x57"],
        ["\xF3\xB0\x8E\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x4F"],
        ["\xF3\xB0\x8E\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x5F"],
        ["\xF3\xB0\x8E\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x6F"],
        ["\xF3\xB0\x8E\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x44"],
        ["\xF3\xB0\x8E\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x53"],
        ["\xF3\xB0\x8E\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x4C"],
        ["\xF3\xB0\x8E\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x5B"],
        ["\xF3\xB0\x8E\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x63"],
        ["\xF3\xB0\x8E\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x41"],
        ["\xF3\xB0\x8E\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x54"],
        ["\xF3\xB0\x8E\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x49"],
        ["\xF3\xB0\x8E\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x5C"],
        ["\xF3\xB0\x8E\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C\x66"],
        ["\xF3\xB0\x95\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x21"],
        ["\xF3\xB0\x95\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x22"],
        ["\xF3\xB0\x95\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x23"],
        ["\xF3\xB0\x95\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x24"],
        ["\xF3\xB0\x95\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x25"],
        ["\xF3\xB0\x95\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x26"],
        ["\xF3\xB0\x95\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x27"],
        ["\xF3\xB0\x95\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x28"],
        ["\xF3\xB0\x95\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x29"],
        ["\xF3\xB0\x95\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2A"],
        ["\xF3\xB0\x95\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2B"],
        ["\xF3\xB0\x95\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2C"],
        ["\xF3\xB0\x95\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2D"],
        ["\xF3\xB0\x95\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2E"],
        ["\xF3\xB0\x95\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x2F"],
        ["\xF3\xB0\x95\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x30"],
        ["\xF3\xB0\x95\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x31"],
        ["\xF3\xB0\x95\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x32"],
        ["\xF3\xB0\x95\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x33"],
        ["\xF3\xB0\x95\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x34"],
        ["\xF3\xB0\x95\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x35"],
        ["\xF3\xB0\x95\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x36"],
        ["\xF3\xB0\x95\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x37"],
        ["\xF3\xB0\x95\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x38"],
        ["\xF3\xB0\x96\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x39"],
        ["\xF3\xB0\x96\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x3A"],
        ["\xF3\xB0\x96\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x3B"],
        ["\xF3\xB0\x96\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x3C"],
        ["\xF3\xB0\x96\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x3D"],
        ["\xF3\xB0\x96\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x3E"],
        ["\xF3\xB0\x96\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x40"],
        ["\xF3\xB0\x96\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x41"],
        ["\xF3\xB0\x96\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x42"],
        ["\xF3\xB0\x96\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x43"],
        ["\xF3\xB0\x96\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x44"],
        ["\xF3\xB0\x96\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x45"],
        ["\xF3\xB0\x96\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x46"],
        ["\xF3\xB0\x96\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x47"],
        ["\xF3\xB0\x96\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x48"],
        ["\xF3\xB0\x96\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x49"],
        ["\xF3\xB0\x96\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4A"],
        ["\xF3\xB0\x96\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4B"],
        ["\xF3\xB0\x96\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4C"],
        ["\xF3\xB0\x96\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4D"],
        ["\xF3\xB0\x96\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4E"],
        ["\xF3\xB0\x96\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x4F"],
        ["\xF3\xB0\x96\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x50"],
        ["\xF3\xB0\x96\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x51"],
        ["\xF3\xB0\x96\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x52"],
        ["\xF3\xB0\x96\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x53"],
        ["\xF3\xB0\x96\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x54"],
        ["\xF3\xB0\x96\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x55"],
        ["\xF3\xB0\x96\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x56"],
        ["\xF3\xB0\x96\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x5F"],
        ["\xF3\xB0\x96\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x60"],
        ["\xF3\xB0\x96\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x61"],
        ["\xF3\xB0\x96\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x62"],
        ["\xF3\xB0\x96\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x63"],
        ["\xF3\xB0\x96\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x64"],
        ["\xF3\xB0\x96\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x65"],
        ["\xF3\xB0\x96\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x66"],
        ["\xF3\xB0\x96\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x67"],
        ["\xF3\xB0\x96\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x68"],
        ["\xF3\xB0\x96\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x69"],
        ["\xF3\xB0\x96\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6A"],
        ["\xF3\xB0\x96\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6B"],
        ["\xF3\xB0\x96\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6C"],
        ["\xF3\xB0\x96\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6D"],
        ["\xF3\xB0\x96\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6E"],
        ["\xF3\xB0\x96\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x6F"],
        ["\xF3\xB0\x96\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x73"],
        ["\xF3\xB0\x96\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x74"],
        ["\xF3\xB0\x96\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x78"],
        ["\xF3\xB0\x97\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D\x79"],
        ["\xF3\xB0\x9A\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x21"],
        ["\xF3\xB0\x9A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x22"],
        ["\xF3\xB0\x9A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x23"],
        ["\xF3\xB0\x9A\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x24"],
        ["\xF3\xB0\x9A\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x25"],
        ["\xF3\xB0\x9A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x26"],
        ["\xF3\xB0\x9A\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x27"],
        ["\xF3\xB0\x9A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x28"],
        ["\xF3\xB0\x9A\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x29"],
        ["\xF3\xB0\x9A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2A"],
        ["\xF3\xB0\x9A\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2B"],
        ["\xF3\xB0\x9A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2C"],
        ["\xF3\xB0\x9A\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2D"],
        ["\xF3\xB0\x9A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2E"],
        ["\xF3\xB0\x9A\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x2F"],
        ["\xF3\xB0\x9A\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x30"],
        ["\xF3\xB0\x9A\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x31"],
        ["\xF3\xB0\x9A\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x32"],
        ["\xF3\xB0\x9A\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],
        ["\xF3\xB0\x9A\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x34"],
        ["\xF3\xB0\x9A\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x35"],
        ["\xF3\xB0\x9A\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x36"],
        ["\xF3\xB0\x9A\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x37"],
        ["\xF3\xB0\x9A\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x38"],
        ["\xF3\xB0\x9A\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x39"],
        ["\xF3\xB0\x9A\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3A"],
        ["\xF3\xB0\x9A\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3B"],
        ["\xF3\xB0\x9A\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3C"],
        ["\xF3\xB0\x9A\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3D"],
        ["\xF3\xB0\x9A\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3E"],
        ["\xF3\xB0\x9A\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x3F"],
        ["\xF3\xB0\x9A\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x40"],
        ["\xF3\xB0\x9A\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x41"],
        ["\xF3\xB0\x9A\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x42"],
        ["\xF3\xB0\x9A\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x43"],
        ["\xF3\xB0\x9A\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x44"],
        ["\xF3\xB0\x9A\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x45"],
        ["\xF3\xB0\x9A\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x46"],
        ["\xF3\xB0\x9A\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x47"],
        ["\xF3\xB0\x9A\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x48"],
        ["\xF3\xB0\x9A\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x49"],
        ["\xF3\xB0\x9A\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4A"],
        ["\xF3\xB0\x9A\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4B"],
        ["\xF3\xB0\x9A\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4C"],
        ["\xF3\xB0\x9A\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4D"],
        ["\xF3\xB0\x9A\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4E"],
        ["\xF3\xB0\x9A\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x4F"],
        ["\xF3\xB0\x9A\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x50"],
        ["\xF3\xB0\x9A\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x51"],
        ["\xF3\xB0\x9A\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x52"],
        ["\xF3\xB0\x9A\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x53"],
        ["\xF3\xB0\x9A\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x54"],
        ["\xF3\xB0\x9A\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x55"],
        ["\xF3\xB0\x9A\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x56"],
        ["\xF3\xB0\x9A\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x57"],
        ["\xF3\xB0\x9A\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x58"],
        ["\xF3\xB0\x9A\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x59"],
        ["\xF3\xB0\x9A\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5A"],
        ["\xF3\xB0\x9A\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5B"],
        ["\xF3\xB0\x9A\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5C"],
        ["\xF3\xB0\x9A\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5D"],
        ["\xF3\xB0\x9A\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5E"],
        ["\xF3\xB0\x9B\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x5F"],
        ["\xF3\xB0\x9B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x60"],
        ["\xF3\xB0\x9B\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x61"],
        ["\xF3\xB0\x9B\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x62"],
        ["\xF3\xB0\x9B\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x63"],
        ["\xF3\xB0\x9B\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x64"],
        ["\xF3\xB0\x9B\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x65"],
        ["\xF3\xB0\x9B\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x66"],
        ["\xF3\xB0\x9B\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x67"],
        ["\xF3\xB0\x9B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x68"],
        ["\xF3\xB0\x9B\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x69"],
        ["\xF3\xB0\x9B\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6A"],
        ["\xF3\xB0\x9B\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6B"],
        ["\xF3\xB0\x9B\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6C"],
        ["\xF3\xB0\x9B\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6D"],
        ["\xF3\xB0\x9B\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6E"],
        ["\xF3\xB0\x9B\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x6F"],
        ["\xF3\xB0\x9B\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x70"],
        ["\xF3\xB0\x9B\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x71"],
        ["\xF3\xB0\x9B\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x72"],
        ["\xF3\xB0\x9B\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x73"],
        ["\xF3\xB0\x9B\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x74"],
        ["\xF3\xB0\x9B\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x75"],
        ["\xF3\xB0\x9B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x76"],
        ["\xF3\xB0\x9B\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x77"],
        ["\xF3\xB0\x9B\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x78"],
        ["\xF3\xB0\x9B\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x79"],
        ["\xF3\xB0\x9B\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x7A"],
        ["\xF3\xB0\x9B\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x7B"],
        ["\xF3\xB0\x9B\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x7C"],
        ["\xF3\xB0\x9B\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x7D"],
        ["\xF3\xB0\x9B\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x7E"],
        ["\xF3\xB0\x9B\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x21"],
        ["\xF3\xB0\x9B\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x22"],
        ["\xF3\xB0\x9B\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x23"],
        ["\xF3\xB0\x9B\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x24"],
        ["\xF3\xB0\x9B\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x25"],
        ["\xF3\xB0\x9B\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x26"],
        ["\xF3\xB0\x9B\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x27"],
        ["\xF3\xB0\x9B\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x28"],
        ["\xF3\xB0\x9B\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x29"],
        ["\xF3\xB0\x9B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2A"],
        ["\xF3\xB0\x9B\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2B"],
        ["\xF3\xB0\x9B\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2C"],
        ["\xF3\xB0\x9B\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2D"],
        ["\xF3\xB0\x9B\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2E"],
        ["\xF3\xB0\x9B\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x2F"],
        ["\xF3\xB0\x9B\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x30"],
        ["\xF3\xB0\x9B\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x31"],
        ["\xF3\xB0\x9B\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x32"],
        ["\xF3\xB0\x9B\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x33"],
        ["\xF3\xB0\x9B\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x34"],
        ["\xF3\xB0\x9B\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x35"],
        ["\xF3\xB0\x9B\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x36"],
        ["\xF3\xB0\x9B\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x37"],
        ["\xF3\xB0\x9B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x38"],
        ["\xF3\xB0\x9B\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x39"],
        ["\xF3\xB0\x9B\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3A"],
        ["\xF3\xB0\x9B\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3B"],
        ["\xF3\xB0\x9B\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3C"],
        ["\xF3\xB0\x9B\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3D"],
        ["\xF3\xB0\x9B\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3E"],
        ["\xF3\xB0\x9B\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x3F"],
        ["\xF3\xB0\x9B\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x40"],
        ["\xF3\xB0\x9C\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x41"],
        ["\xF3\xB0\x9C\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x42"],
        ["\xF3\xB0\x9C\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x43"],
        ["\xF3\xB0\x9C\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x44"],
        ["\xF3\xB0\x9C\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x45"],
        ["\xF3\xB0\x9C\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x46"],
        ["\xF3\xB0\x9C\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x47"],
        ["\xF3\xB0\x9C\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x48"],
        ["\xF3\xB0\x9C\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x49"],
        ["\xF3\xB0\x9C\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4A"],
        ["\xF3\xB0\x9C\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4B"],
        ["\xF3\xB0\x9C\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4C"],
        ["\xF3\xB0\x9C\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4D"],
        ["\xF3\xB0\x9C\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4E"],
        ["\xF3\xB0\x9C\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x4F"],
        ["\xF3\xB0\x9C\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x50"],
        ["\xF3\xB0\x9C\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x51"],
        ["\xF3\xB0\x9C\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x52"],
        ["\xF3\xB0\x9C\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x53"],
        ["\xF3\xB0\x9C\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x54"],
        ["\xF3\xB0\x9C\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x55"],
        ["\xF3\xB0\x9C\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x56"],
        ["\xF3\xB0\x9C\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x57"],
        ["\xF3\xB0\x9C\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x58"],
        ["\xF3\xB0\x9C\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x59"],
        ["\xF3\xB0\x9C\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5A"],
        ["\xF3\xB0\x9C\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5B"],
        ["\xF3\xB0\x9C\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5C"],
        ["\xF3\xB0\x9C\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5D"],
        ["\xF3\xB0\x9C\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5E"],
        ["\xF3\xB0\x9C\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x5F"],
        ["\xF3\xB0\x9C\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x60"],
        ["\xF3\xB0\x9C\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x61"],
        ["\xF3\xB0\x9C\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x62"],
        ["\xF3\xB0\x9C\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x63"],
        ["\xF3\xB0\x9C\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x64"],
        ["\xF3\xB0\x9C\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x65"],
        ["\xF3\xB0\x9C\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x66"],
        ["\xF3\xB0\x9C\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x67"],
        ["\xF3\xB0\x9C\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x68"],
        ["\xF3\xB0\x9C\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x69"],
        ["\xF3\xB0\x9C\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6A"],
        ["\xF3\xB0\x9C\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6B"],
        ["\xF3\xB0\x9C\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6C"],
        ["\xF3\xB0\x9C\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6D"],
        ["\xF3\xB0\x9C\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6E"],
        ["\xF3\xB0\x9C\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x6F"],
        ["\xF3\xB0\x9C\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x70"],
        ["\xF3\xB0\x9C\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x71"],
        ["\xF3\xB0\x9C\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x72"],
        ["\xF3\xB0\x9C\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x73"],
        ["\xF3\xB0\x9C\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x74"],
        ["\xF3\xB0\x9C\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x75"],
        ["\xF3\xB0\x9C\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x76"],
        ["\xF3\xB0\x9C\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x77"],
        ["\xF3\xB0\x9C\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x78"],
        ["\xF3\xB0\x9C\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x79"],
        ["\xF3\xB0\x9C\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x7A"],
        ["\xF3\xB0\x9C\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x7B"],
        ["\xF3\xB0\x9C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x7C"],
        ["\xF3\xB0\x9C\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x7D"],
        ["\xF3\xB0\x9C\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31\x7E"],
        ["\xF3\xB0\x9C\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x21"],
        ["\xF3\xB0\x9C\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x22"],
        ["\xF3\xB0\x9D\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x23"],
        ["\xF3\xB0\x9D\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x24"],
        ["\xF3\xB0\x9D\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x25"],
        ["\xF3\xB0\x9D\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x26"],
        ["\xF3\xB0\x9D\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x27"],
        ["\xF3\xB0\x9D\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x28"],
        ["\xF3\xB0\x9D\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],
        ["\xF3\xB0\x9D\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2A"],
        ["\xF3\xB0\x9D\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2B"],
        ["\xF3\xB0\x9D\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2C"],
        ["\xF3\xB0\x9D\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2D"],
        ["\xF3\xB0\x9D\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2E"],
        ["\xF3\xB0\x9D\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x2F"],
        ["\xF3\xB0\x9D\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x30"],
        ["\xF3\xB0\x9D\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x31"],
        ["\xF3\xB0\x9D\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x32"],
        ["\xF3\xB0\x9D\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x33"],
        ["\xF3\xB0\x9D\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x34"],
        ["\xF3\xB0\x9D\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x35"],
        ["\xF3\xB0\x9D\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x36"],
        ["\xF3\xB0\x9D\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x37"],
        ["\xF3\xB0\x9D\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x38"],
        ["\xF3\xB0\x9D\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x39"],
        ["\xF3\xB0\x9D\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3A"],
        ["\xF3\xB0\x9D\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3B"],
        ["\xF3\xB0\x9D\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3C"],
        ["\xF3\xB0\x9D\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3D"],
        ["\xF3\xB0\x9D\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3E"],
        ["\xF3\xB0\x9D\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x3F"],
        ["\xF3\xB0\x9D\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x40"],
        ["\xF3\xB0\x9D\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x41"],
        ["\xF3\xB0\x9D\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x42"],
        ["\xF3\xB0\x9D\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x43"],
        ["\xF3\xB0\x9D\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x44"],
        ["\xF3\xB0\x9D\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x45"],
        ["\xF3\xB0\x9D\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x46"],
        ["\xF3\xB0\x9D\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x47"],
        ["\xF3\xB0\x9D\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x48"],
        ["\xF3\xB0\x9D\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x49"],
        ["\xF3\xB0\x9D\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4A"],
        ["\xF3\xB0\x9D\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4B"],
        ["\xF3\xB0\x9D\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4C"],
        ["\xF3\xB0\x9D\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4D"],
        ["\xF3\xB0\x9D\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4E"],
        ["\xF3\xB0\x9D\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x4F"],
        ["\xF3\xB0\x9D\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x50"],
        ["\xF3\xB0\x9D\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x51"],
        ["\xF3\xB0\x9D\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x52"],
        ["\xF3\xB0\x9D\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x53"],
        ["\xF3\xB0\x9D\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x54"],
        ["\xF3\xB0\x9D\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x55"],
        ["\xF3\xB0\x9D\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x56"],
        ["\xF3\xB0\x9D\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x57"],
        ["\xF3\xB0\x9D\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x58"],
        ["\xF3\xB0\x9D\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x59"],
        ["\xF3\xB0\x9D\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5A"],
        ["\xF3\xB0\x9D\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5B"],
        ["\xF3\xB0\x9D\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5C"],
        ["\xF3\xB0\x9D\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5D"],
        ["\xF3\xB0\x9D\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5E"],
        ["\xF3\xB0\x9D\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x5F"],
        ["\xF3\xB0\x9D\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x60"],
        ["\xF3\xB0\x9D\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x61"],
        ["\xF3\xB0\x9D\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x62"],
        ["\xF3\xB0\x9E\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x63"],
        ["\xF3\xB0\x9E\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x64"],
        ["\xF3\xB0\x9E\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x65"],
        ["\xF3\xB0\x9E\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x66"],
        ["\xF3\xB0\x9E\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x67"],
        ["\xF3\xB0\x9E\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x68"],
        ["\xF3\xB0\x9E\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x69"],
        ["\xF3\xB0\x9E\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6A"],
        ["\xF3\xB0\x9E\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6B"],
        ["\xF3\xB0\x9E\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6C"],
        ["\xF3\xB0\x9E\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6D"],
        ["\xF3\xB0\x9E\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6E"],
        ["\xF3\xB0\x9E\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x6F"],
        ["\xF3\xB0\x9E\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x70"],
        ["\xF3\xB0\x9E\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x71"],
        ["\xF3\xB0\x9E\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x72"],
        ["\xF3\xB0\x9E\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x73"],
        ["\xF3\xB0\x9E\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x74"],
        ["\xF3\xB0\x9E\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x75"],
        ["\xF3\xB0\x9E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x76"],
        ["\xF3\xB0\x9E\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x77"],
        ["\xF3\xB0\x9E\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x78"],
        ["\xF3\xB0\x9E\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x79"],
        ["\xF3\xB0\x9E\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x7A"],
        ["\xF3\xB0\x9E\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x7B"],
        ["\xF3\xB0\x9E\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x7C"],
        ["\xF3\xB0\x9E\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x7D"],
        ["\xF3\xB0\x9E\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x7E"],
        ["\xF3\xB0\x9E\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x21"],
        ["\xF3\xB0\x9E\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x22"],
        ["\xF3\xB0\x9E\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x23"],
        ["\xF3\xB0\x9E\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x24"],
        ["\xF3\xB0\x9E\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x25"],
        ["\xF3\xB0\x9E\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x26"],
        ["\xF3\xB0\x9E\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x27"],
        ["\xF3\xB0\x9E\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x28"],
        ["\xF3\xB0\x9E\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x29"],
        ["\xF3\xB0\x9E\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2A"],
        ["\xF3\xB0\x9E\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2B"],
        ["\xF3\xB0\x9E\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2C"],
        ["\xF3\xB0\x9E\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2D"],
        ["\xF3\xB0\x9E\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2E"],
        ["\xF3\xB0\x9E\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x2F"],
        ["\xF3\xB0\x9E\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x30"],
        ["\xF3\xB0\x9E\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x31"],
        ["\xF3\xB0\x9E\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x32"],
        ["\xF3\xB0\x9E\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x33"],
        ["\xF3\xB0\x9E\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x34"],
        ["\xF3\xB0\x9E\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x35"],
        ["\xF3\xB0\x9E\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x36"],
        ["\xF3\xB0\x9E\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x37"],
        ["\xF3\xB0\x9E\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x38"],
        ["\xF3\xB0\x9E\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x39"],
        ["\xF3\xB0\x9E\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3A"],
        ["\xF3\xB0\x9E\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3B"],
        ["\xF3\xB0\x9E\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3C"],
        ["\xF3\xB0\x9E\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3D"],
        ["\xF3\xB0\x9E\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3E"],
        ["\xF3\xB0\x9E\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x3F"],
        ["\xF3\xB0\x9E\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x40"],
        ["\xF3\xB0\x9E\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x41"],
        ["\xF3\xB0\x9E\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],
        ["\xF3\xB0\x9E\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x43"],
        ["\xF3\xB0\x9E\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x44"],
        ["\xF3\xB0\x9F\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x45"],
        ["\xF3\xB0\x9F\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x46"],
        ["\xF3\xB0\x9F\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x47"],
        ["\xF3\xB0\x9F\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x48"],
        ["\xF3\xB0\x9F\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\xF3\xB0\x9F\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4A"],
        ["\xF3\xB0\x9F\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4B"],
        ["\xF3\xB0\x9F\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4C"],
        ["\xF3\xB0\x9F\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4D"],
        ["\xF3\xB0\x9F\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4E"],
        ["\xF3\xB0\x9F\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x4F"],
        ["\xF3\xB0\x9F\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x50"],
        ["\xF3\xB0\x9F\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x51"],
        ["\xF3\xB0\x9F\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x52"],
        ["\xF3\xB0\x9F\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x53"],
        ["\xF3\xB0\x9F\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x54"],
        ["\xF3\xB0\x9F\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x55"],
        ["\xF3\xB0\x9F\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x56"],
        ["\xF3\xB0\x9F\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x57"],
        ["\xF3\xB0\x9F\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x58"],
        ["\xF3\xB0\x9F\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x59"],
        ["\xF3\xB0\x9F\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5A"],
        ["\xF3\xB0\x9F\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5B"],
        ["\xF3\xB0\x9F\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5C"],
        ["\xF3\xB0\x9F\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5D"],
        ["\xF3\xB0\x9F\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5E"],
        ["\xF3\xB0\x9F\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x5F"],
        ["\xF3\xB0\x9F\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x60"],
        ["\xF3\xB0\x9F\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x61"],
        ["\xF3\xB0\x9F\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x62"],
        ["\xF3\xB0\x9F\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x63"],
        ["\xF3\xB0\x9F\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x64"],
        ["\xF3\xB0\x9F\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x65"],
        ["\xF3\xB0\x9F\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x66"],
        ["\xF3\xB0\x9F\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x67"],
        ["\xF3\xB0\x9F\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x68"],
        ["\xF3\xB0\x9F\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x69"],
        ["\xF3\xB0\x9F\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6A"],
        ["\xF3\xB0\x9F\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6B"],
        ["\xF3\xB0\x9F\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6C"],
        ["\xF3\xB0\x9F\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6D"],
        ["\xF3\xB0\x9F\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6E"],
        ["\xF3\xB0\x9F\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x6F"],
        ["\xF3\xB0\x9F\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x70"],
        ["\xF3\xB0\x9F\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x71"],
        ["\xF3\xB0\x9F\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x72"],
        ["\xF3\xB0\x9F\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x73"],
        ["\xF3\xB0\x9F\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x74"],
        ["\xF3\xB0\x9F\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x75"],
        ["\xF3\xB0\x9F\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\xF3\xB0\x9F\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x77"],
        ["\xF3\xB0\x9F\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x78"],
        ["\xF3\xB0\x9F\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x79"],
        ["\xF3\xB0\x9F\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x7A"],
        ["\xF3\xB0\x9F\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x7B"],
        ["\xF3\xB0\x9F\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x7C"],
        ["\xF3\xB0\x9F\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x7D"],
        ["\xF3\xB0\x9F\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x7E"],
        ["\xF3\xB0\x9F\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x21"],
        ["\xF3\xB0\x9F\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x22"],
        ["\xF3\xB0\x9F\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x23"],
        ["\xF3\xB0\x9F\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x24"],
        ["\xF3\xB0\x9F\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x25"],
        ["\xF3\xB0\x9F\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x26"],
        ["\xF3\xB0\xA0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x27"],
        ["\xF3\xB0\xA0\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x28"],
        ["\xF3\xB0\xA0\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x29"],
        ["\xF3\xB0\xA0\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2A"],
        ["\xF3\xB0\xA0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2B"],
        ["\xF3\xB0\xA0\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2C"],
        ["\xF3\xB0\xA0\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2D"],
        ["\xF3\xB0\xA0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2E"],
        ["\xF3\xB0\xA0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x2F"],
        ["\xF3\xB0\xA0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x30"],
        ["\xF3\xB0\xA0\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x31"],
        ["\xF3\xB0\xA0\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x32"],
        ["\xF3\xB0\xA0\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x33"],
        ["\xF3\xB0\xA0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x34"],
        ["\xF3\xB0\xA0\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x35"],
        ["\xF3\xB0\xA0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x36"],
        ["\xF3\xB0\xA0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x37"],
        ["\xF3\xB0\xA0\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x38"],
        ["\xF3\xB0\xA0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x39"],
        ["\xF3\xB0\xA0\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3A"],
        ["\xF3\xB0\xA0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3B"],
        ["\xF3\xB0\xA0\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3C"],
        ["\xF3\xB0\xA0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3D"],
        ["\xF3\xB0\xA0\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3E"],
        ["\xF3\xB0\xA0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x3F"],
        ["\xF3\xB0\xA0\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x40"],
        ["\xF3\xB0\xA0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x41"],
        ["\xF3\xB0\xA0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x42"],
        ["\xF3\xB0\xA0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\xF3\xB0\xA0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x44"],
        ["\xF3\xB0\xA0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x45"],
        ["\xF3\xB0\xA0\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x46"],
        ["\xF3\xB0\xA0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x47"],
        ["\xF3\xB0\xA0\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x48"],
        ["\xF3\xB0\xA0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x49"],
        ["\xF3\xB0\xA0\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4A"],
        ["\xF3\xB0\xA0\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4B"],
        ["\xF3\xB0\xA0\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4C"],
        ["\xF3\xB0\xA0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4D"],
        ["\xF3\xB0\xA0\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4E"],
        ["\xF3\xB0\xA0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x4F"],
        ["\xF3\xB0\xA0\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x50"],
        ["\xF3\xB0\xA0\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x51"],
        ["\xF3\xB0\xA0\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5D"],
        ["\xF3\xB0\xA0\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x53"],
        ["\xF3\xB0\xA0\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x54"],
        ["\xF3\xB0\xA0\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x55"],
        ["\xF3\xB0\xA0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x56"],
        ["\xF3\xB0\xA0\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x57"],
        ["\xF3\xB0\xA0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x58"],
        ["\xF3\xB0\xA0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x59"],
        ["\xF3\xB0\xA0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5A"],
        ["\xF3\xB0\xA0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5B"],
        ["\xF3\xB0\xA0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5C"],
        ["\xF3\xB0\xA0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5D"],
        ["\xF3\xB0\xA0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5E"],
        ["\xF3\xB0\xA0\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x5F"],
        ["\xF3\xB0\xA0\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x60"],
        ["\xF3\xB0\xA0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x61"],
        ["\xF3\xB0\xA0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x62"],
        ["\xF3\xB0\xA0\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x63"],
        ["\xF3\xB0\xA0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x64"],
        ["\xF3\xB0\xA0\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x65"],
        ["\xF3\xB0\xA0\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x66"],
        ["\xF3\xB0\xA1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x67"],
        ["\xF3\xB0\xA1\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x68"],
        ["\xF3\xB0\xA1\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x69"],
        ["\xF3\xB0\xA1\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6A"],
        ["\xF3\xB0\xA1\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6B"],
        ["\xF3\xB0\xA1\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6C"],
        ["\xF3\xB0\xA1\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6D"],
        ["\xF3\xB0\xA1\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6E"],
        ["\xF3\xB0\xA1\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x6F"],
        ["\xF3\xB0\xA1\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x70"],
        ["\xF3\xB0\xA1\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x71"],
        ["\xF3\xB0\xA1\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x72"],
        ["\xF3\xB0\xA1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x73"],
        ["\xF3\xB0\xA1\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x74"],
        ["\xF3\xB0\xA1\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x75"],
        ["\xF3\xB0\xA1\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x76"],
        ["\xF3\xB0\xA1\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x77"],
        ["\xF3\xB0\xA1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x78"],
        ["\xF3\xB0\xA1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x79"],
        ["\xF3\xB0\xA1\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x7A"],
        ["\xF3\xB0\xA1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x7B"],
        ["\xF3\xB0\xA1\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x7C"],
        ["\xF3\xB0\xA1\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x7D"],
        ["\xF3\xB0\xA1\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x7E"],
        ["\xF3\xB0\xA1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x21"],
        ["\xF3\xB0\xA1\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x22"],
        ["\xF3\xB0\xA1\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x23"],
        ["\xF3\xB0\xA1\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x24"],
        ["\xF3\xB0\xA1\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x25"],
        ["\xF3\xB0\xA1\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x26"],
        ["\xF3\xB0\xA1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x27"],
        ["\xF3\xB0\xA1\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x28"],
        ["\xF3\xB0\xA1\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x29"],
        ["\xF3\xB0\xA1\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2A"],
        ["\xF3\xB0\xA1\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2B"],
        ["\xF3\xB0\xA1\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2C"],
        ["\xF3\xB0\xA1\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2D"],
        ["\xF3\xB0\xA1\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2E"],
        ["\xF3\xB0\xA1\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x2F"],
        ["\xF3\xB0\xA1\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x30"],
        ["\xF3\xB0\xA1\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x31"],
        ["\xF3\xB0\xA1\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x32"],
        ["\xF3\xB0\xA1\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x33"],
        ["\xF3\xB0\xA1\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x34"],
        ["\xF3\xB0\xA1\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x35"],
        ["\xF3\xB0\xA1\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x36"],
        ["\xF3\xB0\xA1\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x37"],
        ["\xF3\xB0\xA1\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x38"],
        ["\xF3\xB0\xA1\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x39"],
        ["\xF3\xB0\xA1\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3A"],
        ["\xF3\xB0\xA1\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3B"],
        ["\xF3\xB0\xA1\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3C"],
        ["\xF3\xB0\xA1\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3D"],
        ["\xF3\xB0\xA1\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3E"],
        ["\xF3\xB0\xA1\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x3F"],
        ["\xF3\xB0\xA1\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x40"],
        ["\xF3\xB0\xA1\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x41"],
        ["\xF3\xB0\xA1\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x42"],
        ["\xF3\xB0\xA1\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x43"],
        ["\xF3\xB0\xA1\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x44"],
        ["\xF3\xB0\xA1\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x45"],
        ["\xF3\xB0\xA1\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x46"],
        ["\xF3\xB0\xA1\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x47"],
        ["\xF3\xB0\xA1\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x48"],
        ["\xF3\xB0\xA2\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x49"],
        ["\xF3\xB0\xA2\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4A"],
        ["\xF3\xB0\xA2\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4B"],
        ["\xF3\xB0\xA2\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4C"],
        ["\xF3\xB0\xA2\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4D"],
        ["\xF3\xB0\xA2\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4E"],
        ["\xF3\xB0\xA2\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x4F"],
        ["\xF3\xB0\xA2\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x50"],
        ["\xF3\xB0\xA2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x51"],
        ["\xF3\xB0\xA2\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x52"],
        ["\xF3\xB0\xA2\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x53"],
        ["\xF3\xB0\xA2\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x54"],
        ["\xF3\xB0\xA2\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x55"],
        ["\xF3\xB0\xA2\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x56"],
        ["\xF3\xB0\xA2\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x57"],
        ["\xF3\xB0\xA2\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x58"],
        ["\xF3\xB0\xA2\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x59"],
        ["\xF3\xB0\xA2\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5A"],
        ["\xF3\xB0\xA2\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5B"],
        ["\xF3\xB0\xA2\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5C"],
        ["\xF3\xB0\xA2\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5D"],
        ["\xF3\xB0\xA2\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5E"],
        ["\xF3\xB0\xA2\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x5F"],
        ["\xF3\xB0\xA2\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x60"],
        ["\xF3\xB0\xA2\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x61"],
        ["\xF3\xB0\xA2\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x62"],
        ["\xF3\xB0\xA2\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x63"],
        ["\xF3\xB0\xA2\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x64"],
        ["\xF3\xB0\xA2\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x65"],
        ["\xF3\xB0\xA2\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x66"],
        ["\xF3\xB0\xA2\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x67"],
        ["\xF3\xB0\xA2\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x68"],
        ["\xF3\xB0\xA2\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x69"],
        ["\xF3\xB0\xA2\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6A"],
        ["\xF3\xB0\xA2\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6B"],
        ["\xF3\xB0\xA2\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6C"],
        ["\xF3\xB0\xA2\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6D"],
        ["\xF3\xB0\xA2\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6E"],
        ["\xF3\xB0\xA2\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x6F"],
        ["\xF3\xB0\xA2\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x70"],
        ["\xF3\xB0\xA2\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x71"],
        ["\xF3\xB0\xA2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x72"],
        ["\xF3\xB0\xA2\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x73"],
        ["\xF3\xB0\xA2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x74"],
        ["\xF3\xB0\xA2\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x75"],
        ["\xF3\xB0\xA2\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x76"],
        ["\xF3\xB0\xA2\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x77"],
        ["\xF3\xB0\xA2\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x78"],
        ["\xF3\xB0\xA2\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x79"],
        ["\xF3\xB0\xA2\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x7A"],
        ["\xF3\xB0\xA2\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x7B"],
        ["\xF3\xB0\xA2\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x7C"],
        ["\xF3\xB0\xA2\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x7D"],
        ["\xF3\xB0\xA2\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35\x7E"],
        ["\xF3\xB0\xA2\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x21"],
        ["\xF3\xB0\xA2\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x22"],
        ["\xF3\xB0\xA2\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x23"],
        ["\xF3\xB0\xA2\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x24"],
        ["\xF3\xB0\xA2\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x25"],
        ["\xF3\xB0\xA2\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x26"],
        ["\xF3\xB0\xA2\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x27"],
        ["\xF3\xB0\xA2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x28"],
        ["\xF3\xB0\xA2\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x29"],
        ["\xF3\xB0\xA2\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2A"],
        ["\xF3\xB0\xA3\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2B"],
        ["\xF3\xB0\xA3\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2C"],
        ["\xF3\xB0\xA3\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2D"],
        ["\xF3\xB0\xA3\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2E"],
        ["\xF3\xB0\xA3\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x2F"],
        ["\xF3\xB0\xA3\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x30"],
        ["\xF3\xB0\xA3\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x31"],
        ["\xF3\xB0\xA3\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x32"],
        ["\xF3\xB0\xA3\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x33"],
        ["\xF3\xB0\xA3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x34"],
        ["\xF3\xB0\xA3\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x35"],
        ["\xF3\xB0\xA3\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x36"],
        ["\xF3\xB0\xA3\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x37"],
        ["\xF3\xB0\xA3\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x38"],
        ["\xF3\xB0\xA3\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x39"],
        ["\xF3\xB0\xA3\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3A"],
        ["\xF3\xB0\xA3\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3B"],
        ["\xF3\xB0\xA3\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3C"],
        ["\xF3\xB0\xA3\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3D"],
        ["\xF3\xB0\xA3\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3E"],
        ["\xF3\xB0\xA3\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x3F"],
        ["\xF3\xB0\xA3\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x40"],
        ["\xF3\xB0\xA3\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x41"],
        ["\xF3\xB0\xA3\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x42"],
        ["\xF3\xB0\xA3\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x43"],
        ["\xF3\xB0\xA3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x44"],
        ["\xF3\xB0\xA3\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x45"],
        ["\xF3\xB0\xA3\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xF3\xB0\xA3\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x47"],
        ["\xF3\xB0\xA3\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x48"],
        ["\xF3\xB0\xA3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x49"],
        ["\xF3\xB0\xA3\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4A"],
        ["\xF3\xB0\xA3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4B"],
        ["\xF3\xB0\xA3\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4C"],
        ["\xF3\xB0\xA3\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4D"],
        ["\xF3\xB0\xA3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4E"],
        ["\xF3\xB0\xA3\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x4F"],
        ["\xF3\xB0\xA3\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x50"],
        ["\xF3\xB0\xA3\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x51"],
        ["\xF3\xB0\xA3\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x52"],
        ["\xF3\xB0\xA3\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x53"],
        ["\xF3\xB0\xA3\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x54"],
        ["\xF3\xB0\xA3\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x55"],
        ["\xF3\xB0\xA3\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x56"],
        ["\xF3\xB0\xA3\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x57"],
        ["\xF3\xB0\xA3\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x58"],
        ["\xF3\xB0\xA3\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x59"],
        ["\xF3\xB0\xA3\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5A"],
        ["\xF3\xB0\xA3\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5B"],
        ["\xF3\xB0\xA3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5C"],
        ["\xF3\xB0\xA3\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5D"],
        ["\xF3\xB0\xA3\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5E"],
        ["\xF3\xB0\xA3\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x5F"],
        ["\xF3\xB0\xA3\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x60"],
        ["\xF3\xB0\xA3\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x61"],
        ["\xF3\xB0\xA3\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x62"],
        ["\xF3\xB0\xA3\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x63"],
        ["\xF3\xB0\xA3\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x64"],
        ["\xF3\xB0\xA3\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x65"],
        ["\xF3\xB0\xA3\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x66"],
        ["\xF3\xB0\xA3\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x67"],
        ["\xF3\xB0\xA3\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x68"],
        ["\xF3\xB0\xA3\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x69"],
        ["\xF3\xB0\xA3\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6A"],
        ["\xF3\xB0\xA4\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6B"],
        ["\xF3\xB0\xA4\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6C"],
        ["\xF3\xB0\xA4\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6D"],
        ["\xF3\xB0\xA4\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6E"],
        ["\xF3\xB0\xA4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x6F"],
        ["\xF3\xB0\xA4\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x70"],
        ["\xF3\xB0\xA4\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x71"],
        ["\xF3\xB0\xA4\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x72"],
        ["\xF3\xB0\xA4\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x73"],
        ["\xF3\xB0\xA4\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x74"],
        ["\xF3\xB0\xA4\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x75"],
        ["\xF3\xB0\xA4\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x76"],
        ["\xF3\xB0\xA4\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x77"],
        ["\xF3\xB0\xA4\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x78"],
        ["\xF3\xB0\xA4\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x79"],
        ["\xF3\xB0\xA4\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x7A"],
        ["\xF3\xB0\xA4\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x7B"],
        ["\xF3\xB0\xA4\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x7C"],
        ["\xF3\xB0\xA4\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x7D"],
        ["\xF3\xB0\xA4\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x7E"],
        ["\xF3\xB0\xA4\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x21"],
        ["\xF3\xB0\xA4\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x22"],
        ["\xF3\xB0\xA4\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x23"],
        ["\xF3\xB0\xA4\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x24"],
        ["\xF3\xB0\xA4\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x25"],
        ["\xF3\xB0\xA4\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x26"],
        ["\xF3\xB0\xA4\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x27"],
        ["\xF3\xB0\xA4\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x28"],
        ["\xF3\xB0\xA4\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x29"],
        ["\xF3\xB0\xA4\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2A"],
        ["\xF3\xB0\xA4\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2B"],
        ["\xF3\xB0\xA4\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2C"],
        ["\xF3\xB0\xA4\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2D"],
        ["\xF3\xB0\xA4\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2E"],
        ["\xF3\xB0\xA4\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x2F"],
        ["\xF3\xB0\xA4\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x30"],
        ["\xF3\xB0\xA4\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x31"],
        ["\xF3\xB0\xA4\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x32"],
        ["\xF3\xB0\xA4\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x33"],
        ["\xF3\xB0\xA4\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x34"],
        ["\xF3\xB0\xA4\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x35"],
        ["\xF3\xB0\xA4\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x36"],
        ["\xF3\xB0\xA4\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x37"],
        ["\xF3\xB0\xA4\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x38"],
        ["\xF3\xB0\xA4\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x39"],
        ["\xF3\xB0\xA4\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3A"],
        ["\xF3\xB0\xA4\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3B"],
        ["\xF3\xB0\xA4\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3C"],
        ["\xF3\xB0\xA4\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3D"],
        ["\xF3\xB0\xA4\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3E"],
        ["\xF3\xB0\xA4\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x3F"],
        ["\xF3\xB0\xA4\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x40"],
        ["\xF3\xB0\xA4\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x41"],
        ["\xF3\xB0\xA4\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x42"],
        ["\xF3\xB0\xA4\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x43"],
        ["\xF3\xB0\xA4\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x44"],
        ["\xF3\xB0\xA4\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x45"],
        ["\xF3\xB0\xA4\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x46"],
        ["\xF3\xB0\xA4\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x47"],
        ["\xF3\xB0\xA4\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x48"],
        ["\xF3\xB0\xA4\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x49"],
        ["\xF3\xB0\xA4\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4A"],
        ["\xF3\xB0\xA4\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4B"],
        ["\xF3\xB0\xA4\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4C"],
        ["\xF3\xB0\xA5\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4D"],
        ["\xF3\xB0\xA5\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4E"],
        ["\xF3\xB0\xA5\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x4F"],
        ["\xF3\xB0\xA5\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x50"],
        ["\xF3\xB0\xA5\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x51"],
        ["\xF3\xB0\xA5\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x52"],
        ["\xF3\xB0\xA5\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x53"],
        ["\xF3\xB0\xA5\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x54"],
        ["\xF3\xB0\xA5\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x55"],
        ["\xF3\xB0\xA5\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x56"],
        ["\xF3\xB0\xA5\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x57"],
        ["\xF3\xB0\xA5\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x58"],
        ["\xF3\xB0\xA5\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x59"],
        ["\xF3\xB0\xA5\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5A"],
        ["\xF3\xB0\xA5\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],
        ["\xF3\xB0\xA5\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5C"],
        ["\xF3\xB0\xA5\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5D"],
        ["\xF3\xB0\xA5\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5E"],
        ["\xF3\xB0\xA5\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5F"],
        ["\xF3\xB0\xA5\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x60"],
        ["\xF3\xB0\xA5\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x61"],
        ["\xF3\xB0\xA5\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x62"],
        ["\xF3\xB0\xA5\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x63"],
        ["\xF3\xB0\xA5\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x64"],
        ["\xF3\xB0\xA5\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x65"],
        ["\xF3\xB0\xA5\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x66"],
        ["\xF3\xB0\xA5\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x67"],
        ["\xF3\xB0\xA5\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x68"],
        ["\xF3\xB0\xA5\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x69"],
        ["\xF3\xB0\xA5\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6A"],
        ["\xF3\xB0\xA5\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6B"],
        ["\xF3\xB0\xA5\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6C"],
        ["\xF3\xB0\xA5\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6D"],
        ["\xF3\xB0\xA5\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6E"],
        ["\xF3\xB0\xA5\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x6F"],
        ["\xF3\xB0\xA5\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x70"],
        ["\xF3\xB0\xA5\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x71"],
        ["\xF3\xB0\xA5\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x72"],
        ["\xF3\xB0\xA5\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x73"],
        ["\xF3\xB0\xA5\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x74"],
        ["\xF3\xB0\xA5\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x75"],
        ["\xF3\xB0\xA5\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x76"],
        ["\xF3\xB0\xA5\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x77"],
        ["\xF3\xB0\xA5\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x78"],
        ["\xF3\xB0\xA5\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x79"],
        ["\xF3\xB0\xA5\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x7A"],
        ["\xF3\xB0\xA5\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x7B"],
        ["\xF3\xB0\xA5\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x7C"],
        ["\xF3\xB0\xA5\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x7D"],
        ["\xF3\xB0\xA5\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x7E"],
        ["\xF3\xB0\xA5\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x21"],
        ["\xF3\xB0\xA5\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x22"],
        ["\xF3\xB0\xA5\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x23"],
        ["\xF3\xB0\xA5\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x24"],
        ["\xF3\xB0\xA5\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x25"],
        ["\xF3\xB0\xA5\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x26"],
        ["\xF3\xB0\xA5\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x27"],
        ["\xF3\xB0\xA5\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x28"],
        ["\xF3\xB0\xA5\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x29"],
        ["\xF3\xB0\xA5\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2A"],
        ["\xF3\xB0\xA5\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2B"],
        ["\xF3\xB0\xA5\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2C"],
        ["\xF3\xB0\xA5\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2D"],
        ["\xF3\xB0\xA5\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2E"],
        ["\xF3\xB0\xA6\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x2F"],
        ["\xF3\xB0\xA6\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x30"],
        ["\xF3\xB0\xA6\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x31"],
        ["\xF3\xB0\xA6\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x32"],
        ["\xF3\xB0\xA6\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x33"],
        ["\xF3\xB0\xA6\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x34"],
        ["\xF3\xB0\xA6\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x35"],
        ["\xF3\xB0\xA6\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x36"],
        ["\xF3\xB0\xA6\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x37"],
        ["\xF3\xB0\xA6\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x38"],
        ["\xF3\xB0\xA6\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x39"],
        ["\xF3\xB0\xA6\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3A"],
        ["\xF3\xB0\xA6\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3B"],
        ["\xF3\xB0\xA6\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3C"],
        ["\xF3\xB0\xA6\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3D"],
        ["\xF3\xB0\xA6\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3E"],
        ["\xF3\xB0\xA6\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x3F"],
        ["\xF3\xB0\xA6\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x40"],
        ["\xF3\xB0\xA6\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x41"],
        ["\xF3\xB0\xA6\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x42"],
        ["\xF3\xB0\xA6\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x43"],
        ["\xF3\xB0\xA6\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x44"],
        ["\xF3\xB0\xA6\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x45"],
        ["\xF3\xB0\xA6\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x46"],
        ["\xF3\xB0\xA6\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x47"],
        ["\xF3\xB0\xA6\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x48"],
        ["\xF3\xB0\xA6\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x49"],
        ["\xF3\xB0\xA6\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4A"],
        ["\xF3\xB0\xA6\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4B"],
        ["\xF3\xB0\xA6\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4C"],
        ["\xF3\xB0\xA6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4D"],
        ["\xF3\xB0\xA6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4E"],
        ["\xF3\xB0\xA6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x4F"],
        ["\xF3\xB0\xA6\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x50"],
        ["\xF3\xB0\xA6\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x51"],
        ["\xF3\xB0\xA6\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x52"],
        ["\xF3\xB0\xA6\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x53"],
        ["\xF3\xB0\xA6\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x54"],
        ["\xF3\xB0\xA6\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x55"],
        ["\xF3\xB0\xA6\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x56"],
        ["\xF3\xB0\xA6\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x57"],
        ["\xF3\xB0\xA6\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x58"],
        ["\xF3\xB0\xA6\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x59"],
        ["\xF3\xB0\xA6\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5A"],
        ["\xF3\xB0\xA6\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5B"],
        ["\xF3\xB0\xA6\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5C"],
        ["\xF3\xB0\xA6\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5D"],
        ["\xF3\xB0\xA6\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5E"],
        ["\xF3\xB0\xA6\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x5F"],
        ["\xF3\xB0\xA6\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x60"],
        ["\xF3\xB0\xA6\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x61"],
        ["\xF3\xB0\xA6\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x62"],
        ["\xF3\xB0\xA6\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x63"],
        ["\xF3\xB0\xA6\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x64"],
        ["\xF3\xB0\xA6\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x65"],
        ["\xF3\xB0\xA6\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x66"],
        ["\xF3\xB0\xA6\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x67"],
        ["\xF3\xB0\xA6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x68"],
        ["\xF3\xB0\xA6\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x69"],
        ["\xF3\xB0\xA6\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6A"],
        ["\xF3\xB0\xA6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6B"],
        ["\xF3\xB0\xA6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6C"],
        ["\xF3\xB0\xA6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6D"],
        ["\xF3\xB0\xA6\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6E"],
        ["\xF3\xB0\xA7\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x6F"],
        ["\xF3\xB0\xA7\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x70"],
        ["\xF3\xB0\xA7\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x71"],
        ["\xF3\xB0\xA7\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x72"],
        ["\xF3\xB0\xA7\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x73"],
        ["\xF3\xB0\xA7\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x74"],
        ["\xF3\xB0\xA7\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x75"],
        ["\xF3\xB0\xA7\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x76"],
        ["\xF3\xB0\xA7\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x77"],
        ["\xF3\xB0\xA7\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x78"],
        ["\xF3\xB0\xA7\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x79"],
        ["\xF3\xB0\xA7\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x7A"],
        ["\xF3\xB0\xA7\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x7B"],
        ["\xF3\xB0\xA7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x7C"],
        ["\xF3\xB0\xA7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x7D"],
        ["\xF3\xB0\xA7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38\x7E"],
        ["\xF3\xB0\xA7\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x21"],
        ["\xF3\xB0\xA7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x22"],
        ["\xF3\xB0\xA7\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x23"],
        ["\xF3\xB0\xA7\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x24"],
        ["\xF3\xB0\xA7\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x25"],
        ["\xF3\xB0\xA7\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x26"],
        ["\xF3\xB0\xA7\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x27"],
        ["\xF3\xB0\xA7\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x28"],
        ["\xF3\xB0\xA7\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x29"],
        ["\xF3\xB0\xA7\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2A"],
        ["\xF3\xB0\xA7\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2B"],
        ["\xF3\xB0\xA7\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2C"],
        ["\xF3\xB0\xA7\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2D"],
        ["\xF3\xB0\xA7\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2E"],
        ["\xF3\xB0\xA7\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x2F"],
        ["\xF3\xB0\xA7\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x30"],
        ["\xF3\xB0\xA7\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x31"],
        ["\xF3\xB0\xA7\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x32"],
        ["\xF3\xB0\xA7\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x33"],
        ["\xF3\xB0\xA7\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x34"],
        ["\xF3\xB0\xA7\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x35"],
        ["\xF3\xB0\xA7\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x36"],
        ["\xF3\xB0\xA7\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xF3\xB0\xA7\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x38"],
        ["\xF3\xB0\xA7\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x39"],
        ["\xF3\xB0\xA7\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3A"],
        ["\xF3\xB0\xA7\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3B"],
        ["\xF3\xB0\xA7\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3C"],
        ["\xF3\xB0\xA7\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3D"],
        ["\xF3\xB0\xA7\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3E"],
        ["\xF3\xB0\xA7\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x3F"],
        ["\xF3\xB0\xA7\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x40"],
        ["\xF3\xB0\xA7\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x41"],
        ["\xF3\xB0\xA7\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x42"],
        ["\xF3\xB0\xA7\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x43"],
        ["\xF3\xB0\xA7\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x44"],
        ["\xF3\xB0\xA7\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x45"],
        ["\xF3\xB0\xA7\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x46"],
        ["\xF3\xB0\xA7\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x47"],
        ["\xF3\xB0\xA7\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x48"],
        ["\xF3\xB0\xA7\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x49"],
        ["\xF3\xB0\xA7\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4A"],
        ["\xF3\xB0\xA7\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4B"],
        ["\xF3\xB0\xA7\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4C"],
        ["\xF3\xB0\xA7\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4D"],
        ["\xF3\xB0\xA7\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4E"],
        ["\xF3\xB0\xA7\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x4F"],
        ["\xF3\xB0\xA7\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x50"],
        ["\xF3\xB0\xA8\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x51"],
        ["\xF3\xB0\xA8\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x52"],
        ["\xF3\xB0\xA8\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x53"],
        ["\xF3\xB0\xA8\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x54"],
        ["\xF3\xB0\xA8\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x55"],
        ["\xF3\xB0\xA8\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x56"],
        ["\xF3\xB0\xA8\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x57"],
        ["\xF3\xB0\xA8\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x58"],
        ["\xF3\xB0\xA8\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x59"],
        ["\xF3\xB0\xA8\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5A"],
        ["\xF3\xB0\xA8\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5B"],
        ["\xF3\xB0\xA8\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\xF3\xB0\xA8\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5D"],
        ["\xF3\xB0\xA8\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5E"],
        ["\xF3\xB0\xA8\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5F"],
        ["\xF3\xB0\xA8\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x60"],
        ["\xF3\xB0\xA8\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x61"],
        ["\xF3\xB0\xA8\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x62"],
        ["\xF3\xB0\xA8\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x63"],
        ["\xF3\xB0\xA8\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x64"],
        ["\xF3\xB0\xA8\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x65"],
        ["\xF3\xB0\xA8\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x66"],
        ["\xF3\xB0\xA8\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x67"],
        ["\xF3\xB0\xA8\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x68"],
        ["\xF3\xB0\xA8\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x69"],
        ["\xF3\xB0\xA8\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6A"],
        ["\xF3\xB0\xA8\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6B"],
        ["\xF3\xB0\xA8\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6C"],
        ["\xF3\xB0\xA8\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xF3\xB0\xA8\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6E"],
        ["\xF3\xB0\xA8\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6F"],
        ["\xF3\xB0\xA8\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x70"],
        ["\xF3\xB0\xA8\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x71"],
        ["\xF3\xB0\xA8\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x72"],
        ["\xF3\xB0\xA8\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x73"],
        ["\xF3\xB0\xA8\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x74"],
        ["\xF3\xB0\xA8\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x75"],
        ["\xF3\xB0\xA8\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x76"],
        ["\xF3\xB0\xA8\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x77"],
        ["\xF3\xB0\xA8\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x78"],
        ["\xF3\xB0\xA8\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x79"],
        ["\xF3\xB0\xA8\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x7A"],
        ["\xF3\xB0\xA8\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x7B"],
        ["\xF3\xB0\xA8\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x7C"],
        ["\xF3\xB0\xA8\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x7D"],
        ["\xF3\xB0\xA8\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x7E"],
        ["\xF3\xB0\xA8\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x21"],
        ["\xF3\xB0\xA8\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x22"],
        ["\xF3\xB0\xA8\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x23"],
        ["\xF3\xB0\xA8\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x24"],
        ["\xF3\xB0\xA8\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x25"],
        ["\xF3\xB0\xA8\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x26"],
        ["\xF3\xB0\xA8\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x27"],
        ["\xF3\xB0\xA8\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x28"],
        ["\xF3\xB0\xA8\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x29"],
        ["\xF3\xB0\xA8\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2A"],
        ["\xF3\xB0\xA8\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2B"],
        ["\xF3\xB0\xA8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2C"],
        ["\xF3\xB0\xA8\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2D"],
        ["\xF3\xB0\xA8\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2E"],
        ["\xF3\xB0\xA8\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x2F"],
        ["\xF3\xB0\xA8\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x30"],
        ["\xF3\xB0\xA8\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x31"],
        ["\xF3\xB0\xA8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x32"],
        ["\xF3\xB0\xA9\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x33"],
        ["\xF3\xB0\xA9\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x34"],
        ["\xF3\xB0\xA9\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x35"],
        ["\xF3\xB0\xA9\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x36"],
        ["\xF3\xB0\xA9\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x37"],
        ["\xF3\xB0\xA9\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x38"],
        ["\xF3\xB0\xA9\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x39"],
        ["\xF3\xB0\xA9\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3A"],
        ["\xF3\xB0\xA9\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3B"],
        ["\xF3\xB0\xA9\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3C"],
        ["\xF3\xB0\xA9\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3D"],
        ["\xF3\xB0\xA9\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3E"],
        ["\xF3\xB0\xA9\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x3F"],
        ["\xF3\xB0\xA9\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x40"],
        ["\xF3\xB0\xA9\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x41"],
        ["\xF3\xB0\xA9\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x42"],
        ["\xF3\xB0\xA9\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x43"],
        ["\xF3\xB0\xA9\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x44"],
        ["\xF3\xB0\xA9\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x45"],
        ["\xF3\xB0\xA9\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x46"],
        ["\xF3\xB0\xA9\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x47"],
        ["\xF3\xB0\xA9\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x48"],
        ["\xF3\xB0\xA9\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x49"],
        ["\xF3\xB0\xA9\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4A"],
        ["\xF3\xB0\xA9\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4B"],
        ["\xF3\xB0\xA9\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4C"],
        ["\xF3\xB0\xA9\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4D"],
        ["\xF3\xB0\xA9\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4E"],
        ["\xF3\xB0\xA9\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x4F"],
        ["\xF3\xB0\xA9\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x50"],
        ["\xF3\xB0\xA9\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x51"],
        ["\xF3\xB0\xA9\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x52"],
        ["\xF3\xB0\xA9\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x53"],
        ["\xF3\xB0\xA9\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x54"],
        ["\xF3\xB0\xA9\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x55"],
        ["\xF3\xB0\xA9\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x56"],
        ["\xF3\xB0\xA9\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x57"],
        ["\xF3\xB0\xA9\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x58"],
        ["\xF3\xB0\xA9\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x59"],
        ["\xF3\xB0\xA9\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5A"],
        ["\xF3\xB0\xA9\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5B"],
        ["\xF3\xB0\xA9\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5C"],
        ["\xF3\xB0\xA9\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5D"],
        ["\xF3\xB0\xA9\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5E"],
        ["\xF3\xB0\xA9\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x5F"],
        ["\xF3\xB0\xA9\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x60"],
        ["\xF3\xB0\xA9\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x61"],
        ["\xF3\xB0\xA9\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x62"],
        ["\xF3\xB0\xA9\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x63"],
        ["\xF3\xB0\xA9\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x64"],
        ["\xF3\xB0\xA9\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x65"],
        ["\xF3\xB0\xA9\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x66"],
        ["\xF3\xB0\xA9\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x67"],
        ["\xF3\xB0\xA9\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x68"],
        ["\xF3\xB0\xA9\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x69"],
        ["\xF3\xB0\xA9\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6A"],
        ["\xF3\xB0\xA9\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6B"],
        ["\xF3\xB0\xA9\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6C"],
        ["\xF3\xB0\xA9\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6D"],
        ["\xF3\xB0\xA9\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6E"],
        ["\xF3\xB0\xA9\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x6F"],
        ["\xF3\xB0\xA9\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x70"],
        ["\xF3\xB0\xA9\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x71"],
        ["\xF3\xB0\xA9\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x72"],
        ["\xF3\xB0\xAA\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x73"],
        ["\xF3\xB0\xAA\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x74"],
        ["\xF3\xB0\xAA\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x75"],
        ["\xF3\xB0\xAA\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x76"],
        ["\xF3\xB0\xAA\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x77"],
        ["\xF3\xB0\xAA\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x78"],
        ["\xF3\xB0\xAA\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x79"],
        ["\xF3\xB0\xAA\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x7A"],
        ["\xF3\xB0\xAA\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x7B"],
        ["\xF3\xB0\xAA\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x7C"],
        ["\xF3\xB0\xAA\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x7D"],
        ["\xF3\xB0\xAA\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A\x7E"],
        ["\xF3\xB0\xAA\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x21"],
        ["\xF3\xB0\xAA\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x22"],
        ["\xF3\xB0\xAA\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x23"],
        ["\xF3\xB0\xAA\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x24"],
        ["\xF3\xB0\xAA\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x25"],
        ["\xF3\xB0\xAA\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x26"],
        ["\xF3\xB0\xAA\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x27"],
        ["\xF3\xB0\xAA\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x28"],
        ["\xF3\xB0\xAA\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x29"],
        ["\xF3\xB0\xAA\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2A"],
        ["\xF3\xB0\xAA\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2B"],
        ["\xF3\xB0\xAA\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2C"],
        ["\xF3\xB0\xAA\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2D"],
        ["\xF3\xB0\xAA\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2E"],
        ["\xF3\xB0\xAA\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x2F"],
        ["\xF3\xB0\xAA\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x30"],
        ["\xF3\xB0\xAA\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x31"],
        ["\xF3\xB0\xAA\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x32"],
        ["\xF3\xB0\xAA\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x33"],
        ["\xF3\xB0\xAA\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x34"],
        ["\xF3\xB0\xAA\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x35"],
        ["\xF3\xB0\xAA\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x36"],
        ["\xF3\xB0\xAA\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x37"],
        ["\xF3\xB0\xAA\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x38"],
        ["\xF3\xB0\xAA\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x39"],
        ["\xF3\xB0\xAA\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3A"],
        ["\xF3\xB0\xAA\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3B"],
        ["\xF3\xB0\xAA\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3C"],
        ["\xF3\xB0\xAA\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3D"],
        ["\xF3\xB0\xAA\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3E"],
        ["\xF3\xB0\xAA\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x3F"],
        ["\xF3\xB0\xAA\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x40"],
        ["\xF3\xB0\xAA\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x41"],
        ["\xF3\xB0\xAA\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x42"],
        ["\xF3\xB0\xAA\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x43"],
        ["\xF3\xB0\xAA\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x44"],
        ["\xF3\xB0\xAA\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x45"],
        ["\xF3\xB0\xAA\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x46"],
        ["\xF3\xB0\xAA\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x47"],
        ["\xF3\xB0\xAA\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x48"],
        ["\xF3\xB0\xAA\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x49"],
        ["\xF3\xB0\xAA\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4A"],
        ["\xF3\xB0\xAA\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4B"],
        ["\xF3\xB0\xAA\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4C"],
        ["\xF3\xB0\xAA\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4D"],
        ["\xF3\xB0\xAA\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4E"],
        ["\xF3\xB0\xAA\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x4F"],
        ["\xF3\xB0\xAA\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x50"],
        ["\xF3\xB0\xAA\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x51"],
        ["\xF3\xB0\xAA\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x52"],
        ["\xF3\xB0\xAA\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x53"],
        ["\xF3\xB0\xAA\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x54"],
        ["\xF3\xB0\xAB\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x55"],
        ["\xF3\xB0\xAB\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x56"],
        ["\xF3\xB0\xAB\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x57"],
        ["\xF3\xB0\xAB\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x58"],
        ["\xF3\xB0\xAB\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x59"],
        ["\xF3\xB0\xAB\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5A"],
        ["\xF3\xB0\xAB\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5B"],
        ["\xF3\xB0\xAB\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5C"],
        ["\xF3\xB0\xAB\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5D"],
        ["\xF3\xB0\xAB\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5E"],
        ["\xF3\xB0\xAB\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x5F"],
        ["\xF3\xB0\xAB\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x60"],
        ["\xF3\xB0\xAB\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x61"],
        ["\xF3\xB0\xAB\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x62"],
        ["\xF3\xB0\xAB\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x63"],
        ["\xF3\xB0\xAB\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x64"],
        ["\xF3\xB0\xAB\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x65"],
        ["\xF3\xB0\xAB\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x66"],
        ["\xF3\xB0\xAB\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x67"],
        ["\xF3\xB0\xAB\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x68"],
        ["\xF3\xB0\xAB\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x69"],
        ["\xF3\xB0\xAB\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6A"],
        ["\xF3\xB0\xAB\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6B"],
        ["\xF3\xB0\xAB\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6C"],
        ["\xF3\xB0\xAB\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6D"],
        ["\xF3\xB0\xAB\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6E"],
        ["\xF3\xB0\xAB\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x6F"],
        ["\xF3\xB0\xAB\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x70"],
        ["\xF3\xB0\xAB\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x71"],
        ["\xF3\xB0\xAB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x72"],
        ["\xF3\xB0\xAB\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x73"],
        ["\xF3\xB0\xAB\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x74"],
        ["\xF3\xB0\xAB\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x75"],
        ["\xF3\xB0\xAB\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x76"],
        ["\xF3\xB0\xAB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x77"],
        ["\xF3\xB0\xAB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x78"],
        ["\xF3\xB0\xAB\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x79"],
        ["\xF3\xB0\xAB\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x7A"],
        ["\xF3\xB0\xAB\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x7B"],
        ["\xF3\xB0\xAB\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x7C"],
        ["\xF3\xB0\xAB\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x7D"],
        ["\xF3\xB0\xAB\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B\x7E"],
        ["\xF3\xB0\xAB\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x21"],
        ["\xF3\xB0\xAB\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x22"],
        ["\xF3\xB0\xAB\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x23"],
        ["\xF3\xB0\xAB\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x24"],
        ["\xF3\xB0\xAB\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x25"],
        ["\xF3\xB0\xAB\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x26"],
        ["\xF3\xB0\xAB\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x27"],
        ["\xF3\xB0\xAB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x28"],
        ["\xF3\xB0\xAB\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x29"],
        ["\xF3\xB0\xAB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2A"],
        ["\xF3\xB0\xAB\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2B"],
        ["\xF3\xB0\xAB\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2C"],
        ["\xF3\xB0\xAB\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2D"],
        ["\xF3\xB0\xAB\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2E"],
        ["\xF3\xB0\xAB\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x2F"],
        ["\xF3\xB0\xAB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x30"],
        ["\xF3\xB0\xAB\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x31"],
        ["\xF3\xB0\xAB\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x32"],
        ["\xF3\xB0\xAB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x33"],
        ["\xF3\xB0\xAB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x34"],
        ["\xF3\xB0\xAB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x35"],
        ["\xF3\xB0\xAB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x36"],
        ["\xF3\xB0\xAC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x37"],
        ["\xF3\xB0\xAC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x38"],
        ["\xF3\xB0\xAC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x39"],
        ["\xF3\xB0\xAC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3A"],
        ["\xF3\xB0\xAC\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3B"],
        ["\xF3\xB0\xAC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3C"],
        ["\xF3\xB0\xAC\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3D"],
        ["\xF3\xB0\xAC\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3E"],
        ["\xF3\xB0\xAC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x3F"],
        ["\xF3\xB0\xAC\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x40"],
        ["\xF3\xB0\xAC\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x41"],
        ["\xF3\xB0\xAC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x42"],
        ["\xF3\xB0\xAC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x43"],
        ["\xF3\xB0\xAC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x44"],
        ["\xF3\xB0\xAC\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x45"],
        ["\xF3\xB0\xAC\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x46"],
        ["\xF3\xB0\xAC\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x47"],
        ["\xF3\xB0\xAC\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x48"],
        ["\xF3\xB0\xAC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x22"],
        ["\xF3\xB0\xAC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4A"],
        ["\xF3\xB0\xAC\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4B"],
        ["\xF3\xB0\xAC\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4C"],
        ["\xF3\xB0\xAC\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4D"],
        ["\xF3\xB0\xAC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4E"],
        ["\xF3\xB0\xAC\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x4F"],
        ["\xF3\xB0\xAC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x50"],
        ["\xF3\xB0\xAC\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x51"],
        ["\xF3\xB0\xAC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x52"],
        ["\xF3\xB0\xAC\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x53"],
        ["\xF3\xB0\xAC\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x54"],
        ["\xF3\xB0\xAC\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x55"],
        ["\xF3\xB0\xAC\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x56"],
        ["\xF3\xB0\xAC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x57"],
        ["\xF3\xB0\xAC\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x58"],
        ["\xF3\xB0\xAC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x59"],
        ["\xF3\xB0\xAC\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5A"],
        ["\xF3\xB0\xAC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5B"],
        ["\xF3\xB0\xAC\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5C"],
        ["\xF3\xB0\xAC\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5D"],
        ["\xF3\xB0\xAC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5E"],
        ["\xF3\xB0\xAC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x5F"],
        ["\xF3\xB0\xAC\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x60"],
        ["\xF3\xB0\xAC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x61"],
        ["\xF3\xB0\xAC\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x62"],
        ["\xF3\xB0\xAC\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x63"],
        ["\xF3\xB0\xAC\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x64"],
        ["\xF3\xB0\xAC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x65"],
        ["\xF3\xB0\xAC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x66"],
        ["\xF3\xB0\xAC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x67"],
        ["\xF3\xB0\xAC\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x68"],
        ["\xF3\xB0\xAC\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x69"],
        ["\xF3\xB0\xAC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6A"],
        ["\xF3\xB0\xAC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6B"],
        ["\xF3\xB0\xAC\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6C"],
        ["\xF3\xB0\xAC\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6D"],
        ["\xF3\xB0\xAC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6E"],
        ["\xF3\xB0\xAC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x6F"],
        ["\xF3\xB0\xAC\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x70"],
        ["\xF3\xB0\xAC\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x71"],
        ["\xF3\xB0\xAC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x72"],
        ["\xF3\xB0\xAC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x73"],
        ["\xF3\xB0\xAC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x74"],
        ["\xF3\xB0\xAC\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x75"],
        ["\xF3\xB0\xAC\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x76"],
        ["\xF3\xB0\xAD\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x77"],
        ["\xF3\xB0\xAD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x78"],
        ["\xF3\xB0\xAD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x79"],
        ["\xF3\xB0\xAD\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x7A"],
        ["\xF3\xB0\xAD\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x7B"],
        ["\xF3\xB0\xAD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x7C"],
        ["\xF3\xB0\xAD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x7D"],
        ["\xF3\xB0\xAD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x7E"],
        ["\xF3\xB0\xAD\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x21"],
        ["\xF3\xB0\xAD\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x22"],
        ["\xF3\xB0\xAD\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x23"],
        ["\xF3\xB0\xAD\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x24"],
        ["\xF3\xB0\xAD\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x25"],
        ["\xF3\xB0\xAD\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x26"],
        ["\xF3\xB0\xAD\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x27"],
        ["\xF3\xB0\xAD\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x28"],
        ["\xF3\xB0\xAD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x29"],
        ["\xF3\xB0\xAD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2A"],
        ["\xF3\xB0\xAD\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2B"],
        ["\xF3\xB0\xAD\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2C"],
        ["\xF3\xB0\xAD\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2D"],
        ["\xF3\xB0\xAD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2E"],
        ["\xF3\xB0\xAD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x2F"],
        ["\xF3\xB0\xAD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x30"],
        ["\xF3\xB0\xAD\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x31"],
        ["\xF3\xB0\xAD\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x32"],
        ["\xF3\xB0\xAD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x33"],
        ["\xF3\xB0\xAD\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x34"],
        ["\xF3\xB0\xAD\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x35"],
        ["\xF3\xB0\xAD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x36"],
        ["\xF3\xB0\xAD\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x37"],
        ["\xF3\xB0\xAD\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x38"],
        ["\xF3\xB0\xAD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x39"],
        ["\xF3\xB0\xAD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3A"],
        ["\xF3\xB0\xAD\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3B"],
        ["\xF3\xB0\xAD\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3C"],
        ["\xF3\xB0\xAD\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3D"],
        ["\xF3\xB0\xAD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3E"],
        ["\xF3\xB0\xAD\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x3F"],
        ["\xF3\xB0\xAD\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x40"],
        ["\xF3\xB0\xAD\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x41"],
        ["\xF3\xB0\xAD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x42"],
        ["\xF3\xB0\xAD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x43"],
        ["\xF3\xB0\xAD\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x44"],
        ["\xF3\xB0\xAD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x45"],
        ["\xF3\xB0\xAD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x46"],
        ["\xF3\xB0\xAD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x47"],
        ["\xF3\xB0\xAD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x48"],
        ["\xF3\xB0\xAD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x49"],
        ["\xF3\xB0\xAD\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4A"],
        ["\xF3\xB0\xAD\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4B"],
        ["\xF3\xB0\xAD\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4C"],
        ["\xF3\xB0\xAD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4D"],
        ["\xF3\xB0\xAD\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4E"],
        ["\xF3\xB0\xAD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x4F"],
        ["\xF3\xB0\xAD\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x50"],
        ["\xF3\xB0\xAD\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x51"],
        ["\xF3\xB0\xAD\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x52"],
        ["\xF3\xB0\xAD\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x53"],
        ["\xF3\xB0\xAD\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x54"],
        ["\xF3\xB0\xAD\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x55"],
        ["\xF3\xB0\xAD\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x56"],
        ["\xF3\xB0\xAD\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x57"],
        ["\xF3\xB0\xAD\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x58"],
        ["\xF3\xB0\xAE\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x59"],
        ["\xF3\xB0\xAE\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5A"],
        ["\xF3\xB0\xAE\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5B"],
        ["\xF3\xB0\xAE\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5C"],
        ["\xF3\xB0\xAE\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5D"],
        ["\xF3\xB0\xAE\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5E"],
        ["\xF3\xB0\xAE\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x5F"],
        ["\xF3\xB0\xAE\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x60"],
        ["\xF3\xB0\xAE\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x61"],
        ["\xF3\xB0\xAE\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x62"],
        ["\xF3\xB0\xAE\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x63"],
        ["\xF3\xB0\xAE\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x64"],
        ["\xF3\xB0\xAE\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x65"],
        ["\xF3\xB0\xAE\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x66"],
        ["\xF3\xB0\xAE\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x67"],
        ["\xF3\xB0\xAE\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x68"],
        ["\xF3\xB0\xAE\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x69"],
        ["\xF3\xB0\xAE\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6A"],
        ["\xF3\xB0\xAE\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6B"],
        ["\xF3\xB0\xAE\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6C"],
        ["\xF3\xB0\xAE\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6D"],
        ["\xF3\xB0\xAE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6E"],
        ["\xF3\xB0\xAE\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x6F"],
        ["\xF3\xB0\xAE\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x70"],
        ["\xF3\xB0\xAE\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x71"],
        ["\xF3\xB0\xAE\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x72"],
        ["\xF3\xB0\xAE\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x73"],
        ["\xF3\xB0\xAE\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x74"],
        ["\xF3\xB0\xAE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x75"],
        ["\xF3\xB0\xAE\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x76"],
        ["\xF3\xB0\xAE\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x77"],
        ["\xF3\xB0\xAE\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x78"],
        ["\xF3\xB0\xAE\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x79"],
        ["\xF3\xB0\xAE\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x7A"],
        ["\xF3\xB0\xAE\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x7B"],
        ["\xF3\xB0\xAE\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x7C"],
        ["\xF3\xB0\xAE\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x7D"],
        ["\xF3\xB0\xAE\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D\x7E"],
        ["\xF3\xB0\xAE\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x21"],
        ["\xF3\xB0\xAE\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x22"],
        ["\xF3\xB0\xAE\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x23"],
        ["\xF3\xB0\xAE\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x24"],
        ["\xF3\xB0\xAE\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x25"],
        ["\xF3\xB0\xAE\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x26"],
        ["\xF3\xB0\xAE\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x27"],
        ["\xF3\xB0\xAE\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x28"],
        ["\xF3\xB0\xAE\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x29"],
        ["\xF3\xB0\xAE\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2A"],
        ["\xF3\xB0\xAE\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2B"],
        ["\xF3\xB0\xAE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2C"],
        ["\xF3\xB0\xAE\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2D"],
        ["\xF3\xB0\xAE\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2E"],
        ["\xF3\xB0\xAE\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x2F"],
        ["\xF3\xB0\xAE\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x30"],
        ["\xF3\xB0\xAE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x31"],
        ["\xF3\xB0\xAE\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x32"],
        ["\xF3\xB0\xAE\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x33"],
        ["\xF3\xB0\xAE\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x34"],
        ["\xF3\xB0\xAE\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x35"],
        ["\xF3\xB0\xAE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x36"],
        ["\xF3\xB0\xAE\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x37"],
        ["\xF3\xB0\xAE\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x38"],
        ["\xF3\xB0\xAE\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x39"],
        ["\xF3\xB0\xAE\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3A"],
        ["\xF3\xB0\xAF\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3B"],
        ["\xF3\xB0\xAF\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3C"],
        ["\xF3\xB0\xAF\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3D"],
        ["\xF3\xB0\xAF\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3E"],
        ["\xF3\xB0\xAF\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x3F"],
        ["\xF3\xB0\xAF\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x40"],
        ["\xF3\xB0\xAF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x41"],
        ["\xF3\xB0\xAF\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x42"],
        ["\xF3\xB0\xAF\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x43"],
        ["\xF3\xB0\xAF\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x44"],
        ["\xF3\xB0\xAF\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x45"],
        ["\xF3\xB0\xAF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x46"],
        ["\xF3\xB0\xAF\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x47"],
        ["\xF3\xB0\xAF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x48"],
        ["\xF3\xB0\xAF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x49"],
        ["\xF3\xB0\xAF\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4A"],
        ["\xF3\xB0\xAF\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4B"],
        ["\xF3\xB0\xAF\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4C"],
        ["\xF3\xB0\xAF\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4D"],
        ["\xF3\xB0\xAF\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4E"],
        ["\xF3\xB0\xAF\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x4F"],
        ["\xF3\xB0\xAF\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x50"],
        ["\xF3\xB0\xAF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x51"],
        ["\xF3\xB0\xAF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x52"],
        ["\xF3\xB0\xAF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x53"],
        ["\xF3\xB0\xAF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x54"],
        ["\xF3\xB0\xAF\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x55"],
        ["\xF3\xB0\xAF\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x56"],
        ["\xF3\xB0\xAF\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x57"],
        ["\xF3\xB0\xAF\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x58"],
        ["\xF3\xB0\xAF\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x59"],
        ["\xF3\xB0\xAF\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5A"],
        ["\xF3\xB0\xAF\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5B"],
        ["\xF3\xB0\xAF\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5C"],
        ["\xF3\xB0\xAF\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5D"],
        ["\xF3\xB0\xAF\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5E"],
        ["\xF3\xB0\xAF\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x5F"],
        ["\xF3\xB0\xAF\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x60"],
        ["\xF3\xB0\xAF\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x61"],
        ["\xF3\xB0\xAF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x62"],
        ["\xF3\xB0\xAF\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x63"],
        ["\xF3\xB0\xAF\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x64"],
        ["\xF3\xB0\xAF\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x65"],
        ["\xF3\xB0\xAF\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x66"],
        ["\xF3\xB0\xAF\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x67"],
        ["\xF3\xB0\xAF\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x68"],
        ["\xF3\xB0\xAF\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x69"],
        ["\xF3\xB0\xAF\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6A"],
        ["\xF3\xB0\xAF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6B"],
        ["\xF3\xB0\xAF\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6C"],
        ["\xF3\xB0\xAF\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6D"],
        ["\xF3\xB0\xAF\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6E"],
        ["\xF3\xB0\xAF\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x6F"],
        ["\xF3\xB0\xAF\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x70"],
        ["\xF3\xB0\xAF\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x71"],
        ["\xF3\xB0\xAF\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x72"],
        ["\xF3\xB0\xAF\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x73"],
        ["\xF3\xB0\xAF\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x74"],
        ["\xF3\xB0\xAF\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x75"],
        ["\xF3\xB0\xAF\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x76"],
        ["\xF3\xB0\xAF\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x77"],
        ["\xF3\xB0\xAF\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x78"],
        ["\xF3\xB0\xAF\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x79"],
        ["\xF3\xB0\xAF\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x7A"],
        ["\xF3\xB0\xB0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x7B"],
        ["\xF3\xB0\xB0\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x7C"],
        ["\xF3\xB0\xB0\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x7D"],
        ["\xF3\xB0\xB0\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E\x7E"],
        ["\xF3\xB0\xB0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x21"],
        ["\xF3\xB0\xB0\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x22"],
        ["\xF3\xB0\xB0\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x23"],
        ["\xF3\xB0\xB0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x24"],
        ["\xF3\xB0\xB0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x25"],
        ["\xF3\xB0\xB0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x26"],
        ["\xF3\xB0\xB0\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x27"],
        ["\xF3\xB0\xB0\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x28"],
        ["\xF3\xB0\xB0\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x29"],
        ["\xF3\xB0\xB0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2A"],
        ["\xF3\xB0\xB0\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2B"],
        ["\xF3\xB0\xB0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2C"],
        ["\xF3\xB0\xB0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2D"],
        ["\xF3\xB0\xB0\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2E"],
        ["\xF3\xB0\xB0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x2F"],
        ["\xF3\xB0\xB0\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x30"],
        ["\xF3\xB0\xB0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x31"],
        ["\xF3\xB0\xB0\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x32"],
        ["\xF3\xB0\xB0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x33"],
        ["\xF3\xB0\xB0\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x34"],
        ["\xF3\xB0\xB0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x35"],
        ["\xF3\xB0\xB0\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x36"],
        ["\xF3\xB0\xB0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x37"],
        ["\xF3\xB0\xB0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x38"],
        ["\xF3\xB0\xB0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x39"],
        ["\xF3\xB0\xB0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3A"],
        ["\xF3\xB0\xB0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3B"],
        ["\xF3\xB0\xB0\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3C"],
        ["\xF3\xB0\xB0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3D"],
        ["\xF3\xB0\xB0\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3E"],
        ["\xF3\xB0\xB0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x3F"],
        ["\xF3\xB0\xB0\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x40"],
        ["\xF3\xB0\xB0\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x41"],
        ["\xF3\xB0\xB0\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x42"],
        ["\xF3\xB0\xB0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x43"],
        ["\xF3\xB0\xB0\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x44"],
        ["\xF3\xB0\xB0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x45"],
        ["\xF3\xB0\xB0\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x46"],
        ["\xF3\xB0\xB0\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x47"],
        ["\xF3\xB0\xB0\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x48"],
        ["\xF3\xB0\xB0\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x49"],
        ["\xF3\xB0\xB0\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4A"],
        ["\xF3\xB0\xB0\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4B"],
        ["\xF3\xB0\xB0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4C"],
        ["\xF3\xB0\xB0\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4D"],
        ["\xF3\xB0\xB0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4E"],
        ["\xF3\xB0\xB0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x4F"],
        ["\xF3\xB0\xB0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x50"],
        ["\xF3\xB0\xB0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x51"],
        ["\xF3\xB0\xB0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x52"],
        ["\xF3\xB0\xB0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x53"],
        ["\xF3\xB0\xB0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x54"],
        ["\xF3\xB0\xB0\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x55"],
        ["\xF3\xB0\xB0\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x56"],
        ["\xF3\xB0\xB0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x57"],
        ["\xF3\xB0\xB0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x58"],
        ["\xF3\xB0\xB0\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],
        ["\xF3\xB0\xB0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5A"],
        ["\xF3\xB0\xB0\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5B"],
        ["\xF3\xB0\xB0\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5C"],
        ["\xF3\xB0\xB1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5D"],
        ["\xF3\xB0\xB1\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5E"],
        ["\xF3\xB0\xB1\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x5F"],
        ["\xF3\xB0\xB1\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x60"],
        ["\xF3\xB0\xB1\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x61"],
        ["\xF3\xB0\xB1\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x62"],
        ["\xF3\xB0\xB1\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x63"],
        ["\xF3\xB0\xB1\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x64"],
        ["\xF3\xB0\xB1\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x65"],
        ["\xF3\xB0\xB1\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x66"],
        ["\xF3\xB0\xB1\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x67"],
        ["\xF3\xB0\xB1\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x68"],
        ["\xF3\xB0\xB1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x69"],
        ["\xF3\xB0\xB1\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6A"],
        ["\xF3\xB0\xB1\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6B"],
        ["\xF3\xB0\xB1\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6C"],
        ["\xF3\xB0\xB1\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6D"],
        ["\xF3\xB0\xB1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6E"],
        ["\xF3\xB0\xB1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x6F"],
        ["\xF3\xB0\xB1\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x70"],
        ["\xF3\xB0\xB1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x71"],
        ["\xF3\xB0\xB1\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x72"],
        ["\xF3\xB0\xB1\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x73"],
        ["\xF3\xB0\xB1\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x74"],
        ["\xF3\xB0\xB1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x75"],
        ["\xF3\xB0\xB1\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x76"],
        ["\xF3\xB0\xB1\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x77"],
        ["\xF3\xB0\xB1\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x78"],
        ["\xF3\xB0\xB1\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x79"],
        ["\xF3\xB0\xB1\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x7A"],
        ["\xF3\xB0\xB1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x7B"],
        ["\xF3\xB0\xB1\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x7C"],
        ["\xF3\xB0\xB1\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x7D"],
        ["\xF3\xB0\xB1\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x7E"],
        ["\xF3\xB0\xB1\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x21"],
        ["\xF3\xB0\xB1\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x22"],
        ["\xF3\xB0\xB1\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x23"],
        ["\xF3\xB0\xB1\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x24"],
        ["\xF3\xB0\xB1\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x25"],
        ["\xF3\xB0\xB1\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x26"],
        ["\xF3\xB0\xB1\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x27"],
        ["\xF3\xB0\xB1\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x28"],
        ["\xF3\xB0\xB1\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x29"],
        ["\xF3\xB0\xB1\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2A"],
        ["\xF3\xB0\xB1\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2B"],
        ["\xF3\xB0\xB1\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2C"],
        ["\xF3\xB0\xB1\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2D"],
        ["\xF3\xB0\xB1\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2E"],
        ["\xF3\xB0\xB1\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x2F"],
        ["\xF3\xB0\xB1\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x30"],
        ["\xF3\xB0\xB1\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x31"],
        ["\xF3\xB0\xB1\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x32"],
        ["\xF3\xB0\xB1\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x33"],
        ["\xF3\xB0\xB1\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x34"],
        ["\xF3\xB0\xB1\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x35"],
        ["\xF3\xB0\xB1\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x36"],
        ["\xF3\xB0\xB1\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x37"],
        ["\xF3\xB0\xB1\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x38"],
        ["\xF3\xB0\xB1\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x39"],
        ["\xF3\xB0\xB1\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3A"],
        ["\xF3\xB0\xB1\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3B"],
        ["\xF3\xB0\xB1\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3C"],
        ["\xF3\xB0\xB1\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3D"],
        ["\xF3\xB0\xB1\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3E"],
        ["\xF3\xB0\xB2\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x3F"],
        ["\xF3\xB0\xB2\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\xF3\xB0\xB2\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x41"],
        ["\xF3\xB0\xB2\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x42"],
        ["\xF3\xB0\xB2\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x43"],
        ["\xF3\xB0\xB2\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x44"],
        ["\xF3\xB0\xB2\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x45"],
        ["\xF3\xB0\xB2\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x46"],
        ["\xF3\xB0\xB2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x47"],
        ["\xF3\xB0\xB2\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x48"],
        ["\xF3\xB0\xB2\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x49"],
        ["\xF3\xB0\xB2\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4A"],
        ["\xF3\xB0\xB2\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4B"],
        ["\xF3\xB0\xB2\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4C"],
        ["\xF3\xB0\xB2\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4D"],
        ["\xF3\xB0\xB2\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4E"],
        ["\xF3\xB0\xB2\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x4F"],
        ["\xF3\xB0\xB2\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x50"],
        ["\xF3\xB0\xB2\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x51"],
        ["\xF3\xB0\xB2\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x52"],
        ["\xF3\xB0\xB2\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x53"],
        ["\xF3\xB0\xB2\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x54"],
        ["\xF3\xB0\xB2\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x55"],
        ["\xF3\xB0\xB2\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x56"],
        ["\xF3\xB0\xB2\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x57"],
        ["\xF3\xB0\xB2\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x58"],
        ["\xF3\xB0\xB2\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x59"],
        ["\xF3\xB0\xB2\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5A"],
        ["\xF3\xB0\xB2\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5B"],
        ["\xF3\xB0\xB2\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5C"],
        ["\xF3\xB0\xB2\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5D"],
        ["\xF3\xB0\xB2\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5E"],
        ["\xF3\xB0\xB2\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x5F"],
        ["\xF3\xB0\xB2\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x60"],
        ["\xF3\xB0\xB2\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x61"],
        ["\xF3\xB0\xB2\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x62"],
        ["\xF3\xB0\xB2\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x63"],
        ["\xF3\xB0\xB2\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x64"],
        ["\xF3\xB0\xB2\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x65"],
        ["\xF3\xB0\xB2\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x66"],
        ["\xF3\xB0\xB2\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x67"],
        ["\xF3\xB0\xB2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x68"],
        ["\xF3\xB0\xB2\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x69"],
        ["\xF3\xB0\xB2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6A"],
        ["\xF3\xB0\xB2\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6B"],
        ["\xF3\xB0\xB2\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6C"],
        ["\xF3\xB0\xB2\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6D"],
        ["\xF3\xB0\xB2\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6E"],
        ["\xF3\xB0\xB2\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x6F"],
        ["\xF3\xB0\xB2\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x70"],
        ["\xF3\xB0\xB2\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x71"],
        ["\xF3\xB0\xB2\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x72"],
        ["\xF3\xB0\xB2\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x73"],
        ["\xF3\xB0\xB2\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x74"],
        ["\xF3\xB0\xB2\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x75"],
        ["\xF3\xB0\xB2\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x76"],
        ["\xF3\xB0\xB2\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x77"],
        ["\xF3\xB0\xB2\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x78"],
        ["\xF3\xB0\xB2\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x79"],
        ["\xF3\xB0\xB2\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x7A"],
        ["\xF3\xB0\xB2\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x7B"],
        ["\xF3\xB0\xB2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x7C"],
        ["\xF3\xB0\xB2\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x7D"],
        ["\xF3\xB0\xB2\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40\x7E"],
        ["\xF3\xB0\xB3\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x21"],
        ["\xF3\xB0\xB3\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x22"],
        ["\xF3\xB0\xB3\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x23"],
        ["\xF3\xB0\xB3\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x24"],
        ["\xF3\xB0\xB3\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x25"],
        ["\xF3\xB0\xB3\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x26"],
        ["\xF3\xB0\xB3\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x27"],
        ["\xF3\xB0\xB3\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],
        ["\xF3\xB0\xB3\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x29"],
        ["\xF3\xB0\xB3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2A"],
        ["\xF3\xB0\xB3\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2B"],
        ["\xF3\xB0\xB3\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2C"],
        ["\xF3\xB0\xB3\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2D"],
        ["\xF3\xB0\xB3\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2E"],
        ["\xF3\xB0\xB3\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x2F"],
        ["\xF3\xB0\xB3\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x30"],
        ["\xF3\xB0\xB3\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x31"],
        ["\xF3\xB0\xB3\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x32"],
        ["\xF3\xB0\xB3\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x33"],
        ["\xF3\xB0\xB3\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x34"],
        ["\xF3\xB0\xB3\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x35"],
        ["\xF3\xB0\xB3\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x36"],
        ["\xF3\xB0\xB3\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x37"],
        ["\xF3\xB0\xB3\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x38"],
        ["\xF3\xB0\xB3\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x39"],
        ["\xF3\xB0\xB3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3A"],
        ["\xF3\xB0\xB3\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3B"],
        ["\xF3\xB0\xB3\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3C"],
        ["\xF3\xB0\xB3\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3D"],
        ["\xF3\xB0\xB3\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3E"],
        ["\xF3\xB0\xB3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x3F"],
        ["\xF3\xB0\xB3\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x40"],
        ["\xF3\xB0\xB3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\xF3\xB0\xB3\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\xF3\xB0\xB3\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\xF3\xB0\xB3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\xF3\xB0\xB3\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\xF3\xB0\xB3\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\xF3\xB0\xB3\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\xF3\xB0\xB3\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\xF3\xB0\xB3\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\xF3\xB0\xB3\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\xF3\xB0\xB3\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\xF3\xB0\xB3\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\xF3\xB0\xB3\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\xF3\xB0\xB3\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\xF3\xB0\xB3\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\xF3\xB0\xB3\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\xF3\xB0\xB3\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\xF3\xB0\xB3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\xF3\xB0\xB3\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\xF3\xB0\xB3\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\xF3\xB0\xB3\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\xF3\xB0\xB3\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\xF3\xB0\xB3\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\xF3\xB0\xB3\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\xF3\xB0\xB3\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x59"],
        ["\xF3\xB0\xB3\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5A"],
        ["\xF3\xB0\xB3\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5B"],
        ["\xF3\xB0\xB3\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5C"],
        ["\xF3\xB0\xB3\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5D"],
        ["\xF3\xB0\xB3\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5E"],
        ["\xF3\xB0\xB3\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x5F"],
        ["\xF3\xB0\xB3\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x60"],
        ["\xF3\xB0\xB4\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\xF3\xB0\xB4\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\xF3\xB0\xB4\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\xF3\xB0\xB4\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\xF3\xB0\xB4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\xF3\xB0\xB4\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\xF3\xB0\xB4\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\xF3\xB0\xB4\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\xF3\xB0\xB4\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\xF3\xB0\xB4\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\xF3\xB0\xB4\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\xF3\xB0\xB4\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\xF3\xB0\xB4\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\xF3\xB0\xB4\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\xF3\xB0\xB4\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\xF3\xB0\xB4\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\xF3\xB0\xB4\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\xF3\xB0\xB4\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\xF3\xB0\xB4\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\xF3\xB0\xB4\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\xF3\xB0\xB4\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\xF3\xB0\xB4\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\xF3\xB0\xB4\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\xF3\xB0\xB4\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\xF3\xB0\xB4\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x79"],
        ["\xF3\xB0\xB4\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x7A"],
        ["\xF3\xB0\xB4\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x7B"],
        ["\xF3\xB0\xB4\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x7C"],
        ["\xF3\xB0\xB4\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x7D"],
        ["\xF3\xB0\xB4\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x7E"],
        ["\xF3\xB0\xB4\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x21"],
        ["\xF3\xB0\xB4\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x22"],
        ["\xF3\xB0\xB4\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x23"],
        ["\xF3\xB0\xB4\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x24"],
        ["\xF3\xB0\xB4\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x25"],
        ["\xF3\xB0\xB4\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x26"],
        ["\xF3\xB0\xB4\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x27"],
        ["\xF3\xB0\xB4\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x28"],
        ["\xF3\xB0\xB4\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x29"],
        ["\xF3\xB0\xB4\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2A"],
        ["\xF3\xB0\xB4\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2B"],
        ["\xF3\xB0\xB4\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2C"],
        ["\xF3\xB0\xB4\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2D"],
        ["\xF3\xB0\xB4\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2E"],
        ["\xF3\xB0\xB4\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x2F"],
        ["\xF3\xB0\xB4\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x30"],
        ["\xF3\xB0\xB4\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x31"],
        ["\xF3\xB0\xB4\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x32"],
        ["\xF3\xB0\xB4\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x33"],
        ["\xF3\xB0\xB4\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x34"],
        ["\xF3\xB0\xB4\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x35"],
        ["\xF3\xB0\xB4\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x36"],
        ["\xF3\xB0\xB4\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x37"],
        ["\xF3\xB0\xB4\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x38"],
        ["\xF3\xB0\xB4\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x39"],
        ["\xF3\xB0\xB4\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3A"],
        ["\xF3\xB0\xB4\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3B"],
        ["\xF3\xB0\xB4\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3C"],
        ["\xF3\xB0\xB4\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3D"],
        ["\xF3\xB0\xB4\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3E"],
        ["\xF3\xB0\xB4\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x3F"],
        ["\xF3\xB0\xB4\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x40"],
        ["\xF3\xB0\xB4\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x41"],
        ["\xF3\xB0\xB4\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x42"],
        ["\xF3\xB0\xB5\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x43"],
        ["\xF3\xB0\xB5\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x44"],
        ["\xF3\xB0\xB5\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x45"],
        ["\xF3\xB0\xB5\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x46"],
        ["\xF3\xB0\xB5\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x47"],
        ["\xF3\xB0\xB5\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x48"],
        ["\xF3\xB0\xB5\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x49"],
        ["\xF3\xB0\xB5\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\xF3\xB0\xB5\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\xF3\xB0\xB5\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\xF3\xB0\xB5\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\xF3\xB0\xB5\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\xF3\xB0\xB5\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\xF3\xB0\xB5\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\xF3\xB0\xB5\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x51"],
        ["\xF3\xB0\xB5\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x52"],
        ["\xF3\xB0\xB5\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x53"],
        ["\xF3\xB0\xB5\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x54"],
        ["\xF3\xB0\xB5\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x55"],
        ["\xF3\xB0\xB5\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x56"],
        ["\xF3\xB0\xB5\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x57"],
        ["\xF3\xB0\xB5\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x58"],
        ["\xF3\xB0\xB5\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x59"],
        ["\xF3\xB0\xB5\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\xF3\xB0\xB5\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\xF3\xB0\xB5\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\xF3\xB0\xB5\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\xF3\xB0\xB5\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\xF3\xB0\xB5\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\xF3\xB0\xB5\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],
        ["\xF3\xB0\xB5\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\xF3\xB0\xB5\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x62"],
        ["\xF3\xB0\xB5\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x63"],
        ["\xF3\xB0\xB5\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x64"],
        ["\xF3\xB0\xB5\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x65"],
        ["\xF3\xB0\xB5\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x66"],
        ["\xF3\xB0\xB5\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x67"],
        ["\xF3\xB0\xB5\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x68"],
        ["\xF3\xB0\xB5\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x69"],
        ["\xF3\xB0\xB5\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],
        ["\xF3\xB0\xB5\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\xF3\xB0\xB5\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\xF3\xB0\xB5\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\xF3\xB0\xB5\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\xF3\xB0\xB5\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\xF3\xB0\xB5\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x70"],
        ["\xF3\xB0\xB5\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x71"],
        ["\xF3\xB0\xB5\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x72"],
        ["\xF3\xB0\xB5\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x73"],
        ["\xF3\xB0\xB5\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x74"],
        ["\xF3\xB0\xB5\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x75"],
        ["\xF3\xB0\xB5\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x76"],
        ["\xF3\xB0\xB5\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x77"],
        ["\xF3\xB0\xB5\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x78"],
        ["\xF3\xB0\xB5\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\xF3\xB0\xB5\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\xF3\xB0\xB5\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\xF3\xB0\xB5\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\xF3\xB0\xB5\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],
        ["\xF3\xB0\xB5\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\xF3\xB0\xB5\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x21"],
        ["\xF3\xB0\xB5\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x22"],
        ["\xF3\xB0\xB5\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x23"],
        ["\xF3\xB0\xB5\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x24"],
        ["\xF3\xB0\xB6\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x25"],
        ["\xF3\xB0\xB6\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x26"],
        ["\xF3\xB0\xB6\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x27"],
        ["\xF3\xB0\xB6\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x28"],
        ["\xF3\xB0\xB6\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x29"],
        ["\xF3\xB0\xB6\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2A"],
        ["\xF3\xB0\xB6\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2B"],
        ["\xF3\xB0\xB6\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2C"],
        ["\xF3\xB0\xB6\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2D"],
        ["\xF3\xB0\xB6\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2E"],
        ["\xF3\xB0\xB6\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x2F"],
        ["\xF3\xB0\xB6\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x30"],
        ["\xF3\xB0\xB6\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x31"],
        ["\xF3\xB0\xB6\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x32"],
        ["\xF3\xB0\xB6\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x33"],
        ["\xF3\xB0\xB6\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x34"],
        ["\xF3\xB0\xB6\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x35"],
        ["\xF3\xB0\xB6\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x36"],
        ["\xF3\xB0\xB6\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x37"],
        ["\xF3\xB0\xB6\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x38"],
        ["\xF3\xB0\xB6\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x39"],
        ["\xF3\xB0\xB6\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3A"],
        ["\xF3\xB0\xB6\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3B"],
        ["\xF3\xB0\xB6\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3C"],
        ["\xF3\xB0\xB6\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3D"],
        ["\xF3\xB0\xB6\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3E"],
        ["\xF3\xB0\xB6\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x3F"],
        ["\xF3\xB0\xB6\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x40"],
        ["\xF3\xB0\xB6\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\xF3\xB0\xB6\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\xF3\xB0\xB6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\xF3\xB0\xB6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\xF3\xB0\xB6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\xF3\xB0\xB6\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\xF3\xB0\xB6\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\xF3\xB0\xB6\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\xF3\xB0\xB6\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\xF3\xB0\xB6\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\xF3\xB0\xB6\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\xF3\xB0\xB6\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\xF3\xB0\xB6\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\xF3\xB0\xB6\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\xF3\xB0\xB6\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\xF3\xB0\xB6\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x50"],
        ["\xF3\xB0\xB6\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\xF3\xB0\xB6\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\xF3\xB0\xB6\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\xF3\xB0\xB6\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\xF3\xB0\xB6\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\xF3\xB0\xB6\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\xF3\xB0\xB6\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\xF3\xB0\xB6\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\xF3\xB0\xB6\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\xF3\xB0\xB6\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\xF3\xB0\xB6\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\xF3\xB0\xB6\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\xF3\xB0\xB6\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\xF3\xB0\xB6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\xF3\xB0\xB6\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\xF3\xB0\xB6\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\xF3\xB0\xB6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\xF3\xB0\xB6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\xF3\xB0\xB6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\xF3\xB0\xB6\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\xF3\xB0\xB7\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\xF3\xB0\xB7\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\xF3\xB0\xB7\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\xF3\xB0\xB7\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\xF3\xB0\xB7\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\xF3\xB0\xB7\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\xF3\xB0\xB7\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\xF3\xB0\xB7\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\xF3\xB0\xB7\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\xF3\xB0\xB7\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\xF3\xB0\xB7\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\xF3\xB0\xB7\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\xF3\xB0\xB7\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\xF3\xB0\xB7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\xF3\xB0\xB7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\xF3\xB0\xB7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\xF3\xB0\xB7\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\xF3\xB0\xB7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\xF3\xB0\xB7\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\xF3\xB0\xB7\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\xF3\xB0\xB7\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\xF3\xB0\xB7\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\xF3\xB0\xB7\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x7B"],
        ["\xF3\xB0\xB7\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\xF3\xB0\xB7\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\xF3\xB0\xB7\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\xF3\xB0\xB7\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x21"],
        ["\xF3\xB0\xB7\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x22"],
        ["\xF3\xB0\xB7\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x23"],
        ["\xF3\xB0\xB7\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x24"],
        ["\xF3\xB0\xB7\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x25"],
        ["\xF3\xB0\xB7\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x26"],
        ["\xF3\xB0\xB7\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x27"],
        ["\xF3\xB0\xB7\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x28"],
        ["\xF3\xB0\xB7\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x29"],
        ["\xF3\xB0\xB7\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2A"],
        ["\xF3\xB0\xB7\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2B"],
        ["\xF3\xB0\xB7\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2C"],
        ["\xF3\xB0\xB7\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2D"],
        ["\xF3\xB0\xB7\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2E"],
        ["\xF3\xB0\xB7\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x2F"],
        ["\xF3\xB0\xB7\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x30"],
        ["\xF3\xB0\xB7\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x31"],
        ["\xF3\xB0\xB7\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x32"],
        ["\xF3\xB0\xB7\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x33"],
        ["\xF3\xB0\xB7\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x34"],
        ["\xF3\xB0\xB7\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x35"],
        ["\xF3\xB0\xB7\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x36"],
        ["\xF3\xB0\xB7\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x37"],
        ["\xF3\xB0\xB7\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x38"],
        ["\xF3\xB0\xB7\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x39"],
        ["\xF3\xB0\xB7\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3A"],
        ["\xF3\xB0\xB7\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3B"],
        ["\xF3\xB0\xB7\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3C"],
        ["\xF3\xB0\xB7\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3D"],
        ["\xF3\xB0\xB7\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3E"],
        ["\xF3\xB0\xB7\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x3F"],
        ["\xF3\xB0\xB7\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x40"],
        ["\xF3\xB0\xB7\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x41"],
        ["\xF3\xB0\xB7\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\xF3\xB0\xB7\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\xF3\xB0\xB7\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\xF3\xB0\xB7\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\xF3\xB0\xB7\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\xF3\xB0\xB8\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\xF3\xB0\xB8\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\xF3\xB0\xB8\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\xF3\xB0\xB8\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],
        ["\xF3\xB0\xB8\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\xF3\xB0\xB8\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\xF3\xB0\xB8\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xF3\xB0\xB8\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\xF3\xB0\xB8\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4F"],
        ["\xF3\xB0\xB8\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\xF3\xB0\xB8\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\xF3\xB0\xB8\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\xF3\xB0\xB8\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\xF3\xB0\xB8\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\xF3\xB0\xB8\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\xF3\xB0\xB8\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\xF3\xB0\xB8\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\xF3\xB0\xB8\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x58"],
        ["\xF3\xB0\xB8\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x59"],
        ["\xF3\xB0\xB8\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\xF3\xB0\xB8\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\xF3\xB0\xB8\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\xF3\xB0\xB8\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\xF3\xB0\xB8\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\xF3\xB0\xB8\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\xF3\xB0\xB8\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\xF3\xB0\xB8\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\xF3\xB0\xB8\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\xF3\xB0\xB8\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\xF3\xB0\xB8\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\xF3\xB0\xB8\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\xF3\xB0\xB8\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\xF3\xB0\xB8\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\xF3\xB0\xB8\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\xF3\xB0\xB8\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\xF3\xB0\xB8\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\xF3\xB0\xB8\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\xF3\xB0\xB8\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\xF3\xB0\xB8\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\xF3\xB0\xB8\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\xF3\xB0\xB8\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\xF3\xB0\xB8\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\xF3\xB0\xB8\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\xF3\xB0\xB8\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\xF3\xB0\xB8\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\xF3\xB0\xB8\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\xF3\xB0\xB8\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\xF3\xB0\xB8\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\xF3\xB0\xB8\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\xF3\xB0\xB8\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\xF3\xB0\xB8\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\xF3\xB0\xB8\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\xF3\xB0\xB8\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\xF3\xB0\xB8\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],
        ["\xF3\xB0\xB8\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\xF3\xB0\xB8\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\xF3\xB0\xB8\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x21"],
        ["\xF3\xB0\xB8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x22"],
        ["\xF3\xB0\xB8\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x23"],
        ["\xF3\xB0\xB8\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x24"],
        ["\xF3\xB0\xB8\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x25"],
        ["\xF3\xB0\xB8\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x26"],
        ["\xF3\xB0\xB8\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x27"],
        ["\xF3\xB0\xB8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x28"],
        ["\xF3\xB0\xB9\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x29"],
        ["\xF3\xB0\xB9\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2A"],
        ["\xF3\xB0\xB9\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2B"],
        ["\xF3\xB0\xB9\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2C"],
        ["\xF3\xB0\xB9\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2D"],
        ["\xF3\xB0\xB9\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2E"],
        ["\xF3\xB0\xB9\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x2F"],
        ["\xF3\xB0\xB9\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x30"],
        ["\xF3\xB0\xB9\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x31"],
        ["\xF3\xB0\xB9\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x32"],
        ["\xF3\xB0\xB9\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x33"],
        ["\xF3\xB0\xB9\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x34"],
        ["\xF3\xB0\xB9\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x35"],
        ["\xF3\xB0\xB9\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xF3\xB0\xB9\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x37"],
        ["\xF3\xB0\xB9\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x38"],
        ["\xF3\xB0\xB9\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x39"],
        ["\xF3\xB0\xB9\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3A"],
        ["\xF3\xB0\xB9\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3B"],
        ["\xF3\xB0\xB9\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3C"],
        ["\xF3\xB0\xB9\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3D"],
        ["\xF3\xB0\xB9\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3E"],
        ["\xF3\xB0\xB9\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xF3\xB0\xB9\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x40"],
        ["\xF3\xB0\xB9\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\xF3\xB0\xB9\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\xF3\xB0\xB9\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\xF3\xB0\xB9\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\xF3\xB0\xB9\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\xF3\xB0\xB9\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\xF3\xB0\xB9\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\xF3\xB0\xB9\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\xF3\xB0\xB9\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\xF3\xB0\xB9\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\xF3\xB0\xB9\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\xF3\xB0\xB9\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\xF3\xB0\xB9\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\xF3\xB0\xB9\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\xF3\xB0\xB9\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\xF3\xB0\xB9\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\xF3\xB0\xB9\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\xF3\xB0\xB9\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\xF3\xB0\xB9\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\xF3\xB0\xB9\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\xF3\xB0\xB9\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\xF3\xB0\xB9\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\xF3\xB0\xB9\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\xF3\xB0\xB9\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\xF3\xB0\xB9\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\xF3\xB0\xB9\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\xF3\xB0\xB9\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\xF3\xB0\xB9\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\xF3\xB0\xB9\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\xF3\xB0\xB9\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\xF3\xB0\xB9\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\xF3\xB0\xB9\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\xF3\xB0\xB9\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\xF3\xB0\xB9\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\xF3\xB0\xB9\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\xF3\xB0\xB9\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\xF3\xB0\xB9\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\xF3\xB0\xB9\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\xF3\xB0\xB9\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\xF3\xB0\xB9\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\xF3\xB0\xBA\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\xF3\xB0\xBA\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\xF3\xB0\xBA\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\xF3\xB0\xBA\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\xF3\xB0\xBA\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\xF3\xB0\xBA\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\xF3\xB0\xBA\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\xF3\xB0\xBA\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\xF3\xB0\xBA\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\xF3\xB0\xBA\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\xF3\xB0\xBA\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x39"],
        ["\xF3\xB0\xBA\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\xF3\xB0\xBA\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\xF3\xB0\xBA\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\xF3\xB0\xBA\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\xF3\xB0\xBA\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\xF3\xB0\xBA\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\xF3\xB0\xBA\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\xF3\xB0\xBA\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\xF3\xB0\xBA\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\xF3\xB0\xBA\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\xF3\xB0\xBA\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\xF3\xB0\xBA\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x21"],
        ["\xF3\xB0\xBA\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x22"],
        ["\xF3\xB0\xBA\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x23"],
        ["\xF3\xB0\xBA\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x24"],
        ["\xF3\xB0\xBA\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x25"],
        ["\xF3\xB0\xBA\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x26"],
        ["\xF3\xB0\xBA\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x27"],
        ["\xF3\xB0\xBA\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x28"],
        ["\xF3\xB0\xBA\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x29"],
        ["\xF3\xB0\xBA\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2A"],
        ["\xF3\xB0\xBA\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2B"],
        ["\xF3\xB0\xBA\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2C"],
        ["\xF3\xB0\xBA\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2D"],
        ["\xF3\xB0\xBA\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2E"],
        ["\xF3\xB0\xBA\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x2F"],
        ["\xF3\xB0\xBA\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x30"],
        ["\xF3\xB0\xBA\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x31"],
        ["\xF3\xB0\xBA\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x32"],
        ["\xF3\xB0\xBA\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x33"],
        ["\xF3\xB0\xBA\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x34"],
        ["\xF3\xB0\xBA\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x35"],
        ["\xF3\xB0\xBA\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x36"],
        ["\xF3\xB0\xBA\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x37"],
        ["\xF3\xB0\xBA\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x38"],
        ["\xF3\xB0\xBA\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x39"],
        ["\xF3\xB0\xBA\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3A"],
        ["\xF3\xB0\xBA\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3B"],
        ["\xF3\xB0\xBA\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3C"],
        ["\xF3\xB0\xBA\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3D"],
        ["\xF3\xB0\xBA\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3E"],
        ["\xF3\xB0\xBA\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x3F"],
        ["\xF3\xB0\xBA\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x40"],
        ["\xF3\xB0\xBA\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\xF3\xB0\xBA\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\xF3\xB0\xBA\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\xF3\xB0\xBA\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\xF3\xB0\xBA\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\xF3\xB0\xBA\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\xF3\xB0\xBA\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\xF3\xB0\xBA\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\xF3\xB0\xBA\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\xF3\xB0\xBA\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\xF3\xB0\xBB\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\xF3\xB0\xBB\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\xF3\xB0\xBB\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\xF3\xB0\xBB\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\xF3\xB0\xBB\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\xF3\xB0\xBB\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\xF3\xB0\xBB\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\xF3\xB0\xBB\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\xF3\xB0\xBB\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\xF3\xB0\xBB\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\xF3\xB0\xBB\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\xF3\xB0\xBB\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\xF3\xB0\xBB\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\xF3\xB0\xBB\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\xF3\xB0\xBB\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\xF3\xB0\xBB\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\xF3\xB0\xBB\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\xF3\xB0\xBB\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\xF3\xB0\xBB\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\xF3\xB0\xBB\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\xF3\xB0\xBB\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\xF3\xB0\xBB\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\xF3\xB0\xBB\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\xF3\xB0\xBB\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\xF3\xB0\xBB\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\xF3\xB0\xBB\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\xF3\xB0\xBB\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\xF3\xB0\xBB\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\xF3\xB0\xBB\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\xF3\xB0\xBB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\xF3\xB0\xBB\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\xF3\xB0\xBB\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\xF3\xB0\xBB\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\xF3\xB0\xBB\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\xF3\xB0\xBB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\xF3\xB0\xBB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\xF3\xB0\xBB\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\xF3\xB0\xBB\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\xF3\xB0\xBB\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\xF3\xB0\xBB\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\xF3\xB0\xBB\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\xF3\xB0\xBB\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\xF3\xB0\xBB\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\xF3\xB0\xBB\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],
        ["\xF3\xB0\xBB\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\xF3\xB0\xBB\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\xF3\xB0\xBB\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\xF3\xB0\xBB\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\xF3\xB0\xBB\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\xF3\xB0\xBB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\xF3\xB0\xBB\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\xF3\xB0\xBB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\xF3\xB0\xBB\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x21"],
        ["\xF3\xB0\xBB\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x22"],
        ["\xF3\xB0\xBB\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x23"],
        ["\xF3\xB0\xBB\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x24"],
        ["\xF3\xB0\xBB\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x25"],
        ["\xF3\xB0\xBB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x26"],
        ["\xF3\xB0\xBB\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x27"],
        ["\xF3\xB0\xBB\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x28"],
        ["\xF3\xB0\xBB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x29"],
        ["\xF3\xB0\xBB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2A"],
        ["\xF3\xB0\xBB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2B"],
        ["\xF3\xB0\xBB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2C"],
        ["\xF3\xB0\xBC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2D"],
        ["\xF3\xB0\xBC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2E"],
        ["\xF3\xB0\xBC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x2F"],
        ["\xF3\xB0\xBC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x30"],
        ["\xF3\xB0\xBC\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x31"],
        ["\xF3\xB0\xBC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x32"],
        ["\xF3\xB0\xBC\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x33"],
        ["\xF3\xB0\xBC\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x34"],
        ["\xF3\xB0\xBC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x35"],
        ["\xF3\xB0\xBC\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x36"],
        ["\xF3\xB0\xBC\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x37"],
        ["\xF3\xB0\xBC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x38"],
        ["\xF3\xB0\xBC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x39"],
        ["\xF3\xB0\xBC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3A"],
        ["\xF3\xB0\xBC\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3B"],
        ["\xF3\xB0\xBC\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3C"],
        ["\xF3\xB0\xBC\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3D"],
        ["\xF3\xB0\xBC\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3E"],
        ["\xF3\xB0\xBC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x3F"],
        ["\xF3\xB0\xBC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x40"],
        ["\xF3\xB0\xBC\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\xF3\xB0\xBC\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\xF3\xB0\xBC\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\xF3\xB0\xBC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\xF3\xB0\xBC\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\xF3\xB0\xBC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\xF3\xB0\xBC\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\xF3\xB0\xBC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\xF3\xB0\xBC\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\xF3\xB0\xBC\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\xF3\xB0\xBC\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\xF3\xB0\xBC\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\xF3\xB0\xBC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\xF3\xB0\xBC\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\xF3\xB0\xBC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\xF3\xB0\xBC\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\xF3\xB0\xBC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\xF3\xB0\xBC\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\xF3\xB0\xBC\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\xF3\xB0\xBC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\xF3\xB0\xBC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\xF3\xB0\xBC\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\xF3\xB0\xBC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\xF3\xB0\xBC\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\xF3\xB0\xBC\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\xF3\xB0\xBC\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\xF3\xB0\xBC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\xF3\xB0\xBC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\xF3\xB0\xBC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\xF3\xB0\xBC\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\xF3\xB0\xBC\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\xF3\xB0\xBC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\xF3\xB0\xBC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\xF3\xB0\xBC\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\xF3\xB0\xBC\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\xF3\xB0\xBC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\xF3\xB0\xBC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\xF3\xB0\xBC\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\xF3\xB0\xBC\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\xF3\xB0\xBC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x24"],
        ["\xF3\xB0\xBC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\xF3\xB0\xBC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\xF3\xB0\xBC\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\xF3\xB0\xBC\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\xF3\xB0\xBD\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\xF3\xB0\xBD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\xF3\xB0\xBD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\xF3\xB0\xBD\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\xF3\xB0\xBD\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\xF3\xB0\xBD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\xF3\xB0\xBD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\xF3\xB0\xBD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\xF3\xB0\xBD\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\xF3\xB0\xBD\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\xF3\xB0\xBD\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\xF3\xB0\xBD\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\xF3\xB0\xBD\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\xF3\xB0\xBD\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\xF3\xB0\xBD\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\xF3\xB0\xBD\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\xF3\xB0\xBD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\xF3\xB0\xBD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\xF3\xB0\xBD\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x21"],
        ["\xF3\xB0\xBD\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x22"],
        ["\xF3\xB0\xBD\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x23"],
        ["\xF3\xB0\xBD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x24"],
        ["\xF3\xB0\xBD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x25"],
        ["\xF3\xB0\xBD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x26"],
        ["\xF3\xB0\xBD\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x27"],
        ["\xF3\xB0\xBD\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x28"],
        ["\xF3\xB0\xBD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x29"],
        ["\xF3\xB0\xBD\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2A"],
        ["\xF3\xB0\xBD\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2B"],
        ["\xF3\xB0\xBD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2C"],
        ["\xF3\xB0\xBD\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2D"],
        ["\xF3\xB0\xBD\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2E"],
        ["\xF3\xB0\xBD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x2F"],
        ["\xF3\xB0\xBD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x30"],
        ["\xF3\xB0\xBD\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x31"],
        ["\xF3\xB0\xBD\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x32"],
        ["\xF3\xB0\xBD\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x33"],
        ["\xF3\xB0\xBD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x34"],
        ["\xF3\xB0\xBD\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x35"],
        ["\xF3\xB0\xBD\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x36"],
        ["\xF3\xB0\xBD\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x37"],
        ["\xF3\xB0\xBD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x38"],
        ["\xF3\xB0\xBD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x39"],
        ["\xF3\xB0\xBD\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3A"],
        ["\xF3\xB0\xBD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3B"],
        ["\xF3\xB0\xBD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3C"],
        ["\xF3\xB0\xBD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3D"],
        ["\xF3\xB0\xBD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3E"],
        ["\xF3\xB0\xBD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x3F"],
        ["\xF3\xB0\xBD\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x40"],
        ["\xF3\xB0\xBD\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\xF3\xB0\xBD\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\xF3\xB0\xBD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\xF3\xB0\xBD\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\xF3\xB0\xBD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\xF3\xB0\xBD\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\xF3\xB0\xBD\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\xF3\xB0\xBD\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\xF3\xB0\xBD\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\xF3\xB0\xBD\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\xF3\xB0\xBD\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\xF3\xB0\xBD\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\xF3\xB0\xBD\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\xF3\xB0\xBD\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\xF3\xB0\xBE\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\xF3\xB0\xBE\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\xF3\xB0\xBE\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\xF3\xB0\xBE\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\xF3\xB0\xBE\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\xF3\xB0\xBE\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\xF3\xB0\xBE\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\xF3\xB0\xBE\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\xF3\xB0\xBE\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\xF3\xB0\xBE\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\xF3\xB0\xBE\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\xF3\xB0\xBE\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\xF3\xB0\xBE\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\xF3\xB0\xBE\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\xF3\xB0\xBE\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\xF3\xB0\xBE\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\xF3\xB0\xBE\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\xF3\xB0\xBE\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\xF3\xB0\xBE\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\xF3\xB0\xBE\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\xF3\xB0\xBE\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\xF3\xB0\xBE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\xF3\xB0\xBE\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\xF3\xB0\xBE\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\xF3\xB0\xBE\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\xF3\xB0\xBE\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\xF3\xB0\xBE\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\xF3\xB0\xBE\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\xF3\xB0\xBE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\xF3\xB0\xBE\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\xF3\xB0\xBE\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\xF3\xB0\xBE\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\xF3\xB0\xBE\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\xF3\xB0\xBE\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\xF3\xB0\xBE\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\xF3\xB0\xBE\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\xF3\xB0\xBE\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\xF3\xB0\xBE\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\xF3\xB0\xBE\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\xF3\xB0\xBE\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\xF3\xB0\xBE\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\xF3\xB0\xBE\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\xF3\xB0\xBE\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\xF3\xB0\xBE\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\xF3\xB0\xBE\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\xF3\xB0\xBE\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\xF3\xB0\xBE\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\xF3\xB0\xBE\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\xF3\xB0\xBE\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x21"],
        ["\xF3\xB0\xBE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x22"],
        ["\xF3\xB0\xBE\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x23"],
        ["\xF3\xB0\xBE\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x24"],
        ["\xF3\xB0\xBE\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x25"],
        ["\xF3\xB0\xBE\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x26"],
        ["\xF3\xB0\xBE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x27"],
        ["\xF3\xB0\xBE\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x28"],
        ["\xF3\xB0\xBE\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x29"],
        ["\xF3\xB0\xBE\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2A"],
        ["\xF3\xB0\xBE\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2B"],
        ["\xF3\xB0\xBE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2C"],
        ["\xF3\xB0\xBE\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2D"],
        ["\xF3\xB0\xBE\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2E"],
        ["\xF3\xB0\xBE\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x2F"],
        ["\xF3\xB0\xBE\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\xF3\xB0\xBF\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x31"],
        ["\xF3\xB0\xBF\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x32"],
        ["\xF3\xB0\xBF\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x33"],
        ["\xF3\xB0\xBF\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x34"],
        ["\xF3\xB0\xBF\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x35"],
        ["\xF3\xB0\xBF\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x36"],
        ["\xF3\xB0\xBF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x37"],
        ["\xF3\xB0\xBF\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x38"],
        ["\xF3\xB0\xBF\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x39"],
        ["\xF3\xB0\xBF\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3A"],
        ["\xF3\xB0\xBF\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3B"],
        ["\xF3\xB0\xBF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3C"],
        ["\xF3\xB0\xBF\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3D"],
        ["\xF3\xB0\xBF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3E"],
        ["\xF3\xB0\xBF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x3F"],
        ["\xF3\xB0\xBF\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x40"],
        ["\xF3\xB0\xBF\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\xF3\xB0\xBF\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\xF3\xB0\xBF\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\xF3\xB0\xBF\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\xF3\xB0\xBF\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\xF3\xB0\xBF\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\xF3\xB0\xBF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\xF3\xB0\xBF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\xF3\xB0\xBF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\xF3\xB0\xBF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\xF3\xB0\xBF\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\xF3\xB0\xBF\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\xF3\xB0\xBF\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\xF3\xB0\xBF\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\xF3\xB0\xBF\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\xF3\xB0\xBF\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\xF3\xB0\xBF\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\xF3\xB0\xBF\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\xF3\xB0\xBF\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\xF3\xB0\xBF\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\xF3\xB0\xBF\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\xF3\xB0\xBF\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\xF3\xB0\xBF\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\xF3\xB0\xBF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\xF3\xB0\xBF\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\xF3\xB0\xBF\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\xF3\xB0\xBF\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\xF3\xB0\xBF\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\xF3\xB0\xBF\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\xF3\xB0\xBF\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\xF3\xB0\xBF\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\xF3\xB0\xBF\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\xF3\xB0\xBF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\xF3\xB0\xBF\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\xF3\xB0\xBF\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\xF3\xB0\xBF\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\xF3\xB0\xBF\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\xF3\xB0\xBF\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\xF3\xB0\xBF\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\xF3\xB0\xBF\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\xF3\xB0\xBF\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\xF3\xB0\xBF\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\xF3\xB0\xBF\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\xF3\xB0\xBF\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\xF3\xB0\xBF\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\xF3\xB0\xBF\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\xF3\xB0\xBF\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\xF3\xB0\xBF\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\xF3\xB1\x80\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\xF3\xB1\x80\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\xF3\xB1\x80\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\xF3\xB1\x80\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\xF3\xB1\x80\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\xF3\xB1\x80\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\xF3\xB1\x80\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\xF3\xB1\x80\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\xF3\xB1\x80\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\xF3\xB1\x80\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\xF3\xB1\x80\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\xF3\xB1\x80\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\xF3\xB1\x80\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\xF3\xB1\x80\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\xF3\xB1\x80\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x21"],
        ["\xF3\xB1\x80\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x22"],
        ["\xF3\xB1\x80\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x23"],
        ["\xF3\xB1\x80\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x24"],
        ["\xF3\xB1\x80\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x25"],
        ["\xF3\xB1\x80\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x26"],
        ["\xF3\xB1\x80\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x27"],
        ["\xF3\xB1\x80\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x28"],
        ["\xF3\xB1\x80\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x29"],
        ["\xF3\xB1\x80\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2A"],
        ["\xF3\xB1\x80\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2B"],
        ["\xF3\xB1\x80\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2C"],
        ["\xF3\xB1\x80\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2D"],
        ["\xF3\xB1\x80\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2E"],
        ["\xF3\xB1\x80\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x2F"],
        ["\xF3\xB1\x80\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x30"],
        ["\xF3\xB1\x80\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x31"],
        ["\xF3\xB1\x80\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x32"],
        ["\xF3\xB1\x80\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x33"],
        ["\xF3\xB1\x80\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x34"],
        ["\xF3\xB1\x80\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x35"],
        ["\xF3\xB1\x80\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x36"],
        ["\xF3\xB1\x80\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x37"],
        ["\xF3\xB1\x80\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x38"],
        ["\xF3\xB1\x80\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x39"],
        ["\xF3\xB1\x80\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3A"],
        ["\xF3\xB1\x80\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3B"],
        ["\xF3\xB1\x80\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3C"],
        ["\xF3\xB1\x80\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3D"],
        ["\xF3\xB1\x80\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3E"],
        ["\xF3\xB1\x80\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x3F"],
        ["\xF3\xB1\x80\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x40"],
        ["\xF3\xB1\x80\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\xF3\xB1\x80\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\xF3\xB1\x80\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\xF3\xB1\x80\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\xF3\xB1\x80\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\xF3\xB1\x80\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\xF3\xB1\x80\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\xF3\xB1\x80\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\xF3\xB1\x80\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\xF3\xB1\x80\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\xF3\xB1\x80\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\xF3\xB1\x80\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\xF3\xB1\x80\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\xF3\xB1\x80\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\xF3\xB1\x80\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\xF3\xB1\x80\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\xF3\xB1\x80\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\xF3\xB1\x80\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\xF3\xB1\x81\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\xF3\xB1\x81\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\xF3\xB1\x81\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\xF3\xB1\x81\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\xF3\xB1\x81\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\xF3\xB1\x81\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\xF3\xB1\x81\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\xF3\xB1\x81\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\xF3\xB1\x81\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\xF3\xB1\x81\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\xF3\xB1\x81\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\xF3\xB1\x81\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\xF3\xB1\x81\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\xF3\xB1\x81\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\xF3\xB1\x81\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\xF3\xB1\x81\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\xF3\xB1\x81\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\xF3\xB1\x81\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\xF3\xB1\x81\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\xF3\xB1\x81\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\xF3\xB1\x81\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\xF3\xB1\x81\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\xF3\xB1\x81\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\xF3\xB1\x81\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\xF3\xB1\x81\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\xF3\xB1\x81\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\xF3\xB1\x81\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\xF3\xB1\x81\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\xF3\xB1\x81\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\xF3\xB1\x81\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\xF3\xB1\x81\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\xF3\xB1\x81\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\xF3\xB1\x81\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\xF3\xB1\x81\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\xF3\xB1\x81\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\xF3\xB1\x81\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\xF3\xB1\x81\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\xF3\xB1\x81\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\xF3\xB1\x81\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\xF3\xB1\x81\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\xF3\xB1\x81\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\xF3\xB1\x81\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\xF3\xB1\x81\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\xF3\xB1\x81\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\xF3\xB1\x81\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x21"],
        ["\xF3\xB1\x81\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x22"],
        ["\xF3\xB1\x81\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x23"],
        ["\xF3\xB1\x81\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x24"],
        ["\xF3\xB1\x81\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x25"],
        ["\xF3\xB1\x81\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x26"],
        ["\xF3\xB1\x81\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x27"],
        ["\xF3\xB1\x81\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x28"],
        ["\xF3\xB1\x81\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x29"],
        ["\xF3\xB1\x81\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2A"],
        ["\xF3\xB1\x81\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2B"],
        ["\xF3\xB1\x81\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2C"],
        ["\xF3\xB1\x81\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2D"],
        ["\xF3\xB1\x81\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2E"],
        ["\xF3\xB1\x81\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x2F"],
        ["\xF3\xB1\x81\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x30"],
        ["\xF3\xB1\x81\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x31"],
        ["\xF3\xB1\x81\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x32"],
        ["\xF3\xB1\x81\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x33"],
        ["\xF3\xB1\x81\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x34"],
        ["\xF3\xB1\x82\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x35"],
        ["\xF3\xB1\x82\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x36"],
        ["\xF3\xB1\x82\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x37"],
        ["\xF3\xB1\x82\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x38"],
        ["\xF3\xB1\x82\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x39"],
        ["\xF3\xB1\x82\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3A"],
        ["\xF3\xB1\x82\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3B"],
        ["\xF3\xB1\x82\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3C"],
        ["\xF3\xB1\x82\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3D"],
        ["\xF3\xB1\x82\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3E"],
        ["\xF3\xB1\x82\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x3F"],
        ["\xF3\xB1\x82\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x40"],
        ["\xF3\xB1\x82\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\xF3\xB1\x82\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\xF3\xB1\x82\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\xF3\xB1\x82\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\xF3\xB1\x82\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\xF3\xB1\x82\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\xF3\xB1\x82\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\xF3\xB1\x82\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\xF3\xB1\x82\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\xF3\xB1\x82\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\xF3\xB1\x82\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\xF3\xB1\x82\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\xF3\xB1\x82\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\xF3\xB1\x82\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\xF3\xB1\x82\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\xF3\xB1\x82\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\xF3\xB1\x82\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\xF3\xB1\x82\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\xF3\xB1\x82\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\xF3\xB1\x82\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\xF3\xB1\x82\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\xF3\xB1\x82\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\xF3\xB1\x82\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\xF3\xB1\x82\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\xF3\xB1\x82\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\xF3\xB1\x82\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\xF3\xB1\x82\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\xF3\xB1\x82\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\xF3\xB1\x82\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\xF3\xB1\x82\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\xF3\xB1\x82\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\xF3\xB1\x82\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\xF3\xB1\x82\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\xF3\xB1\x82\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\xF3\xB1\x82\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\xF3\xB1\x82\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\xF3\xB1\x82\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\xF3\xB1\x82\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\xF3\xB1\x82\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\xF3\xB1\x82\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\xF3\xB1\x82\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\xF3\xB1\x82\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xF3\xB1\x82\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\xF3\xB1\x82\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\xF3\xB1\x82\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\xF3\xB1\x82\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\xF3\xB1\x82\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\xF3\xB1\x82\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\xF3\xB1\x82\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\xF3\xB1\x82\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\xF3\xB1\x82\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\xF3\xB1\x82\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\xF3\xB1\x83\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\xF3\xB1\x83\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\xF3\xB1\x83\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\xF3\xB1\x83\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\xF3\xB1\x83\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\xF3\xB1\x83\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\xF3\xB1\x83\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\xF3\xB1\x83\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\xF3\xB1\x83\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\xF3\xB1\x83\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\xF3\xB1\x83\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x21"],
        ["\xF3\xB1\x83\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x22"],
        ["\xF3\xB1\x83\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x23"],
        ["\xF3\xB1\x83\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x24"],
        ["\xF3\xB1\x83\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x25"],
        ["\xF3\xB1\x83\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x26"],
        ["\xF3\xB1\x83\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x27"],
        ["\xF3\xB1\x83\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x28"],
        ["\xF3\xB1\x83\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x29"],
        ["\xF3\xB1\x83\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2A"],
        ["\xF3\xB1\x83\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2B"],
        ["\xF3\xB1\x83\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2C"],
        ["\xF3\xB1\x83\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2D"],
        ["\xF3\xB1\x83\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2E"],
        ["\xF3\xB1\x83\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x2F"],
        ["\xF3\xB1\x83\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x30"],
        ["\xF3\xB1\x83\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x31"],
        ["\xF3\xB1\x83\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x32"],
        ["\xF3\xB1\x83\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x33"],
        ["\xF3\xB1\x83\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x34"],
        ["\xF3\xB1\x83\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x35"],
        ["\xF3\xB1\x83\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x36"],
        ["\xF3\xB1\x83\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x37"],
        ["\xF3\xB1\x83\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x38"],
        ["\xF3\xB1\x83\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x39"],
        ["\xF3\xB1\x83\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3A"],
        ["\xF3\xB1\x83\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3B"],
        ["\xF3\xB1\x83\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3C"],
        ["\xF3\xB1\x83\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3D"],
        ["\xF3\xB1\x83\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3E"],
        ["\xF3\xB1\x83\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x3F"],
        ["\xF3\xB1\x83\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x40"],
        ["\xF3\xB1\x83\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\xF3\xB1\x83\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\xF3\xB1\x83\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\xF3\xB1\x83\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\xF3\xB1\x83\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\xF3\xB1\x83\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\xF3\xB1\x83\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\xF3\xB1\x83\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\xF3\xB1\x83\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\xF3\xB1\x83\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\xF3\xB1\x83\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\xF3\xB1\x83\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\xF3\xB1\x83\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\xF3\xB1\x83\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\xF3\xB1\x83\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\xF3\xB1\x83\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\xF3\xB1\x83\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\xF3\xB1\x83\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\xF3\xB1\x83\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\xF3\xB1\x83\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\xF3\xB1\x83\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\xF3\xB1\x83\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\xF3\xB1\x84\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\xF3\xB1\x84\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\xF3\xB1\x84\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\xF3\xB1\x84\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\xF3\xB1\x84\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\xF3\xB1\x84\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\xF3\xB1\x84\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\xF3\xB1\x84\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\xF3\xB1\x84\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\xF3\xB1\x84\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\xF3\xB1\x84\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\xF3\xB1\x84\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\xF3\xB1\x84\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\xF3\xB1\x84\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\xF3\xB1\x84\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\xF3\xB1\x84\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\xF3\xB1\x84\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\xF3\xB1\x84\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\xF3\xB1\x84\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\xF3\xB1\x84\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\xF3\xB1\x84\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\xF3\xB1\x84\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\xF3\xB1\x84\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\xF3\xB1\x84\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\xF3\xB1\x84\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\xF3\xB1\x84\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\xF3\xB1\x84\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\xF3\xB1\x84\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\xF3\xB1\x84\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\xF3\xB1\x84\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\xF3\xB1\x84\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\xF3\xB1\x84\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\xF3\xB1\x84\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\xF3\xB1\x84\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\xF3\xB1\x84\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2E"],
        ["\xF3\xB1\x84\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\xF3\xB1\x84\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\xF3\xB1\x84\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\xF3\xB1\x84\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\xF3\xB1\x84\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\xF3\xB1\x84\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x21"],
        ["\xF3\xB1\x84\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x22"],
        ["\xF3\xB1\x84\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x23"],
        ["\xF3\xB1\x84\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x24"],
        ["\xF3\xB1\x84\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x25"],
        ["\xF3\xB1\x84\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x26"],
        ["\xF3\xB1\x84\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x27"],
        ["\xF3\xB1\x84\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x28"],
        ["\xF3\xB1\x84\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x29"],
        ["\xF3\xB1\x84\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2A"],
        ["\xF3\xB1\x84\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2B"],
        ["\xF3\xB1\x84\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2C"],
        ["\xF3\xB1\x84\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2D"],
        ["\xF3\xB1\x84\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2E"],
        ["\xF3\xB1\x84\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x2F"],
        ["\xF3\xB1\x84\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x30"],
        ["\xF3\xB1\x84\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x31"],
        ["\xF3\xB1\x84\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x32"],
        ["\xF3\xB1\x84\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x33"],
        ["\xF3\xB1\x84\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x34"],
        ["\xF3\xB1\x84\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x35"],
        ["\xF3\xB1\x84\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x36"],
        ["\xF3\xB1\x84\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x37"],
        ["\xF3\xB1\x84\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x38"],
        ["\xF3\xB1\x85\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x39"],
        ["\xF3\xB1\x85\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3A"],
        ["\xF3\xB1\x85\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3B"],
        ["\xF3\xB1\x85\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3C"],
        ["\xF3\xB1\x85\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3D"],
        ["\xF3\xB1\x85\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3E"],
        ["\xF3\xB1\x85\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x3F"],
        ["\xF3\xB1\x85\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x40"],
        ["\xF3\xB1\x85\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\xF3\xB1\x85\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\xF3\xB1\x85\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\xF3\xB1\x85\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\xF3\xB1\x85\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\xF3\xB1\x85\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\xF3\xB1\x85\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\xF3\xB1\x85\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\xF3\xB1\x85\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\xF3\xB1\x85\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\xF3\xB1\x85\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\xF3\xB1\x85\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\xF3\xB1\x85\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\xF3\xB1\x85\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\xF3\xB1\x85\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\xF3\xB1\x85\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\xF3\xB1\x85\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\xF3\xB1\x85\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\xF3\xB1\x85\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\xF3\xB1\x85\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\xF3\xB1\x85\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\xF3\xB1\x85\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\xF3\xB1\x85\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\xF3\xB1\x85\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\xF3\xB1\x85\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\xF3\xB1\x85\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xF3\xB1\x85\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\xF3\xB1\x85\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\xF3\xB1\x85\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\xF3\xB1\x85\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\xF3\xB1\x85\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\xF3\xB1\x85\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\xF3\xB1\x85\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\xF3\xB1\x85\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\xF3\xB1\x85\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\xF3\xB1\x85\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\xF3\xB1\x85\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\xF3\xB1\x85\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\xF3\xB1\x85\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\xF3\xB1\x85\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\xF3\xB1\x85\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\xF3\xB1\x85\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\xF3\xB1\x85\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\xF3\xB1\x85\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\xF3\xB1\x85\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\xF3\xB1\x85\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\xF3\xB1\x85\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\xF3\xB1\x85\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\xF3\xB1\x85\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\xF3\xB1\x85\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\xF3\xB1\x85\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\xF3\xB1\x85\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\xF3\xB1\x85\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\xF3\xB1\x85\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\xF3\xB1\x85\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\xF3\xB1\x85\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\xF3\xB1\x86\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\xF3\xB1\x86\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\xF3\xB1\x86\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\xF3\xB1\x86\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\xF3\xB1\x86\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\xF3\xB1\x86\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\xF3\xB1\x86\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x21"],
        ["\xF3\xB1\x86\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x22"],
        ["\xF3\xB1\x86\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x23"],
        ["\xF3\xB1\x86\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x24"],
        ["\xF3\xB1\x86\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x25"],
        ["\xF3\xB1\x86\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x26"],
        ["\xF3\xB1\x86\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x27"],
        ["\xF3\xB1\x86\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x28"],
        ["\xF3\xB1\x86\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x29"],
        ["\xF3\xB1\x86\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2A"],
        ["\xF3\xB1\x86\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2B"],
        ["\xF3\xB1\x86\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2C"],
        ["\xF3\xB1\x86\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2D"],
        ["\xF3\xB1\x86\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2E"],
        ["\xF3\xB1\x86\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x2F"],
        ["\xF3\xB1\x86\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x30"],
        ["\xF3\xB1\x86\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x31"],
        ["\xF3\xB1\x86\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x32"],
        ["\xF3\xB1\x86\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x33"],
        ["\xF3\xB1\x86\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x34"],
        ["\xF3\xB1\x86\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x35"],
        ["\xF3\xB1\x86\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x36"],
        ["\xF3\xB1\x86\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x37"],
        ["\xF3\xB1\x86\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x38"],
        ["\xF3\xB1\x86\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x39"],
        ["\xF3\xB1\x86\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3A"],
        ["\xF3\xB1\x86\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3B"],
        ["\xF3\xB1\x86\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3C"],
        ["\xF3\xB1\x86\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3D"],
        ["\xF3\xB1\x86\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3E"],
        ["\xF3\xB1\x86\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x3F"],
        ["\xF3\xB1\x86\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x40"],
        ["\xF3\xB1\x86\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\xF3\xB1\x86\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\xF3\xB1\x86\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\xF3\xB1\x86\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\xF3\xB1\x86\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\xF3\xB1\x86\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\xF3\xB1\x86\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\xF3\xB1\x86\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\xF3\xB1\x86\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\xF3\xB1\x86\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\xF3\xB1\x86\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\xF3\xB1\x86\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\xF3\xB1\x86\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\xF3\xB1\x86\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\xF3\xB1\x86\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\xF3\xB1\x86\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\xF3\xB1\x86\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\xF3\xB1\x86\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\xF3\xB1\x86\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],
        ["\xF3\xB1\x86\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\xF3\xB1\x86\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\xF3\xB1\x86\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\xF3\xB1\x86\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\xF3\xB1\x86\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\xF3\xB1\x86\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\xF3\xB1\x86\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\xF3\xB1\x87\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\xF3\xB1\x87\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\xF3\xB1\x87\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\xF3\xB1\x87\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\xF3\xB1\x87\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\xF3\xB1\x87\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\xF3\xB1\x87\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\xF3\xB1\x87\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\xF3\xB1\x87\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\xF3\xB1\x87\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\xF3\xB1\x87\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\xF3\xB1\x87\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\xF3\xB1\x87\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\xF3\xB1\x87\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\xF3\xB1\x87\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\xF3\xB1\x87\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\xF3\xB1\x87\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\xF3\xB1\x87\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\xF3\xB1\x87\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\xF3\xB1\x87\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\xF3\xB1\x87\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\xF3\xB1\x87\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\xF3\xB1\x87\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\xF3\xB1\x87\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\xF3\xB1\x87\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\xF3\xB1\x87\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\xF3\xB1\x87\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\xF3\xB1\x87\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\xF3\xB1\x87\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\xF3\xB1\x87\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\xF3\xB1\x87\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\xF3\xB1\x87\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\xF3\xB1\x87\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\xF3\xB1\x87\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\xF3\xB1\x87\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\xF3\xB1\x87\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\xF3\xB1\x87\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x21"],
        ["\xF3\xB1\x87\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x22"],
        ["\xF3\xB1\x87\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x23"],
        ["\xF3\xB1\x87\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x24"],
        ["\xF3\xB1\x87\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x25"],
        ["\xF3\xB1\x87\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x26"],
        ["\xF3\xB1\x87\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x27"],
        ["\xF3\xB1\x87\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x28"],
        ["\xF3\xB1\x87\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x29"],
        ["\xF3\xB1\x87\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2A"],
        ["\xF3\xB1\x87\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2B"],
        ["\xF3\xB1\x87\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2C"],
        ["\xF3\xB1\x87\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2D"],
        ["\xF3\xB1\x87\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2E"],
        ["\xF3\xB1\x87\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x2F"],
        ["\xF3\xB1\x87\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x30"],
        ["\xF3\xB1\x87\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x31"],
        ["\xF3\xB1\x87\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x32"],
        ["\xF3\xB1\x87\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x33"],
        ["\xF3\xB1\x87\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x34"],
        ["\xF3\xB1\x87\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x35"],
        ["\xF3\xB1\x87\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\xF3\xB1\x87\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x37"],
        ["\xF3\xB1\x87\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x38"],
        ["\xF3\xB1\x87\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x39"],
        ["\xF3\xB1\x87\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3A"],
        ["\xF3\xB1\x87\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3B"],
        ["\xF3\xB1\x87\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3C"],
        ["\xF3\xB1\x88\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3D"],
        ["\xF3\xB1\x88\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3E"],
        ["\xF3\xB1\x88\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x3F"],
        ["\xF3\xB1\x88\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x40"],
        ["\xF3\xB1\x88\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\xF3\xB1\x88\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\xF3\xB1\x88\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\xF3\xB1\x88\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\xF3\xB1\x88\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\xF3\xB1\x88\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\xF3\xB1\x88\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\xF3\xB1\x88\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\xF3\xB1\x88\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\xF3\xB1\x88\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\xF3\xB1\x88\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\xF3\xB1\x88\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\xF3\xB1\x88\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\xF3\xB1\x88\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\xF3\xB1\x88\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\xF3\xB1\x88\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\xF3\xB1\x88\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\xF3\xB1\x88\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\xF3\xB1\x88\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\xF3\xB1\x89\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x21"],
        ["\xF3\xB1\x89\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x22"],
        ["\xF3\xB1\x89\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x23"],
        ["\xF3\xB1\x89\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x24"],
        ["\xF3\xB1\x89\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x25"],
        ["\xF3\xB1\x89\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x26"],
        ["\xF3\xB1\x89\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x27"],
        ["\xF3\xB1\x89\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x28"],
        ["\xF3\xB1\x89\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x29"],
        ["\xF3\xB1\x89\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2A"],
        ["\xF3\xB1\x89\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2B"],
        ["\xF3\xB1\x89\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2C"],
        ["\xF3\xB1\x89\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2D"],
        ["\xF3\xB1\x89\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2E"],
        ["\xF3\xB1\x89\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x2F"],
        ["\xF3\xB1\x89\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x30"],
        ["\xF3\xB1\x89\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x31"],
        ["\xF3\xB1\x89\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x32"],
        ["\xF3\xB1\x89\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x33"],
        ["\xF3\xB1\x89\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x34"],
        ["\xF3\xB1\x89\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x35"],
        ["\xF3\xB1\x89\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x36"],
        ["\xF3\xB1\x89\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x37"],
        ["\xF3\xB1\x89\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x38"],
        ["\xF3\xB1\x89\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x39"],
        ["\xF3\xB1\x89\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3A"],
        ["\xF3\xB1\x89\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3B"],
        ["\xF3\xB1\x89\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3C"],
        ["\xF3\xB1\x89\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3D"],
        ["\xF3\xB1\x89\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3E"],
        ["\xF3\xB1\x89\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x3F"],
        ["\xF3\xB1\x89\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x40"],
        ["\xF3\xB1\x89\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\xF3\xB1\x89\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\xF3\xB1\x89\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\xF3\xB1\x89\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\xF3\xB1\x89\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\xF3\xB1\x89\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\xF3\xB1\x89\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\xF3\xB1\x89\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\xF3\xB1\x89\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\xF3\xB1\x89\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\xF3\xB1\x89\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\xF3\xB1\x89\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\xF3\xB1\x89\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\xF3\xB1\x89\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\xF3\xB1\x89\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\xF3\xB1\x89\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\xF3\xB1\x89\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\xF3\xB1\x89\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\xF3\xB1\x89\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\xF3\xB1\x89\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\xF3\xB1\x89\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\xF3\xB1\x89\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\xF3\xB1\x89\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\xF3\xB1\x89\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\xF3\xB1\x89\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\xF3\xB1\x89\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\xF3\xB1\x89\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\xF3\xB1\x89\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\xF3\xB1\x89\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\xF3\xB1\x89\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\xF3\xB1\x8A\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\xF3\xB1\x8A\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\xF3\xB1\x8A\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\xF3\xB1\x8A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\xF3\xB1\x8A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\xF3\xB1\x8A\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\xF3\xB1\x8A\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\xF3\xB1\x8A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\xF3\xB1\x8A\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\xF3\xB1\x8A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\xF3\xB1\x8A\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\xF3\xB1\x8A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\xF3\xB1\x8A\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\xF3\xB1\x8A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\xF3\xB1\x8A\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\xF3\xB1\x8A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\xF3\xB1\x8A\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\xF3\xB1\x8A\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\xF3\xB1\x8A\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\xF3\xB1\x8A\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\xF3\xB1\x8A\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\xF3\xB1\x8A\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\xF3\xB1\x8A\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\xF3\xB1\x8A\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\xF3\xB1\x8A\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\xF3\xB1\x8A\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\xF3\xB1\x8A\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\xF3\xB1\x8A\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\xF3\xB1\x8A\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\xF3\xB1\x8A\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\xF3\xB1\x8A\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\xF3\xB1\x8A\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\xF3\xB1\x8A\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x21"],
        ["\xF3\xB1\x8A\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x22"],
        ["\xF3\xB1\x8A\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x23"],
        ["\xF3\xB1\x8A\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x24"],
        ["\xF3\xB1\x8A\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x25"],
        ["\xF3\xB1\x8A\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x26"],
        ["\xF3\xB1\x8A\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x27"],
        ["\xF3\xB1\x8A\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x28"],
        ["\xF3\xB1\x8A\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x29"],
        ["\xF3\xB1\x8A\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2A"],
        ["\xF3\xB1\x8A\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2B"],
        ["\xF3\xB1\x8A\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2C"],
        ["\xF3\xB1\x8A\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2D"],
        ["\xF3\xB1\x8A\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2E"],
        ["\xF3\xB1\x8A\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x2F"],
        ["\xF3\xB1\x8A\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x30"],
        ["\xF3\xB1\x8A\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x31"],
        ["\xF3\xB1\x8A\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x32"],
        ["\xF3\xB1\x8A\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x33"],
        ["\xF3\xB1\x8A\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x34"],
        ["\xF3\xB1\x8A\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x35"],
        ["\xF3\xB1\x8A\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x36"],
        ["\xF3\xB1\x8A\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x37"],
        ["\xF3\xB1\x8A\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x38"],
        ["\xF3\xB1\x8A\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x39"],
        ["\xF3\xB1\x8A\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3A"],
        ["\xF3\xB1\x8A\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3B"],
        ["\xF3\xB1\x8A\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3C"],
        ["\xF3\xB1\x8A\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3D"],
        ["\xF3\xB1\x8A\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3E"],
        ["\xF3\xB1\x8A\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x3F"],
        ["\xF3\xB1\x8A\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x40"],
        ["\xF3\xB1\x8B\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\xF3\xB1\x8B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\xF3\xB1\x8B\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\xF3\xB1\x8B\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\xF3\xB1\x8B\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\xF3\xB1\x8B\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\xF3\xB1\x8B\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\xF3\xB1\x8B\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\xF3\xB1\x8B\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\xF3\xB1\x8B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\xF3\xB1\x8B\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\xF3\xB1\x8B\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\xF3\xB1\x8B\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\xF3\xB1\x8B\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\xF3\xB1\x8B\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\xF3\xB1\x8B\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\xF3\xB1\x8B\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\xF3\xB1\x8B\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\xF3\xB1\x8B\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\xF3\xB1\x8B\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\xF3\xB1\x8B\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\xF3\xB1\x8B\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\xF3\xB1\x8B\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\xF3\xB1\x8B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\xF3\xB1\x8B\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\xF3\xB1\x8B\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\xF3\xB1\x8B\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\xF3\xB1\x8B\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\xF3\xB1\x8B\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\xF3\xB1\x8B\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\xF3\xB1\x8B\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\xF3\xB1\x8B\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\xF3\xB1\x8B\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\xF3\xB1\x8B\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\xF3\xB1\x8B\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\xF3\xB1\x8B\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\xF3\xB1\x8B\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\xF3\xB1\x8B\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\xF3\xB1\x8B\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\xF3\xB1\x8B\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\xF3\xB1\x8B\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\xF3\xB1\x8B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\xF3\xB1\x8B\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\xF3\xB1\x8B\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\xF3\xB1\x8B\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\xF3\xB1\x8B\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\xF3\xB1\x8B\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\xF3\xB1\x8B\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\xF3\xB1\x8B\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\xF3\xB1\x8B\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\xF3\xB1\x8B\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\xF3\xB1\x8B\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\xF3\xB1\x8B\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\xF3\xB1\x8B\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\xF3\xB1\x8B\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\xF3\xB1\x8B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\xF3\xB1\x8B\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\xF3\xB1\x8B\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\xF3\xB1\x8B\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\xF3\xB1\x8B\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\xF3\xB1\x8B\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\xF3\xB1\x8B\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\xF3\xB1\x8B\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x21"],
        ["\xF3\xB1\x8B\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x22"],
        ["\xF3\xB1\x8C\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x23"],
        ["\xF3\xB1\x8C\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x24"],
        ["\xF3\xB1\x8C\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x25"],
        ["\xF3\xB1\x8C\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x26"],
        ["\xF3\xB1\x8C\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x27"],
        ["\xF3\xB1\x8C\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x28"],
        ["\xF3\xB1\x8C\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x29"],
        ["\xF3\xB1\x8C\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2A"],
        ["\xF3\xB1\x8C\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2B"],
        ["\xF3\xB1\x8C\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2C"],
        ["\xF3\xB1\x8C\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2D"],
        ["\xF3\xB1\x8C\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2E"],
        ["\xF3\xB1\x8C\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x2F"],
        ["\xF3\xB1\x8C\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x30"],
        ["\xF3\xB1\x8C\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x31"],
        ["\xF3\xB1\x8C\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x32"],
        ["\xF3\xB1\x8C\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x33"],
        ["\xF3\xB1\x8C\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x34"],
        ["\xF3\xB1\x8C\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x35"],
        ["\xF3\xB1\x8C\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x36"],
        ["\xF3\xB1\x8C\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x37"],
        ["\xF3\xB1\x8C\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x38"],
        ["\xF3\xB1\x8C\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x39"],
        ["\xF3\xB1\x8C\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3A"],
        ["\xF3\xB1\x8C\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3B"],
        ["\xF3\xB1\x8C\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3C"],
        ["\xF3\xB1\x8C\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3D"],
        ["\xF3\xB1\x8C\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3E"],
        ["\xF3\xB1\x8C\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x3F"],
        ["\xF3\xB1\x8C\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x40"],
        ["\xF3\xB1\x8C\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\xF3\xB1\x8C\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\xF3\xB1\x8C\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\xF3\xB1\x8C\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\xF3\xB1\x8C\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\xF3\xB1\x8C\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\xF3\xB1\x8C\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\xF3\xB1\x8C\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\xF3\xB1\x8C\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\xF3\xB1\x8C\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\xF3\xB1\x8C\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],
        ["\xF3\xB1\x8C\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\xF3\xB1\x8C\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\xF3\xB1\x8C\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\xF3\xB1\x8C\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\xF3\xB1\x8C\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\xF3\xB1\x8C\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\xF3\xB1\x8C\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\xF3\xB1\x8C\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\xF3\xB1\x8C\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\xF3\xB1\x8C\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\xF3\xB1\x8C\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\xF3\xB1\x8C\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\xF3\xB1\x8C\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\xF3\xB1\x8C\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\xF3\xB1\x8C\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\xF3\xB1\x8C\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\xF3\xB1\x8C\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\xF3\xB1\x8C\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\xF3\xB1\x8C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\xF3\xB1\x8C\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\xF3\xB1\x8C\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\xF3\xB1\x8C\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\xF3\xB1\x8C\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\xF3\xB1\x8D\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\xF3\xB1\x8D\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\xF3\xB1\x8D\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\xF3\xB1\x8D\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\xF3\xB1\x8D\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\xF3\xB1\x8D\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\xF3\xB1\x8D\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\xF3\xB1\x8D\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\xF3\xB1\x8D\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\xF3\xB1\x8D\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\xF3\xB1\x8D\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\xF3\xB1\x8D\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\xF3\xB1\x8D\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\xF3\xB1\x8D\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\xF3\xB1\x8D\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\xF3\xB1\x8D\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\xF3\xB1\x8D\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\xF3\xB1\x8D\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\xF3\xB1\x8D\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\xF3\xB1\x8D\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\xF3\xB1\x8D\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\xF3\xB1\x8D\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\xF3\xB1\x8D\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\xF3\xB1\x8D\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\xF3\xB1\x8D\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],
        ["\xF3\xB1\x8D\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\xF3\xB1\x8D\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\xF3\xB1\x8D\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\xF3\xB1\x8D\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x21"],
        ["\xF3\xB1\x8D\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x22"],
        ["\xF3\xB1\x8D\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x23"],
        ["\xF3\xB1\x8D\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x24"],
        ["\xF3\xB1\x8D\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x25"],
        ["\xF3\xB1\x8D\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x26"],
        ["\xF3\xB1\x8D\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x27"],
        ["\xF3\xB1\x8D\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x28"],
        ["\xF3\xB1\x8D\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x29"],
        ["\xF3\xB1\x8D\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2A"],
        ["\xF3\xB1\x8D\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2B"],
        ["\xF3\xB1\x8D\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2C"],
        ["\xF3\xB1\x8D\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2D"],
        ["\xF3\xB1\x8D\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2E"],
        ["\xF3\xB1\x8D\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x2F"],
        ["\xF3\xB1\x8D\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x30"],
        ["\xF3\xB1\x8D\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x31"],
        ["\xF3\xB1\x8D\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x32"],
        ["\xF3\xB1\x8D\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x33"],
        ["\xF3\xB1\x8D\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x34"],
        ["\xF3\xB1\x8D\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x35"],
        ["\xF3\xB1\x8D\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x36"],
        ["\xF3\xB1\x8D\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x37"],
        ["\xF3\xB1\x8D\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x38"],
        ["\xF3\xB1\x8D\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x39"],
        ["\xF3\xB1\x8D\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3A"],
        ["\xF3\xB1\x8D\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3B"],
        ["\xF3\xB1\x8D\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3C"],
        ["\xF3\xB1\x8D\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3D"],
        ["\xF3\xB1\x8D\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3E"],
        ["\xF3\xB1\x8D\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x3F"],
        ["\xF3\xB1\x8D\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x40"],
        ["\xF3\xB1\x8D\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\xF3\xB1\x8D\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],
        ["\xF3\xB1\x8D\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\xF3\xB1\x8D\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\xF3\xB1\x8E\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\xF3\xB1\x8E\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\xF3\xB1\x8E\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\xF3\xB1\x8E\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\xF3\xB1\x8E\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\xF3\xB1\x8E\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\xF3\xB1\x8E\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\xF3\xB1\x8E\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\xF3\xB1\x8E\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\xF3\xB1\x8E\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\xF3\xB1\x8E\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\xF3\xB1\x8E\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\xF3\xB1\x8E\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\xF3\xB1\x8E\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\xF3\xB1\x8E\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\xF3\xB1\x8E\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\xF3\xB1\x8E\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\xF3\xB1\x8E\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\xF3\xB1\x8E\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\xF3\xB1\x8E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\xF3\xB1\x8E\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\xF3\xB1\x8E\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\xF3\xB1\x8E\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\xF3\xB1\x8E\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\xF3\xB1\x8E\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\xF3\xB1\x8E\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\xF3\xB1\x8E\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\xF3\xB1\x8E\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\xF3\xB1\x8E\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\xF3\xB1\x8E\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\xF3\xB1\x8E\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\xF3\xB1\x8E\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\xF3\xB1\x8E\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\xF3\xB1\x8E\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\xF3\xB1\x8E\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\xF3\xB1\x8E\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\xF3\xB1\x8E\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\xF3\xB1\x8E\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\xF3\xB1\x8E\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\xF3\xB1\x8E\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\xF3\xB1\x8E\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\xF3\xB1\x8E\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\xF3\xB1\x8E\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\xF3\xB1\x8E\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\xF3\xB1\x8E\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\xF3\xB1\x8E\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\xF3\xB1\x8E\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\xF3\xB1\x8E\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\xF3\xB1\x8E\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\xF3\xB1\x8E\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\xF3\xB1\x8E\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\xF3\xB1\x8E\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\xF3\xB1\x8E\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\xF3\xB1\x8E\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\xF3\xB1\x8E\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\xF3\xB1\x8E\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\xF3\xB1\x8E\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\xF3\xB1\x8E\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\xF3\xB1\x8E\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x21"],
        ["\xF3\xB1\x8E\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x22"],
        ["\xF3\xB1\x8E\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x23"],
        ["\xF3\xB1\x8E\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x24"],
        ["\xF3\xB1\x8E\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x25"],
        ["\xF3\xB1\x8E\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x26"],
        ["\xF3\xB1\x8F\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x27"],
        ["\xF3\xB1\x8F\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x28"],
        ["\xF3\xB1\x8F\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x29"],
        ["\xF3\xB1\x8F\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2A"],
        ["\xF3\xB1\x8F\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2B"],
        ["\xF3\xB1\x8F\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2C"],
        ["\xF3\xB1\x8F\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2D"],
        ["\xF3\xB1\x8F\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2E"],
        ["\xF3\xB1\x8F\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x2F"],
        ["\xF3\xB1\x8F\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x30"],
        ["\xF3\xB1\x8F\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x31"],
        ["\xF3\xB1\x8F\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x32"],
        ["\xF3\xB1\x8F\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x33"],
        ["\xF3\xB1\x8F\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x34"],
        ["\xF3\xB1\x8F\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x35"],
        ["\xF3\xB1\x8F\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x36"],
        ["\xF3\xB1\x8F\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x37"],
        ["\xF3\xB1\x8F\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x38"],
        ["\xF3\xB1\x8F\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x39"],
        ["\xF3\xB1\x8F\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3A"],
        ["\xF3\xB1\x8F\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3B"],
        ["\xF3\xB1\x8F\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3C"],
        ["\xF3\xB1\x8F\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3D"],
        ["\xF3\xB1\x8F\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3E"],
        ["\xF3\xB1\x8F\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x3F"],
        ["\xF3\xB1\x8F\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x40"],
        ["\xF3\xB1\x8F\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\xF3\xB1\x8F\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\xF3\xB1\x8F\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\xF3\xB1\x8F\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\xF3\xB1\x8F\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\xF3\xB1\x8F\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\xF3\xB1\x8F\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\xF3\xB1\x8F\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\xF3\xB1\x8F\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\xF3\xB1\x8F\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\xF3\xB1\x8F\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\xF3\xB1\x8F\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\xF3\xB1\x8F\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\xF3\xB1\x8F\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\xF3\xB1\x8F\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\xF3\xB1\x8F\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\xF3\xB1\x8F\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\xF3\xB1\x8F\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\xF3\xB1\x8F\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\xF3\xB1\x8F\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\xF3\xB1\x8F\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\xF3\xB1\x8F\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\xF3\xB1\x8F\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\xF3\xB1\x8F\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\xF3\xB1\x8F\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\xF3\xB1\x8F\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\xF3\xB1\x8F\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\xF3\xB1\x8F\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\xF3\xB1\x8F\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\xF3\xB1\x8F\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\xF3\xB1\x8F\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\xF3\xB1\x8F\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\xF3\xB1\x8F\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\xF3\xB1\x8F\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\xF3\xB1\x8F\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\xF3\xB1\x8F\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\xF3\xB1\x8F\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\xF3\xB1\x8F\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\xF3\xB1\x90\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\xF3\xB1\x90\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\xF3\xB1\x90\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\xF3\xB1\x90\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\xF3\xB1\x90\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\xF3\xB1\x90\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\xF3\xB1\x90\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\xF3\xB1\x90\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\xF3\xB1\x90\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\xF3\xB1\x90\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\xF3\xB1\x90\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\xF3\xB1\x90\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\xF3\xB1\x90\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\xF3\xB1\x90\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\xF3\xB1\x90\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\xF3\xB1\x90\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\xF3\xB1\x90\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\xF3\xB1\x90\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\xF3\xB1\x90\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\xF3\xB1\x90\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\xF3\xB1\x90\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\xF3\xB1\x90\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\xF3\xB1\x90\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\xF3\xB1\x90\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\xF3\xB1\x90\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x21"],
        ["\xF3\xB1\x90\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x22"],
        ["\xF3\xB1\x90\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x23"],
        ["\xF3\xB1\x90\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x24"],
        ["\xF3\xB1\x90\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x25"],
        ["\xF3\xB1\x90\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x26"],
        ["\xF3\xB1\x90\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x27"],
        ["\xF3\xB1\x90\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x28"],
        ["\xF3\xB1\x90\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x29"],
        ["\xF3\xB1\x90\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2A"],
        ["\xF3\xB1\x90\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2B"],
        ["\xF3\xB1\x90\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2C"],
        ["\xF3\xB1\x90\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2D"],
        ["\xF3\xB1\x90\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2E"],
        ["\xF3\xB1\x90\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x2F"],
        ["\xF3\xB1\x90\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x30"],
        ["\xF3\xB1\x90\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x31"],
        ["\xF3\xB1\x90\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x32"],
        ["\xF3\xB1\x90\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x33"],
        ["\xF3\xB1\x90\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x34"],
        ["\xF3\xB1\x90\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x35"],
        ["\xF3\xB1\x90\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x36"],
        ["\xF3\xB1\x90\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x37"],
        ["\xF3\xB1\x90\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x38"],
        ["\xF3\xB1\x90\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x39"],
        ["\xF3\xB1\x90\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3A"],
        ["\xF3\xB1\x90\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3B"],
        ["\xF3\xB1\x90\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3C"],
        ["\xF3\xB1\x90\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3D"],
        ["\xF3\xB1\x90\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3E"],
        ["\xF3\xB1\x90\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x3F"],
        ["\xF3\xB1\x90\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x40"],
        ["\xF3\xB1\x90\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\xF3\xB1\x90\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\xF3\xB1\x90\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\xF3\xB1\x90\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\xF3\xB1\x90\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\xF3\xB1\x90\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\xF3\xB1\x90\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\xF3\xB1\x90\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\xF3\xB1\x91\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\xF3\xB1\x91\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\xF3\xB1\x91\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\xF3\xB1\x91\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\xF3\xB1\x91\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\xF3\xB1\x91\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\xF3\xB1\x91\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\xF3\xB1\x91\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\xF3\xB1\x91\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],
        ["\xF3\xB1\x91\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\xF3\xB1\x91\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\xF3\xB1\x91\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\xF3\xB1\x91\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\xF3\xB1\x91\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\xF3\xB1\x91\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\xF3\xB1\x91\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\xF3\xB1\x91\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\xF3\xB1\x91\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\xF3\xB1\x91\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\xF3\xB1\x91\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\xF3\xB1\x91\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\xF3\xB1\x91\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\xF3\xB1\x91\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\xF3\xB1\x91\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\xF3\xB1\x91\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\xF3\xB1\x91\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\xF3\xB1\x91\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\xF3\xB1\x91\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\xF3\xB1\x91\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\xF3\xB1\x91\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\xF3\xB1\x91\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\xF3\xB1\x91\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\xF3\xB1\x91\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\xF3\xB1\x91\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\xF3\xB1\x91\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\xF3\xB1\x91\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\xF3\xB1\x91\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\xF3\xB1\x91\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\xF3\xB1\x91\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\xF3\xB1\x91\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\xF3\xB1\x91\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\xF3\xB1\x91\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\xF3\xB1\x91\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\xF3\xB1\x91\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\xF3\xB1\x91\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\xF3\xB1\x91\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\xF3\xB1\x91\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\xF3\xB1\x91\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\xF3\xB1\x91\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\xF3\xB1\x91\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\xF3\xB1\x91\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\xF3\xB1\x91\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\xF3\xB1\x91\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\xF3\xB1\x91\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\xF3\xB1\x91\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x21"],
        ["\xF3\xB1\x91\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x22"],
        ["\xF3\xB1\x91\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x23"],
        ["\xF3\xB1\x91\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x24"],
        ["\xF3\xB1\x91\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x25"],
        ["\xF3\xB1\x91\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x26"],
        ["\xF3\xB1\x91\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x27"],
        ["\xF3\xB1\x91\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x28"],
        ["\xF3\xB1\x91\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x29"],
        ["\xF3\xB1\x91\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2A"],
        ["\xF3\xB1\x92\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2B"],
        ["\xF3\xB1\x92\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2C"],
        ["\xF3\xB1\x92\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2D"],
        ["\xF3\xB1\x92\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2E"],
        ["\xF3\xB1\x92\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x2F"],
        ["\xF3\xB1\x92\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x30"],
        ["\xF3\xB1\x92\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x31"],
        ["\xF3\xB1\x92\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x32"],
        ["\xF3\xB1\x92\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x33"],
        ["\xF3\xB1\x92\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x34"],
        ["\xF3\xB1\x92\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x35"],
        ["\xF3\xB1\x92\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x36"],
        ["\xF3\xB1\x92\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x37"],
        ["\xF3\xB1\x92\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x38"],
        ["\xF3\xB1\x92\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x39"],
        ["\xF3\xB1\x92\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3A"],
        ["\xF3\xB1\x92\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3B"],
        ["\xF3\xB1\x92\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3C"],
        ["\xF3\xB1\x92\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3D"],
        ["\xF3\xB1\x92\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3E"],
        ["\xF3\xB1\x92\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x3F"],
        ["\xF3\xB1\x92\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x40"],
        ["\xF3\xB1\x92\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\xF3\xB1\x92\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\xF3\xB1\x92\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\xF3\xB1\x92\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],
        ["\xF3\xB1\x92\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\xF3\xB1\x92\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\xF3\xB1\x92\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\xF3\xB1\x92\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\xF3\xB1\x92\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\xF3\xB1\x92\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\xF3\xB1\x92\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\xF3\xB1\x92\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\xF3\xB1\x92\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\xF3\xB1\x92\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\xF3\xB1\x92\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\xF3\xB1\x92\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\xF3\xB1\x92\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\xF3\xB1\x92\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\xF3\xB1\x92\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\xF3\xB1\x92\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\xF3\xB1\x92\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\xF3\xB1\x92\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\xF3\xB1\x92\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\xF3\xB1\x92\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\xF3\xB1\x92\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\xF3\xB1\x92\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\xF3\xB1\x92\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\xF3\xB1\x92\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\xF3\xB1\x92\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],
        ["\xF3\xB1\x92\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\xF3\xB1\x92\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\xF3\xB1\x92\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\xF3\xB1\x92\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\xF3\xB1\x92\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x62"],
        ["\xF3\xB1\x92\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\xF3\xB1\x92\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\xF3\xB1\x92\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],
        ["\xF3\xB1\x92\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],
        ["\xF3\xB1\x92\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\xF3\xB1\x92\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\xF3\xB1\x92\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\xF3\xB1\x92\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6A"],
        ["\xF3\xB1\x93\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\xF3\xB1\x93\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\xF3\xB1\x93\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\xF3\xB1\x93\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],
        ["\xF3\xB1\x93\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\xF3\xB1\x93\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],
        ["\xF3\xB1\x93\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],
        ["\xF3\xB1\x93\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\xF3\xB1\x93\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\xF3\xB1\x93\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],
        ["\xF3\xB1\x93\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\xF3\xB1\x93\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\xF3\xB1\x93\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\xF3\xB1\x93\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\xF3\xB1\x93\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\xF3\xB1\x93\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\xF3\xB1\x93\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],
        ["\xF3\xB1\x93\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\xF3\xB1\x93\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\xF3\xB1\x93\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\xF3\xB1\x93\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x21"],
        ["\xF3\xB1\x93\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x22"],
        ["\xF3\xB1\x93\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x23"],
        ["\xF3\xB1\x93\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x24"],
        ["\xF3\xB1\x93\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x25"],
        ["\xF3\xB1\x93\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x26"],
        ["\xF3\xB1\x93\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x27"],
        ["\xF3\xB1\x93\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x28"],
        ["\xF3\xB1\x93\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x29"],
        ["\xF3\xB1\x93\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2A"],
        ["\xF3\xB1\x93\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2B"],
        ["\xF3\xB1\x93\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2C"],
        ["\xF3\xB1\x93\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2D"],
        ["\xF3\xB1\x93\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2E"],
        ["\xF3\xB1\x93\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x2F"],
        ["\xF3\xB1\x93\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x30"],
        ["\xF3\xB1\x93\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x31"],
        ["\xF3\xB1\x93\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x32"],
        ["\xF3\xB1\x93\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x33"],
        ["\xF3\xB1\x93\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x34"],
        ["\xF3\xB1\x93\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x35"],
        ["\xF3\xB1\x93\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x36"],
        ["\xF3\xB1\x93\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x37"],
        ["\xF3\xB1\x93\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x38"],
        ["\xF3\xB1\x93\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x39"],
        ["\xF3\xB1\x93\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3A"],
        ["\xF3\xB1\x93\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3C"],
        ["\xF3\xB1\x93\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3D"],
        ["\xF3\xB1\x93\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3E"],
        ["\xF3\xB1\x93\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3F"],
        ["\xF3\xB1\x93\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x40"],
        ["\xF3\xB1\x93\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\xF3\xB1\x93\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\xF3\xB1\x93\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\xF3\xB1\x93\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\xF3\xB1\x93\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\xF3\xB1\x93\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\xF3\xB1\x93\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\xF3\xB1\x93\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\xF3\xB1\x93\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\xF3\xB1\x93\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\xF3\xB1\x93\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\xF3\xB1\x93\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\xF3\xB1\x94\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\xF3\xB1\x94\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\xF3\xB1\x94\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\xF3\xB1\x94\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\xF3\xB1\x94\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\xF3\xB1\x94\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\xF3\xB1\x94\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\xF3\xB1\x94\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\xF3\xB1\x94\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\xF3\xB1\x94\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x56"],
        ["\xF3\xB1\x94\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\xF3\xB1\x94\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],
        ["\xF3\xB1\x94\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\xF3\xB1\x94\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\xF3\xB1\x94\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\xF3\xB1\x94\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\xF3\xB1\x94\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\xF3\xB1\x94\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\xF3\xB1\x94\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\xF3\xB1\x94\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\xF3\xB1\x94\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\xF3\xB1\x94\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\xF3\xB1\x94\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\xF3\xB1\x94\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\xF3\xB1\x94\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\xF3\xB1\x94\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\xF3\xB1\x94\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\xF3\xB1\x94\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\xF3\xB1\x94\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\xF3\xB1\x94\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\xF3\xB1\x94\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\xF3\xB1\x94\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\xF3\xB1\x94\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\xF3\xB1\x94\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\xF3\xB1\x94\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\xF3\xB1\x94\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\xF3\xB1\x94\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\xF3\xB1\x94\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\xF3\xB1\x94\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\xF3\xB1\x94\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\xF3\xB1\x94\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\xF3\xB1\x94\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\xF3\xB1\x94\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\xF3\xB1\x94\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\xF3\xB1\x94\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\xF3\xB1\x94\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\xF3\xB1\x94\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\xF3\xB1\x94\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\xF3\xB1\x94\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\xF3\xB1\x94\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\xF3\xB1\x94\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x21"],
        ["\xF3\xB1\x94\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x22"],
        ["\xF3\xB1\x94\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x23"],
        ["\xF3\xB1\x94\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x24"],
        ["\xF3\xB1\x94\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x25"],
        ["\xF3\xB1\x94\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x26"],
        ["\xF3\xB1\x94\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x27"],
        ["\xF3\xB1\x94\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x28"],
        ["\xF3\xB1\x94\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x29"],
        ["\xF3\xB1\x94\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2A"],
        ["\xF3\xB1\x94\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2B"],
        ["\xF3\xB1\x94\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2C"],
        ["\xF3\xB1\x94\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2D"],
        ["\xF3\xB1\x94\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2E"],
        ["\xF3\xB1\x95\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x2F"],
        ["\xF3\xB1\x95\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x30"],
        ["\xF3\xB1\x95\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x31"],
        ["\xF3\xB1\x95\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x32"],
        ["\xF3\xB1\x95\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x33"],
        ["\xF3\xB1\x95\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x34"],
        ["\xF3\xB1\x95\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x35"],
        ["\xF3\xB1\x95\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x36"],
        ["\xF3\xB1\x95\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x37"],
        ["\xF3\xB1\x95\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x38"],
        ["\xF3\xB1\x95\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x39"],
        ["\xF3\xB1\x95\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3A"],
        ["\xF3\xB1\x95\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3B"],
        ["\xF3\xB1\x95\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3C"],
        ["\xF3\xB1\x95\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3D"],
        ["\xF3\xB1\x95\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3E"],
        ["\xF3\xB1\x95\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x3F"],
        ["\xF3\xB1\x95\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x40"],
        ["\xF3\xB1\x95\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\xF3\xB1\x95\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\xF3\xB1\x95\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\xF3\xB1\x95\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\xF3\xB1\x95\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\xF3\xB1\x95\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\xF3\xB1\x95\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\xF3\xB1\x95\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\xF3\xB1\x95\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\xF3\xB1\x95\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\xF3\xB1\x95\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\xF3\xB1\x95\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\xF3\xB1\x95\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\xF3\xB1\x95\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\xF3\xB1\x95\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\xF3\xB1\x95\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\xF3\xB1\x95\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\xF3\xB1\x95\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\xF3\xB1\x95\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\xF3\xB1\x95\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\xF3\xB1\x95\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\xF3\xB1\x95\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\xF3\xB1\x95\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\xF3\xB1\x95\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\xF3\xB1\x95\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\xF3\xB1\x95\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\xF3\xB1\x95\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\xF3\xB1\x95\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\xF3\xB1\x95\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\xF3\xB1\x95\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\xF3\xB1\x95\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\xF3\xB1\x95\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x60"],
        ["\xF3\xB1\x95\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\xF3\xB1\x95\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\xF3\xB1\x95\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x63"],
        ["\xF3\xB1\x95\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\xF3\xB1\x95\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\xF3\xB1\x95\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\xF3\xB1\x95\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\xF3\xB1\x95\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\xF3\xB1\x95\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\xF3\xB1\x95\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\xF3\xB1\x95\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\xF3\xB1\x95\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],
        ["\xF3\xB1\x95\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\xF3\xB1\x95\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\xF3\xB1\x96\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\xF3\xB1\x96\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],
        ["\xF3\xB1\x96\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\xF3\xB1\x96\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\xF3\xB1\x96\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],
        ["\xF3\xB1\x96\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\xF3\xB1\x96\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\xF3\xB1\x96\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\xF3\xB1\x96\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],
        ["\xF3\xB1\x96\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\xF3\xB1\x96\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\xF3\xB1\x96\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\xF3\xB1\x96\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\xF3\xB1\x96\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\xF3\xB1\x96\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\xF3\xB1\x96\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\xF3\xB1\x96\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x21"],
        ["\xF3\xB1\x96\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x22"],
        ["\xF3\xB1\x96\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x23"],
        ["\xF3\xB1\x96\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x24"],
        ["\xF3\xB1\x96\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x25"],
        ["\xF3\xB1\x96\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x26"],
        ["\xF3\xB1\x96\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x27"],
        ["\xF3\xB1\x96\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x28"],
        ["\xF3\xB1\x96\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x29"],
        ["\xF3\xB1\x96\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2A"],
        ["\xF3\xB1\x96\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2B"],
        ["\xF3\xB1\x96\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2C"],
        ["\xF3\xB1\x96\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2D"],
        ["\xF3\xB1\x96\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2E"],
        ["\xF3\xB1\x96\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x2F"],
        ["\xF3\xB1\x96\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x30"],
        ["\xF3\xB1\x96\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x31"],
        ["\xF3\xB1\x96\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x32"],
        ["\xF3\xB1\x96\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x33"],
        ["\xF3\xB1\x96\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x34"],
        ["\xF3\xB1\x96\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x35"],
        ["\xF3\xB1\x96\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x36"],
        ["\xF3\xB1\x96\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x37"],
        ["\xF3\xB1\x96\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x38"],
        ["\xF3\xB1\x96\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x39"],
        ["\xF3\xB1\x96\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3A"],
        ["\xF3\xB1\x96\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3B"],
        ["\xF3\xB1\x96\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3C"],
        ["\xF3\xB1\x96\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3D"],
        ["\xF3\xB1\x96\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3E"],
        ["\xF3\xB1\x96\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x3F"],
        ["\xF3\xB1\x96\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x40"],
        ["\xF3\xB1\x96\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\xF3\xB1\x96\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],
        ["\xF3\xB1\x96\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\xF3\xB1\x96\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],
        ["\xF3\xB1\x96\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\xF3\xB1\x96\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\xF3\xB1\x96\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\xF3\xB1\x96\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\xF3\xB1\x96\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\xF3\xB1\x96\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\xF3\xB1\x96\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\xF3\xB1\x96\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\xF3\xB1\x96\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\xF3\xB1\x96\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\xF3\xB1\x96\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\xF3\xB1\x96\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\xF3\xB1\x97\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],
        ["\xF3\xB1\x97\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\xF3\xB1\x97\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\xF3\xB1\x97\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\xF3\xB1\x97\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\xF3\xB1\x97\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\xF3\xB1\x97\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\xF3\xB1\x97\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\xF3\xB1\x97\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\xF3\xB1\x97\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\xF3\xB1\x97\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\xF3\xB1\x97\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\xF3\xB1\x97\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\xF3\xB1\x97\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\xF3\xB1\x97\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\xF3\xB1\x97\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\xF3\xB1\x97\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\xF3\xB1\x97\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\xF3\xB1\x97\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\xF3\xB1\x97\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\xF3\xB1\x97\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\xF3\xB1\x97\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\xF3\xB1\x97\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\xF3\xB1\x97\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\xF3\xB1\x97\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\xF3\xB1\x97\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\xF3\xB1\x97\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\xF3\xB1\x97\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\xF3\xB1\x97\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\xF3\xB1\x97\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\xF3\xB1\x97\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\xF3\xB1\x97\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\xF3\xB1\x97\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\xF3\xB1\x97\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\xF3\xB1\x97\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\xF3\xB1\x97\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\xF3\xB1\x97\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\xF3\xB1\x97\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\xF3\xB1\x97\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\xF3\xB1\x97\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x49"],
        ["\xF3\xB1\x97\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\xF3\xB1\x97\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\xF3\xB1\x97\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\xF3\xB1\x97\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\xF3\xB1\x97\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\xF3\xB1\x97\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\xF3\xB1\x97\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x21"],
        ["\xF3\xB1\x97\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x22"],
        ["\xF3\xB1\x97\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x23"],
        ["\xF3\xB1\x97\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x24"],
        ["\xF3\xB1\x97\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x25"],
        ["\xF3\xB1\x97\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x26"],
        ["\xF3\xB1\x97\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x27"],
        ["\xF3\xB1\x97\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x28"],
        ["\xF3\xB1\x97\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x29"],
        ["\xF3\xB1\x97\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2A"],
        ["\xF3\xB1\x97\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2B"],
        ["\xF3\xB1\x97\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2C"],
        ["\xF3\xB1\x97\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2D"],
        ["\xF3\xB1\x97\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2E"],
        ["\xF3\xB1\x97\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x2F"],
        ["\xF3\xB1\x97\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x30"],
        ["\xF3\xB1\x97\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x31"],
        ["\xF3\xB1\x97\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x32"],
        ["\xF3\xB1\x98\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x33"],
        ["\xF3\xB1\x98\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x34"],
        ["\xF3\xB1\x98\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x35"],
        ["\xF3\xB1\x98\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x36"],
        ["\xF3\xB1\x98\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x37"],
        ["\xF3\xB1\x98\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x38"],
        ["\xF3\xB1\x98\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x39"],
        ["\xF3\xB1\x98\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3A"],
        ["\xF3\xB1\x98\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3B"],
        ["\xF3\xB1\x98\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3C"],
        ["\xF3\xB1\x98\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3D"],
        ["\xF3\xB1\x98\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3E"],
        ["\xF3\xB1\x98\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x3F"],
        ["\xF3\xB1\x98\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x40"],
        ["\xF3\xB1\x98\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\xF3\xB1\x98\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\xF3\xB1\x98\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\xF3\xB1\x98\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x44"],
        ["\xF3\xB1\x98\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\xF3\xB1\x98\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\xF3\xB1\x98\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\xF3\xB1\x98\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\xF3\xB1\x98\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\xF3\xB1\x98\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\xF3\xB1\x98\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\xF3\xB1\x98\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\xF3\xB1\x98\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\xF3\xB1\x98\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\xF3\xB1\x98\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\xF3\xB1\x98\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\xF3\xB1\x98\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x51"],
        ["\xF3\xB1\x98\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\xF3\xB1\x98\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\xF3\xB1\x98\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\xF3\xB1\x98\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\xF3\xB1\x98\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\xF3\xB1\x98\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\xF3\xB1\x98\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\xF3\xB1\x98\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\xF3\xB1\x98\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\xF3\xB1\x98\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\xF3\xB1\x98\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\xF3\xB1\x98\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\xF3\xB1\x98\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\xF3\xB1\x98\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\xF3\xB1\x98\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\xF3\xB1\x98\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\xF3\xB1\x98\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\xF3\xB1\x98\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\xF3\xB1\x98\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\xF3\xB1\x98\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\xF3\xB1\x98\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\xF3\xB1\x98\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\xF3\xB1\x98\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\xF3\xB1\x98\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\xF3\xB1\x98\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\xF3\xB1\x98\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\xF3\xB1\x98\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\xF3\xB1\x98\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\xF3\xB1\x98\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\xF3\xB1\x98\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\xF3\xB1\x98\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\xF3\xB1\x98\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\xF3\xB1\x98\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\xF3\xB1\x99\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\xF3\xB1\x99\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\xF3\xB1\x99\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\xF3\xB1\x99\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\xF3\xB1\x99\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\xF3\xB1\x99\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\xF3\xB1\x99\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\xF3\xB1\x99\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\xF3\xB1\x99\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\xF3\xB1\x99\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\xF3\xB1\x99\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\xF3\xB1\x99\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\xF3\xB1\x99\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x21"],
        ["\xF3\xB1\x99\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x22"],
        ["\xF3\xB1\x99\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x23"],
        ["\xF3\xB1\x99\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x24"],
        ["\xF3\xB1\x99\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x25"],
        ["\xF3\xB1\x99\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x26"],
        ["\xF3\xB1\x99\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x27"],
        ["\xF3\xB1\x99\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x28"],
        ["\xF3\xB1\x99\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x29"],
        ["\xF3\xB1\x99\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2A"],
        ["\xF3\xB1\x99\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2B"],
        ["\xF3\xB1\x99\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2C"],
        ["\xF3\xB1\x99\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2D"],
        ["\xF3\xB1\x99\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2E"],
        ["\xF3\xB1\x99\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x2F"],
        ["\xF3\xB1\x99\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x30"],
        ["\xF3\xB1\x99\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x31"],
        ["\xF3\xB1\x99\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x32"],
        ["\xF3\xB1\x99\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x33"],
        ["\xF3\xB1\x99\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x34"],
        ["\xF3\xB1\x99\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x35"],
        ["\xF3\xB1\x99\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x36"],
        ["\xF3\xB1\x99\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x37"],
        ["\xF3\xB1\x99\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x38"],
        ["\xF3\xB1\x99\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x39"],
        ["\xF3\xB1\x99\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3A"],
        ["\xF3\xB1\x99\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3B"],
        ["\xF3\xB1\x99\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3C"],
        ["\xF3\xB1\x99\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3D"],
        ["\xF3\xB1\x99\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3E"],
        ["\xF3\xB1\x99\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x3F"],
        ["\xF3\xB1\x99\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x40"],
        ["\xF3\xB1\x99\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\xF3\xB1\x99\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\xF3\xB1\x99\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\xF3\xB1\x99\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\xF3\xB1\x99\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\xF3\xB1\x99\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\xF3\xB1\x99\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\xF3\xB1\x99\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\xF3\xB1\x99\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\xF3\xB1\x99\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\xF3\xB1\x99\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\xF3\xB1\x99\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\xF3\xB1\x99\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\xF3\xB1\x99\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\xF3\xB1\x99\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\xF3\xB1\x99\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\xF3\xB1\x99\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\xF3\xB1\x99\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\xF3\xB1\x99\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],
        ["\xF3\xB1\x99\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],
        ["\xF3\xB1\x9A\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\xF3\xB1\x9A\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\xF3\xB1\x9A\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\xF3\xB1\x9A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49\x30"],
        ["\xF3\xB1\x9A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\xF3\xB1\x9A\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\xF3\xB1\x9A\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\xF3\xB1\x9A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\xF3\xB1\x9A\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\xF3\xB1\x9A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\xF3\xB1\x9A\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\xF3\xB1\x9A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\xF3\xB1\x9A\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\xF3\xB1\x9A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\xF3\xB1\x9A\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\xF3\xB1\x9A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\xF3\xB1\x9A\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\xF3\xB1\x9A\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\xF3\xB1\x9A\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\xF3\xB1\x9A\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\xF3\xB1\x9A\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\xF3\xB1\x9A\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\xF3\xB1\x9A\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\xF3\xB1\x9A\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\xF3\xB1\x9A\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\xF3\xB1\x9A\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\xF3\xB1\x9A\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\xF3\xB1\x9A\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\xF3\xB1\x9A\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\xF3\xB1\x9A\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\xF3\xB1\x9A\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\xF3\xB1\x9A\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\xF3\xB1\x9A\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\xF3\xB1\x9A\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\xF3\xB1\x9A\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\xF3\xB1\x9A\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\xF3\xB1\x9A\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\xF3\xB1\x9A\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\xF3\xB1\x9A\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\xF3\xB1\x9A\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\xF3\xB1\x9A\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\xF3\xB1\x9A\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\xF3\xB1\x9A\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x21"],
        ["\xF3\xB1\x9A\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x22"],
        ["\xF3\xB1\x9A\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x23"],
        ["\xF3\xB1\x9A\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x24"],
        ["\xF3\xB1\x9A\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x25"],
        ["\xF3\xB1\x9A\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x26"],
        ["\xF3\xB1\x9A\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x27"],
        ["\xF3\xB1\x9A\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x28"],
        ["\xF3\xB1\x9A\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x29"],
        ["\xF3\xB1\x9A\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2A"],
        ["\xF3\xB1\x9A\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2B"],
        ["\xF3\xB1\x9A\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2C"],
        ["\xF3\xB1\x9A\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2D"],
        ["\xF3\xB1\x9A\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2E"],
        ["\xF3\xB1\x9A\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x2F"],
        ["\xF3\xB1\x9A\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x30"],
        ["\xF3\xB1\x9A\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x31"],
        ["\xF3\xB1\x9A\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x32"],
        ["\xF3\xB1\x9A\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x33"],
        ["\xF3\xB1\x9A\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x34"],
        ["\xF3\xB1\x9A\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x35"],
        ["\xF3\xB1\x9A\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x36"],
        ["\xF3\xB1\x9B\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x37"],
        ["\xF3\xB1\x9B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x38"],
        ["\xF3\xB1\x9B\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x39"],
        ["\xF3\xB1\x9B\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3A"],
        ["\xF3\xB1\x9B\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3B"],
        ["\xF3\xB1\x9B\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3C"],
        ["\xF3\xB1\x9B\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3D"],
        ["\xF3\xB1\x9B\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3E"],
        ["\xF3\xB1\x9B\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x3F"],
        ["\xF3\xB1\x9B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x40"],
        ["\xF3\xB1\x9B\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\xF3\xB1\x9B\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\xF3\xB1\x9B\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\xF3\xB1\x9B\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\xF3\xB1\x9B\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\xF3\xB1\x9B\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\xF3\xB1\x9B\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\xF3\xB1\x9B\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\xF3\xB1\x9B\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\xF3\xB1\x9B\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\xF3\xB1\x9B\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\xF3\xB1\x9B\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\xF3\xB1\x9B\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\xF3\xB1\x9B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\xF3\xB1\x9B\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\xF3\xB1\x9B\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\xF3\xB1\x9B\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\xF3\xB1\x9B\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\xF3\xB1\x9B\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\xF3\xB1\x9B\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\xF3\xB1\x9B\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\xF3\xB1\x9B\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\xF3\xB1\x9B\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\xF3\xB1\x9B\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\xF3\xB1\x9B\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\xF3\xB1\x9B\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\xF3\xB1\x9B\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\xF3\xB1\x9B\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\xF3\xB1\x9B\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\xF3\xB1\x9B\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\xF3\xB1\x9B\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],
        ["\xF3\xB1\x9B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\xF3\xB1\x9B\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\xF3\xB1\x9B\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\xF3\xB1\x9B\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\xF3\xB1\x9B\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\xF3\xB1\x9B\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\xF3\xB1\x9B\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],
        ["\xF3\xB1\x9B\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\xF3\xB1\x9B\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\xF3\xB1\x9B\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\xF3\xB1\x9B\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\xF3\xB1\x9B\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\xF3\xB1\x9B\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\xF3\xB1\x9B\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\xF3\xB1\x9B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],
        ["\xF3\xB1\x9B\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\xF3\xB1\x9B\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\xF3\xB1\x9B\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\xF3\xB1\x9B\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\xF3\xB1\x9B\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\xF3\xB1\x9B\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\xF3\xB1\x9B\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\xF3\xB1\x9B\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\xF3\xB1\x9C\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\xF3\xB1\x9C\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],
        ["\xF3\xB1\x9C\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],
        ["\xF3\xB1\x9C\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\xF3\xB1\x9C\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\xF3\xB1\x9C\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\xF3\xB1\x9C\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\xF3\xB1\x9C\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\xF3\xB1\x9C\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x21"],
        ["\xF3\xB1\x9C\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x22"],
        ["\xF3\xB1\x9C\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x23"],
        ["\xF3\xB1\x9C\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x24"],
        ["\xF3\xB1\x9C\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x25"],
        ["\xF3\xB1\x9C\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x26"],
        ["\xF3\xB1\x9C\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x27"],
        ["\xF3\xB1\x9C\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x28"],
        ["\xF3\xB1\x9C\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x29"],
        ["\xF3\xB1\x9C\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2A"],
        ["\xF3\xB1\x9C\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2B"],
        ["\xF3\xB1\x9C\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2C"],
        ["\xF3\xB1\x9C\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2D"],
        ["\xF3\xB1\x9C\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2E"],
        ["\xF3\xB1\x9C\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x2F"],
        ["\xF3\xB1\x9C\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x30"],
        ["\xF3\xB1\x9C\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x31"],
        ["\xF3\xB1\x9C\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x32"],
        ["\xF3\xB1\x9C\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x33"],
        ["\xF3\xB1\x9C\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x34"],
        ["\xF3\xB1\x9C\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x35"],
        ["\xF3\xB1\x9C\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x36"],
        ["\xF3\xB1\x9C\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x37"],
        ["\xF3\xB1\x9C\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x38"],
        ["\xF3\xB1\x9C\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x39"],
        ["\xF3\xB1\x9C\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3A"],
        ["\xF3\xB1\x9C\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3B"],
        ["\xF3\xB1\x9C\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3C"],
        ["\xF3\xB1\x9C\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3D"],
        ["\xF3\xB1\x9C\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3E"],
        ["\xF3\xB1\x9C\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x3F"],
        ["\xF3\xB1\x9C\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x40"],
        ["\xF3\xB1\x9C\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\xF3\xB1\x9C\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\xF3\xB1\x9C\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\xF3\xB1\x9C\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\xF3\xB1\x9C\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\xF3\xB1\x9C\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\xF3\xB1\x9C\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\xF3\xB1\x9C\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\xF3\xB1\x9C\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\xF3\xB1\x9C\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\xF3\xB1\x9C\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\xF3\xB1\x9C\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\xF3\xB1\x9C\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\xF3\xB1\x9C\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],
        ["\xF3\xB1\x9C\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\xF3\xB1\x9C\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\xF3\xB1\x9C\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\xF3\xB1\x9C\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\xF3\xB1\x9C\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\xF3\xB1\x9C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\xF3\xB1\x9C\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\xF3\xB1\x9C\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\xF3\xB1\x9C\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\xF3\xB1\x9C\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],
        ["\xF3\xB1\x9D\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\xF3\xB1\x9D\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\xF3\xB1\x9D\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\xF3\xB1\x9D\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\xF3\xB1\x9D\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\xF3\xB1\x9D\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\xF3\xB1\x9D\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\xF3\xB1\x9D\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],
        ["\xF3\xB1\x9D\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\xF3\xB1\x9D\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x62"],
        ["\xF3\xB1\x9D\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\xF3\xB1\x9D\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\xF3\xB1\x9D\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\xF3\xB1\x9D\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\xF3\xB1\x9D\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\xF3\xB1\x9D\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\xF3\xB1\x9D\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\xF3\xB1\x9D\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\xF3\xB1\x9D\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6B"],
        ["\xF3\xB1\x9D\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\xF3\xB1\x9D\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\xF3\xB1\x9D\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\xF3\xB1\x9D\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\xF3\xB1\x9D\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\xF3\xB1\x9D\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\xF3\xB1\x9D\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],
        ["\xF3\xB1\x9D\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\xF3\xB1\x9D\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],
        ["\xF3\xB1\x9D\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\xF3\xB1\x9D\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\xF3\xB1\x9D\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\xF3\xB1\x9D\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\xF3\xB1\x9D\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\xF3\xB1\x9D\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x7A"],
        ["\xF3\xB1\x9D\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\xF3\xB1\x9D\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\xF3\xB1\x9D\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\xF3\xB1\x9D\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\xF3\xB1\x9D\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x21"],
        ["\xF3\xB1\x9D\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x22"],
        ["\xF3\xB1\x9D\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x23"],
        ["\xF3\xB1\x9D\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x24"],
        ["\xF3\xB1\x9D\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x25"],
        ["\xF3\xB1\x9D\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x26"],
        ["\xF3\xB1\x9D\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x27"],
        ["\xF3\xB1\x9D\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x28"],
        ["\xF3\xB1\x9D\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x29"],
        ["\xF3\xB1\x9D\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2A"],
        ["\xF3\xB1\x9D\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2B"],
        ["\xF3\xB1\x9D\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2C"],
        ["\xF3\xB1\x9D\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2D"],
        ["\xF3\xB1\x9D\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2E"],
        ["\xF3\xB1\x9D\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x2F"],
        ["\xF3\xB1\x9D\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x30"],
        ["\xF3\xB1\x9D\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x31"],
        ["\xF3\xB1\x9D\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x32"],
        ["\xF3\xB1\x9D\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x33"],
        ["\xF3\xB1\x9D\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x34"],
        ["\xF3\xB1\x9D\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x35"],
        ["\xF3\xB1\x9D\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x36"],
        ["\xF3\xB1\x9D\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x37"],
        ["\xF3\xB1\x9D\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x38"],
        ["\xF3\xB1\x9D\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\xF3\xB1\x9D\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3A"],
        ["\xF3\xB1\x9E\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3B"],
        ["\xF3\xB1\x9E\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3C"],
        ["\xF3\xB1\x9E\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3D"],
        ["\xF3\xB1\x9E\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3E"],
        ["\xF3\xB1\x9E\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x3F"],
        ["\xF3\xB1\x9E\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x40"],
        ["\xF3\xB1\x9E\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\xF3\xB1\x9E\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\xF3\xB1\x9E\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\xF3\xB1\x9E\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\xF3\xB1\x9E\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\xF3\xB1\x9E\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\xF3\xB1\x9E\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\xF3\xB1\x9E\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\xF3\xB1\x9E\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],
        ["\xF3\xB1\x9E\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\xF3\xB1\x9E\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\xF3\xB1\x9E\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\xF3\xB1\x9E\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\xF3\xB1\x9E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\xF3\xB1\x9E\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\xF3\xB1\x9E\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\xF3\xB1\x9E\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\xF3\xB1\x9E\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\xF3\xB1\x9E\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\xF3\xB1\x9E\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\xF3\xB1\x9E\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\xF3\xB1\x9E\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\xF3\xB1\x9E\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\xF3\xB1\x9E\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\xF3\xB1\x9E\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\xF3\xB1\x9E\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\xF3\xB1\x9E\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\xF3\xB1\x9E\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\xF3\xB1\x9E\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\xF3\xB1\x9E\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\xF3\xB1\x9E\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\xF3\xB1\x9E\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\xF3\xB1\x9E\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\xF3\xB1\x9E\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\xF3\xB1\x9E\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\xF3\xB1\x9E\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\xF3\xB1\x9E\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\xF3\xB1\x9E\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\xF3\xB1\x9E\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\xF3\xB1\x9E\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\xF3\xB1\x9E\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\xF3\xB1\x9E\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\xF3\xB1\x9E\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\xF3\xB1\x9E\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\xF3\xB1\x9E\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\xF3\xB1\x9E\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\xF3\xB1\x9E\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\xF3\xB1\x9E\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\xF3\xB1\x9E\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\xF3\xB1\x9E\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\xF3\xB1\x9E\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\xF3\xB1\x9E\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\xF3\xB1\x9E\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x43"],
        ["\xF3\xB1\x9E\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\xF3\xB1\x9E\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\xF3\xB1\x9E\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\xF3\xB1\x9E\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\xF3\xB1\x9E\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\xF3\xB1\x9F\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\xF3\xB1\x9F\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\xF3\xB1\x9F\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\xF3\xB1\x9F\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\xF3\xB1\x9F\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x21"],
        ["\xF3\xB1\x9F\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x22"],
        ["\xF3\xB1\x9F\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x23"],
        ["\xF3\xB1\x9F\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x24"],
        ["\xF3\xB1\x9F\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x25"],
        ["\xF3\xB1\x9F\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x26"],
        ["\xF3\xB1\x9F\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x27"],
        ["\xF3\xB1\x9F\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x28"],
        ["\xF3\xB1\x9F\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x29"],
        ["\xF3\xB1\x9F\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2A"],
        ["\xF3\xB1\x9F\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2B"],
        ["\xF3\xB1\x9F\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2C"],
        ["\xF3\xB1\x9F\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2D"],
        ["\xF3\xB1\x9F\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2E"],
        ["\xF3\xB1\x9F\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x2F"],
        ["\xF3\xB1\x9F\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x30"],
        ["\xF3\xB1\x9F\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x31"],
        ["\xF3\xB1\x9F\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x32"],
        ["\xF3\xB1\x9F\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x33"],
        ["\xF3\xB1\x9F\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x34"],
        ["\xF3\xB1\x9F\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x35"],
        ["\xF3\xB1\x9F\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x36"],
        ["\xF3\xB1\x9F\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x37"],
        ["\xF3\xB1\x9F\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x38"],
        ["\xF3\xB1\x9F\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x39"],
        ["\xF3\xB1\x9F\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3A"],
        ["\xF3\xB1\x9F\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3B"],
        ["\xF3\xB1\x9F\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3C"],
        ["\xF3\xB1\x9F\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3D"],
        ["\xF3\xB1\x9F\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3E"],
        ["\xF3\xB1\x9F\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x3F"],
        ["\xF3\xB1\x9F\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x40"],
        ["\xF3\xB1\x9F\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\xF3\xB1\x9F\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\xF3\xB1\x9F\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\xF3\xB1\x9F\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\xF3\xB1\x9F\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\xF3\xB1\x9F\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\xF3\xB1\x9F\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\xF3\xB1\x9F\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\xF3\xB1\x9F\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\xF3\xB1\x9F\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\xF3\xB1\x9F\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\xF3\xB1\x9F\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\xF3\xB1\x9F\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\xF3\xB1\x9F\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\xF3\xB1\x9F\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\xF3\xB1\x9F\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\xF3\xB1\x9F\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\xF3\xB1\x9F\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\xF3\xB1\x9F\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\xF3\xB1\x9F\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\xF3\xB1\x9F\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\xF3\xB1\x9F\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\xF3\xB1\x9F\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\xF3\xB1\x9F\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\xF3\xB1\x9F\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\xF3\xB1\x9F\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\xF3\xB1\x9F\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\xF3\xB1\x9F\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\xF3\xB1\xA0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\xF3\xB1\xA0\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\xF3\xB1\xA0\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\xF3\xB1\xA0\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\xF3\xB1\xA0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\xF3\xB1\xA0\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\xF3\xB1\xA0\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\xF3\xB1\xA0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\xF3\xB1\xA0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\xF3\xB1\xA0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\xF3\xB1\xA0\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\xF3\xB1\xA0\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\xF3\xB1\xA0\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\xF3\xB1\xA0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\xF3\xB1\xA0\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\xF3\xB1\xA0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\xF3\xB1\xA0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\xF3\xB1\xA0\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\xF3\xB1\xA0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\xF3\xB1\xA0\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\xF3\xB1\xA0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\xF3\xB1\xA0\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\xF3\xB1\xA0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\xF3\xB1\xA0\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\xF3\xB1\xA0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\xF3\xB1\xA0\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\xF3\xB1\xA0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\xF3\xB1\xA0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\xF3\xB1\xA0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\xF3\xB1\xA0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\xF3\xB1\xA0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\xF3\xB1\xA0\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\xF3\xB1\xA0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\xF3\xB1\xA0\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\xF3\xB1\xA0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x21"],
        ["\xF3\xB1\xA0\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x22"],
        ["\xF3\xB1\xA0\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x23"],
        ["\xF3\xB1\xA0\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x24"],
        ["\xF3\xB1\xA0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x25"],
        ["\xF3\xB1\xA0\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x26"],
        ["\xF3\xB1\xA0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x27"],
        ["\xF3\xB1\xA0\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x28"],
        ["\xF3\xB1\xA0\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x29"],
        ["\xF3\xB1\xA0\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2A"],
        ["\xF3\xB1\xA0\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2B"],
        ["\xF3\xB1\xA0\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2C"],
        ["\xF3\xB1\xA0\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2D"],
        ["\xF3\xB1\xA0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2E"],
        ["\xF3\xB1\xA0\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x2F"],
        ["\xF3\xB1\xA0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x30"],
        ["\xF3\xB1\xA0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x31"],
        ["\xF3\xB1\xA0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x32"],
        ["\xF3\xB1\xA0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x33"],
        ["\xF3\xB1\xA0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x34"],
        ["\xF3\xB1\xA0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x35"],
        ["\xF3\xB1\xA0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x36"],
        ["\xF3\xB1\xA0\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x37"],
        ["\xF3\xB1\xA0\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x38"],
        ["\xF3\xB1\xA0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x39"],
        ["\xF3\xB1\xA0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3A"],
        ["\xF3\xB1\xA0\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3B"],
        ["\xF3\xB1\xA0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3C"],
        ["\xF3\xB1\xA0\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3D"],
        ["\xF3\xB1\xA0\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3E"],
        ["\xF3\xB1\xA1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x3F"],
        ["\xF3\xB1\xA1\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x40"],
        ["\xF3\xB1\xA1\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\xF3\xB1\xA1\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\xF3\xB1\xA1\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\xF3\xB1\xA1\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\xF3\xB1\xA1\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\xF3\xB1\xA1\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\xF3\xB1\xA1\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\xF3\xB1\xA1\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\xF3\xB1\xA1\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\xF3\xB1\xA1\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\xF3\xB1\xA1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\xF3\xB1\xA1\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\xF3\xB1\xA1\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\xF3\xB1\xA1\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\xF3\xB1\xA1\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\xF3\xB1\xA1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\xF3\xB1\xA1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\xF3\xB1\xA1\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\xF3\xB1\xA1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\xF3\xB1\xA1\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\xF3\xB1\xA1\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\xF3\xB1\xA1\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\xF3\xB1\xA1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\xF3\xB1\xA1\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],
        ["\xF3\xB1\xA1\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\xF3\xB1\xA1\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],
        ["\xF3\xB1\xA1\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\xF3\xB1\xA1\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\xF3\xB1\xA1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\xF3\xB1\xA1\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\xF3\xB1\xA1\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\xF3\xB1\xA1\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\xF3\xB1\xA1\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\xF3\xB1\xA1\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\xF3\xB1\xA1\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\xF3\xB1\xA1\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\xF3\xB1\xA1\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\xF3\xB1\xA1\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\xF3\xB1\xA1\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\xF3\xB1\xA1\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\xF3\xB1\xA1\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\xF3\xB1\xA1\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\xF3\xB1\xA1\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\xF3\xB1\xA1\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\xF3\xB1\xA1\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\xF3\xB1\xA1\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\xF3\xB1\xA1\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\xF3\xB1\xA1\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\xF3\xB1\xA1\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\xF3\xB1\xA1\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\xF3\xB1\xA1\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\xF3\xB1\xA1\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\xF3\xB1\xA1\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\xF3\xB1\xA1\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xF3\xB1\xA1\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\xF3\xB1\xA1\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\xF3\xB1\xA1\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\xF3\xB1\xA1\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\xF3\xB1\xA1\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\xF3\xB1\xA1\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\xF3\xB1\xA1\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\xF3\xB1\xA1\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\xF3\xB1\xA2\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x21"],
        ["\xF3\xB1\xA2\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x22"],
        ["\xF3\xB1\xA2\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x23"],
        ["\xF3\xB1\xA2\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x24"],
        ["\xF3\xB1\xA2\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x25"],
        ["\xF3\xB1\xA2\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x26"],
        ["\xF3\xB1\xA2\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x27"],
        ["\xF3\xB1\xA2\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x28"],
        ["\xF3\xB1\xA2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x29"],
        ["\xF3\xB1\xA2\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2A"],
        ["\xF3\xB1\xA2\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2B"],
        ["\xF3\xB1\xA2\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2C"],
        ["\xF3\xB1\xA2\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2D"],
        ["\xF3\xB1\xA2\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2E"],
        ["\xF3\xB1\xA2\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x2F"],
        ["\xF3\xB1\xA2\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x30"],
        ["\xF3\xB1\xA2\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x31"],
        ["\xF3\xB1\xA2\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x32"],
        ["\xF3\xB1\xA2\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x33"],
        ["\xF3\xB1\xA2\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x34"],
        ["\xF3\xB1\xA2\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x35"],
        ["\xF3\xB1\xA2\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x36"],
        ["\xF3\xB1\xA2\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x37"],
        ["\xF3\xB1\xA2\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x38"],
        ["\xF3\xB1\xA2\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x39"],
        ["\xF3\xB1\xA2\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3A"],
        ["\xF3\xB1\xA2\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3B"],
        ["\xF3\xB1\xA2\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3C"],
        ["\xF3\xB1\xA2\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3D"],
        ["\xF3\xB1\xA2\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3E"],
        ["\xF3\xB1\xA2\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x3F"],
        ["\xF3\xB1\xA2\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x40"],
        ["\xF3\xB1\xA2\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\xF3\xB1\xA2\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\xF3\xB1\xA2\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\xF3\xB1\xA2\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\xF3\xB1\xA2\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\xF3\xB1\xA2\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\xF3\xB1\xA2\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\xF3\xB1\xA2\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\xF3\xB1\xA2\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\xF3\xB1\xA2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\xF3\xB1\xA2\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\xF3\xB1\xA2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\xF3\xB1\xA2\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\xF3\xB1\xA2\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\xF3\xB1\xA2\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\xF3\xB1\xA2\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\xF3\xB1\xA2\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\xF3\xB1\xA2\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\xF3\xB1\xA2\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\xF3\xB1\xA2\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\xF3\xB1\xA2\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\xF3\xB1\xA2\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\xF3\xB1\xA2\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],
        ["\xF3\xB1\xA2\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\xF3\xB1\xA2\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\xF3\xB1\xA2\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\xF3\xB1\xA2\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\xF3\xB1\xA2\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\xF3\xB1\xA2\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\xF3\xB1\xA2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\xF3\xB1\xA2\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\xF3\xB1\xA2\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\xF3\xB1\xA3\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\xF3\xB1\xA3\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\xF3\xB1\xA3\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\xF3\xB1\xA3\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\xF3\xB1\xA3\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\xF3\xB1\xA3\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\xF3\xB1\xA3\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\xF3\xB1\xA3\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\xF3\xB1\xA3\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\xF3\xB1\xA3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\xF3\xB1\xA3\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\xF3\xB1\xA3\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\xF3\xB1\xA3\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\xF3\xB1\xA3\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6E"],
        ["\xF3\xB1\xA3\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\xF3\xB1\xA3\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\xF3\xB1\xA3\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\xF3\xB1\xA3\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\xF3\xB1\xA3\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\xF3\xB1\xA3\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\xF3\xB1\xA3\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\xF3\xB1\xA3\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\xF3\xB1\xA3\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x77"],
        ["\xF3\xB1\xA3\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\xF3\xB1\xA3\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\xF3\xB1\xA3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\xF3\xB1\xA3\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\xF3\xB1\xA3\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\xF3\xB1\xA3\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\xF3\xB1\xA3\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\xF3\xB1\xA3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x21"],
        ["\xF3\xB1\xA3\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x22"],
        ["\xF3\xB1\xA3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x23"],
        ["\xF3\xB1\xA3\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x24"],
        ["\xF3\xB1\xA3\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x25"],
        ["\xF3\xB1\xA3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x26"],
        ["\xF3\xB1\xA3\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x27"],
        ["\xF3\xB1\xA3\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x28"],
        ["\xF3\xB1\xA3\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x29"],
        ["\xF3\xB1\xA3\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2A"],
        ["\xF3\xB1\xA3\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2B"],
        ["\xF3\xB1\xA3\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2C"],
        ["\xF3\xB1\xA3\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2D"],
        ["\xF3\xB1\xA3\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2E"],
        ["\xF3\xB1\xA3\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x2F"],
        ["\xF3\xB1\xA3\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x30"],
        ["\xF3\xB1\xA3\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x31"],
        ["\xF3\xB1\xA3\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x32"],
        ["\xF3\xB1\xA3\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x33"],
        ["\xF3\xB1\xA3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x34"],
        ["\xF3\xB1\xA3\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x35"],
        ["\xF3\xB1\xA3\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x36"],
        ["\xF3\xB1\xA3\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x37"],
        ["\xF3\xB1\xA3\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x38"],
        ["\xF3\xB1\xA3\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x39"],
        ["\xF3\xB1\xA3\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3A"],
        ["\xF3\xB1\xA3\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3B"],
        ["\xF3\xB1\xA3\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3C"],
        ["\xF3\xB1\xA3\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3D"],
        ["\xF3\xB1\xA3\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3E"],
        ["\xF3\xB1\xA3\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x3F"],
        ["\xF3\xB1\xA3\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x40"],
        ["\xF3\xB1\xA3\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\xF3\xB1\xA3\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\xF3\xB1\xA4\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\xF3\xB1\xA4\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\xF3\xB1\xA4\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\xF3\xB1\xA4\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\xF3\xB1\xA4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\xF3\xB1\xA4\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],
        ["\xF3\xB1\xA4\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\xF3\xB1\xA4\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\xF3\xB1\xA4\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\xF3\xB1\xA4\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\xF3\xB1\xA4\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\xF3\xB1\xA4\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\xF3\xB1\xA4\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\xF3\xB1\xA4\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\xF3\xB1\xA4\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\xF3\xB1\xA4\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\xF3\xB1\xA4\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\xF3\xB1\xA4\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\xF3\xB1\xA4\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\xF3\xB1\xA4\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\xF3\xB1\xA4\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\xF3\xB1\xA4\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\xF3\xB1\xA4\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\xF3\xB1\xA4\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\xF3\xB1\xA4\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\xF3\xB1\xA4\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\xF3\xB1\xA4\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\xF3\xB1\xA4\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\xF3\xB1\xA4\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\xF3\xB1\xA4\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\xF3\xB1\xA4\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\xF3\xB1\xA4\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\xF3\xB1\xA4\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\xF3\xB1\xA4\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\xF3\xB1\xA4\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\xF3\xB1\xA4\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\xF3\xB1\xA4\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\xF3\xB1\xA4\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x5C"],
        ["\xF3\xB1\xA4\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\xF3\xB1\xA4\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\xF3\xB1\xA4\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\xF3\xB1\xA4\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\xF3\xB1\xA4\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\xF3\xB1\xA4\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\xF3\xB1\xA4\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\xF3\xB1\xA4\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\xF3\xB1\xA4\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\xF3\xB1\xA4\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\xF3\xB1\xA4\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\xF3\xB1\xA4\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\xF3\xB1\xA4\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\xF3\xB1\xA4\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\xF3\xB1\xA4\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\xF3\xB1\xA4\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\xF3\xB1\xA4\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\xF3\xB1\xA4\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\xF3\xB1\xA4\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\xF3\xB1\xA4\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\xF3\xB1\xA4\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\xF3\xB1\xA4\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\xF3\xB1\xA4\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x21"],
        ["\xF3\xB1\xA4\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x22"],
        ["\xF3\xB1\xA4\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x23"],
        ["\xF3\xB1\xA4\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x24"],
        ["\xF3\xB1\xA5\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x25"],
        ["\xF3\xB1\xA5\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x26"],
        ["\xF3\xB1\xA5\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x27"],
        ["\xF3\xB1\xA5\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x28"],
        ["\xF3\xB1\xA5\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x29"],
        ["\xF3\xB1\xA5\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2A"],
        ["\xF3\xB1\xA5\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2B"],
        ["\xF3\xB1\xA5\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2C"],
        ["\xF3\xB1\xA5\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2D"],
        ["\xF3\xB1\xA5\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2E"],
        ["\xF3\xB1\xA5\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x2F"],
        ["\xF3\xB1\xA5\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x30"],
        ["\xF3\xB1\xA5\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x31"],
        ["\xF3\xB1\xA5\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x32"],
        ["\xF3\xB1\xA5\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x33"],
        ["\xF3\xB1\xA5\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x34"],
        ["\xF3\xB1\xA5\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x35"],
        ["\xF3\xB1\xA5\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x36"],
        ["\xF3\xB1\xA5\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x37"],
        ["\xF3\xB1\xA5\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x38"],
        ["\xF3\xB1\xA5\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x39"],
        ["\xF3\xB1\xA5\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3A"],
        ["\xF3\xB1\xA5\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3B"],
        ["\xF3\xB1\xA5\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3C"],
        ["\xF3\xB1\xA5\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3D"],
        ["\xF3\xB1\xA5\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3E"],
        ["\xF3\xB1\xA5\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x3F"],
        ["\xF3\xB1\xA5\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x40"],
        ["\xF3\xB1\xA5\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\xF3\xB1\xA5\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\xF3\xB1\xA5\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\xF3\xB1\xA5\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\xF3\xB1\xA5\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\xF3\xB1\xA5\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\xF3\xB1\xA5\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\xF3\xB1\xA5\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\xF3\xB1\xA5\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\xF3\xB1\xA5\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\xF3\xB1\xA5\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\xF3\xB1\xA5\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\xF3\xB1\xA5\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\xF3\xB1\xA5\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\xF3\xB1\xA5\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\xF3\xB1\xA5\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\xF3\xB1\xA5\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\xF3\xB1\xA5\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\xF3\xB1\xA5\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\xF3\xB1\xA5\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\xF3\xB1\xA5\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\xF3\xB1\xA5\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\xF3\xB1\xA5\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\xF3\xB1\xA5\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\xF3\xB1\xA5\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\xF3\xB1\xA5\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\xF3\xB1\xA5\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\xF3\xB1\xA5\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\xF3\xB1\xA5\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\xF3\xB1\xA5\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x76"],
        ["\xF3\xB1\xA5\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\xF3\xB1\xA5\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\xF3\xB1\xA5\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\xF3\xB1\xA5\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\xF3\xB1\xA5\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\xF3\xB1\xA5\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\xF3\xB1\xA6\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\xF3\xB1\xA6\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\xF3\xB1\xA6\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\xF3\xB1\xA6\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\xF3\xB1\xA6\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\xF3\xB1\xA6\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\xF3\xB1\xA6\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\xF3\xB1\xA6\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\xF3\xB1\xA6\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\xF3\xB1\xA6\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\xF3\xB1\xA6\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\xF3\xB1\xA6\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\xF3\xB1\xA6\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\xF3\xB1\xA6\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\xF3\xB1\xA6\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\xF3\xB1\xA6\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\xF3\xB1\xA6\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\xF3\xB1\xA6\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\xF3\xB1\xA6\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\xF3\xB1\xA6\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\xF3\xB1\xA6\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\xF3\xB1\xA6\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\xF3\xB1\xA6\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\xF3\xB1\xA6\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\xF3\xB1\xA6\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\xF3\xB1\xA6\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\xF3\xB1\xA6\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x21"],
        ["\xF3\xB1\xA6\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x22"],
        ["\xF3\xB1\xA6\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x23"],
        ["\xF3\xB1\xA6\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x24"],
        ["\xF3\xB1\xA6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x25"],
        ["\xF3\xB1\xA6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x26"],
        ["\xF3\xB1\xA6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x27"],
        ["\xF3\xB1\xA6\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x28"],
        ["\xF3\xB1\xA6\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x29"],
        ["\xF3\xB1\xA6\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2A"],
        ["\xF3\xB1\xA6\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2B"],
        ["\xF3\xB1\xA6\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2C"],
        ["\xF3\xB1\xA6\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2D"],
        ["\xF3\xB1\xA6\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2E"],
        ["\xF3\xB1\xA6\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x2F"],
        ["\xF3\xB1\xA6\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x30"],
        ["\xF3\xB1\xA6\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x31"],
        ["\xF3\xB1\xA6\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x32"],
        ["\xF3\xB1\xA6\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x33"],
        ["\xF3\xB1\xA6\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x34"],
        ["\xF3\xB1\xA6\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x35"],
        ["\xF3\xB1\xA6\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x36"],
        ["\xF3\xB1\xA6\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x37"],
        ["\xF3\xB1\xA6\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x38"],
        ["\xF3\xB1\xA6\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x39"],
        ["\xF3\xB1\xA6\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3A"],
        ["\xF3\xB1\xA6\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3B"],
        ["\xF3\xB1\xA6\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3C"],
        ["\xF3\xB1\xA6\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3D"],
        ["\xF3\xB1\xA6\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3E"],
        ["\xF3\xB1\xA6\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x3F"],
        ["\xF3\xB1\xA6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x40"],
        ["\xF3\xB1\xA6\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\xF3\xB1\xA6\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\xF3\xB1\xA6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\xF3\xB1\xA6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\xF3\xB1\xA6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x45"],
        ["\xF3\xB1\xA6\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x36"],
        ["\xF3\xB1\xA7\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\xF3\xB1\xA7\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\xF3\xB1\xA7\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\xF3\xB1\xA7\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\xF3\xB1\xA7\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\xF3\xB1\xA7\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\xF3\xB1\xA7\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\xF3\xB1\xA7\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\xF3\xB1\xA7\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\xF3\xB1\xA7\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\xF3\xB1\xA7\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\xF3\xB1\xA7\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\xF3\xB1\xA7\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\xF3\xB1\xA7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\xF3\xB1\xA7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\xF3\xB1\xA7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\xF3\xB1\xA7\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\xF3\xB1\xA7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\xF3\xB1\xA7\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\xF3\xB1\xA7\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\xF3\xB1\xA7\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\xF3\xB1\xA7\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\xF3\xB1\xA7\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\xF3\xB1\xA7\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\xF3\xB1\xA7\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\xF3\xB1\xA7\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\xF3\xB1\xA7\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\xF3\xB1\xA7\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\xF3\xB1\xA7\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\xF3\xB1\xA7\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\xF3\xB1\xA7\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\xF3\xB1\xA7\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\xF3\xB1\xA7\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\xF3\xB1\xA7\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\xF3\xB1\xA7\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\xF3\xB1\xA7\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\xF3\xB1\xA7\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\xF3\xB1\xA7\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\xF3\xB1\xA7\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\xF3\xB1\xA7\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\xF3\xB1\xA7\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\xF3\xB1\xA7\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\xF3\xB1\xA7\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\xF3\xB1\xA7\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\xF3\xB1\xA7\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\xF3\xB1\xA7\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\xF3\xB1\xA7\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\xF3\xB1\xA7\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\xF3\xB1\xA7\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\xF3\xB1\xA7\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\xF3\xB1\xA7\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\xF3\xB1\xA7\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\xF3\xB1\xA7\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\xF3\xB1\xA7\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\xF3\xB1\xA7\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\xF3\xB1\xA7\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\xF3\xB1\xA7\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x21"],
        ["\xF3\xB1\xA7\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x22"],
        ["\xF3\xB1\xA7\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x23"],
        ["\xF3\xB1\xA7\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x24"],
        ["\xF3\xB1\xA7\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x25"],
        ["\xF3\xB1\xA7\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x26"],
        ["\xF3\xB1\xA7\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x27"],
        ["\xF3\xB1\xA7\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x28"],
        ["\xF3\xB1\xA8\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x29"],
        ["\xF3\xB1\xA8\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2A"],
        ["\xF3\xB1\xA8\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2B"],
        ["\xF3\xB1\xA8\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2C"],
        ["\xF3\xB1\xA8\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2D"],
        ["\xF3\xB1\xA8\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2E"],
        ["\xF3\xB1\xA8\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x2F"],
        ["\xF3\xB1\xA8\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x30"],
        ["\xF3\xB1\xA8\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x31"],
        ["\xF3\xB1\xA8\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x32"],
        ["\xF3\xB1\xA8\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x33"],
        ["\xF3\xB1\xA8\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x34"],
        ["\xF3\xB1\xA8\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x35"],
        ["\xF3\xB1\xA8\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x36"],
        ["\xF3\xB1\xA8\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x37"],
        ["\xF3\xB1\xA8\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x38"],
        ["\xF3\xB1\xA8\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x39"],
        ["\xF3\xB1\xA8\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3A"],
        ["\xF3\xB1\xA8\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3B"],
        ["\xF3\xB1\xA8\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3C"],
        ["\xF3\xB1\xA8\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3D"],
        ["\xF3\xB1\xA8\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3E"],
        ["\xF3\xB1\xA8\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x3F"],
        ["\xF3\xB1\xA8\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x40"],
        ["\xF3\xB1\xA8\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\xF3\xB1\xA8\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\xF3\xB1\xA8\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\xF3\xB1\xA8\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\xF3\xB1\xA8\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\xF3\xB1\xA8\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\xF3\xB1\xA8\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\xF3\xB1\xA8\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\xF3\xB1\xA8\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x49"],
        ["\xF3\xB1\xA8\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\xF3\xB1\xA8\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\xF3\xB1\xA8\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\xF3\xB1\xA8\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\xF3\xB1\xA8\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\xF3\xB1\xA8\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\xF3\xB1\xA8\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\xF3\xB1\xA8\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\xF3\xB1\xA8\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\xF3\xB1\xA8\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x53"],
        ["\xF3\xB1\xA8\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\xF3\xB1\xA8\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\xF3\xB1\xA8\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\xF3\xB1\xA8\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\xF3\xB1\xA8\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\xF3\xB1\xA8\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\xF3\xB1\xA8\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\xF3\xB1\xA8\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\xF3\xB1\xA8\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\xF3\xB1\xA8\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\xF3\xB1\xA8\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\xF3\xB1\xA8\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\xF3\xB1\xA8\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\xF3\xB1\xA8\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\xF3\xB1\xA8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\xF3\xB1\xA8\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\xF3\xB1\xA8\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\xF3\xB1\xA8\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\xF3\xB1\xA8\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\xF3\xB1\xA8\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\xF3\xB1\xA8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\xF3\xB1\xA9\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\xF3\xB1\xA9\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\xF3\xB1\xA9\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\xF3\xB1\xA9\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\xF3\xB1\xA9\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\xF3\xB1\xA9\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\xF3\xB1\xA9\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\xF3\xB1\xA9\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\xF3\xB1\xA9\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\xF3\xB1\xA9\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\xF3\xB1\xA9\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\xF3\xB1\xA9\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\xF3\xB1\xA9\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\xF3\xB1\xA9\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\xF3\xB1\xA9\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\xF3\xB1\xA9\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\xF3\xB1\xA9\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\xF3\xB1\xA9\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\xF3\xB1\xA9\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\xF3\xB1\xA9\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\xF3\xB1\xA9\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\xF3\xB1\xA9\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\xF3\xB1\xA9\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x21"],
        ["\xF3\xB1\xA9\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x22"],
        ["\xF3\xB1\xA9\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x23"],
        ["\xF3\xB1\xA9\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x24"],
        ["\xF3\xB1\xA9\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x25"],
        ["\xF3\xB1\xA9\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x26"],
        ["\xF3\xB1\xA9\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x27"],
        ["\xF3\xB1\xA9\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x28"],
        ["\xF3\xB1\xA9\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x29"],
        ["\xF3\xB1\xA9\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2A"],
        ["\xF3\xB1\xA9\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2B"],
        ["\xF3\xB1\xA9\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2C"],
        ["\xF3\xB1\xA9\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2D"],
        ["\xF3\xB1\xA9\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2E"],
        ["\xF3\xB1\xA9\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x2F"],
        ["\xF3\xB1\xA9\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x30"],
        ["\xF3\xB1\xA9\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x31"],
        ["\xF3\xB1\xA9\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x32"],
        ["\xF3\xB1\xA9\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x33"],
        ["\xF3\xB1\xA9\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x34"],
        ["\xF3\xB1\xA9\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x35"],
        ["\xF3\xB1\xA9\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x36"],
        ["\xF3\xB1\xA9\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x37"],
        ["\xF3\xB1\xA9\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x38"],
        ["\xF3\xB1\xA9\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x39"],
        ["\xF3\xB1\xA9\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3A"],
        ["\xF3\xB1\xA9\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3B"],
        ["\xF3\xB1\xA9\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3C"],
        ["\xF3\xB1\xA9\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3D"],
        ["\xF3\xB1\xA9\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3E"],
        ["\xF3\xB1\xA9\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x3F"],
        ["\xF3\xB1\xA9\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x40"],
        ["\xF3\xB1\xA9\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\xF3\xB1\xA9\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\xF3\xB1\xA9\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\xF3\xB1\xA9\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\xF3\xB1\xA9\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\xF3\xB1\xA9\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\xF3\xB1\xA9\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\xF3\xB1\xA9\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\xF3\xB1\xA9\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\xF3\xB1\xA9\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\xF3\xB1\xAA\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\xF3\xB1\xAA\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\xF3\xB1\xAA\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\xF3\xB1\xAA\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\xF3\xB1\xAA\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\xF3\xB1\xAA\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\xF3\xB1\xAA\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\xF3\xB1\xAA\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\xF3\xB1\xAA\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\xF3\xB1\xAA\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\xF3\xB1\xAA\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\xF3\xB1\xAA\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\xF3\xB1\xAA\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\xF3\xB1\xAA\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\xF3\xB1\xAA\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\xF3\xB1\xAA\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\xF3\xB1\xAA\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\xF3\xB1\xAA\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\xF3\xB1\xAA\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\xF3\xB1\xAA\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\xF3\xB1\xAA\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\xF3\xB1\xAA\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\xF3\xB1\xAA\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\xF3\xB1\xAA\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\xF3\xB1\xAA\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\xF3\xB1\xAA\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\xF3\xB1\xAA\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\xF3\xB1\xAA\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\xF3\xB1\xAA\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\xF3\xB1\xAA\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\xF3\xB1\xAA\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\xF3\xB1\xAA\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\xF3\xB1\xAA\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\xF3\xB1\xAA\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\xF3\xB1\xAA\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\xF3\xB1\xAA\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\xF3\xB1\xAA\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\xF3\xB1\xAA\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\xF3\xB1\xAA\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\xF3\xB1\xAA\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\xF3\xB1\xAA\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\xF3\xB1\xAA\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\xF3\xB1\xAA\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\xF3\xB1\xAA\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\xF3\xB1\xAA\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\xF3\xB1\xAA\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\xF3\xB1\xAA\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\xF3\xB1\xAA\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\xF3\xB1\xAA\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\xF3\xB1\xAA\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\xF3\xB1\xAA\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\xF3\xB1\xAA\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\xF3\xB1\xAA\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x21"],
        ["\xF3\xB1\xAA\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x22"],
        ["\xF3\xB1\xAA\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x23"],
        ["\xF3\xB1\xAA\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x24"],
        ["\xF3\xB1\xAA\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x25"],
        ["\xF3\xB1\xAA\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x26"],
        ["\xF3\xB1\xAA\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x27"],
        ["\xF3\xB1\xAA\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x28"],
        ["\xF3\xB1\xAA\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x29"],
        ["\xF3\xB1\xAA\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2A"],
        ["\xF3\xB1\xAA\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2B"],
        ["\xF3\xB1\xAA\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2C"],
        ["\xF3\xB1\xAB\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2D"],
        ["\xF3\xB1\xAB\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2E"],
        ["\xF3\xB1\xAB\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x2F"],
        ["\xF3\xB1\xAB\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x30"],
        ["\xF3\xB1\xAB\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x31"],
        ["\xF3\xB1\xAB\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x32"],
        ["\xF3\xB1\xAB\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x33"],
        ["\xF3\xB1\xAB\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x34"],
        ["\xF3\xB1\xAB\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x35"],
        ["\xF3\xB1\xAB\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x36"],
        ["\xF3\xB1\xAB\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x37"],
        ["\xF3\xB1\xAB\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x38"],
        ["\xF3\xB1\xAB\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x39"],
        ["\xF3\xB1\xAB\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3A"],
        ["\xF3\xB1\xAB\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3B"],
        ["\xF3\xB1\xAB\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3C"],
        ["\xF3\xB1\xAB\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3D"],
        ["\xF3\xB1\xAB\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3E"],
        ["\xF3\xB1\xAB\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x3F"],
        ["\xF3\xB1\xAB\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x40"],
        ["\xF3\xB1\xAB\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\xF3\xB1\xAB\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\xF3\xB1\xAB\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\xF3\xB1\xAB\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],
        ["\xF3\xB1\xAB\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],
        ["\xF3\xB1\xAB\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],
        ["\xF3\xB1\xAB\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],
        ["\xF3\xB1\xAB\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],
        ["\xF3\xB1\xAB\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],
        ["\xF3\xB1\xAB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\xF3\xB1\xAB\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\xF3\xB1\xAB\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\xF3\xB1\xAB\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\xF3\xB1\xAB\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\xF3\xB1\xAB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\xF3\xB1\xAB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\xF3\xB1\xAB\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],
        ["\xF3\xB1\xAB\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],
        ["\xF3\xB1\xAB\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],
        ["\xF3\xB1\xAB\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],
        ["\xF3\xB1\xAB\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],
        ["\xF3\xB1\xAB\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],
        ["\xF3\xB1\xAB\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\xF3\xB1\xAB\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],
        ["\xF3\xB1\xAB\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\xF3\xB1\xAB\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\xF3\xB1\xAB\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\xF3\xB1\xAB\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\xF3\xB1\xAB\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\xF3\xB1\xAB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\xF3\xB1\xAB\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\xF3\xB1\xAB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\xF3\xB1\xAB\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\xF3\xB1\xAB\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\xF3\xB1\xAB\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\xF3\xB1\xAB\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\xF3\xB1\xAB\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\xF3\xB1\xAB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\xF3\xB1\xAB\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\xF3\xB1\xAB\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\xF3\xB1\xAB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\xF3\xB1\xAB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\xF3\xB1\xAB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\xF3\xB1\xAB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\xF3\xB1\xAC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\xF3\xB1\xAC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\xF3\xB1\xAC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\xF3\xB1\xAC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\xF3\xB1\xAC\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\xF3\xB1\xAC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\xF3\xB1\xAC\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\xF3\xB1\xAC\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\xF3\xB1\xAC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\xF3\xB1\xAC\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\xF3\xB1\xAC\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\xF3\xB1\xAC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\xF3\xB1\xAC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\xF3\xB1\xAC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\xF3\xB1\xAC\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\xF3\xB1\xAC\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\xF3\xB1\xAC\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\xF3\xB1\xAC\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\xF3\xB1\xAC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x21"],
        ["\xF3\xB1\xAC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x22"],
        ["\xF3\xB1\xAC\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x23"],
        ["\xF3\xB1\xAC\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x24"],
        ["\xF3\xB1\xAC\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x25"],
        ["\xF3\xB1\xAC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x26"],
        ["\xF3\xB1\xAC\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x27"],
        ["\xF3\xB1\xAC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x28"],
        ["\xF3\xB1\xAC\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x29"],
        ["\xF3\xB1\xAC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2A"],
        ["\xF3\xB1\xAC\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2B"],
        ["\xF3\xB1\xAC\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2C"],
        ["\xF3\xB1\xAC\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2D"],
        ["\xF3\xB1\xAC\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2E"],
        ["\xF3\xB1\xAC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x2F"],
        ["\xF3\xB1\xAC\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x30"],
        ["\xF3\xB1\xAC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x31"],
        ["\xF3\xB1\xAC\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x32"],
        ["\xF3\xB1\xAC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x33"],
        ["\xF3\xB1\xAC\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x34"],
        ["\xF3\xB1\xAC\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x35"],
        ["\xF3\xB1\xAC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x36"],
        ["\xF3\xB1\xAC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x37"],
        ["\xF3\xB1\xAC\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x38"],
        ["\xF3\xB1\xAC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x39"],
        ["\xF3\xB1\xAC\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3A"],
        ["\xF3\xB1\xAC\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3B"],
        ["\xF3\xB1\xAC\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3C"],
        ["\xF3\xB1\xAC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3D"],
        ["\xF3\xB1\xAC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3E"],
        ["\xF3\xB1\xAC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x3F"],
        ["\xF3\xB1\xAC\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x40"],
        ["\xF3\xB1\xAC\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],
        ["\xF3\xB1\xAC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],
        ["\xF3\xB1\xAC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],
        ["\xF3\xB1\xAC\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],
        ["\xF3\xB1\xAC\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],
        ["\xF3\xB1\xAC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],
        ["\xF3\xB1\xAC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],
        ["\xF3\xB1\xAC\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],
        ["\xF3\xB1\xAC\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],
        ["\xF3\xB1\xAC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\xF3\xB1\xAC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\xF3\xB1\xAC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\xF3\xB1\xAC\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\xF3\xB1\xAC\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\xF3\xB1\xAD\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\xF3\xB1\xAD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\xF3\xB1\xAD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\xF3\xB1\xAD\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],
        ["\xF3\xB1\xAD\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],
        ["\xF3\xB1\xAD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],
        ["\xF3\xB1\xAD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],
        ["\xF3\xB1\xAD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],
        ["\xF3\xB1\xAD\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\xF3\xB1\xAD\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],
        ["\xF3\xB1\xAD\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\xF3\xB1\xAD\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\xF3\xB1\xAD\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\xF3\xB1\xAD\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\xF3\xB1\xAD\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\xF3\xB1\xAD\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\xF3\xB1\xAD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\xF3\xB1\xAD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\xF3\xB1\xAD\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\xF3\xB1\xAD\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\xF3\xB1\xAD\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\xF3\xB1\xAD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\xF3\xB1\xAD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\xF3\xB1\xAD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\xF3\xB1\xAD\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\xF3\xB1\xAD\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\xF3\xB1\xAD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\xF3\xB1\xAD\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\xF3\xB1\xAD\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\xF3\xB1\xAD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\xF3\xB1\xAD\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\xF3\xB1\xAD\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\xF3\xB1\xAD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\xF3\xB1\xAD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\xF3\xB1\xAD\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\xF3\xB1\xAD\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\xF3\xB1\xAD\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\xF3\xB1\xAD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\xF3\xB1\xAD\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\xF3\xB1\xAD\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\xF3\xB1\xAD\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\xF3\xB1\xAD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\xF3\xB1\xAD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\xF3\xB1\xAD\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\xF3\xB1\xAD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\xF3\xB1\xAD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\xF3\xB1\xAD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\xF3\xB1\xAD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\xF3\xB1\xAD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x21"],
        ["\xF3\xB1\xAD\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C\x49"],
        ["\xF3\xB1\xAD\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x23"],
        ["\xF3\xB1\xAD\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x24"],
        ["\xF3\xB1\xAD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x25"],
        ["\xF3\xB1\xAD\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x26"],
        ["\xF3\xB1\xAD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x27"],
        ["\xF3\xB1\xAD\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x28"],
        ["\xF3\xB1\xAD\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x29"],
        ["\xF3\xB1\xAD\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2A"],
        ["\xF3\xB1\xAD\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2B"],
        ["\xF3\xB1\xAD\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2C"],
        ["\xF3\xB1\xAD\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2D"],
        ["\xF3\xB1\xAD\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\xF3\xB1\xAD\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x2F"],
        ["\xF3\xB1\xAD\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x30"],
        ["\xF3\xB1\xAE\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x31"],
        ["\xF3\xB1\xAE\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x32"],
        ["\xF3\xB1\xAE\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x33"],
        ["\xF3\xB1\xAE\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x34"],
        ["\xF3\xB1\xAE\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x35"],
        ["\xF3\xB1\xAE\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x36"],
        ["\xF3\xB1\xAE\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x37"],
        ["\xF3\xB1\xAE\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x38"],
        ["\xF3\xB1\xAE\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x39"],
        ["\xF3\xB1\xAE\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3A"],
        ["\xF3\xB1\xAE\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3B"],
        ["\xF3\xB1\xAE\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3C"],
        ["\xF3\xB1\xAE\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3D"],
        ["\xF3\xB1\xAE\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3E"],
        ["\xF3\xB1\xAE\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x3F"],
        ["\xF3\xB1\xAE\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x40"],
        ["\xF3\xB1\xAE\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x41"],
        ["\xF3\xB1\xAE\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x42"],
        ["\xF3\xB1\xAE\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x43"],
        ["\xF3\xB1\xAE\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x44"],
        ["\xF3\xB1\xAE\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x45"],
        ["\xF3\xB1\xAE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x46"],
        ["\xF3\xB1\xAE\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x47"],
        ["\xF3\xB1\xAE\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x48"],
        ["\xF3\xB1\xAE\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x49"],
        ["\xF3\xB1\xAE\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],
        ["\xF3\xB1\xAE\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],
        ["\xF3\xB1\xAE\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],
        ["\xF3\xB1\xAE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],
        ["\xF3\xB1\xAE\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],
        ["\xF3\xB1\xAE\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],
        ["\xF3\xB1\xAE\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],
        ["\xF3\xB1\xAE\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x51"],
        ["\xF3\xB1\xAE\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x52"],
        ["\xF3\xB1\xAE\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x53"],
        ["\xF3\xB1\xAE\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x54"],
        ["\xF3\xB1\xAE\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x55"],
        ["\xF3\xB1\xAE\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x56"],
        ["\xF3\xB1\xAE\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],
        ["\xF3\xB1\xAE\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x58"],
        ["\xF3\xB1\xAE\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],
        ["\xF3\xB1\xAE\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33\x42"],
        ["\xF3\xB1\xAE\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],
        ["\xF3\xB1\xAE\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],
        ["\xF3\xB1\xAE\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],
        ["\xF3\xB1\xAE\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],
        ["\xF3\xB1\xAE\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],
        ["\xF3\xB1\xAE\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],
        ["\xF3\xB1\xAE\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],
        ["\xF3\xB1\xAE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],
        ["\xF3\xB1\xAE\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],
        ["\xF3\xB1\xAE\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],
        ["\xF3\xB1\xAE\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],
        ["\xF3\xB1\xAE\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],
        ["\xF3\xB1\xAE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],
        ["\xF3\xB1\xAE\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],
        ["\xF3\xB1\xAE\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],
        ["\xF3\xB1\xAE\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],
        ["\xF3\xB1\xAE\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],
        ["\xF3\xB1\xAE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],
        ["\xF3\xB1\xAE\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],
        ["\xF3\xB1\xAE\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],
        ["\xF3\xB1\xAE\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],
        ["\xF3\xB1\xAE\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],
        ["\xF3\xB1\xAF\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],
        ["\xF3\xB1\xAF\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],
        ["\xF3\xB1\xAF\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],
        ["\xF3\xB1\xAF\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],
        ["\xF3\xB1\xAF\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],
        ["\xF3\xB1\xAF\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],
        ["\xF3\xB1\xAF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],
        ["\xF3\xB1\xAF\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],
        ["\xF3\xB1\xAF\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],
        ["\xF3\xB1\xAF\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],
        ["\xF3\xB1\xAF\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],
        ["\xF3\xB1\xAF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],
        ["\xF3\xB1\xAF\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],
        ["\xF3\xB1\xAF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],
        ["\xF3\xB1\xAF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x21"],
        ["\xF3\xB1\xAF\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x22"],
        ["\xF3\xB1\xAF\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x23"],
        ["\xF3\xB1\xAF\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\xF3\xB1\xAF\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x25"],
        ["\xF3\xB1\xAF\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x26"],
        ["\xF3\xB1\xAF\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x27"],
        ["\xF3\xB1\xAF\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x28"],
        ["\xF3\xB1\xAF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x29"],
        ["\xF3\xB1\xAF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2A"],
        ["\xF3\xB1\xAF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2B"],
        ["\xF3\xB1\xAF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2C"],
        ["\xF3\xB1\xAF\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2D"],
        ["\xF3\xB1\xAF\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2E"],
        ["\xF3\xB1\xAF\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x2F"],
        ["\xF3\xB1\xAF\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x30"],
        ["\xF3\xB1\xAF\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x31"],
        ["\xF3\xB1\xAF\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x32"],
        ["\xF3\xB1\xAF\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x33"],
        ["\xF3\xB1\xAF\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x34"],
        ["\xF3\xB1\xAF\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x35"],
        ["\xF3\xB1\xAF\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x36"],
        ["\xF3\xB1\xAF\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x37"],
        ["\xF3\xB1\xAF\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x38"],
        ["\xF3\xB1\xAF\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x39"],
        ["\xF3\xB1\xAF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3A"],
        ["\xF3\xB1\xAF\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3B"],
        ["\xF3\xB1\xAF\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3C"],
        ["\xF3\xB1\xAF\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3D"],
        ["\xF3\xB1\xAF\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3E"],
        ["\xF3\xB1\xAF\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x3F"],
        ["\xF3\xB1\xAF\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x40"],
        ["\xF3\xB1\xAF\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x41"],
        ["\xF3\xB1\xAF\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x42"],
        ["\xF3\xB1\xAF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x43"],
        ["\xF3\xB1\xAF\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x44"],
        ["\xF3\xB1\xAF\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x45"],
        ["\xF3\xB1\xAF\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x46"],
        ["\xF3\xB1\xAF\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x47"],
        ["\xF3\xB1\xAF\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x48"],
        ["\xF3\xB1\xAF\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x49"],
        ["\xF3\xB1\xAF\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4A"],
        ["\xF3\xB1\xAF\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4B"],
        ["\xF3\xB1\xAF\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4C"],
        ["\xF3\xB1\xAF\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4D"],
        ["\xF3\xB1\xAF\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4E"],
        ["\xF3\xB1\xAF\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x4F"],
        ["\xF3\xB1\xAF\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x50"],
        ["\xF3\xB1\xAF\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x51"],
        ["\xF3\xB1\xAF\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x52"],
        ["\xF3\xB1\xB0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x53"],
        ["\xF3\xB1\xB0\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x54"],
        ["\xF3\xB1\xB0\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x55"],
        ["\xF3\xB1\xB0\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x56"],
        ["\xF3\xB1\xB0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x57"],
        ["\xF3\xB1\xB0\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x58"],
        ["\xF3\xB1\xB0\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x59"],
        ["\xF3\xB1\xB0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5A"],
        ["\xF3\xB1\xB0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5B"],
        ["\xF3\xB1\xB0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5C"],
        ["\xF3\xB1\xB0\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5D"],
        ["\xF3\xB1\xB0\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5E"],
        ["\xF3\xB1\xB0\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x5F"],
        ["\xF3\xB1\xB0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x60"],
        ["\xF3\xB1\xB0\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x61"],
        ["\xF3\xB1\xB0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x62"],
        ["\xF3\xB1\xB0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x63"],
        ["\xF3\xB1\xB0\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x64"],
        ["\xF3\xB1\xB0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x65"],
        ["\xF3\xB1\xB0\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x66"],
        ["\xF3\xB1\xB0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x67"],
        ["\xF3\xB1\xB0\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x68"],
        ["\xF3\xB1\xB0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x69"],
        ["\xF3\xB1\xB0\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6A"],
        ["\xF3\xB1\xB0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6B"],
        ["\xF3\xB1\xB0\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6C"],
        ["\xF3\xB1\xB0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6D"],
        ["\xF3\xB1\xB0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6E"],
        ["\xF3\xB1\xB0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x6F"],
        ["\xF3\xB1\xB0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x70"],
        ["\xF3\xB1\xB0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x71"],
        ["\xF3\xB1\xB0\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x72"],
        ["\xF3\xB1\xB0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x73"],
        ["\xF3\xB1\xB0\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x74"],
        ["\xF3\xB1\xB0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x75"],
        ["\xF3\xB1\xB0\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x76"],
        ["\xF3\xB1\xB0\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x77"],
        ["\xF3\xB1\xB0\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x78"],
        ["\xF3\xB1\xB0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x79"],
        ["\xF3\xB1\xB0\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x7A"],
        ["\xF3\xB1\xB0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x7B"],
        ["\xF3\xB1\xB0\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x7C"],
        ["\xF3\xB1\xB0\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x7D"],
        ["\xF3\xB1\xB0\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A\x7E"],
        ["\xF3\xB1\xB0\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x21"],
        ["\xF3\xB1\xB0\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x22"],
        ["\xF3\xB1\xB0\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x23"],
        ["\xF3\xB1\xB0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x24"],
        ["\xF3\xB1\xB0\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x25"],
        ["\xF3\xB1\xB0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x26"],
        ["\xF3\xB1\xB0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x27"],
        ["\xF3\xB1\xB0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x28"],
        ["\xF3\xB1\xB0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x29"],
        ["\xF3\xB1\xB0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2A"],
        ["\xF3\xB1\xB0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2B"],
        ["\xF3\xB1\xB0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2C"],
        ["\xF3\xB1\xB0\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2D"],
        ["\xF3\xB1\xB0\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2E"],
        ["\xF3\xB1\xB0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x2F"],
        ["\xF3\xB1\xB0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x30"],
        ["\xF3\xB1\xB0\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x31"],
        ["\xF3\xB1\xB0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x32"],
        ["\xF3\xB1\xB0\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x33"],
        ["\xF3\xB1\xB0\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x34"],
        ["\xF3\xB1\xB1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x35"],
        ["\xF3\xB1\xB1\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x36"],
        ["\xF3\xB1\xB1\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x37"],
        ["\xF3\xB1\xB1\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x38"],
        ["\xF3\xB1\xB1\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x39"],
        ["\xF3\xB1\xB1\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3A"],
        ["\xF3\xB1\xB1\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3B"],
        ["\xF3\xB1\xB1\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3C"],
        ["\xF3\xB1\xB1\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3D"],
        ["\xF3\xB1\xB1\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3E"],
        ["\xF3\xB1\xB1\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x3F"],
        ["\xF3\xB1\xB1\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x40"],
        ["\xF3\xB1\xB1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x41"],
        ["\xF3\xB1\xB1\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x42"],
        ["\xF3\xB1\xB1\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x43"],
        ["\xF3\xB1\xB1\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x44"],
        ["\xF3\xB1\xB1\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x45"],
        ["\xF3\xB1\xB1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x46"],
        ["\xF3\xB1\xB1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x47"],
        ["\xF3\xB1\xB1\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x48"],
        ["\xF3\xB1\xB1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x49"],
        ["\xF3\xB1\xB1\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],
        ["\xF3\xB1\xB1\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4B"],
        ["\xF3\xB1\xB1\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],
        ["\xF3\xB1\xB1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4D"],
        ["\xF3\xB1\xB1\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4E"],
        ["\xF3\xB1\xB1\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4F"],
        ["\xF3\xB1\xB1\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],
        ["\xF3\xB1\xB1\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x51"],
        ["\xF3\xB1\xB1\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x52"],
        ["\xF3\xB1\xB1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x53"],
        ["\xF3\xB1\xB1\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x54"],
        ["\xF3\xB1\xB1\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x55"],
        ["\xF3\xB1\xB1\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x56"],
        ["\xF3\xB1\xB1\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x57"],
        ["\xF3\xB1\xB1\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x58"],
        ["\xF3\xB1\xB1\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x59"],
        ["\xF3\xB1\xB1\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5A"],
        ["\xF3\xB1\xB1\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],
        ["\xF3\xB1\xB1\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5C"],
        ["\xF3\xB1\xB1\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34\x52"],
        ["\xF3\xB1\xB1\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],
        ["\xF3\xB1\xB1\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5F"],
        ["\xF3\xB1\xB1\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x60"],
        ["\xF3\xB1\xB1\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x61"],
        ["\xF3\xB1\xB1\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],
        ["\xF3\xB1\xB1\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x63"],
        ["\xF3\xB1\xB1\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x64"],
        ["\xF3\xB1\xB1\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],
        ["\xF3\xB1\xB1\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x66"],
        ["\xF3\xB1\xB1\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x67"],
        ["\xF3\xB1\xB1\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x68"],
        ["\xF3\xB1\xB1\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x69"],
        ["\xF3\xB1\xB1\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6A"],
        ["\xF3\xB1\xB1\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6B"],
        ["\xF3\xB1\xB1\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],
        ["\xF3\xB1\xB1\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],
        ["\xF3\xB1\xB1\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6E"],
        ["\xF3\xB1\xB1\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],
        ["\xF3\xB1\xB1\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x70"],
        ["\xF3\xB1\xB1\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x71"],
        ["\xF3\xB1\xB1\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x72"],
        ["\xF3\xB1\xB1\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x73"],
        ["\xF3\xB1\xB1\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],
        ["\xF3\xB1\xB2\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x75"],
        ["\xF3\xB1\xB2\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x76"],
        ["\xF3\xB1\xB2\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x77"],
        ["\xF3\xB1\xB2\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x78"],
        ["\xF3\xB1\xB2\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],
        ["\xF3\xB1\xB2\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7A"],
        ["\xF3\xB1\xB2\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7B"],
        ["\xF3\xB1\xB2\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],
        ["\xF3\xB1\xB2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],
        ["\xF3\xB1\xB2\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7E"],
        ["\xF3\xB1\xB2\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x21"],
        ["\xF3\xB1\xB2\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x22"],
        ["\xF3\xB1\xB2\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x23"],
        ["\xF3\xB1\xB2\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x24"],
        ["\xF3\xB1\xB2\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x25"],
        ["\xF3\xB1\xB2\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x26"],
        ["\xF3\xB1\xB2\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x27"],
        ["\xF3\xB1\xB2\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x28"],
        ["\xF3\xB1\xB2\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x29"],
        ["\xF3\xB1\xB2\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2A"],
        ["\xF3\xB1\xB2\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2B"],
        ["\xF3\xB1\xB2\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2C"],
        ["\xF3\xB1\xB2\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2D"],
        ["\xF3\xB1\xB2\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2E"],
        ["\xF3\xB1\xB2\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x2F"],
        ["\xF3\xB1\xB2\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x30"],
        ["\xF3\xB1\xB2\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x31"],
        ["\xF3\xB1\xB2\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x32"],
        ["\xF3\xB1\xB2\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x33"],
        ["\xF3\xB1\xB2\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x34"],
        ["\xF3\xB1\xB2\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x35"],
        ["\xF3\xB1\xB2\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x36"],
        ["\xF3\xB1\xB2\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x37"],
        ["\xF3\xB1\xB2\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x38"],
        ["\xF3\xB1\xB2\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x39"],
        ["\xF3\xB1\xB2\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3A"],
        ["\xF3\xB1\xB2\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3B"],
        ["\xF3\xB1\xB2\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3C"],
        ["\xF3\xB1\xB2\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3D"],
        ["\xF3\xB1\xB2\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3E"],
        ["\xF3\xB1\xB2\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x3F"],
        ["\xF3\xB1\xB2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x40"],
        ["\xF3\xB1\xB2\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x41"],
        ["\xF3\xB1\xB2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x42"],
        ["\xF3\xB1\xB2\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x43"],
        ["\xF3\xB1\xB2\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x44"],
        ["\xF3\xB1\xB2\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x45"],
        ["\xF3\xB1\xB2\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x46"],
        ["\xF3\xB1\xB2\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x47"],
        ["\xF3\xB1\xB2\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x48"],
        ["\xF3\xB1\xB2\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x49"],
        ["\xF3\xB1\xB2\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],
        ["\xF3\xB1\xB2\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],
        ["\xF3\xB1\xB2\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],
        ["\xF3\xB1\xB2\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\x28"],
        ["\xF3\xB1\xB2\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],
        ["\xF3\xB1\xB2\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],
        ["\xF3\xB1\xB2\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],
        ["\xF3\xB1\xB2\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x51"],
        ["\xF3\xB1\xB2\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x52"],
        ["\xF3\xB1\xB2\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x53"],
        ["\xF3\xB1\xB2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x54"],
        ["\xF3\xB1\xB2\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x55"],
        ["\xF3\xB1\xB2\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x56"],
        ["\xF3\xB1\xB3\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],
        ["\xF3\xB1\xB3\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x58"],
        ["\xF3\xB1\xB3\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],
        ["\xF3\xB1\xB3\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],
        ["\xF3\xB1\xB3\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],
        ["\xF3\xB1\xB3\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],
        ["\xF3\xB1\xB3\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],
        ["\xF3\xB1\xB3\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],
        ["\xF3\xB1\xB3\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],
        ["\xF3\xB1\xB3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],
        ["\xF3\xB1\xB3\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],
        ["\xF3\xB1\xB3\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],
        ["\xF3\xB1\xB3\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],
        ["\xF3\xB1\xB3\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],
        ["\xF3\xB1\xB3\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],
        ["\xF3\xB1\xB3\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],
        ["\xF3\xB1\xB3\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],
        ["\xF3\xB1\xB3\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],
        ["\xF3\xB1\xB3\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],
        ["\xF3\xB1\xB3\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6A"],
        ["\xF3\xB1\xB3\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],
        ["\xF3\xB1\xB3\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],
        ["\xF3\xB1\xB3\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],
        ["\xF3\xB1\xB3\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],
        ["\xF3\xB1\xB3\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],
        ["\xF3\xB1\xB3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],
        ["\xF3\xB1\xB3\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],
        ["\xF3\xB1\xB3\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],
        ["\xF3\xB1\xB3\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],
        ["\xF3\xB1\xB3\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],
        ["\xF3\xB1\xB3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],
        ["\xF3\xB1\xB3\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],
        ["\xF3\xB1\xB3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],
        ["\xF3\xB1\xB3\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],
        ["\xF3\xB1\xB3\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],
        ["\xF3\xB1\xB3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],
        ["\xF3\xB1\xB3\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],
        ["\xF3\xB1\xB3\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],
        ["\xF3\xB1\xB3\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],
        ["\xF3\xB1\xB3\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],
        ["\xF3\xB1\xB3\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x21"],
        ["\xF3\xB1\xB3\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x22"],
        ["\xF3\xB1\xB3\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x23"],
        ["\xF3\xB1\xB3\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x24"],
        ["\xF3\xB1\xB3\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x25"],
        ["\xF3\xB1\xB3\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x26"],
        ["\xF3\xB1\xB3\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x27"],
        ["\xF3\xB1\xB3\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x28"],
        ["\xF3\xB1\xB3\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x29"],
        ["\xF3\xB1\xB3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2A"],
        ["\xF3\xB1\xB3\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2B"],
        ["\xF3\xB1\xB3\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2C"],
        ["\xF3\xB1\xB3\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2D"],
        ["\xF3\xB1\xB3\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2E"],
        ["\xF3\xB1\xB3\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x2F"],
        ["\xF3\xB1\xB3\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x30"],
        ["\xF3\xB1\xB3\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x31"],
        ["\xF3\xB1\xB3\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x32"],
        ["\xF3\xB1\xB3\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x33"],
        ["\xF3\xB1\xB3\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x34"],
        ["\xF3\xB1\xB3\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x35"],
        ["\xF3\xB1\xB3\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x36"],
        ["\xF3\xB1\xB3\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x37"],
        ["\xF3\xB1\xB3\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x38"],
        ["\xF3\xB1\xB4\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x39"],
        ["\xF3\xB1\xB4\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3A"],
        ["\xF3\xB1\xB4\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3B"],
        ["\xF3\xB1\xB4\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3C"],
        ["\xF3\xB1\xB4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3D"],
        ["\xF3\xB1\xB4\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3E"],
        ["\xF3\xB1\xB4\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x3F"],
        ["\xF3\xB1\xB4\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x40"],
        ["\xF3\xB1\xB4\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x41"],
        ["\xF3\xB1\xB4\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x42"],
        ["\xF3\xB1\xB4\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x43"],
        ["\xF3\xB1\xB4\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x44"],
        ["\xF3\xB1\xB4\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x45"],
        ["\xF3\xB1\xB4\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x46"],
        ["\xF3\xB1\xB4\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x47"],
        ["\xF3\xB1\xB4\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x48"],
        ["\xF3\xB1\xB4\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x49"],
        ["\xF3\xB1\xB4\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],
        ["\xF3\xB1\xB4\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],
        ["\xF3\xB1\xB4\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],
        ["\xF3\xB1\xB4\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],
        ["\xF3\xB1\xB4\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],
        ["\xF3\xB1\xB4\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],
        ["\xF3\xB1\xB4\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],
        ["\xF3\xB1\xB4\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x51"],
        ["\xF3\xB1\xB4\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x52"],
        ["\xF3\xB1\xB4\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x53"],
        ["\xF3\xB1\xB4\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x54"],
        ["\xF3\xB1\xB4\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x55"],
        ["\xF3\xB1\xB4\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x56"],
        ["\xF3\xB1\xB4\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],
        ["\xF3\xB1\xB4\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x58"],
        ["\xF3\xB1\xB4\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],
        ["\xF3\xB1\xB4\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],
        ["\xF3\xB1\xB4\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],
        ["\xF3\xB1\xB4\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],
        ["\xF3\xB1\xB4\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],
        ["\xF3\xB1\xB4\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],
        ["\xF3\xB1\xB4\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],
        ["\xF3\xB1\xB4\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],
        ["\xF3\xB1\xB4\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],
        ["\xF3\xB1\xB4\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],
        ["\xF3\xB1\xB4\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],
        ["\xF3\xB1\xB4\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],
        ["\xF3\xB1\xB4\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],
        ["\xF3\xB1\xB4\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],
        ["\xF3\xB1\xB4\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],
        ["\xF3\xB1\xB4\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],
        ["\xF3\xB1\xB4\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],
        ["\xF3\xB1\xB4\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],
        ["\xF3\xB1\xB4\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],
        ["\xF3\xB1\xB4\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],
        ["\xF3\xB1\xB4\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],
        ["\xF3\xB1\xB4\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\xF3\xB1\xB4\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],
        ["\xF3\xB1\xB4\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],
        ["\xF3\xB1\xB4\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],
        ["\xF3\xB1\xB4\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],
        ["\xF3\xB1\xB4\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],
        ["\xF3\xB1\xB4\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],
        ["\xF3\xB1\xB4\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],
        ["\xF3\xB1\xB4\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],
        ["\xF3\xB1\xB4\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],
        ["\xF3\xB1\xB4\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],
        ["\xF3\xB1\xB5\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],
        ["\xF3\xB1\xB5\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],
        ["\xF3\xB1\xB5\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],
        ["\xF3\xB1\xB5\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],
        ["\xF3\xB1\xB5\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],
        ["\xF3\xB1\xB5\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],
        ["\xF3\xB1\xB5\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x21"],
        ["\xF3\xB1\xB5\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x22"],
        ["\xF3\xB1\xB5\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x23"],
        ["\xF3\xB1\xB5\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x24"],
        ["\xF3\xB1\xB5\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x25"],
        ["\xF3\xB1\xB5\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x26"],
        ["\xF3\xB1\xB5\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x27"],
        ["\xF3\xB1\xB5\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x28"],
        ["\xF3\xB1\xB5\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x29"],
        ["\xF3\xB1\xB5\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2A"],
        ["\xF3\xB1\xB5\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2B"],
        ["\xF3\xB1\xB5\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2C"],
        ["\xF3\xB1\xB5\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2D"],
        ["\xF3\xB1\xB5\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2E"],
        ["\xF3\xB1\xB5\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x2F"],
        ["\xF3\xB1\xB5\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x30"],
        ["\xF3\xB1\xB5\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x31"],
        ["\xF3\xB1\xB5\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x32"],
        ["\xF3\xB1\xB5\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x33"],
        ["\xF3\xB1\xB5\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x34"],
        ["\xF3\xB1\xB5\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x35"],
        ["\xF3\xB1\xB5\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x36"],
        ["\xF3\xB1\xB5\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x37"],
        ["\xF3\xB1\xB5\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x38"],
        ["\xF3\xB1\xB5\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x39"],
        ["\xF3\xB1\xB5\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3A"],
        ["\xF3\xB1\xB5\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3B"],
        ["\xF3\xB1\xB5\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3C"],
        ["\xF3\xB1\xB5\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3D"],
        ["\xF3\xB1\xB5\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3E"],
        ["\xF3\xB1\xB5\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x3F"],
        ["\xF3\xB1\xB5\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x40"],
        ["\xF3\xB1\xB5\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x41"],
        ["\xF3\xB1\xB5\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x42"],
        ["\xF3\xB1\xB5\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x43"],
        ["\xF3\xB1\xB5\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x44"],
        ["\xF3\xB1\xB5\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x45"],
        ["\xF3\xB1\xB5\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x46"],
        ["\xF3\xB1\xB5\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x47"],
        ["\xF3\xB1\xB5\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x48"],
        ["\xF3\xB1\xB5\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x49"],
        ["\xF3\xB1\xB5\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],
        ["\xF3\xB1\xB5\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],
        ["\xF3\xB1\xB5\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],
        ["\xF3\xB1\xB5\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],
        ["\xF3\xB1\xB5\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],
        ["\xF3\xB1\xB5\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],
        ["\xF3\xB1\xB5\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],
        ["\xF3\xB1\xB5\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x51"],
        ["\xF3\xB1\xB5\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x52"],
        ["\xF3\xB1\xB5\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x53"],
        ["\xF3\xB1\xB5\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x54"],
        ["\xF3\xB1\xB5\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x55"],
        ["\xF3\xB1\xB5\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x56"],
        ["\xF3\xB1\xB5\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],
        ["\xF3\xB1\xB5\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x58"],
        ["\xF3\xB1\xB5\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],
        ["\xF3\xB1\xB5\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],
        ["\xF3\xB1\xB6\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],
        ["\xF3\xB1\xB6\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],
        ["\xF3\xB1\xB6\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],
        ["\xF3\xB1\xB6\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],
        ["\xF3\xB1\xB6\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],
        ["\xF3\xB1\xB6\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],
        ["\xF3\xB1\xB6\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],
        ["\xF3\xB1\xB6\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],
        ["\xF3\xB1\xB6\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],
        ["\xF3\xB1\xB6\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],
        ["\xF3\xB1\xB6\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],
        ["\xF3\xB1\xB6\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],
        ["\xF3\xB1\xB6\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],
        ["\xF3\xB1\xB6\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],
        ["\xF3\xB1\xB6\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],
        ["\xF3\xB1\xB6\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],
        ["\xF3\xB1\xB6\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],
        ["\xF3\xB1\xB6\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],
        ["\xF3\xB1\xB6\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],
        ["\xF3\xB1\xB6\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],
        ["\xF3\xB1\xB6\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],
        ["\xF3\xB1\xB6\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],
        ["\xF3\xB1\xB6\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],
        ["\xF3\xB1\xB6\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],
        ["\xF3\xB1\xB6\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],
        ["\xF3\xB1\xB6\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],
        ["\xF3\xB1\xB6\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],
        ["\xF3\xB1\xB6\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],
        ["\xF3\xB1\xB6\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],
        ["\xF3\xB1\xB6\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],
        ["\xF3\xB1\xB6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],
        ["\xF3\xB1\xB6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],
        ["\xF3\xB1\xB6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],
        ["\xF3\xB1\xB6\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],
        ["\xF3\xB1\xB6\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],
        ["\xF3\xB1\xB6\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],
        ["\xF3\xB1\xB6\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x21"],
        ["\xF3\xB1\xB6\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x22"],
        ["\xF3\xB1\xB6\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x23"],
        ["\xF3\xB1\xB6\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x24"],
        ["\xF3\xB1\xB6\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x25"],
        ["\xF3\xB1\xB6\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x26"],
        ["\xF3\xB1\xB6\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x27"],
        ["\xF3\xB1\xB6\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x28"],
        ["\xF3\xB1\xB6\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x29"],
        ["\xF3\xB1\xB6\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2A"],
        ["\xF3\xB1\xB6\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2B"],
        ["\xF3\xB1\xB6\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2C"],
        ["\xF3\xB1\xB6\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2D"],
        ["\xF3\xB1\xB6\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2E"],
        ["\xF3\xB1\xB6\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x2F"],
        ["\xF3\xB1\xB6\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x30"],
        ["\xF3\xB1\xB6\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x31"],
        ["\xF3\xB1\xB6\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x32"],
        ["\xF3\xB1\xB6\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x33"],
        ["\xF3\xB1\xB6\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x34"],
        ["\xF3\xB1\xB6\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x35"],
        ["\xF3\xB1\xB6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x36"],
        ["\xF3\xB1\xB6\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x37"],
        ["\xF3\xB1\xB6\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x38"],
        ["\xF3\xB1\xB6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x39"],
        ["\xF3\xB1\xB6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3A"],
        ["\xF3\xB1\xB6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3B"],
        ["\xF3\xB1\xB6\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3C"],
        ["\xF3\xB1\xB7\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3D"],
        ["\xF3\xB1\xB7\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3E"],
        ["\xF3\xB1\xB7\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x3F"],
        ["\xF3\xB1\xB7\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x40"],
        ["\xF3\xB1\xB7\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x41"],
        ["\xF3\xB1\xB7\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x42"],
        ["\xF3\xB1\xB7\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x43"],
        ["\xF3\xB1\xB7\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x44"],
        ["\xF3\xB1\xB7\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x45"],
        ["\xF3\xB1\xB7\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x46"],
        ["\xF3\xB1\xB7\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x47"],
        ["\xF3\xB1\xB7\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x48"],
        ["\xF3\xB1\xB7\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x49"],
        ["\xF3\xB1\xB7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],
        ["\xF3\xB1\xB7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],
        ["\xF3\xB1\xB7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],
        ["\xF3\xB1\xB7\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],
        ["\xF3\xB1\xB7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],
        ["\xF3\xB1\xB7\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],
        ["\xF3\xB1\xB7\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],
        ["\xF3\xB1\xB7\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x51"],
        ["\xF3\xB1\xB7\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x52"],
        ["\xF3\xB1\xB7\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x53"],
        ["\xF3\xB1\xB7\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x54"],
        ["\xF3\xB1\xB7\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x55"],
        ["\xF3\xB1\xB7\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x56"],
        ["\xF3\xB1\xB7\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],
        ["\xF3\xB1\xB7\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x58"],
        ["\xF3\xB1\xB7\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],
        ["\xF3\xB1\xB7\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],
        ["\xF3\xB1\xB7\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],
        ["\xF3\xB1\xB7\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],
        ["\xF3\xB1\xB7\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],
        ["\xF3\xB1\xB7\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],
        ["\xF3\xB1\xB7\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],
        ["\xF3\xB1\xB7\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],
        ["\xF3\xB1\xB7\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],
        ["\xF3\xB1\xB7\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],
        ["\xF3\xB1\xB7\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],
        ["\xF3\xB1\xB7\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],
        ["\xF3\xB1\xB7\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],
        ["\xF3\xB1\xB7\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],
        ["\xF3\xB1\xB7\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],
        ["\xF3\xB1\xB7\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],
        ["\xF3\xB1\xB7\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],
        ["\xF3\xB1\xB7\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],
        ["\xF3\xB1\xB7\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],
        ["\xF3\xB1\xB7\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],
        ["\xF3\xB1\xB7\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],
        ["\xF3\xB1\xB7\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],
        ["\xF3\xB1\xB7\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],
        ["\xF3\xB1\xB7\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],
        ["\xF3\xB1\xB7\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],
        ["\xF3\xB1\xB7\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],
        ["\xF3\xB1\xB7\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],
        ["\xF3\xB1\xB7\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],
        ["\xF3\xB1\xB7\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],
        ["\xF3\xB1\xB7\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],
        ["\xF3\xB1\xB7\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],
        ["\xF3\xB1\xB7\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],
        ["\xF3\xB1\xB7\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],
        ["\xF3\xB1\xB7\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],
        ["\xF3\xB1\xB7\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],
        ["\xF3\xB1\xB7\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],
        ["\xF3\xB1\xB8\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],
        ["\xF3\xB1\xB8\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],
        ["\xF3\xB1\xB8\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x21"],
        ["\xF3\xB1\xB8\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x22"],
        ["\xF3\xB1\xB8\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x23"],
        ["\xF3\xB1\xB8\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x24"],
        ["\xF3\xB1\xB8\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x25"],
        ["\xF3\xB1\xB8\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x26"],
        ["\xF3\xB1\xB8\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x27"],
        ["\xF3\xB1\xB8\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x28"],
        ["\xF3\xB1\xB8\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x29"],
        ["\xF3\xB1\xB8\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2A"],
        ["\xF3\xB1\xB8\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2B"],
        ["\xF3\xB1\xB8\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2C"],
        ["\xF3\xB1\xB8\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2D"],
        ["\xF3\xB1\xB8\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2E"],
        ["\xF3\xB1\xB8\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x2F"],
        ["\xF3\xB1\xB8\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x30"],
        ["\xF3\xB1\xB8\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x31"],
        ["\xF3\xB1\xB8\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x32"],
        ["\xF3\xB1\xB8\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x33"],
        ["\xF3\xB1\xB8\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x34"],
        ["\xF3\xB1\xB8\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x35"],
        ["\xF3\xB1\xB8\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x36"],
        ["\xF3\xB1\xB8\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x37"],
        ["\xF3\xB1\xB8\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x38"],
        ["\xF3\xB1\xB8\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x39"],
        ["\xF3\xB1\xB8\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3A"],
        ["\xF3\xB1\xB8\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3B"],
        ["\xF3\xB1\xB8\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3C"],
        ["\xF3\xB1\xB8\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3D"],
        ["\xF3\xB1\xB8\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3E"],
        ["\xF3\xB1\xB8\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x3F"],
        ["\xF3\xB1\xB8\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x40"],
        ["\xF3\xB1\xB8\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x41"],
        ["\xF3\xB1\xB8\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x42"],
        ["\xF3\xB1\xB8\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x43"],
        ["\xF3\xB1\xB8\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x44"],
        ["\xF3\xB1\xB8\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x45"],
        ["\xF3\xB1\xB8\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x46"],
        ["\xF3\xB1\xB8\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x47"],
        ["\xF3\xB1\xB8\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x48"],
        ["\xF3\xB1\xB8\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x49"],
        ["\xF3\xB1\xB8\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],
        ["\xF3\xB1\xB8\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],
        ["\xF3\xB1\xB8\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],
        ["\xF3\xB1\xB8\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],
        ["\xF3\xB1\xB8\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],
        ["\xF3\xB1\xB8\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],
        ["\xF3\xB1\xB8\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],
        ["\xF3\xB1\xB8\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x51"],
        ["\xF3\xB1\xB8\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x52"],
        ["\xF3\xB1\xB8\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x53"],
        ["\xF3\xB1\xB8\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x54"],
        ["\xF3\xB1\xB8\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x55"],
        ["\xF3\xB1\xB8\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x56"],
        ["\xF3\xB1\xB8\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F\x59"],
        ["\xF3\xB1\xB8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x58"],
        ["\xF3\xB1\xB8\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],
        ["\xF3\xB1\xB8\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],
        ["\xF3\xB1\xB8\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],
        ["\xF3\xB1\xB8\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],
        ["\xF3\xB1\xB8\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],
        ["\xF3\xB1\xB8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],
        ["\xF3\xB1\xB9\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],
        ["\xF3\xB1\xB9\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],
        ["\xF3\xB1\xB9\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],
        ["\xF3\xB1\xB9\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],
        ["\xF3\xB1\xB9\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],
        ["\xF3\xB1\xB9\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],
        ["\xF3\xB1\xB9\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],
        ["\xF3\xB1\xB9\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],
        ["\xF3\xB1\xB9\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],
        ["\xF3\xB1\xB9\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],
        ["\xF3\xB1\xB9\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],
        ["\xF3\xB1\xB9\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],
        ["\xF3\xB1\xB9\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],
        ["\xF3\xB1\xB9\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],
        ["\xF3\xB1\xB9\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],
        ["\xF3\xB1\xB9\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],
        ["\xF3\xB1\xB9\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],
        ["\xF3\xB1\xB9\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],
        ["\xF3\xB1\xB9\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],
        ["\xF3\xB1\xB9\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],
        ["\xF3\xB1\xB9\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],
        ["\xF3\xB1\xB9\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37\x5B"],
        ["\xF3\xB1\xB9\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],
        ["\xF3\xB1\xB9\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],
        ["\xF3\xB1\xB9\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],
        ["\xF3\xB1\xB9\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],
        ["\xF3\xB1\xB9\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],
        ["\xF3\xB1\xB9\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],
        ["\xF3\xB1\xB9\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],
        ["\xF3\xB1\xB9\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],
        ["\xF3\xB1\xB9\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],
        ["\xF3\xB1\xB9\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],
        ["\xF3\xB1\xB9\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x21"],
        ["\xF3\xB1\xB9\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x22"],
        ["\xF3\xB1\xB9\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x23"],
        ["\xF3\xB1\xB9\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x24"],
        ["\xF3\xB1\xB9\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x25"],
        ["\xF3\xB1\xB9\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x26"],
        ["\xF3\xB1\xB9\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x27"],
        ["\xF3\xB1\xB9\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x28"],
        ["\xF3\xB1\xB9\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x29"],
        ["\xF3\xB1\xB9\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2A"],
        ["\xF3\xB1\xB9\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2B"],
        ["\xF3\xB1\xB9\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2C"],
        ["\xF3\xB1\xB9\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2D"],
        ["\xF3\xB1\xB9\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2E"],
        ["\xF3\xB1\xB9\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x2F"],
        ["\xF3\xB1\xB9\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x30"],
        ["\xF3\xB1\xB9\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x31"],
        ["\xF3\xB1\xB9\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x32"],
        ["\xF3\xB1\xB9\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x33"],
        ["\xF3\xB1\xB9\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x34"],
        ["\xF3\xB1\xB9\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x35"],
        ["\xF3\xB1\xB9\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x36"],
        ["\xF3\xB1\xB9\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x37"],
        ["\xF3\xB1\xB9\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x38"],
        ["\xF3\xB1\xB9\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x39"],
        ["\xF3\xB1\xB9\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3A"],
        ["\xF3\xB1\xB9\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3B"],
        ["\xF3\xB1\xB9\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3C"],
        ["\xF3\xB1\xB9\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3D"],
        ["\xF3\xB1\xB9\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3E"],
        ["\xF3\xB1\xB9\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x3F"],
        ["\xF3\xB1\xB9\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x40"],
        ["\xF3\xB1\xBA\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x41"],
        ["\xF3\xB1\xBA\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x42"],
        ["\xF3\xB1\xBA\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x43"],
        ["\xF3\xB1\xBA\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x44"],
        ["\xF3\xB1\xBA\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x45"],
        ["\xF3\xB1\xBA\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x46"],
        ["\xF3\xB1\xBA\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x47"],
        ["\xF3\xB1\xBA\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x48"],
        ["\xF3\xB1\xBA\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x49"],
        ["\xF3\xB1\xBA\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],
        ["\xF3\xB1\xBA\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],
        ["\xF3\xB1\xBA\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],
        ["\xF3\xB1\xBA\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],
        ["\xF3\xB1\xBA\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],
        ["\xF3\xB1\xBA\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],
        ["\xF3\xB1\xBA\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],
        ["\xF3\xB1\xBA\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x51"],
        ["\xF3\xB1\xBA\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x52"],
        ["\xF3\xB1\xBA\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x53"],
        ["\xF3\xB1\xBA\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x54"],
        ["\xF3\xB1\xBA\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x55"],
        ["\xF3\xB1\xBA\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x56"],
        ["\xF3\xB1\xBA\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],
        ["\xF3\xB1\xBA\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x58"],
        ["\xF3\xB1\xBA\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],
        ["\xF3\xB1\xBA\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],
        ["\xF3\xB1\xBA\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],
        ["\xF3\xB1\xBA\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],
        ["\xF3\xB1\xBA\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],
        ["\xF3\xB1\xBA\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],
        ["\xF3\xB1\xBA\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],
        ["\xF3\xB1\xBA\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],
        ["\xF3\xB1\xBA\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],
        ["\xF3\xB1\xBA\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],
        ["\xF3\xB1\xBA\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],
        ["\xF3\xB1\xBA\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],
        ["\xF3\xB1\xBA\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],
        ["\xF3\xB1\xBA\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],
        ["\xF3\xB1\xBA\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],
        ["\xF3\xB1\xBA\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],
        ["\xF3\xB1\xBA\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],
        ["\xF3\xB1\xBA\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],
        ["\xF3\xB1\xBA\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],
        ["\xF3\xB1\xBA\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],
        ["\xF3\xB1\xBA\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],
        ["\xF3\xB1\xBA\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],
        ["\xF3\xB1\xBA\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],
        ["\xF3\xB1\xBA\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],
        ["\xF3\xB1\xBA\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],
        ["\xF3\xB1\xBA\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],
        ["\xF3\xB1\xBA\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],
        ["\xF3\xB1\xBA\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],
        ["\xF3\xB1\xBA\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],
        ["\xF3\xB1\xBA\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],
        ["\xF3\xB1\xBA\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],
        ["\xF3\xB1\xBA\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],
        ["\xF3\xB1\xBA\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],
        ["\xF3\xB1\xBA\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],
        ["\xF3\xB1\xBA\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],
        ["\xF3\xB1\xBA\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],
        ["\xF3\xB1\xBA\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],
        ["\xF3\xB1\xBA\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],
        ["\xF3\xB1\xBA\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x21"],
        ["\xF3\xB1\xBA\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x22"],
        ["\xF3\xB1\xBB\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x23"],
        ["\xF3\xB1\xBB\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x24"],
        ["\xF3\xB1\xBB\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x25"],
        ["\xF3\xB1\xBB\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x26"],
        ["\xF3\xB1\xBB\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x27"],
        ["\xF3\xB1\xBB\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x28"],
        ["\xF3\xB1\xBB\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x29"],
        ["\xF3\xB1\xBB\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2A"],
        ["\xF3\xB1\xBB\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2B"],
        ["\xF3\xB1\xBB\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2C"],
        ["\xF3\xB1\xBB\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2D"],
        ["\xF3\xB1\xBB\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2E"],
        ["\xF3\xB1\xBB\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x2F"],
        ["\xF3\xB1\xBB\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x30"],
        ["\xF3\xB1\xBB\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x31"],
        ["\xF3\xB1\xBB\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x32"],
        ["\xF3\xB1\xBB\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x33"],
        ["\xF3\xB1\xBB\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x34"],
        ["\xF3\xB1\xBB\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x35"],
        ["\xF3\xB1\xBB\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x36"],
        ["\xF3\xB1\xBB\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x37"],
        ["\xF3\xB1\xBB\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x38"],
        ["\xF3\xB1\xBB\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x39"],
        ["\xF3\xB1\xBB\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3A"],
        ["\xF3\xB1\xBB\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3B"],
        ["\xF3\xB1\xBB\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3C"],
        ["\xF3\xB1\xBB\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3D"],
        ["\xF3\xB1\xBB\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3E"],
        ["\xF3\xB1\xBB\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x3F"],
        ["\xF3\xB1\xBB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x40"],
        ["\xF3\xB1\xBB\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x41"],
        ["\xF3\xB1\xBB\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x42"],
        ["\xF3\xB1\xBB\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x43"],
        ["\xF3\xB1\xBB\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x44"],
        ["\xF3\xB1\xBB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x45"],
        ["\xF3\xB1\xBB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x46"],
        ["\xF3\xB1\xBB\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x47"],
        ["\xF3\xB1\xBB\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x48"],
        ["\xF3\xB1\xBB\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x49"],
        ["\xF3\xB1\xBB\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],
        ["\xF3\xB1\xBB\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],
        ["\xF3\xB1\xBB\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],
        ["\xF3\xB1\xBB\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30\x33"],
        ["\xF3\xB1\xBB\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],
        ["\xF3\xB1\xBB\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],
        ["\xF3\xB1\xBB\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],
        ["\xF3\xB1\xBB\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x51"],
        ["\xF3\xB1\xBB\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x52"],
        ["\xF3\xB1\xBB\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x53"],
        ["\xF3\xB1\xBB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x54"],
        ["\xF3\xB1\xBB\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x55"],
        ["\xF3\xB1\xBB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x56"],
        ["\xF3\xB1\xBB\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],
        ["\xF3\xB1\xBB\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x58"],
        ["\xF3\xB1\xBB\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],
        ["\xF3\xB1\xBB\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],
        ["\xF3\xB1\xBB\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],
        ["\xF3\xB1\xBB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],
        ["\xF3\xB1\xBB\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],
        ["\xF3\xB1\xBB\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],
        ["\xF3\xB1\xBB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],
        ["\xF3\xB1\xBB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],
        ["\xF3\xB1\xBB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],
        ["\xF3\xB1\xBB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],
        ["\xF3\xB1\xBC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],
        ["\xF3\xB1\xBC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],
        ["\xF3\xB1\xBC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],
        ["\xF3\xB1\xBC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],
        ["\xF3\xB1\xBC\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],
        ["\xF3\xB1\xBC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],
        ["\xF3\xB1\xBC\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],
        ["\xF3\xB1\xBC\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],
        ["\xF3\xB1\xBC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],
        ["\xF3\xB1\xBC\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],
        ["\xF3\xB1\xBC\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],
        ["\xF3\xB1\xBC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],
        ["\xF3\xB1\xBC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],
        ["\xF3\xB1\xBC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],
        ["\xF3\xB1\xBC\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],
        ["\xF3\xB1\xBC\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],
        ["\xF3\xB1\xBC\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],
        ["\xF3\xB1\xBC\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32\x29"],
        ["\xF3\xB1\xBC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],
        ["\xF3\xB1\xBC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],
        ["\xF3\xB1\xBC\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],
        ["\xF3\xB1\xBC\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],
        ["\xF3\xB1\xBC\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],
        ["\xF3\xB1\xBC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],
        ["\xF3\xB1\xBC\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],
        ["\xF3\xB1\xBC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],
        ["\xF3\xB1\xBC\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],
        ["\xF3\xB1\xBC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],
        ["\xF3\xB1\xBC\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x21"],
        ["\xF3\xB1\xBC\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x22"],
        ["\xF3\xB1\xBC\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x23"],
        ["\xF3\xB1\xBC\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x24"],
        ["\xF3\xB1\xBC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x25"],
        ["\xF3\xB1\xBC\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x26"],
        ["\xF3\xB1\xBC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x27"],
        ["\xF3\xB1\xBC\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x28"],
        ["\xF3\xB1\xBC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x29"],
        ["\xF3\xB1\xBC\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2A"],
        ["\xF3\xB1\xBC\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2B"],
        ["\xF3\xB1\xBC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2C"],
        ["\xF3\xB1\xBC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2D"],
        ["\xF3\xB1\xBC\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2E"],
        ["\xF3\xB1\xBC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x2F"],
        ["\xF3\xB1\xBC\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x30"],
        ["\xF3\xB1\xBC\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x31"],
        ["\xF3\xB1\xBC\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x32"],
        ["\xF3\xB1\xBC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x33"],
        ["\xF3\xB1\xBC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x34"],
        ["\xF3\xB1\xBC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x35"],
        ["\xF3\xB1\xBC\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x36"],
        ["\xF3\xB1\xBC\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x37"],
        ["\xF3\xB1\xBC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x38"],
        ["\xF3\xB1\xBC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x39"],
        ["\xF3\xB1\xBC\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3A"],
        ["\xF3\xB1\xBC\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3B"],
        ["\xF3\xB1\xBC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3C"],
        ["\xF3\xB1\xBC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3D"],
        ["\xF3\xB1\xBC\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3E"],
        ["\xF3\xB1\xBC\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x3F"],
        ["\xF3\xB1\xBC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x40"],
        ["\xF3\xB1\xBC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x41"],
        ["\xF3\xB1\xBC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x42"],
        ["\xF3\xB1\xBC\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x43"],
        ["\xF3\xB1\xBC\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x44"],
        ["\xF3\xB1\xBD\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x45"],
        ["\xF3\xB1\xBD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x46"],
        ["\xF3\xB1\xBD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x47"],
        ["\xF3\xB1\xBD\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x48"],
        ["\xF3\xB1\xBD\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x49"],
        ["\xF3\xB1\xBD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],
        ["\xF3\xB1\xBD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],
        ["\xF3\xB1\xBD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],
        ["\xF3\xB1\xBD\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],
        ["\xF3\xB1\xBD\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],
        ["\xF3\xB1\xBD\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],
        ["\xF3\xB1\xBD\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],
        ["\xF3\xB1\xBD\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x51"],
        ["\xF3\xB1\xBD\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x52"],
        ["\xF3\xB1\xBD\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x53"],
        ["\xF3\xB1\xBD\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x54"],
        ["\xF3\xB1\xBD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x55"],
        ["\xF3\xB1\xBD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x56"],
        ["\xF3\xB1\xBD\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],
        ["\xF3\xB1\xBD\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x58"],
        ["\xF3\xB1\xBD\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],
        ["\xF3\xB1\xBD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],
        ["\xF3\xB1\xBD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],
        ["\xF3\xB1\xBD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],
        ["\xF3\xB1\xBD\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],
        ["\xF3\xB1\xBD\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],
        ["\xF3\xB1\xBD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],
        ["\xF3\xB1\xBD\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],
        ["\xF3\xB1\xBD\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],
        ["\xF3\xB1\xBD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],
        ["\xF3\xB1\xBD\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],
        ["\xF3\xB1\xBD\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],
        ["\xF3\xB1\xBD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],
        ["\xF3\xB1\xBD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],
        ["\xF3\xB1\xBD\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],
        ["\xF3\xB1\xBD\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],
        ["\xF3\xB1\xBD\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],
        ["\xF3\xB1\xBD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],
        ["\xF3\xB1\xBD\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],
        ["\xF3\xB1\xBD\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],
        ["\xF3\xB1\xBD\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],
        ["\xF3\xB1\xBD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],
        ["\xF3\xB1\xBD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],
        ["\xF3\xB1\xBD\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],
        ["\xF3\xB1\xBD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],
        ["\xF3\xB1\xBD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],
        ["\xF3\xB1\xBD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],
        ["\xF3\xB1\xBD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],
        ["\xF3\xB1\xBD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],
        ["\xF3\xB1\xBD\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],
        ["\xF3\xB1\xBD\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],
        ["\xF3\xB1\xBD\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],
        ["\xF3\xB1\xBD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],
        ["\xF3\xB1\xBD\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],
        ["\xF3\xB1\xBD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],
        ["\xF3\xB1\xBD\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],
        ["\xF3\xB1\xBD\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],
        ["\xF3\xB1\xBD\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],
        ["\xF3\xB1\xBD\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36\x46"],
        ["\xF3\xB1\xBD\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\xF3\xB1\xBD\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\xF3\xB1\xBD\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\xF3\xB1\xBD\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xF3\xB1\xBD\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xF3\xB2\xAB\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xF3\xB2\xAB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xF3\xB2\xAB\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\xF3\xB2\xAB\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\xF3\xB2\xAB\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\xF3\xB2\xAB\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC2"],
        ["\xF3\xB2\xAB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC3"],
        ["\xF3\xB2\xAB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC4"],
        ["\xF3\xB2\xAB\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC5"],
        ["\xF3\xB2\xAB\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xC6"],
        ["\xF3\xB2\xAB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xFB"],
        ["\xF3\xB2\xAB\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xF3\xB2\xAB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xF3\xB2\xAB\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xF3\xB2\xAB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xF3\xB2\xAB\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xF3\xB2\xAB\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xF3\xB2\xAB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xF3\xB2\xAB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xF3\xB2\xAB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xF3\xB2\xAB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xF3\xB2\xAC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xF3\xB2\xAC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xF3\xB2\xAC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xF3\xB2\xAC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xF3\xB2\xAC\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xF3\xB2\xAC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xF3\xB2\xAC\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xF3\xB2\xAC\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xF3\xB2\xAC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xF3\xB2\xAC\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xF3\xB2\xAC\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xF3\xB2\xAC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xF3\xB2\xAC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xF3\xB2\xAC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xF3\xB2\xAC\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xF3\xB2\xAC\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xF3\xB2\xAC\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xF3\xB2\xAC\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xF3\xB2\xAC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xF3\xB2\xAC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xF3\xB2\xAC\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xF3\xB2\xAC\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xF3\xB2\xAC\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xF3\xB2\xAC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xF3\xB2\xAC\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xF3\xB2\xAC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xF3\xB2\xAC\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xF3\xB2\xAC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xF3\xB2\xAC\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xF3\xB2\xAC\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xF3\xB2\xAC\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xF3\xB2\xAC\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xF3\xB2\xAC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xF3\xB2\xAC\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xF3\xB2\xAC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xF3\xB2\xAC\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xF3\xB2\xAC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xF3\xB2\xAC\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xF3\xB2\xAC\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xF3\xB2\xAC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xF3\xB2\xAC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xF3\xB2\xAC\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xF3\xB2\xAC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xF3\xB2\xAC\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xF3\xB2\xAC\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xF3\xB2\xAC\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xF3\xB2\xAC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xF3\xB2\xAC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xF3\xB2\xAC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xF3\xB2\xAC\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xF3\xB2\xAC\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xF3\xB2\xAC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xF3\xB2\xAC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xF3\xB2\xAC\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xF3\xB2\xAC\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xF3\xB2\xAC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\xF3\xB2\xAC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xF3\xB2\xAC\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xF3\xB2\xAC\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xF3\xB2\xAC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xF3\xB2\xAC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xF3\xB2\xAC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xF3\xB2\xAC\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xF3\xB2\xAC\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xF3\xB2\xAD\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xF3\xB2\xAD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xF3\xB2\xAD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xF3\xB2\xAD\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xF3\xB2\xAD\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xF3\xB2\xAD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xF3\xB2\xAD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xF3\xB2\xAD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xF3\xB2\xAD\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xF3\xB2\xAD\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xF3\xB2\xAD\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xF3\xB2\xAD\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xF3\xB2\xAD\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xF3\xB2\xAD\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xF3\xB2\xAD\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xF3\xB2\xAD\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xF3\xB2\xAD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xF3\xB2\xAD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xF3\xB2\xAD\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xF3\xB2\xAD\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xF3\xB2\xAD\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xF3\xB2\xAD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xF3\xB2\xAD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xF3\xB2\xAD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xF3\xB2\xAD\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xF3\xB2\xAD\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xF3\xB2\xAD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xF3\xB2\xAD\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xF3\xB2\xAD\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xF3\xB2\xAD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xF3\xB2\xAD\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xF3\xB2\xAD\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xF3\xB2\xAD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xF3\xB2\xAD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xF3\xB2\xAD\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xF3\xB2\xAD\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xF3\xB2\xAD\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xF3\xB2\xAD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xF3\xB2\xAD\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xF3\xB2\xAD\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xF3\xB2\xAD\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xF3\xB2\xAD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xF3\xB2\xAD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xF3\xB2\xAD\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x37"],
        ["\xF3\xB2\xAD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xF3\xB2\xAD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xF3\xB2\xAD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xF3\xB2\xAD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xF3\xB2\xAD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xF3\xB2\xAD\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xF3\xB2\xAD\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xF3\xB2\xAD\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xF3\xB2\xAD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xF3\xB2\xAD\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xF3\xB2\xAD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xF3\xB2\xAD\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xF3\xB2\xAD\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xF3\xB2\xAD\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xF3\xB2\xAD\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xF3\xB2\xAD\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xF3\xB2\xAD\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xF3\xB2\xAD\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xF3\xB2\xAD\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xF3\xB2\xAD\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xF3\xB2\xAE\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xF3\xB2\xAE\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xF3\xB2\xAE\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xF3\xB2\xAE\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xF3\xB2\xAE\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xF3\xB2\xAE\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xF3\xB2\xAE\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xF3\xB2\xAE\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xF3\xB2\xAE\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xF3\xB2\xAE\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xF3\xB2\xAE\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xF3\xB2\xAE\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xF3\xB2\xAE\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xF3\xB2\xAE\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xF3\xB2\xAE\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xF3\xB2\xAE\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xF3\xB2\xAE\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xF3\xB2\xAE\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xF3\xB2\xAE\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xF3\xB2\xAE\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xF3\xB2\xAE\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xF3\xB2\xAE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xF3\xB2\xAE\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xF3\xB2\xAE\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xF3\xB2\xAE\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xF3\xB2\xAE\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xF3\xB2\xAE\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xF3\xB2\xAE\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xF3\xB2\xAE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xF3\xB2\xAE\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xF3\xB2\xAE\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xF3\xB2\xAE\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xF3\xB2\xAE\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xF3\xB2\xAE\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xF3\xB2\xAE\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xF3\xB2\xAE\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xF3\xB2\xAE\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xF3\xB2\xAE\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xF3\xB2\xAE\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xF3\xB2\xAE\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xF3\xB2\xAE\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xF3\xB2\xAE\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xF3\xB2\xAE\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xF3\xB2\xAE\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xF3\xB2\xAE\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xF3\xB2\xAE\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xF3\xB2\xAE\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xF3\xB2\xAE\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xF3\xB2\xAE\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xF3\xB2\xAE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xF3\xB2\xAE\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xF3\xB2\xAE\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xF3\xB2\xAE\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xF3\xB2\xAE\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xF3\xB2\xAE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xF3\xB2\xAE\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xF3\xB2\xAE\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xF3\xB2\xAE\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xF3\xB2\xAE\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xF3\xB2\xAE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xF3\xB2\xAE\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xF3\xB2\xAE\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xF3\xB2\xAE\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xF3\xB2\xAE\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xF3\xB2\xAF\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xF3\xB2\xAF\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xF3\xB2\xAF\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xF3\xB2\xAF\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xF3\xB2\xAF\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xF3\xB2\xAF\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xF3\xB2\xAF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xF3\xB2\xAF\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xF3\xB2\xAF\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xF3\xB2\xAF\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xF3\xB2\xAF\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xF3\xB2\xAF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xF3\xB2\xAF\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xF3\xB2\xAF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xF3\xB2\xAF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xF3\xB2\xAF\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xF3\xB2\xAF\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xF3\xB2\xAF\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xF3\xB2\xAF\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xF3\xB2\xAF\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xF3\xB2\xAF\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xF3\xB2\xAF\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xF3\xB2\xAF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xF3\xB2\xAF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xF3\xB2\xAF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xF3\xB2\xAF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xF3\xB2\xAF\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xF3\xB2\xAF\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xF3\xB2\xAF\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xF3\xB2\xAF\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xF3\xB2\xAF\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xF3\xB2\xAF\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xF3\xB2\xAF\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xF3\xB2\xAF\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xF3\xB2\xAF\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xF3\xB2\xAF\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xF3\xB2\xAF\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xF3\xB2\xAF\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xF3\xB2\xAF\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xF3\xB2\xAF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xF3\xB2\xAF\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xF3\xB2\xAF\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xF3\xB2\xAF\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xF3\xB2\xAF\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xF3\xB2\xAF\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xF3\xB2\xAF\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xF3\xB2\xAF\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xF3\xB2\xAF\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xF3\xB2\xAF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xF3\xB2\xAF\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xF3\xB2\xAF\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xF3\xB2\xAF\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xF3\xB2\xAF\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xF3\xB2\xAF\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xF3\xB2\xAF\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xF3\xB2\xAF\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xF3\xB2\xAF\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xF3\xB2\xAF\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xF3\xB2\xAF\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xF3\xB2\xAF\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xF3\xB2\xAF\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xF3\xB2\xAF\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xF3\xB2\xAF\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xF3\xB2\xAF\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xF3\xB2\xB0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xF3\xB2\xB0\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xF3\xB2\xB0\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xF3\xB2\xB0\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xF3\xB2\xB0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xF3\xB2\xB0\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xF3\xB2\xB0\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xF3\xB2\xB0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xF3\xB2\xB0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xF3\xB2\xB0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xDE"],
        ["\xF3\xB2\xB0\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xFD"],
        ["\xF3\xB2\xB0\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xF3\xB2\xB0\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xF3\xB2\xB0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xF3\xB2\xB0\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xF3\xB2\xB0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xF3\xB2\xB0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xF3\xB2\xB0\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xF3\xB2\xB0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xF3\xB2\xB0\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xF3\xB2\xB0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xF3\xB2\xB0\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xF3\xB2\xB0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xF3\xB2\xB0\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xF3\xB2\xB0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xF3\xB2\xB0\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xF3\xB2\xB0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xF3\xB2\xB0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xF3\xB2\xB0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xF3\xB2\xB0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xF3\xB2\xB0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xF3\xB2\xB0\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xF3\xB2\xB0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xF3\xB2\xB0\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xF3\xB2\xB0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xF3\xB2\xB0\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xF3\xB2\xB0\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xF3\xB2\xB0\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xF3\xB2\xB0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xF3\xB2\xB0\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xF3\xB2\xB0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xF3\xB2\xB0\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xF3\xB2\xB0\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xF3\xB2\xB0\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xF3\xB2\xB0\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xF3\xB2\xB0\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xF3\xB2\xB0\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xF3\xB2\xB0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xF3\xB2\xB0\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xF3\xB2\xB0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xF3\xB2\xB0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xF3\xB2\xB0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xF3\xB2\xB0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xF3\xB2\xB0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xF3\xB2\xB0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xF3\xB2\xB0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xF3\xB2\xB0\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xF3\xB2\xB0\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xF3\xB2\xB0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xF3\xB2\xB0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xF3\xB2\xB0\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xF3\xB2\xB0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xF3\xB2\xB0\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xF3\xB2\xB0\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xF3\xB2\xB1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xF3\xB2\xB1\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xF3\xB2\xB1\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xF3\xB2\xB1\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xF3\xB2\xB1\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xF3\xB2\xB1\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xF3\xB2\xB1\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xF3\xB2\xB1\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xF3\xB2\xB1\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xF3\xB2\xB1\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xF3\xB2\xB1\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xF3\xB2\xB1\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xF3\xB2\xB1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xF3\xB2\xB1\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xF3\xB2\xB1\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xF3\xB2\xB1\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xF3\xB2\xB1\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xF3\xB2\xB1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xF3\xB2\xB1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xF3\xB2\xB1\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xF3\xB2\xB1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xF3\xB2\xB1\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xF3\xB2\xB1\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xF3\xB2\xB1\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xF3\xB2\xB1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xF3\xB2\xB1\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xF3\xB2\xB1\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xF3\xB2\xB1\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xF3\xB2\xB1\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xF3\xB2\xB1\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xF3\xB2\xB1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xF3\xB2\xB1\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xF3\xB2\xB6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xF3\xB2\xB6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xF3\xB2\xB6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xF3\xB2\xB6\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xF3\xB2\xB6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xF3\xB2\xB6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xF3\xB2\xB6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xF3\xB2\xB6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xDE"],
        ["\xF3\xB2\xB7\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xF3\xB2\xB7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xF3\xB2\xB7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xF3\xB2\xB7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xF3\xB2\xB7\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xF3\xB2\xB7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xF3\xB2\xB7\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xF3\xB2\xB7\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xF3\xB2\xB7\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xDD"],
        ["\xF3\xB2\xB8\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xF3\xB2\xB8\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF7"],
        ["\xF3\xB2\xBB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xF3\xB2\xBC\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xF3\xB2\xBC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xF3\xB2\xBC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xF3\xB2\xBE\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xFA"],
        ["\xF3\xB2\xBE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xFB"],
        ["\xF3\xB3\x80\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xF3\xB3\x80\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xF3\xB3\x80\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xF3\xB3\x80\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xF3\xB3\x80\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xF3\xB3\x80\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xF3\xB3\x80\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xF3\xB3\x80\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xF3\xB3\x80\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xF3\xB3\x80\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xF3\xB3\x80\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xF3\xB3\x80\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xF3\xB3\x80\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xF3\xB3\x80\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xF3\xB3\x80\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xF3\xB3\x80\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xF3\xB3\x80\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xF3\xB3\x80\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xF3\xB3\x80\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xF3\xB3\x80\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xF3\xB3\x80\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xF3\xB3\x80\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xF3\xB3\x80\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xF3\xB3\x80\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xF3\xB3\x81\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xF3\xB3\x81\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xF3\xB3\x81\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xF3\xB3\x81\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xF3\xB3\x81\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xF3\xB3\x81\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xF3\xB3\x81\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xF3\xB3\x81\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xF3\xB3\x81\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xF3\xB3\x81\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xF3\xB3\x81\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xF3\xB3\x81\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xF3\xB3\x83\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xF3\xB3\x83\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xF3\xB3\x84\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xF3\xB3\x84\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xF3\xB3\x84\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xF3\xB3\x84\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xF3\xB3\x84\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xF3\xB3\x84\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xF3\xB3\x84\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xF3\xB3\x84\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xF3\xB3\x84\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xF3\xB3\x84\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xF3\xB3\x84\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xDB"],
        ["\xF3\xB3\x84\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],
        ["\xF3\xB3\x84\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xF3\xB3\x84\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xF3\xB3\x84\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xF3\xB3\x84\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xF3\xB3\x84\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xF3\xB3\x84\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xF3\xB3\x85\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xF3\xB3\x85\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xF3\xB3\x85\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xF3\xB3\x85\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\xF3\xB3\x85\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\xF3\xB3\x85\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xF3\xB3\x85\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xF3\xB3\x85\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xF3\xB3\x85\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xF3\xB3\x85\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xF3\xB3\x85\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xF3\xB3\x85\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xF3\xB3\x85\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xF3\xB3\x85\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xF3\xB3\x85\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xF3\xB3\x85\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xF3\xB3\x85\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xF3\xB3\x85\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xF3\xB3\x85\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xF3\xB3\x85\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xF3\xB3\x85\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xF3\xB3\x85\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xF3\xB3\x85\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xF3\xB3\x85\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xF3\xB3\x85\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xF3\xB3\x85\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xF3\xB3\x85\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xF3\xB3\x85\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xF3\xB3\x85\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xF3\xB3\x85\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xF3\xB3\x85\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xF3\xB3\x85\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xF3\xB3\x85\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xF3\xB3\x85\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xF3\xB3\x85\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xF3\xB3\x85\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xF3\xB3\x85\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xF3\xB3\x86\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xD1"],
        ["\xF3\xB3\x86\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xD2"],
        ["\xF3\xB3\x87\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xF3\xB3\x87\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xF3\xB3\x87\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xF3\xB3\x87\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xF3\xB3\x87\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xF3\xB3\x87\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xF3\xB3\x87\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xF3\xB3\x87\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xF3\xB3\x87\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xF3\xB3\x87\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xF3\xB3\x87\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xF3\xB3\x87\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xF3\xB3\x87\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xF3\xB3\x87\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xF3\xB3\x87\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xF3\xB3\x87\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xF3\xB3\x87\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xF3\xB3\x87\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xF3\xB3\x88\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xF3\xB3\x88\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xF3\xB3\x88\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xF3\xB3\x88\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xF3\xB3\x88\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xF3\xB3\x88\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xF3\xB3\x88\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xF3\xB3\x88\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xF3\xB3\x88\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xF3\xB3\x88\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xF3\xB3\x88\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xF3\xB3\x88\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xF3\xB3\x88\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xF3\xB3\x88\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xF3\xB3\x88\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xF3\xB3\x88\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xF3\xB3\x88\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xF3\xB3\x88\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xF3\xB3\x88\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xF3\xB3\x89\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xF3\xB3\x89\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xF3\xB3\x89\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xF3\xB3\x89\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xF3\xB3\x89\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xF3\xB3\x89\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xF3\xB3\x89\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xF3\xB3\x89\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xF3\xB3\x89\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xF3\xB3\x89\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xF3\xB3\x89\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xF3\xB3\x89\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xF3\xB3\x89\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xF3\xB3\x89\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xF3\xB3\x89\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xF3\xB3\x89\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xF3\xB3\x89\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xF3\xB3\x89\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xF3\xB3\x89\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xF3\xB3\x89\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x36"],
        ["\xF3\xB3\x89\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xF3\xB3\x89\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xF3\xB3\x89\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xF3\xB3\x89\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xF3\xB3\x89\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xF3\xB3\x89\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xF3\xB3\x89\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xF3\xB3\x89\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xF3\xB3\x89\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xF3\xB3\x89\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xF3\xB3\x89\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xF3\xB3\x89\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xF3\xB3\x8A\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xF3\xB3\x8A\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xF3\xB3\x8A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xF3\xB3\x8A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xF3\xB3\x8A\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xF3\xB3\x8A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xF3\xB3\x8A\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xF3\xB3\x8A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xF3\xB3\x8A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xF3\xB3\x8A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xF3\xB3\x8A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xF3\xB3\xB8\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xF3\xB3\xB8\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xF3\xB3\xB8\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xF3\xB3\xB8\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xF3\xB3\xB8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xF3\xB3\xB8\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xF3\xB3\xB8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xF3\xB3\xB9\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xF3\xB3\xB9\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xF3\xB3\xB9\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xF3\xB4\x83\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x3B"],
        ["\xF3\xB4\xAE\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xF3\xB4\xAE\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xF3\xB4\xAE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xF3\xB4\xAE\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xF3\xB4\xAE\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xF3\xB4\xAE\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xF3\xB4\xAE\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xF3\xB4\xAE\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xF3\xB4\xAE\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xF3\xB4\xAE\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xF3\xB4\xAE\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xF3\xB4\xAE\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xF3\xB4\xAE\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xF3\xB4\xAE\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xF3\xB4\xAE\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xF3\xB4\xAE\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xF3\xB4\xAE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xF3\xB4\xAE\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xF3\xB4\xAE\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xF3\xB4\xAE\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xF3\xB4\xAE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xF3\xB4\xAE\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xF3\xB4\xAE\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xF3\xB4\xAE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xF3\xB4\xAF\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xF3\xB4\xAF\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xF3\xB4\xAF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xF3\xB4\xAF\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xF3\xB4\xAF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xF3\xB4\xAF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xF3\xB4\xAF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xF3\xB4\xAF\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xF3\xB4\xAF\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xF3\xB4\xAF\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xF3\xB4\xAF\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xF3\xB4\xAF\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xF3\xB4\xAF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xF3\xB4\xAF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xF3\xB4\xAF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xF3\xB4\xAF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xF3\xB4\xAF\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xF3\xB4\xAF\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xF3\xB4\xAF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xF3\xB4\xAF\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xF3\xB4\xAF\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xF3\xB4\xAF\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xF3\xB4\xAF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xF3\xB4\xAF\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xF3\xB4\xAF\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xF3\xB4\xAF\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xF3\xB4\xB0\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xF3\xB4\xB0\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xF3\xB4\xB0\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xF3\xB4\xB0\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xF3\xB4\xB0\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xF3\xB4\xB0\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xF3\xB4\xB0\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xF3\xB4\xB0\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xF3\xB4\xB0\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xF3\xB4\xB0\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xF3\xB4\xB0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xF3\xB4\xB0\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xF3\xB4\xB0\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xF3\xB4\xB0\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xF3\xB4\xB0\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xF3\xB4\xB0\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xF3\xB4\xB0\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xF3\xB4\xB0\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xF3\xB4\xB0\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xF3\xB4\xB0\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xF3\xB4\xB0\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xF3\xB4\xB0\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xF3\xB4\xB0\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xF3\xB4\xB0\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xF3\xB4\xB0\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xF3\xB4\xB0\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xF3\xB4\xB0\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xF3\xB4\xB0\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xF3\xB4\xB0\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xF3\xB4\xB0\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xF3\xB4\xB1\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xF3\xB4\xB1\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xF3\xB4\xB1\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xF3\xB4\xB1\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xF3\xB4\xB1\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xF3\xB4\xB1\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xF3\xB4\xB1\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xF3\xB4\xB1\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xF3\xB4\xB1\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xF3\xB4\xB1\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xF3\xB4\xB1\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xF3\xB4\xB1\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xF3\xB4\xB1\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xF3\xB4\xB1\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xF3\xB4\xB1\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xF3\xB4\xB1\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xF3\xB4\xB1\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xF3\xB4\xB1\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xF3\xB4\xB1\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xF3\xB4\xB2\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xF3\xB4\xB2\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xF3\xB4\xB2\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xF3\xB4\xB2\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xF3\xB4\xB2\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xF3\xB4\xB2\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xF3\xB4\xB2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xF3\xB4\xB2\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xF3\xB4\xB2\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xF3\xB4\xB2\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xF3\xB4\xB2\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xF3\xB4\xB2\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xF3\xB4\xB2\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xF3\xB4\xB2\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xF3\xB4\xB2\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xF3\xB4\xB2\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xF3\xB4\xB2\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xF3\xB4\xB2\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xF3\xB4\xB2\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xF3\xB4\xB2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xF3\xB4\xB2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xF3\xB4\xB2\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xF3\xB4\xB2\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xF3\xB4\xB2\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xF3\xB4\xB2\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xF3\xB4\xB2\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xF3\xB4\xB2\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xF3\xB4\xB2\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xF3\xB4\xB2\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xF3\xB4\xB2\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xF3\xB4\xB2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xF3\xB4\xB3\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xF3\xB4\xB3\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xF3\xB4\xB3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xF3\xB4\xB3\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xF3\xB4\xB3\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xF3\xB4\xB3\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xF3\xB4\xB3\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xF3\xB4\xB3\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xF3\xB4\xB3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xF3\xB4\xB3\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xF3\xB4\xB3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xF3\xB4\xB3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xF3\xB4\xB3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xF3\xB4\xB3\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xF3\xB4\xB3\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xF3\xB4\xB3\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xF3\xB4\xB3\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xF3\xB4\xB3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xF3\xB4\xB3\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xF3\xB4\xB3\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xF3\xB4\xB3\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xF3\xB4\xB3\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xF3\xB4\xB4\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xF3\xB4\xB4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xF3\xB4\xB4\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xF3\xB4\xB4\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xF3\xB4\xB4\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xF3\xB4\xB4\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xF3\xB4\xB4\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xF3\xB4\xB4\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xF3\xB4\xB4\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xF3\xB4\xB4\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xF3\xB4\xB4\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xF3\xB4\xB4\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xF3\xB4\xB4\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xF3\xB4\xB4\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xF3\xB4\xB4\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xF3\xB4\xB4\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xF3\xB4\xB4\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xF3\xB4\xB4\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xF3\xB4\xB4\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xF3\xB4\xB4\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xF3\xB4\xB4\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xF3\xB4\xB4\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xF3\xB4\xB4\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xF3\xB4\xB4\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xF3\xB4\xB4\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xF3\xB4\xB4\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xF3\xB4\xB4\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xF3\xB4\xB4\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xF3\xB4\xB5\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xF3\xB4\xB5\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xF3\xB4\xB5\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xF3\xB4\xB5\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xF3\xB4\xB5\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xF3\xB4\xB5\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xF3\xB4\xB5\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xF3\xB4\xB5\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xF3\xB4\xB5\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xF3\xB4\xB5\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xF3\xB4\xB5\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xF3\xB4\xB5\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xF3\xB4\xB5\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xF3\xB4\xB5\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xF3\xB4\xB5\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xF3\xB4\xB5\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xF3\xB4\xB5\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xF3\xB4\xB5\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xF3\xB4\xB5\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xF3\xB4\xB5\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xF3\xB4\xB5\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xF3\xB4\xB6\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xF3\xB4\xB6\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xF3\xB4\xB6\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xF3\xB4\xB6\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xF3\xB4\xB6\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xF3\xB4\xB6\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xF3\xB4\xB6\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xF3\xB4\xB6\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xF3\xB4\xB6\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xF3\xB4\xB6\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xF3\xB4\xB6\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xF3\xB4\xB6\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xF3\xB4\xB6\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xF3\xB4\xB6\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xF3\xB4\xB6\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xF3\xB4\xB6\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xF3\xB4\xB6\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xF3\xB4\xB6\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xF3\xB4\xB6\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xF3\xB4\xB6\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xF3\xB4\xB6\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xF3\xB4\xB6\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xF3\xB4\xB6\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xF3\xB4\xB6\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xF3\xB4\xB6\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xF3\xB4\xB6\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xF3\xB4\xB6\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xF3\xB4\xB6\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xF3\xB4\xB6\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xF3\xB4\xB6\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xF3\xB4\xB6\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xF3\xB4\xB6\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xF3\xB4\xB6\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xF3\xB4\xB6\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xF3\xB4\xB7\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xF3\xB4\xB7\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xF3\xB4\xB7\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xF3\xB4\xB7\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xF3\xB4\xB7\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xF3\xB4\xB7\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xF3\xB4\xB7\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xF3\xB4\xB7\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xF3\xB4\xB7\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xF3\xB4\xB7\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xF3\xB4\xB7\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xF3\xB4\xB7\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xF3\xB4\xB7\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xF3\xB4\xB7\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xF3\xB4\xB7\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xF3\xB4\xB7\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xF3\xB4\xB7\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xF3\xB4\xB7\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xF3\xB4\xB7\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xF3\xB4\xB7\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xF3\xB4\xB7\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xF3\xB4\xB7\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xF3\xB4\xB7\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xF3\xB4\xB7\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xF3\xB4\xB8\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xF3\xB4\xB8\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xF3\xB4\xB8\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xF3\xB4\xB8\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xF3\xB4\xB8\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xF3\xB4\xB8\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xF3\xB4\xB8\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xF3\xB4\xB8\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xF3\xB4\xB8\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xF3\xB4\xB8\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xF3\xB4\xB8\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xF3\xB4\xB9\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xF3\xB4\xB9\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xF3\xB4\xB9\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xF3\xB4\xB9\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xF3\xB4\xB9\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xF3\xB4\xB9\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xF3\xB4\xB9\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xF3\xB4\xB9\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xF3\xB4\xB9\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xF3\xB4\xB9\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xF3\xB4\xB9\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xF3\xB4\xB9\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xF3\xB4\xB9\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xF3\xB4\xB9\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xF3\xB4\xB9\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xF3\xB4\xB9\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xF3\xB4\xB9\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xF3\xB4\xB9\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xF3\xB4\xB9\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xF3\xB4\xB9\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xF3\xB4\xB9\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xF3\xB4\xB9\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xF3\xB4\xB9\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xF3\xB4\xB9\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xF3\xB4\xBA\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xF3\xB4\xBA\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xF3\xB4\xBA\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xF3\xB4\xBA\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xF3\xB4\xBA\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xF3\xB4\xBA\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xF3\xB4\xBA\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xF3\xB4\xBA\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xF3\xB4\xBA\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xF3\xB4\xBA\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xF3\xB4\xBA\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD6"],
        ["\xF3\xB4\xBA\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xDB"],
        ["\xF3\xB4\xBA\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xE3"],
        ["\xF3\xB4\xBA\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xE6"],
        ["\xF3\xB4\xBA\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xE8"],
        ["\xF3\xB4\xBA\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xEC"],
        ["\xF3\xB4\xBA\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xF3\xB4\xBA\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xF1"],
        ["\xF3\xB4\xBA\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xFE"],
        ["\xF3\xB4\xBA\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xF3\xB4\xBA\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xF3\xB4\xBA\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xF3\xB4\xBA\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xF3\xB4\xBA\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xF3\xB4\xBA\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xF3\xB4\xBA\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xF3\xB4\xBA\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xF3\xB4\xBA\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xF3\xB4\xBB\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xF3\xB4\xBB\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xF3\xB4\xBB\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xF3\xB4\xBB\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xF3\xB4\xBB\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xF3\xB4\xBB\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xF3\xB4\xBB\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xF3\xB4\xBB\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xF3\xB4\xBB\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xF3\xB4\xBB\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xF3\xB4\xBB\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xF3\xB4\xBB\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xF3\xB4\xBB\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xF3\xB4\xBB\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xF3\xB4\xBB\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xF3\xB4\xBB\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xF3\xB4\xBB\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xF3\xB4\xBB\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xF3\xB4\xBB\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xF3\xB4\xBB\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xF3\xB4\xBB\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xF3\xB4\xBB\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xF3\xB4\xBB\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xF3\xB4\xBC\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xF3\xB4\xBC\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xF3\xB4\xBC\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xF3\xB4\xBC\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xF3\xB4\xBC\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xF3\xB4\xBC\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xF3\xB4\xBC\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xF3\xB4\xBC\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xF3\xB4\xBC\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xF3\xB4\xBC\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xF3\xB4\xBC\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xF3\xB4\xBC\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xF3\xB4\xBC\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xF3\xB4\xBC\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xF3\xB4\xBC\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xF3\xB4\xBC\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xF3\xB4\xBC\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xF3\xB4\xBC\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xF3\xB4\xBC\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xF3\xB4\xBC\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xF3\xB4\xBC\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xF3\xB4\xBC\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xF3\xB4\xBC\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xF3\xB4\xBC\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xF3\xB4\xBC\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xF3\xB4\xBC\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x3F"],
        ["\xF3\xB4\xBC\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xF3\xB4\xBC\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xF3\xB4\xBC\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xF3\xB4\xBD\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xF3\xB4\xBD\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xF3\xB4\xBD\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xF3\xB4\xBD\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xF3\xB4\xBD\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xF3\xB4\xBD\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xF3\xB4\xBD\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xF3\xB4\xBD\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xF3\xB4\xBD\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xF3\xB4\xBD\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xF3\xB4\xBD\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xF3\xB4\xBD\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xF3\xB4\xBD\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xF3\xB4\xBD\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xF3\xB4\xBD\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xF3\xB4\xBD\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xF3\xB4\xBD\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xF3\xB4\xBD\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xF3\xB4\xBD\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xF3\xB4\xBD\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xF3\xB4\xBD\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xF3\xB4\xBD\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xF3\xB4\xBD\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xF3\xB4\xBD\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xF3\xB4\xBE\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xF3\xB4\xBE\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xF3\xB4\xBE\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39\x6D"],
        ["\xF3\xB4\xBE\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xF3\xB4\xBE\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xF3\xB4\xBE\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xF3\xB4\xBE\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xF3\xB4\xBE\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xF3\xB4\xBE\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xF3\xB4\xBE\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xF3\xB4\xBE\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xF3\xB4\xBE\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xF3\xB4\xBE\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xF3\xB4\xBE\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xF3\xB4\xBE\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xF3\xB4\xBE\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xF3\xB4\xBE\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xF3\xB4\xBE\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xF3\xB4\xBF\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xF3\xB4\xBF\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xF3\xB4\xBF\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xF3\xB4\xBF\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xF3\xB4\xBF\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xF3\xB4\xBF\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xF3\xB4\xBF\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xF3\xB4\xBF\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xF3\xB4\xBF\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xF3\xB4\xBF\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xF3\xB4\xBF\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xF3\xB4\xBF\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xF3\xB4\xBF\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xF3\xB4\xBF\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xF3\xB4\xBF\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xF3\xB4\xBF\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xF3\xB5\x80\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xF3\xB5\x80\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xF3\xB5\x80\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xF3\xB5\x80\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xF3\xB5\x80\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xF3\xB5\x80\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xF3\xB5\x80\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xF3\xB5\x80\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xF3\xB5\x80\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xF3\xB5\x80\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xF3\xB5\x81\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xF3\xB5\x81\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xF3\xB5\x81\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xF3\xB5\x81\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xF3\xB5\x81\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xF3\xB5\x81\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xF3\xB5\x81\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xF3\xB5\x81\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xF3\xB5\x81\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xF3\xB5\x81\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xF3\xB5\x81\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xF3\xB5\x81\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xF3\xB5\x82\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xF3\xB5\x82\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xF3\xB5\x82\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xF3\xB5\x82\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xF3\xB5\x82\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xF3\xB5\x82\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xF3\xB5\x82\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xF3\xB5\x82\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xF3\xB5\x82\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xF3\xB5\x82\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xF3\xB5\x82\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xF3\xB5\x82\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xF3\xB5\x82\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xF3\xB5\x83\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xF3\xB5\x83\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xF3\xB5\x83\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xF3\xB5\x83\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xF3\xB5\x83\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xF3\xB5\x83\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xF3\xB5\x83\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xF3\xB5\x83\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xF3\xB5\x83\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xF3\xB5\x84\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xF3\xB5\x84\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xF3\xB5\x84\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xF3\xB5\x84\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xF3\xB5\x84\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xF3\xB5\x84\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xF3\xB5\x84\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xF3\xB5\x84\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xF3\xB5\x84\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xF3\xB5\x84\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xF3\xB5\x84\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xF3\xB5\x84\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xF3\xB5\x84\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xF3\xB5\x84\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xF3\xB5\x84\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xF3\xB5\x84\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xF3\xB5\x85\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xF3\xB5\x85\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xF3\xB5\x85\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xF3\xB5\x85\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xF3\xB5\x85\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xF3\xB5\x85\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xF3\xB5\x85\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xF3\xB5\x85\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xF3\xB5\x85\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xF3\xB5\x85\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xF3\xB5\x85\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xF3\xB5\x85\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xF3\xB5\x85\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xF3\xB5\x85\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xF3\xB5\x86\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xF3\xB5\x86\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xF3\xB5\x86\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xF3\xB5\x86\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xF3\xB5\x86\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xF3\xB5\x86\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xF3\xB5\x86\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xF3\xB5\x86\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xF3\xB5\x86\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xF3\xB5\x86\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xF3\xB5\x86\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xF3\xB5\x86\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xF3\xB5\x86\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xF3\xB5\x86\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xF3\xB5\x86\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xF3\xB5\x86\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xF3\xB5\x86\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xF3\xB5\x86\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xF3\xB5\x86\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xF3\xB5\x86\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xF3\xB5\x86\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xF3\xB5\x87\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xF3\xB5\x87\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xF3\xB5\x87\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xF3\xB5\x87\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xF3\xB5\x87\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xF3\xB5\x87\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xF3\xB5\x87\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xF3\xB5\x87\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xF3\xB5\x87\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xF3\xB5\x87\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xF3\xB5\x87\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xF3\xB5\x87\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xF3\xB5\x87\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xF3\xB5\x88\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xF3\xB5\x88\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xF3\xB5\x88\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xF3\xB5\x88\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xF3\xB5\x88\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xF3\xB5\x88\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xF3\xB5\x88\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xF3\xB5\x88\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xF3\xB5\x88\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xF3\xB5\x88\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xF3\xB5\x88\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xF3\xB5\x88\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xF3\xB5\x88\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xF3\xB5\x88\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xF3\xB5\x88\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xF3\xB5\x88\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xF3\xB5\x88\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xF3\xB5\x88\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xF3\xB5\x88\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xF3\xB5\x89\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xF3\xB5\x89\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xF3\xB5\x89\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xF3\xB5\x89\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xF3\xB5\x89\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xF3\xB5\x89\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xF3\xB5\x89\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xF3\xB5\x89\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xF3\xB5\x89\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xF3\xB5\x89\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xF3\xB5\x8A\x83",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xF3\xB5\x8A\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xF3\xB5\x8A\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xF3\xB5\x8A\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xF3\xB5\x8A\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xF3\xB5\x8A\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xF3\xB5\x8A\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xF3\xB5\x8A\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xF3\xB5\x8A\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xF3\xB5\x8A\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xF3\xB5\x8A\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xF3\xB5\x8A\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xF3\xB5\x8B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xF3\xB5\x8B\x82",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xF3\xB5\x8B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xF3\xB5\x8B\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xF3\xB5\x8B\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xF3\xB5\x8B\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xF3\xB5\x8B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xF3\xB5\x8B\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xF3\xB5\x8B\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xF3\xB5\x8B\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xF3\xB5\x8B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xF3\xB5\x8B\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xF3\xB5\x8B\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xF3\xB5\x8B\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xF3\xB5\x8B\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xF3\xB5\x8B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xF3\xB5\x8B\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xF3\xB5\x8B\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xF3\xB5\x8B\xBF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xF3\xB5\x8C\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xF3\xB5\x8C\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xF3\xB5\x8C\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xF3\xB5\x8C\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xF3\xB5\x8C\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xF3\xB5\x8C\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xF3\xB5\x8C\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xF3\xB5\x8C\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xF3\xB5\x8C\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xF3\xB5\x8C\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xF3\xB5\x8C\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xF3\xB5\x8C\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xF3\xB5\x8C\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xF3\xB5\x8C\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xF3\xB5\x8C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xF3\xB5\x8C\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xF3\xB5\x8C\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xF3\xB5\x8D\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xF3\xB5\x8D\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xF3\xB5\x8D\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xF3\xB5\x8D\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xF3\xB5\x8D\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xF3\xB5\x8D\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xF3\xB5\x8D\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xF3\xB5\x8D\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xF3\xB5\x8D\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xF3\xB5\x8D\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xF3\xB5\x8D\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xF3\xB5\x8D\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xF3\xB5\x8D\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xF3\xB5\x8D\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xF3\xB5\x8E\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xF3\xB5\x8E\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xF3\xB5\x8E\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xF3\xB5\x8E\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xF3\xB5\x8E\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xF3\xB5\x8E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xF3\xB5\x8E\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xF3\xB5\x8E\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xF3\xB5\x8E\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xF3\xB5\x8E\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xF3\xB5\x8E\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xF3\xB5\x8E\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xF3\xB5\x8E\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xF3\xB5\x8E\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xF3\xB5\x8E\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xF3\xB5\x8F\x85",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xF3\xB5\x8F\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xF3\xB5\x8F\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xF3\xB5\x8F\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xF3\xB5\x8F\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xF3\xB5\x8F\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xF3\xB5\x8F\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xF3\xB5\x8F\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xF3\xB5\x8F\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xF3\xB5\x8F\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xF3\xB5\x8F\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xF3\xB5\x8F\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xF3\xB5\x8F\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xF3\xB5\x8F\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xF3\xB5\x8F\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xF3\xB5\x8F\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xF3\xB5\x8F\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xF3\xB5\x8F\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xF3\xB5\x8F\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xF3\xB5\x8F\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xF3\xB5\x8F\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xF3\xB5\x90\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xF3\xB5\x90\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xF3\xB5\x90\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xF3\xB5\x90\x96",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xF3\xB5\x90\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xF3\xB5\x90\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xF3\xB5\x90\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xF3\xB5\x90\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\xF3\xB5\x90\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xF3\xB5\x90\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xF3\xB5\x90\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xF3\xB5\x91\x80",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xF3\xB5\x91\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xF3\xB5\x91\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xF3\xB5\x91\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xF3\xB5\x91\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xF3\xB5\x91\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xF3\xB5\x91\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xF3\xB5\x91\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xF3\xB5\x91\xAF",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xF3\xB5\x91\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xF3\xB5\x91\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xF3\xB5\x91\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xF3\xB5\x92\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xF3\xB5\x92\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xF3\xB5\x92\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xF3\xB5\x92\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xF3\xB5\x92\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xF3\xB5\x92\x91",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xF3\xB5\x92\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xF3\xB5\x92\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xF3\xB5\x92\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xF3\xB5\x92\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xF3\xB5\x92\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xF3\xB5\x92\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xF3\xB5\x92\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xF3\xB5\x92\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xF3\xB5\x92\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xF3\xB5\x92\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xF3\xB5\x92\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xF3\xB5\x92\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xF3\xB5\x92\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xF3\xB5\x92\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xF3\xB5\x92\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xF3\xB5\x93\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xF3\xB5\x93\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xF3\xB5\x93\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xF3\xB5\x93\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xF3\xB5\x93\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xF3\xB5\x93\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xF3\xB5\x93\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xF3\xB5\x93\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xF3\xB5\x93\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xF3\xB5\x93\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xF3\xB5\x93\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xF3\xB5\x93\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xF3\xB5\x93\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xF3\xB5\x93\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xF3\xB5\x93\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xF3\xB5\x93\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xF3\xB5\x94\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xF3\xB5\x94\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xF3\xB5\x94\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xF3\xB5\x94\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xF3\xB5\x94\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xF3\xB5\x94\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xF3\xB5\x94\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xF3\xB5\x94\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xF3\xB5\x94\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xF3\xB5\x94\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xF3\xB5\x94\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xF3\xB5\x94\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xF3\xB5\x95\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xF3\xB5\x95\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xF3\xB5\x95\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xF3\xB5\x95\x8A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xF3\xB5\x95\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xF3\xB5\x95\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xF3\xB5\x95\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xF3\xB5\x95\x9A",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xF3\xB5\x95\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xF3\xB5\x95\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xF3\xB5\x95\xA1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xF3\xB5\x95\xA2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xF3\xB5\x95\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xF3\xB5\x95\xB0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xF3\xB5\x95\xB2",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xF3\xB5\x95\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xF3\xB5\x95\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xF3\xB5\x95\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xF3\xB5\x95\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xF3\xB5\x96\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xF3\xB5\x96\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xF3\xB5\x96\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xF3\xB5\x96\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xF3\xB5\x96\xAC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xF3\xB5\x96\xB4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xF3\xB5\x96\xB5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xF3\xB5\x96\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xF3\xB5\x96\xBA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xF3\xB5\x97\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xF3\xB5\x97\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xF3\xB5\x97\xA7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xF3\xB5\x97\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xF3\xB5\x97\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xF3\xB5\x97\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xF3\xB5\x97\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xF3\xB5\x98\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xF3\xB5\x98\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xF3\xB5\x98\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xF3\xB5\x99\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xF3\xB5\x99\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xF3\xB5\x99\x8C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xF3\xB5\x99\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xF3\xB5\x99\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xF3\xB5\x99\xAE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xF3\xB5\x99\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xF3\xB5\x9A\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xF3\xB5\x9A\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xF3\xB5\x9A\x8D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xF3\xB5\x9A\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xF3\xB5\x9A\x94",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xF3\xB5\x9A\x95",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xF3\xB5\x9A\x9F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xF3\xB5\x9A\xA4",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xF3\xB5\x9A\xA6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xF3\xB5\x9A\xB3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xF3\xB5\x9A\xB6",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xF3\xB5\x9B\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xF3\xB5\x9B\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xF3\xB5\x9B\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xF3\xB5\x9B\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xF3\xB5\x9B\x8E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xF3\xB5\x9B\x8F",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xF3\xB5\x9B\x97",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xF3\xB5\x9B\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xF3\xB5\x9B\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xF3\xB5\x9B\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xF3\xB5\x9B\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xF3\xB5\x9B\xB7",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xF3\xB5\x9B\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xF3\xB5\x9C\x81",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xF3\xB5\x9C\xBB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xFB"],
        ["\xF3\xB5\x9D\x87",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xF3\xB5\x9E\x8B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xF3\xB5\x9E\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xF3\xB5\x9F\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xF3\xB5\x9F\xA5",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xF3\xB5\x9F\xAD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xF3\xB5\xA0\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xF3\xB5\xA0\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xF3\xB5\xA0\x9B",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xF3\xB5\xA1\xAA",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xF3\xB5\xA1\xB8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xF3\xB5\xA1\xBC",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xF3\xB5\xA2\x88",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xF3\xB5\xA2\x90",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xF3\xB5\xA2\x93",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xF3\xB5\xA2\x98",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xF3\xB5\xA2\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xF3\xB5\xA2\x9D",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xF3\xB5\xA2\xA8",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xF3\xB5\xA2\xA9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xF3\xB5\xA2\xAB",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xF3\xB5\xA2\xB9",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xF3\xB5\xA2\xBD",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xF3\xB5\xA2\xBE",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xF3\xB5\xA3\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xF3\xB5\xA3\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xF3\xB5\xA3\x92",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xF3\xB5\xA3\x99",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xF3\xB5\xA3\x9C",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xF3\xB5\xA3\x9E",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xF3\xB5\xA3\xA0",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xF3\xB5\xA3\xA3",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xF3\xB5\xA3\xB1",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xF3\xB5\xA4\x84",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xF3\xB5\xA4\x86",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xF3\xB5\xA4\x89",'jipsj','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
