<!--

@license CC-BY-SA-4.0

-->

# Code of Conduct

> A Code of Conduct to foster a more open, positive, welcoming, and friendly community.

This project is not simply a collection of technologies, but also a community.

This Code of Conduct outlines (1) our expectations for everyone who participates inside our community, (2) our expectations for everyone who participates outside our community when an individual is representing the project and/or our community (including, but not limited to, conferences, trade shows, other public events, mailing lists, social media, IRC channels, and GitHub repositories), and (3) the consequences for unacceptable behavior.

Anyone who violates this Code of Conduct will be reprimanded and possibly banned from the community.

## Scope

We expect all community participants, including paid and unpaid contributors, sponsors, users, and affiliated members, to abide by this Code of Conduct at **all** times in **all** community venues, online and in person, and in one-on-one communications.

This Code of Conduct covers the usage of the project, as well as the project website, project related events, and any other affiliated services. This Code of Conduct and its related policies also applies to behavior **outside** the scope of community activities, including but not limited to GitHub repositories, IRC channels, social media, mailing lists, and public events, when such behavior has the potential to adversely affect the safety and well-being of community members either through threats of violence or targeted harassment as pertains to gender identity, sexual orientation, ability, ethnicity, religion, age, physical appearance, body size, race, or other personal characteristics.

This Code of Conduct is in addition to, and does **not** in any way nullify or invalidate, any other terms or conditions related to use of the project.

Any disputes involving definitions of contentious terms such as "discriminatory", "hateful", or "confusing" will be decided at the sole discretion of the project owners.

## Expected Behavior

We are committed to providing a friendly, safe, and welcoming environment for all, regardless of level of experience, gender, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, nationality, or other personal characteristic.

We ask that you respect that people have differences of opinion regarding technical choices, and that every design or implementation choice carries a trade-off and numerous costs. There is seldom a single right answer. A difference of technology preferences is **never** a license to be rude.

The following behaviors are **expected** of **all** community members:

-   Be careful in the words you choose.
-   Use welcoming and inclusive language.
-   Refrain from demeaning, discriminatory, or harassing behavior and speech.
-   Avoid sarcasm in **any** form. What is considered benign by you is seen as caustic by others. 
-   Be respectful of differing viewpoints and experiences.
-   Resist the urge to be defensive if someone takes issue with something you said or did. Even if you feel misinterpreted or unfairly accused, in all likelihood, you probably could have communicated better. **Remember**: it is **your** responsibility to make fellow community members comfortable and feel respected.
-   Keep unstructured critique to a minimum. If you have solid contribution ideas, make a fork, experiment, and evaluate accordingly.
-   Gracefully accept constructive criticism.
-   Attempt collaboration before conflict.
-   Always be professional.
-   Show empathy toward other community members.
-   Focus on what is best for the community.

## Unacceptable Behavior

The following behaviors are considered harassment, are unacceptable within our community, and will **not** be tolerated:

-   Personal insults.
-   Deliberate intimidation.
-   Harmful or prejudicial verbal or written comments related to gender identity, sexual orientation, ability, ethnicity, religion, age, physical appearance, body size, race, or other personal characteristics.
-   Deliberate "outing" of any aspect of a person's identity without their consent, except as necessary to protect others from intentional abuse.
-   Unwelcome comments regarding a person's lifestyle choices and practices, including those related to food, health, parenting, drugs, and employment.
-   Deliberate misgendering. This includes deadnaming or persistently using a pronoun that does not correctly reflect a person's gender identity.
-   Posting or displaying sexually explicit or violent material.
-   Posting or threatening to post personally identifying information ("doxing").
-   Stalking or following (online or in person).
-   Any spamming, trolling, flaming, baiting, or other attention-stealing behavior.
-   Harassing photography or recording, including logging online activity for harassment purposes.
-   Violence, threats of violence (physical or psychological), or violent language.
-   Public or private harassment.
-   Unwelcome sexual attention, including gratuitous or off-topic sexual images or behavior.
-   Physical or simulated contact without consent or after a request to stop.
-   Continued one-on-one communication after requests to cease.
-   Publication of non-harassing private communication.
-   Sustained disruption of discussion.
-   Any other conduct which could reasonably be considered inappropriate in a professional setting.
-   Advocating for, or encouraging, any of the above behavior, including but not limited to "liking", "starring", "retweeting", or any other form of promotion.

Note that your free speech is not **our** problem. That this policy is a restrictive political stance is intentional. If you want different rules, go create a separate project.

## Enforcement

Unacceptable behavior from any community member, including users, sponsors, project owners, and those with decision-making authority, will **not** be tolerated. Anyone asked to stop unacceptable behavior is expected to comply **immediately**.

If an individual engages in unacceptable behavior, the project owners may take **any** action they deem appropriate, up to and including a temporary ban or permanent ban from the community without warning.

Note that any individual found to have previously engaged in abusive behavior in **any** form inside **or** outside the community should expect **zero** tolerance for **any** violation of this Code of Conduct.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

Project owners are held to a higher standard than other community members. If an owner creates an inappropriate situation, they should expect **much less** leeway than others.

## Reporting

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the [reporting team][reporting]. In your report, please include

-   Your contact information.
-   Names (real, nicknames, or pseudonyms) of any individuals involved. If available, any additional witnesses.
-   An account of what occurred, and if you believe the incident is ongoing.
-   If available, a public record (e.g., a link to a mailing list archive, public IRC logger, Tweet, or issue thread).
-   Any prior records of behavior either inside or outside the community which can be used to establish prior precedent.
-   Any additional information that may be helpful.

All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate. Complaint recipients are obligated to maintain confidentiality with regard to the reporter of an incident. 

If an accused person is part of the reporting team, they will recuse themselves from handling your incident. If the reporter is a reporting team member, the complaint will be handled by a different member of the reporting team.

Note that we reserve the right to reject any report we believe to have been made in bad faith. Reports intended to silence legitimate criticism or differences in opinion may be ignored without response.

Further details of specific enforcement policies may be posted separately.

## Grievances

Publicly complaining about repercussions is **not** tolerated. All complaints should be handled through **private** channels with project owners.

If you feel you have been falsely or unfairly accused of violating this Code of Conduct, you should contact the project owners. We will do our best to ensure that your grievance is handled appropriately.

Note that we prioritize marginalized people's safety over privileged people's comfort. We will **not** act on complaints regarding:

-   "Reverse"-isms, including "reverse racism," "reverse sexism," and "cisphobia"
-   Reasonable communication of boundaries, such as "leave me alone," "go away," or "I'm not discussing this with you."
-   Refusal to explain or debate social justice concepts.
-   Communicating in a "tone" you do not find congenial.
-   Criticizing racist, sexist, cissexist, or otherwise oppressive behavior or assumptions.

## Changes

This is a living document and may be updated over time. Refer to the [git history for this document][git-history] to view changes.

## Attribution

This Code of Conduct borrows heavily from 

-   [npm Code of Conduct][npm-code-of-conduct]
-   [#node.js IRC policy on trolling][nodejs-irc]
-   Stumptown Syndicate [Citizen Code of Conduct][citizen-code-of-conduct]
-   Geek Feminism [Code of Conduct][geek-feminism-code-of-conduct]
-   [Contributor Covenant][contributor-covenant]
-   [Open Code of Conduct][open-code-of-conduct]
-   [The Rust Code of Conduct][rust-code-of-conduct]

## License

This document may be reused under a [Creative Commons Attribution-ShareAlike License][license].

[git-history]: https://github.com/stdlib-js/stdlib/commits/develop/CODE_OF_CONDUCT.md

[npm-code-of-conduct]: https://docs.npmjs.com/policies/conduct

[nodejs-irc]: https://blog.izs.me/2012/08/policy-on-trolling

[citizen-code-of-conduct]: https://github.com/stumpsyn/policies/blob/7caa4699ba74e341a46b3266d4610af477ba2c3d/citizen_code_of_conduct.md

[geek-feminism-code-of-conduct]: https://geekfeminismdotorg.wordpress.com/about/code-of-conduct/

[contributor-covenant]: https://www.contributor-covenant.org/version/2/1/code_of_conduct/code_of_conduct.md

[open-code-of-conduct]: https://github.com/todogroup/opencodeofconduct

[rust-code-of-conduct]: https://www.rust-lang.org/policies/code-of-conduct

[license]: https://creativecommons.org/licenses/by-sa/4.0/

[reporting]: mailto:kgryte@gmail.com
