## TFSA-2021-153: Heap OOB in nested `tf.map_fn` with `RaggedTensor`s

### CVE Number
CVE-2021-37679

### Impact
It is possible to nest a `tf.map_fn` within another `tf.map_fn` call. However,
if the input tensor is a `RaggedTensor` and there is no function signature
provided, code assumes the output is a fully specified tensor and fills output
buffer with uninitialized contents from the heap:

```python
import tensorflow as tf
x = tf.ragged.constant([[1,2,3], [4,5], [6]])
t = tf.map_fn(lambda r: tf.map_fn(lambda y: r, r), x)
z = tf.ragged.constant([[[1,2,3],[1,2,3],[1,2,3]],[[4,5],[4,5]],[[6]]])
```

The `t` and `z` outputs should be identical, however this is not the case. The
last row of `t` contains data from the heap which can be used to leak other
memory information.

The bug lies in the conversion from a `Variant` tensor to a `RaggedTensor`. The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/ragged_tensor_from_variant_op.cc#L177-L190)
does not check that all inner shapes match and this results in the additional
dimensions in the above example.

The same implementation can result in data loss, if input tensor is tweaked:

```python
import tensorflow as tf
x = tf.ragged.constant([[1,2], [3,4,5], [6]])
t = tf.map_fn(lambda r: tf.map_fn(lambda y: r, r), x)
```

Here, the output tensor will only have 2 elements for each inner dimension.

### Patches
We have patched the issue in GitHub commit
[4e2565483d0ffcadc719bd44893fb7f609bb5f12](https://github.com/tensorflow/tensorflow/commit/4e2565483d0ffcadc719bd44893fb7f609bb5f12).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Haris Sahovic.
