#include "pamc_private.h"

/*
 * Copyright (c) 1998 Andrew G. Morgan <morgan@linux.kernel.org>
 * All rights reserved.
 *
 * The license for this source code should accompany this file.  Its
 * md5 checksum is: cac41ac118b52c96cf248baec7237381
 */

/*
 * This code initializes the pamc path variable and returns a handle
 * for it.
 */

pamc_handle_t pamc_set_path(const char *path)
{
    struct pamc_handle_struct *phc;

    /* Has a path been specified? */

    if (path == NULL) {
	path = PAMC_DEFAULT_PATH;
    } else {
	/* XXX - this will change when we can parse "path1:path2:..." */
	return NULL;
    }

    phc = malloc(sizeof(struct pamc_handle_struct));
    if (phc == NULL) {
	return NULL;         /* out of memory */
    }

    phc->path = strdup(path);
    if (phc->path == NULL) {
	free(phc);
	return NULL;
    }

    phc->stack = NULL;
    phc->current = NULL;

    /* all done. */
    return phc;
}

