#!/usr/local/bin/perl
#
# LField.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package LField;

@LField::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;

	my $object_id = $cgi->param("_objectid"); # Here we know which connector we are using ==> objectid
	return undef unless $object_id;
	$self->_hiddenvar ("_objectid", $object_id); # Save for next page load

	my $query = $dbh->newquery({ object_id => $object_id }); 
	$query->sconnectorlist();
	my $connector = $dbh->hexecfetchrownop($query, 1);

	foreach my $field (keys %{$connector}) { $self->_datavar($field, $connector->{$field}); } # the Data Hash contain the connector


	my $container;
	my $containerid;
	if ($containerid = $cgi->param("_selectedoid")) {
		$query = $dbh->newquery({ object_id => $containerid });
		$query->scontainerlist();
		$container = $dbh->hexecfetchrownop($query, 1);
	}
	$container->{ name } = $cgi->param("_selectedname");
	$container->{ name } =~ s/[^[:alnum:]]/_/g;
	$container->{ name } = "Unnamed____" unless ($container->{ name });
	$container->{ name } = "A_" . $container->{ name } unless ($container->{ name } =~ /^[[:alpha:]]/);
	$container->{ externalname } = $cgi->param("_selectedexternalname");
	$container->{ owner } = $cgi->param("_selectedowner");
	$container->{ externalschema } = $cgi->param("_selectedowner");
	$container->{ type } = $cgi->param("_selectedtype");
	$container->{ externaltype } = $cgi->param("_selectedtype");
	$container->{ remarks } = $cgi->param("_selectedremarks");
	$self->{_container} = $container;

	$self->{_list1} = $self->describeContainer($dbh, $conf, $connector, $container);

	$self->{list1count} = $#{$self->{_list1}} + 1;

	if ($self->_datavar("driverid")) {
		$query = $dbh->newquery( { "driverid" => $self->_datavar("driverid") });
		$query->sdatatypelist();
	}
	else {
		$query = $dbh->newquery();
		$query->sdatatypeliststd();
	}
	$self->{_datatypelist} = $dbh->hexecfetchall($query);
	#list tables.
}

sub meth_import {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	my $updateexisting = $cgi->param("updateexisting");

	my $connectorid = $cgi->param("connectorid");
	
	my $container = $self->getContainerData($cgi, $dbh);

	my $fields = $self->getFieldsData($cgi,$dbh);

	my $ifld = -1;
	my $fldmsg;
	my $message = "Importing the structure of the container $container->{name}/$container->{externalname}";
	$message .= " Internal Id is $container->{object_id}" if ($container->{object_id});
	if ($updateexisting) {
		$container->{parent_id} = $connectorid;
		my $ret = $self->updateContainer($cgi, $dbh, $container);
		if ($ret and ($ret > 0)) {
			$message .= "<BR><FONT COLOR= \"BLUE\"><B> ==== Container updated ====</B></FONT>";
			foreach my $fld (@$fields) {
				$ifld++;
				$fldmsg = " while updating $fld->{name}/$fld->{externalname} (order = $ifld)";
				$fld->{parent_id} = $container->{object_id};
				if ($fld->{object_id}) { $self->updateField($cgi, $dbh, $fld); }
				else { $ret = $self->createField ($cgi, $dbh, $fld); }
				last unless ($ret and ($ret > 0));
			}
			if ($ret and ($ret > 0)) { $message .= "<BR><FONT COLOR= \"BLUE\"><B> $ifld field(s) successfully updated</B></FONT>"; }
			else { $message .= "<BR><FONT COLOR= \"RED\"><B> Failed $fldmsg </B></FONT>", $dbh->errstr(); }
		}
		else {
			$message .= "<BR><FONT COLOR= \"RED\"><B> Failed to update the container</B></FONT>, reason : ", $dbh->errstr();
		}
		$dbh->commit() if ($ret);
	}
	else {
		$container->{parent_id} = $connectorid;
		my $ret = $self->createContainer($cgi, $dbh, $container);
		if ($ret and ($ret > 0)) {
			$message .= "<BR><FONT COLOR= \"BLUE\"><B> ==== Container created ====</B></FONT>";
			foreach my $fld (@$fields) {
				$ifld++;
				$fldmsg = " while creating $fld->{name}/$fld->{externalname} (order = $ifld)";
				$fld->{parent_id} = $container->{object_id};
				$ret = $self->createField ($cgi, $dbh, $fld);
				last unless ($ret and ($ret > 0));
			}
			if ($ret and ($ret > 0)) { $message .= "<BR><FONT COLOR= \"BLUE\"><B> $ifld field(s) successfully created</B></FONT>"; }
			else { $message .= "<BR><FONT COLOR= \"RED\"><B> Failed $fldmsg </B></FONT>", $dbh->errstr(); }
		}
		else {
			$message .= "<BR><FONT COLOR= \"RED\"><B> Failed to create the container</B></FONT>, reason : ", $dbh->errstr();
		}
		$dbh->commit() if ($ret);
	}
	$self->_systemvar("_INFO", $message);
	$self->_systemvar("_redirect", "connectorl");

}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	my $object_id = $cgi->param("_objectid");
	return undef unless $object_id;
	$self->_hiddenvar ("_objectid", $object_id);

	my $query = $dbh->newquery({ object_id => $object_id });
	$query->sconnectorlist();
	my $connector = $dbh->hexecfetchrownop($query, 1);


	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'container');
	$self->_hiddenvar ("search1", $cgi->param("search1"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query;
	unless ($self->{_system}{noselect}) {
		$query = $dbh->newquery({ object_id => $self->_datavar("object_id"), id => $self->_datavar("object_id"), });
		$self->_datavar("id", $self->_datavar("object_id"));

		$query->scontainerlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		$query->sobject();
		my $row = $dbh->hexecfetchrow($query, 1);
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		my $objectids = $self->_getmyobjectids(qw(parent_id));
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));

	$self->_datavar("rollbackspace", 'no') unless ($self->_datavar("rollbackspace"));
	$self->_datavar("xcreate", 'no') unless ($self->_datavar("xcreate"));
	$self->_datavar("status", 'online') unless ($self->_datavar("status"));
	$self->_datavar("parent_id", undef) unless ($self->_datavar("parent_id") > 0);

	$self->{_attributeslist} = $self->_getmyattributes($dbh);
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;


	$self->_datavar("object_id", $dbh->nextseq("objects"));
	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->icontainer();
		$ret = $dbh->executefinish($query);
		if ($ret > 0) { $self->_updateattributes(); }
		if ($ret > 0) { $dbh->commit(); }
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ucontainer();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dcontainer();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
