#!/usr/local/bin/perl
#
# Objects.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Objects;

@Objects::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "label" },
	{ fName => "parent_id" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },
	{ fName => "object_id" },
	{ fName => "username", fType => "string", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "password", fType => "password", fMand => 0, fMin => 3, dMax => 30 },
	{ fName => "currentuser" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	my $search3 = $self->{search3};
	$self->{search3} = [ $self->{search3} ] if ($self->{search3});

	my $searchcrit = $self->_hiddenvar("_searchCriteria");
	if ($searchcrit) {
		my @crit = split(/-/, $searchcrit);
		my $critfld = "";
		my @objtypes;
		my @objparents;
		foreach my $crit (@crit) {
			if ($crit eq "__type__") { $critfld = "type"; next; }
			if ($crit eq "__parent__") { $critfld = "parent"; next; }
			if ($critfld eq "type") { push @objtypes, $crit; }
			if ($critfld eq "parent") { push @objparents, $crit; }
		}
		unless ($search3 and ($searchcrit =~ /-$search3/)) { 
			$self->{search3} = \@objtypes if (@objtypes and $#objtypes);
		}
		$self->{search4} = \@objparents if (@objparents and $#objparents);
	}

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "objects.objectlabel" ], "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }

	if ($self->{search3}) { $cond->[++$icond] = [ "objects.type", "in", "('" . join("','",@{$self->{search3}}) . "')" ]; }
	if ($self->{search4}) { $self->{search4} =~ s/[^0-9]*//g; $cond->[++$icond] = [ "objects.parent_id", "in", join(",",@{$self->{search4}}) ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("objects", $cond);
	
	my $query = $dbh->newquery({ namelabel=>$self->{search1}, status=>$self->{search2}, type=>$self->{search3}, parent_id=>$self->{search4} });
	$query->sobjectlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	foreach my $obj (@{$self->{_list1}}) {
		$obj->{__editid} = $obj->{object_id};
		$obj->{__editf} = $obj->{type} . "e";
		$obj->{__func} = "edit";

		if ($obj->{type} eq "subflow") { $obj->{__editf} = "flowes"; $obj->{__editid} = $obj->{parent_id}; $obj->{__func} = "edits"; }
		elsif ($obj->{type} =~ /^sql|^perl/) { $obj->{__editf} = "scriptse"; }
	}

	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	# print "<BR>\nlist1count = $self->{list1count}";
}

=cut
sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'objects');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $self->_datavar("object_id") });
		$query->sobjectslist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $dbh->nextseq("objects"));

	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	my $ret;
	if ($ret = $dbh->executefinish($query)) {
		$query->iobjects();
		$ret = $dbh->executefinish($query);
		if ($ret) { $dbh->commit(); }
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

#	print "<BR>\n heheh  ", $query->query();

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	$query->uobjects();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	$query->dobjects();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}
=cut

1;
