#!/usr/local/bin/perl
#
# cafdDIRSL 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdDIRSL;
 
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdDIRSL::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
	my %dirsl_attrs = (
		record_tag       => $db->{_ATTRS}{RECORD_TAG},
	);
	foreach my $a (keys %dirsl_attrs) {
		if (($dirsl_attrs{$a} !~ /^\\$/) and defined($dirsl_attrs{$a})) { eval "\$dirsl_attrs{$a} = \"$dirsl_attrs{$a}\""; }
	}
	$self->{_DIRSL_ATTRS} = \%dirsl_attrs;
	$self->{dbh}       = DBI->connect("dbi:AnyData(RaiseError=>1):");
	$self;
}

sub dirslattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_DIRSL_ATTRS}{$attrib} = shift; }
	$self->{_DIRSL_ATTRS}{$attrib};
}
		
sub dirslinfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_DIRSLINFO}{$infolabel} = shift; }
	$self->{_DIRSLINFO}{$infolabel};
}

sub cleardirslinfo {
	my $self = shift;

	$self->{_DIRSLINFO} = undef;
	delete $self->{_DIRSLINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};

        $q->_attribute("command", $cmd);
        my $container = $self->{db}{container};
 
 
	my @col_map;
	my %map_col;
	my $colpos = 0;
	my %col_pos;
	foreach my $col (@{$container->{_FIELDS}}) {
		push @col_map, { $col->{externalname} => $col->{name} };
		$map_col{$col->{name}} = $col->{externalname};
		$col_pos{$col->{externalname}} = $colpos;
		$colpos++;
	}
 
	my @acol_names = map { $_->{name} }  @{$container->{_FIELDS}};
	my $scol_names = join(',', @acol_names);
 
	my $name = $container->{name};
	my $externalname = $container->{externalname};
 
	$self->dirslinfo("_NAME", $name);
	$self->dirslinfo("_MODE", $mode);
	$self->dirslinfo("_CMD", $cmd);
	$self->dirslinfo("_EXTERNALNAME", $externalname);
	$self->dirslinfo("_SCOLNAMES", $scol_names);
	$self->dirslinfo("_ACOLNAMES", \@acol_names);
	$self->dirslinfo("_COLMAP", \@col_map);
	$self->dirslinfo("_MAPCOL", \%map_col);
	$self->dirslinfo("_COLPOS", \%col_pos);
}


sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->dirslinfo("_NAME")) {

		$self->preprepare($q);
		my ($cmd, $mode) = ($self->dirslinfo("_CMD"),$self->dirslinfo("_MODE"));
		my $dbh = $self->{dbh};

		if ($cmd eq "select") {
			$self->_dir($self->fullpath($self->dirslinfo("_EXTERNALNAME")));
			my $lines = $self->dirlisting();

			my $col_map = $self->dirslinfo("_COLMAP"); #, \@col_map);
			my $map_col = $self->dirslinfo("_MAPCOL"); #, \%map_col);
			my $col_pos = $self->dirslinfo("_COLPOS"); #, \%col_pos);
			my @rows;
			foreach my $l (@$lines) {
#				RIGHTS     LNK OWNER    GROUP   SIZE      MDATE        NAME
#				drwxr-xr-x   2 1003     501          4096 Jun 22  2002 Desktop
				my $i = 0;
				my @row;
				foreach my $f (GetTableDef()) {
					if (defined($col_pos->{$f}) and $col_map->[$col_pos->{$f}]) {
						$row[$col_pos->{$f}] = $l->[$i];
					}
					$i++;
				}
				push @rows, \@row;
			}
			 $self->dirslinfo("_DATA", \@rows)		
		}
		else { die "Unsuported sql command $cmd"; }
		my $colnames = $self->dirslinfo("_SCOLNAMES");
		$dbh->func($self->dirslinfo("_NAME"), 'ARRAY', $self->dirslinfo("_DATA"), {col_names => $colnames, }, 'ad_catalog'); 
	}
	return $self->SUPER::prepare($q);
}

sub setexternalname {
        my $self = shift;
        my $filename = shift;
	my $container = $self->{db}{container};                                                                                               
	$container->{externalname} = $filename;
        $self->dirslinfo("_EXTERNALNAME", $filename);
}

sub getexternalname {
        my $self = shift;
	my $container = $self->{db}{container};                                                                                               
	$self->dirslinfo("_EXTERNALNAME") || $container->{externalname};
}

sub finalcommit {
	my $self = shift;

	$self->cleardirslinfo();
	return 1;
}

sub finalrollback {
	my $self = shift;

	$self->cleardirslinfo();
	return 1;
}

sub generatequery {
	my $self = shift;

	@cafdDIRSL::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

sub GetTableDef {
	return (qw(FRIGHTS FLINKS FOWNER FGROUP FSIZE FMDATE FNAME FTYPE DIRLINE FDIR));
}

sub describe {
	my $self = shift;
	my $table_name = shift;
 
	my @fields = GetTableDef();
 
	my (@ret, $i);
	foreach my $e (@fields) {
		$i++;
		push @ret, {
				name => $e,
				externalname => $e,
				datatypeid => 'VARCHAR',
				datalength => 100,
				fieldorder => $i*10,
				keyposition  => ($i == 6) ? undef : $i,
		};
	}
 
	\@ret;

}

1;
