#!/usr/local/bin/perl
#
# CTXTCFG.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package CTXTCFG;

#$ENV{ORACLE_HOME} = '/home/ora8i/product';
#$ENV{ORACLE_BASE} = '/home/ora8i/';
#$ENV{LD_LIBRARY_PATH} = $ENV{ORACLE_HOME} . "/lib:" . $ENV{ORACLE_HOME} . "/jdbc/lib";
#$ENV{ORACLE_OWNER} = "ora8i";
#$ENV{CLASSPATH} = $ENV{ORACLE_HOME} . "/jdbc/lib/classes111.zip";

my $refdsn = "dbi:Pg:dbname=cafeterraq;host=localhost;port=5432";
my $refdrv = "Pg";
my $refproto = "DBI";
my $refuser = "aliphe";
my $refpass = "aliphe";
my $refPrintError = 0;
my $refRaiseError = 1;
my $refAutoCommit = 0;

my $cipher        = undef;
my $cipherkey     = undef;

my $printstack = 1;

my $licence    = "Cafeterra Entreprise";

my $basedir    = "/home/app/cafeterra";
my $flowdir        = "/home/app/cafeterra/flowdir";

my $connectpage = "connectpage";
my $menupage    = "menupage";

my $maxlistdisplay = 20;

my $contextid  = "default";
my $contextlabel  = "Default context";

my $conf       = {
	db => {
		connector      => {
			driverid          => $refdrv,
			protocolid        => $refproto,
			dbidsn            => $refdsn,
		},
		user                 => { username => $refuser, password => $refpass, },
		_ATTRS               => {
			PrintError        => $refPrintError,
			RaiseError        => $refRaiseError,
			AutoCommit        => $refAutoCommit,
			_FLOWDIR          => $flowdir,
		},
	},
	_BASEDIR       => $basedir,
	licence        => $licence,
	_printstack    => $printstack,
	maxlistdisplay => $maxlistdisplay,
	defaultpages   => {
		connectpage  => $connectpage,
		menupage     => $menupage,
	},

	contextid      => $contextid,
	contextlabel   => $contextlabel,
};

sub new {
	my $class = shift;
	$class = ref($class) || $class;
	my $self = $conf;
	bless $self, "CTXTCFG";
	$self;
}

sub init {
	my @a = split(":", $conf->{connector}->{dbidsn});
	$conf->{refdrv} = $a[1];
	my @b = split(";", $a[2]);
	foreach my $e (@b) {
		my @c = split("=", $e);
		$conf->{ "ref" . $c[0] } = $c[0];
	}
}

sub wd {
	return $conf->{_BASEDIR};
}

sub refdb {
	return $conf->{db};
}

sub refconnector {
	return $conf->{db}{connector};
}

sub refuser {
	return $conf->{db}{user};
}

sub refdsn {
	return $conf->{db}{connector}->{dbidsn};
}

sub refdbname {
	my $s = refdsn ();
	return $s;
	$s =~ s/;/#/g;
}

sub conPage {
	return $conf->{defaultpages}{connectpage};
}

sub mainPage {
	return $conf->{defaultpages}{menupage};
}

sub maxlistdisplay {
	return $conf->{maxlistdisplay};
}

1;
