#!/usr/local/bin/perl
#
# FlowSubs.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
 
#package FlowRt;
package ScriptRt;

sub Format_min {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $padc = shift;

	return (undef) unless (defined ($value));
	return lc($value);
} # min

sub Format_maj {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $padc = shift;

	return (undef) unless (defined ($value));
	return uc($value);
} # maj

sub Format_rpad {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $padc = shift;

	return (undef) unless (defined ($value));
	if (!defined($padc) || (length($padc) == 0)) { $padc = " "; }
	while (length($value) < $maxlen) { $value .= $padc; }
	#print "rpad $value : $maxlen : $padc\n ";
	return (substr($value,0,$maxlen));
} # rpad

sub Format_lpad {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $padc = shift;

	return (undef) unless (defined ($value));
	#print "lpad $value $maxlen $padc => ";
	if (!defined($padc) || (length($padc) == 0)) { $padc = " "; }
	while (length($value) < $maxlen) { $value = $padc . $value; }
	#print "lpad $value : $maxlen : $padc\n ";
	return (substr($value,0,$maxlen));
} # lpad

sub Format_ltrim {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $trimc = shift;

	return (undef) unless (defined ($value));
	if (!defined($trimc) || (length($trimc) == 0)) { $trimc = " "; }
	my $offset = 0;
	#while (index($value, $trimc, $offset) == $offset) { $offset += length($trimc); }
	while (substr($value, $offset, 1) eq $trimc) { $offset++; }
	if ($offset <= length($value)) { $value = substr($value, $offset); }
	else { $value = undef; }
	return (substr($value,0,$maxlen)) if ($maxlen and $value);
	$value
} # ltrim

sub Format_rtrim {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $trimc = shift;

	if (!defined($trimc) || (length($trimc) == 0)) { $trimc = " "; }
	if (! defined($trimc)) { $trimc = " "; }
	my $offset = length($value) - 1;
	#while (rindex($value, $trimc, $offset) ==  $offset) { $offset -= length($trimc); }
	while (substr($value, $offset, 1) eq $trimc) { $offset--; }
	if ($offset > 0) { $value = substr($value, 0, $offset+1); }
	else { $value = undef; }
	return (substr($value,0,$maxlen)) if ($maxlen and $value);
	$value;
} # ltrim

sub Format_trim {
	my $self = shift;
	my $value = shift;
	my $maxlen = shift;
	my $trimc = shift;

	return (undef) unless (defined ($value));
	return ($self->Format_ltrim($self->Format_rtrim($value, length($value) + 1, $trimc), $maxlen, $trimc))
	#return ($self->ltrim($value, $maxlen, $trimc));
} # ltrim

sub Format_todate {
	my $self = shift;
	my $value = shift;
	my $fromformat = shift;
	my $toformat = shift;

	my $dd = 0;
	my $mm = 0;
	my $yy = 0;
	my $hh = 0;
	my $mi = 0;
	my $ss = 0;
	my $temp;
	my $seps=".-/ :";
	my $context;

	return (undef) unless (defined ($value));

	for (my $i = 0; $i < length($fromformat); $i++) {
		my $tok = substr($value, $i, 1);
		my $ftok = substr($fromformat, $i, 1);
		if ($ftok eq 'D') {
			if ($context eq 'day') { $dd = ($dd * 10) + $tok; }
			else { $dd = $tok; }
			$context = 'day';
		}
		elsif ($ftok eq 'M') {
			if ($context eq 'temp') { $mm = ($temp * 10) + $tok; $context = 'month'; }
			else { $temp = $tok; $context = 'temp'; }
		}
		elsif ($ftok eq 'I') {
			if ($context eq 'temp') { $mi = ($temp * 10) + $tok; $context = 'temp'; }
		}
		elsif ($ftok eq 'Y') {
			if ($context eq 'year') { $yy = ($yy * 10) + $tok; }
			else { $yy = $tok; }
			$context = 'year';
		}
		elsif ($ftok eq 'H') {
			if ($context eq 'hour') { $hh = ($hh * 10) + $tok; }
			else { $hh = $tok; }
			$context = 'hour';
		}
		elsif ($ftok eq 'S') {
			if ($context eq 'sec') { $ss = ($ss * 10) + $tok; }
			else { $ss = $tok; }
			$context = 'sec';
		}
		else { $context = undef; }
	}

	$yy = 1970 unless ($yy);
	if ($yy < 50) { $yy += 2000; }
	elsif ($yy < 100) { $yy += 1900; }

	my $result;
	for (my $i = 0; $i < length($toformat); $i++) {
		my $ftok = substr($toformat, $i, 1);
		if ($ftok eq 'D') {
			if (uc(substr($toformat, $i+1, 1)) eq 'D') { $i++; $dd = $self->Format_lpad($dd, 2, "0"); }
			$result = $result . $dd;
		}
		elsif ($ftok eq 'M') {
			if (uc(substr($toformat, $i+1, 1)) eq 'M') { 
				$i++; $mm = $self->Format_lpad($mm, 2, "0");
				$result = $result . $mm;
			}
			elsif (uc(substr($toformat, $i+1, 1)) eq 'I') {
				$i++; $mi = $self->Format_lpad($mi, 2, "0");
				$result = $result . $mi;
			}
		}
		elsif ($ftok eq 'Y') {
			my $y = 10;
			my $ync = 1;
			while (uc(substr($toformat, $i+1, 1)) eq 'Y') { $y = $y * 10; $ync++; $i++; }
			$yy = $yy % $y;
			$result .= $self->Format_lpad($yy, $ync, "0");
		}
		elsif ($ftok eq 'H') {
			if (uc(substr($toformat, $i+1, 1)) eq 'H') { $i++; $hh = $self->Format_lpad($hh, 2, "0"); }
			$result = $result . $hh;
		}
		elsif ($ftok eq 'S') {
			if (uc(substr($toformat, $i+1, 1)) eq 'S') { $i++; $ss = $self->Format_lpad($ss, 2, "0"); }
			$result = $result . $ss;
		}
		else {
			$result .= substr($toformat, $i, 1);
		}
	}
	#print "lpad $value : $fromformat : $toformat => $result\n ";
	return $result;
}

sub Format_tonumber {
	my $self = shift;
	my $colval = shift;
	my $colfdta = shift;

	my $intval;
	my $decval;

	return (undef) unless (defined ($colval));

	$colval =~ s/,/./;
	$colval =~ s/ //g;

	my $zero;
	my $sign;
	
	my $i = 0;
	my $minlen = "";
	my $declen = "";
	my $e = 0;
	my $elen = 0;
	my $conv = "d";

	if ((substr($colfdta, $i, 1) eq "+") || (substr($colfdta, $i, 1) eq "-")) { $sign = substr($colfdta, $i, 1); $i++; }
	if (substr($colfdta, $i, 1) eq "0") { $zero = 1; $i++; }
	while ((substr($colfdta, $i, 1) eq "9")) { $i++; $minlen++; }

	$i++;
	while ((substr($colfdta, $i, 1) eq "9")) { $i++; $declen++; $conv = "f"; }

	if ((substr($colfdta, $i, 1) eq "e")) { $i++; $e = 1; $conv = "e"; }
	if ((substr($colfdta, $i, 1) eq "E")) { $i++; $e = 1; $conv = "E"; }

	my $format = "%$sign" . "0";
	if ($declen) { $format .= ".$declen"; $minlen+= $declen + 1; }
	$format .= "$conv";

	# print "$colval -> $format\n";
	$colval = sprintf ($format, $colval);

	if ($zero) {
		if ($colval < 0) { $sign = "-"; }
		# print $colval, "\n";
		if ($sign) { $colval = $sign . $self->Format_lpad (substr($colval,1), $minlen - 1, "0"); }
		else { $colval = $self->Format_lpad ($colval, $minlen, "0"); }
	}

	return $colval;
}


1;
