#!/usr/local/bin/perl
#
# cafDbg 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafDbg;
 
use strict;
$cafDbg::cafStack  = [];
$cafDbg::cafErrors = [];

$cafDbg::cafDindex = -1;


# calling new clear the global variables
sub new {
	my $class = shift;

	my $self = {};

	$class->clear ();
 
	bless $self, $class;
	return $self;
}

sub clear {
	$cafDbg::cafStack  = [];
	$cafDbg::cafErrors = [];
	$cafDbg::cafDindex = -1;
}

# update the content of the stack trace (append)
sub pushstackdump {
	my $self = shift;
	my $stacklevel = 1;
	$stacklevel = shift if (@_);

	my ($package, $filename, $line, $subroutine) = caller($stacklevel);
	push @{$cafDbg::cafStack}, "	Package = $package, Filename = $filename, Line = $line, Subroutine = $subroutine";
}

sub pushstackdumps {
	my $self = shift;
	my $stacklevel = 1;
	$stacklevel = shift if (@_);

	while ($stacklevel) {
		my ($package, $filename, $line, $subroutine) = caller($stacklevel);
		push @{$cafDbg::cafStack}, "	Package = $package, Filename = $filename, Line = $line, Subroutine = $subroutine";
		$stacklevel--;
	}
}

#remove the last stack dump
sub popstackdump {
	my $self = shift;
	pop @{$cafDbg::cafStack};
}

sub popstackdumps {
	my $self = shift;
	my $stacklevel = shift || 1;
	while ($stacklevel) { pop @{$cafDbg::cafStack}; $stacklevel--; }
}

# push an errors text/code/stack
#	clear the stack content
#	update the error count;
sub pusherror {
	my $self = shift;
	my $errt = shift;

	my $errh = {};

	my @erra = split (/;/, $errt);

	$errh->{_code} = shift @erra;
	$errh->{_text} = join(";", @erra);
	$errh->{_text} =~ s/\n/\n<BR>/;
	$errh->{_stack} = join ("\n<BR>", @{$cafDbg::cafStack});

	$cafDbg::cafStack = [];

	$cafDbg::cafDindex++;

	push @{$cafDbg::cafErrors}, $errh;

	return join $errt;
}

#return a ref to the errors array
sub geterrors {
	my $self = shift;

	return $cafDbg::cafErrors;
}

# return the number of errors
sub geterrorn {
	my $self = shift;

	return $cafDbg::cafDindex;
}

# return the specified error (argument = index of the errors array)
sub geterror {
	my $self = shift;

	return $cafDbg::cafErrors->[shift];
}

sub printerror {
	my $self = shift;

	for (my $i = $#{$cafDbg::cafErrors}; $i >= 0; $i--) {
		if (my $errh = $cafDbg::cafErrors->[$i]) {
			print "Code = $errh->{_code} - Text = $errh->{_text}<br>\n";
			print "STACK = <br>\n$errh->{_stack}<br>\n";
		}
	}
}

sub errortostring {
	my $self = shift;

	my $err = "";
	my $stack = "";
	for (my $i = $#{$cafDbg::cafErrors}; $i >= 0; $i--) {
		if (my $errh = $cafDbg::cafErrors->[$i]) {
			$err .= "Code = $errh->{_code} - Text = $errh->{_text}<br>\n";
			$stack .= "STACK = <br>\n$errh->{_stack}<br>\n";
		}
	}

	cafDbg->clear();
	return ($err, $stack);
}

sub printstack {
	my $self = shift;
	my $msg = shift;
	my $stacklevel = -1;

	print "$msg\n" if ($msg);

	while (1) {
		$stacklevel++;
		my ($package, $filename, $line, $subroutine) = caller($stacklevel);
		last unless ($package);
		print "  ==> $package::$filename $line $subroutine\n";
	}
}

1;
