function get_chit_figures($subscription, $subscribers, $foreman_com_rate, $max_bid_rate, $bid_amount){
    // note: bid_amount = discount
    $chit_amount = $subscribers * $subscription;
    $foreman_com_amount = $chit_amount * ($foreman_com_rate / 100);
    $min_bid_amount = $foreman_com_amount;
    $max_bid_amount = $chit_amount * ($max_bid_rate / 100);
    $prize_amount = $chit_amount - $bid_amount;
    $dividend = ($bid_amount - $foreman_com_amount) / $subscribers;
    $dividend_rate = ($dividend / $subscription) * 100;
    $chit_dividend = $bid_amount - $foreman_com_amount;
    $monthly_share_amount = $subscription - $dividend;
    // budget expectations
    $expected_foreman_commission = $subscribers * $foreman_com_amount;
    $expected_group_turnover = $subscribers * $subscription * $subscribers;
    // result array
    // given
    $result[subscription] = $subscription;
    $result[subscribers] = $subscribers;
    $result[foreman_com_rate] = $foreman_com_rate;
    $result[max_bid_rate] = $max_bid_rate;
    $result[bid_amount] = $bid_amount;
    // calculated
    $result[chit_amount]= $chit_amount;
    $result[foreman_com_amount] = $foreman_com_amount;
    $result[min_bid_amount] = $min_bid_amount;
    $result[max_bid_amount] = $max_bid_amount;
    $result[prize_amount] = $prize_amount;
    $result[dividend] = $dividend;
    $result[dividend_rate] = $dividend_rate;
    $result[chit_dividend] = $chit_dividend;
    $result[monthly_share_amount] = $monthly_share_amount;
    $result[expected_foreman_commission] = $expected_foreman_commission;
    $result[expected_group_turnover] = $expected_group_turnover;
    return $result;   
}
echo "<h1>proc_new: $proc_new</h1>";
if ($proc_new=="true"){
    // new procedure
    $ding_code=$ChitGroup[Code];
    $ding_name="Chit Group " . $ChitGroup[Code];
    $sql = "insert into proceedings (procedure_code, proceeding_code, proceeding_name, last_completed_step_id) values ('$proc_code', '$ding_code', '$ding_name', $step_id)";
    echo "<p>proceedings:$sql";
    $last_ding_oid = Exec_Sql($sql);    
    $sql = "select proceeding_id from proceedings where oid=$last_ding_oid";
    $ding_id = Retn_Result($sql);       
    //echo "<p>sql:$sql";
    //  REGISTER PROCEEDING IN SUBSIDARY TABLES
    $ac_name = $ding_code . " Group Account";
    $chit_group_achead = 46;
    $entity_id = $login_entity;
    $sql = "insert into accounts(account_code, account_name, achead_id, entity_id) 
			 values ('$ding_id', '$ac_name', $chit_group_achead, $entity_id)";
    $last_ac_oid = Exec_Sql($sql);
    $sql = "select account_id from accounts 
	     where oid=$last_ac_oid";
    $account_id = Retn_Result($sql);  
    $sql = "insert into chitgroups (chitgroup_code, chitgrouptype_id, proceeding_id, 
				    account_id, foreman_contact_id) 
			    values ('$ding_code', $ChitGroup[TypeID], $ding_id, $account_id, 1)";
    $last_chit_regn_id = Exec_Sql($sql);

    // REGISTER EVENT
    $event_id = insert_event($ding_id, $step_id);

    // REGISTER ASSERTIONS
    reset($sql_assertion);
    while (list($key, $value)=each($sql_assertion)){
         $value=str_replace('^event_id^', $event_id, $value);
         echo "<p>$value";
	 $assertion_oid[]=Exec_Sql($value);
    }
    echo "<b>Proceedings completed.</b><br>";
    echo "<b>Transaction event_id: $event_id</b>";
    echo "<h2><a href=Proceedings.php>Back to Proceedings</a></h2>";
    echo "<hr>";
    exit;
}
$ding = get_record_info("proceeding_id", $ding_id);
$cg = get_chit_group_info("$ding[proceeding_code]");
$cgt = get_chit_type_info($cg[chitgrouptype_id]);
$st= get_record_info("step_id", $step_id);
$cg_dump = get_array($step);
// echo "$cg_dump";
$step=$st[step];
$step_code=$st[step_code];
/*******************************************************************************************/
//         step_code         | step |                       step_name
//---------------------------+------+--------------------------------------------------------
// 00Resolution              |    1 | Resolution for commencing and conducting new chit  
// code to be executed at each step is given a heading has above
/*******************************************************************************************/     
// 02ChitRegistration        |    2 | Endorsement of Registration
if (($step_code=="02ChitRegistration") && ($step==2)){
    // create tickets
    $subscribers = $cgt[subscribers];
    echo "<h1>Subscribers:$subscribers</h1>";
    for ($i=1; $i<=$subscribers; $i++){
         $chit_subscriber_code = $ding[proceeding_code] . "_" . $i;
	 $sql = "insert into chit_subscribers (chit_subscriber_code, ticket_number, chitgroup_code)
                                       values (\'$chit_subscriber_code\', $i, \'$ding[proceeding_code]\')";
         $result = Exec_Sql($sql);
    }
}
 
// 02ChitRegistration        |    5 | Enlisting of Subscribers
if (($step_code=="02ChitRegistration") && ($step==5)){
    // enlist given subscriber to the group
    
}

// 03ChitAuction             |    1 | Notice of Auction to Subscribers
if (($step_code=="03ChitRegistration") && ($step==1)){
    // issue auction notice
}

// 03ChitAuction             |    2 | Chit Auction Meeting
if (($step_code=="03ChitRegistration") && ($step==3)){
    // conduct an auction

}

// 03ChitAuction             |    3 | Filing of Minutes of Auction
if (($step_code=="03ChitRegistration") && ($step==3)){
    // file minutes of auction

}

// 04ChitTermination         |    1 | Termination of Chit
if (($step_code=="03ChitRegistration") && ($step==1)){
    // terminate chit group

}              
