<?php
//
//2001-07-23 Chennai Ramanraj
//These functions connect to a PostgreSQL database.
//All elementary database functions are carried out through this include.
//TODO: Equivalent function libraries to be written for Oracle, DB2, etc
//Index to PostgreSQL based Functions Included in this collection:
//
//	function Show_Sql ($sql, $fmt_table="<table border=1>", $col_head="")
//		Function to display the results of $sql as a html table
//
//	function Retn_Sql_Array($sql)
//		Function to return the sql result as an array
//
//	function Retn_Row ($sql)
//		Function to return a single row defined by a sql statement 
//
//	function Exec_Sql ($sql)
//	    Function to execute $slq
//
$CLP_DEBUG[]="including db_pgsql_lib.inc ...";
$database = pg_connect("host=$DSN_HOSTSPEC port=$DSN_PORT dbname=$DSN_DATABASE user=$DSN_USERNAME password=$DSN_PASSWORD") or die('pg_connect failed');


function Show_Sql ($sql, $fmt_table="<table border=0>", $col_head=""){
    // Show_Sql($sql) : Function to display the results of $sql as a html table 
    // open connection to postgres
    global $CLP_DEBUG;
    $CLP_DEBUG[]="function Show_Sql(sql=$sql, fmt_table=$fmt_table, col_head=$col_head)";
    global $database;
    $result=pg_exec($database,$sql); 	
    if($numofrows=pg_numrows($result)) { 		
        echo "$fmt_table";
        // print column headings 	
        $fields=pg_numfields($result); 		
        $fields2=$fields;
        // if no col_head is specified, print default table field names, else print specified head
        if ($col_head=="")	{
           echo "<tr>";
           while($fields2) {
               echo "<td>".pg_fieldname($result,$fields-$fields2);
	       echo "</td>";
	       $fields2-- ; 
           }
           echo "</tr>\n";
           } else {
           echo "<tr valign=top>$col_head</tr>";
        }		
        // print record rows 
        $click=0;
        while($numofrows > $click) { 
            $row=pg_fetch_array($result,$click++); 
	    echo "<tr valign=top>";
	    $fields2=$fields; 
	    while($fields2) { 
	       echo "<td>";
	       echo $row[$fields-$fields2--];
	       echo "</td>";  
            }
	    echo "</tr>\n";
        } 
    echo "</table>";
    }
    // free postgres connection 
    pg_freeresult($result);
    return 0;
}

function Retn_Sql_Table ($sql, $fmt_table="<table border=1>", $col_head=""){	
    //Show_Sql($sql) : Function to display the results of $sql as a html table
    //open connection to postgres
    global $CLP_DEBUG;
    $CLP_DEBUG[]="function Retn_Sql_Table(sql=$sql, fmt_table=$fmt_table, col_head=$col_head)";
    global $database;
    $result=pg_exec($database,$sql); 	
    if($numofrows=pg_numrows($result)) { 		
        $table = "$fmt_table";
        //print column headings
        $fields=pg_numfields($result); 		
        $fields2=$fields;
        //if no col_head is specified, print default table field names, else print specified head
        if ($col_head=="")	{
            echo "<tr>";
            while($fields2) {
	        $table .= "<td>".pg_fieldname($result,$fields-$fields2);
	        $table .= "</td>";
		$fields2-- ; 
            }
	    $table .= "</tr>\n";
            } else {
	    $table .= "<tr valign=top>$col_head</tr>";
	}
        //print record rows
	$click=0;
        while($numofrows > $click) { 
	    $row=pg_fetch_array($result,$click++); 
	    $result .= "<tr valign=top>";
	    $fields2=$fields; 
	    while($fields2) { 
		$table .= "<td>";
		$table .= $row[$fields-$fields2--];
		$table .= "</td>";  
            }
	    $table .= "</tr>\n";
	} 
        $table .= "</table>";
    }
    //free postgres connection	
    pg_freeresult($result);	
    return $table;
}

function Retn_Sql_Result ($sql){
    global $CLP_DEBUG;
    $CLP_DEBUG[]="function Retn_Sql_Result(sql=$sql)";
    global $database;
    $result=pg_exec($database,$sql); 	
    if($numofrows=pg_numrows($result)) { 		
        $fields=pg_numfields($result); 		
        $fields2=$fields;          
        $click=0;
	while($numofrows > $click) { 
	    $row=pg_fetch_array($result,$click++); 
	    $fields2=$fields; 
	    while($fields2) { 
	        $table .= $row[$fields-$fields2--];
	    }
        }
     }
    // free postgres connection 			
    pg_freeresult($result);		
    return $table;
}

function Retn_Sql_Array($sql){
    global $database;
    $sql = trim($sql);
    if ($sql!=''){
	$result=pg_exec($database, $sql);
	$result_rows=pg_numrows($result);
	if($result_rows>0) { 		
	    while ($rec<$result_rows){
		$row = pg_fetch_array($result, $rec);
		$result_array[]=$row;
		$rec=$rec + 1;
	    }
	}
	pg_freeresult($result);
    } else {
        $result_array[error]="Invalid sql: $sql";
    }
    return $result_array;     	
}

function Retn_Key_Value_Array($sql){
// returns an array in the format $result[field0]=field1 [ . ' ' . field2 [ . ' ' . fieldn]]
// where $sql = select field0, field1[, field2[, fieldn]] from tablename;
// sample $sql values:
// $sql = "select contact_id, name from contacts" # $result[contact_id]=name;
// $sql = "select contact_id, initials, name from contacts"  # $result[contact_id]=initials . ' ' . name;
// 
    global $database;
    $result=pg_exec($database,$sql);
    $result_rows=pg_numrows($result);
    if($result_rows>0) {
        $cnt = pg_numfields($result);		
        while ($rec<$result_rows){
    	    $row = pg_fetch_row($result, $rec);
            
            if ($cnt == 1){
                $result_array[]=$row[0];
            	} elseif($cnt==2) {
    	        $result_array[$row[0]]=$row[1];
            	} elseif($cnt>2){
		for($i=1; $i<=$cnt; $i++){
                    $tmp .= $row[$i] . " ";
                }
                $result_array[$row[0]]=$tmp;
                $tmp='';
            }
	    $rec=$rec + 1;
        }
    }
    pg_freeresult($result);
    return $result_array;     	
}

function Retn_Result($sql){
    global $database;
    $result=pg_exec($database,$sql);
    $result_rows=pg_numrows($result);
    if($result_rows>0) {		
    	$row = pg_fetch_row($result, $rec);
    	$answer=$row[0];    
    }
    pg_freeresult($result);
    return $answer;    
}

function Retn_Sql_Single_Col_Array($sql){
    global $database;
    $result=pg_exec($database,$sql);
    $result_rows=pg_numrows($result);
    if($result_rows>0) { 		
        while ($rec<$result_rows){
    	    $row = pg_fetch_row($result, $rec);
    	    while(list($key, $value)=each($row)){
    		 $result_array[]=$value;
    	    }
    	    $rec=$rec + 1;
        }
    }
    pg_freeresult($result);
    return $result_array;     	
}

function Retn_Row_Count($sql){
    // RETURNS THE NUMBER OF ROWS RETURNED BY $sql
    global $database; 	
    $result=pg_exec($database, $sql);
    $result_rows=pg_numrows($result);
    pg_freeresult($result);
    return $result_rows;     	
}

function Retn_Row ($sql){   
    //Retn_Row($sql):  Function to return a single row defined by a sql statement 
    // open connection to postgres 
    global $database;
    global $reasons;
    $reasons[]="function Retn_Row(sql): $sql";
    $result=pg_exec($database, $sql);
    if ($result != FALSE){
	$row_count = pg_numrows($result);
	if ($row_count > 0) {
	    $ret_row = pg_fetch_array($result, 0);
	    return $ret_row;
	    } else {
	    $ret_row = "";
	    return $ret_row;
	}
    } else {
	 $result = "";
    }
    // free postgres connection 
    pg_freeresult($result);
}

function Exec_Sql ($sql){
    // Function to execute $sql and return the lastoid. returns -1 if $sql is not an insert statemenr
    global $database;
    $result=pg_exec($database, $sql);		
    $ret_val=pg_getlastoid($result);	
    pg_freeresult($result);        
    return $ret_val;
}

function Retn_ID($oid, $table){
    // Returns first field value for any given oid
    $sql = "select * from $table where oid=$oid";
    $result = Retn_Result($sql);
    return $result;
}

function fmt_ind_rs($cur){
    // Format $cur to indian currency
    global $database;
    $sql="select to_char($cur, '99G99G999G99G99G999D99')";
    $result = Retn_Result($sql);
    $result = trim($result);
    $start = $result[0];
    if ($start=='.'){
	 $result = '0' . $result;
    } elseif ($start=='-'){
	if ($result[1]=='.'){
	    $result = "-0." . substr($result, 2);
	}
    }
    return $result;
}
$CLP_DEBUG[]="including db_pgsql_lib.inc done";
?>