<?
/*****************************************************************************************
  Fileame: config.inc.php

  Purpose: Contains all settings for the php wrapper

  Created: 02-01-03

******************************************************************************************/

//postgresql host
define("DBHOST","localhost");

//postgresql user
define("DBUSER","postgres");

//postgresql password
define("DBPASSWORD","secret");

//postgresql port
define("DBPORT","5432");

//postgresql database name
define("DBNAME","docmgr");

//set this if you wish to OCR images so their content will be searchable
//this requires gocr and imagemagick
define("OCR_SUPPORT","1");

//set this if you want to be able to search content in pdf files
//This requires GhostScript
define("INDEX_PDF","1");

//set this if you wish to have extended tiff and mtiff support,
//This will allow per page indexing for mtiff files
define("TIFF_SUPPORT","1");

//set the directory you wish to allow users to import
//files from
define("UPLOAD_DIR","/import");

//max execution time (in seconds) that php will allow per
//file in processing during imports.
define("EXECUTION_TIME","60");

//maximum file upload size (bytes)
define("MAX_UPLOAD","50000000");

//the following is site admin information to display if a user
//has login problems.  Uncomment the following if you wish to
//display such information.
$display_site_admin=1;

//admin name
$login_admin="Site Admin";

//admin phone
$login_admin_phone="x1234";

//admin email address
$login_admin_email="admin@foobar.com";

//this is a regexp used by php to decide what to characters you want to include
//in the index.  I was going to hardcode it, but I could see some people wanting
//to allow nonalphanumeric characters, etc.  So, whatever you set this
//variable to is what characters will be kept during indexing.  Some examples
//are included below.
//
//$keepIndex = "a-z";		//keep only the characters a thru z
//
//$keepIndex = "a-z0-9";	//keep only numbers 0 thru 9 and letters a-z
//
//$keepIndex = "a-z0-9/.@:";	//keep letters, numbers, and characters for email/web addresses
//

$keepIndex = "a-zA-Z0-9:@./";

//this array prevents certain files from being quickviewed.  A quickviewed
//file is opened directly in your browser.  Add more as you see fit.
$denyQuickview=array();

$denyQuickview[0] = ".php";
$denyQuickview[1] = ".php3";
$denyQuickview[2] = ".phtml";
$denyQuickview[3] = ".asp";
$denyQuickview[4] = ".gz";	//.tar.gz files dont work for some reason
$denyQuickview[5] = ".com";
$denyQuickview[6] = ".vbs";
$denyQuickview[7] = ".bat";
$denyQuickview[8] = ".tgz";
$denyQuickview[9] = ".iso";	//because these are cd images, and are big


//this prevents common words from being indexed.  Note:  Nothing smaller
//than three words is indexed, so you can ignore those.  Obviously this
//list can get pretty big, but I just wanted to start with a base list
//
//KEEP THE SPACES BEFORE AND AFTER THE WORD

$preventIndex = array();

$preventIndex[] = " all ";
$preventIndex[] = " and ";
$preventIndex[] = " any ";
$preventIndex[] = " are ";
$preventIndex[] = " can ";
$preventIndex[] = " for ";
$preventIndex[] = " from ";
$preventIndex[] = " its ";
$preventIndex[] = " may ";
$preventIndex[] = " more ";
$preventIndex[] = " that ";
$preventIndex[] = " the ";
$preventIndex[] = " their ";
$preventIndex[] = " then ";
$preventIndex[] = " there ";
$preventIndex[] = " they ";
$preventIndex[] = " this ";
$preventIndex[] = " with ";
$preventIndex[] = " what ";
$preventIndex[] = " when ";
$preventIndex[] = " where ";
$preventIndex[] = " who ";
$preventIndex[] = " why ";
$preventIndex[] = " yes ";
$preventIndex[] = " you ";
$preventIndex[] = " your ";

/*************************************************************************
	Do not modify anything below this line
*************************************************************************/

//the name of the header file we use
define("HEADER","default.inc.php");

//the name of the stylesheet we use
define("STYLESHEET","default.inc.php");

define("APP_ID","1");
define("APP_NAME","DocMGR");
define("APP_BITSET","8");
define("APP_SPECIFIC","1");
define("MAIN_LEFT_COLUMN","1");

//define our modules for links
define("DEFAULT_MOD","1");

//sets the module system to auth users
define("AUTHORIZE","yes");

//define the DocMGR version
define("APP_VERSION","DocMGR 0.40");

define("AUTHHOST",DBHOST);
define("AUTHUSER",DBUSER);
define("AUTHPASSWORD",DBPASSWORD);
define("AUTHPORT",DBPORT);
define("AUTHNAME",DBNAME);

//set this if you wish to have the ability to convert any picture
//to a pdf file.  This also allows extended tiff and mtiff support.
//This requires libtiff and OCR support.
//
//NOTE:  This option is disabled for the time being.  I don't think it's
//being used, and it doesn't work in this version anyways.  We'll see what
//the response to it's absence is.
//define("PIC2PDF","1");


?>
