/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicTOPLinkDeploymentTool;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class EjbJar
extends MatchingTask {
    private File srcDir;
    private File descriptorDir;
    private File destDir;
    private String baseJarName;
    private Path classpath;
    private boolean flatDestDir = false;
    private String baseNameTerminator = "-";
    private String genericJarSuffix = "-generic.jar";
    private ArrayList deploymentTools = new ArrayList();

    public WeblogicDeploymentTool createWeblogic() {
        WeblogicDeploymentTool tool = new WeblogicDeploymentTool();
        tool.setTask((Task)this);
        this.deploymentTools.add(tool);
        return tool;
    }

    public WeblogicTOPLinkDeploymentTool createWeblogictoplink() {
        WeblogicTOPLinkDeploymentTool tool = new WeblogicTOPLinkDeploymentTool();
        tool.setTask((Task)this);
        this.deploymentTools.add(tool);
        return tool;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((Task)this).project);
        }
        return this.classpath.createPath();
    }

    public void setSrcdir(File inDir) {
        this.srcDir = inDir;
    }

    public void setDescriptordir(File inDir) {
        this.descriptorDir = inDir;
    }

    public void setBasejarname(String inValue) {
        this.baseJarName = inValue;
    }

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setFlatdestdir(boolean inValue) {
        this.flatDestDir = inValue;
    }

    public void setGenericjarsuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public void setBasenameterminator(String inValue) {
        this.baseNameTerminator = inValue;
    }

    public void execute() throws BuildException {
        String msg;
        File scanDir;
        if (this.srcDir == null) {
            throw new BuildException("The srcDir attribute must be specified");
        }
        if (this.deploymentTools.size() == 0) {
            GenericDeploymentTool genericTool = new GenericDeploymentTool();
            genericTool.setDestdir(this.destDir);
            genericTool.setTask((Task)this);
            genericTool.setGenericJarSuffix(this.genericJarSuffix);
            this.deploymentTools.add(genericTool);
        }
        if ((scanDir = this.descriptorDir) == null) {
            scanDir = this.srcDir;
        }
        Iterator i = ((AbstractList)this.deploymentTools).iterator();
        while (i.hasNext()) {
            EJBDeploymentTool tool = (EJBDeploymentTool)i.next();
            tool.configure(this.srcDir, scanDir, this.baseNameTerminator, this.baseJarName, this.flatDestDir, this.classpath);
            tool.validateConfigured();
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            DirectoryScanner ds = this.getDirectoryScanner(scanDir);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            this.log(files.length + " deployment descriptors located.", 3);
            int index = 0;
            while (index < files.length) {
                Iterator i2 = ((AbstractList)this.deploymentTools).iterator();
                while (i2.hasNext()) {
                    EJBDeploymentTool tool = (EJBDeploymentTool)i2.next();
                    tool.processDescriptor(files[index], saxParser);
                }
                ++index;
            }
        }
        catch (SAXException se) {
            msg = "SAXException while creating parser.  Details: " + se.getMessage();
            throw new BuildException(msg, (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            msg = "ParserConfigurationException while creating parser. Details: " + pce.getMessage();
            throw new BuildException(msg, (Throwable)pce);
        }
    }
}

