/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/server/CleanLogRunnable.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.server;

import com.postgres.replic.server.props.ConnectionPoolProps;
import com.postgres.replic.server.props.ServerProps;
import com.postgres.util.jdbc.ConnectionPool;


public class CleanLogRunnable extends AbstractReplicationRunnable
		implements Runnable {

	public CleanLogRunnable(ServerProps serverProps,
							ConnectionPoolProps connPoolProps,
							ConnectionPool masterPool,
							ConnectionPool slavePool) throws ReplicationException {
		super(serverProps, connPoolProps, masterPool, slavePool);
	}


	public void run() {
		try {
			while (true && !(getSignal() == STOP)) {
				getLogger().debug("CleanLogRunnable::run cleanLog");
				getRserv().cleanLog(getServerProps().getHowOldLog());
				Thread.sleep(getServerProps().getCleanLogInterval());
			}
		} catch (InterruptedException ie) {
			getLogger().error("CleanLogRunnable::run: InterruptedException: calling destroy");
			destroy();
		} catch (Exception e) {
			getLogger().error("CleanLogRunnable::run: ", e);
		} finally {

		}
	}
}
