/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/tools/desc/UpdateSeqDesc.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class UpdateSeqDesc extends GeneratorDescriptor {

    private AddMarkerColumn addMarker;
    private Connection conn;
    private DBMetaHelper dbMetaHelper;
    private String schema;
    private boolean print;

    public UpdateSeqDesc(boolean print, Connection conn, String schema) throws Exception {
        if (conn == null) {
            throw new Exception("UpdateSeqDesc:: Connection may not be null");
        }
        this.conn = conn;
        this.schema = schema;
        this.print = true;
        addMarker = new AddMarkerColumn(false);
        dbMetaHelper = new DBMetaHelper (conn);
    }

    public String getLine(String table) throws Exception {
        if (table.toLowerCase().startsWith(ToolKitConst.GLOBAL_PREFIX)) {
            return "";
        }

        String markerColumn = addMarker.getColumnName(table);

        if (!dbMetaHelper.columnExists(schema, table, markerColumn)){
            if (debug) System.out.println("UpdateSeqDesc::getLine: "+table+"."+markerColumn+" does not exist");
            return "";
        }

        int count = 0;
        Statement stmt = null;
        ResultSet rs = null;

        try {
             stmt = conn.createStatement();
             String select = "select * from  " + table;
             String where = null;


             String [] condArray = dbMetaHelper.getPrimaryKeys(schema, table);
             if (condArray == null) return null;
             rs = stmt.executeQuery(select);

             while (rs.next()) {
                 where = null;
                 count++;
             	 for (int i=0; i< condArray.length; i++) {
                    String and = i==0 ? "" : " and " ;
                     where = and + condArray[i] + "=" + rs.getString(condArray[i]);
                 }


                 String sql = "update " + table + " set " + markerColumn + "=" + count;
                 if (where != null) {
                    sql += " where " + where;
                 }

                if (debug) System.out.println("UpdateSeqDesc::getLine: sql="+sql);
                if (print) System.out.println(sql + ";");
             }




             //stmt.executeUpdate(sql);
        } catch (Exception e) {
             System.out.println("UpdateSeqDesc::getLine: " + e.toString());
             throw new Exception("UpdateSeqDesc: Cannot update column " + table + "." + markerColumn);
        } finally {
             try {
                 if (stmt != null) stmt.close();
             } catch (Exception e) {}

        }

        String result = "-- Successfully updated column " + table + "." + markerColumn;
        if (print) System.out.println(result);

        return result;
    }

    public boolean tableOnly() {
        return true;
    }

}
