/*
 * DataPanel.java
 *
 * Created on 31 de julio de 2002, 16:53
 */

package components.view;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class DataPanel extends JPanel{
    private View view = null;
    private SQLTable data_view = new SQLTable();
    
    private Hashtable tales_order = new Hashtable(100);
    private DataPanelListener listener = null;
    
    /** Creates a new instance of DataPanel */
    public DataPanel() {
        data_view = new SQLTable();
        listener = new DataPanelListener(this);
        initPanel();
    }
    private void initPanel(){
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        setLayout(new BorderLayout());
        
        SQLTableModel sql_tm = new SQLTableModel(data_view);
        data_view.setModel(sql_tm);
        
        add(new DataPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_view), BorderLayout.CENTER);
    }
    
    public void refresh(){
        dataSourceResultSet dsrs = new dataSourceResultSet(view.getConnection(), generateSQL());
        ((SQLTableModel) data_view.getModel()).setDataSource(dsrs);
        repaint();
    }
    public void refresh(View view_object){
        view = view_object;
        refresh();
    }
    
    private String generateSQL(){
        StringBuffer retorno = new StringBuffer();
        if(view != null){
            retorno.append("SELECT * FROM ").append(view.getName());
            
            Vector order = getOrder();
            if(order.size() > 0){
                retorno.append(" ORDER BY ");
                for(int i= 0; i<order.size(); i++){
                    retorno.append(order.get(i));
                    if(i < (order.size() - 1)){
                        retorno.append(", ");
                    } else {
                        retorno.append(" ");
                    }
                }
            }
        }
        return retorno.toString();
    }
    
    public void addOrder(String _column){
        Vector order = getOrder();
        if ((_column != null) && (getOrderPos(_column) < 0)){
            order.add(_column);
        }
    }
    public void clearOrder(){
        getOrder().removeAllElements();
    }
    public int getOrderPos(String _column){
        int retorno = -1;
        Vector order = getOrder();
        for(int i=0 ; (i<order.size()) && (retorno < 0); i++){
            if (((String) order.get(i)).equals(_column)){
                retorno = i;
            }
        }
        return retorno;
    }
    public Vector getOrder(){
        Vector retorno = (Vector) tales_order.get(view.getName());
        if(retorno == null){
            retorno = new Vector();
            tales_order.put(view.getName(), retorno);
        }
        return retorno;
    }
    
    public View getView(){
        return view;
    }
    
    public DataPanelListener getListener(){
        return listener;
    }
    
    public void showOrderDialog(){
        (new DataPanelOrderDialog(this)).show();
    }
    public void newRecord(){
    }
    public void editRecord(){
    }
    public void deleteRecord(){
    }
}
