/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.SQLTable;
import components.SQLTableModel;
import components.table.DataPanelListener;
import components.table.DataPanelOrderDialog;
import components.table.DataPanelToolbar;
import components.table.TableAddRecordDialog;
import components.table.TableEditRecordDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.TableIndex;

public class DataPanel
extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private DataPanelListener listener = null;
    private Hashtable tales_order = new Hashtable(100);

    public DataPanel() {
        this.data_table = new SQLTable();
        this.listener = new DataPanelListener(this);
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_table);
        this.data_table.setModel(sQLTableModel);
        this.add((Component)new DataPanelToolbar(this), "North");
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        this.data_table.getTableModel().setDataSource(new dataSourceResultSet(this.table.getConnection(), this.generateSQL()));
        this.repaint();
    }

    public void refresh(Table table) {
        this.table = table;
        this.refresh();
    }

    private String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.table != null) {
            stringBuffer.append("SELECT * FROM ").append(this.table.getName());
            Vector vector = this.getOrder();
            if (vector.size() > 0) {
                stringBuffer.append(" ORDER BY ");
                int n = 0;
                while (n < vector.size()) {
                    stringBuffer.append(vector.get(n));
                    if (n < vector.size() - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append(" ");
                    }
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    public void addOrder(String string) {
        if (string != null && this.getOrderPos(string) < 0) {
            this.getOrder().add(string);
        }
    }

    public void clearOrder() {
        this.getOrder().removeAllElements();
    }

    public int getOrderPos(String string) {
        int n = -1;
        Vector vector = this.getOrder();
        int n2 = 0;
        while (n2 < vector.size() && n < 0) {
            if (((String)vector.get(n2)).equals(string)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public Vector getOrder() {
        Vector vector = (Vector)this.tales_order.get(this.table.getName());
        if (vector == null) {
            vector = new Vector();
            this.tales_order.put(this.table.getName(), vector);
        }
        return vector;
    }

    public Table getTable() {
        return this.table;
    }

    public DataPanelListener getListener() {
        return this.listener;
    }

    public void showOrderDialog() {
        new DataPanelOrderDialog(this).show();
    }

    public void newRecord() {
        new TableAddRecordDialog(this.getTable()).show();
        this.refresh();
    }

    public void editRecord() {
        int n = this.data_table.getSelectedRow();
        if (this.table.getPrimaryKeys().size() > 0) {
            Vector<Object> vector = new Vector<Object>();
            int n2 = 0;
            while (n2 < this.data_table.getColumnCount()) {
                vector.add(this.data_table.getValueAt(n, n2));
                ++n2;
            }
            new TableEditRecordDialog(this.getTable(), vector).show();
        } else {
            JOptionPane.showMessageDialog(this, "Table has no primary keys defined.", "Error", 1);
        }
        this.refresh();
    }

    public void deleteRecord() {
        if (JOptionPane.showConfirmDialog(this, "Delete selected records ?", "Error.", 0) == 0) {
            if (this.table.getPrimaryKeys().size() > 0) {
                Vector vector = ((TableIndex)this.table.getPrimaryKeys().get(0)).getColumns();
                int[] nArray = new int[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    nArray[n] = this.table.getColumnIndex(((TableColumn)vector.get(n)).getName());
                    ++n;
                }
                int[] nArray2 = this.data_table.getSelectedRows();
                int n2 = 0;
                while (n2 < nArray2.length) {
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        Vector<Object> vector2 = new Vector<Object>();
                        vector2.add(this.data_table.getValueAt(nArray2[n2], nArray[n3] + 1));
                        try {
                            this.table.deleteRecord(vector2);
                        }
                        catch (SQLException sQLException) {
                            JOptionPane.showMessageDialog(this, sQLException.getMessage(), "Error.", 1);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Table has no primary keys defined.", "Error", 1);
            }
        }
        this.refresh();
    }
}

