/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import pgclibrary.dataaccess.DatabaseQuerys;

public class MainConnection
implements Serializable {
    public static final String defaultDriver = "org.postgresql.Driver";
    public static final String defaultURI = "jdbc:postgresql://localhost:5432/prueba1";
    private String driver = null;
    private String URI = null;
    private String userName = null;
    private String password = null;
    private Connection connection = null;
    private Statement statement = null;
    private DatabaseQuerys databaseQG = null;
    private Vector error_text = new Vector();
    private long error_code = 0L;
    private String databaseVersion = null;

    public MainConnection() {
    }

    public MainConnection(String string, String string2, String string3, String string4) {
        this.error_text = new Vector();
        this.error_code = 0L;
        if (string != null && string2 != null && string3 != null && string4 != null) {
            this.driver = new String(string);
            this.URI = new String(string2);
            this.userName = new String(string3);
            this.password = new String(string4);
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", this.userName);
            ((Hashtable)properties).put("password", this.password);
            this.connect(properties);
        }
    }

    private boolean connect(Properties properties) {
        boolean bl = false;
        Connection connection = null;
        if (this.driver != null && this.URI != null && this.userName != null && this.password != null) {
            try {
                Class.forName(this.driver);
                connection = DriverManager.getConnection(this.URI, properties);
                connection.setAutoCommit(true);
                SQLWarning sQLWarning = connection.getWarnings();
                if (sQLWarning != null && sQLWarning.getErrorCode() == 28002) {
                    this.error_text.add("Incorrect password.");
                    this.error_code = sQLWarning.getErrorCode();
                }
            }
            catch (Exception exception) {
                this.error_text.add(exception.getMessage());
                connection = null;
            }
        }
        if (connection != null) {
            this.connection = connection;
            try {
                this.statement = this.connection.createStatement(1004, 1008);
                bl = true;
            }
            catch (Exception exception) {
                this.error_text.add(exception.getMessage());
                this.connection = null;
                bl = false;
            }
        }
        return bl;
    }

    public MainConnection(String string, String string2) {
        this(defaultDriver, defaultURI, string, string2);
    }

    public MainConnection(MainConnection mainConnection) {
        this(mainConnection.getDriver(), mainConnection.getURI(), mainConnection.getUserName(), mainConnection.getPassword());
    }

    public Vector getError() {
        return this.error_text;
    }

    public long getErrorCode() {
        return this.error_code;
    }

    public String getUserName() {
        return this.userName;
    }

    private String getPassword() {
        return this.password;
    }

    public Connection getConnection() throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("The connection has not be initialized");
        }
        return this.connection;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getURI() {
        return this.URI;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public Statement getStatementReadOnly() throws SQLException {
        Statement statement = null;
        statement = this.getConnection().createStatement(1004, 1007);
        return statement;
    }

    public Statement getStatement() throws SQLException {
        Statement statement = null;
        statement = this.getConnection().createStatement(1004, 1007);
        return statement;
    }

    public Statement getStatement(int n, int n2) throws SQLException {
        Statement statement = null;
        statement = this.getConnection().createStatement(n, n2);
        return statement;
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.statement != null) {
            return this.statement.executeUpdate(string);
        }
        return 0;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.statement != null) {
            return this.statement.executeQuery(string);
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("Connection nor initialized");
        }
        return this.getConnection().prepareStatement(string, 1004, 1007);
    }

    public void close() {
        if (this.isConnected()) {
            try {
                this.statement.close();
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static boolean isQuery(String string) {
        String string2 = string.toUpperCase();
        return string2.indexOf("SELECT") >= 0 && string2.indexOf("UPDATE") < 0 && string2.indexOf("DELETE") < 0 && string2.indexOf("GRANT") < 0 && string2.indexOf("REVOKE") < 0 && string2.indexOf("INSERT") < 0;
    }

    public String getDatabaseName() {
        String string = new String();
        if (this.isConnected()) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getURI(), "/");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    public String getProductName() {
        String string = new String();
        try {
            if (this.isConnected()) {
                string = this.getConnection().getMetaData().getDatabaseProductName() + " " + this.getConnection().getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String getDriverVersion() {
        String string = new String();
        try {
            if (this.isConnected()) {
                string = this.getConnection().getMetaData().getDriverVersion();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String getDatabaseVersion() {
        if (this.databaseVersion == null) {
            try {
                if (this.isConnected()) {
                    this.databaseVersion = this.getConnection().getMetaData().getDatabaseProductVersion();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.databaseVersion;
    }

    public String getURL() {
        String string = new String();
        try {
            if (this.isConnected()) {
                string = this.getConnection().getMetaData().getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public DatabaseQuerys getQueryGenerator() {
        if (this.databaseQG == null) {
            this.databaseQG = DatabaseQuerys.getDefaultQueryGenerator(this);
        }
        return this.databaseQG;
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

