/*
 * Sequence.java
 *
 * Created on 30 de julio de 2002, 18:17
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class Sequence extends DBObject {
    private long last_value = 0;
    private long increment_by = 0;
    private long max_value = 0;
    private long min_value = 0;
    private long cache_value = 0;
    private boolean cycled = false;
    private boolean called = false;
    private long start = 0;
    private String description = null;
    
    /** Creates a new instance of Sequence */
    public Sequence(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    public Sequence(DBObject owner) {
        super(owner);
    }
    
    public boolean Drop(){
        boolean retorno = false;
        try{
            retorno = getConnection().executeUpdate("DROP SEQUENCE " + getName()) > 0;
        } catch (SQLException e){
            JOptionPane.showMessageDialog(null, e.getMessage(), "Can't drop object", JOptionPane.ERROR_MESSAGE);
        }
        return retorno;
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP SEQUENCE ");
        retorno.append(getName()).append(";\n");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE SEQUENCE ");
        retorno.append(getName()).append(" ");
        
        if(getIncrementBy() > 1){
            retorno.append("\n\tINCREMENT ").append(getIncrementBy()).append(" ");
        }
        if(getMinValue() > 0){
            retorno.append("\n\tMINVALUE ").append(getMinValue()).append(" ");
        }
        if(getMaxValue() > 0){
            retorno.append("\n\tMAXVALUE ").append(getMaxValue()).append(" ");
        }
        if(getStart() > 0){
            retorno.append("\n\tSTART ").append(getStart()).append(" ");
        }
        if(getCacheValue() > 0){
            retorno.append("\n\tCACHE ").append(getCacheValue()).append(" ");
        }
        if(isCycled()){
            retorno.append("\n\tCYCLE ");
        }
        retorno.append(";\n");
        retorno.append(getCommentSQL());
        return retorno.toString();
    }
    
    /** Find the object asociated with the NAme.
     * @param _name name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            ResultSet rs = getConnection().getQueryGenerator().getSequence(_name);
            if((rs != null) && rs.next()){
                setName(rs.getString("sequence_name"));
                setCreator(new User(this, rs.getString("sequence_owner")));
                setLastValue(rs.getLong("last_value"));
                setIncrementBy(rs.getLong("increment_by"));
                setMaxValue(rs.getLong("max_value"));
                setMinValue(rs.getLong("min_value"));
                setCacheValue(rs.getLong("cache_value"));
                setCycled(rs.getBoolean("is_cycled"));
                setCalled(rs.getBoolean("is_called"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
            initialize();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        start = 0;
        last_value = 0;
        increment_by = 0;
        max_value = 0;
        min_value = 0;
        cache_value = 0;
        cycled = false;
        called = false;
        description = null;
    }
    
    // ------ SET AND GET --------
    public long getLastValue(){
        return last_value;
    }
    public long getIncrementBy(){
        return increment_by;
    }
    public long getMaxValue(){
        return max_value;
    }
    public long getMinValue(){
        return min_value;
    }
    public long getCacheValue(){
        return cache_value;
    }
    public boolean isCycled(){
        return cycled;
    }
    public boolean isCalled(){
        return called;
    }
    public String getDescription(){
        if(description == null){
            description = getConnection().getQueryGenerator().getTableDescription(getName());
        }
        return description;
    }
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    

// --- PRIVATE MOTHODS ---
    
    private void setLastValue(long _last_value){
        last_value = _last_value;
    }
    private void setIncrementBy(long _increment_by){
        increment_by = _increment_by;
    }
    private void setMaxValue(long _max_value){
        max_value = _max_value;
    }
    private void setMinValue(long _min_value){
        min_value = _min_value;
    }
    private void setCacheValue(long _cache_value){
        cache_value = _cache_value;
    }
    private void setCycled(boolean _cycled){
        cycled = _cycled;
    }
    private void setCalled(boolean _called){
        called = _called;
    }
    private long getStart(){
        return start;
    }
    private void setStart(long _start){
        start = _start;
    }
    private String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON SEQUENCE " + getName()
            + " IS '" + getDescription() + "'; \n";
        }
        return retorno;
    }
    private void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
}
