/*
 * View.java
 *
 * Created on 30 de julio de 2002, 18:17
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class View extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    private String description = null;
    
    public View(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    public View(DBObject owner) {
        super(owner);
    }
    
    /** Drops this view
     */
    public boolean Drop(){
        boolean retorno = false;
        try{
            retorno = getConnection().executeUpdate("DROP VIEW " + getName()) > 0;
        } catch (SQLException e){
            JOptionPane.showMessageDialog(null, e.getMessage(), "Can't drop object", JOptionPane.ERROR_MESSAGE);
        }
        return retorno;
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database. Used in script generation.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP VIEW ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE VIEW ").append(getName()).append(" AS ");
        retorno.append(definition);
        retorno.append(";\n");
        
        retorno.append(getCommentSQL());
        for(int i = 0;i >getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            retorno.append(tc.getCommentSQL());
        }
        return retorno.toString();
    }
    
    /** Find the object asociated with the Name.
     * @param _name name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            ResultSet rs = getConnection().getQueryGenerator().getView(_name);
            if((rs != null) && rs.next()){
                setName(rs.getString("view_name"));
                setCreator(new User(this, rs.getString("view_owner")));
                setDefinition(rs.getString("view_definition"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        definition = new String();
        columns = null;
        description = null;
    }
    
    // ------ SET AND GET --------
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                ResultSet rs = getConnection().getQueryGenerator().getColumnNames(getName());
                while((rs != null) && rs.next()){
                    columns.add(new TableColumn(this, rs.getString("column_name")));
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return columns;
    }
    public String getDescription(){
        if(description == null){
            description = getConnection().getQueryGenerator().getTableDescription(getName());
        }
        return description;
    }
    /** refresh the data from database.
     * if oid>0. Elsewere no action.
     */
    public void refresh() {
        search(getName());
    }
    
    // --------PRIVATE METHODS-------------
    private void setDefinition(String _definition){
        if(_definition != null){
            _definition = Utilities.replaceAll(_definition, "SELECT", "\n\tSELECT");
            _definition = Utilities.replaceAll(_definition, "FROM", "\n\tFROM");
            _definition = Utilities.replaceAll(_definition, "WHERE", "\n\tWHERE");
            _definition = Utilities.replaceAll(_definition, "ORDER", "\n\tORDER");
            _definition = Utilities.replaceAll(_definition, "UNION", "\nUNION");
            
            definition = _definition;
        } else {
            definition = new String();
        }
    }
    private String getDefinition(){
        return definition;
    }
    
    /** Retrieve the SQL DML statement for comments
     */
    private String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON VIEW " + getName()
            + " IS '" + getDescription() + "'; \n";
        }
        return retorno;
    }
    
    private void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
}

