/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbbasemanager.h"

	/**
 	 * Constructor
	 */
  DBBaseManager::DBBaseManager()
  {
  	m_poDBConn = 0;
  } // end constructor
	
	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBBaseManager::DBBaseManager(DBConnection *poDBConn)
  {
  	m_poDBConn = poDBConn;
  } // end constructor
	
	/**
 	 * Destructor
   */		
	DBBaseManager::~DBBaseManager()
	{
		// do nothing
	} // end destructor

	/**
	 * Used to set the database connection object
	 * @param poDBConn
	 */
	void DBBaseManager::setDBConnection(DBConnection * poDBConn)
	{
		m_poDBConn = poDBConn;
	} // end setDBConnection

	/**
	 * Used to get the database connection object
	 */
	DBConnection * DBBaseManager::getDBConnection()
	{
		return m_poDBConn;
	} // end getDBConnection
