/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTYPEMANAGER_H
#define DBTYPEMANAGER_H

#include <string>
#include "../../exceptions/sqlexception.h"
#include "dbtype.h"
#include "dbtypeset.h"
#include "../dbconnection.h"
#include "../dbbasemanager.h"
#include "../../utils/equalobjects.h"
#include <hash_map>

/**
 * This class is used to manage operations concerning database types. The class
 * provides many generic functions that can be used to retrieve database types.
 */
class DBTypeManager : public DBBaseManager
{
protected:
	/**
	 * This hash table is used to cache database types. This is intended to save on
	 * database reads. The key for this hash is the type oid. Once a type is retrieved
	 * from the database it will persist in the cache until the program is exited.
	 */
	hash_map<long, DBType, hash<long>, EqualLong> m_oDBTypeCache;
		
public:

	/**
 	 * Constructor
   */		
  DBTypeManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBTypeManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBTypeManager();
			
	/**
	 * Used to retrieve the list of types based on the type oids passed in. The type
	 * oids are passed in via the DBType objects held in the vector.
	 * @param			rvoDBTypes (contains a vector of DBType objects)
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfTypes(vector<DBType> & rvoDBTypes) throw (SQLException, DBConnectionException);

};

#endif

