/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbview.h"
	
	/**
 	 * Constructor
   */		
	DBView::DBView()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBView::~DBView()
	{
	} // end destructor
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBView::clear()
	{
		m_strViewName = "";
		m_strViewComment = "";
		m_strViewOwner = "";
		m_strDefinition = "";					
	} // end clear
	
	/**
 	 * Used to set the view name.
   */			    	
	void DBView::setViewName(const string &rstrViewName)
	{
		m_strViewName = rstrViewName;
	} // end setViewName

	/**
 	 * Used to retrieve the view name.
   */			    			
	const string & DBView::getViewName() const
	{
		return m_strViewName;
	} // end getViewName

	/**
 	 * Used to set the view comment.
   */			    						
	void DBView::setViewComment(const string &rstrViewComment)
	{
		m_strViewComment = rstrViewComment;
	} // end setViewComment

	/**
 	 * Used to retrieve the view comment.
   */			    			
	const string & DBView::getViewComment() const
	{
		return m_strViewComment;
	} // end getViewComment			

	/**
 	 * Used to set the view owner.
   */			    						
	void DBView::setViewOwner(const string &rstrViewOwner)
	{
		m_strViewOwner = rstrViewOwner;
	} // end setViewOwner

	/**
 	 * Used to retrieve the view owner.
   */			    			
	const string & DBView::getViewOwner() const
	{
		return m_strViewOwner;
	} // end getViewOwner			

	/**
 	 * Used to set the view definition.
   */			    						
	void DBView::setDefinition(const string &rstrDefinition)
	{
		m_strDefinition = rstrDefinition;
	} // end setDefinition

	/**
 	 * Used to retrieve the view definition.
   */			    			
	const string & DBView::getDefinition() const
	{
		return m_strDefinition;
	} // end getDefinition			
