/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBVIEW_H
#define DBVIEW_H

#include <string>

/**
 * This class is used to represent a database view.
 */
class DBView
{

protected:
	string m_strViewName;
	string m_strViewComment;
	string m_strViewOwner;
	string m_strDefinition;
				
public:
	
	/**
 	 * Constructor
   */		
	DBView();
	
	/**
 	 * Destructor
   */		
	~DBView();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to set the view name.
   */			    	
	void setViewName(const string &rstrViewName);

	/**
 	 * Used to retrieve the view name.
   */			    			
	const string & getViewName() const;

	/**
 	 * Used to set the view comment.
   */			    						
	void setViewComment(const string &rstrViewComment);

	/**
 	 * Used to retrieve the view comment.
   */			    			
	const string & getViewComment() const;			

	/**
 	 * Used to set the view owner.
   */			    						
	void setViewOwner(const string &rstrViewOwner);

	/**
 	 * Used to retrieve the view owner.
   */			    			
	const string & getViewOwner() const;			

	/**
 	 * Used to set the view definition.
   */			    						
	void setDefinition(const string &rstrDefinition);

	/**
 	 * Used to retrieve the view definition.
   */			    			
	const string & getDefinition() const;			
		
};

#endif

