/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "commentform.h"
#include "../mainlistview.h"
#include "../tables/tableitempopup.h"
#include "../tables/tablelistviewitem.h"
#include "../views/viewitempopup.h"
#include "../views/viewlistviewitem.h"
#include "../sequences/sequenceitempopup.h"
#include "../sequences/sequencelistviewitem.h"
#include "../functions/functionitempopup.h"
#include "../functions/functionlistviewitem.h"
#include "../tables/triggers/triggeritempopup.h"
#include "../tables/triggers/triggerlistviewitem.h"
#include "../tables/indicies/indexitempopup.h"
#include "../tables/indicies/indexlistviewitem.h"
#include <qmultilineedit.h>
				
	/**
 	 * Constructor
   */		
  CommentForm::CommentForm(QWidget* pqoParent, const DBConnection & roDBConn, CommentType enumCommentType)
  	: UicCommentForm(pqoParent)
  {
  	m_oDBConn = roDBConn;	// copies all connection properties
  	m_oDBMasterMgr.setDBConnection(&m_oDBConn);
		m_enumCommentType = enumCommentType;
  } // end constructor

  /**
   * This method is used to set the comment to be displayed.
   */
  void CommentForm::setComment(const QString & rqstrComment)
  {
  	m_pqtxtEditComment->setText(rqstrComment);
  } // end setComment

  /**
   * This method is used to set the object name.
   */
  void CommentForm::setObjectName(const string & rstrObjectName)
  {
  	m_strObjectName = rstrObjectName;
    setCaption(QString("View/Edit Comment :: ") + rstrObjectName.c_str());  	
  } // end setObjectName

	/**
	 * This method is used to save the comment to the database.
	 */
	void CommentForm::saveComment()
	{
  	// setup new database connection
		// do connection
		try
		{
			m_oDBConn.connect();
		} // end try to connect
		catch (DBConnectionException e)
		{
			// recover?
		} // end catch exception
		
		BaseListViewItem * poListViewItem = 0;
		
		if (m_enumCommentType == TableComment)
		{				
			// update comment
			(m_oDBMasterMgr.getDBTableManager())->modifyTableComment(m_strObjectName, (m_pqtxtEditComment->text()).latin1()); 			
			TableItemPopup* poPopup = (TableItemPopup*)parentWidget();
			poListViewItem = poPopup->getTableListViewItem();
			((TableListViewItem*)poListViewItem)->setTableComment((m_pqtxtEditComment->text()).latin1());
		} // end if table comment
		else if (m_enumCommentType == ViewComment)
		{				
			// update comment
			(m_oDBMasterMgr.getDBViewManager())->modifyViewComment(m_strObjectName, (m_pqtxtEditComment->text()).latin1()); 			
			ViewItemPopup* poPopup = (ViewItemPopup*)parentWidget();
			poListViewItem = poPopup->getViewListViewItem();
			((ViewListViewItem*)poListViewItem)->setViewComment((m_pqtxtEditComment->text()).latin1());
		} // end if view comment
		else if (m_enumCommentType == SequenceComment)
		{				
			// update comment
			(m_oDBMasterMgr.getDBSequenceManager())->modifySequenceComment(m_strObjectName, (m_pqtxtEditComment->text()).latin1()); 			
			SequenceItemPopup* poPopup = (SequenceItemPopup*)parentWidget();
			poListViewItem = poPopup->getSequenceListViewItem();
			((SequenceListViewItem*)poListViewItem)->setSequenceComment((m_pqtxtEditComment->text()).latin1());
		} // end if view comment
		else if (m_enumCommentType == FunctionComment)
		{				
			// update comment
			FunctionItemPopup* poPopup = (FunctionItemPopup*)parentWidget();
			poListViewItem = poPopup->getFunctionListViewItem();			
			(m_oDBMasterMgr.getDBFunctionManager())->modifyFunctionComment(m_strObjectName, ((FunctionListViewItem*)poListViewItem)->getArgumentTypes(), (m_pqtxtEditComment->text()).latin1()); 			
			((FunctionListViewItem*)poListViewItem)->setFunctionComment((m_pqtxtEditComment->text()).latin1());
		} // end if view comment
		else if (m_enumCommentType == TriggerComment)
		{				
			// update comment
			TriggerItemPopup* poPopup = (TriggerItemPopup*)parentWidget();
			poListViewItem = poPopup->getTriggerListViewItem();			
			(m_oDBMasterMgr.getDBTriggerManager())->modifyTriggerComment(m_strObjectName, ((TriggerListViewItem*)poListViewItem)->getTableName(), (m_pqtxtEditComment->text()).latin1()); 			
			((TriggerListViewItem*)poListViewItem)->setTriggerComment((m_pqtxtEditComment->text()).latin1());
		} // end if view comment
		else if (m_enumCommentType == IndexComment)
		{				
			// update comment
			IndexItemPopup* poPopup = (IndexItemPopup*)parentWidget();
			poListViewItem = poPopup->getIndexListViewItem();			
			(m_oDBMasterMgr.getDBIndexManager())->modifyIndexComment(m_strObjectName, (m_pqtxtEditComment->text()).latin1()); 			
			((IndexListViewItem*)poListViewItem)->setIndexComment((m_pqtxtEditComment->text()).latin1());
		} // end if view comment
		
		if (poListViewItem != 0)
		{
			// lets update the description of the list view item
			poListViewItem->updateDescription();
			// lets signal to change the description
			((MainListView*)(poListViewItem->listView()))->changeItemDescription(poListViewItem);
		} // end if list view item exists
		
		// set as OK and close window
		accept();
	} // end saveComment	
	 	

